goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e30637){var e = e30637;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30823 = arguments.length;
var i__4737__auto___30824 = (0);
while(true){
if((i__4737__auto___30824 < len__4736__auto___30823)){
args__4742__auto__.push((arguments[i__4737__auto___30824]));

var G__30825 = (i__4737__auto___30824 + (1));
i__4737__auto___30824 = G__30825;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__30652){
var vec__30654 = p__30652;
var map__30657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30654,(0),null);
var map__30657__$1 = (((((!((map__30657 == null))))?(((((map__30657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30657):map__30657);
var opts = map__30657__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30657__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30657__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30657__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30657__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__30659 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__30659__$1 = (((((!((map__30659 == null))))?(((((map__30659.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30659.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30659):map__30659);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30659__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30659__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__30641_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__30641_SHARP_);
}));

(web_socket.onclose = (function (p1__30642_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__30642_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28279__auto___30835 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_30738){
var state_val_30739 = (state_30738[(1)]);
if((state_val_30739 === (7))){
var inst_30730 = (state_30738[(2)]);
var state_30738__$1 = state_30738;
var statearr_30746_30838 = state_30738__$1;
(statearr_30746_30838[(2)] = inst_30730);

(statearr_30746_30838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (20))){
var state_30738__$1 = state_30738;
var statearr_30748_30840 = state_30738__$1;
(statearr_30748_30840[(2)] = null);

(statearr_30748_30840[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (1))){
var inst_30663 = false;
var state_30738__$1 = (function (){var statearr_30750 = state_30738;
(statearr_30750[(7)] = inst_30663);

return statearr_30750;
})();
var statearr_30751_30843 = state_30738__$1;
(statearr_30751_30843[(2)] = null);

(statearr_30751_30843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (4))){
var inst_30682 = (state_30738[(8)]);
var inst_30680 = (state_30738[(9)]);
var inst_30680__$1 = (state_30738[(2)]);
var inst_30681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30680__$1,(0),null);
var inst_30682__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30680__$1,(1),null);
var inst_30683 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30682__$1,open_ch);
var state_30738__$1 = (function (){var statearr_30754 = state_30738;
(statearr_30754[(8)] = inst_30682__$1);

(statearr_30754[(10)] = inst_30681);

(statearr_30754[(9)] = inst_30680__$1);

return statearr_30754;
})();
if(inst_30683){
var statearr_30755_30846 = state_30738__$1;
(statearr_30755_30846[(1)] = (5));

} else {
var statearr_30756_30848 = state_30738__$1;
(statearr_30756_30848[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (15))){
var inst_30715 = (state_30738[(2)]);
var state_30738__$1 = state_30738;
var statearr_30757_30849 = state_30738__$1;
(statearr_30757_30849[(2)] = inst_30715);

(statearr_30757_30849[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (21))){
var inst_30726 = (state_30738[(2)]);
var state_30738__$1 = state_30738;
var statearr_30758_30851 = state_30738__$1;
(statearr_30758_30851[(2)] = inst_30726);

(statearr_30758_30851[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (13))){
var state_30738__$1 = state_30738;
var statearr_30760_30853 = state_30738__$1;
(statearr_30760_30853[(2)] = null);

(statearr_30760_30853[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (6))){
var inst_30682 = (state_30738[(8)]);
var inst_30698 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30682,close_ch);
var state_30738__$1 = state_30738;
if(inst_30698){
var statearr_30763_30857 = state_30738__$1;
(statearr_30763_30857[(1)] = (9));

} else {
var statearr_30765_30858 = state_30738__$1;
(statearr_30765_30858[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (17))){
var state_30738__$1 = state_30738;
var statearr_30766_30861 = state_30738__$1;
(statearr_30766_30861[(2)] = initial_ch);

(statearr_30766_30861[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (3))){
var inst_30733 = (state_30738[(2)]);
var state_30738__$1 = state_30738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30738__$1,inst_30733);
} else {
if((state_val_30739 === (12))){
var inst_30663 = (state_30738[(7)]);
var state_30738__$1 = state_30738;
if(cljs.core.truth_(inst_30663)){
var statearr_30769_30864 = state_30738__$1;
(statearr_30769_30864[(1)] = (16));

} else {
var statearr_30770_30865 = state_30738__$1;
(statearr_30770_30865[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (2))){
var inst_30675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30677 = [open_ch,close_ch];
var inst_30678 = (new cljs.core.PersistentVector(null,2,(5),inst_30675,inst_30677,null));
var state_30738__$1 = state_30738;
return cljs.core.async.ioc_alts_BANG_(state_30738__$1,(4),inst_30678);
} else {
if((state_val_30739 === (19))){
var inst_30681 = (state_30738[(10)]);
var state_30738__$1 = state_30738;
var statearr_30774_30869 = state_30738__$1;
(statearr_30774_30869[(2)] = inst_30681);

(statearr_30774_30869[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (11))){
var inst_30728 = (state_30738[(2)]);
var state_30738__$1 = state_30738;
var statearr_30776_30873 = state_30738__$1;
(statearr_30776_30873[(2)] = inst_30728);

(statearr_30776_30873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (9))){
var inst_30680 = (state_30738[(9)]);
var inst_30705 = (state_30738[(11)]);
var inst_30704 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30680,(0),null);
var inst_30705__$1 = chord.client.close_event__GT_maybe_error(inst_30704);
var state_30738__$1 = (function (){var statearr_30780 = state_30738;
(statearr_30780[(11)] = inst_30705__$1);

return statearr_30780;
})();
if(cljs.core.truth_(inst_30705__$1)){
var statearr_30781_30875 = state_30738__$1;
(statearr_30781_30875[(1)] = (12));

} else {
var statearr_30782_30877 = state_30738__$1;
(statearr_30782_30877[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (5))){
var inst_30680 = (state_30738[(9)]);
var inst_30688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30680,(0),null);
var inst_30689 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_30690 = [ws_chan];
var inst_30691 = cljs.core.PersistentHashMap.fromArrays(inst_30689,inst_30690);
var state_30738__$1 = (function (){var statearr_30789 = state_30738;
(statearr_30789[(12)] = inst_30688);

return statearr_30789;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30738__$1,(8),initial_ch,inst_30691);
} else {
if((state_val_30739 === (14))){
var inst_30718 = (state_30738[(2)]);
var inst_30719 = cljs.core.async.close_BANG_(ws_chan);
var inst_30720 = cljs.core.async.close_BANG_(initial_ch);
var state_30738__$1 = (function (){var statearr_30790 = state_30738;
(statearr_30790[(13)] = inst_30718);

(statearr_30790[(14)] = inst_30719);

return statearr_30790;
})();
var statearr_30792_30883 = state_30738__$1;
(statearr_30792_30883[(2)] = inst_30720);

(statearr_30792_30883[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (16))){
var state_30738__$1 = state_30738;
var statearr_30794_30884 = state_30738__$1;
(statearr_30794_30884[(2)] = read_ch__$1);

(statearr_30794_30884[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (10))){
var inst_30682 = (state_30738[(8)]);
var inst_30722 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30682,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_30738__$1 = state_30738;
if(inst_30722){
var statearr_30795_30887 = state_30738__$1;
(statearr_30795_30887[(1)] = (19));

} else {
var statearr_30796_30888 = state_30738__$1;
(statearr_30796_30888[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30739 === (18))){
var inst_30705 = (state_30738[(11)]);
var inst_30710 = (state_30738[(2)]);
var inst_30711 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30712 = [inst_30705];
var inst_30713 = cljs.core.PersistentHashMap.fromArrays(inst_30711,inst_30712);
var state_30738__$1 = state_30738;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30738__$1,(15),inst_30710,inst_30713);
} else {
if((state_val_30739 === (8))){
var inst_30693 = (state_30738[(2)]);
var inst_30695 = cljs.core.async.close_BANG_(initial_ch);
var inst_30663 = true;
var state_30738__$1 = (function (){var statearr_30800 = state_30738;
(statearr_30800[(7)] = inst_30663);

(statearr_30800[(15)] = inst_30693);

(statearr_30800[(16)] = inst_30695);

return statearr_30800;
})();
var statearr_30801_30894 = state_30738__$1;
(statearr_30801_30894[(2)] = null);

(statearr_30801_30894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28138__auto__ = null;
var chord$client$state_machine__28138__auto____0 = (function (){
var statearr_30804 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30804[(0)] = chord$client$state_machine__28138__auto__);

(statearr_30804[(1)] = (1));

return statearr_30804;
});
var chord$client$state_machine__28138__auto____1 = (function (state_30738){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30738);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30809){if((e30809 instanceof Object)){
var ex__28141__auto__ = e30809;
var statearr_30810_30899 = state_30738;
(statearr_30810_30899[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30738);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30809;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30903 = state_30738;
state_30738 = G__30903;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
chord$client$state_machine__28138__auto__ = function(state_30738){
switch(arguments.length){
case 0:
return chord$client$state_machine__28138__auto____0.call(this);
case 1:
return chord$client$state_machine__28138__auto____1.call(this,state_30738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28138__auto____0;
chord$client$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28138__auto____1;
return chord$client$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30813 = f__28280__auto__();
(statearr_30813[(6)] = c__28279__auto___30835);

return statearr_30813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq30644){
var G__30645 = cljs.core.first(seq30644);
var seq30644__$1 = cljs.core.next(seq30644);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30645,seq30644__$1);
}));


//# sourceMappingURL=chord.client.js.map
