goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_46561 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_46561(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_46569 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_46569(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__45690 = coll;
var G__45691 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__45690,G__45691) : shadow.dom.lazy_native_coll_seq.call(null,G__45690,G__45691));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__45700 = arguments.length;
switch (G__45700) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__45705 = arguments.length;
switch (G__45705) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__45708 = arguments.length;
switch (G__45708) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__45716 = arguments.length;
switch (G__45716) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__45726 = arguments.length;
switch (G__45726) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__45744 = arguments.length;
switch (G__45744) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e45747){if((e45747 instanceof Object)){
var e = e45747;
return console.log("didnt support attachEvent",el,e);
} else {
throw e45747;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__45766 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__45767 = null;
var count__45768 = (0);
var i__45769 = (0);
while(true){
if((i__45769 < count__45768)){
var el = chunk__45767.cljs$core$IIndexed$_nth$arity$2(null,i__45769);
var handler_46636__$1 = ((function (seq__45766,chunk__45767,count__45768,i__45769,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__45766,chunk__45767,count__45768,i__45769,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_46636__$1);


var G__46639 = seq__45766;
var G__46640 = chunk__45767;
var G__46641 = count__45768;
var G__46642 = (i__45769 + (1));
seq__45766 = G__46639;
chunk__45767 = G__46640;
count__45768 = G__46641;
i__45769 = G__46642;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45766);
if(temp__5720__auto__){
var seq__45766__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45766__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45766__$1);
var G__46645 = cljs.core.chunk_rest(seq__45766__$1);
var G__46646 = c__4556__auto__;
var G__46647 = cljs.core.count(c__4556__auto__);
var G__46648 = (0);
seq__45766 = G__46645;
chunk__45767 = G__46646;
count__45768 = G__46647;
i__45769 = G__46648;
continue;
} else {
var el = cljs.core.first(seq__45766__$1);
var handler_46650__$1 = ((function (seq__45766,chunk__45767,count__45768,i__45769,el,seq__45766__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__45766,chunk__45767,count__45768,i__45769,el,seq__45766__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_46650__$1);


var G__46655 = cljs.core.next(seq__45766__$1);
var G__46656 = null;
var G__46657 = (0);
var G__46658 = (0);
seq__45766 = G__46655;
chunk__45767 = G__46656;
count__45768 = G__46657;
i__45769 = G__46658;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__45787 = arguments.length;
switch (G__45787) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__45799 = cljs.core.seq(events);
var chunk__45800 = null;
var count__45801 = (0);
var i__45802 = (0);
while(true){
if((i__45802 < count__45801)){
var vec__45829 = chunk__45800.cljs$core$IIndexed$_nth$arity$2(null,i__45802);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45829,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45829,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__46685 = seq__45799;
var G__46686 = chunk__45800;
var G__46687 = count__45801;
var G__46688 = (i__45802 + (1));
seq__45799 = G__46685;
chunk__45800 = G__46686;
count__45801 = G__46687;
i__45802 = G__46688;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45799);
if(temp__5720__auto__){
var seq__45799__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45799__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45799__$1);
var G__46690 = cljs.core.chunk_rest(seq__45799__$1);
var G__46691 = c__4556__auto__;
var G__46692 = cljs.core.count(c__4556__auto__);
var G__46693 = (0);
seq__45799 = G__46690;
chunk__45800 = G__46691;
count__45801 = G__46692;
i__45802 = G__46693;
continue;
} else {
var vec__45832 = cljs.core.first(seq__45799__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45832,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45832,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__46696 = cljs.core.next(seq__45799__$1);
var G__46697 = null;
var G__46698 = (0);
var G__46699 = (0);
seq__45799 = G__46696;
chunk__45800 = G__46697;
count__45801 = G__46698;
i__45802 = G__46699;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__45837 = cljs.core.seq(styles);
var chunk__45838 = null;
var count__45839 = (0);
var i__45840 = (0);
while(true){
if((i__45840 < count__45839)){
var vec__45855 = chunk__45838.cljs$core$IIndexed$_nth$arity$2(null,i__45840);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45855,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45855,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__46705 = seq__45837;
var G__46706 = chunk__45838;
var G__46707 = count__45839;
var G__46708 = (i__45840 + (1));
seq__45837 = G__46705;
chunk__45838 = G__46706;
count__45839 = G__46707;
i__45840 = G__46708;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45837);
if(temp__5720__auto__){
var seq__45837__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45837__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45837__$1);
var G__46713 = cljs.core.chunk_rest(seq__45837__$1);
var G__46714 = c__4556__auto__;
var G__46715 = cljs.core.count(c__4556__auto__);
var G__46716 = (0);
seq__45837 = G__46713;
chunk__45838 = G__46714;
count__45839 = G__46715;
i__45840 = G__46716;
continue;
} else {
var vec__45861 = cljs.core.first(seq__45837__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45861,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45861,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__46719 = cljs.core.next(seq__45837__$1);
var G__46720 = null;
var G__46721 = (0);
var G__46722 = (0);
seq__45837 = G__46719;
chunk__45838 = G__46720;
count__45839 = G__46721;
i__45840 = G__46722;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__45867_46727 = key;
var G__45867_46728__$1 = (((G__45867_46727 instanceof cljs.core.Keyword))?G__45867_46727.fqn:null);
switch (G__45867_46728__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_46738 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_46738,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_46738,"aria-");
}
})())){
el.setAttribute(ks_46738,value);
} else {
(el[ks_46738] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__45887){
var map__45888 = p__45887;
var map__45888__$1 = (((((!((map__45888 == null))))?(((((map__45888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45888.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45888):map__45888);
var props = map__45888__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45888__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__45890 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45890,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45890,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45890,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__45894 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__45894,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__45894;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__45896 = arguments.length;
switch (G__45896) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__45906){
var vec__45907 = p__45906;
var seq__45908 = cljs.core.seq(vec__45907);
var first__45909 = cljs.core.first(seq__45908);
var seq__45908__$1 = cljs.core.next(seq__45908);
var nn = first__45909;
var first__45909__$1 = cljs.core.first(seq__45908__$1);
var seq__45908__$2 = cljs.core.next(seq__45908__$1);
var np = first__45909__$1;
var nc = seq__45908__$2;
var node = vec__45907;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__45918 = nn;
var G__45919 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__45918,G__45919) : create_fn.call(null,G__45918,G__45919));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__45925 = nn;
var G__45926 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__45925,G__45926) : create_fn.call(null,G__45925,G__45926));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__45949 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45949,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45949,(1),null);
var seq__45952_46779 = cljs.core.seq(node_children);
var chunk__45953_46780 = null;
var count__45954_46781 = (0);
var i__45955_46782 = (0);
while(true){
if((i__45955_46782 < count__45954_46781)){
var child_struct_46783 = chunk__45953_46780.cljs$core$IIndexed$_nth$arity$2(null,i__45955_46782);
var children_46786 = shadow.dom.dom_node(child_struct_46783);
if(cljs.core.seq_QMARK_(children_46786)){
var seq__45992_46787 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_46786));
var chunk__45994_46788 = null;
var count__45995_46789 = (0);
var i__45996_46790 = (0);
while(true){
if((i__45996_46790 < count__45995_46789)){
var child_46792 = chunk__45994_46788.cljs$core$IIndexed$_nth$arity$2(null,i__45996_46790);
if(cljs.core.truth_(child_46792)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46792);


var G__46796 = seq__45992_46787;
var G__46797 = chunk__45994_46788;
var G__46798 = count__45995_46789;
var G__46799 = (i__45996_46790 + (1));
seq__45992_46787 = G__46796;
chunk__45994_46788 = G__46797;
count__45995_46789 = G__46798;
i__45996_46790 = G__46799;
continue;
} else {
var G__46801 = seq__45992_46787;
var G__46802 = chunk__45994_46788;
var G__46803 = count__45995_46789;
var G__46804 = (i__45996_46790 + (1));
seq__45992_46787 = G__46801;
chunk__45994_46788 = G__46802;
count__45995_46789 = G__46803;
i__45996_46790 = G__46804;
continue;
}
} else {
var temp__5720__auto___46806 = cljs.core.seq(seq__45992_46787);
if(temp__5720__auto___46806){
var seq__45992_46807__$1 = temp__5720__auto___46806;
if(cljs.core.chunked_seq_QMARK_(seq__45992_46807__$1)){
var c__4556__auto___46809 = cljs.core.chunk_first(seq__45992_46807__$1);
var G__46810 = cljs.core.chunk_rest(seq__45992_46807__$1);
var G__46811 = c__4556__auto___46809;
var G__46812 = cljs.core.count(c__4556__auto___46809);
var G__46813 = (0);
seq__45992_46787 = G__46810;
chunk__45994_46788 = G__46811;
count__45995_46789 = G__46812;
i__45996_46790 = G__46813;
continue;
} else {
var child_46815 = cljs.core.first(seq__45992_46807__$1);
if(cljs.core.truth_(child_46815)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46815);


var G__46817 = cljs.core.next(seq__45992_46807__$1);
var G__46818 = null;
var G__46819 = (0);
var G__46820 = (0);
seq__45992_46787 = G__46817;
chunk__45994_46788 = G__46818;
count__45995_46789 = G__46819;
i__45996_46790 = G__46820;
continue;
} else {
var G__46822 = cljs.core.next(seq__45992_46807__$1);
var G__46823 = null;
var G__46824 = (0);
var G__46825 = (0);
seq__45992_46787 = G__46822;
chunk__45994_46788 = G__46823;
count__45995_46789 = G__46824;
i__45996_46790 = G__46825;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_46786);
}


var G__46827 = seq__45952_46779;
var G__46828 = chunk__45953_46780;
var G__46829 = count__45954_46781;
var G__46830 = (i__45955_46782 + (1));
seq__45952_46779 = G__46827;
chunk__45953_46780 = G__46828;
count__45954_46781 = G__46829;
i__45955_46782 = G__46830;
continue;
} else {
var temp__5720__auto___46831 = cljs.core.seq(seq__45952_46779);
if(temp__5720__auto___46831){
var seq__45952_46835__$1 = temp__5720__auto___46831;
if(cljs.core.chunked_seq_QMARK_(seq__45952_46835__$1)){
var c__4556__auto___46837 = cljs.core.chunk_first(seq__45952_46835__$1);
var G__46839 = cljs.core.chunk_rest(seq__45952_46835__$1);
var G__46840 = c__4556__auto___46837;
var G__46841 = cljs.core.count(c__4556__auto___46837);
var G__46842 = (0);
seq__45952_46779 = G__46839;
chunk__45953_46780 = G__46840;
count__45954_46781 = G__46841;
i__45955_46782 = G__46842;
continue;
} else {
var child_struct_46846 = cljs.core.first(seq__45952_46835__$1);
var children_46847 = shadow.dom.dom_node(child_struct_46846);
if(cljs.core.seq_QMARK_(children_46847)){
var seq__46007_46848 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_46847));
var chunk__46009_46849 = null;
var count__46010_46850 = (0);
var i__46011_46851 = (0);
while(true){
if((i__46011_46851 < count__46010_46850)){
var child_46858 = chunk__46009_46849.cljs$core$IIndexed$_nth$arity$2(null,i__46011_46851);
if(cljs.core.truth_(child_46858)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46858);


var G__46859 = seq__46007_46848;
var G__46860 = chunk__46009_46849;
var G__46861 = count__46010_46850;
var G__46862 = (i__46011_46851 + (1));
seq__46007_46848 = G__46859;
chunk__46009_46849 = G__46860;
count__46010_46850 = G__46861;
i__46011_46851 = G__46862;
continue;
} else {
var G__46865 = seq__46007_46848;
var G__46866 = chunk__46009_46849;
var G__46867 = count__46010_46850;
var G__46868 = (i__46011_46851 + (1));
seq__46007_46848 = G__46865;
chunk__46009_46849 = G__46866;
count__46010_46850 = G__46867;
i__46011_46851 = G__46868;
continue;
}
} else {
var temp__5720__auto___46869__$1 = cljs.core.seq(seq__46007_46848);
if(temp__5720__auto___46869__$1){
var seq__46007_46871__$1 = temp__5720__auto___46869__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46007_46871__$1)){
var c__4556__auto___46872 = cljs.core.chunk_first(seq__46007_46871__$1);
var G__46875 = cljs.core.chunk_rest(seq__46007_46871__$1);
var G__46876 = c__4556__auto___46872;
var G__46877 = cljs.core.count(c__4556__auto___46872);
var G__46878 = (0);
seq__46007_46848 = G__46875;
chunk__46009_46849 = G__46876;
count__46010_46850 = G__46877;
i__46011_46851 = G__46878;
continue;
} else {
var child_46880 = cljs.core.first(seq__46007_46871__$1);
if(cljs.core.truth_(child_46880)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46880);


var G__46881 = cljs.core.next(seq__46007_46871__$1);
var G__46882 = null;
var G__46883 = (0);
var G__46884 = (0);
seq__46007_46848 = G__46881;
chunk__46009_46849 = G__46882;
count__46010_46850 = G__46883;
i__46011_46851 = G__46884;
continue;
} else {
var G__46886 = cljs.core.next(seq__46007_46871__$1);
var G__46887 = null;
var G__46888 = (0);
var G__46889 = (0);
seq__46007_46848 = G__46886;
chunk__46009_46849 = G__46887;
count__46010_46850 = G__46888;
i__46011_46851 = G__46889;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_46847);
}


var G__46890 = cljs.core.next(seq__45952_46835__$1);
var G__46891 = null;
var G__46892 = (0);
var G__46893 = (0);
seq__45952_46779 = G__46890;
chunk__45953_46780 = G__46891;
count__45954_46781 = G__46892;
i__45955_46782 = G__46893;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46038 = cljs.core.seq(node);
var chunk__46039 = null;
var count__46040 = (0);
var i__46041 = (0);
while(true){
if((i__46041 < count__46040)){
var n = chunk__46039.cljs$core$IIndexed$_nth$arity$2(null,i__46041);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__46901 = seq__46038;
var G__46902 = chunk__46039;
var G__46903 = count__46040;
var G__46904 = (i__46041 + (1));
seq__46038 = G__46901;
chunk__46039 = G__46902;
count__46040 = G__46903;
i__46041 = G__46904;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46038);
if(temp__5720__auto__){
var seq__46038__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46038__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46038__$1);
var G__46905 = cljs.core.chunk_rest(seq__46038__$1);
var G__46906 = c__4556__auto__;
var G__46907 = cljs.core.count(c__4556__auto__);
var G__46908 = (0);
seq__46038 = G__46905;
chunk__46039 = G__46906;
count__46040 = G__46907;
i__46041 = G__46908;
continue;
} else {
var n = cljs.core.first(seq__46038__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__46910 = cljs.core.next(seq__46038__$1);
var G__46911 = null;
var G__46912 = (0);
var G__46913 = (0);
seq__46038 = G__46910;
chunk__46039 = G__46911;
count__46040 = G__46912;
i__46041 = G__46913;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46057 = arguments.length;
switch (G__46057) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46071 = arguments.length;
switch (G__46071) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46078 = arguments.length;
switch (G__46078) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46932 = arguments.length;
var i__4737__auto___46933 = (0);
while(true){
if((i__4737__auto___46933 < len__4736__auto___46932)){
args__4742__auto__.push((arguments[i__4737__auto___46933]));

var G__46934 = (i__4737__auto___46933 + (1));
i__4737__auto___46933 = G__46934;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46099_46935 = cljs.core.seq(nodes);
var chunk__46100_46936 = null;
var count__46101_46937 = (0);
var i__46102_46938 = (0);
while(true){
if((i__46102_46938 < count__46101_46937)){
var node_46943 = chunk__46100_46936.cljs$core$IIndexed$_nth$arity$2(null,i__46102_46938);
fragment.appendChild(shadow.dom._to_dom(node_46943));


var G__46946 = seq__46099_46935;
var G__46947 = chunk__46100_46936;
var G__46948 = count__46101_46937;
var G__46949 = (i__46102_46938 + (1));
seq__46099_46935 = G__46946;
chunk__46100_46936 = G__46947;
count__46101_46937 = G__46948;
i__46102_46938 = G__46949;
continue;
} else {
var temp__5720__auto___46954 = cljs.core.seq(seq__46099_46935);
if(temp__5720__auto___46954){
var seq__46099_46957__$1 = temp__5720__auto___46954;
if(cljs.core.chunked_seq_QMARK_(seq__46099_46957__$1)){
var c__4556__auto___46958 = cljs.core.chunk_first(seq__46099_46957__$1);
var G__46959 = cljs.core.chunk_rest(seq__46099_46957__$1);
var G__46960 = c__4556__auto___46958;
var G__46961 = cljs.core.count(c__4556__auto___46958);
var G__46962 = (0);
seq__46099_46935 = G__46959;
chunk__46100_46936 = G__46960;
count__46101_46937 = G__46961;
i__46102_46938 = G__46962;
continue;
} else {
var node_46965 = cljs.core.first(seq__46099_46957__$1);
fragment.appendChild(shadow.dom._to_dom(node_46965));


var G__46966 = cljs.core.next(seq__46099_46957__$1);
var G__46967 = null;
var G__46968 = (0);
var G__46969 = (0);
seq__46099_46935 = G__46966;
chunk__46100_46936 = G__46967;
count__46101_46937 = G__46968;
i__46102_46938 = G__46969;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46097){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46097));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46115_46975 = cljs.core.seq(scripts);
var chunk__46116_46976 = null;
var count__46117_46977 = (0);
var i__46118_46978 = (0);
while(true){
if((i__46118_46978 < count__46117_46977)){
var vec__46130_46980 = chunk__46116_46976.cljs$core$IIndexed$_nth$arity$2(null,i__46118_46978);
var script_tag_46981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46130_46980,(0),null);
var script_body_46982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46130_46980,(1),null);
eval(script_body_46982);


var G__46984 = seq__46115_46975;
var G__46985 = chunk__46116_46976;
var G__46986 = count__46117_46977;
var G__46987 = (i__46118_46978 + (1));
seq__46115_46975 = G__46984;
chunk__46116_46976 = G__46985;
count__46117_46977 = G__46986;
i__46118_46978 = G__46987;
continue;
} else {
var temp__5720__auto___46988 = cljs.core.seq(seq__46115_46975);
if(temp__5720__auto___46988){
var seq__46115_46993__$1 = temp__5720__auto___46988;
if(cljs.core.chunked_seq_QMARK_(seq__46115_46993__$1)){
var c__4556__auto___46994 = cljs.core.chunk_first(seq__46115_46993__$1);
var G__46995 = cljs.core.chunk_rest(seq__46115_46993__$1);
var G__46996 = c__4556__auto___46994;
var G__46997 = cljs.core.count(c__4556__auto___46994);
var G__46998 = (0);
seq__46115_46975 = G__46995;
chunk__46116_46976 = G__46996;
count__46117_46977 = G__46997;
i__46118_46978 = G__46998;
continue;
} else {
var vec__46136_47004 = cljs.core.first(seq__46115_46993__$1);
var script_tag_47005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46136_47004,(0),null);
var script_body_47006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46136_47004,(1),null);
eval(script_body_47006);


var G__47008 = cljs.core.next(seq__46115_46993__$1);
var G__47009 = null;
var G__47010 = (0);
var G__47011 = (0);
seq__46115_46975 = G__47008;
chunk__46116_46976 = G__47009;
count__46117_46977 = G__47010;
i__46118_46978 = G__47011;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46140){
var vec__46141 = p__46140;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46141,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46141,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46153 = arguments.length;
switch (G__46153) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46181 = cljs.core.seq(style_keys);
var chunk__46182 = null;
var count__46183 = (0);
var i__46184 = (0);
while(true){
if((i__46184 < count__46183)){
var it = chunk__46182.cljs$core$IIndexed$_nth$arity$2(null,i__46184);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47028 = seq__46181;
var G__47029 = chunk__46182;
var G__47030 = count__46183;
var G__47031 = (i__46184 + (1));
seq__46181 = G__47028;
chunk__46182 = G__47029;
count__46183 = G__47030;
i__46184 = G__47031;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46181);
if(temp__5720__auto__){
var seq__46181__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46181__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46181__$1);
var G__47034 = cljs.core.chunk_rest(seq__46181__$1);
var G__47035 = c__4556__auto__;
var G__47036 = cljs.core.count(c__4556__auto__);
var G__47037 = (0);
seq__46181 = G__47034;
chunk__46182 = G__47035;
count__46183 = G__47036;
i__46184 = G__47037;
continue;
} else {
var it = cljs.core.first(seq__46181__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47038 = cljs.core.next(seq__46181__$1);
var G__47039 = null;
var G__47040 = (0);
var G__47041 = (0);
seq__46181 = G__47038;
chunk__46182 = G__47039;
count__46183 = G__47040;
i__46184 = G__47041;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46194,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46203 = k46194;
var G__46203__$1 = (((G__46203 instanceof cljs.core.Keyword))?G__46203.fqn:null);
switch (G__46203__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46194,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46204){
var vec__46205 = p__46204;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46205,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46205,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46193){
var self__ = this;
var G__46193__$1 = this;
return (new cljs.core.RecordIter((0),G__46193__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46195,other46196){
var self__ = this;
var this46195__$1 = this;
return (((!((other46196 == null)))) && ((this46195__$1.constructor === other46196.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46195__$1.x,other46196.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46195__$1.y,other46196.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46195__$1.__extmap,other46196.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46193){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46216 = cljs.core.keyword_identical_QMARK_;
var expr__46217 = k__4388__auto__;
if(cljs.core.truth_((pred__46216.cljs$core$IFn$_invoke$arity$2 ? pred__46216.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46217) : pred__46216.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46217)))){
return (new shadow.dom.Coordinate(G__46193,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46216.cljs$core$IFn$_invoke$arity$2 ? pred__46216.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46217) : pred__46216.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46217)))){
return (new shadow.dom.Coordinate(self__.x,G__46193,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46193),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46193){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46193,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46198){
var extmap__4419__auto__ = (function (){var G__46227 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46198,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46198)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46227);
} else {
return G__46227;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46198),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46198),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46240,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46244 = k46240;
var G__46244__$1 = (((G__46244 instanceof cljs.core.Keyword))?G__46244.fqn:null);
switch (G__46244__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46240,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46246){
var vec__46247 = p__46246;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46247,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46247,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46239){
var self__ = this;
var G__46239__$1 = this;
return (new cljs.core.RecordIter((0),G__46239__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46241,other46242){
var self__ = this;
var this46241__$1 = this;
return (((!((other46242 == null)))) && ((this46241__$1.constructor === other46242.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46241__$1.w,other46242.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46241__$1.h,other46242.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46241__$1.__extmap,other46242.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46239){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46259 = cljs.core.keyword_identical_QMARK_;
var expr__46260 = k__4388__auto__;
if(cljs.core.truth_((pred__46259.cljs$core$IFn$_invoke$arity$2 ? pred__46259.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__46260) : pred__46259.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46260)))){
return (new shadow.dom.Size(G__46239,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46259.cljs$core$IFn$_invoke$arity$2 ? pred__46259.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__46260) : pred__46259.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46260)))){
return (new shadow.dom.Size(self__.w,G__46239,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46239),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46239){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46239,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46243){
var extmap__4419__auto__ = (function (){var G__46271 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46243,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__46243)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46271);
} else {
return G__46271;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46243),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46243),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47108 = (i + (1));
var G__47109 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__47108;
ret = G__47109;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__46295){
var vec__46296 = p__46295;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46296,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46296,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46303 = arguments.length;
switch (G__46303) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47122 = ps;
var G__47123 = (i + (1));
el__$1 = G__47122;
i = G__47123;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46328 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46328,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46328,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46328,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46337_47130 = cljs.core.seq(props);
var chunk__46338_47131 = null;
var count__46339_47132 = (0);
var i__46340_47133 = (0);
while(true){
if((i__46340_47133 < count__46339_47132)){
var vec__46350_47136 = chunk__46338_47131.cljs$core$IIndexed$_nth$arity$2(null,i__46340_47133);
var k_47137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46350_47136,(0),null);
var v_47138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46350_47136,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_47137);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47137),v_47138);


var G__47140 = seq__46337_47130;
var G__47141 = chunk__46338_47131;
var G__47142 = count__46339_47132;
var G__47143 = (i__46340_47133 + (1));
seq__46337_47130 = G__47140;
chunk__46338_47131 = G__47141;
count__46339_47132 = G__47142;
i__46340_47133 = G__47143;
continue;
} else {
var temp__5720__auto___47144 = cljs.core.seq(seq__46337_47130);
if(temp__5720__auto___47144){
var seq__46337_47145__$1 = temp__5720__auto___47144;
if(cljs.core.chunked_seq_QMARK_(seq__46337_47145__$1)){
var c__4556__auto___47146 = cljs.core.chunk_first(seq__46337_47145__$1);
var G__47147 = cljs.core.chunk_rest(seq__46337_47145__$1);
var G__47148 = c__4556__auto___47146;
var G__47149 = cljs.core.count(c__4556__auto___47146);
var G__47150 = (0);
seq__46337_47130 = G__47147;
chunk__46338_47131 = G__47148;
count__46339_47132 = G__47149;
i__46340_47133 = G__47150;
continue;
} else {
var vec__46354_47151 = cljs.core.first(seq__46337_47145__$1);
var k_47152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46354_47151,(0),null);
var v_47153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46354_47151,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_47152);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47152),v_47153);


var G__47159 = cljs.core.next(seq__46337_47145__$1);
var G__47160 = null;
var G__47161 = (0);
var G__47162 = (0);
seq__46337_47130 = G__47159;
chunk__46338_47131 = G__47160;
count__46339_47132 = G__47161;
i__46340_47133 = G__47162;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46358 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46358,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46358,(1),null);
var seq__46361_47166 = cljs.core.seq(node_children);
var chunk__46363_47167 = null;
var count__46364_47168 = (0);
var i__46365_47169 = (0);
while(true){
if((i__46365_47169 < count__46364_47168)){
var child_struct_47170 = chunk__46363_47167.cljs$core$IIndexed$_nth$arity$2(null,i__46365_47169);
if((!((child_struct_47170 == null)))){
if(typeof child_struct_47170 === 'string'){
var text_47171 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47171),child_struct_47170].join(''));
} else {
var children_47175 = shadow.dom.svg_node(child_struct_47170);
if(cljs.core.seq_QMARK_(children_47175)){
var seq__46415_47176 = cljs.core.seq(children_47175);
var chunk__46417_47177 = null;
var count__46418_47178 = (0);
var i__46419_47179 = (0);
while(true){
if((i__46419_47179 < count__46418_47178)){
var child_47181 = chunk__46417_47177.cljs$core$IIndexed$_nth$arity$2(null,i__46419_47179);
if(cljs.core.truth_(child_47181)){
node.appendChild(child_47181);


var G__47182 = seq__46415_47176;
var G__47183 = chunk__46417_47177;
var G__47184 = count__46418_47178;
var G__47185 = (i__46419_47179 + (1));
seq__46415_47176 = G__47182;
chunk__46417_47177 = G__47183;
count__46418_47178 = G__47184;
i__46419_47179 = G__47185;
continue;
} else {
var G__47186 = seq__46415_47176;
var G__47187 = chunk__46417_47177;
var G__47188 = count__46418_47178;
var G__47189 = (i__46419_47179 + (1));
seq__46415_47176 = G__47186;
chunk__46417_47177 = G__47187;
count__46418_47178 = G__47188;
i__46419_47179 = G__47189;
continue;
}
} else {
var temp__5720__auto___47192 = cljs.core.seq(seq__46415_47176);
if(temp__5720__auto___47192){
var seq__46415_47194__$1 = temp__5720__auto___47192;
if(cljs.core.chunked_seq_QMARK_(seq__46415_47194__$1)){
var c__4556__auto___47195 = cljs.core.chunk_first(seq__46415_47194__$1);
var G__47197 = cljs.core.chunk_rest(seq__46415_47194__$1);
var G__47198 = c__4556__auto___47195;
var G__47199 = cljs.core.count(c__4556__auto___47195);
var G__47200 = (0);
seq__46415_47176 = G__47197;
chunk__46417_47177 = G__47198;
count__46418_47178 = G__47199;
i__46419_47179 = G__47200;
continue;
} else {
var child_47201 = cljs.core.first(seq__46415_47194__$1);
if(cljs.core.truth_(child_47201)){
node.appendChild(child_47201);


var G__47202 = cljs.core.next(seq__46415_47194__$1);
var G__47203 = null;
var G__47204 = (0);
var G__47205 = (0);
seq__46415_47176 = G__47202;
chunk__46417_47177 = G__47203;
count__46418_47178 = G__47204;
i__46419_47179 = G__47205;
continue;
} else {
var G__47206 = cljs.core.next(seq__46415_47194__$1);
var G__47207 = null;
var G__47208 = (0);
var G__47209 = (0);
seq__46415_47176 = G__47206;
chunk__46417_47177 = G__47207;
count__46418_47178 = G__47208;
i__46419_47179 = G__47209;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47175);
}
}


var G__47211 = seq__46361_47166;
var G__47212 = chunk__46363_47167;
var G__47213 = count__46364_47168;
var G__47214 = (i__46365_47169 + (1));
seq__46361_47166 = G__47211;
chunk__46363_47167 = G__47212;
count__46364_47168 = G__47213;
i__46365_47169 = G__47214;
continue;
} else {
var G__47216 = seq__46361_47166;
var G__47217 = chunk__46363_47167;
var G__47218 = count__46364_47168;
var G__47219 = (i__46365_47169 + (1));
seq__46361_47166 = G__47216;
chunk__46363_47167 = G__47217;
count__46364_47168 = G__47218;
i__46365_47169 = G__47219;
continue;
}
} else {
var temp__5720__auto___47220 = cljs.core.seq(seq__46361_47166);
if(temp__5720__auto___47220){
var seq__46361_47221__$1 = temp__5720__auto___47220;
if(cljs.core.chunked_seq_QMARK_(seq__46361_47221__$1)){
var c__4556__auto___47222 = cljs.core.chunk_first(seq__46361_47221__$1);
var G__47223 = cljs.core.chunk_rest(seq__46361_47221__$1);
var G__47224 = c__4556__auto___47222;
var G__47225 = cljs.core.count(c__4556__auto___47222);
var G__47226 = (0);
seq__46361_47166 = G__47223;
chunk__46363_47167 = G__47224;
count__46364_47168 = G__47225;
i__46365_47169 = G__47226;
continue;
} else {
var child_struct_47227 = cljs.core.first(seq__46361_47221__$1);
if((!((child_struct_47227 == null)))){
if(typeof child_struct_47227 === 'string'){
var text_47228 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47228),child_struct_47227].join(''));
} else {
var children_47229 = shadow.dom.svg_node(child_struct_47227);
if(cljs.core.seq_QMARK_(children_47229)){
var seq__46451_47230 = cljs.core.seq(children_47229);
var chunk__46453_47231 = null;
var count__46454_47232 = (0);
var i__46455_47233 = (0);
while(true){
if((i__46455_47233 < count__46454_47232)){
var child_47234 = chunk__46453_47231.cljs$core$IIndexed$_nth$arity$2(null,i__46455_47233);
if(cljs.core.truth_(child_47234)){
node.appendChild(child_47234);


var G__47235 = seq__46451_47230;
var G__47236 = chunk__46453_47231;
var G__47237 = count__46454_47232;
var G__47238 = (i__46455_47233 + (1));
seq__46451_47230 = G__47235;
chunk__46453_47231 = G__47236;
count__46454_47232 = G__47237;
i__46455_47233 = G__47238;
continue;
} else {
var G__47240 = seq__46451_47230;
var G__47241 = chunk__46453_47231;
var G__47242 = count__46454_47232;
var G__47243 = (i__46455_47233 + (1));
seq__46451_47230 = G__47240;
chunk__46453_47231 = G__47241;
count__46454_47232 = G__47242;
i__46455_47233 = G__47243;
continue;
}
} else {
var temp__5720__auto___47244__$1 = cljs.core.seq(seq__46451_47230);
if(temp__5720__auto___47244__$1){
var seq__46451_47245__$1 = temp__5720__auto___47244__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46451_47245__$1)){
var c__4556__auto___47246 = cljs.core.chunk_first(seq__46451_47245__$1);
var G__47247 = cljs.core.chunk_rest(seq__46451_47245__$1);
var G__47248 = c__4556__auto___47246;
var G__47249 = cljs.core.count(c__4556__auto___47246);
var G__47250 = (0);
seq__46451_47230 = G__47247;
chunk__46453_47231 = G__47248;
count__46454_47232 = G__47249;
i__46455_47233 = G__47250;
continue;
} else {
var child_47252 = cljs.core.first(seq__46451_47245__$1);
if(cljs.core.truth_(child_47252)){
node.appendChild(child_47252);


var G__47254 = cljs.core.next(seq__46451_47245__$1);
var G__47255 = null;
var G__47256 = (0);
var G__47257 = (0);
seq__46451_47230 = G__47254;
chunk__46453_47231 = G__47255;
count__46454_47232 = G__47256;
i__46455_47233 = G__47257;
continue;
} else {
var G__47259 = cljs.core.next(seq__46451_47245__$1);
var G__47260 = null;
var G__47261 = (0);
var G__47262 = (0);
seq__46451_47230 = G__47259;
chunk__46453_47231 = G__47260;
count__46454_47232 = G__47261;
i__46455_47233 = G__47262;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47229);
}
}


var G__47263 = cljs.core.next(seq__46361_47221__$1);
var G__47264 = null;
var G__47265 = (0);
var G__47266 = (0);
seq__46361_47166 = G__47263;
chunk__46363_47167 = G__47264;
count__46364_47168 = G__47265;
i__46365_47169 = G__47266;
continue;
} else {
var G__47267 = cljs.core.next(seq__46361_47221__$1);
var G__47268 = null;
var G__47269 = (0);
var G__47270 = (0);
seq__46361_47166 = G__47267;
chunk__46363_47167 = G__47268;
count__46364_47168 = G__47269;
i__46365_47169 = G__47270;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47278 = arguments.length;
var i__4737__auto___47279 = (0);
while(true){
if((i__4737__auto___47279 < len__4736__auto___47278)){
args__4742__auto__.push((arguments[i__4737__auto___47279]));

var G__47280 = (i__4737__auto___47279 + (1));
i__4737__auto___47279 = G__47280;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq46491){
var G__46492 = cljs.core.first(seq46491);
var seq46491__$1 = cljs.core.next(seq46491);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46492,seq46491__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__46503 = arguments.length;
switch (G__46503) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__42854__auto___47285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_46516){
var state_val_46517 = (state_46516[(1)]);
if((state_val_46517 === (1))){
var state_46516__$1 = state_46516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46516__$1,(2),once_or_cleanup);
} else {
if((state_val_46517 === (2))){
var inst_46513 = (state_46516[(2)]);
var inst_46514 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_46516__$1 = (function (){var statearr_46520 = state_46516;
(statearr_46520[(7)] = inst_46513);

return statearr_46520;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46516__$1,inst_46514);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42649__auto__ = null;
var shadow$dom$state_machine__42649__auto____0 = (function (){
var statearr_46522 = [null,null,null,null,null,null,null,null];
(statearr_46522[(0)] = shadow$dom$state_machine__42649__auto__);

(statearr_46522[(1)] = (1));

return statearr_46522;
});
var shadow$dom$state_machine__42649__auto____1 = (function (state_46516){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_46516);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e46528){if((e46528 instanceof Object)){
var ex__42652__auto__ = e46528;
var statearr_46530_47287 = state_46516;
(statearr_46530_47287[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46516);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46528;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47291 = state_46516;
state_46516 = G__47291;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
shadow$dom$state_machine__42649__auto__ = function(state_46516){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42649__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42649__auto____1.call(this,state_46516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42649__auto____0;
shadow$dom$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42649__auto____1;
return shadow$dom$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_46534 = f__42855__auto__();
(statearr_46534[(6)] = c__42854__auto___47285);

return statearr_46534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
