(ns clojuress.impl.renjin.session
  (:require [clojuress.protocols :as prot]
            [clojuress.impl.renjin.proc :as proc]
            [clojuress.impl.renjin.java :as java]
            [clojuress.impl.renjin.java-to-clj :as java-to-clj]
            [clojuress.impl.renjin.clj-to-java :as clj-to-java]
            [clojure.core.async :as async])
  (:import (org.renjin.sexp SEXP)
           clojuress.protocols.Session))

(defrecord RenjinSession [session-args renjin]
  Session
  (close [session]
    )
  (session-args [session]
    session-args)
  (desc [session]
    session-args)
  (eval-r->java [session code]
    )
  (java->r-set [session varname java-obj]
    )
  (get-r->java [session varname]
    )
  (java->specified-type [session java-obj typ]
    )
  (java->naive-clj [session java-obj]
    )
  (java->clj [session java-obj]
    )
  (clj->java [session clj-obj]
    ))

(defn make [session-args]
  )

