(ns clojuress.impl.renjin.java-to-clj
  (:require [clojure.pprint :as pp]
            [clojure.walk :as walk]
            [com.rpl.specter :as specter]
            [tech.ml.dataset :as dataset]
            [tech.v2.datatype :as dtype]
            [tech.v2.datatype.protocols :as dtype-prot :refer [->array-copy]])
  (:import (org.renjin.sexp SEXP)
           (java.util Map List Collection)
           (clojure.lang Named)))

(defn java->specified-type
  [^SEXP java-obj typ]
  (case typ
    :ints nil
    :doubles nil
    :strings nil))

(defn java->naive-clj
  [^SEXP java-obj]
  )

(defprotocol Clojable
  (-java->clj [this]))

(defn java->clj
  [java-obj]
  (some-> java-obj
          -java->clj))

(extend-type Object
  Clojable
  (-java->clj [this] this))


(defmethod pp/simple-dispatch SEXP [obj]
  (let [clj-obj (java->clj obj)]
    (pp/pprint
     (into [(symbol (.toDebugString obj))]
           (when (not= clj-obj obj)
             [['->Clj clj-obj]])))))
