(ns clojisr.v1.impl.renjin.testing
  (:require [clojisr.v1.renjin :as renjin]
            [clojisr.v1.rserve :as rserve]
            [clojisr.v1.r :as r :refer [r]]
            [clojisr.v1.session :as session]
            [clojisr.v1.protocols :as prot]
            [clojisr.v1.objects-memory :as mem]
            [clojisr.v1.require :refer [require-r]]
            [clojisr.v1.inspection :as inspection]
            [tech.ml.dataset :as dataset]
            [alembic.still :refer [distill]]
            [clojisr.v1.impl.renjin.engine :as engine]
            [clojure.java.browse :refer [browse-url]])
  (:import (org.renjin.primitives.packaging ClasspathPackageLoader NamespaceRegistry)
           (org.renjin.base Base BaseFrame)))

(renjin/set-as-default!)
(r/discard-all-sessions)

(r '[+ 1 2])

(rserve/set-as-default!)
(r/discard-all-sessions)
(require-r '[base]
           '[datasets])
(r 'iris)


(require-r '[datasets])
(def euro r.datasets/euro)

[euro]







(session/set-default-session-type! :renjin)
(require '[clojisr.v1.r :as r :refer [r+ r r->java r->clj]])
(r/discard-all-sessions)

(def x (r "1"))
(mem/forget (:object-name x)
            (:session x))
[x]

(require-r '[base :as baze :refer [abs]]
           '[stats :as statz :refer [median]])

(baze/abs -4)
(r.base/abs -4)
(abs -4)

(statz/median [1 2 3])
(r.stats/median [1 2 3])
(median [1 2 3])

(let [session (session/fetch-or-make nil)]
  (->> session
       :engine
       engine/runtime-context
       (.getBaseEnvironment)
       (.getNames)
       (prot/java->clj session)))



(let [ctx (-> nil
              session/fetch-or-make
              :engine
              engine/runtime-context)]
  (-> ctx
      (.getNamespaceRegistry)
      (.getPackageLoader)
      (.load "stats")
      (.get)
      (.loadSymbols ctx)
      (->> (map #(.getName %)))))


(-> (NamespaceRegistry.)
    (.getPackageLoader))

(-> (ClasspathPackageLoader.)
    (.load "dplyr")
    (.get)
    (.getObjectNames))

(distill '[org.renjin.cran/dplyr "0.8.2-b6"]
         '[org.renjin.cran/ggplot2 "3.0.0-b29"]
         '[org.renjin.cran/ggvis "0.4.3-b32"])

(session/set-session-type! :rserve)
(session/set-session-type! :renjin)
(r/discard-all-sessions)

(require-r '[base]
           '[stats]
           '[utils]
           '[dplyr])


(-> (r '[library base])
    r/r->java)

(-> ['+ 1 2]
    r
    r->clj)




(def data-file "/tmp/data.csv")

(r.utils/write-csv
 (->> {:x [1 2 3 1 2 3]
       :y [4 5 6 7 8 9]}
      dataset/name-values-seq->dataset)
 :file data-file
 :row.names false)

(def data
  (-> data-file
    r.utils/read-csv))


(defn calc [data expr]
  (let [data-java (r->java data)
        colnames          (-> ['names data]
                              r
                              r->clj)
        colnames-set      (set colnames)
        relevant-col-symbols (->> [expr]
                               flatten
                               (filter (fn [v]
                                         (and (symbol? v)
                                              (-> v name colnames-set)))))
        relevant-colnames (map name relevant-col-symbols)
        f (eval (list 'fn
                      (vec relevant-col-symbols)
                      expr))]
    (->> relevant-colnames
         (map (fn [colname]
                (.getElementAsSEXP data-java colname)))
         (apply map f))))

(defn immutate [data & coldefs]
  (->> coldefs
       (partition 2)
       (map (fn [[col-kw expr]]
              [col-kw (calc data expr)]))
       (into {})
       (vector 'data.frame)
       (vector 'cbind data)
       r))

(defn filterr [data expr]
  (r [(symbol "`[`")
      data
      (calc data expr)
      (r/empty-symbol)]))

(defn grroup-by [data expr]
  (let [grouped-r-obj ^ListVector (r ['split
                                      data
                                      (calc data expr)])
        levels (inspection/names grouped-r-obj)]
    (->> grouped-r-obj
         inspection/names
         (map (fn [level]
                [level (r/brabra grouped-r-obj level)]))
         (into {}))))

(-> d
    (grroup-by 'x))


(def d
  (r ['data.frame {:x [1 2 1 2]
                   :y [3 4 5 6]
                   :z [7 8 9 10]}]))

(-> d
    (calc '(+ x y)))



(-> ['data.frame {:x [1 2 1 2]
                  :y [3 4 5 6]
                  :z [7 8 9 10]}]
    r
    (calc '(+ x y)))



(-> ['data.frame {:x [1 2 1 2]
                  :y [3 4 5 6]
                  :z [7 8 9 10]}]
    r
    (immutate :v '(+ x y)
              :w 'z))


(-> ['data.frame {:x [1 2 1 2]
                  :y [3 4 5 6]
                  :z [7 8 9 10]}]
    r
    (filterr '(< (+ x y) 5)))


(-> ['data.frame {:x [1 2 1 2]
                  :y [3 4 5 6]
                  :z [7 8 9 10]}]
    r
    (grroup-by 'x)
    r->clj)

(->> ['split data
      ['$ data 'x]]
     r
     r->java
     (.toArrayUnsafe)
     (mapcat (fn [data1]
               (r->clj (r ['nrow data1]))))
     r)

(r ['names data])




(alembic.still/distill '[org.renjin.cran/ggplot2 "3.2.0-b8"])
(require-r '[base :refer [data.frame]]
           '[ggplot2 :refer [ggplot geom_histogram aes]])
(require '[clojisr.v1.applications.plotting :as plotting])
(->> (plotting/plotting-function->svg
      (fn []
        (-> {:x (->> (repeatedly
                      999
                      (fn []
                        (reduce + (repeatedly 99 rand)))))}
            data-frame
            ggplot
            (r+ (geom_histogram
                 (aes :x 'x)))
            r.base/print)))
     (spit "/tmp/tmp.svg"))



(distill '[org.renjin.cran/lattice "0.20-38-b16"])

(require-r '[base]
           '[lattice])
(require '[clojisr.v1.applications.plotting :as plotting])

(->> (plotting/plotting-function->svg
      (fn []
        (r.lattice/histogram
         ['tilde 'x]
         :data (r.base/data-frame
                :x (->> (repeatedly
                         999
                         (fn []
                           (reduce + (repeatedly 99 rand)))))))))
     (spit "/tmp/tmp.svg"))

(browse-url "/tmp/tmp.svg")






(defn load [...])

(comment
  (load {...}))

(defn cleanup [...])

(comment
  (for [p [1 2 3]]
    (->> (load {:p p ...})
         (cleanup {...}))))

(->> (load {...})
     (cleanup {...})
     (feature-extraction {...})
     (algo1 {...})
     (vis {...}))
(def a 10)

[{:x 1 :y 2}
 {:x 3 :y 4}
 {:x 5 :y 6}]

(assoc {:a 1} :b 3) ; => {:b 3}

(=mapassoc :z '(+ x y a))

(=mapassoc [x y] :z '(+ x y a))

(=mapassoc :z '(+ ?x ?y a))

data %>% mutate(z=x+y+a)

[{:x 1 :y 2 :z 13}
 {:x 3 :y 4 :z 17}
 {:x 5 :y 6 :z 21}]




(comp (=mapassoc :z '(+ x y a))
      (=filter )
      (=group-by )
      (=summarize ))

:dataframe

(defmacro =mapassoc ...)

(comp ...)

(=mapassoc :z (+ ?x ?y a)
           :w (* ?x ?y a))

(=mapassoc (m :z (+ ?x ?y a)
              :w (* ?x ?y a)))

(=mapassoc :z '(+ ?x ?y a)
           :w '(* ?x ?y a))

(=mapassoc {:z '(+ ?x.x1 ?y a)
            :w {:w1 '(* ?x ?y a)
                :w2 '(* ?x ?y a 2)}})







(m/...
  ;;data
 [{:x 1 :y 2 :z 13}
  {:x 3 :y 4 :z 17}
  {:x 5 :y 6 :z 21}]
 ;; pattern
 (scan {:x ?x
        :y ?y})
 ;; output
 {:w {:w1 [(+ ?x ?y)]}}
)

[{:w {:w1 3}}
 {:w {:w1 _}}
 {:w {:w1 _}}]
