(ns schopfhirsch.injector)
 
(defprotocol Context
  (maker [this])
  (statistics [this]))

(defn ^:private make
  "Do dependency injection 
  (i.e. call the referenced function with the right arguments)"
  [deps dependency]
  (if (map? dependency)
    (:val dependency)
    (let [dep (get deps dependency)
          fun (:f dep)
          params (:p dep)]
      (apply fun (map #(make deps %) params)))))
 
(defn ^:private track-call [tracker dependency]
  (swap! tracker
         (fn [old-tracker]
           (let [{calls :calls} old-tracker
                 call-count (or (get calls dependency) 0)]
             (assoc old-tracker
                    :calls
                    (assoc calls dependency (inc call-count)))))))

(deftype context [deps tracker]
  Context
  (maker [this]
    (fn [dependency]
      (track-call tracker dependency)
      (make deps dependency)))
  (statistics [this] @tracker))

(defn ^:private current-time []
  (str
   #?(:clj (java.util.Date.)
      :cljs (js/Date.))))

(defn create-context
  "Returns a function that can be used to call functions with 
  dependencies"
  [deps]
  (context. deps
            (atom
             {:start (current-time)
              :calls {}})))
