# Schopfhirsch
## Injector
Dependency Injection for Clojure and ClojureScript.

[![Clojars Project](https://clojars.org/schopfhirsch/injector/latest-version.svg)](https://clojars.org/schopfhirsch/injector)

[Code on GitHub](https://github.com/Peter-Donner/schopfhirsch-injector)

### Example Code
Find the following example code here: https://github.com/Peter-Donner/schopfhirsch-injector/tree/master/examples/simple

### Define Functions that Should be Called via Dependency Injection
```clojure
(ns example.simple
  (:use [schopfhirsch.injector :only [create-context maker statistics]]))

;; db-handle will be injected with the value of (database-handle) and
;; collection as constant value
(defn customer-controller [db-handle collection]
  (println "customer-controller called db-handle:"
           (str db-handle) "collection:" collection))

;; connection-string will be injected with a constant value 
(defn database-handle [connection-string]
  (println "db-handle called with connection-string:"
           connection-string)
  {:conn connection-string})
```

### Create an Injection Context
```clojure
(defonce ctx
  (create-context
   {:customer-controller
    {:f customer-controller
     :p [:database-handle
         :default-customer-collection]}

    :database-handle
    {:f database-handle
     :p [{:val "mongodb://localhost"}]}

    :default-customer-collection
    {:f (fn [] "customer")
     :val "customer"}}))
```

### Create Functions
```clojure
(def make (maker ctx))

;; Create an instance of customer-controller
(make :customer-controller)

;; Create an instance of database-handle
(make :database-handle)

;; Print statistics
(println (statistics ctx)))
```
