(ns schopfhirsch.injector)

(defn ^:private add-dependencies!
  "Merge dependencies into ctx"
  [ctx dependencies]
  (swap! ctx merge dependencies))

(defn ^:private create
  "Do dependency injection (i.e. call the referenced function with the right 
  arguments)"
  [ctx dependency]
  (if (map? dependency)
    (:val dependency)
    (let [dep (get @ctx dependency)]
      (apply (:f dep) (map #(create ctx %) (:p dep))))))

(defn create-context
  "Returns a function that can be used to call functions with dependencies"
  []
  (let [ctx (atom {})]
    (add-dependencies! ctx {:add-deps! {:f (fn []
                                             (fn [dependencies]
                                               (add-dependencies! ctx dependencies)))}})
    (fn [dependency] (create ctx dependency))))
