(ns schopfhirsch.injector)

(defn add-dependencies!
  "Merge dependencies into ctx"
  [ctx dependencies]
  (swap! ctx merge dependencies))

(defn please
  "Do dependency injection (i.e. call the referenced function with the right 
  arguments)"
  [ctx dependency]
  (if (map? dependency)
    (:val dependency)
    (let [dep (get @ctx dependency)]
      (apply (:f dep) (map #(please ctx %) (:p dep))))))

(defn create-context
  "Create context container data structure"
  []
  (atom {}))
