# Schopfhirsch
## Injector
Dependency Injection for Clojure and ClojureScript.

[![Clojars Project](https://clojars.org/schopfhirsch/injector/latest-version.svg)](https://clojars.org/schopfhirsch/injector)

[Code on GitHub](https://github.com/Peter-Donner/schopfhirsch-injector)

### Example Code
Find the following example code here: https://github.com/Peter-Donner/schopfhirsch-injector/tree/master/examples/simple

### Create an Injection Context
```clojure
(ns example.simple
  (:use [schopfhirsch.injector
         :only [add-dependencies! create-context please]]))

;; Container for dependency injection
(defonce ctx (create-context))

;; pls function for convenience
(def pls (partial please ctx))
```

### Define Functions that Should be Called via Dependency Injection
```clojure
;; db-handle will be injected with the value of (database-handle) and
;; collection as constant value
(defn customer-controller [db-handle collection]
  (println "customer-controller called db-handle:"
           (str db-handle) "collection:" collection))

;; connection-string will be injected with a constant value 
(defn database-handle [connection-string]
  (println "db-handle called with connection-string:"
           connection-string)
  {:conn connection-string})
```

### Define Dependencies
```clojure
(add-dependencies!
 ctx
 {:customer-controller {:f customer-controller
                        :p [:database-handle]}
  :database-handle {:f database-handle
                    :p [{:val "mongodb://localhost"}]}})
```

### Create Functions
```clojure
  ;; Create an instance of customer-controller
  (pls :customer-controller)

  ;; Create an instance of database-handle
  (pls :database-handle)
```
