# Schopfhirsch
## Hash Router
A routing library for web based single page applications written in ClojureScript.

[Code on GitHub](https://github.com/Peter-Donner/schopfhirsch-hash-router)

### Highlights
* hash matching with plain **regular expressions**
* enter/exit functions with **argument injection**
* supports **custom resolvers**
* **dead simple**, written in < 100 lines of ClojureScript code

### Example Code
See [React.js example](https://github.com/Peter-Donner/schopfhirsch-hash-router/tree/master/examples/react)

### Route Examples
```clojure
(ns example.router
  (:use [schopfhirsch.hash-router :only [set-routes!]]))

(set-routes!
 ;; call customer-list-handler without any arguments
 [{:rule #"#/customer-list1" :enter customer-list-handler}

  ;; call customer-list-handler with the return value of (ctx-factory)
  ;; as argument  
  {:rule #"#/customer-list2" :enter customer-list-handler :args [ctx-factory]}

  ;; call exit-handler with the arguments from the :enter handler when
  ;; the hash URL changes
  {:rule #"#/customer-list3" :enter customer-list-handler :args [ctx-factory]
   :exit exit-handler}

  ;; call customer-handler with 2 arguments, the second argument is
  ;; the first match of the :rule expression
  {:rule #"#/customer1/(.*)" :enter customer-handler :args [ctx-factory 1]}

  ;; change argument ordering for customer-handler
  {:rule #"#/customer2/(.*)" :enter customer-handler :args [1 ctx-factory]}])
```

### Routes can be Nested

```clojure
(ns example.router
  (:use [schopfhirsch.hash-router :only [set-routes!]]))

(def customer-routes
  [{:rule #"#/customer1/(.*)" :enter customer-handler :args [ctx-factory 1]}
   {:rule #"#/customer2/(.*)" :enter customer-handler :args [1 ctx-factory]}])

(set-routes!
 [{:rule #"#/customer-list1" :enter customer-list-handler}
  {:rule #"#/customer-list2" :enter customer-list-handler :args [ctx-factory]}
  {:rule #"#/customer-list3" :enter customer-list-handler :args [ctx-factory]
   :exit exit-handler}
  ;; nested routes
  customer-routes])
```