/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class PushGateway {
    private final String address;
    private static final int SECONDS_PER_MILLISECOND = 1000;

    public PushGateway(String address) {
        this.address = address;
    }

    public void push(CollectorRegistry registry, String job) throws IOException {
        this.doRequest(registry, job, null, "POST");
    }

    public void push(Collector collector, String job) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.push(registry, job);
    }

    public void push(CollectorRegistry registry, String job, Map<String, String> groupingKey) throws IOException {
        this.doRequest(registry, job, groupingKey, "POST");
    }

    public void push(Collector collector, String job, Map<String, String> groupingKey) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.push(registry, job, groupingKey);
    }

    public void pushAdd(CollectorRegistry registry, String job) throws IOException {
        this.doRequest(registry, job, null, "PUT");
    }

    public void pushAdd(Collector collector, String job) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.pushAdd(registry, job);
    }

    public void pushAdd(CollectorRegistry registry, String job, Map<String, String> groupingKey) throws IOException {
        this.doRequest(registry, job, groupingKey, "PUT");
    }

    public void pushAdd(Collector collector, String job, Map<String, String> groupingKey) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.pushAdd(registry, job, groupingKey);
    }

    public void delete(String job) throws IOException {
        this.doRequest(null, job, null, "DELETE");
    }

    public void delete(String job, Map<String, String> groupingKey) throws IOException {
        this.doRequest(null, job, groupingKey, "DELETE");
    }

    @Deprecated
    public void push(CollectorRegistry registry, String job, String instance) throws IOException {
        HashMap<String, String> groupingKey = new HashMap<String, String>();
        groupingKey.put("instance", instance);
        this.doRequest(registry, job, groupingKey, "POST");
    }

    @Deprecated
    public void push(Collector collector, String job, String instance) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.push(registry, job, instance);
    }

    @Deprecated
    public void pushAdd(CollectorRegistry registry, String job, String instance) throws IOException {
        HashMap<String, String> groupingKey = new HashMap<String, String>();
        groupingKey.put("instance", instance);
        this.doRequest(registry, job, groupingKey, "PUT");
    }

    @Deprecated
    public void pushAdd(Collector collector, String job, String instance) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.pushAdd(registry, job, instance);
    }

    @Deprecated
    public void delete(String job, String instance) throws IOException {
        HashMap<String, String> groupingKey = new HashMap<String, String>();
        groupingKey.put("instance", instance);
        this.doRequest(null, job, groupingKey, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRequest(CollectorRegistry registry, String job, Map<String, String> groupingKey, String method) throws IOException {
        String url = "http://" + this.address + "/metrics/job/" + URLEncoder.encode(job, "UTF-8");
        if (groupingKey != null) {
            for (Map.Entry<String, String> entry : groupingKey.entrySet()) {
                url = url + "/" + entry.getKey() + "/" + URLEncoder.encode(entry.getValue(), "UTF-8");
            }
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
        if (!method.equals("DELETE")) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod(method);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.connect();
        try {
            int response;
            if (!method.equals("DELETE")) {
                BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                TextFormat.write004(writer2, registry.metricFamilySamples());
                writer2.flush();
                writer2.close();
            }
            if ((response = connection.getResponseCode()) != 202) {
                throw new IOException("Response code from " + url + " was " + response);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static Map<String, String> instanceIPGroupingKey() throws UnknownHostException {
        HashMap<String, String> groupingKey = new HashMap<String, String>();
        groupingKey.put("instance", InetAddress.getLocalHost().getHostAddress());
        return groupingKey;
    }
}

