/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.PhongLighting;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.sw.SWEffectPeer;
import com.sun.scenario.effect.light.SpotLight;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.FloatBuffer;

public class SWPhongLighting_POINTPeer
extends SWEffectPeer {
    private FloatBuffer kvals;

    public SWPhongLighting_POINTPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    @Override
    protected final PhongLighting getEffect() {
        return (PhongLighting)super.getEffect();
    }

    private float getSurfaceScale() {
        return this.getEffect().getSurfaceScale();
    }

    private float getDiffuseConstant() {
        return this.getEffect().getDiffuseConstant();
    }

    private float getSpecularConstant() {
        return this.getEffect().getSpecularConstant();
    }

    private float getSpecularExponent() {
        return this.getEffect().getSpecularExponent();
    }

    private float[] getLightPosition() {
        return this.getEffect().getLight().getNormalizedLightPosition();
    }

    private float[] getLightColor() {
        return this.getEffect().getLight().getColor().getComponents(null);
    }

    private float getLightSpecularExponent() {
        return ((SpotLight)this.getEffect().getLight()).getSpecularExponent();
    }

    private float[] getLightDirection() {
        return ((SpotLight)this.getEffect().getLight()).getNormalizedLightDirection();
    }

    private FloatBuffer getKvals() {
        Rectangle bumpImgBounds = this.getInputNativeBounds(0);
        float xoff = 1.0f / (float)bumpImgBounds.width;
        float yoff = 1.0f / (float)bumpImgBounds.height;
        float[] kx = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] ky = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer(36);
        }
        this.kvals.clear();
        int kidx = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                this.kvals.put((float)j * xoff);
                this.kvals.put((float)i * yoff);
                this.kvals.put(kx[kidx]);
                this.kvals.put(ky[kidx]);
                ++kidx;
            }
        }
        this.kvals.rewind();
        return this.kvals;
    }

    @Override
    protected float[] getSourceRegion(int inputIndex) {
        switch (inputIndex) {
            case 0: {
                Rectangle bump = this.getInputBounds(0);
                Rectangle orig = this.getInputBounds(1);
                Rectangle nb = this.getInputNativeBounds(0);
                float xdiff = (float)(bump.width - orig.width) / 2.0f;
                float ydiff = (float)(bump.height - orig.height) / 2.0f;
                float x1 = (float)bump.x + xdiff;
                float y1 = (float)bump.y + ydiff;
                float x2 = (float)(bump.x + bump.width) - xdiff;
                float y2 = (float)(bump.y + bump.height) - ydiff;
                float tx1 = x1 / (float)nb.width;
                float ty1 = y1 / (float)nb.height;
                float tx2 = x2 / (float)nb.width;
                float ty2 = y2 / (float)nb.height;
                return new float[]{tx1, ty1, tx2, ty2};
            }
            case 1: {
                return super.getSourceRegion(inputIndex);
            }
        }
        throw new InternalError("Invalid input index");
    }

    @Override
    public ImageData filter(Effect effect, ImageData ... inputs) {
        this.setEffect(effect);
        BufferedImage src0 = (BufferedImage)inputs[0].getImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getWidth();
        int src0h = src0.getHeight();
        int src0scan = src0.getWidth();
        int[] bumpImg = ((DataBufferInt)src0.getRaster().getDataBuffer()).getData();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        this.setInputBounds(0, inputs[0].getBounds());
        this.setInputNativeBounds(0, src0Bounds);
        BufferedImage src1 = (BufferedImage)inputs[1].getImage();
        int src1x = 0;
        int src1y = 0;
        int src1w = src1.getWidth();
        int src1h = src1.getHeight();
        int src1scan = src1.getWidth();
        int[] origImg = ((DataBufferInt)src1.getRaster().getDataBuffer()).getData();
        Rectangle src1Bounds = new Rectangle(src1x, src1y, src1w, src1h);
        this.setInputBounds(1, inputs[1].getBounds());
        this.setInputNativeBounds(1, src1Bounds);
        float[] src0Rect = this.getSourceRegion(0);
        float[] src1Rect = this.getSourceRegion(1);
        Rectangle dstBounds = this.getDestBounds();
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        BufferedImage dst = this.getDestImageFromPool(dstw, dsth);
        this.setDestNativeBounds(dst.getWidth(), dst.getHeight());
        int dstscan = dst.getWidth();
        int[] dstPixels = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        float diffuseConstant = this.getDiffuseConstant();
        float surfaceScale = this.getSurfaceScale();
        float[] lightColor_arr = this.getLightColor();
        float lightColor_x = lightColor_arr[0];
        float lightColor_y = lightColor_arr[1];
        float lightColor_z = lightColor_arr[2];
        FloatBuffer kvals_buf = this.getKvals();
        float[] kvals_arr = new float[kvals_buf.capacity()];
        kvals_buf.get(kvals_arr);
        float[] lightPosition_arr = this.getLightPosition();
        float lightPosition_x = lightPosition_arr[0];
        float lightPosition_y = lightPosition_arr[1];
        float lightPosition_z = lightPosition_arr[2];
        float specularConstant = this.getSpecularConstant();
        float specularExponent = this.getSpecularExponent();
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float inc1_x = (src1Rect[2] - src1Rect[0]) / (float)dstw;
        float inc1_y = (src1Rect[3] - src1Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        float pos1_y = src1Rect[1] + inc1_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            float pos1_x = src1Rect[0] + inc1_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float max_res;
                float S_w;
                float NdotH;
                int bumpImg_tmp;
                int origImg_tmp;
                float pixcoord_x = dx;
                float loc_tmp_x = pos1_x;
                float loc_tmp_y = pos1_y;
                if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x * (float)src1w);
                    int iloc_tmp_y = (int)(loc_tmp_y * (float)src1h);
                    boolean out = iloc_tmp_x >= src1w || iloc_tmp_y >= src1h;
                    origImg_tmp = out ? 0 : origImg[iloc_tmp_y * src1scan + iloc_tmp_x];
                } else {
                    origImg_tmp = 0;
                }
                float sample_res_x = (float)(origImg_tmp >> 16 & 0xFF) / 255.0f;
                float sample_res_y = (float)(origImg_tmp >> 8 & 0xFF) / 255.0f;
                float sample_res_z = (float)(origImg_tmp & 0xFF) / 255.0f;
                float sample_res_w = (float)(origImg_tmp >>> 24) / 255.0f;
                float orig_x = sample_res_x;
                float orig_y = sample_res_y;
                float orig_z = sample_res_z;
                float orig_w = sample_res_w;
                float sum_x = 0.0f;
                float sum_y = 0.0f;
                for (int i = 0; i < 9; ++i) {
                    int bumpImg_tmp2;
                    float loc_tmp_x2 = pos0_x + kvals_arr[i * 4 + 0];
                    float loc_tmp_y2 = pos0_y + kvals_arr[i * 4 + 1];
                    if (loc_tmp_x2 >= 0.0f && loc_tmp_y2 >= 0.0f) {
                        int iloc_tmp_x = (int)(loc_tmp_x2 * (float)src0w);
                        int iloc_tmp_y = (int)(loc_tmp_y2 * (float)src0h);
                        boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                        bumpImg_tmp2 = out ? 0 : bumpImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                    } else {
                        bumpImg_tmp2 = 0;
                    }
                    sample_res_w = (float)(bumpImg_tmp2 >>> 24) / 255.0f;
                    sum_x += kvals_arr[i * 4 + 2] * sample_res_w;
                    sum_y += kvals_arr[i * 4 + 3] * sample_res_w;
                }
                float factor = 0.25f;
                float x_tmp_x = sum_x *= -surfaceScale * factor;
                float x_tmp_y = sum_y *= -surfaceScale * factor;
                float x_tmp_z = 1.0f;
                float denom = (float)Math.sqrt(x_tmp_x * x_tmp_x + x_tmp_y * x_tmp_y + x_tmp_z * x_tmp_z);
                float normalize_res_x = x_tmp_x / denom;
                float normalize_res_y = x_tmp_y / denom;
                float normalize_res_z = x_tmp_z / denom;
                float N_x = normalize_res_x;
                float N_y = normalize_res_y;
                float N_z = normalize_res_z;
                float loc_tmp_x3 = pos0_x;
                float loc_tmp_y3 = pos0_y;
                if (loc_tmp_x3 >= 0.0f && loc_tmp_y3 >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x3 * (float)src0w);
                    int iloc_tmp_y = (int)(loc_tmp_y3 * (float)src0h);
                    boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                    bumpImg_tmp = out ? 0 : bumpImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                } else {
                    bumpImg_tmp = 0;
                }
                float bumpA = sample_res_w = (float)(bumpImg_tmp >>> 24) / 255.0f;
                float tmp_x = pixcoord_x;
                float tmp_y = pixcoord_y;
                float tmp_z = surfaceScale * bumpA;
                float x_tmp_x2 = tmp_x;
                float x_tmp_y2 = tmp_y;
                float x_tmp_z2 = tmp_z;
                float denom2 = (float)Math.sqrt(x_tmp_x2 * x_tmp_x2 + x_tmp_y2 * x_tmp_y2 + x_tmp_z2 * x_tmp_z2);
                normalize_res_x = x_tmp_x2 / denom2;
                normalize_res_y = x_tmp_y2 / denom2;
                normalize_res_z = x_tmp_z2 / denom2;
                float Lxyz_x = lightPosition_x - normalize_res_x;
                float Lxyz_y = lightPosition_y - normalize_res_y;
                float Lxyz_z = lightPosition_z - normalize_res_z;
                float Lrgb_x = lightColor_x;
                float Lrgb_y = lightColor_y;
                float Lrgb_z = lightColor_z;
                float E_x = 0.0f;
                float E_y = 0.0f;
                float E_z = 1.0f;
                float x_tmp_x3 = Lxyz_x + E_x;
                float x_tmp_y3 = Lxyz_y + E_y;
                float x_tmp_z3 = Lxyz_z + E_z;
                float denom3 = (float)Math.sqrt(x_tmp_x3 * x_tmp_x3 + x_tmp_y3 * x_tmp_y3 + x_tmp_z3 * x_tmp_z3);
                normalize_res_x = x_tmp_x3 / denom3;
                normalize_res_y = x_tmp_y3 / denom3;
                normalize_res_z = x_tmp_z3 / denom3;
                float H_x = normalize_res_x;
                float H_y = normalize_res_y;
                float H_z = normalize_res_z;
                float x_tmp_x4 = N_x;
                float x_tmp_y4 = N_y;
                float x_tmp_z4 = N_z;
                float y_tmp_x = Lxyz_x;
                float y_tmp_y = Lxyz_y;
                float y_tmp_z = Lxyz_z;
                float dot_res = x_tmp_x4 * y_tmp_x + x_tmp_y4 * y_tmp_y + x_tmp_z4 * y_tmp_z;
                float D_x = diffuseConstant * dot_res * Lrgb_x;
                float D_y = diffuseConstant * dot_res * Lrgb_y;
                float D_z = diffuseConstant * dot_res * Lrgb_z;
                float D_w = 1.0f;
                float x_tmp_x5 = N_x;
                float x_tmp_y5 = N_y;
                float x_tmp_z5 = N_z;
                float y_tmp_x2 = H_x;
                float y_tmp_y2 = H_y;
                float y_tmp_z2 = H_z;
                float x_tmp = NdotH = (dot_res = x_tmp_x5 * y_tmp_x2 + x_tmp_y5 * y_tmp_y2 + x_tmp_z5 * y_tmp_z2);
                float y_tmp = specularExponent;
                float pow_res = (float)Math.pow(x_tmp, y_tmp);
                float S_x = specularConstant * pow_res * Lrgb_x;
                float S_y = specularConstant * pow_res * Lrgb_y;
                float S_z = specularConstant * pow_res * Lrgb_z;
                float x_tmp2 = S_x;
                float y_tmp2 = S_y;
                x_tmp2 = S_w = (max_res = x_tmp2 > y_tmp2 ? x_tmp2 : y_tmp2);
                y_tmp2 = S_z;
                S_w = max_res = x_tmp2 > y_tmp2 ? x_tmp2 : y_tmp2;
                float color_x = (S_x *= (orig_w *= D_w)) + (orig_x *= D_x) * (1.0f - (S_w *= orig_w));
                float color_y = (S_y *= orig_w) + (orig_y *= D_y) * (1.0f - S_w);
                float color_z = (S_z *= orig_w) + (orig_z *= D_z) * (1.0f - S_w);
                float color_w = orig_w;
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > 1.0f) {
                    color_x = 1.0f;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > 1.0f) {
                    color_y = 1.0f;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > 1.0f) {
                    color_z = 1.0f;
                }
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f + 0.5f) << 24;
                pos0_x += inc0_x;
                pos1_x += inc1_x;
            }
            pos0_y += inc0_y;
            pos1_y += inc1_y;
        }
        return new ImageData(dst, dstBounds);
    }
}

