/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.MotionBlur;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.sw.SWEffectPeer;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.FloatBuffer;

public class SWMotionBlurPeer
extends SWEffectPeer {
    private FloatBuffer kvals;

    public SWMotionBlurPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    @Override
    protected final MotionBlur getEffect() {
        return (MotionBlur)super.getEffect();
    }

    private static int getPad(float radius) {
        return (int)Math.ceil(radius);
    }

    private int getKernelSize() {
        int r = SWMotionBlurPeer.getPad(this.getEffect().getRadius());
        return r * 2 + 1;
    }

    private FloatBuffer getKvals() {
        float radius = this.getEffect().getRadius();
        int r = SWMotionBlurPeer.getPad(radius);
        int klen = r * 2 + 1;
        Rectangle nb = this.getInputNativeBounds(0);
        float xoff = 1.0f / (float)nb.width;
        float yoff = 1.0f / (float)nb.height;
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer(508);
        }
        this.kvals.clear();
        float angle = this.getEffect().getAngle();
        float sina = (float)Math.sin(angle);
        float cosa = (float)Math.cos(angle);
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        for (int row = -r; row <= r; ++row) {
            float distance = (float)row * (float)row;
            float kval = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            float dx = cosa * (float)row;
            this.kvals.put(dx * xoff);
            float dy = sina * (float)row;
            this.kvals.put(-dy * yoff);
            this.kvals.put(kval);
            this.kvals.put(0.0f);
            total += kval;
        }
        for (int i = 2; i < klen * 4; i += 4) {
            this.kvals.put(i, this.kvals.get(i) / total);
        }
        this.kvals.rewind();
        return this.kvals;
    }

    @Override
    protected float[] getSourceRegion(int inputIndex) {
        if (this.getPass() != 0) {
            throw new InternalError();
        }
        Rectangle b = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float pad = SWMotionBlurPeer.getPad(this.getEffect().getRadius());
        float x1 = (float)b.x - pad;
        float y1 = (float)b.y - pad;
        float x2 = (float)(b.x + b.width) + pad;
        float y2 = (float)(b.y + b.height) + pad;
        float tx1 = x1 / (float)nb.width;
        float ty1 = y1 / (float)nb.height;
        float tx2 = x2 / (float)nb.width;
        float ty2 = y2 / (float)nb.height;
        return new float[]{tx1, ty1, tx2, ty2};
    }

    @Override
    public ImageData filter(Effect effect, ImageData ... inputs) {
        this.setEffect(effect);
        BufferedImage src0 = (BufferedImage)inputs[0].getImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getWidth();
        int src0h = src0.getHeight();
        int src0scan = src0.getWidth();
        int[] baseImg = ((DataBufferInt)src0.getRaster().getDataBuffer()).getData();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        this.setInputBounds(0, inputs[0].getBounds());
        this.setInputNativeBounds(0, src0Bounds);
        float[] src0Rect = this.getSourceRegion(0);
        Rectangle dstBounds = this.getDestBounds();
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        BufferedImage dst = this.getDestImageFromPool(dstw, dsth);
        this.setDestNativeBounds(dst.getWidth(), dst.getHeight());
        int dstscan = dst.getWidth();
        int[] dstPixels = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int kernelSize = this.getKernelSize();
        FloatBuffer kvals_buf = this.getKvals();
        float[] kvals_arr = new float[kvals_buf.capacity()];
        kvals_buf.get(kvals_arr);
        int MAX_KERNEL_SIZE = 127;
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float pixcoord_x = dx;
                float sum_x = 0.0f;
                float sum_y = 0.0f;
                float sum_z = 0.0f;
                float sum_w = 0.0f;
                for (int i = 0; i < kernelSize; ++i) {
                    int baseImg_tmp;
                    float loc_tmp_x = pos0_x + kvals_arr[i * 4 + 0];
                    float loc_tmp_y = pos0_y + kvals_arr[i * 4 + 1];
                    if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                        int iloc_tmp_x = (int)(loc_tmp_x * (float)src0w);
                        int iloc_tmp_y = (int)(loc_tmp_y * (float)src0h);
                        boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                        baseImg_tmp = out ? 0 : baseImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                    } else {
                        baseImg_tmp = 0;
                    }
                    float sample_res_x = (float)(baseImg_tmp >> 16 & 0xFF) / 255.0f;
                    float sample_res_y = (float)(baseImg_tmp >> 8 & 0xFF) / 255.0f;
                    float sample_res_z = (float)(baseImg_tmp & 0xFF) / 255.0f;
                    float sample_res_w = (float)(baseImg_tmp >>> 24) / 255.0f;
                    sum_x += kvals_arr[i * 4 + 2] * sample_res_x;
                    sum_y += kvals_arr[i * 4 + 2] * sample_res_y;
                    sum_z += kvals_arr[i * 4 + 2] * sample_res_z;
                    sum_w += kvals_arr[i * 4 + 2] * sample_res_w;
                }
                float color_x = sum_x;
                float color_y = sum_y;
                float color_z = sum_z;
                float color_w = sum_w;
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > 1.0f) {
                    color_x = 1.0f;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > 1.0f) {
                    color_y = 1.0f;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > 1.0f) {
                    color_z = 1.0f;
                }
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f + 0.5f) << 24;
                pos0_x += inc0_x;
            }
            pos0_y += inc0_y;
        }
        return new ImageData(dst, dstBounds);
    }
}

