/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.impl.state.ZoomRadialBlurState;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class ZoomRadialBlur
extends CoreEffect {
    private int r;
    private float centerX;
    private float centerY;
    private final ZoomRadialBlurState state = new ZoomRadialBlurState(this);

    public ZoomRadialBlur() {
        this(1);
    }

    public ZoomRadialBlur(int radius) {
        this(radius, (Effect)new Source(true));
    }

    public ZoomRadialBlur(int radius, Effect input) {
        super(input, new Source(true));
        this.setRadius(radius);
    }

    @Override
    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getRadius() {
        return this.r;
    }

    public void setRadius(int radius) {
        if (radius < 1 || radius > 64) {
            throw new IllegalArgumentException("Radius must be in the range [1,64]");
        }
        int old = this.r;
        this.r = radius;
        this.state.invalidateDeltas();
        this.firePropertyChange("radius", old, radius);
        this.updatePeer();
    }

    private void updatePeer() {
        int psize = 4 + this.r - this.r % 4;
        this.updatePeerKey("ZoomRadialBlur", psize);
    }

    public float getCenterX() {
        return this.centerX;
    }

    public void setCenterX(float centerX) {
        float old = this.centerX;
        this.centerX = centerX;
        this.firePropertyChange("centerX", Float.valueOf(old), Float.valueOf(centerX));
    }

    public float getCenterY() {
        return this.centerY;
    }

    public void setCenterY(float centerY) {
        float old = this.centerY;
        this.centerY = centerY;
        this.firePropertyChange("centerY", Float.valueOf(old), Float.valueOf(centerY));
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getInputs().get(0).getBounds();
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        Rectangle bnd = this.getBounds().getBounds();
        this.state.updateDeltas((float)(1.0 / bnd.getWidth()), (float)(1.0 / bnd.getHeight()));
        return this.filterInputs(config, 0).getImage();
    }
}

