/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Shadow;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.light.Light;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PhongLighting
extends CoreEffect {
    private float surfaceScale = 1.0f;
    private float diffuseConstant = 1.0f;
    private float specularConstant = 1.0f;
    private float specularExponent = 1.0f;
    private Light light;
    private final PropertyChangeListener lightListener = new LightChangeListener();

    public PhongLighting(Light light) {
        this(light, new Shadow(10.0f), new Source(true));
    }

    public PhongLighting(Light light, Effect bumpInput, Effect contentInput) {
        super(bumpInput, contentInput);
        this.setLight(light);
    }

    public final Effect getBumpInput() {
        return this.getInputs().get(0);
    }

    public void setBumpInput(Effect bumpInput) {
        this.setInput(0, bumpInput);
    }

    public final Effect getContentInput() {
        return this.getInputs().get(1);
    }

    public void setContentInput(Effect contentInput) {
        this.setInput(1, contentInput);
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        if (light == null) {
            throw new IllegalArgumentException("Light must be non-null");
        }
        Light old = this.light;
        if (old != null) {
            old.removePropertyChangeListener(this.lightListener);
        }
        this.light = light;
        this.light.addPropertyChangeListener(this.lightListener);
        this.updatePeerKey("PhongLighting_" + light.getType().name());
        this.firePropertyChange("light", old, light);
    }

    public float getDiffuseConstant() {
        return this.diffuseConstant;
    }

    public void setDiffuseConstant(float diffuseConstant) {
        if (diffuseConstant < 0.0f || diffuseConstant > 2.0f) {
            throw new IllegalArgumentException("Diffuse constant must be in the range [0,2]");
        }
        float old = this.diffuseConstant;
        this.diffuseConstant = diffuseConstant;
        this.firePropertyChange("diffuseConstant", Float.valueOf(old), Float.valueOf(diffuseConstant));
    }

    public float getSpecularConstant() {
        return this.specularConstant;
    }

    public void setSpecularConstant(float specularConstant) {
        if (specularConstant < 0.0f || specularConstant > 2.0f) {
            throw new IllegalArgumentException("Specular constant must be in the range [0,2]");
        }
        float old = this.specularConstant;
        this.specularConstant = specularConstant;
        this.firePropertyChange("specularConstant", Float.valueOf(old), Float.valueOf(specularConstant));
    }

    public float getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(float specularExponent) {
        if (specularExponent < 0.0f || specularExponent > 40.0f) {
            throw new IllegalArgumentException("Specular exponent must be in the range [0,40]");
        }
        float old = this.specularExponent;
        this.specularExponent = specularExponent;
        this.firePropertyChange("specularExponent", Float.valueOf(old), Float.valueOf(specularExponent));
    }

    public float getSurfaceScale() {
        return this.surfaceScale;
    }

    public void setSurfaceScale(float surfaceScale) {
        if (surfaceScale < 0.0f || surfaceScale > 10.0f) {
            throw new IllegalArgumentException("Surface scale must be in the range [0,10]");
        }
        float old = this.surfaceScale;
        this.surfaceScale = surfaceScale;
        this.firePropertyChange("surfaceScale", Float.valueOf(old), Float.valueOf(surfaceScale));
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getContentInput().getBounds();
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        return this.filterInputs(config, true, 0, 1).getImage();
    }

    private class LightChangeListener
    implements PropertyChangeListener {
        private LightChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PhongLighting.this.firePropertyChange("light", null, PhongLighting.this.light);
        }
    }
}

