/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class InvertMask
extends Effect {
    private int pad;

    public InvertMask() {
        this(10, (Effect)new Source(true));
    }

    public InvertMask(int pad, Effect input) {
        super(input);
        this.setPad(pad);
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getPad() {
        return this.pad;
    }

    public void setPad(int pad) {
        if (pad < 0) {
            throw new IllegalArgumentException("Pad value must be non-negative");
        }
        int old = this.pad;
        this.pad = pad;
        this.firePropertyChange("pad", old, pad);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D r = this.getInputs().get(0).getBounds();
        int pad2 = 2 * this.pad;
        r.setFrame(r.getX() - (double)this.pad, r.getY() - (double)this.pad, r.getWidth() + (double)pad2, r.getHeight() + (double)pad2);
        return r;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        Rectangle fullBounds = this.getBounds().getBounds();
        int w = fullBounds.width;
        int h = fullBounds.height;
        Image dst = InvertMask.getCompatibleImage(config, w, h);
        Effect input = this.getInputs().get(0);
        Rectangle inputBounds = input.getBounds().getBounds();
        Image src = input.filter(config);
        int iw = inputBounds.width;
        int ih = inputBounds.height;
        int dx = this.pad;
        int dy = this.pad;
        int sx = 0;
        int sy = 0;
        Graphics2D gdst = (Graphics2D)dst.getGraphics();
        gdst.setColor(Color.WHITE);
        gdst.fillRect(0, 0, w, h);
        gdst.setComposite(AlphaComposite.DstOut);
        gdst.drawImage(src, dx, dy, dx + iw, dy + ih, sx, sy, sx + iw, sx + ih, null);
        gdst.dispose();
        return dst;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return Effect.AccelType.NONE;
    }
}

