/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Crop
extends Effect {
    public Crop() {
        this(new Source(true));
    }

    public Crop(Effect input) {
        super(input);
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D.Float r = new Rectangle2D.Float();
        if (this.getInputs().get(0).isInDeviceSpace()) {
            ((Rectangle2D)r).setRect(this.getSourceContent().getTransformedBounds());
        } else {
            ((Rectangle2D)r).setRect(this.getSourceContent().getUntransformedBounds());
        }
        return r;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        Rectangle fullBounds = this.getBounds().getBounds();
        int w = fullBounds.width;
        int h = fullBounds.height;
        Image dst = Crop.getCompatibleImage(config, w, h);
        Effect input = this.getInputs().get(0);
        Rectangle inputBounds = input.getBounds().getBounds();
        Image src = input.filter(config);
        int dx = 0;
        int dy = 0;
        int sx = fullBounds.x - inputBounds.x;
        int sy = fullBounds.y - inputBounds.y;
        Graphics2D gdst = (Graphics2D)dst.getGraphics();
        gdst.setComposite(AlphaComposite.Src);
        gdst.drawImage(src, dx, dy, dx + w, dy + h, sx, sy, sx + w, sx + h, null);
        gdst.dispose();
        return dst;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return Effect.AccelType.NONE;
    }
}

