/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Identity;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.ImageData;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;

abstract class CoreEffect
extends Effect {
    private String peerKey;
    private int peerCount = -1;
    private GraphicsConfiguration cachedConfig;
    private EffectPeer cachedPeer;

    CoreEffect() {
    }

    CoreEffect(Effect input) {
        super(input);
    }

    CoreEffect(Effect input1, Effect input2) {
        super(input1, input2);
    }

    final void updatePeerKey(String key) {
        this.updatePeerKey(key, -1);
    }

    final void updatePeerKey(String key, int unrollCount) {
        this.peerKey = key;
        this.peerCount = unrollCount;
        this.cachedPeer = null;
    }

    final EffectPeer getPeer(GraphicsConfiguration config) {
        if (config != this.cachedConfig || this.cachedPeer == null) {
            this.cachedPeer = EffectPeer.getInstance(config, this.peerKey, this.peerCount);
            this.cachedConfig = config;
        }
        return this.cachedPeer;
    }

    private ImageData getInputData(GraphicsConfiguration config, boolean transformed, int inputIndex) {
        Effect input = this.getInputs().get(inputIndex);
        Image img = input.filter(config, transformed);
        Rectangle bounds = transformed ? input.getTransformedBounds().getBounds() : input.getBounds().getBounds();
        bounds.setLocation(0, 0);
        return new ImageData(img, bounds);
    }

    ImageData filterInputs(GraphicsConfiguration config, int ... inputIndices) {
        return this.filterInputs(config, false, inputIndices);
    }

    ImageData filterInputs(GraphicsConfiguration config, boolean transformed, int ... inputIndices) {
        ImageData[] inputData = new ImageData[inputIndices.length];
        for (int i = 0; i < inputIndices.length; ++i) {
            inputData[i] = this.getInputData(config, transformed, inputIndices[i]);
        }
        EffectPeer peer = this.getPeer(config);
        ImageData res = peer.filter(this, inputData);
        for (int i = 0; i < inputIndices.length; ++i) {
            Effect input = this.getInputs().get(inputIndices[i]);
            if (input instanceof Source || input instanceof Identity) continue;
            CoreEffect.releaseCompatibleImage(config, inputData[i].getImage());
        }
        return res;
    }

    ImageData filterData(GraphicsConfiguration config, ImageData ... inputs) {
        EffectPeer peer = this.getPeer(config);
        ImageData res = peer.filter(this, inputs);
        for (ImageData input : inputs) {
            CoreEffect.releaseCompatibleImage(config, input.getImage());
        }
        return res;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        EffectPeer peer = this.getPeer(config);
        return peer.getAccelType();
    }
}

