/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class ColorAdjust
extends CoreEffect {
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float brightness = 0.0f;
    private float contrast = 1.0f;

    public ColorAdjust() {
        this(new Source(true));
    }

    public ColorAdjust(Effect input) {
        super(input);
        this.updatePeerKey("ColorAdjust");
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float hue) {
        if (hue < -1.0f || hue > 1.0f) {
            throw new IllegalArgumentException("Hue must be in the range [-1, 1]");
        }
        float old = this.hue;
        this.hue = hue;
        this.firePropertyChange("hue", Float.valueOf(old), Float.valueOf(hue));
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        if (saturation < -1.0f || saturation > 1.0f) {
            throw new IllegalArgumentException("Saturation must be in the range [-1, 1]");
        }
        float old = this.saturation;
        this.saturation = saturation;
        this.firePropertyChange("saturation", Float.valueOf(old), Float.valueOf(saturation));
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        if (brightness < -1.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("Brightness must be in the range [-1, 1]");
        }
        float old = this.brightness;
        this.brightness = brightness;
        this.firePropertyChange("brightness", Float.valueOf(old), Float.valueOf(brightness));
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float contrast) {
        if (contrast < 0.25f || contrast > 4.0f) {
            throw new IllegalArgumentException("Contrast must be in the range [0.25, 4]");
        }
        float old = this.contrast;
        this.contrast = contrast;
        this.firePropertyChange("contrast", Float.valueOf(old), Float.valueOf(contrast));
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getInputs().get(0).getBounds();
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        return this.filterInputs(config, 0).getImage();
    }
}

