/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.SourceContent;
import com.sun.scenario.effect.impl.state.BoxBlurState;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class BoxBlur
extends CoreEffect {
    private int r;
    private final BoxBlurState state = this.createState();

    public BoxBlur() {
        this(1);
    }

    public BoxBlur(int radius) {
        this(radius, (Effect)new Source(true));
    }

    public BoxBlur(int radius, Effect input) {
        super(input, new Source(true));
        this.setRadius(radius);
    }

    @Override
    Object getState() {
        return this.state;
    }

    BoxBlurState createState() {
        return new BoxBlurState(this);
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getRadius() {
        return this.r;
    }

    public void setRadius(int radius) {
        if (radius < 1 || radius > 64) {
            throw new IllegalArgumentException("Radius must be in the range [1,64]");
        }
        int old = this.r;
        this.r = radius;
        this.state.invalidateDeltas();
        this.firePropertyChange("radius", old, radius);
        this.updatePeer();
    }

    private void updatePeer() {
        int psize = 4 + this.r - this.r % 4;
        this.updatePeerKey("BoxBlur", psize);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getInputs().get(0).getBounds();
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        Rectangle bnd = this.getBounds().getBounds();
        this.state.updateDeltas((float)(1.0 / bnd.getWidth()), (float)(1.0 / bnd.getHeight()));
        Image res = Effect.getCompatibleImage(config, bnd.width, bnd.height);
        for (int i = -this.r; i <= this.r; ++i) {
            this.getInputs().get(1).setSourceContent(new SourceContent(res));
            this.state.setRow(i);
            Image tmp = this.filterInputs(config, 0, 1).getImage();
            BoxBlur.releaseCompatibleImage(config, res);
            res = tmp;
        }
        return res;
    }
}

