/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Brightpass;
import com.sun.scenario.effect.Crop;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.GaussianBlur;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.SourceContent;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class Bloom
extends Effect {
    private final Brightpass brightpass;
    private final GaussianBlur blur;
    private final Blend blend;

    public Bloom() {
        this(new Source(true));
    }

    public Bloom(Effect input) {
        super(input);
        this.brightpass = new Brightpass(input);
        this.blur = new GaussianBlur(10.0f, (Effect)this.brightpass);
        Crop crop = new Crop(this.blur);
        this.blend = new Blend(Blend.Mode.ADD, input, crop);
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
        this.brightpass.setInput(input);
        this.blend.setBottomInput(input);
    }

    public float getThreshold() {
        return this.brightpass.getThreshold();
    }

    public void setThreshold(float threshold) {
        float old = this.brightpass.getThreshold();
        this.brightpass.setThreshold(threshold);
        this.firePropertyChange("threshold", Float.valueOf(old), Float.valueOf(threshold));
    }

    @Override
    public void setSourceContent(SourceContent content) {
        super.setSourceContent(content);
        this.blend.setSourceContent(content);
    }

    @Override
    public int needsSourceContent() {
        return 2;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.blend.getBounds();
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        return this.blend.filter(config);
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return this.blend.getAccelType(config);
    }
}

