/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.ImageData;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public abstract class AbstractGaussian
extends CoreEffect {
    private float radius;
    private final String prefix;

    AbstractGaussian(String prefix, float radius, Effect input) {
        super(input);
        this.prefix = prefix;
        this.setRadius(radius);
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        if (radius < 1.0f || radius > 63.0f) {
            throw new IllegalArgumentException("Radius must be in the range [1,63]");
        }
        float old = this.radius;
        this.radius = radius;
        this.firePropertyChange("radius", Float.valueOf(old), Float.valueOf(radius));
        this.updatePeer();
    }

    private int getPad() {
        return (int)Math.ceil(this.getRadius());
    }

    private int getKernelSize() {
        int r = this.getPad();
        return r * 2 + 1;
    }

    private void updatePeer() {
        int ksize = this.getKernelSize();
        int psize = ksize + (10 - ksize % 10);
        this.updatePeerKey(this.prefix, psize);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D r = this.getInputs().get(0).getBounds();
        int pad = this.getPad();
        int pad2 = 2 * pad;
        r.setFrame(r.getX() - (double)pad, r.getY() - (double)pad, r.getWidth() + (double)pad2, r.getHeight() + (double)pad2);
        return r;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        EffectPeer peer = this.getPeer(config);
        peer.setPass(0);
        ImageData res0 = this.filterInputs(config, 0);
        peer.setPass(1);
        ImageData res1 = this.filterData(config, res0);
        return res1.getImage();
    }
}

