uniform float pixCoordYOffset;
vec2 pixcoord = vec2(gl_FragCoord.x, pixCoordYOffset-gl_FragCoord.y);
vec4 jsl_sample(sampler2D img, vec2 pos) {
    pos.y = 1.0 - pos.y;
    return texture2D(img, pos);
}
uniform sampler2D botImg;
uniform sampler2D topImg;
uniform float opacity;
vec4 blend_src_over(vec4 bot, vec4 top) {
return top + (bot * (1.0 - top.a));
}
vec4 blend_src_in(vec4 bot, vec4 top) {
return top * bot.a;
}
vec4 blend_src_out(vec4 bot, vec4 top) {
return top * (1.0 - bot.a);
}
vec4 blend_src_atop(vec4 bot, vec4 top) {
return (top * bot.a) + (bot * (1.0 - top.a));
}
vec4 blend_add(vec4 bot, vec4 top) {
return bot + top;
}
vec4 blend_multiply(vec4 bot, vec4 top) {
return bot * (top + 1.0 - top.a) + top * (1.0 - bot.a);
}
vec4 blend_screen(vec4 bot, vec4 top) {
return bot + top - bot * top;
}
vec4 blend_overlay(vec4 bot, vec4 top) {
vec4 res;
res.a = bot.a + top.a - bot.a * top.a;
vec3 mask = ceil(bot.rgb - bot.a * 0.5);
vec3 adjbot = abs(bot.rgb - mask * bot.a);
vec3 adjtop = abs(top.rgb - mask * top.a);
res.rgb = (2.0 * adjbot + 1.0 - bot.a) * adjtop + (1.0 - top.a) * adjbot;
res.rgb = abs(res.rgb - mask * res.a);
return res;
}
vec4 blend_darken(vec4 bot, vec4 top) {
vec4 res;
res.r = min(bot.r, top.r);
res.g = min(bot.g, top.g);
res.b = min(bot.b, top.b);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_lighten(vec4 bot, vec4 top) {
vec4 res;
res.r = max(bot.r, top.r);
res.g = max(bot.g, top.g);
res.b = max(bot.b, top.b);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_color_dodge(vec4 bot, vec4 top) {
vec4 res;
res.rgb = bot.rgb / (1.0 - top.rgb);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_color_burn(vec4 bot, vec4 top) {
vec4 res;
res.rgb = 1.0 - ((1.0 - bot.rgb) / top.rgb);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_hard_light(vec4 bot, vec4 top) {
vec3 lumCoeff = vec3(0.2125, 0.7154, 0.0721);
float lum = dot(top.rgb, lumCoeff);
vec4 res;
if (lum < 0.45){
res.rgb = 2.0 * top.rgb * bot.rgb;
}
 else if (lum > 0.55){
res.rgb = 1.0 - (2.0 * (1.0 - top.rgb) * (1.0 - bot.rgb));
}
 else {
vec3 res1 = 2.0 * top.rgb * bot.rgb;
vec3 res2 = 1.0 - (2.0 * (1.0 - top.rgb) * (1.0 - bot.rgb));
res.rgb = mix(res1, res2, (lum - 0.45) * 10.0);
}
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_soft_light(vec4 bot, vec4 top) {
vec4 res;
vec3 botsq = bot.rgb * bot.rgb;
res.rgb = (2.0 * bot.rgb * top.rgb) + botsq - (2.0 * botsq * top.rgb);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_difference(vec4 bot, vec4 top) {
vec4 res;
res.rgb = abs(bot.rgb - top.rgb);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_exclusion(vec4 bot, vec4 top) {
vec4 res;
res.rgb = top.rgb + bot.rgb - (2.0 * top.rgb * bot.rgb);
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_red(vec4 bot, vec4 top) {
vec4 res;
res.r = top.r;
res.gb = bot.gb;
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_green(vec4 bot, vec4 top) {
vec4 res;
res.g = top.g;
res.rb = bot.rb;
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
vec4 blend_blue(vec4 bot, vec4 top) {
vec4 res;
res.b = top.b;
res.rg = bot.rg;
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
void main() {
vec4 bot = jsl_sample(botImg, gl_TexCoord[0].st);
vec4 top = jsl_sample(topImg, gl_TexCoord[1].st) * opacity;
gl_FragColor = blend_hard_light(bot, top);
}
