/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.ogl;

import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.impl.hw.HWRenderer;
import com.sun.scenario.effect.impl.hw.Shader;
import com.sun.scenario.effect.impl.hw.Texture;
import com.sun.scenario.effect.impl.hw.ogl.DecTexture;
import com.sun.scenario.effect.impl.hw.ogl.J2DTexture;
import com.sun.scenario.effect.impl.hw.ogl.OGLShader;
import com.sun.scenario.effect.impl.hw.ogl.OGLTexture;
import java.awt.GraphicsConfiguration;
import java.awt.image.VolatileImage;
import java.io.InputStream;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLProfile;
import javax.media.opengl.glu.gl2.GLUgl2;
import sun.java2d.pipe.hw.AccelSurface;

public class OGLRenderer
extends HWRenderer {
    private GLUgl2 glu = new GLUgl2();
    private GLContext j2dContext;

    public OGLRenderer(GraphicsConfiguration config) {
        super(config);
    }

    public void enable() {
        if (this.j2dContext == null) {
            this.j2dContext = GLDrawableFactory.getFactory((GLProfile)GLProfile.get((String[])new String[]{"GL2"})).createExternalGLContext();
        }
        this.j2dContext.makeCurrent();
    }

    public void disable() {
        this.j2dContext.release();
    }

    private static InputStream getStream(String name) {
        return OGLRenderer.class.getResourceAsStream("glsl/" + name + ".glsl");
    }

    public Shader createShader(String name, Map<String, Integer> samplers, Map<String, Integer> params) {
        return OGLShader.create(OGLRenderer.getStream(name), samplers);
    }

    public Texture getTexture(VolatileImage vimg) {
        return J2DTexture.create(vimg);
    }

    public DecTexture createFloatTexture(int w, int h) {
        return DecTexture.createFloat(w, h);
    }

    public void updateFloatTexture(Object texture, FloatMap map) {
        DecTexture ftex = (DecTexture)texture;
        ftex.update(map);
    }

    public void setBlendMode(HWRenderer.BlendMode mode) {
        GL2 gl = GLUgl2.getCurrentGL2();
        switch (mode) {
            default: {
                gl.glDisable(3042);
                break;
            }
            case ADD: {
                gl.glEnable(3042);
                gl.glBlendFunc(1, 1);
            }
        }
    }

    public void drawQuad(AccelSurface dst, float dx1, float dy1, float dx2, float dy2) {
        GL2 gl = GLUgl2.getCurrentGL2();
        gl.glBegin(7);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glVertex2f(dx1, dy1);
        gl.glVertex2f(dx2, dy1);
        gl.glVertex2f(dx2, dy2);
        gl.glVertex2f(dx1, dy2);
        gl.glEnd();
    }

    public void drawTexture(AccelSurface dst, Texture src, boolean linear, float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2) {
        GL2 gl = GLUgl2.getCurrentGL2();
        OGLTexture oglsrc = (OGLTexture)src;
        int target = oglsrc.getTarget();
        int texid = oglsrc.getID();
        gl.glEnable(target);
        gl.glBindTexture(target, texid);
        int filter = linear ? 9729 : 9728;
        gl.glTexParameteri(target, 10242, 33069);
        gl.glTexParameteri(target, 10243, 33069);
        gl.glTexParameteri(target, 10241, filter);
        gl.glTexParameteri(target, 10240, filter);
        gl.glBegin(7);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glTexCoord2f(tx1, ty1);
        gl.glVertex2f(dx1, dy1);
        gl.glTexCoord2f(tx2, ty1);
        gl.glVertex2f(dx2, dy1);
        gl.glTexCoord2f(tx2, ty2);
        gl.glVertex2f(dx2, dy2);
        gl.glTexCoord2f(tx1, ty2);
        gl.glVertex2f(dx1, dy2);
        gl.glEnd();
        gl.glBindTexture(target, 0);
        gl.glDisable(target);
    }

    public void drawTexture(AccelSurface dst, Texture src1, boolean linear1, Texture src2, boolean linear2, float dx1, float dy1, float dx2, float dy2, float t1x1, float t1y1, float t1x2, float t1y2, float t2x1, float t2y1, float t2x2, float t2y2) {
        GL2 gl = GLUgl2.getCurrentGL2();
        OGLTexture oglSrc1 = (OGLTexture)src1;
        int target1 = oglSrc1.getTarget();
        int texid1 = oglSrc1.getID();
        OGLTexture oglSrc2 = (OGLTexture)src2;
        int target2 = oglSrc2.getTarget();
        int texid2 = oglSrc2.getID();
        gl.glActiveTexture(33984);
        gl.glEnable(target1);
        gl.glBindTexture(target1, texid1);
        int filter1 = linear1 ? 9729 : 9728;
        gl.glTexParameteri(target1, 10242, 33069);
        gl.glTexParameteri(target1, 10243, 33069);
        gl.glTexParameteri(target1, 10241, filter1);
        gl.glTexParameteri(target1, 10240, filter1);
        gl.glActiveTexture(33985);
        gl.glEnable(target2);
        gl.glBindTexture(target2, texid2);
        int filter2 = linear2 ? 9729 : 9728;
        gl.glTexParameteri(target2, 10242, 33069);
        gl.glTexParameteri(target2, 10243, 33069);
        gl.glTexParameteri(target2, 10241, filter2);
        gl.glTexParameteri(target2, 10240, filter2);
        gl.glBegin(7);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glMultiTexCoord2f(33984, t1x1, t1y1);
        gl.glMultiTexCoord2f(33985, t2x1, t2y1);
        gl.glVertex2f(dx1, dy1);
        gl.glMultiTexCoord2f(33984, t1x2, t1y1);
        gl.glMultiTexCoord2f(33985, t2x2, t2y1);
        gl.glVertex2f(dx2, dy1);
        gl.glMultiTexCoord2f(33984, t1x2, t1y2);
        gl.glMultiTexCoord2f(33985, t2x2, t2y2);
        gl.glVertex2f(dx2, dy2);
        gl.glMultiTexCoord2f(33984, t1x1, t1y2);
        gl.glMultiTexCoord2f(33985, t2x1, t2y2);
        gl.glVertex2f(dx1, dy2);
        gl.glEnd();
        gl.glActiveTexture(33985);
        gl.glBindTexture(target2, 0);
        gl.glDisable(target2);
        gl.glActiveTexture(33984);
        gl.glBindTexture(target1, 0);
        gl.glDisable(target1);
    }
}

