/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw;

import com.sun.scenario.effect.MotionBlur;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.hw.HWOneSamplerPeer;
import com.sun.scenario.effect.impl.hw.Shader;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class HWMotionBlur_50Peer
extends HWOneSamplerPeer {
    private FloatBuffer kvals;

    public HWMotionBlur_50Peer(GraphicsConfiguration gc) {
        super(gc);
    }

    protected final MotionBlur getEffect() {
        return (MotionBlur)super.getEffect();
    }

    private static int getPad(float radius) {
        return (int)Math.ceil(radius);
    }

    private int getKernelSize() {
        int r = HWMotionBlur_50Peer.getPad(this.getEffect().getRadius());
        return r * 2 + 1;
    }

    private FloatBuffer getKvals() {
        float radius = this.getEffect().getRadius();
        int r = HWMotionBlur_50Peer.getPad(radius);
        int klen = r * 2 + 1;
        Rectangle nb = this.getInputNativeBounds(0);
        float xoff = 1.0f / (float)nb.width;
        float yoff = 1.0f / (float)nb.height;
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer((int)508);
        }
        this.kvals.clear();
        float angle = this.getEffect().getAngle();
        float sina = (float)Math.sin(angle);
        float cosa = (float)Math.cos(angle);
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        for (int row = -r; row <= r; ++row) {
            float distance = (float)row * (float)row;
            float kval = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            float dx = cosa * (float)row;
            this.kvals.put(dx * xoff);
            float dy = sina * (float)row;
            this.kvals.put(-dy * yoff);
            this.kvals.put(kval);
            this.kvals.put(0.0f);
            total += kval;
        }
        for (int i = 2; i < klen * 4; i += 4) {
            this.kvals.put(i, this.kvals.get(i) / total);
        }
        this.kvals.rewind();
        return this.kvals;
    }

    protected float[] getSourceRegion(int inputIndex) {
        if (this.getPass() != 0) {
            throw new InternalError();
        }
        Rectangle b = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float pad = HWMotionBlur_50Peer.getPad(this.getEffect().getRadius());
        float x1 = (float)b.x - pad;
        float y1 = (float)b.y - pad;
        float x2 = (float)(b.x + b.width) + pad;
        float y2 = (float)(b.y + b.height) + pad;
        float tx1 = x1 / (float)nb.width;
        float ty1 = y1 / (float)nb.height;
        float tx2 = x2 / (float)nb.width;
        float ty2 = y2 / (float)nb.height;
        return new float[]{tx1, ty1, tx2, ty2};
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            default: 
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("baseImg", 0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("kernelSize", 127);
        params.put("kvals", 0);
        return this.getRenderer().createShader("MotionBlur_50", samplers, params);
    }

    @Override
    protected void updateShader(Shader shader) {
        if (shader.getClass().getSimpleName().startsWith("OGL")) {
            float yoff = this.getDestNativeBounds().height;
            shader.setConstant("pixCoordYOffset", yoff);
        }
        shader.setConstant("kernelSize", this.getKernelSize());
        shader.setConstants("kvals", this.getKvals(), 0, 127);
    }
}

