/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw;

import com.sun.scenario.effect.ColorAdjust;
import com.sun.scenario.effect.impl.hw.HWOneSamplerPeer;
import com.sun.scenario.effect.impl.hw.Shader;
import java.awt.GraphicsConfiguration;
import java.util.HashMap;

public class HWColorAdjustPeer
extends HWOneSamplerPeer {
    public HWColorAdjustPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    protected final ColorAdjust getEffect() {
        return (ColorAdjust)super.getEffect();
    }

    private float getHue() {
        return this.getEffect().getHue() / 2.0f;
    }

    private float getSaturation() {
        return this.getEffect().getSaturation() + 1.0f;
    }

    private float getBrightness() {
        return this.getEffect().getBrightness() + 1.0f;
    }

    private float getContrast() {
        return this.getEffect().getContrast();
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            default: 
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("baseImg", 0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("contrast", 3);
        params.put("brightness", 2);
        params.put("saturation", 1);
        params.put("hue", 0);
        return this.getRenderer().createShader("ColorAdjust", samplers, params);
    }

    @Override
    protected void updateShader(Shader shader) {
        if (shader.getClass().getSimpleName().startsWith("OGL")) {
            float yoff = this.getDestNativeBounds().height;
            shader.setConstant("pixCoordYOffset", yoff);
        }
        shader.setConstant("contrast", this.getContrast());
        shader.setConstant("brightness", this.getBrightness());
        shader.setConstant("saturation", this.getSaturation());
        shader.setConstant("hue", this.getHue());
    }
}

