(ns ^:no-doc user
  (:require [google-apis.auth.service-account :refer [get-bearer-token]]
            [google-apis.v4.internal.scopes :refer [sheet-scopes]]
            [google-apis.v4.sheets :refer [get-sheet get-tab-names]]
            [cheshire.core :as json]
            [environ.core :refer [env]]))


(comment

;; Get credentials w/ Google Service Api json
(def credentials (clojure.edn/read-string (env :google)))


(def creds (credentials :creds))
(def api-key (credentials :api-key))

(assert)

(def bt (get-bearer-token sheet-scopes creds))



  (get-sheet {:creds {:api-key api-key
                      :bearer  bt}
              :query {:sheets-id      "1gQ1v4mHKkeOboytf4witE70Izusk_39AoMhsccBqtp4"
                      :sheet-tab-name "Munkalap1"
                      :range-of       ["A1" "C1"]
                      :from-response  [:body :headers :status]
                      }})

  (get-tab-names {:creds {:api-key api-key
                          :bearer  bt}
                  :query {:sheets-id "1gQ1v4mHKkeOboytf4witE70Izusk_39AoMhsccBqtp4"}})

  )
