(defproject sbaader/google-apis "0.1.0-SNAPSHOT"
  :description "Clojure/script access for Google Api [under development]"
  :url "https://github.com/damesek/google-apis"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.0"]
                 [ring "1.8.0"]
                 [gapi "1.0.2"]
                 [cheshire "5.10.0"]
                 [com.cemerick/url "0.1.1"]
                 [clj-jwt "0.1.1"]
                 [clj-time "0.15.2"]
                 [clj-http "3.12.0"]
                 [org.clojure/data.csv "1.0.0"]
                 [tick "0.4.29-alpha"]
                 [clojure.java-time "0.3.1"]
                 [environ "1.2.0"]]
  :source-paths ["src"
                 "dev"]
  :plugins [[lein-codox "0.10.7"]]
  :codox {:source-paths ["src/"]
          :metadata {:doc/format :markdown}
          :output-path "codox"}
  :deploy-repositories {"releases" {:url "https://repo.clojars.org" :sign-releases false}}
  :repl-options {:init-ns google-apis.core})
