// Compiled by ClojureScript 1.7.48 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');

figwheel.client.file_reloading.all_QMARK_ = (function figwheel$client$file_reloading$all_QMARK_(pred,coll){
return cljs.core.reduce.call(null,(function (p1__34022_SHARP_,p2__34023_SHARP_){
var and__17347__auto__ = p1__34022_SHARP_;
if(cljs.core.truth_(and__17347__auto__)){
return p2__34023_SHARP_;
} else {
return and__17347__auto__;
}
}),true,cljs.core.map.call(null,pred,coll));
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__17359__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__17359__auto__){
return or__17359__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.ns_to_js_file = (function figwheel$client$file_reloading$ns_to_js_file(ns){

return [cljs.core.str(clojure.string.replace.call(null,ns,".","/")),cljs.core.str(".js")].join('');
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){

return [cljs.core.str(figwheel.client.utils.base_url_path.call(null)),cljs.core.str(figwheel.client.file_reloading.ns_to_js_file.call(null,ns))].join('');
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
goog.isProvided = (function (x){
return false;
});

if(((cljs.core._STAR_loaded_libs_STAR_ == null)) || (cljs.core.empty_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_))){
cljs.core._STAR_loaded_libs_STAR_ = (function (){var gntp = goog.dependencies_.nameToPath;
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,((function (gntp){
return (function (name){
return (goog.dependencies_.visited[(gntp[name])]);
});})(gntp))
,cljs.core.js_keys.call(null,gntp)));
})();
} else {
}

goog.require = (function (name,reload){
if(cljs.core.truth_((function (){var or__17359__auto__ = !(cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,name));
if(or__17359__auto__){
return or__17359__auto__;
} else {
return reload;
}
})())){
cljs.core._STAR_loaded_libs_STAR_ = cljs.core.conj.call(null,(function (){var or__17359__auto__ = cljs.core._STAR_loaded_libs_STAR_;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),name);

return figwheel.client.file_reloading.reload_file_STAR_.call(null,figwheel.client.file_reloading.resolve_ns.call(null,name));
} else {
return null;
}
});

goog.provide = goog.exportPath_;

return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.reload_file_STAR_;
});
if(typeof figwheel.client.file_reloading.resolve_url !== 'undefined'){
} else {
figwheel.client.file_reloading.resolve_url = (function (){var method_table__18253__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__18254__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__18255__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__18256__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__18257__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","resolve-url"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__18257__auto__,method_table__18253__auto__,prefer_table__18254__auto__,method_cache__18255__auto__,cached_hierarchy__18256__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__34042){
var map__34043 = p__34042;
var map__34043__$1 = ((((!((map__34043 == null)))?((((map__34043.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34043.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34043):map__34043);
var file = cljs.core.get.call(null,map__34043__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
return file;
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"namespace","namespace",-377510372),(function (p__34045){
var map__34046 = p__34045;
var map__34046__$1 = ((((!((map__34046 == null)))?((((map__34046.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34046.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34046):map__34046);
var namespace = cljs.core.get.call(null,map__34046__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

return figwheel.client.file_reloading.resolve_ns.call(null,namespace);
}));
if(typeof figwheel.client.file_reloading.reload_base !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_base = (function (){var method_table__18253__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__18254__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__18255__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__18256__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__18257__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","reload-base"),figwheel.client.utils.host_env_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__18257__auto__,method_table__18253__auto__,prefer_table__18254__auto__,method_cache__18255__auto__,cached_hierarchy__18256__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"node","node",581201198),(function (request_url,callback){

var root = clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.drop.call(null,(2),cljs.core.reverse.call(null,clojure.string.split.call(null,__dirname,"/")))));
var path = [cljs.core.str(root),cljs.core.str("/"),cljs.core.str(request_url)].join('');
(require.cache[path] = null);

return callback.call(null,(function (){try{return require(path);
}catch (e34049){if((e34049 instanceof Error)){
var e = e34049;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34049;

}
}})());
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"html","html",-998796897),(function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
}));
figwheel.client.file_reloading.reload_file_STAR_ = (function figwheel$client$file_reloading$reload_file_STAR_(){
var args34054 = [];
var len__18398__auto___34057 = arguments.length;
var i__18399__auto___34058 = (0);
while(true){
if((i__18399__auto___34058 < len__18398__auto___34057)){
args34054.push((arguments[i__18399__auto___34058]));

var G__34059 = (i__18399__auto___34058 + (1));
i__18399__auto___34058 = G__34059;
continue;
} else {
}
break;
}

var G__34056 = args34054.length;
switch (G__34056) {
case 2:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34054.length)].join('')));

}
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (request_url,callback){
return figwheel.client.file_reloading.reload_base.call(null,request_url,callback);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (request_url){
return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,cljs.core.identity);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__34061,callback){
var map__34064 = p__34061;
var map__34064__$1 = ((((!((map__34064 == null)))?((((map__34064.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34064.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34064):map__34064);
var file_msg = map__34064__$1;
var request_url = cljs.core.get.call(null,map__34064__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__34064,map__34064__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfullly loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__34064,map__34064__$1,file_msg,request_url))
);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__34066){
var map__34072 = p__34066;
var map__34072__$1 = ((((!((map__34072 == null)))?((((map__34072.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34072.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34072):map__34072);
var file_msg = map__34072__$1;
var namespace = cljs.core.get.call(null,map__34072__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,map__34072__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));

var meta_data__$1 = (function (){var or__17359__auto__ = meta_data;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var and__17347__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_data__$1));
if(and__17347__auto__){
var or__17359__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
var or__17359__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__17359__auto____$1)){
return or__17359__auto____$1;
} else {
var and__17347__auto____$1 = cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,namespace);
if(and__17347__auto____$1){
var or__17359__auto____$2 = !(cljs.core.contains_QMARK_.call(null,meta_data__$1,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932)));
if(or__17359__auto____$2){
return or__17359__auto____$2;
} else {
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
}
} else {
return and__17347__auto____$1;
}
}
}
} else {
return and__17347__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__34085,callback){
var map__34088 = p__34085;
var map__34088__$1 = ((((!((map__34088 == null)))?((((map__34088.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34088.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34088):map__34088);
var file_msg = map__34088__$1;
var request_url = cljs.core.get.call(null,map__34088__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__34088__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.reload_file.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
setTimeout(((function (out){
return (function (){
return figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
figwheel.client.file_reloading.patch_goog_base.call(null);

cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
});})(out))
,(0));

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__21281__auto___34183 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___34183,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___34183,out){
return (function (state_34162){
var state_val_34163 = (state_34162[(1)]);
if((state_val_34163 === (1))){
var inst_34139 = cljs.core.nth.call(null,files,(0),null);
var inst_34140 = cljs.core.nthnext.call(null,files,(1));
var inst_34142 = files;
var state_34162__$1 = (function (){var statearr_34164 = state_34162;
(statearr_34164[(7)] = inst_34142);

(statearr_34164[(8)] = inst_34139);

(statearr_34164[(9)] = inst_34140);

return statearr_34164;
})();
var statearr_34165_34184 = state_34162__$1;
(statearr_34165_34184[(2)] = null);

(statearr_34165_34184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34163 === (2))){
var inst_34145 = (state_34162[(10)]);
var inst_34142 = (state_34162[(7)]);
var inst_34145__$1 = cljs.core.nth.call(null,inst_34142,(0),null);
var inst_34146 = cljs.core.nthnext.call(null,inst_34142,(1));
var inst_34147 = (inst_34145__$1 == null);
var inst_34148 = cljs.core.not.call(null,inst_34147);
var state_34162__$1 = (function (){var statearr_34166 = state_34162;
(statearr_34166[(10)] = inst_34145__$1);

(statearr_34166[(11)] = inst_34146);

return statearr_34166;
})();
if(inst_34148){
var statearr_34167_34185 = state_34162__$1;
(statearr_34167_34185[(1)] = (4));

} else {
var statearr_34168_34187 = state_34162__$1;
(statearr_34168_34187[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34163 === (3))){
var inst_34160 = (state_34162[(2)]);
var state_34162__$1 = state_34162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34162__$1,inst_34160);
} else {
if((state_val_34163 === (4))){
var inst_34145 = (state_34162[(10)]);
var inst_34150 = figwheel.client.file_reloading.reload_js_file.call(null,inst_34145);
var state_34162__$1 = state_34162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34162__$1,(7),inst_34150);
} else {
if((state_val_34163 === (5))){
var inst_34156 = cljs.core.async.close_BANG_.call(null,out);
var state_34162__$1 = state_34162;
var statearr_34169_34188 = state_34162__$1;
(statearr_34169_34188[(2)] = inst_34156);

(statearr_34169_34188[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34163 === (6))){
var inst_34158 = (state_34162[(2)]);
var state_34162__$1 = state_34162;
var statearr_34170_34189 = state_34162__$1;
(statearr_34170_34189[(2)] = inst_34158);

(statearr_34170_34189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34163 === (7))){
var inst_34146 = (state_34162[(11)]);
var inst_34152 = (state_34162[(2)]);
var inst_34153 = cljs.core.async.put_BANG_.call(null,out,inst_34152);
var inst_34142 = inst_34146;
var state_34162__$1 = (function (){var statearr_34171 = state_34162;
(statearr_34171[(7)] = inst_34142);

(statearr_34171[(12)] = inst_34153);

return statearr_34171;
})();
var statearr_34172_34190 = state_34162__$1;
(statearr_34172_34190[(2)] = null);

(statearr_34172_34190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__21281__auto___34183,out))
;
return ((function (switch__21216__auto__,c__21281__auto___34183,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto____0 = (function (){
var statearr_34176 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34176[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto__);

(statearr_34176[(1)] = (1));

return statearr_34176;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto____1 = (function (state_34162){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_34162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e34180){if((e34180 instanceof Object)){
var ex__21220__auto__ = e34180;
var statearr_34181_34191 = state_34162;
(statearr_34181_34191[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34162);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34192 = state_34162;
state_34162 = G__34192;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto__ = function(state_34162){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto____1.call(this,state_34162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___34183,out))
})();
var state__21283__auto__ = (function (){var statearr_34182 = f__21282__auto__.call(null);
(statearr_34182[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___34183);

return statearr_34182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___34183,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.add_request_url = (function figwheel$client$file_reloading$add_request_url(p__34193,p__34194){
var map__34199 = p__34193;
var map__34199__$1 = ((((!((map__34199 == null)))?((((map__34199.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34199.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34199):map__34199);
var opts = map__34199__$1;
var url_rewriter = cljs.core.get.call(null,map__34199__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838));
var map__34200 = p__34194;
var map__34200__$1 = ((((!((map__34200 == null)))?((((map__34200.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34200.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34200):map__34200);
var file_msg = map__34200__$1;
var file = cljs.core.get.call(null,map__34200__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var resolved_path = figwheel.client.file_reloading.resolve_url.call(null,file_msg);
return cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"request-url","request-url",2100346596),(cljs.core.truth_(url_rewriter)?url_rewriter.call(null,resolved_path):resolved_path));
});
figwheel.client.file_reloading.add_request_urls = (function figwheel$client$file_reloading$add_request_urls(opts,files){
return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.file_reloading.add_request_url,opts),files);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__34203){
var map__34207 = p__34203;
var map__34207__$1 = ((((!((map__34207 == null)))?((((map__34207.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34207.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34207):map__34207);
var eval_body__$1 = cljs.core.get.call(null,map__34207__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__34207__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__17347__auto__ = eval_body__$1;
if(cljs.core.truth_(and__17347__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__17347__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return eval(code);
}catch (e34209){var e = e34209;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__34214,p__34215){
var map__34450 = p__34214;
var map__34450__$1 = ((((!((map__34450 == null)))?((((map__34450.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34450.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34450):map__34450);
var opts = map__34450__$1;
var before_jsload = cljs.core.get.call(null,map__34450__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__34450__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var load_unchanged_files = cljs.core.get.call(null,map__34450__$1,new cljs.core.Keyword(null,"load-unchanged-files","load-unchanged-files",-1561468704));
var map__34451 = p__34215;
var map__34451__$1 = ((((!((map__34451 == null)))?((((map__34451.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34451.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34451):map__34451);
var msg = map__34451__$1;
var files = cljs.core.get.call(null,map__34451__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var c__21281__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (state_34591){
var state_val_34592 = (state_34591[(1)]);
if((state_val_34592 === (7))){
var inst_34467 = (state_34591[(7)]);
var inst_34464 = (state_34591[(8)]);
var inst_34466 = (state_34591[(9)]);
var inst_34465 = (state_34591[(10)]);
var inst_34472 = cljs.core._nth.call(null,inst_34465,inst_34467);
var inst_34473 = figwheel.client.file_reloading.eval_body.call(null,inst_34472);
var inst_34474 = (inst_34467 + (1));
var tmp34593 = inst_34464;
var tmp34594 = inst_34466;
var tmp34595 = inst_34465;
var inst_34464__$1 = tmp34593;
var inst_34465__$1 = tmp34595;
var inst_34466__$1 = tmp34594;
var inst_34467__$1 = inst_34474;
var state_34591__$1 = (function (){var statearr_34597 = state_34591;
(statearr_34597[(7)] = inst_34467__$1);

(statearr_34597[(8)] = inst_34464__$1);

(statearr_34597[(9)] = inst_34466__$1);

(statearr_34597[(11)] = inst_34473);

(statearr_34597[(10)] = inst_34465__$1);

return statearr_34597;
})();
var statearr_34598_34680 = state_34591__$1;
(statearr_34598_34680[(2)] = null);

(statearr_34598_34680[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (20))){
var inst_34513 = (state_34591[(12)]);
var inst_34514 = (state_34591[(13)]);
var inst_34509 = (state_34591[(14)]);
var inst_34510 = (state_34591[(15)]);
var inst_34516 = (state_34591[(16)]);
var inst_34519 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34521 = (function (){var all_files = inst_34509;
var files_SINGLEQUOTE_ = inst_34510;
var res_SINGLEQUOTE_ = inst_34513;
var res = inst_34514;
var files_not_loaded = inst_34516;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_34513,inst_34514,inst_34509,inst_34510,inst_34516,inst_34519,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (p__34520){
var map__34599 = p__34520;
var map__34599__$1 = ((((!((map__34599 == null)))?((((map__34599.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34599.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34599):map__34599);
var namespace = cljs.core.get.call(null,map__34599__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34599__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.ns_to_js_file.call(null,namespace);
} else {
return file;
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_34513,inst_34514,inst_34509,inst_34510,inst_34516,inst_34519,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34522 = cljs.core.map.call(null,inst_34521,inst_34514);
var inst_34523 = cljs.core.pr_str.call(null,inst_34522);
var inst_34524 = figwheel.client.utils.log.call(null,inst_34523);
var inst_34525 = (function (){var all_files = inst_34509;
var files_SINGLEQUOTE_ = inst_34510;
var res_SINGLEQUOTE_ = inst_34513;
var res = inst_34514;
var files_not_loaded = inst_34516;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_34513,inst_34514,inst_34509,inst_34510,inst_34516,inst_34519,inst_34521,inst_34522,inst_34523,inst_34524,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (){
return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_34513,inst_34514,inst_34509,inst_34510,inst_34516,inst_34519,inst_34521,inst_34522,inst_34523,inst_34524,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34526 = setTimeout(inst_34525,(10));
var state_34591__$1 = (function (){var statearr_34601 = state_34591;
(statearr_34601[(17)] = inst_34524);

(statearr_34601[(18)] = inst_34519);

return statearr_34601;
})();
var statearr_34602_34686 = state_34591__$1;
(statearr_34602_34686[(2)] = inst_34526);

(statearr_34602_34686[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (27))){
var state_34591__$1 = state_34591;
var statearr_34603_34687 = state_34591__$1;
(statearr_34603_34687[(2)] = false);

(statearr_34603_34687[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (1))){
var inst_34456 = (state_34591[(19)]);
var inst_34454 = before_jsload.call(null,files);
var inst_34455 = (function (){return ((function (inst_34456,inst_34454,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (p1__34210_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34210_SHARP_);
});
;})(inst_34456,inst_34454,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34456__$1 = cljs.core.filter.call(null,inst_34455,files);
var inst_34457 = cljs.core.not_empty.call(null,inst_34456__$1);
var state_34591__$1 = (function (){var statearr_34604 = state_34591;
(statearr_34604[(20)] = inst_34454);

(statearr_34604[(19)] = inst_34456__$1);

return statearr_34604;
})();
if(cljs.core.truth_(inst_34457)){
var statearr_34605_34688 = state_34591__$1;
(statearr_34605_34688[(1)] = (2));

} else {
var statearr_34606_34689 = state_34591__$1;
(statearr_34606_34689[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (24))){
var state_34591__$1 = state_34591;
var statearr_34607_34690 = state_34591__$1;
(statearr_34607_34690[(2)] = null);

(statearr_34607_34690[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (39))){
var state_34591__$1 = state_34591;
var statearr_34608_34691 = state_34591__$1;
(statearr_34608_34691[(2)] = null);

(statearr_34608_34691[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (4))){
var inst_34501 = (state_34591[(2)]);
var inst_34502 = (function (){return ((function (inst_34501,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (p1__34211_SHARP_){
var and__17347__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34211_SHARP_);
if(cljs.core.truth_(and__17347__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34211_SHARP_));
} else {
return and__17347__auto__;
}
});
;})(inst_34501,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34503 = cljs.core.filter.call(null,inst_34502,files);
var state_34591__$1 = (function (){var statearr_34609 = state_34591;
(statearr_34609[(21)] = inst_34503);

(statearr_34609[(22)] = inst_34501);

return statearr_34609;
})();
if(cljs.core.truth_(load_unchanged_files)){
var statearr_34610_34692 = state_34591__$1;
(statearr_34610_34692[(1)] = (16));

} else {
var statearr_34611_34693 = state_34591__$1;
(statearr_34611_34693[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (15))){
var inst_34491 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
var statearr_34612_34694 = state_34591__$1;
(statearr_34612_34694[(2)] = inst_34491);

(statearr_34612_34694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (21))){
var state_34591__$1 = state_34591;
var statearr_34613_34695 = state_34591__$1;
(statearr_34613_34695[(2)] = null);

(statearr_34613_34695[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (31))){
var inst_34548 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
var statearr_34614_34696 = state_34591__$1;
(statearr_34614_34696[(2)] = inst_34548);

(statearr_34614_34696[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (32))){
var inst_34536 = (state_34591[(23)]);
var inst_34553 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34536);
var state_34591__$1 = state_34591;
var statearr_34615_34697 = state_34591__$1;
(statearr_34615_34697[(2)] = inst_34553);

(statearr_34615_34697[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (40))){
var inst_34559 = (state_34591[(24)]);
var inst_34577 = (state_34591[(2)]);
var inst_34578 = cljs.core.not_empty.call(null,inst_34559);
var state_34591__$1 = (function (){var statearr_34616 = state_34591;
(statearr_34616[(25)] = inst_34577);

return statearr_34616;
})();
if(cljs.core.truth_(inst_34578)){
var statearr_34617_34698 = state_34591__$1;
(statearr_34617_34698[(1)] = (41));

} else {
var statearr_34618_34699 = state_34591__$1;
(statearr_34618_34699[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (33))){
var inst_34536 = (state_34591[(23)]);
var state_34591__$1 = state_34591;
var statearr_34619_34700 = state_34591__$1;
(statearr_34619_34700[(2)] = inst_34536);

(statearr_34619_34700[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (13))){
var inst_34477 = (state_34591[(26)]);
var inst_34481 = cljs.core.chunk_first.call(null,inst_34477);
var inst_34482 = cljs.core.chunk_rest.call(null,inst_34477);
var inst_34483 = cljs.core.count.call(null,inst_34481);
var inst_34464 = inst_34482;
var inst_34465 = inst_34481;
var inst_34466 = inst_34483;
var inst_34467 = (0);
var state_34591__$1 = (function (){var statearr_34620 = state_34591;
(statearr_34620[(7)] = inst_34467);

(statearr_34620[(8)] = inst_34464);

(statearr_34620[(9)] = inst_34466);

(statearr_34620[(10)] = inst_34465);

return statearr_34620;
})();
var statearr_34621_34701 = state_34591__$1;
(statearr_34621_34701[(2)] = null);

(statearr_34621_34701[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (22))){
var inst_34516 = (state_34591[(16)]);
var inst_34529 = (state_34591[(2)]);
var inst_34530 = cljs.core.not_empty.call(null,inst_34516);
var state_34591__$1 = (function (){var statearr_34622 = state_34591;
(statearr_34622[(27)] = inst_34529);

return statearr_34622;
})();
if(cljs.core.truth_(inst_34530)){
var statearr_34623_34702 = state_34591__$1;
(statearr_34623_34702[(1)] = (23));

} else {
var statearr_34624_34703 = state_34591__$1;
(statearr_34624_34703[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (36))){
var state_34591__$1 = state_34591;
var statearr_34625_34704 = state_34591__$1;
(statearr_34625_34704[(2)] = null);

(statearr_34625_34704[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (41))){
var inst_34559 = (state_34591[(24)]);
var inst_34580 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34559);
var inst_34581 = cljs.core.pr_str.call(null,inst_34580);
var inst_34582 = [cljs.core.str("not required: "),cljs.core.str(inst_34581)].join('');
var inst_34583 = figwheel.client.utils.log.call(null,inst_34582);
var state_34591__$1 = state_34591;
var statearr_34626_34705 = state_34591__$1;
(statearr_34626_34705[(2)] = inst_34583);

(statearr_34626_34705[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (43))){
var inst_34586 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
var statearr_34627_34706 = state_34591__$1;
(statearr_34627_34706[(2)] = inst_34586);

(statearr_34627_34706[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (29))){
var state_34591__$1 = state_34591;
var statearr_34628_34707 = state_34591__$1;
(statearr_34628_34707[(2)] = true);

(statearr_34628_34707[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (6))){
var inst_34498 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
var statearr_34629_34710 = state_34591__$1;
(statearr_34629_34710[(2)] = inst_34498);

(statearr_34629_34710[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (28))){
var inst_34551 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
if(cljs.core.truth_(inst_34551)){
var statearr_34630_34712 = state_34591__$1;
(statearr_34630_34712[(1)] = (32));

} else {
var statearr_34631_34714 = state_34591__$1;
(statearr_34631_34714[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (25))){
var inst_34589 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34591__$1,inst_34589);
} else {
if((state_val_34592 === (34))){
var inst_34557 = (state_34591[(28)]);
var inst_34556 = (state_34591[(2)]);
var inst_34557__$1 = cljs.core.get.call(null,inst_34556,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34558 = cljs.core.get.call(null,inst_34556,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
var inst_34559 = cljs.core.get.call(null,inst_34556,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34560 = cljs.core.not_empty.call(null,inst_34557__$1);
var state_34591__$1 = (function (){var statearr_34632 = state_34591;
(statearr_34632[(29)] = inst_34558);

(statearr_34632[(24)] = inst_34559);

(statearr_34632[(28)] = inst_34557__$1);

return statearr_34632;
})();
if(cljs.core.truth_(inst_34560)){
var statearr_34633_34718 = state_34591__$1;
(statearr_34633_34718[(1)] = (35));

} else {
var statearr_34634_34719 = state_34591__$1;
(statearr_34634_34719[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (17))){
var inst_34503 = (state_34591[(21)]);
var state_34591__$1 = state_34591;
var statearr_34635_34720 = state_34591__$1;
(statearr_34635_34720[(2)] = inst_34503);

(statearr_34635_34720[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (3))){
var state_34591__$1 = state_34591;
var statearr_34636_34721 = state_34591__$1;
(statearr_34636_34721[(2)] = null);

(statearr_34636_34721[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (12))){
var inst_34494 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
var statearr_34637_34722 = state_34591__$1;
(statearr_34637_34722[(2)] = inst_34494);

(statearr_34637_34722[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (2))){
var inst_34456 = (state_34591[(19)]);
var inst_34463 = cljs.core.seq.call(null,inst_34456);
var inst_34464 = inst_34463;
var inst_34465 = null;
var inst_34466 = (0);
var inst_34467 = (0);
var state_34591__$1 = (function (){var statearr_34638 = state_34591;
(statearr_34638[(7)] = inst_34467);

(statearr_34638[(8)] = inst_34464);

(statearr_34638[(9)] = inst_34466);

(statearr_34638[(10)] = inst_34465);

return statearr_34638;
})();
var statearr_34639_34724 = state_34591__$1;
(statearr_34639_34724[(2)] = null);

(statearr_34639_34724[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (23))){
var inst_34513 = (state_34591[(12)]);
var inst_34514 = (state_34591[(13)]);
var inst_34509 = (state_34591[(14)]);
var inst_34536 = (state_34591[(23)]);
var inst_34510 = (state_34591[(15)]);
var inst_34516 = (state_34591[(16)]);
var inst_34532 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34535 = (function (){var all_files = inst_34509;
var files_SINGLEQUOTE_ = inst_34510;
var res_SINGLEQUOTE_ = inst_34513;
var res = inst_34514;
var files_not_loaded = inst_34516;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_34513,inst_34514,inst_34509,inst_34536,inst_34510,inst_34516,inst_34532,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (p__34534){
var map__34640 = p__34534;
var map__34640__$1 = ((((!((map__34640 == null)))?((((map__34640.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34640.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34640):map__34640);
var meta_data = cljs.core.get.call(null,map__34640__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
if((cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932))) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data)))){
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_34513,inst_34514,inst_34509,inst_34536,inst_34510,inst_34516,inst_34532,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34536__$1 = cljs.core.group_by.call(null,inst_34535,inst_34516);
var inst_34538 = (inst_34536__$1 == null);
var inst_34539 = cljs.core.not.call(null,inst_34538);
var state_34591__$1 = (function (){var statearr_34642 = state_34591;
(statearr_34642[(23)] = inst_34536__$1);

(statearr_34642[(30)] = inst_34532);

return statearr_34642;
})();
if(inst_34539){
var statearr_34643_34725 = state_34591__$1;
(statearr_34643_34725[(1)] = (26));

} else {
var statearr_34644_34726 = state_34591__$1;
(statearr_34644_34726[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (35))){
var inst_34557 = (state_34591[(28)]);
var inst_34562 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34557);
var inst_34563 = cljs.core.pr_str.call(null,inst_34562);
var inst_34564 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_34563)].join('');
var inst_34565 = figwheel.client.utils.log.call(null,inst_34564);
var state_34591__$1 = state_34591;
var statearr_34645_34727 = state_34591__$1;
(statearr_34645_34727[(2)] = inst_34565);

(statearr_34645_34727[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (19))){
var inst_34513 = (state_34591[(12)]);
var inst_34514 = (state_34591[(13)]);
var inst_34509 = (state_34591[(14)]);
var inst_34510 = (state_34591[(15)]);
var inst_34513__$1 = (state_34591[(2)]);
var inst_34514__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34513__$1);
var inst_34515 = (function (){var all_files = inst_34509;
var files_SINGLEQUOTE_ = inst_34510;
var res_SINGLEQUOTE_ = inst_34513__$1;
var res = inst_34514__$1;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_34513,inst_34514,inst_34509,inst_34510,inst_34513__$1,inst_34514__$1,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (p1__34213_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__34213_SHARP_));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_34513,inst_34514,inst_34509,inst_34510,inst_34513__$1,inst_34514__$1,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34516 = cljs.core.filter.call(null,inst_34515,inst_34513__$1);
var inst_34517 = cljs.core.not_empty.call(null,inst_34514__$1);
var state_34591__$1 = (function (){var statearr_34646 = state_34591;
(statearr_34646[(12)] = inst_34513__$1);

(statearr_34646[(13)] = inst_34514__$1);

(statearr_34646[(16)] = inst_34516);

return statearr_34646;
})();
if(cljs.core.truth_(inst_34517)){
var statearr_34647_34728 = state_34591__$1;
(statearr_34647_34728[(1)] = (20));

} else {
var statearr_34648_34729 = state_34591__$1;
(statearr_34648_34729[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (11))){
var state_34591__$1 = state_34591;
var statearr_34649_34730 = state_34591__$1;
(statearr_34649_34730[(2)] = null);

(statearr_34649_34730[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (9))){
var inst_34496 = (state_34591[(2)]);
var state_34591__$1 = state_34591;
var statearr_34650_34731 = state_34591__$1;
(statearr_34650_34731[(2)] = inst_34496);

(statearr_34650_34731[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (5))){
var inst_34467 = (state_34591[(7)]);
var inst_34466 = (state_34591[(9)]);
var inst_34469 = (inst_34467 < inst_34466);
var inst_34470 = inst_34469;
var state_34591__$1 = state_34591;
if(cljs.core.truth_(inst_34470)){
var statearr_34651_34732 = state_34591__$1;
(statearr_34651_34732[(1)] = (7));

} else {
var statearr_34652_34733 = state_34591__$1;
(statearr_34652_34733[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (14))){
var inst_34477 = (state_34591[(26)]);
var inst_34486 = cljs.core.first.call(null,inst_34477);
var inst_34487 = figwheel.client.file_reloading.eval_body.call(null,inst_34486);
var inst_34488 = cljs.core.next.call(null,inst_34477);
var inst_34464 = inst_34488;
var inst_34465 = null;
var inst_34466 = (0);
var inst_34467 = (0);
var state_34591__$1 = (function (){var statearr_34653 = state_34591;
(statearr_34653[(7)] = inst_34467);

(statearr_34653[(8)] = inst_34464);

(statearr_34653[(9)] = inst_34466);

(statearr_34653[(31)] = inst_34487);

(statearr_34653[(10)] = inst_34465);

return statearr_34653;
})();
var statearr_34654_34734 = state_34591__$1;
(statearr_34654_34734[(2)] = null);

(statearr_34654_34734[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (26))){
var inst_34536 = (state_34591[(23)]);
var inst_34541 = inst_34536.cljs$lang$protocol_mask$partition0$;
var inst_34542 = (inst_34541 & (64));
var inst_34543 = inst_34536.cljs$core$ISeq$;
var inst_34544 = (inst_34542) || (inst_34543);
var state_34591__$1 = state_34591;
if(cljs.core.truth_(inst_34544)){
var statearr_34655_34737 = state_34591__$1;
(statearr_34655_34737[(1)] = (29));

} else {
var statearr_34656_34738 = state_34591__$1;
(statearr_34656_34738[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (16))){
var inst_34503 = (state_34591[(21)]);
var inst_34505 = (function (){var all_files = inst_34503;
return ((function (all_files,inst_34503,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function (p1__34212_SHARP_){
return cljs.core.update_in.call(null,p1__34212_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157)], null),cljs.core.dissoc,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
});
;})(all_files,inst_34503,state_val_34592,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var inst_34506 = cljs.core.map.call(null,inst_34505,inst_34503);
var state_34591__$1 = state_34591;
var statearr_34657_34741 = state_34591__$1;
(statearr_34657_34741[(2)] = inst_34506);

(statearr_34657_34741[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (38))){
var inst_34558 = (state_34591[(29)]);
var inst_34571 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34558);
var inst_34572 = cljs.core.pr_str.call(null,inst_34571);
var inst_34573 = [cljs.core.str("file didn't change: "),cljs.core.str(inst_34572)].join('');
var inst_34574 = figwheel.client.utils.log.call(null,inst_34573);
var state_34591__$1 = state_34591;
var statearr_34658_34745 = state_34591__$1;
(statearr_34658_34745[(2)] = inst_34574);

(statearr_34658_34745[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (30))){
var state_34591__$1 = state_34591;
var statearr_34659_34746 = state_34591__$1;
(statearr_34659_34746[(2)] = false);

(statearr_34659_34746[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (10))){
var inst_34477 = (state_34591[(26)]);
var inst_34479 = cljs.core.chunked_seq_QMARK_.call(null,inst_34477);
var state_34591__$1 = state_34591;
if(inst_34479){
var statearr_34660_34747 = state_34591__$1;
(statearr_34660_34747[(1)] = (13));

} else {
var statearr_34661_34748 = state_34591__$1;
(statearr_34661_34748[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (18))){
var inst_34509 = (state_34591[(14)]);
var inst_34510 = (state_34591[(15)]);
var inst_34509__$1 = (state_34591[(2)]);
var inst_34510__$1 = figwheel.client.file_reloading.add_request_urls.call(null,opts,inst_34509__$1);
var inst_34511 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34510__$1);
var state_34591__$1 = (function (){var statearr_34662 = state_34591;
(statearr_34662[(14)] = inst_34509__$1);

(statearr_34662[(15)] = inst_34510__$1);

return statearr_34662;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34591__$1,(19),inst_34511);
} else {
if((state_val_34592 === (42))){
var state_34591__$1 = state_34591;
var statearr_34663_34749 = state_34591__$1;
(statearr_34663_34749[(2)] = null);

(statearr_34663_34749[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (37))){
var inst_34558 = (state_34591[(29)]);
var inst_34568 = (state_34591[(2)]);
var inst_34569 = cljs.core.not_empty.call(null,inst_34558);
var state_34591__$1 = (function (){var statearr_34664 = state_34591;
(statearr_34664[(32)] = inst_34568);

return statearr_34664;
})();
if(cljs.core.truth_(inst_34569)){
var statearr_34665_34751 = state_34591__$1;
(statearr_34665_34751[(1)] = (38));

} else {
var statearr_34666_34752 = state_34591__$1;
(statearr_34666_34752[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34592 === (8))){
var inst_34464 = (state_34591[(8)]);
var inst_34477 = (state_34591[(26)]);
var inst_34477__$1 = cljs.core.seq.call(null,inst_34464);
var state_34591__$1 = (function (){var statearr_34667 = state_34591;
(statearr_34667[(26)] = inst_34477__$1);

return statearr_34667;
})();
if(inst_34477__$1){
var statearr_34668_34753 = state_34591__$1;
(statearr_34668_34753[(1)] = (10));

} else {
var statearr_34669_34754 = state_34591__$1;
(statearr_34669_34754[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
;
return ((function (switch__21216__auto__,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto____0 = (function (){
var statearr_34673 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34673[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto__);

(statearr_34673[(1)] = (1));

return statearr_34673;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto____1 = (function (state_34591){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_34591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e34674){if((e34674 instanceof Object)){
var ex__21220__auto__ = e34674;
var statearr_34675_34755 = state_34591;
(statearr_34675_34755[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34591);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34674;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34756 = state_34591;
state_34591 = G__34756;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto__ = function(state_34591){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto____1.call(this,state_34591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
})();
var state__21283__auto__ = (function (){var statearr_34676 = f__21282__auto__.call(null);
(statearr_34676[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto__);

return statearr_34676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto__,map__34450,map__34450__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__34451,map__34451__$1,msg,files))
);

return c__21281__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34759,link){
var map__34762 = p__34759;
var map__34762__$1 = ((((!((map__34762 == null)))?((((map__34762.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34762.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34762):map__34762);
var file = cljs.core.get.call(null,map__34762__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__34762,map__34762__$1,file){
return (function (p1__34757_SHARP_,p2__34758_SHARP_){
if(cljs.core._EQ_.call(null,p1__34757_SHARP_,p2__34758_SHARP_)){
return p1__34757_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__34762,map__34762__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34768){
var map__34769 = p__34768;
var map__34769__$1 = ((((!((map__34769 == null)))?((((map__34769.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34769.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34769):map__34769);
var match_length = cljs.core.get.call(null,map__34769__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34769__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34764_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34764_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(){
var args34778 = [];
var len__18398__auto___34781 = arguments.length;
var i__18399__auto___34782 = (0);
while(true){
if((i__18399__auto___34782 < len__18398__auto___34781)){
args34778.push((arguments[i__18399__auto___34782]));

var G__34783 = (i__18399__auto___34782 + (1));
i__18399__auto___34782 = G__34783;
continue;
} else {
}
break;
}

var G__34780 = args34778.length;
switch (G__34780) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34778.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__34786){
var map__34789 = p__34786;
var map__34789__$1 = ((((!((map__34789 == null)))?((((map__34789.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34789.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34789):map__34789);
var f_data = map__34789__$1;
var file = cljs.core.get.call(null,map__34789__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var request_url = cljs.core.get.call(null,map__34789__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var temp__4423__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4423__auto__)){
var link = temp__4423__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return figwheel.client.file_reloading.add_link_to_doc.call(null,figwheel.client.file_reloading.create_link.call(null,(function (){var or__17359__auto__ = request_url;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return file;
}
})()));
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34791,files_msg){
var map__34814 = p__34791;
var map__34814__$1 = ((((!((map__34814 == null)))?((((map__34814.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34814.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34814):map__34814);
var opts = map__34814__$1;
var on_cssload = cljs.core.get.call(null,map__34814__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__34816_34836 = cljs.core.seq.call(null,figwheel.client.file_reloading.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__34817_34837 = null;
var count__34818_34838 = (0);
var i__34819_34839 = (0);
while(true){
if((i__34819_34839 < count__34818_34838)){
var f_34840 = cljs.core._nth.call(null,chunk__34817_34837,i__34819_34839);
figwheel.client.file_reloading.reload_css_file.call(null,f_34840);

var G__34841 = seq__34816_34836;
var G__34842 = chunk__34817_34837;
var G__34843 = count__34818_34838;
var G__34844 = (i__34819_34839 + (1));
seq__34816_34836 = G__34841;
chunk__34817_34837 = G__34842;
count__34818_34838 = G__34843;
i__34819_34839 = G__34844;
continue;
} else {
var temp__4425__auto___34845 = cljs.core.seq.call(null,seq__34816_34836);
if(temp__4425__auto___34845){
var seq__34816_34846__$1 = temp__4425__auto___34845;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34816_34846__$1)){
var c__18143__auto___34847 = cljs.core.chunk_first.call(null,seq__34816_34846__$1);
var G__34848 = cljs.core.chunk_rest.call(null,seq__34816_34846__$1);
var G__34849 = c__18143__auto___34847;
var G__34850 = cljs.core.count.call(null,c__18143__auto___34847);
var G__34851 = (0);
seq__34816_34836 = G__34848;
chunk__34817_34837 = G__34849;
count__34818_34838 = G__34850;
i__34819_34839 = G__34851;
continue;
} else {
var f_34852 = cljs.core.first.call(null,seq__34816_34846__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_34852);

var G__34853 = cljs.core.next.call(null,seq__34816_34846__$1);
var G__34854 = null;
var G__34855 = (0);
var G__34856 = (0);
seq__34816_34836 = G__34853;
chunk__34817_34837 = G__34854;
count__34818_34838 = G__34855;
i__34819_34839 = G__34856;
continue;
}
} else {
}
}
break;
}

var c__21281__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto__,map__34814,map__34814__$1,opts,on_cssload){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto__,map__34814,map__34814__$1,opts,on_cssload){
return (function (state_34826){
var state_val_34827 = (state_34826[(1)]);
if((state_val_34827 === (1))){
var inst_34820 = cljs.core.async.timeout.call(null,(100));
var state_34826__$1 = state_34826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34826__$1,(2),inst_34820);
} else {
if((state_val_34827 === (2))){
var inst_34822 = (state_34826[(2)]);
var inst_34823 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg);
var inst_34824 = on_cssload.call(null,inst_34823);
var state_34826__$1 = (function (){var statearr_34828 = state_34826;
(statearr_34828[(7)] = inst_34822);

return statearr_34828;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34826__$1,inst_34824);
} else {
return null;
}
}
});})(c__21281__auto__,map__34814,map__34814__$1,opts,on_cssload))
;
return ((function (switch__21216__auto__,c__21281__auto__,map__34814,map__34814__$1,opts,on_cssload){
return (function() {
var figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto__ = null;
var figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto____0 = (function (){
var statearr_34832 = [null,null,null,null,null,null,null,null];
(statearr_34832[(0)] = figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto__);

(statearr_34832[(1)] = (1));

return statearr_34832;
});
var figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto____1 = (function (state_34826){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_34826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e34833){if((e34833 instanceof Object)){
var ex__21220__auto__ = e34833;
var statearr_34834_34857 = state_34826;
(statearr_34834_34857[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34833;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34858 = state_34826;
state_34826 = G__34858;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto__ = function(state_34826){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto____1.call(this,state_34826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto____0;
figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto____1;
return figwheel$client$file_reloading$reload_css_files_$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto__,map__34814,map__34814__$1,opts,on_cssload))
})();
var state__21283__auto__ = (function (){var statearr_34835 = f__21282__auto__.call(null);
(statearr_34835[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto__);

return statearr_34835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto__,map__34814,map__34814__$1,opts,on_cssload))
);

return c__21281__auto__;
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1439917880057