// Compiled by ClojureScript 1.7.48 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__26164_26168 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__26165_26169 = null;
var count__26166_26170 = (0);
var i__26167_26171 = (0);
while(true){
if((i__26167_26171 < count__26166_26170)){
var k_26172 = cljs.core._nth.call(null,chunk__26165_26169,i__26167_26171);
var v_26173 = (b[k_26172]);
(a[k_26172] = v_26173);

var G__26174 = seq__26164_26168;
var G__26175 = chunk__26165_26169;
var G__26176 = count__26166_26170;
var G__26177 = (i__26167_26171 + (1));
seq__26164_26168 = G__26174;
chunk__26165_26169 = G__26175;
count__26166_26170 = G__26176;
i__26167_26171 = G__26177;
continue;
} else {
var temp__4425__auto___26178 = cljs.core.seq.call(null,seq__26164_26168);
if(temp__4425__auto___26178){
var seq__26164_26179__$1 = temp__4425__auto___26178;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26164_26179__$1)){
var c__18143__auto___26180 = cljs.core.chunk_first.call(null,seq__26164_26179__$1);
var G__26181 = cljs.core.chunk_rest.call(null,seq__26164_26179__$1);
var G__26182 = c__18143__auto___26180;
var G__26183 = cljs.core.count.call(null,c__18143__auto___26180);
var G__26184 = (0);
seq__26164_26168 = G__26181;
chunk__26165_26169 = G__26182;
count__26166_26170 = G__26183;
i__26167_26171 = G__26184;
continue;
} else {
var k_26185 = cljs.core.first.call(null,seq__26164_26179__$1);
var v_26186 = (b[k_26185]);
(a[k_26185] = v_26186);

var G__26187 = cljs.core.next.call(null,seq__26164_26179__$1);
var G__26188 = null;
var G__26189 = (0);
var G__26190 = (0);
seq__26164_26168 = G__26187;
chunk__26165_26169 = G__26188;
count__26166_26170 = G__26189;
i__26167_26171 = G__26190;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(){
var args26191 = [];
var len__18398__auto___26194 = arguments.length;
var i__18399__auto___26195 = (0);
while(true){
if((i__18399__auto___26195 < len__18398__auto___26194)){
args26191.push((arguments[i__18399__auto___26195]));

var G__26196 = (i__18399__auto___26195 + (1));
i__18399__auto___26195 = G__26196;
continue;
} else {
}
break;
}

var G__26193 = args26191.length;
switch (G__26193) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26191.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__26198 = (i + (2));
var G__26199 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__26198;
ret = G__26199;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__26200_26204 = cljs.core.seq.call(null,v);
var chunk__26201_26205 = null;
var count__26202_26206 = (0);
var i__26203_26207 = (0);
while(true){
if((i__26203_26207 < count__26202_26206)){
var x_26208 = cljs.core._nth.call(null,chunk__26201_26205,i__26203_26207);
ret.push(x_26208);

var G__26209 = seq__26200_26204;
var G__26210 = chunk__26201_26205;
var G__26211 = count__26202_26206;
var G__26212 = (i__26203_26207 + (1));
seq__26200_26204 = G__26209;
chunk__26201_26205 = G__26210;
count__26202_26206 = G__26211;
i__26203_26207 = G__26212;
continue;
} else {
var temp__4425__auto___26213 = cljs.core.seq.call(null,seq__26200_26204);
if(temp__4425__auto___26213){
var seq__26200_26214__$1 = temp__4425__auto___26213;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26200_26214__$1)){
var c__18143__auto___26215 = cljs.core.chunk_first.call(null,seq__26200_26214__$1);
var G__26216 = cljs.core.chunk_rest.call(null,seq__26200_26214__$1);
var G__26217 = c__18143__auto___26215;
var G__26218 = cljs.core.count.call(null,c__18143__auto___26215);
var G__26219 = (0);
seq__26200_26204 = G__26216;
chunk__26201_26205 = G__26217;
count__26202_26206 = G__26218;
i__26203_26207 = G__26219;
continue;
} else {
var x_26220 = cljs.core.first.call(null,seq__26200_26214__$1);
ret.push(x_26220);

var G__26221 = cljs.core.next.call(null,seq__26200_26214__$1);
var G__26222 = null;
var G__26223 = (0);
var G__26224 = (0);
seq__26200_26204 = G__26221;
chunk__26201_26205 = G__26222;
count__26202_26206 = G__26223;
i__26203_26207 = G__26224;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__26225_26229 = cljs.core.seq.call(null,v);
var chunk__26226_26230 = null;
var count__26227_26231 = (0);
var i__26228_26232 = (0);
while(true){
if((i__26228_26232 < count__26227_26231)){
var x_26233 = cljs.core._nth.call(null,chunk__26226_26230,i__26228_26232);
ret.push(x_26233);

var G__26234 = seq__26225_26229;
var G__26235 = chunk__26226_26230;
var G__26236 = count__26227_26231;
var G__26237 = (i__26228_26232 + (1));
seq__26225_26229 = G__26234;
chunk__26226_26230 = G__26235;
count__26227_26231 = G__26236;
i__26228_26232 = G__26237;
continue;
} else {
var temp__4425__auto___26238 = cljs.core.seq.call(null,seq__26225_26229);
if(temp__4425__auto___26238){
var seq__26225_26239__$1 = temp__4425__auto___26238;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26225_26239__$1)){
var c__18143__auto___26240 = cljs.core.chunk_first.call(null,seq__26225_26239__$1);
var G__26241 = cljs.core.chunk_rest.call(null,seq__26225_26239__$1);
var G__26242 = c__18143__auto___26240;
var G__26243 = cljs.core.count.call(null,c__18143__auto___26240);
var G__26244 = (0);
seq__26225_26229 = G__26241;
chunk__26226_26230 = G__26242;
count__26227_26231 = G__26243;
i__26228_26232 = G__26244;
continue;
} else {
var x_26245 = cljs.core.first.call(null,seq__26225_26239__$1);
ret.push(x_26245);

var G__26246 = cljs.core.next.call(null,seq__26225_26239__$1);
var G__26247 = null;
var G__26248 = (0);
var G__26249 = (0);
seq__26225_26229 = G__26246;
chunk__26226_26230 = G__26247;
count__26227_26231 = G__26248;
i__26228_26232 = G__26249;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__26250_26254 = cljs.core.seq.call(null,v);
var chunk__26251_26255 = null;
var count__26252_26256 = (0);
var i__26253_26257 = (0);
while(true){
if((i__26253_26257 < count__26252_26256)){
var x_26258 = cljs.core._nth.call(null,chunk__26251_26255,i__26253_26257);
ret.push(x_26258);

var G__26259 = seq__26250_26254;
var G__26260 = chunk__26251_26255;
var G__26261 = count__26252_26256;
var G__26262 = (i__26253_26257 + (1));
seq__26250_26254 = G__26259;
chunk__26251_26255 = G__26260;
count__26252_26256 = G__26261;
i__26253_26257 = G__26262;
continue;
} else {
var temp__4425__auto___26263 = cljs.core.seq.call(null,seq__26250_26254);
if(temp__4425__auto___26263){
var seq__26250_26264__$1 = temp__4425__auto___26263;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26250_26264__$1)){
var c__18143__auto___26265 = cljs.core.chunk_first.call(null,seq__26250_26264__$1);
var G__26266 = cljs.core.chunk_rest.call(null,seq__26250_26264__$1);
var G__26267 = c__18143__auto___26265;
var G__26268 = cljs.core.count.call(null,c__18143__auto___26265);
var G__26269 = (0);
seq__26250_26254 = G__26266;
chunk__26251_26255 = G__26267;
count__26252_26256 = G__26268;
i__26253_26257 = G__26269;
continue;
} else {
var x_26270 = cljs.core.first.call(null,seq__26250_26264__$1);
ret.push(x_26270);

var G__26271 = cljs.core.next.call(null,seq__26250_26264__$1);
var G__26272 = null;
var G__26273 = (0);
var G__26274 = (0);
seq__26250_26254 = G__26271;
chunk__26251_26255 = G__26272;
count__26252_26256 = G__26273;
i__26253_26257 = G__26274;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 * opts is a map containing a :handlers entry. :handlers is a map of
 * type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(){
var args26275 = [];
var len__18398__auto___26286 = arguments.length;
var i__18399__auto___26287 = (0);
while(true){
if((i__18399__auto___26287 < len__18398__auto___26286)){
args26275.push((arguments[i__18399__auto___26287]));

var G__26288 = (i__18399__auto___26287 + (1));
i__18399__auto___26287 = G__26288;
continue;
} else {
}
break;
}

var G__26277 = args26275.length;
switch (G__26277) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26275.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__26278 = obj;
G__26278.push(kfn.call(null,k),vfn.call(null,v));

return G__26278;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x26279 = cljs.core.clone.call(null,handlers);
x26279.forEach = ((function (x26279,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__26280 = cljs.core.seq.call(null,coll);
var chunk__26281 = null;
var count__26282 = (0);
var i__26283 = (0);
while(true){
if((i__26283 < count__26282)){
var vec__26284 = cljs.core._nth.call(null,chunk__26281,i__26283);
var k = cljs.core.nth.call(null,vec__26284,(0),null);
var v = cljs.core.nth.call(null,vec__26284,(1),null);
f.call(null,v,k);

var G__26290 = seq__26280;
var G__26291 = chunk__26281;
var G__26292 = count__26282;
var G__26293 = (i__26283 + (1));
seq__26280 = G__26290;
chunk__26281 = G__26291;
count__26282 = G__26292;
i__26283 = G__26293;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__26280);
if(temp__4425__auto__){
var seq__26280__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26280__$1)){
var c__18143__auto__ = cljs.core.chunk_first.call(null,seq__26280__$1);
var G__26294 = cljs.core.chunk_rest.call(null,seq__26280__$1);
var G__26295 = c__18143__auto__;
var G__26296 = cljs.core.count.call(null,c__18143__auto__);
var G__26297 = (0);
seq__26280 = G__26294;
chunk__26281 = G__26295;
count__26282 = G__26296;
i__26283 = G__26297;
continue;
} else {
var vec__26285 = cljs.core.first.call(null,seq__26280__$1);
var k = cljs.core.nth.call(null,vec__26285,(0),null);
var v = cljs.core.nth.call(null,vec__26285,(1),null);
f.call(null,v,k);

var G__26298 = cljs.core.next.call(null,seq__26280__$1);
var G__26299 = null;
var G__26300 = (0);
var G__26301 = (0);
seq__26280 = G__26298;
chunk__26281 = G__26299;
count__26282 = G__26300;
i__26283 = G__26301;
continue;
}
} else {
return null;
}
}
break;
}
});})(x26279,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x26279;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(){
var args26302 = [];
var len__18398__auto___26308 = arguments.length;
var i__18399__auto___26309 = (0);
while(true){
if((i__18399__auto___26309 < len__18398__auto___26308)){
args26302.push((arguments[i__18399__auto___26309]));

var G__26310 = (i__18399__auto___26309 + (1));
i__18399__auto___26309 = G__26310;
continue;
} else {
}
break;
}

var G__26304 = args26302.length;
switch (G__26304) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26302.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t26305 !== 'undefined'){
} else {

/**
* @constructor
*/
cognitect.transit.t26305 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta26306){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta26306 = meta26306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t26305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26307,meta26306__$1){
var self__ = this;
var _26307__$1 = this;
return (new cognitect.transit.t26305(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta26306__$1));
});

cognitect.transit.t26305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26307){
var self__ = this;
var _26307__$1 = this;
return self__.meta26306;
});

cognitect.transit.t26305.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t26305.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t26305.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t26305.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t26305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta26306","meta26306",-1338026241,null)], null);
});

cognitect.transit.t26305.cljs$lang$type = true;

cognitect.transit.t26305.cljs$lang$ctorStr = "cognitect.transit/t26305";

cognitect.transit.t26305.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cognitect.transit/t26305");
});

cognitect.transit.__GT_t26305 = (function cognitect$transit$__GT_t26305(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta26306){
return (new cognitect.transit.t26305(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta26306));
});

}

return (new cognitect.transit.t26305(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 * in the 53bit integer range, a goog.math.Long instance if above. s
 * may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.integer.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 * range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
return com.cognitect.transit.types.isUUID.call(null,x);
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map?rel=1439917870793