// Compiled by ClojureScript 1.7.48 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t27773 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t27773 = (function (fn_handler,f,meta27774){
this.fn_handler = fn_handler;
this.f = f;
this.meta27774 = meta27774;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t27773.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27775,meta27774__$1){
var self__ = this;
var _27775__$1 = this;
return (new cljs.core.async.t27773(self__.fn_handler,self__.f,meta27774__$1));
});

cljs.core.async.t27773.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27775){
var self__ = this;
var _27775__$1 = this;
return self__.meta27774;
});

cljs.core.async.t27773.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t27773.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t27773.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t27773.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta27774","meta27774",865721440,null)], null);
});

cljs.core.async.t27773.cljs$lang$type = true;

cljs.core.async.t27773.cljs$lang$ctorStr = "cljs.core.async/t27773";

cljs.core.async.t27773.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t27773");
});

cljs.core.async.__GT_t27773 = (function cljs$core$async$fn_handler_$___GT_t27773(fn_handler__$1,f__$1,meta27774){
return (new cljs.core.async.t27773(fn_handler__$1,f__$1,meta27774));
});

}

return (new cljs.core.async.t27773(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args27778 = [];
var len__18398__auto___27781 = arguments.length;
var i__18399__auto___27782 = (0);
while(true){
if((i__18399__auto___27782 < len__18398__auto___27781)){
args27778.push((arguments[i__18399__auto___27782]));

var G__27783 = (i__18399__auto___27782 + (1));
i__18399__auto___27782 = G__27783;
continue;
} else {
}
break;
}

var G__27780 = args27778.length;
switch (G__27780) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27778.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args27785 = [];
var len__18398__auto___27788 = arguments.length;
var i__18399__auto___27789 = (0);
while(true){
if((i__18399__auto___27789 < len__18398__auto___27788)){
args27785.push((arguments[i__18399__auto___27789]));

var G__27790 = (i__18399__auto___27789 + (1));
i__18399__auto___27789 = G__27790;
continue;
} else {
}
break;
}

var G__27787 = args27785.length;
switch (G__27787) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27785.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_27792 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_27792);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_27792,ret){
return (function (){
return fn1.call(null,val_27792);
});})(val_27792,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args27793 = [];
var len__18398__auto___27796 = arguments.length;
var i__18399__auto___27797 = (0);
while(true){
if((i__18399__auto___27797 < len__18398__auto___27796)){
args27793.push((arguments[i__18399__auto___27797]));

var G__27798 = (i__18399__auto___27797 + (1));
i__18399__auto___27797 = G__27798;
continue;
} else {
}
break;
}

var G__27795 = args27793.length;
switch (G__27795) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27793.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__18243__auto___27800 = n;
var x_27801 = (0);
while(true){
if((x_27801 < n__18243__auto___27800)){
(a[x_27801] = (0));

var G__27802 = (x_27801 + (1));
x_27801 = G__27802;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__27803 = (i + (1));
i = G__27803;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t27807 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t27807 = (function (alt_flag,flag,meta27808){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta27808 = meta27808;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t27807.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_27809,meta27808__$1){
var self__ = this;
var _27809__$1 = this;
return (new cljs.core.async.t27807(self__.alt_flag,self__.flag,meta27808__$1));
});})(flag))
;

cljs.core.async.t27807.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_27809){
var self__ = this;
var _27809__$1 = this;
return self__.meta27808;
});})(flag))
;

cljs.core.async.t27807.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t27807.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t27807.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t27807.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta27808","meta27808",-1790735873,null)], null);
});})(flag))
;

cljs.core.async.t27807.cljs$lang$type = true;

cljs.core.async.t27807.cljs$lang$ctorStr = "cljs.core.async/t27807";

cljs.core.async.t27807.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t27807");
});})(flag))
;

cljs.core.async.__GT_t27807 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t27807(alt_flag__$1,flag__$1,meta27808){
return (new cljs.core.async.t27807(alt_flag__$1,flag__$1,meta27808));
});})(flag))
;

}

return (new cljs.core.async.t27807(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t27813 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t27813 = (function (alt_handler,flag,cb,meta27814){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta27814 = meta27814;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t27813.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27815,meta27814__$1){
var self__ = this;
var _27815__$1 = this;
return (new cljs.core.async.t27813(self__.alt_handler,self__.flag,self__.cb,meta27814__$1));
});

cljs.core.async.t27813.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27815){
var self__ = this;
var _27815__$1 = this;
return self__.meta27814;
});

cljs.core.async.t27813.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t27813.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t27813.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t27813.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta27814","meta27814",1399379752,null)], null);
});

cljs.core.async.t27813.cljs$lang$type = true;

cljs.core.async.t27813.cljs$lang$ctorStr = "cljs.core.async/t27813";

cljs.core.async.t27813.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t27813");
});

cljs.core.async.__GT_t27813 = (function cljs$core$async$alt_handler_$___GT_t27813(alt_handler__$1,flag__$1,cb__$1,meta27814){
return (new cljs.core.async.t27813(alt_handler__$1,flag__$1,cb__$1,meta27814));
});

}

return (new cljs.core.async.t27813(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27816_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27816_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27817_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27817_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__17359__auto__ = wport;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return port;
}
})()], null));
} else {
var G__27818 = (i + (1));
i = G__27818;
continue;
}
} else {
return null;
}
break;
}
})();
var or__17359__auto__ = ret;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__17347__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__17347__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__17347__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__18405__auto__ = [];
var len__18398__auto___27824 = arguments.length;
var i__18399__auto___27825 = (0);
while(true){
if((i__18399__auto___27825 < len__18398__auto___27824)){
args__18405__auto__.push((arguments[i__18399__auto___27825]));

var G__27826 = (i__18399__auto___27825 + (1));
i__18399__auto___27825 = G__27826;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__27821){
var map__27822 = p__27821;
var map__27822__$1 = ((((!((map__27822 == null)))?((((map__27822.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27822.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27822):map__27822);
var opts = map__27822__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq27819){
var G__27820 = cljs.core.first.call(null,seq27819);
var seq27819__$1 = cljs.core.next.call(null,seq27819);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27820,seq27819__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args27827 = [];
var len__18398__auto___27877 = arguments.length;
var i__18399__auto___27878 = (0);
while(true){
if((i__18399__auto___27878 < len__18398__auto___27877)){
args27827.push((arguments[i__18399__auto___27878]));

var G__27879 = (i__18399__auto___27878 + (1));
i__18399__auto___27878 = G__27879;
continue;
} else {
}
break;
}

var G__27829 = args27827.length;
switch (G__27829) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27827.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__21281__auto___27881 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___27881){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___27881){
return (function (state_27853){
var state_val_27854 = (state_27853[(1)]);
if((state_val_27854 === (7))){
var inst_27849 = (state_27853[(2)]);
var state_27853__$1 = state_27853;
var statearr_27855_27882 = state_27853__$1;
(statearr_27855_27882[(2)] = inst_27849);

(statearr_27855_27882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (1))){
var state_27853__$1 = state_27853;
var statearr_27856_27883 = state_27853__$1;
(statearr_27856_27883[(2)] = null);

(statearr_27856_27883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (4))){
var inst_27832 = (state_27853[(7)]);
var inst_27832__$1 = (state_27853[(2)]);
var inst_27833 = (inst_27832__$1 == null);
var state_27853__$1 = (function (){var statearr_27857 = state_27853;
(statearr_27857[(7)] = inst_27832__$1);

return statearr_27857;
})();
if(cljs.core.truth_(inst_27833)){
var statearr_27858_27884 = state_27853__$1;
(statearr_27858_27884[(1)] = (5));

} else {
var statearr_27859_27885 = state_27853__$1;
(statearr_27859_27885[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (13))){
var state_27853__$1 = state_27853;
var statearr_27860_27886 = state_27853__$1;
(statearr_27860_27886[(2)] = null);

(statearr_27860_27886[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (6))){
var inst_27832 = (state_27853[(7)]);
var state_27853__$1 = state_27853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27853__$1,(11),to,inst_27832);
} else {
if((state_val_27854 === (3))){
var inst_27851 = (state_27853[(2)]);
var state_27853__$1 = state_27853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27853__$1,inst_27851);
} else {
if((state_val_27854 === (12))){
var state_27853__$1 = state_27853;
var statearr_27861_27887 = state_27853__$1;
(statearr_27861_27887[(2)] = null);

(statearr_27861_27887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (2))){
var state_27853__$1 = state_27853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27853__$1,(4),from);
} else {
if((state_val_27854 === (11))){
var inst_27842 = (state_27853[(2)]);
var state_27853__$1 = state_27853;
if(cljs.core.truth_(inst_27842)){
var statearr_27862_27888 = state_27853__$1;
(statearr_27862_27888[(1)] = (12));

} else {
var statearr_27863_27889 = state_27853__$1;
(statearr_27863_27889[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (9))){
var state_27853__$1 = state_27853;
var statearr_27864_27890 = state_27853__$1;
(statearr_27864_27890[(2)] = null);

(statearr_27864_27890[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (5))){
var state_27853__$1 = state_27853;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27865_27891 = state_27853__$1;
(statearr_27865_27891[(1)] = (8));

} else {
var statearr_27866_27892 = state_27853__$1;
(statearr_27866_27892[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (14))){
var inst_27847 = (state_27853[(2)]);
var state_27853__$1 = state_27853;
var statearr_27867_27893 = state_27853__$1;
(statearr_27867_27893[(2)] = inst_27847);

(statearr_27867_27893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (10))){
var inst_27839 = (state_27853[(2)]);
var state_27853__$1 = state_27853;
var statearr_27868_27894 = state_27853__$1;
(statearr_27868_27894[(2)] = inst_27839);

(statearr_27868_27894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27854 === (8))){
var inst_27836 = cljs.core.async.close_BANG_.call(null,to);
var state_27853__$1 = state_27853;
var statearr_27869_27895 = state_27853__$1;
(statearr_27869_27895[(2)] = inst_27836);

(statearr_27869_27895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___27881))
;
return ((function (switch__21216__auto__,c__21281__auto___27881){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_27873 = [null,null,null,null,null,null,null,null];
(statearr_27873[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_27873[(1)] = (1));

return statearr_27873;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_27853){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_27853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e27874){if((e27874 instanceof Object)){
var ex__21220__auto__ = e27874;
var statearr_27875_27896 = state_27853;
(statearr_27875_27896[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27853);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27874;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27897 = state_27853;
state_27853 = G__27897;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_27853){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_27853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___27881))
})();
var state__21283__auto__ = (function (){var statearr_27876 = f__21282__auto__.call(null);
(statearr_27876[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___27881);

return statearr_27876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___27881))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__28081){
var vec__28082 = p__28081;
var v = cljs.core.nth.call(null,vec__28082,(0),null);
var p = cljs.core.nth.call(null,vec__28082,(1),null);
var job = vec__28082;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__21281__auto___28264 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___28264,res,vec__28082,v,p,job,jobs,results){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___28264,res,vec__28082,v,p,job,jobs,results){
return (function (state_28087){
var state_val_28088 = (state_28087[(1)]);
if((state_val_28088 === (1))){
var state_28087__$1 = state_28087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28087__$1,(2),res,v);
} else {
if((state_val_28088 === (2))){
var inst_28084 = (state_28087[(2)]);
var inst_28085 = cljs.core.async.close_BANG_.call(null,res);
var state_28087__$1 = (function (){var statearr_28089 = state_28087;
(statearr_28089[(7)] = inst_28084);

return statearr_28089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28087__$1,inst_28085);
} else {
return null;
}
}
});})(c__21281__auto___28264,res,vec__28082,v,p,job,jobs,results))
;
return ((function (switch__21216__auto__,c__21281__auto___28264,res,vec__28082,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0 = (function (){
var statearr_28093 = [null,null,null,null,null,null,null,null];
(statearr_28093[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__);

(statearr_28093[(1)] = (1));

return statearr_28093;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1 = (function (state_28087){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28094){if((e28094 instanceof Object)){
var ex__21220__auto__ = e28094;
var statearr_28095_28265 = state_28087;
(statearr_28095_28265[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28094;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28266 = state_28087;
state_28087 = G__28266;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = function(state_28087){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1.call(this,state_28087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___28264,res,vec__28082,v,p,job,jobs,results))
})();
var state__21283__auto__ = (function (){var statearr_28096 = f__21282__auto__.call(null);
(statearr_28096[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___28264);

return statearr_28096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___28264,res,vec__28082,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__28097){
var vec__28098 = p__28097;
var v = cljs.core.nth.call(null,vec__28098,(0),null);
var p = cljs.core.nth.call(null,vec__28098,(1),null);
var job = vec__28098;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__18243__auto___28267 = n;
var __28268 = (0);
while(true){
if((__28268 < n__18243__auto___28267)){
var G__28099_28269 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__28099_28269) {
case "compute":
var c__21281__auto___28271 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28268,c__21281__auto___28271,G__28099_28269,n__18243__auto___28267,jobs,results,process,async){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (__28268,c__21281__auto___28271,G__28099_28269,n__18243__auto___28267,jobs,results,process,async){
return (function (state_28112){
var state_val_28113 = (state_28112[(1)]);
if((state_val_28113 === (1))){
var state_28112__$1 = state_28112;
var statearr_28114_28272 = state_28112__$1;
(statearr_28114_28272[(2)] = null);

(statearr_28114_28272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28113 === (2))){
var state_28112__$1 = state_28112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28112__$1,(4),jobs);
} else {
if((state_val_28113 === (3))){
var inst_28110 = (state_28112[(2)]);
var state_28112__$1 = state_28112;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28112__$1,inst_28110);
} else {
if((state_val_28113 === (4))){
var inst_28102 = (state_28112[(2)]);
var inst_28103 = process.call(null,inst_28102);
var state_28112__$1 = state_28112;
if(cljs.core.truth_(inst_28103)){
var statearr_28115_28273 = state_28112__$1;
(statearr_28115_28273[(1)] = (5));

} else {
var statearr_28116_28274 = state_28112__$1;
(statearr_28116_28274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28113 === (5))){
var state_28112__$1 = state_28112;
var statearr_28117_28275 = state_28112__$1;
(statearr_28117_28275[(2)] = null);

(statearr_28117_28275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28113 === (6))){
var state_28112__$1 = state_28112;
var statearr_28118_28276 = state_28112__$1;
(statearr_28118_28276[(2)] = null);

(statearr_28118_28276[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28113 === (7))){
var inst_28108 = (state_28112[(2)]);
var state_28112__$1 = state_28112;
var statearr_28119_28277 = state_28112__$1;
(statearr_28119_28277[(2)] = inst_28108);

(statearr_28119_28277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28268,c__21281__auto___28271,G__28099_28269,n__18243__auto___28267,jobs,results,process,async))
;
return ((function (__28268,switch__21216__auto__,c__21281__auto___28271,G__28099_28269,n__18243__auto___28267,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0 = (function (){
var statearr_28123 = [null,null,null,null,null,null,null];
(statearr_28123[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__);

(statearr_28123[(1)] = (1));

return statearr_28123;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1 = (function (state_28112){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28112);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28124){if((e28124 instanceof Object)){
var ex__21220__auto__ = e28124;
var statearr_28125_28278 = state_28112;
(statearr_28125_28278[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28112);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28124;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28279 = state_28112;
state_28112 = G__28279;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = function(state_28112){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1.call(this,state_28112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__;
})()
;})(__28268,switch__21216__auto__,c__21281__auto___28271,G__28099_28269,n__18243__auto___28267,jobs,results,process,async))
})();
var state__21283__auto__ = (function (){var statearr_28126 = f__21282__auto__.call(null);
(statearr_28126[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___28271);

return statearr_28126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(__28268,c__21281__auto___28271,G__28099_28269,n__18243__auto___28267,jobs,results,process,async))
);


break;
case "async":
var c__21281__auto___28280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28268,c__21281__auto___28280,G__28099_28269,n__18243__auto___28267,jobs,results,process,async){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (__28268,c__21281__auto___28280,G__28099_28269,n__18243__auto___28267,jobs,results,process,async){
return (function (state_28139){
var state_val_28140 = (state_28139[(1)]);
if((state_val_28140 === (1))){
var state_28139__$1 = state_28139;
var statearr_28141_28281 = state_28139__$1;
(statearr_28141_28281[(2)] = null);

(statearr_28141_28281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28140 === (2))){
var state_28139__$1 = state_28139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28139__$1,(4),jobs);
} else {
if((state_val_28140 === (3))){
var inst_28137 = (state_28139[(2)]);
var state_28139__$1 = state_28139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28139__$1,inst_28137);
} else {
if((state_val_28140 === (4))){
var inst_28129 = (state_28139[(2)]);
var inst_28130 = async.call(null,inst_28129);
var state_28139__$1 = state_28139;
if(cljs.core.truth_(inst_28130)){
var statearr_28142_28282 = state_28139__$1;
(statearr_28142_28282[(1)] = (5));

} else {
var statearr_28143_28283 = state_28139__$1;
(statearr_28143_28283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28140 === (5))){
var state_28139__$1 = state_28139;
var statearr_28144_28284 = state_28139__$1;
(statearr_28144_28284[(2)] = null);

(statearr_28144_28284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28140 === (6))){
var state_28139__$1 = state_28139;
var statearr_28145_28285 = state_28139__$1;
(statearr_28145_28285[(2)] = null);

(statearr_28145_28285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28140 === (7))){
var inst_28135 = (state_28139[(2)]);
var state_28139__$1 = state_28139;
var statearr_28146_28286 = state_28139__$1;
(statearr_28146_28286[(2)] = inst_28135);

(statearr_28146_28286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28268,c__21281__auto___28280,G__28099_28269,n__18243__auto___28267,jobs,results,process,async))
;
return ((function (__28268,switch__21216__auto__,c__21281__auto___28280,G__28099_28269,n__18243__auto___28267,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0 = (function (){
var statearr_28150 = [null,null,null,null,null,null,null];
(statearr_28150[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__);

(statearr_28150[(1)] = (1));

return statearr_28150;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1 = (function (state_28139){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28151){if((e28151 instanceof Object)){
var ex__21220__auto__ = e28151;
var statearr_28152_28287 = state_28139;
(statearr_28152_28287[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28151;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28288 = state_28139;
state_28139 = G__28288;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = function(state_28139){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1.call(this,state_28139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__;
})()
;})(__28268,switch__21216__auto__,c__21281__auto___28280,G__28099_28269,n__18243__auto___28267,jobs,results,process,async))
})();
var state__21283__auto__ = (function (){var statearr_28153 = f__21282__auto__.call(null);
(statearr_28153[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___28280);

return statearr_28153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(__28268,c__21281__auto___28280,G__28099_28269,n__18243__auto___28267,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__28289 = (__28268 + (1));
__28268 = G__28289;
continue;
} else {
}
break;
}

var c__21281__auto___28290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___28290,jobs,results,process,async){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___28290,jobs,results,process,async){
return (function (state_28175){
var state_val_28176 = (state_28175[(1)]);
if((state_val_28176 === (1))){
var state_28175__$1 = state_28175;
var statearr_28177_28291 = state_28175__$1;
(statearr_28177_28291[(2)] = null);

(statearr_28177_28291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28176 === (2))){
var state_28175__$1 = state_28175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28175__$1,(4),from);
} else {
if((state_val_28176 === (3))){
var inst_28173 = (state_28175[(2)]);
var state_28175__$1 = state_28175;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28175__$1,inst_28173);
} else {
if((state_val_28176 === (4))){
var inst_28156 = (state_28175[(7)]);
var inst_28156__$1 = (state_28175[(2)]);
var inst_28157 = (inst_28156__$1 == null);
var state_28175__$1 = (function (){var statearr_28178 = state_28175;
(statearr_28178[(7)] = inst_28156__$1);

return statearr_28178;
})();
if(cljs.core.truth_(inst_28157)){
var statearr_28179_28292 = state_28175__$1;
(statearr_28179_28292[(1)] = (5));

} else {
var statearr_28180_28293 = state_28175__$1;
(statearr_28180_28293[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28176 === (5))){
var inst_28159 = cljs.core.async.close_BANG_.call(null,jobs);
var state_28175__$1 = state_28175;
var statearr_28181_28294 = state_28175__$1;
(statearr_28181_28294[(2)] = inst_28159);

(statearr_28181_28294[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28176 === (6))){
var inst_28156 = (state_28175[(7)]);
var inst_28161 = (state_28175[(8)]);
var inst_28161__$1 = cljs.core.async.chan.call(null,(1));
var inst_28162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28163 = [inst_28156,inst_28161__$1];
var inst_28164 = (new cljs.core.PersistentVector(null,2,(5),inst_28162,inst_28163,null));
var state_28175__$1 = (function (){var statearr_28182 = state_28175;
(statearr_28182[(8)] = inst_28161__$1);

return statearr_28182;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28175__$1,(8),jobs,inst_28164);
} else {
if((state_val_28176 === (7))){
var inst_28171 = (state_28175[(2)]);
var state_28175__$1 = state_28175;
var statearr_28183_28295 = state_28175__$1;
(statearr_28183_28295[(2)] = inst_28171);

(statearr_28183_28295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28176 === (8))){
var inst_28161 = (state_28175[(8)]);
var inst_28166 = (state_28175[(2)]);
var state_28175__$1 = (function (){var statearr_28184 = state_28175;
(statearr_28184[(9)] = inst_28166);

return statearr_28184;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28175__$1,(9),results,inst_28161);
} else {
if((state_val_28176 === (9))){
var inst_28168 = (state_28175[(2)]);
var state_28175__$1 = (function (){var statearr_28185 = state_28175;
(statearr_28185[(10)] = inst_28168);

return statearr_28185;
})();
var statearr_28186_28296 = state_28175__$1;
(statearr_28186_28296[(2)] = null);

(statearr_28186_28296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___28290,jobs,results,process,async))
;
return ((function (switch__21216__auto__,c__21281__auto___28290,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0 = (function (){
var statearr_28190 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28190[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__);

(statearr_28190[(1)] = (1));

return statearr_28190;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1 = (function (state_28175){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28175);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28191){if((e28191 instanceof Object)){
var ex__21220__auto__ = e28191;
var statearr_28192_28297 = state_28175;
(statearr_28192_28297[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28175);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28191;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28298 = state_28175;
state_28175 = G__28298;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = function(state_28175){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1.call(this,state_28175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___28290,jobs,results,process,async))
})();
var state__21283__auto__ = (function (){var statearr_28193 = f__21282__auto__.call(null);
(statearr_28193[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___28290);

return statearr_28193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___28290,jobs,results,process,async))
);


var c__21281__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto__,jobs,results,process,async){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto__,jobs,results,process,async){
return (function (state_28231){
var state_val_28232 = (state_28231[(1)]);
if((state_val_28232 === (7))){
var inst_28227 = (state_28231[(2)]);
var state_28231__$1 = state_28231;
var statearr_28233_28299 = state_28231__$1;
(statearr_28233_28299[(2)] = inst_28227);

(statearr_28233_28299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (20))){
var state_28231__$1 = state_28231;
var statearr_28234_28300 = state_28231__$1;
(statearr_28234_28300[(2)] = null);

(statearr_28234_28300[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (1))){
var state_28231__$1 = state_28231;
var statearr_28235_28301 = state_28231__$1;
(statearr_28235_28301[(2)] = null);

(statearr_28235_28301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (4))){
var inst_28196 = (state_28231[(7)]);
var inst_28196__$1 = (state_28231[(2)]);
var inst_28197 = (inst_28196__$1 == null);
var state_28231__$1 = (function (){var statearr_28236 = state_28231;
(statearr_28236[(7)] = inst_28196__$1);

return statearr_28236;
})();
if(cljs.core.truth_(inst_28197)){
var statearr_28237_28302 = state_28231__$1;
(statearr_28237_28302[(1)] = (5));

} else {
var statearr_28238_28303 = state_28231__$1;
(statearr_28238_28303[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (15))){
var inst_28209 = (state_28231[(8)]);
var state_28231__$1 = state_28231;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28231__$1,(18),to,inst_28209);
} else {
if((state_val_28232 === (21))){
var inst_28222 = (state_28231[(2)]);
var state_28231__$1 = state_28231;
var statearr_28239_28304 = state_28231__$1;
(statearr_28239_28304[(2)] = inst_28222);

(statearr_28239_28304[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (13))){
var inst_28224 = (state_28231[(2)]);
var state_28231__$1 = (function (){var statearr_28240 = state_28231;
(statearr_28240[(9)] = inst_28224);

return statearr_28240;
})();
var statearr_28241_28305 = state_28231__$1;
(statearr_28241_28305[(2)] = null);

(statearr_28241_28305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (6))){
var inst_28196 = (state_28231[(7)]);
var state_28231__$1 = state_28231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28231__$1,(11),inst_28196);
} else {
if((state_val_28232 === (17))){
var inst_28217 = (state_28231[(2)]);
var state_28231__$1 = state_28231;
if(cljs.core.truth_(inst_28217)){
var statearr_28242_28306 = state_28231__$1;
(statearr_28242_28306[(1)] = (19));

} else {
var statearr_28243_28307 = state_28231__$1;
(statearr_28243_28307[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (3))){
var inst_28229 = (state_28231[(2)]);
var state_28231__$1 = state_28231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28231__$1,inst_28229);
} else {
if((state_val_28232 === (12))){
var inst_28206 = (state_28231[(10)]);
var state_28231__$1 = state_28231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28231__$1,(14),inst_28206);
} else {
if((state_val_28232 === (2))){
var state_28231__$1 = state_28231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28231__$1,(4),results);
} else {
if((state_val_28232 === (19))){
var state_28231__$1 = state_28231;
var statearr_28244_28308 = state_28231__$1;
(statearr_28244_28308[(2)] = null);

(statearr_28244_28308[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (11))){
var inst_28206 = (state_28231[(2)]);
var state_28231__$1 = (function (){var statearr_28245 = state_28231;
(statearr_28245[(10)] = inst_28206);

return statearr_28245;
})();
var statearr_28246_28309 = state_28231__$1;
(statearr_28246_28309[(2)] = null);

(statearr_28246_28309[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (9))){
var state_28231__$1 = state_28231;
var statearr_28247_28310 = state_28231__$1;
(statearr_28247_28310[(2)] = null);

(statearr_28247_28310[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (5))){
var state_28231__$1 = state_28231;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28248_28311 = state_28231__$1;
(statearr_28248_28311[(1)] = (8));

} else {
var statearr_28249_28312 = state_28231__$1;
(statearr_28249_28312[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (14))){
var inst_28209 = (state_28231[(8)]);
var inst_28211 = (state_28231[(11)]);
var inst_28209__$1 = (state_28231[(2)]);
var inst_28210 = (inst_28209__$1 == null);
var inst_28211__$1 = cljs.core.not.call(null,inst_28210);
var state_28231__$1 = (function (){var statearr_28250 = state_28231;
(statearr_28250[(8)] = inst_28209__$1);

(statearr_28250[(11)] = inst_28211__$1);

return statearr_28250;
})();
if(inst_28211__$1){
var statearr_28251_28313 = state_28231__$1;
(statearr_28251_28313[(1)] = (15));

} else {
var statearr_28252_28314 = state_28231__$1;
(statearr_28252_28314[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (16))){
var inst_28211 = (state_28231[(11)]);
var state_28231__$1 = state_28231;
var statearr_28253_28315 = state_28231__$1;
(statearr_28253_28315[(2)] = inst_28211);

(statearr_28253_28315[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (10))){
var inst_28203 = (state_28231[(2)]);
var state_28231__$1 = state_28231;
var statearr_28254_28316 = state_28231__$1;
(statearr_28254_28316[(2)] = inst_28203);

(statearr_28254_28316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (18))){
var inst_28214 = (state_28231[(2)]);
var state_28231__$1 = state_28231;
var statearr_28255_28317 = state_28231__$1;
(statearr_28255_28317[(2)] = inst_28214);

(statearr_28255_28317[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28232 === (8))){
var inst_28200 = cljs.core.async.close_BANG_.call(null,to);
var state_28231__$1 = state_28231;
var statearr_28256_28318 = state_28231__$1;
(statearr_28256_28318[(2)] = inst_28200);

(statearr_28256_28318[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto__,jobs,results,process,async))
;
return ((function (switch__21216__auto__,c__21281__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0 = (function (){
var statearr_28260 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28260[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__);

(statearr_28260[(1)] = (1));

return statearr_28260;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1 = (function (state_28231){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28261){if((e28261 instanceof Object)){
var ex__21220__auto__ = e28261;
var statearr_28262_28319 = state_28231;
(statearr_28262_28319[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28231);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28261;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28320 = state_28231;
state_28231 = G__28320;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__ = function(state_28231){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1.call(this,state_28231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21217__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto__,jobs,results,process,async))
})();
var state__21283__auto__ = (function (){var statearr_28263 = f__21282__auto__.call(null);
(statearr_28263[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto__);

return statearr_28263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto__,jobs,results,process,async))
);

return c__21281__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args28321 = [];
var len__18398__auto___28324 = arguments.length;
var i__18399__auto___28325 = (0);
while(true){
if((i__18399__auto___28325 < len__18398__auto___28324)){
args28321.push((arguments[i__18399__auto___28325]));

var G__28326 = (i__18399__auto___28325 + (1));
i__18399__auto___28325 = G__28326;
continue;
} else {
}
break;
}

var G__28323 = args28321.length;
switch (G__28323) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28321.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args28328 = [];
var len__18398__auto___28331 = arguments.length;
var i__18399__auto___28332 = (0);
while(true){
if((i__18399__auto___28332 < len__18398__auto___28331)){
args28328.push((arguments[i__18399__auto___28332]));

var G__28333 = (i__18399__auto___28332 + (1));
i__18399__auto___28332 = G__28333;
continue;
} else {
}
break;
}

var G__28330 = args28328.length;
switch (G__28330) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28328.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args28335 = [];
var len__18398__auto___28388 = arguments.length;
var i__18399__auto___28389 = (0);
while(true){
if((i__18399__auto___28389 < len__18398__auto___28388)){
args28335.push((arguments[i__18399__auto___28389]));

var G__28390 = (i__18399__auto___28389 + (1));
i__18399__auto___28389 = G__28390;
continue;
} else {
}
break;
}

var G__28337 = args28335.length;
switch (G__28337) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28335.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__21281__auto___28392 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___28392,tc,fc){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___28392,tc,fc){
return (function (state_28363){
var state_val_28364 = (state_28363[(1)]);
if((state_val_28364 === (7))){
var inst_28359 = (state_28363[(2)]);
var state_28363__$1 = state_28363;
var statearr_28365_28393 = state_28363__$1;
(statearr_28365_28393[(2)] = inst_28359);

(statearr_28365_28393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (1))){
var state_28363__$1 = state_28363;
var statearr_28366_28394 = state_28363__$1;
(statearr_28366_28394[(2)] = null);

(statearr_28366_28394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (4))){
var inst_28340 = (state_28363[(7)]);
var inst_28340__$1 = (state_28363[(2)]);
var inst_28341 = (inst_28340__$1 == null);
var state_28363__$1 = (function (){var statearr_28367 = state_28363;
(statearr_28367[(7)] = inst_28340__$1);

return statearr_28367;
})();
if(cljs.core.truth_(inst_28341)){
var statearr_28368_28395 = state_28363__$1;
(statearr_28368_28395[(1)] = (5));

} else {
var statearr_28369_28396 = state_28363__$1;
(statearr_28369_28396[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (13))){
var state_28363__$1 = state_28363;
var statearr_28370_28397 = state_28363__$1;
(statearr_28370_28397[(2)] = null);

(statearr_28370_28397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (6))){
var inst_28340 = (state_28363[(7)]);
var inst_28346 = p.call(null,inst_28340);
var state_28363__$1 = state_28363;
if(cljs.core.truth_(inst_28346)){
var statearr_28371_28398 = state_28363__$1;
(statearr_28371_28398[(1)] = (9));

} else {
var statearr_28372_28399 = state_28363__$1;
(statearr_28372_28399[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (3))){
var inst_28361 = (state_28363[(2)]);
var state_28363__$1 = state_28363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28363__$1,inst_28361);
} else {
if((state_val_28364 === (12))){
var state_28363__$1 = state_28363;
var statearr_28373_28400 = state_28363__$1;
(statearr_28373_28400[(2)] = null);

(statearr_28373_28400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (2))){
var state_28363__$1 = state_28363;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28363__$1,(4),ch);
} else {
if((state_val_28364 === (11))){
var inst_28340 = (state_28363[(7)]);
var inst_28350 = (state_28363[(2)]);
var state_28363__$1 = state_28363;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28363__$1,(8),inst_28350,inst_28340);
} else {
if((state_val_28364 === (9))){
var state_28363__$1 = state_28363;
var statearr_28374_28401 = state_28363__$1;
(statearr_28374_28401[(2)] = tc);

(statearr_28374_28401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (5))){
var inst_28343 = cljs.core.async.close_BANG_.call(null,tc);
var inst_28344 = cljs.core.async.close_BANG_.call(null,fc);
var state_28363__$1 = (function (){var statearr_28375 = state_28363;
(statearr_28375[(8)] = inst_28343);

return statearr_28375;
})();
var statearr_28376_28402 = state_28363__$1;
(statearr_28376_28402[(2)] = inst_28344);

(statearr_28376_28402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (14))){
var inst_28357 = (state_28363[(2)]);
var state_28363__$1 = state_28363;
var statearr_28377_28403 = state_28363__$1;
(statearr_28377_28403[(2)] = inst_28357);

(statearr_28377_28403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (10))){
var state_28363__$1 = state_28363;
var statearr_28378_28404 = state_28363__$1;
(statearr_28378_28404[(2)] = fc);

(statearr_28378_28404[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28364 === (8))){
var inst_28352 = (state_28363[(2)]);
var state_28363__$1 = state_28363;
if(cljs.core.truth_(inst_28352)){
var statearr_28379_28405 = state_28363__$1;
(statearr_28379_28405[(1)] = (12));

} else {
var statearr_28380_28406 = state_28363__$1;
(statearr_28380_28406[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___28392,tc,fc))
;
return ((function (switch__21216__auto__,c__21281__auto___28392,tc,fc){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_28384 = [null,null,null,null,null,null,null,null,null];
(statearr_28384[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_28384[(1)] = (1));

return statearr_28384;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_28363){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28385){if((e28385 instanceof Object)){
var ex__21220__auto__ = e28385;
var statearr_28386_28407 = state_28363;
(statearr_28386_28407[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28363);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28408 = state_28363;
state_28363 = G__28408;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_28363){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_28363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___28392,tc,fc))
})();
var state__21283__auto__ = (function (){var statearr_28387 = f__21282__auto__.call(null);
(statearr_28387[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___28392);

return statearr_28387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___28392,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__21281__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto__){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto__){
return (function (state_28455){
var state_val_28456 = (state_28455[(1)]);
if((state_val_28456 === (1))){
var inst_28441 = init;
var state_28455__$1 = (function (){var statearr_28457 = state_28455;
(statearr_28457[(7)] = inst_28441);

return statearr_28457;
})();
var statearr_28458_28473 = state_28455__$1;
(statearr_28458_28473[(2)] = null);

(statearr_28458_28473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28456 === (2))){
var state_28455__$1 = state_28455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28455__$1,(4),ch);
} else {
if((state_val_28456 === (3))){
var inst_28453 = (state_28455[(2)]);
var state_28455__$1 = state_28455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28455__$1,inst_28453);
} else {
if((state_val_28456 === (4))){
var inst_28444 = (state_28455[(8)]);
var inst_28444__$1 = (state_28455[(2)]);
var inst_28445 = (inst_28444__$1 == null);
var state_28455__$1 = (function (){var statearr_28459 = state_28455;
(statearr_28459[(8)] = inst_28444__$1);

return statearr_28459;
})();
if(cljs.core.truth_(inst_28445)){
var statearr_28460_28474 = state_28455__$1;
(statearr_28460_28474[(1)] = (5));

} else {
var statearr_28461_28475 = state_28455__$1;
(statearr_28461_28475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28456 === (5))){
var inst_28441 = (state_28455[(7)]);
var state_28455__$1 = state_28455;
var statearr_28462_28476 = state_28455__$1;
(statearr_28462_28476[(2)] = inst_28441);

(statearr_28462_28476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28456 === (6))){
var inst_28441 = (state_28455[(7)]);
var inst_28444 = (state_28455[(8)]);
var inst_28448 = f.call(null,inst_28441,inst_28444);
var inst_28441__$1 = inst_28448;
var state_28455__$1 = (function (){var statearr_28463 = state_28455;
(statearr_28463[(7)] = inst_28441__$1);

return statearr_28463;
})();
var statearr_28464_28477 = state_28455__$1;
(statearr_28464_28477[(2)] = null);

(statearr_28464_28477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28456 === (7))){
var inst_28451 = (state_28455[(2)]);
var state_28455__$1 = state_28455;
var statearr_28465_28478 = state_28455__$1;
(statearr_28465_28478[(2)] = inst_28451);

(statearr_28465_28478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__21281__auto__))
;
return ((function (switch__21216__auto__,c__21281__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__21217__auto__ = null;
var cljs$core$async$reduce_$_state_machine__21217__auto____0 = (function (){
var statearr_28469 = [null,null,null,null,null,null,null,null,null];
(statearr_28469[(0)] = cljs$core$async$reduce_$_state_machine__21217__auto__);

(statearr_28469[(1)] = (1));

return statearr_28469;
});
var cljs$core$async$reduce_$_state_machine__21217__auto____1 = (function (state_28455){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28470){if((e28470 instanceof Object)){
var ex__21220__auto__ = e28470;
var statearr_28471_28479 = state_28455;
(statearr_28471_28479[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28455);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28470;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28480 = state_28455;
state_28455 = G__28480;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__21217__auto__ = function(state_28455){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__21217__auto____1.call(this,state_28455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__21217__auto____0;
cljs$core$async$reduce_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__21217__auto____1;
return cljs$core$async$reduce_$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto__))
})();
var state__21283__auto__ = (function (){var statearr_28472 = f__21282__auto__.call(null);
(statearr_28472[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto__);

return statearr_28472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto__))
);

return c__21281__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args28481 = [];
var len__18398__auto___28533 = arguments.length;
var i__18399__auto___28534 = (0);
while(true){
if((i__18399__auto___28534 < len__18398__auto___28533)){
args28481.push((arguments[i__18399__auto___28534]));

var G__28535 = (i__18399__auto___28534 + (1));
i__18399__auto___28534 = G__28535;
continue;
} else {
}
break;
}

var G__28483 = args28481.length;
switch (G__28483) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28481.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__21281__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto__){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto__){
return (function (state_28508){
var state_val_28509 = (state_28508[(1)]);
if((state_val_28509 === (7))){
var inst_28490 = (state_28508[(2)]);
var state_28508__$1 = state_28508;
var statearr_28510_28537 = state_28508__$1;
(statearr_28510_28537[(2)] = inst_28490);

(statearr_28510_28537[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (1))){
var inst_28484 = cljs.core.seq.call(null,coll);
var inst_28485 = inst_28484;
var state_28508__$1 = (function (){var statearr_28511 = state_28508;
(statearr_28511[(7)] = inst_28485);

return statearr_28511;
})();
var statearr_28512_28538 = state_28508__$1;
(statearr_28512_28538[(2)] = null);

(statearr_28512_28538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (4))){
var inst_28485 = (state_28508[(7)]);
var inst_28488 = cljs.core.first.call(null,inst_28485);
var state_28508__$1 = state_28508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28508__$1,(7),ch,inst_28488);
} else {
if((state_val_28509 === (13))){
var inst_28502 = (state_28508[(2)]);
var state_28508__$1 = state_28508;
var statearr_28513_28539 = state_28508__$1;
(statearr_28513_28539[(2)] = inst_28502);

(statearr_28513_28539[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (6))){
var inst_28493 = (state_28508[(2)]);
var state_28508__$1 = state_28508;
if(cljs.core.truth_(inst_28493)){
var statearr_28514_28540 = state_28508__$1;
(statearr_28514_28540[(1)] = (8));

} else {
var statearr_28515_28541 = state_28508__$1;
(statearr_28515_28541[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (3))){
var inst_28506 = (state_28508[(2)]);
var state_28508__$1 = state_28508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28508__$1,inst_28506);
} else {
if((state_val_28509 === (12))){
var state_28508__$1 = state_28508;
var statearr_28516_28542 = state_28508__$1;
(statearr_28516_28542[(2)] = null);

(statearr_28516_28542[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (2))){
var inst_28485 = (state_28508[(7)]);
var state_28508__$1 = state_28508;
if(cljs.core.truth_(inst_28485)){
var statearr_28517_28543 = state_28508__$1;
(statearr_28517_28543[(1)] = (4));

} else {
var statearr_28518_28544 = state_28508__$1;
(statearr_28518_28544[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (11))){
var inst_28499 = cljs.core.async.close_BANG_.call(null,ch);
var state_28508__$1 = state_28508;
var statearr_28519_28545 = state_28508__$1;
(statearr_28519_28545[(2)] = inst_28499);

(statearr_28519_28545[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (9))){
var state_28508__$1 = state_28508;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28520_28546 = state_28508__$1;
(statearr_28520_28546[(1)] = (11));

} else {
var statearr_28521_28547 = state_28508__$1;
(statearr_28521_28547[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (5))){
var inst_28485 = (state_28508[(7)]);
var state_28508__$1 = state_28508;
var statearr_28522_28548 = state_28508__$1;
(statearr_28522_28548[(2)] = inst_28485);

(statearr_28522_28548[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (10))){
var inst_28504 = (state_28508[(2)]);
var state_28508__$1 = state_28508;
var statearr_28523_28549 = state_28508__$1;
(statearr_28523_28549[(2)] = inst_28504);

(statearr_28523_28549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28509 === (8))){
var inst_28485 = (state_28508[(7)]);
var inst_28495 = cljs.core.next.call(null,inst_28485);
var inst_28485__$1 = inst_28495;
var state_28508__$1 = (function (){var statearr_28524 = state_28508;
(statearr_28524[(7)] = inst_28485__$1);

return statearr_28524;
})();
var statearr_28525_28550 = state_28508__$1;
(statearr_28525_28550[(2)] = null);

(statearr_28525_28550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto__))
;
return ((function (switch__21216__auto__,c__21281__auto__){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_28529 = [null,null,null,null,null,null,null,null];
(statearr_28529[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_28529[(1)] = (1));

return statearr_28529;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_28508){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28530){if((e28530 instanceof Object)){
var ex__21220__auto__ = e28530;
var statearr_28531_28551 = state_28508;
(statearr_28531_28551[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28530;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28552 = state_28508;
state_28508 = G__28552;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_28508){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_28508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto__))
})();
var state__21283__auto__ = (function (){var statearr_28532 = f__21282__auto__.call(null);
(statearr_28532[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto__);

return statearr_28532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto__))
);

return c__21281__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__17995__auto__ = (((_ == null))?null:_);
var m__17996__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,_);
} else {
var m__17996__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__17996__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m,ch);
} else {
var m__17996__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m);
} else {
var m__17996__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t28778 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t28778 = (function (mult,ch,cs,meta28779){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta28779 = meta28779;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t28778.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_28780,meta28779__$1){
var self__ = this;
var _28780__$1 = this;
return (new cljs.core.async.t28778(self__.mult,self__.ch,self__.cs,meta28779__$1));
});})(cs))
;

cljs.core.async.t28778.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_28780){
var self__ = this;
var _28780__$1 = this;
return self__.meta28779;
});})(cs))
;

cljs.core.async.t28778.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t28778.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t28778.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t28778.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t28778.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t28778.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t28778.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta28779","meta28779",880867060,null)], null);
});})(cs))
;

cljs.core.async.t28778.cljs$lang$type = true;

cljs.core.async.t28778.cljs$lang$ctorStr = "cljs.core.async/t28778";

cljs.core.async.t28778.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t28778");
});})(cs))
;

cljs.core.async.__GT_t28778 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t28778(mult__$1,ch__$1,cs__$1,meta28779){
return (new cljs.core.async.t28778(mult__$1,ch__$1,cs__$1,meta28779));
});})(cs))
;

}

return (new cljs.core.async.t28778(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__21281__auto___28999 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___28999,cs,m,dchan,dctr,done){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___28999,cs,m,dchan,dctr,done){
return (function (state_28911){
var state_val_28912 = (state_28911[(1)]);
if((state_val_28912 === (7))){
var inst_28907 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28913_29000 = state_28911__$1;
(statearr_28913_29000[(2)] = inst_28907);

(statearr_28913_29000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (20))){
var inst_28812 = (state_28911[(7)]);
var inst_28822 = cljs.core.first.call(null,inst_28812);
var inst_28823 = cljs.core.nth.call(null,inst_28822,(0),null);
var inst_28824 = cljs.core.nth.call(null,inst_28822,(1),null);
var state_28911__$1 = (function (){var statearr_28914 = state_28911;
(statearr_28914[(8)] = inst_28823);

return statearr_28914;
})();
if(cljs.core.truth_(inst_28824)){
var statearr_28915_29001 = state_28911__$1;
(statearr_28915_29001[(1)] = (22));

} else {
var statearr_28916_29002 = state_28911__$1;
(statearr_28916_29002[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (27))){
var inst_28854 = (state_28911[(9)]);
var inst_28852 = (state_28911[(10)]);
var inst_28783 = (state_28911[(11)]);
var inst_28859 = (state_28911[(12)]);
var inst_28859__$1 = cljs.core._nth.call(null,inst_28852,inst_28854);
var inst_28860 = cljs.core.async.put_BANG_.call(null,inst_28859__$1,inst_28783,done);
var state_28911__$1 = (function (){var statearr_28917 = state_28911;
(statearr_28917[(12)] = inst_28859__$1);

return statearr_28917;
})();
if(cljs.core.truth_(inst_28860)){
var statearr_28918_29003 = state_28911__$1;
(statearr_28918_29003[(1)] = (30));

} else {
var statearr_28919_29004 = state_28911__$1;
(statearr_28919_29004[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (1))){
var state_28911__$1 = state_28911;
var statearr_28920_29005 = state_28911__$1;
(statearr_28920_29005[(2)] = null);

(statearr_28920_29005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (24))){
var inst_28812 = (state_28911[(7)]);
var inst_28829 = (state_28911[(2)]);
var inst_28830 = cljs.core.next.call(null,inst_28812);
var inst_28792 = inst_28830;
var inst_28793 = null;
var inst_28794 = (0);
var inst_28795 = (0);
var state_28911__$1 = (function (){var statearr_28921 = state_28911;
(statearr_28921[(13)] = inst_28793);

(statearr_28921[(14)] = inst_28795);

(statearr_28921[(15)] = inst_28829);

(statearr_28921[(16)] = inst_28792);

(statearr_28921[(17)] = inst_28794);

return statearr_28921;
})();
var statearr_28922_29006 = state_28911__$1;
(statearr_28922_29006[(2)] = null);

(statearr_28922_29006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (39))){
var state_28911__$1 = state_28911;
var statearr_28926_29007 = state_28911__$1;
(statearr_28926_29007[(2)] = null);

(statearr_28926_29007[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (4))){
var inst_28783 = (state_28911[(11)]);
var inst_28783__$1 = (state_28911[(2)]);
var inst_28784 = (inst_28783__$1 == null);
var state_28911__$1 = (function (){var statearr_28927 = state_28911;
(statearr_28927[(11)] = inst_28783__$1);

return statearr_28927;
})();
if(cljs.core.truth_(inst_28784)){
var statearr_28928_29008 = state_28911__$1;
(statearr_28928_29008[(1)] = (5));

} else {
var statearr_28929_29009 = state_28911__$1;
(statearr_28929_29009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (15))){
var inst_28793 = (state_28911[(13)]);
var inst_28795 = (state_28911[(14)]);
var inst_28792 = (state_28911[(16)]);
var inst_28794 = (state_28911[(17)]);
var inst_28808 = (state_28911[(2)]);
var inst_28809 = (inst_28795 + (1));
var tmp28923 = inst_28793;
var tmp28924 = inst_28792;
var tmp28925 = inst_28794;
var inst_28792__$1 = tmp28924;
var inst_28793__$1 = tmp28923;
var inst_28794__$1 = tmp28925;
var inst_28795__$1 = inst_28809;
var state_28911__$1 = (function (){var statearr_28930 = state_28911;
(statearr_28930[(13)] = inst_28793__$1);

(statearr_28930[(14)] = inst_28795__$1);

(statearr_28930[(18)] = inst_28808);

(statearr_28930[(16)] = inst_28792__$1);

(statearr_28930[(17)] = inst_28794__$1);

return statearr_28930;
})();
var statearr_28931_29010 = state_28911__$1;
(statearr_28931_29010[(2)] = null);

(statearr_28931_29010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (21))){
var inst_28833 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28935_29011 = state_28911__$1;
(statearr_28935_29011[(2)] = inst_28833);

(statearr_28935_29011[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (31))){
var inst_28859 = (state_28911[(12)]);
var inst_28863 = done.call(null,null);
var inst_28864 = cljs.core.async.untap_STAR_.call(null,m,inst_28859);
var state_28911__$1 = (function (){var statearr_28936 = state_28911;
(statearr_28936[(19)] = inst_28863);

return statearr_28936;
})();
var statearr_28937_29012 = state_28911__$1;
(statearr_28937_29012[(2)] = inst_28864);

(statearr_28937_29012[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (32))){
var inst_28854 = (state_28911[(9)]);
var inst_28852 = (state_28911[(10)]);
var inst_28853 = (state_28911[(20)]);
var inst_28851 = (state_28911[(21)]);
var inst_28866 = (state_28911[(2)]);
var inst_28867 = (inst_28854 + (1));
var tmp28932 = inst_28852;
var tmp28933 = inst_28853;
var tmp28934 = inst_28851;
var inst_28851__$1 = tmp28934;
var inst_28852__$1 = tmp28932;
var inst_28853__$1 = tmp28933;
var inst_28854__$1 = inst_28867;
var state_28911__$1 = (function (){var statearr_28938 = state_28911;
(statearr_28938[(9)] = inst_28854__$1);

(statearr_28938[(10)] = inst_28852__$1);

(statearr_28938[(20)] = inst_28853__$1);

(statearr_28938[(22)] = inst_28866);

(statearr_28938[(21)] = inst_28851__$1);

return statearr_28938;
})();
var statearr_28939_29013 = state_28911__$1;
(statearr_28939_29013[(2)] = null);

(statearr_28939_29013[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (40))){
var inst_28879 = (state_28911[(23)]);
var inst_28883 = done.call(null,null);
var inst_28884 = cljs.core.async.untap_STAR_.call(null,m,inst_28879);
var state_28911__$1 = (function (){var statearr_28940 = state_28911;
(statearr_28940[(24)] = inst_28883);

return statearr_28940;
})();
var statearr_28941_29014 = state_28911__$1;
(statearr_28941_29014[(2)] = inst_28884);

(statearr_28941_29014[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (33))){
var inst_28870 = (state_28911[(25)]);
var inst_28872 = cljs.core.chunked_seq_QMARK_.call(null,inst_28870);
var state_28911__$1 = state_28911;
if(inst_28872){
var statearr_28942_29015 = state_28911__$1;
(statearr_28942_29015[(1)] = (36));

} else {
var statearr_28943_29016 = state_28911__$1;
(statearr_28943_29016[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (13))){
var inst_28802 = (state_28911[(26)]);
var inst_28805 = cljs.core.async.close_BANG_.call(null,inst_28802);
var state_28911__$1 = state_28911;
var statearr_28944_29017 = state_28911__$1;
(statearr_28944_29017[(2)] = inst_28805);

(statearr_28944_29017[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (22))){
var inst_28823 = (state_28911[(8)]);
var inst_28826 = cljs.core.async.close_BANG_.call(null,inst_28823);
var state_28911__$1 = state_28911;
var statearr_28945_29018 = state_28911__$1;
(statearr_28945_29018[(2)] = inst_28826);

(statearr_28945_29018[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (36))){
var inst_28870 = (state_28911[(25)]);
var inst_28874 = cljs.core.chunk_first.call(null,inst_28870);
var inst_28875 = cljs.core.chunk_rest.call(null,inst_28870);
var inst_28876 = cljs.core.count.call(null,inst_28874);
var inst_28851 = inst_28875;
var inst_28852 = inst_28874;
var inst_28853 = inst_28876;
var inst_28854 = (0);
var state_28911__$1 = (function (){var statearr_28946 = state_28911;
(statearr_28946[(9)] = inst_28854);

(statearr_28946[(10)] = inst_28852);

(statearr_28946[(20)] = inst_28853);

(statearr_28946[(21)] = inst_28851);

return statearr_28946;
})();
var statearr_28947_29019 = state_28911__$1;
(statearr_28947_29019[(2)] = null);

(statearr_28947_29019[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (41))){
var inst_28870 = (state_28911[(25)]);
var inst_28886 = (state_28911[(2)]);
var inst_28887 = cljs.core.next.call(null,inst_28870);
var inst_28851 = inst_28887;
var inst_28852 = null;
var inst_28853 = (0);
var inst_28854 = (0);
var state_28911__$1 = (function (){var statearr_28948 = state_28911;
(statearr_28948[(9)] = inst_28854);

(statearr_28948[(10)] = inst_28852);

(statearr_28948[(27)] = inst_28886);

(statearr_28948[(20)] = inst_28853);

(statearr_28948[(21)] = inst_28851);

return statearr_28948;
})();
var statearr_28949_29020 = state_28911__$1;
(statearr_28949_29020[(2)] = null);

(statearr_28949_29020[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (43))){
var state_28911__$1 = state_28911;
var statearr_28950_29021 = state_28911__$1;
(statearr_28950_29021[(2)] = null);

(statearr_28950_29021[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (29))){
var inst_28895 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28951_29022 = state_28911__$1;
(statearr_28951_29022[(2)] = inst_28895);

(statearr_28951_29022[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (44))){
var inst_28904 = (state_28911[(2)]);
var state_28911__$1 = (function (){var statearr_28952 = state_28911;
(statearr_28952[(28)] = inst_28904);

return statearr_28952;
})();
var statearr_28953_29023 = state_28911__$1;
(statearr_28953_29023[(2)] = null);

(statearr_28953_29023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (6))){
var inst_28843 = (state_28911[(29)]);
var inst_28842 = cljs.core.deref.call(null,cs);
var inst_28843__$1 = cljs.core.keys.call(null,inst_28842);
var inst_28844 = cljs.core.count.call(null,inst_28843__$1);
var inst_28845 = cljs.core.reset_BANG_.call(null,dctr,inst_28844);
var inst_28850 = cljs.core.seq.call(null,inst_28843__$1);
var inst_28851 = inst_28850;
var inst_28852 = null;
var inst_28853 = (0);
var inst_28854 = (0);
var state_28911__$1 = (function (){var statearr_28954 = state_28911;
(statearr_28954[(9)] = inst_28854);

(statearr_28954[(10)] = inst_28852);

(statearr_28954[(20)] = inst_28853);

(statearr_28954[(30)] = inst_28845);

(statearr_28954[(29)] = inst_28843__$1);

(statearr_28954[(21)] = inst_28851);

return statearr_28954;
})();
var statearr_28955_29024 = state_28911__$1;
(statearr_28955_29024[(2)] = null);

(statearr_28955_29024[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (28))){
var inst_28870 = (state_28911[(25)]);
var inst_28851 = (state_28911[(21)]);
var inst_28870__$1 = cljs.core.seq.call(null,inst_28851);
var state_28911__$1 = (function (){var statearr_28956 = state_28911;
(statearr_28956[(25)] = inst_28870__$1);

return statearr_28956;
})();
if(inst_28870__$1){
var statearr_28957_29025 = state_28911__$1;
(statearr_28957_29025[(1)] = (33));

} else {
var statearr_28958_29026 = state_28911__$1;
(statearr_28958_29026[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (25))){
var inst_28854 = (state_28911[(9)]);
var inst_28853 = (state_28911[(20)]);
var inst_28856 = (inst_28854 < inst_28853);
var inst_28857 = inst_28856;
var state_28911__$1 = state_28911;
if(cljs.core.truth_(inst_28857)){
var statearr_28959_29027 = state_28911__$1;
(statearr_28959_29027[(1)] = (27));

} else {
var statearr_28960_29028 = state_28911__$1;
(statearr_28960_29028[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (34))){
var state_28911__$1 = state_28911;
var statearr_28961_29029 = state_28911__$1;
(statearr_28961_29029[(2)] = null);

(statearr_28961_29029[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (17))){
var state_28911__$1 = state_28911;
var statearr_28962_29030 = state_28911__$1;
(statearr_28962_29030[(2)] = null);

(statearr_28962_29030[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (3))){
var inst_28909 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28911__$1,inst_28909);
} else {
if((state_val_28912 === (12))){
var inst_28838 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28963_29031 = state_28911__$1;
(statearr_28963_29031[(2)] = inst_28838);

(statearr_28963_29031[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (2))){
var state_28911__$1 = state_28911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28911__$1,(4),ch);
} else {
if((state_val_28912 === (23))){
var state_28911__$1 = state_28911;
var statearr_28964_29032 = state_28911__$1;
(statearr_28964_29032[(2)] = null);

(statearr_28964_29032[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (35))){
var inst_28893 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28965_29033 = state_28911__$1;
(statearr_28965_29033[(2)] = inst_28893);

(statearr_28965_29033[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (19))){
var inst_28812 = (state_28911[(7)]);
var inst_28816 = cljs.core.chunk_first.call(null,inst_28812);
var inst_28817 = cljs.core.chunk_rest.call(null,inst_28812);
var inst_28818 = cljs.core.count.call(null,inst_28816);
var inst_28792 = inst_28817;
var inst_28793 = inst_28816;
var inst_28794 = inst_28818;
var inst_28795 = (0);
var state_28911__$1 = (function (){var statearr_28966 = state_28911;
(statearr_28966[(13)] = inst_28793);

(statearr_28966[(14)] = inst_28795);

(statearr_28966[(16)] = inst_28792);

(statearr_28966[(17)] = inst_28794);

return statearr_28966;
})();
var statearr_28967_29034 = state_28911__$1;
(statearr_28967_29034[(2)] = null);

(statearr_28967_29034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (11))){
var inst_28812 = (state_28911[(7)]);
var inst_28792 = (state_28911[(16)]);
var inst_28812__$1 = cljs.core.seq.call(null,inst_28792);
var state_28911__$1 = (function (){var statearr_28968 = state_28911;
(statearr_28968[(7)] = inst_28812__$1);

return statearr_28968;
})();
if(inst_28812__$1){
var statearr_28969_29035 = state_28911__$1;
(statearr_28969_29035[(1)] = (16));

} else {
var statearr_28970_29036 = state_28911__$1;
(statearr_28970_29036[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (9))){
var inst_28840 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28971_29037 = state_28911__$1;
(statearr_28971_29037[(2)] = inst_28840);

(statearr_28971_29037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (5))){
var inst_28790 = cljs.core.deref.call(null,cs);
var inst_28791 = cljs.core.seq.call(null,inst_28790);
var inst_28792 = inst_28791;
var inst_28793 = null;
var inst_28794 = (0);
var inst_28795 = (0);
var state_28911__$1 = (function (){var statearr_28972 = state_28911;
(statearr_28972[(13)] = inst_28793);

(statearr_28972[(14)] = inst_28795);

(statearr_28972[(16)] = inst_28792);

(statearr_28972[(17)] = inst_28794);

return statearr_28972;
})();
var statearr_28973_29038 = state_28911__$1;
(statearr_28973_29038[(2)] = null);

(statearr_28973_29038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (14))){
var state_28911__$1 = state_28911;
var statearr_28974_29039 = state_28911__$1;
(statearr_28974_29039[(2)] = null);

(statearr_28974_29039[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (45))){
var inst_28901 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28975_29040 = state_28911__$1;
(statearr_28975_29040[(2)] = inst_28901);

(statearr_28975_29040[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (26))){
var inst_28843 = (state_28911[(29)]);
var inst_28897 = (state_28911[(2)]);
var inst_28898 = cljs.core.seq.call(null,inst_28843);
var state_28911__$1 = (function (){var statearr_28976 = state_28911;
(statearr_28976[(31)] = inst_28897);

return statearr_28976;
})();
if(inst_28898){
var statearr_28977_29041 = state_28911__$1;
(statearr_28977_29041[(1)] = (42));

} else {
var statearr_28978_29042 = state_28911__$1;
(statearr_28978_29042[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (16))){
var inst_28812 = (state_28911[(7)]);
var inst_28814 = cljs.core.chunked_seq_QMARK_.call(null,inst_28812);
var state_28911__$1 = state_28911;
if(inst_28814){
var statearr_28979_29043 = state_28911__$1;
(statearr_28979_29043[(1)] = (19));

} else {
var statearr_28980_29044 = state_28911__$1;
(statearr_28980_29044[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (38))){
var inst_28890 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28981_29045 = state_28911__$1;
(statearr_28981_29045[(2)] = inst_28890);

(statearr_28981_29045[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (30))){
var state_28911__$1 = state_28911;
var statearr_28982_29046 = state_28911__$1;
(statearr_28982_29046[(2)] = null);

(statearr_28982_29046[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (10))){
var inst_28793 = (state_28911[(13)]);
var inst_28795 = (state_28911[(14)]);
var inst_28801 = cljs.core._nth.call(null,inst_28793,inst_28795);
var inst_28802 = cljs.core.nth.call(null,inst_28801,(0),null);
var inst_28803 = cljs.core.nth.call(null,inst_28801,(1),null);
var state_28911__$1 = (function (){var statearr_28983 = state_28911;
(statearr_28983[(26)] = inst_28802);

return statearr_28983;
})();
if(cljs.core.truth_(inst_28803)){
var statearr_28984_29047 = state_28911__$1;
(statearr_28984_29047[(1)] = (13));

} else {
var statearr_28985_29048 = state_28911__$1;
(statearr_28985_29048[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (18))){
var inst_28836 = (state_28911[(2)]);
var state_28911__$1 = state_28911;
var statearr_28986_29049 = state_28911__$1;
(statearr_28986_29049[(2)] = inst_28836);

(statearr_28986_29049[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (42))){
var state_28911__$1 = state_28911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28911__$1,(45),dchan);
} else {
if((state_val_28912 === (37))){
var inst_28870 = (state_28911[(25)]);
var inst_28783 = (state_28911[(11)]);
var inst_28879 = (state_28911[(23)]);
var inst_28879__$1 = cljs.core.first.call(null,inst_28870);
var inst_28880 = cljs.core.async.put_BANG_.call(null,inst_28879__$1,inst_28783,done);
var state_28911__$1 = (function (){var statearr_28987 = state_28911;
(statearr_28987[(23)] = inst_28879__$1);

return statearr_28987;
})();
if(cljs.core.truth_(inst_28880)){
var statearr_28988_29050 = state_28911__$1;
(statearr_28988_29050[(1)] = (39));

} else {
var statearr_28989_29051 = state_28911__$1;
(statearr_28989_29051[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28912 === (8))){
var inst_28795 = (state_28911[(14)]);
var inst_28794 = (state_28911[(17)]);
var inst_28797 = (inst_28795 < inst_28794);
var inst_28798 = inst_28797;
var state_28911__$1 = state_28911;
if(cljs.core.truth_(inst_28798)){
var statearr_28990_29052 = state_28911__$1;
(statearr_28990_29052[(1)] = (10));

} else {
var statearr_28991_29053 = state_28911__$1;
(statearr_28991_29053[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___28999,cs,m,dchan,dctr,done))
;
return ((function (switch__21216__auto__,c__21281__auto___28999,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__21217__auto__ = null;
var cljs$core$async$mult_$_state_machine__21217__auto____0 = (function (){
var statearr_28995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28995[(0)] = cljs$core$async$mult_$_state_machine__21217__auto__);

(statearr_28995[(1)] = (1));

return statearr_28995;
});
var cljs$core$async$mult_$_state_machine__21217__auto____1 = (function (state_28911){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_28911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e28996){if((e28996 instanceof Object)){
var ex__21220__auto__ = e28996;
var statearr_28997_29054 = state_28911;
(statearr_28997_29054[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28996;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29055 = state_28911;
state_28911 = G__29055;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__21217__auto__ = function(state_28911){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__21217__auto____1.call(this,state_28911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__21217__auto____0;
cljs$core$async$mult_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__21217__auto____1;
return cljs$core$async$mult_$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___28999,cs,m,dchan,dctr,done))
})();
var state__21283__auto__ = (function (){var statearr_28998 = f__21282__auto__.call(null);
(statearr_28998[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___28999);

return statearr_28998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___28999,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args29056 = [];
var len__18398__auto___29059 = arguments.length;
var i__18399__auto___29060 = (0);
while(true){
if((i__18399__auto___29060 < len__18398__auto___29059)){
args29056.push((arguments[i__18399__auto___29060]));

var G__29061 = (i__18399__auto___29060 + (1));
i__18399__auto___29060 = G__29061;
continue;
} else {
}
break;
}

var G__29058 = args29056.length;
switch (G__29058) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29056.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m,ch);
} else {
var m__17996__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m,ch);
} else {
var m__17996__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m);
} else {
var m__17996__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m,state_map);
} else {
var m__17996__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__17995__auto__ = (((m == null))?null:m);
var m__17996__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,m,mode);
} else {
var m__17996__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__18405__auto__ = [];
var len__18398__auto___29075 = arguments.length;
var i__18399__auto___29076 = (0);
while(true){
if((i__18399__auto___29076 < len__18398__auto___29075)){
args__18405__auto__.push((arguments[i__18399__auto___29076]));

var G__29077 = (i__18399__auto___29076 + (1));
i__18399__auto___29076 = G__29077;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((3) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__18406__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29069){
var map__29070 = p__29069;
var map__29070__$1 = ((((!((map__29070 == null)))?((((map__29070.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29070.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29070):map__29070);
var opts = map__29070__$1;
var statearr_29072_29078 = state;
(statearr_29072_29078[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__29070,map__29070__$1,opts){
return (function (val){
var statearr_29073_29079 = state;
(statearr_29073_29079[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__29070,map__29070__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_29074_29080 = state;
(statearr_29074_29080[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29065){
var G__29066 = cljs.core.first.call(null,seq29065);
var seq29065__$1 = cljs.core.next.call(null,seq29065);
var G__29067 = cljs.core.first.call(null,seq29065__$1);
var seq29065__$2 = cljs.core.next.call(null,seq29065__$1);
var G__29068 = cljs.core.first.call(null,seq29065__$2);
var seq29065__$3 = cljs.core.next.call(null,seq29065__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29066,G__29067,G__29068,seq29065__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t29244 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29244 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29245){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29245 = meta29245;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29244.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29246,meta29245__$1){
var self__ = this;
var _29246__$1 = this;
return (new cljs.core.async.t29244(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29245__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29246){
var self__ = this;
var _29246__$1 = this;
return self__.meta29245;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t29244.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t29244.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29245","meta29245",69070935,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29244.cljs$lang$type = true;

cljs.core.async.t29244.cljs$lang$ctorStr = "cljs.core.async/t29244";

cljs.core.async.t29244.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t29244");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t29244 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t29244(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29245){
return (new cljs.core.async.t29244(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29245));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t29244(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__21281__auto___29407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___29407,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___29407,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_29344){
var state_val_29345 = (state_29344[(1)]);
if((state_val_29345 === (7))){
var inst_29262 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
var statearr_29346_29408 = state_29344__$1;
(statearr_29346_29408[(2)] = inst_29262);

(statearr_29346_29408[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (20))){
var inst_29274 = (state_29344[(7)]);
var state_29344__$1 = state_29344;
var statearr_29347_29409 = state_29344__$1;
(statearr_29347_29409[(2)] = inst_29274);

(statearr_29347_29409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (27))){
var state_29344__$1 = state_29344;
var statearr_29348_29410 = state_29344__$1;
(statearr_29348_29410[(2)] = null);

(statearr_29348_29410[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (1))){
var inst_29250 = (state_29344[(8)]);
var inst_29250__$1 = calc_state.call(null);
var inst_29252 = (inst_29250__$1 == null);
var inst_29253 = cljs.core.not.call(null,inst_29252);
var state_29344__$1 = (function (){var statearr_29349 = state_29344;
(statearr_29349[(8)] = inst_29250__$1);

return statearr_29349;
})();
if(inst_29253){
var statearr_29350_29411 = state_29344__$1;
(statearr_29350_29411[(1)] = (2));

} else {
var statearr_29351_29412 = state_29344__$1;
(statearr_29351_29412[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (24))){
var inst_29318 = (state_29344[(9)]);
var inst_29304 = (state_29344[(10)]);
var inst_29297 = (state_29344[(11)]);
var inst_29318__$1 = inst_29297.call(null,inst_29304);
var state_29344__$1 = (function (){var statearr_29352 = state_29344;
(statearr_29352[(9)] = inst_29318__$1);

return statearr_29352;
})();
if(cljs.core.truth_(inst_29318__$1)){
var statearr_29353_29413 = state_29344__$1;
(statearr_29353_29413[(1)] = (29));

} else {
var statearr_29354_29414 = state_29344__$1;
(statearr_29354_29414[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (4))){
var inst_29265 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29265)){
var statearr_29355_29415 = state_29344__$1;
(statearr_29355_29415[(1)] = (8));

} else {
var statearr_29356_29416 = state_29344__$1;
(statearr_29356_29416[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (15))){
var inst_29291 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29291)){
var statearr_29357_29417 = state_29344__$1;
(statearr_29357_29417[(1)] = (19));

} else {
var statearr_29358_29418 = state_29344__$1;
(statearr_29358_29418[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (21))){
var inst_29296 = (state_29344[(12)]);
var inst_29296__$1 = (state_29344[(2)]);
var inst_29297 = cljs.core.get.call(null,inst_29296__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29298 = cljs.core.get.call(null,inst_29296__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29299 = cljs.core.get.call(null,inst_29296__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29344__$1 = (function (){var statearr_29359 = state_29344;
(statearr_29359[(12)] = inst_29296__$1);

(statearr_29359[(11)] = inst_29297);

(statearr_29359[(13)] = inst_29298);

return statearr_29359;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29344__$1,(22),inst_29299);
} else {
if((state_val_29345 === (31))){
var inst_29326 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29326)){
var statearr_29360_29419 = state_29344__$1;
(statearr_29360_29419[(1)] = (32));

} else {
var statearr_29361_29420 = state_29344__$1;
(statearr_29361_29420[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (32))){
var inst_29303 = (state_29344[(14)]);
var state_29344__$1 = state_29344;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29344__$1,(35),out,inst_29303);
} else {
if((state_val_29345 === (33))){
var inst_29296 = (state_29344[(12)]);
var inst_29274 = inst_29296;
var state_29344__$1 = (function (){var statearr_29362 = state_29344;
(statearr_29362[(7)] = inst_29274);

return statearr_29362;
})();
var statearr_29363_29421 = state_29344__$1;
(statearr_29363_29421[(2)] = null);

(statearr_29363_29421[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (13))){
var inst_29274 = (state_29344[(7)]);
var inst_29281 = inst_29274.cljs$lang$protocol_mask$partition0$;
var inst_29282 = (inst_29281 & (64));
var inst_29283 = inst_29274.cljs$core$ISeq$;
var inst_29284 = (inst_29282) || (inst_29283);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29284)){
var statearr_29364_29422 = state_29344__$1;
(statearr_29364_29422[(1)] = (16));

} else {
var statearr_29365_29423 = state_29344__$1;
(statearr_29365_29423[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (22))){
var inst_29303 = (state_29344[(14)]);
var inst_29304 = (state_29344[(10)]);
var inst_29302 = (state_29344[(2)]);
var inst_29303__$1 = cljs.core.nth.call(null,inst_29302,(0),null);
var inst_29304__$1 = cljs.core.nth.call(null,inst_29302,(1),null);
var inst_29305 = (inst_29303__$1 == null);
var inst_29306 = cljs.core._EQ_.call(null,inst_29304__$1,change);
var inst_29307 = (inst_29305) || (inst_29306);
var state_29344__$1 = (function (){var statearr_29366 = state_29344;
(statearr_29366[(14)] = inst_29303__$1);

(statearr_29366[(10)] = inst_29304__$1);

return statearr_29366;
})();
if(cljs.core.truth_(inst_29307)){
var statearr_29367_29424 = state_29344__$1;
(statearr_29367_29424[(1)] = (23));

} else {
var statearr_29368_29425 = state_29344__$1;
(statearr_29368_29425[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (36))){
var inst_29296 = (state_29344[(12)]);
var inst_29274 = inst_29296;
var state_29344__$1 = (function (){var statearr_29369 = state_29344;
(statearr_29369[(7)] = inst_29274);

return statearr_29369;
})();
var statearr_29370_29426 = state_29344__$1;
(statearr_29370_29426[(2)] = null);

(statearr_29370_29426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (29))){
var inst_29318 = (state_29344[(9)]);
var state_29344__$1 = state_29344;
var statearr_29371_29427 = state_29344__$1;
(statearr_29371_29427[(2)] = inst_29318);

(statearr_29371_29427[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (6))){
var state_29344__$1 = state_29344;
var statearr_29372_29428 = state_29344__$1;
(statearr_29372_29428[(2)] = false);

(statearr_29372_29428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (28))){
var inst_29314 = (state_29344[(2)]);
var inst_29315 = calc_state.call(null);
var inst_29274 = inst_29315;
var state_29344__$1 = (function (){var statearr_29373 = state_29344;
(statearr_29373[(7)] = inst_29274);

(statearr_29373[(15)] = inst_29314);

return statearr_29373;
})();
var statearr_29374_29429 = state_29344__$1;
(statearr_29374_29429[(2)] = null);

(statearr_29374_29429[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (25))){
var inst_29340 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
var statearr_29375_29430 = state_29344__$1;
(statearr_29375_29430[(2)] = inst_29340);

(statearr_29375_29430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (34))){
var inst_29338 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
var statearr_29376_29431 = state_29344__$1;
(statearr_29376_29431[(2)] = inst_29338);

(statearr_29376_29431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (17))){
var state_29344__$1 = state_29344;
var statearr_29377_29432 = state_29344__$1;
(statearr_29377_29432[(2)] = false);

(statearr_29377_29432[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (3))){
var state_29344__$1 = state_29344;
var statearr_29378_29433 = state_29344__$1;
(statearr_29378_29433[(2)] = false);

(statearr_29378_29433[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (12))){
var inst_29342 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29344__$1,inst_29342);
} else {
if((state_val_29345 === (2))){
var inst_29250 = (state_29344[(8)]);
var inst_29255 = inst_29250.cljs$lang$protocol_mask$partition0$;
var inst_29256 = (inst_29255 & (64));
var inst_29257 = inst_29250.cljs$core$ISeq$;
var inst_29258 = (inst_29256) || (inst_29257);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29258)){
var statearr_29379_29434 = state_29344__$1;
(statearr_29379_29434[(1)] = (5));

} else {
var statearr_29380_29435 = state_29344__$1;
(statearr_29380_29435[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (23))){
var inst_29303 = (state_29344[(14)]);
var inst_29309 = (inst_29303 == null);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29309)){
var statearr_29381_29436 = state_29344__$1;
(statearr_29381_29436[(1)] = (26));

} else {
var statearr_29382_29437 = state_29344__$1;
(statearr_29382_29437[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (35))){
var inst_29329 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
if(cljs.core.truth_(inst_29329)){
var statearr_29383_29438 = state_29344__$1;
(statearr_29383_29438[(1)] = (36));

} else {
var statearr_29384_29439 = state_29344__$1;
(statearr_29384_29439[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (19))){
var inst_29274 = (state_29344[(7)]);
var inst_29293 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29274);
var state_29344__$1 = state_29344;
var statearr_29385_29440 = state_29344__$1;
(statearr_29385_29440[(2)] = inst_29293);

(statearr_29385_29440[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (11))){
var inst_29274 = (state_29344[(7)]);
var inst_29278 = (inst_29274 == null);
var inst_29279 = cljs.core.not.call(null,inst_29278);
var state_29344__$1 = state_29344;
if(inst_29279){
var statearr_29386_29441 = state_29344__$1;
(statearr_29386_29441[(1)] = (13));

} else {
var statearr_29387_29442 = state_29344__$1;
(statearr_29387_29442[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (9))){
var inst_29250 = (state_29344[(8)]);
var state_29344__$1 = state_29344;
var statearr_29388_29443 = state_29344__$1;
(statearr_29388_29443[(2)] = inst_29250);

(statearr_29388_29443[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (5))){
var state_29344__$1 = state_29344;
var statearr_29389_29444 = state_29344__$1;
(statearr_29389_29444[(2)] = true);

(statearr_29389_29444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (14))){
var state_29344__$1 = state_29344;
var statearr_29390_29445 = state_29344__$1;
(statearr_29390_29445[(2)] = false);

(statearr_29390_29445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (26))){
var inst_29304 = (state_29344[(10)]);
var inst_29311 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_29304);
var state_29344__$1 = state_29344;
var statearr_29391_29446 = state_29344__$1;
(statearr_29391_29446[(2)] = inst_29311);

(statearr_29391_29446[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (16))){
var state_29344__$1 = state_29344;
var statearr_29392_29447 = state_29344__$1;
(statearr_29392_29447[(2)] = true);

(statearr_29392_29447[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (38))){
var inst_29334 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
var statearr_29393_29448 = state_29344__$1;
(statearr_29393_29448[(2)] = inst_29334);

(statearr_29393_29448[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (30))){
var inst_29304 = (state_29344[(10)]);
var inst_29297 = (state_29344[(11)]);
var inst_29298 = (state_29344[(13)]);
var inst_29321 = cljs.core.empty_QMARK_.call(null,inst_29297);
var inst_29322 = inst_29298.call(null,inst_29304);
var inst_29323 = cljs.core.not.call(null,inst_29322);
var inst_29324 = (inst_29321) && (inst_29323);
var state_29344__$1 = state_29344;
var statearr_29394_29449 = state_29344__$1;
(statearr_29394_29449[(2)] = inst_29324);

(statearr_29394_29449[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (10))){
var inst_29250 = (state_29344[(8)]);
var inst_29270 = (state_29344[(2)]);
var inst_29271 = cljs.core.get.call(null,inst_29270,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29272 = cljs.core.get.call(null,inst_29270,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29273 = cljs.core.get.call(null,inst_29270,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29274 = inst_29250;
var state_29344__$1 = (function (){var statearr_29395 = state_29344;
(statearr_29395[(7)] = inst_29274);

(statearr_29395[(16)] = inst_29271);

(statearr_29395[(17)] = inst_29272);

(statearr_29395[(18)] = inst_29273);

return statearr_29395;
})();
var statearr_29396_29450 = state_29344__$1;
(statearr_29396_29450[(2)] = null);

(statearr_29396_29450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (18))){
var inst_29288 = (state_29344[(2)]);
var state_29344__$1 = state_29344;
var statearr_29397_29451 = state_29344__$1;
(statearr_29397_29451[(2)] = inst_29288);

(statearr_29397_29451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (37))){
var state_29344__$1 = state_29344;
var statearr_29398_29452 = state_29344__$1;
(statearr_29398_29452[(2)] = null);

(statearr_29398_29452[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29345 === (8))){
var inst_29250 = (state_29344[(8)]);
var inst_29267 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29250);
var state_29344__$1 = state_29344;
var statearr_29399_29453 = state_29344__$1;
(statearr_29399_29453[(2)] = inst_29267);

(statearr_29399_29453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___29407,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__21216__auto__,c__21281__auto___29407,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__21217__auto__ = null;
var cljs$core$async$mix_$_state_machine__21217__auto____0 = (function (){
var statearr_29403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29403[(0)] = cljs$core$async$mix_$_state_machine__21217__auto__);

(statearr_29403[(1)] = (1));

return statearr_29403;
});
var cljs$core$async$mix_$_state_machine__21217__auto____1 = (function (state_29344){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_29344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e29404){if((e29404 instanceof Object)){
var ex__21220__auto__ = e29404;
var statearr_29405_29454 = state_29344;
(statearr_29405_29454[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29455 = state_29344;
state_29344 = G__29455;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__21217__auto__ = function(state_29344){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__21217__auto____1.call(this,state_29344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__21217__auto____0;
cljs$core$async$mix_$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__21217__auto____1;
return cljs$core$async$mix_$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___29407,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__21283__auto__ = (function (){var statearr_29406 = f__21282__auto__.call(null);
(statearr_29406[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___29407);

return statearr_29406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___29407,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__17995__auto__ = (((p == null))?null:p);
var m__17996__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__17996__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__17995__auto__ = (((p == null))?null:p);
var m__17996__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,p,v,ch);
} else {
var m__17996__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args29458 = [];
var len__18398__auto___29461 = arguments.length;
var i__18399__auto___29462 = (0);
while(true){
if((i__18399__auto___29462 < len__18398__auto___29461)){
args29458.push((arguments[i__18399__auto___29462]));

var G__29463 = (i__18399__auto___29462 + (1));
i__18399__auto___29462 = G__29463;
continue;
} else {
}
break;
}

var G__29460 = args29458.length;
switch (G__29460) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29458.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__17995__auto__ = (((p == null))?null:p);
var m__17996__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,p);
} else {
var m__17996__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__17995__auto__ = (((p == null))?null:p);
var m__17996__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,p,v);
} else {
var m__17996__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args29466 = [];
var len__18398__auto___29591 = arguments.length;
var i__18399__auto___29592 = (0);
while(true){
if((i__18399__auto___29592 < len__18398__auto___29591)){
args29466.push((arguments[i__18399__auto___29592]));

var G__29593 = (i__18399__auto___29592 + (1));
i__18399__auto___29592 = G__29593;
continue;
} else {
}
break;
}

var G__29468 = args29466.length;
switch (G__29468) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29466.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__17359__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__17359__auto__,mults){
return (function (p1__29465_SHARP_){
if(cljs.core.truth_(p1__29465_SHARP_.call(null,topic))){
return p1__29465_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__29465_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__17359__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t29469 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29469 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29470){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29470 = meta29470;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29469.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_29471,meta29470__$1){
var self__ = this;
var _29471__$1 = this;
return (new cljs.core.async.t29469(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29470__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t29469.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_29471){
var self__ = this;
var _29471__$1 = this;
return self__.meta29470;
});})(mults,ensure_mult))
;

cljs.core.async.t29469.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t29469.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t29469.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t29469.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t29469.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t29469.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t29469.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t29469.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29470","meta29470",-1560174056,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t29469.cljs$lang$type = true;

cljs.core.async.t29469.cljs$lang$ctorStr = "cljs.core.async/t29469";

cljs.core.async.t29469.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t29469");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t29469 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t29469(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29470){
return (new cljs.core.async.t29469(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29470));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t29469(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__21281__auto___29595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___29595,mults,ensure_mult,p){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___29595,mults,ensure_mult,p){
return (function (state_29543){
var state_val_29544 = (state_29543[(1)]);
if((state_val_29544 === (7))){
var inst_29539 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
var statearr_29545_29596 = state_29543__$1;
(statearr_29545_29596[(2)] = inst_29539);

(statearr_29545_29596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (20))){
var state_29543__$1 = state_29543;
var statearr_29546_29597 = state_29543__$1;
(statearr_29546_29597[(2)] = null);

(statearr_29546_29597[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (1))){
var state_29543__$1 = state_29543;
var statearr_29547_29598 = state_29543__$1;
(statearr_29547_29598[(2)] = null);

(statearr_29547_29598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (24))){
var inst_29522 = (state_29543[(7)]);
var inst_29531 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_29522);
var state_29543__$1 = state_29543;
var statearr_29548_29599 = state_29543__$1;
(statearr_29548_29599[(2)] = inst_29531);

(statearr_29548_29599[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (4))){
var inst_29474 = (state_29543[(8)]);
var inst_29474__$1 = (state_29543[(2)]);
var inst_29475 = (inst_29474__$1 == null);
var state_29543__$1 = (function (){var statearr_29549 = state_29543;
(statearr_29549[(8)] = inst_29474__$1);

return statearr_29549;
})();
if(cljs.core.truth_(inst_29475)){
var statearr_29550_29600 = state_29543__$1;
(statearr_29550_29600[(1)] = (5));

} else {
var statearr_29551_29601 = state_29543__$1;
(statearr_29551_29601[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (15))){
var inst_29516 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
var statearr_29552_29602 = state_29543__$1;
(statearr_29552_29602[(2)] = inst_29516);

(statearr_29552_29602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (21))){
var inst_29536 = (state_29543[(2)]);
var state_29543__$1 = (function (){var statearr_29553 = state_29543;
(statearr_29553[(9)] = inst_29536);

return statearr_29553;
})();
var statearr_29554_29603 = state_29543__$1;
(statearr_29554_29603[(2)] = null);

(statearr_29554_29603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (13))){
var inst_29498 = (state_29543[(10)]);
var inst_29500 = cljs.core.chunked_seq_QMARK_.call(null,inst_29498);
var state_29543__$1 = state_29543;
if(inst_29500){
var statearr_29555_29604 = state_29543__$1;
(statearr_29555_29604[(1)] = (16));

} else {
var statearr_29556_29605 = state_29543__$1;
(statearr_29556_29605[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (22))){
var inst_29528 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
if(cljs.core.truth_(inst_29528)){
var statearr_29557_29606 = state_29543__$1;
(statearr_29557_29606[(1)] = (23));

} else {
var statearr_29558_29607 = state_29543__$1;
(statearr_29558_29607[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (6))){
var inst_29524 = (state_29543[(11)]);
var inst_29474 = (state_29543[(8)]);
var inst_29522 = (state_29543[(7)]);
var inst_29522__$1 = topic_fn.call(null,inst_29474);
var inst_29523 = cljs.core.deref.call(null,mults);
var inst_29524__$1 = cljs.core.get.call(null,inst_29523,inst_29522__$1);
var state_29543__$1 = (function (){var statearr_29559 = state_29543;
(statearr_29559[(11)] = inst_29524__$1);

(statearr_29559[(7)] = inst_29522__$1);

return statearr_29559;
})();
if(cljs.core.truth_(inst_29524__$1)){
var statearr_29560_29608 = state_29543__$1;
(statearr_29560_29608[(1)] = (19));

} else {
var statearr_29561_29609 = state_29543__$1;
(statearr_29561_29609[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (25))){
var inst_29533 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
var statearr_29562_29610 = state_29543__$1;
(statearr_29562_29610[(2)] = inst_29533);

(statearr_29562_29610[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (17))){
var inst_29498 = (state_29543[(10)]);
var inst_29507 = cljs.core.first.call(null,inst_29498);
var inst_29508 = cljs.core.async.muxch_STAR_.call(null,inst_29507);
var inst_29509 = cljs.core.async.close_BANG_.call(null,inst_29508);
var inst_29510 = cljs.core.next.call(null,inst_29498);
var inst_29484 = inst_29510;
var inst_29485 = null;
var inst_29486 = (0);
var inst_29487 = (0);
var state_29543__$1 = (function (){var statearr_29563 = state_29543;
(statearr_29563[(12)] = inst_29486);

(statearr_29563[(13)] = inst_29484);

(statearr_29563[(14)] = inst_29487);

(statearr_29563[(15)] = inst_29485);

(statearr_29563[(16)] = inst_29509);

return statearr_29563;
})();
var statearr_29564_29611 = state_29543__$1;
(statearr_29564_29611[(2)] = null);

(statearr_29564_29611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (3))){
var inst_29541 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29543__$1,inst_29541);
} else {
if((state_val_29544 === (12))){
var inst_29518 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
var statearr_29565_29612 = state_29543__$1;
(statearr_29565_29612[(2)] = inst_29518);

(statearr_29565_29612[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (2))){
var state_29543__$1 = state_29543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29543__$1,(4),ch);
} else {
if((state_val_29544 === (23))){
var state_29543__$1 = state_29543;
var statearr_29566_29613 = state_29543__$1;
(statearr_29566_29613[(2)] = null);

(statearr_29566_29613[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (19))){
var inst_29524 = (state_29543[(11)]);
var inst_29474 = (state_29543[(8)]);
var inst_29526 = cljs.core.async.muxch_STAR_.call(null,inst_29524);
var state_29543__$1 = state_29543;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29543__$1,(22),inst_29526,inst_29474);
} else {
if((state_val_29544 === (11))){
var inst_29484 = (state_29543[(13)]);
var inst_29498 = (state_29543[(10)]);
var inst_29498__$1 = cljs.core.seq.call(null,inst_29484);
var state_29543__$1 = (function (){var statearr_29567 = state_29543;
(statearr_29567[(10)] = inst_29498__$1);

return statearr_29567;
})();
if(inst_29498__$1){
var statearr_29568_29614 = state_29543__$1;
(statearr_29568_29614[(1)] = (13));

} else {
var statearr_29569_29615 = state_29543__$1;
(statearr_29569_29615[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (9))){
var inst_29520 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
var statearr_29570_29616 = state_29543__$1;
(statearr_29570_29616[(2)] = inst_29520);

(statearr_29570_29616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (5))){
var inst_29481 = cljs.core.deref.call(null,mults);
var inst_29482 = cljs.core.vals.call(null,inst_29481);
var inst_29483 = cljs.core.seq.call(null,inst_29482);
var inst_29484 = inst_29483;
var inst_29485 = null;
var inst_29486 = (0);
var inst_29487 = (0);
var state_29543__$1 = (function (){var statearr_29571 = state_29543;
(statearr_29571[(12)] = inst_29486);

(statearr_29571[(13)] = inst_29484);

(statearr_29571[(14)] = inst_29487);

(statearr_29571[(15)] = inst_29485);

return statearr_29571;
})();
var statearr_29572_29617 = state_29543__$1;
(statearr_29572_29617[(2)] = null);

(statearr_29572_29617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (14))){
var state_29543__$1 = state_29543;
var statearr_29576_29618 = state_29543__$1;
(statearr_29576_29618[(2)] = null);

(statearr_29576_29618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (16))){
var inst_29498 = (state_29543[(10)]);
var inst_29502 = cljs.core.chunk_first.call(null,inst_29498);
var inst_29503 = cljs.core.chunk_rest.call(null,inst_29498);
var inst_29504 = cljs.core.count.call(null,inst_29502);
var inst_29484 = inst_29503;
var inst_29485 = inst_29502;
var inst_29486 = inst_29504;
var inst_29487 = (0);
var state_29543__$1 = (function (){var statearr_29577 = state_29543;
(statearr_29577[(12)] = inst_29486);

(statearr_29577[(13)] = inst_29484);

(statearr_29577[(14)] = inst_29487);

(statearr_29577[(15)] = inst_29485);

return statearr_29577;
})();
var statearr_29578_29619 = state_29543__$1;
(statearr_29578_29619[(2)] = null);

(statearr_29578_29619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (10))){
var inst_29486 = (state_29543[(12)]);
var inst_29484 = (state_29543[(13)]);
var inst_29487 = (state_29543[(14)]);
var inst_29485 = (state_29543[(15)]);
var inst_29492 = cljs.core._nth.call(null,inst_29485,inst_29487);
var inst_29493 = cljs.core.async.muxch_STAR_.call(null,inst_29492);
var inst_29494 = cljs.core.async.close_BANG_.call(null,inst_29493);
var inst_29495 = (inst_29487 + (1));
var tmp29573 = inst_29486;
var tmp29574 = inst_29484;
var tmp29575 = inst_29485;
var inst_29484__$1 = tmp29574;
var inst_29485__$1 = tmp29575;
var inst_29486__$1 = tmp29573;
var inst_29487__$1 = inst_29495;
var state_29543__$1 = (function (){var statearr_29579 = state_29543;
(statearr_29579[(12)] = inst_29486__$1);

(statearr_29579[(13)] = inst_29484__$1);

(statearr_29579[(14)] = inst_29487__$1);

(statearr_29579[(15)] = inst_29485__$1);

(statearr_29579[(17)] = inst_29494);

return statearr_29579;
})();
var statearr_29580_29620 = state_29543__$1;
(statearr_29580_29620[(2)] = null);

(statearr_29580_29620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (18))){
var inst_29513 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
var statearr_29581_29621 = state_29543__$1;
(statearr_29581_29621[(2)] = inst_29513);

(statearr_29581_29621[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (8))){
var inst_29486 = (state_29543[(12)]);
var inst_29487 = (state_29543[(14)]);
var inst_29489 = (inst_29487 < inst_29486);
var inst_29490 = inst_29489;
var state_29543__$1 = state_29543;
if(cljs.core.truth_(inst_29490)){
var statearr_29582_29622 = state_29543__$1;
(statearr_29582_29622[(1)] = (10));

} else {
var statearr_29583_29623 = state_29543__$1;
(statearr_29583_29623[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___29595,mults,ensure_mult,p))
;
return ((function (switch__21216__auto__,c__21281__auto___29595,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_29587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29587[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_29587[(1)] = (1));

return statearr_29587;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_29543){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_29543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e29588){if((e29588 instanceof Object)){
var ex__21220__auto__ = e29588;
var statearr_29589_29624 = state_29543;
(statearr_29589_29624[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29543);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29625 = state_29543;
state_29543 = G__29625;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_29543){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_29543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___29595,mults,ensure_mult,p))
})();
var state__21283__auto__ = (function (){var statearr_29590 = f__21282__auto__.call(null);
(statearr_29590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___29595);

return statearr_29590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___29595,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args29626 = [];
var len__18398__auto___29629 = arguments.length;
var i__18399__auto___29630 = (0);
while(true){
if((i__18399__auto___29630 < len__18398__auto___29629)){
args29626.push((arguments[i__18399__auto___29630]));

var G__29631 = (i__18399__auto___29630 + (1));
i__18399__auto___29630 = G__29631;
continue;
} else {
}
break;
}

var G__29628 = args29626.length;
switch (G__29628) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29626.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args29633 = [];
var len__18398__auto___29636 = arguments.length;
var i__18399__auto___29637 = (0);
while(true){
if((i__18399__auto___29637 < len__18398__auto___29636)){
args29633.push((arguments[i__18399__auto___29637]));

var G__29638 = (i__18399__auto___29637 + (1));
i__18399__auto___29637 = G__29638;
continue;
} else {
}
break;
}

var G__29635 = args29633.length;
switch (G__29635) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29633.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args29640 = [];
var len__18398__auto___29711 = arguments.length;
var i__18399__auto___29712 = (0);
while(true){
if((i__18399__auto___29712 < len__18398__auto___29711)){
args29640.push((arguments[i__18399__auto___29712]));

var G__29713 = (i__18399__auto___29712 + (1));
i__18399__auto___29712 = G__29713;
continue;
} else {
}
break;
}

var G__29642 = args29640.length;
switch (G__29642) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29640.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__21281__auto___29715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___29715,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___29715,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_29681){
var state_val_29682 = (state_29681[(1)]);
if((state_val_29682 === (7))){
var state_29681__$1 = state_29681;
var statearr_29683_29716 = state_29681__$1;
(statearr_29683_29716[(2)] = null);

(statearr_29683_29716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (1))){
var state_29681__$1 = state_29681;
var statearr_29684_29717 = state_29681__$1;
(statearr_29684_29717[(2)] = null);

(statearr_29684_29717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (4))){
var inst_29645 = (state_29681[(7)]);
var inst_29647 = (inst_29645 < cnt);
var state_29681__$1 = state_29681;
if(cljs.core.truth_(inst_29647)){
var statearr_29685_29718 = state_29681__$1;
(statearr_29685_29718[(1)] = (6));

} else {
var statearr_29686_29719 = state_29681__$1;
(statearr_29686_29719[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (15))){
var inst_29677 = (state_29681[(2)]);
var state_29681__$1 = state_29681;
var statearr_29687_29720 = state_29681__$1;
(statearr_29687_29720[(2)] = inst_29677);

(statearr_29687_29720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (13))){
var inst_29670 = cljs.core.async.close_BANG_.call(null,out);
var state_29681__$1 = state_29681;
var statearr_29688_29721 = state_29681__$1;
(statearr_29688_29721[(2)] = inst_29670);

(statearr_29688_29721[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (6))){
var state_29681__$1 = state_29681;
var statearr_29689_29722 = state_29681__$1;
(statearr_29689_29722[(2)] = null);

(statearr_29689_29722[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (3))){
var inst_29679 = (state_29681[(2)]);
var state_29681__$1 = state_29681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29681__$1,inst_29679);
} else {
if((state_val_29682 === (12))){
var inst_29667 = (state_29681[(8)]);
var inst_29667__$1 = (state_29681[(2)]);
var inst_29668 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_29667__$1);
var state_29681__$1 = (function (){var statearr_29690 = state_29681;
(statearr_29690[(8)] = inst_29667__$1);

return statearr_29690;
})();
if(cljs.core.truth_(inst_29668)){
var statearr_29691_29723 = state_29681__$1;
(statearr_29691_29723[(1)] = (13));

} else {
var statearr_29692_29724 = state_29681__$1;
(statearr_29692_29724[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (2))){
var inst_29644 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_29645 = (0);
var state_29681__$1 = (function (){var statearr_29693 = state_29681;
(statearr_29693[(9)] = inst_29644);

(statearr_29693[(7)] = inst_29645);

return statearr_29693;
})();
var statearr_29694_29725 = state_29681__$1;
(statearr_29694_29725[(2)] = null);

(statearr_29694_29725[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (11))){
var inst_29645 = (state_29681[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_29681,(10),Object,null,(9));
var inst_29654 = chs__$1.call(null,inst_29645);
var inst_29655 = done.call(null,inst_29645);
var inst_29656 = cljs.core.async.take_BANG_.call(null,inst_29654,inst_29655);
var state_29681__$1 = state_29681;
var statearr_29695_29726 = state_29681__$1;
(statearr_29695_29726[(2)] = inst_29656);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29681__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (9))){
var inst_29645 = (state_29681[(7)]);
var inst_29658 = (state_29681[(2)]);
var inst_29659 = (inst_29645 + (1));
var inst_29645__$1 = inst_29659;
var state_29681__$1 = (function (){var statearr_29696 = state_29681;
(statearr_29696[(10)] = inst_29658);

(statearr_29696[(7)] = inst_29645__$1);

return statearr_29696;
})();
var statearr_29697_29727 = state_29681__$1;
(statearr_29697_29727[(2)] = null);

(statearr_29697_29727[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (5))){
var inst_29665 = (state_29681[(2)]);
var state_29681__$1 = (function (){var statearr_29698 = state_29681;
(statearr_29698[(11)] = inst_29665);

return statearr_29698;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29681__$1,(12),dchan);
} else {
if((state_val_29682 === (14))){
var inst_29667 = (state_29681[(8)]);
var inst_29672 = cljs.core.apply.call(null,f,inst_29667);
var state_29681__$1 = state_29681;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29681__$1,(16),out,inst_29672);
} else {
if((state_val_29682 === (16))){
var inst_29674 = (state_29681[(2)]);
var state_29681__$1 = (function (){var statearr_29699 = state_29681;
(statearr_29699[(12)] = inst_29674);

return statearr_29699;
})();
var statearr_29700_29728 = state_29681__$1;
(statearr_29700_29728[(2)] = null);

(statearr_29700_29728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (10))){
var inst_29649 = (state_29681[(2)]);
var inst_29650 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_29681__$1 = (function (){var statearr_29701 = state_29681;
(statearr_29701[(13)] = inst_29649);

return statearr_29701;
})();
var statearr_29702_29729 = state_29681__$1;
(statearr_29702_29729[(2)] = inst_29650);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29681__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29682 === (8))){
var inst_29663 = (state_29681[(2)]);
var state_29681__$1 = state_29681;
var statearr_29703_29730 = state_29681__$1;
(statearr_29703_29730[(2)] = inst_29663);

(statearr_29703_29730[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___29715,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__21216__auto__,c__21281__auto___29715,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_29707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29707[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_29707[(1)] = (1));

return statearr_29707;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_29681){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_29681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e29708){if((e29708 instanceof Object)){
var ex__21220__auto__ = e29708;
var statearr_29709_29731 = state_29681;
(statearr_29709_29731[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29681);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29732 = state_29681;
state_29681 = G__29732;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_29681){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_29681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___29715,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__21283__auto__ = (function (){var statearr_29710 = f__21282__auto__.call(null);
(statearr_29710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___29715);

return statearr_29710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___29715,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args29734 = [];
var len__18398__auto___29790 = arguments.length;
var i__18399__auto___29791 = (0);
while(true){
if((i__18399__auto___29791 < len__18398__auto___29790)){
args29734.push((arguments[i__18399__auto___29791]));

var G__29792 = (i__18399__auto___29791 + (1));
i__18399__auto___29791 = G__29792;
continue;
} else {
}
break;
}

var G__29736 = args29734.length;
switch (G__29736) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29734.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21281__auto___29794 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___29794,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___29794,out){
return (function (state_29766){
var state_val_29767 = (state_29766[(1)]);
if((state_val_29767 === (7))){
var inst_29746 = (state_29766[(7)]);
var inst_29745 = (state_29766[(8)]);
var inst_29745__$1 = (state_29766[(2)]);
var inst_29746__$1 = cljs.core.nth.call(null,inst_29745__$1,(0),null);
var inst_29747 = cljs.core.nth.call(null,inst_29745__$1,(1),null);
var inst_29748 = (inst_29746__$1 == null);
var state_29766__$1 = (function (){var statearr_29768 = state_29766;
(statearr_29768[(7)] = inst_29746__$1);

(statearr_29768[(9)] = inst_29747);

(statearr_29768[(8)] = inst_29745__$1);

return statearr_29768;
})();
if(cljs.core.truth_(inst_29748)){
var statearr_29769_29795 = state_29766__$1;
(statearr_29769_29795[(1)] = (8));

} else {
var statearr_29770_29796 = state_29766__$1;
(statearr_29770_29796[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (1))){
var inst_29737 = cljs.core.vec.call(null,chs);
var inst_29738 = inst_29737;
var state_29766__$1 = (function (){var statearr_29771 = state_29766;
(statearr_29771[(10)] = inst_29738);

return statearr_29771;
})();
var statearr_29772_29797 = state_29766__$1;
(statearr_29772_29797[(2)] = null);

(statearr_29772_29797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (4))){
var inst_29738 = (state_29766[(10)]);
var state_29766__$1 = state_29766;
return cljs.core.async.ioc_alts_BANG_.call(null,state_29766__$1,(7),inst_29738);
} else {
if((state_val_29767 === (6))){
var inst_29762 = (state_29766[(2)]);
var state_29766__$1 = state_29766;
var statearr_29773_29798 = state_29766__$1;
(statearr_29773_29798[(2)] = inst_29762);

(statearr_29773_29798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (3))){
var inst_29764 = (state_29766[(2)]);
var state_29766__$1 = state_29766;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29766__$1,inst_29764);
} else {
if((state_val_29767 === (2))){
var inst_29738 = (state_29766[(10)]);
var inst_29740 = cljs.core.count.call(null,inst_29738);
var inst_29741 = (inst_29740 > (0));
var state_29766__$1 = state_29766;
if(cljs.core.truth_(inst_29741)){
var statearr_29775_29799 = state_29766__$1;
(statearr_29775_29799[(1)] = (4));

} else {
var statearr_29776_29800 = state_29766__$1;
(statearr_29776_29800[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (11))){
var inst_29738 = (state_29766[(10)]);
var inst_29755 = (state_29766[(2)]);
var tmp29774 = inst_29738;
var inst_29738__$1 = tmp29774;
var state_29766__$1 = (function (){var statearr_29777 = state_29766;
(statearr_29777[(11)] = inst_29755);

(statearr_29777[(10)] = inst_29738__$1);

return statearr_29777;
})();
var statearr_29778_29801 = state_29766__$1;
(statearr_29778_29801[(2)] = null);

(statearr_29778_29801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (9))){
var inst_29746 = (state_29766[(7)]);
var state_29766__$1 = state_29766;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29766__$1,(11),out,inst_29746);
} else {
if((state_val_29767 === (5))){
var inst_29760 = cljs.core.async.close_BANG_.call(null,out);
var state_29766__$1 = state_29766;
var statearr_29779_29802 = state_29766__$1;
(statearr_29779_29802[(2)] = inst_29760);

(statearr_29779_29802[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (10))){
var inst_29758 = (state_29766[(2)]);
var state_29766__$1 = state_29766;
var statearr_29780_29803 = state_29766__$1;
(statearr_29780_29803[(2)] = inst_29758);

(statearr_29780_29803[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29767 === (8))){
var inst_29746 = (state_29766[(7)]);
var inst_29738 = (state_29766[(10)]);
var inst_29747 = (state_29766[(9)]);
var inst_29745 = (state_29766[(8)]);
var inst_29750 = (function (){var cs = inst_29738;
var vec__29743 = inst_29745;
var v = inst_29746;
var c = inst_29747;
return ((function (cs,vec__29743,v,c,inst_29746,inst_29738,inst_29747,inst_29745,state_val_29767,c__21281__auto___29794,out){
return (function (p1__29733_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__29733_SHARP_);
});
;})(cs,vec__29743,v,c,inst_29746,inst_29738,inst_29747,inst_29745,state_val_29767,c__21281__auto___29794,out))
})();
var inst_29751 = cljs.core.filterv.call(null,inst_29750,inst_29738);
var inst_29738__$1 = inst_29751;
var state_29766__$1 = (function (){var statearr_29781 = state_29766;
(statearr_29781[(10)] = inst_29738__$1);

return statearr_29781;
})();
var statearr_29782_29804 = state_29766__$1;
(statearr_29782_29804[(2)] = null);

(statearr_29782_29804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___29794,out))
;
return ((function (switch__21216__auto__,c__21281__auto___29794,out){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_29786 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29786[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_29786[(1)] = (1));

return statearr_29786;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_29766){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_29766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e29787){if((e29787 instanceof Object)){
var ex__21220__auto__ = e29787;
var statearr_29788_29805 = state_29766;
(statearr_29788_29805[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29766);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29787;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29806 = state_29766;
state_29766 = G__29806;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_29766){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_29766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___29794,out))
})();
var state__21283__auto__ = (function (){var statearr_29789 = f__21282__auto__.call(null);
(statearr_29789[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___29794);

return statearr_29789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___29794,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args29807 = [];
var len__18398__auto___29856 = arguments.length;
var i__18399__auto___29857 = (0);
while(true){
if((i__18399__auto___29857 < len__18398__auto___29856)){
args29807.push((arguments[i__18399__auto___29857]));

var G__29858 = (i__18399__auto___29857 + (1));
i__18399__auto___29857 = G__29858;
continue;
} else {
}
break;
}

var G__29809 = args29807.length;
switch (G__29809) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29807.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21281__auto___29860 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___29860,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___29860,out){
return (function (state_29833){
var state_val_29834 = (state_29833[(1)]);
if((state_val_29834 === (7))){
var inst_29815 = (state_29833[(7)]);
var inst_29815__$1 = (state_29833[(2)]);
var inst_29816 = (inst_29815__$1 == null);
var inst_29817 = cljs.core.not.call(null,inst_29816);
var state_29833__$1 = (function (){var statearr_29835 = state_29833;
(statearr_29835[(7)] = inst_29815__$1);

return statearr_29835;
})();
if(inst_29817){
var statearr_29836_29861 = state_29833__$1;
(statearr_29836_29861[(1)] = (8));

} else {
var statearr_29837_29862 = state_29833__$1;
(statearr_29837_29862[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (1))){
var inst_29810 = (0);
var state_29833__$1 = (function (){var statearr_29838 = state_29833;
(statearr_29838[(8)] = inst_29810);

return statearr_29838;
})();
var statearr_29839_29863 = state_29833__$1;
(statearr_29839_29863[(2)] = null);

(statearr_29839_29863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (4))){
var state_29833__$1 = state_29833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29833__$1,(7),ch);
} else {
if((state_val_29834 === (6))){
var inst_29828 = (state_29833[(2)]);
var state_29833__$1 = state_29833;
var statearr_29840_29864 = state_29833__$1;
(statearr_29840_29864[(2)] = inst_29828);

(statearr_29840_29864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (3))){
var inst_29830 = (state_29833[(2)]);
var inst_29831 = cljs.core.async.close_BANG_.call(null,out);
var state_29833__$1 = (function (){var statearr_29841 = state_29833;
(statearr_29841[(9)] = inst_29830);

return statearr_29841;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29833__$1,inst_29831);
} else {
if((state_val_29834 === (2))){
var inst_29810 = (state_29833[(8)]);
var inst_29812 = (inst_29810 < n);
var state_29833__$1 = state_29833;
if(cljs.core.truth_(inst_29812)){
var statearr_29842_29865 = state_29833__$1;
(statearr_29842_29865[(1)] = (4));

} else {
var statearr_29843_29866 = state_29833__$1;
(statearr_29843_29866[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (11))){
var inst_29810 = (state_29833[(8)]);
var inst_29820 = (state_29833[(2)]);
var inst_29821 = (inst_29810 + (1));
var inst_29810__$1 = inst_29821;
var state_29833__$1 = (function (){var statearr_29844 = state_29833;
(statearr_29844[(10)] = inst_29820);

(statearr_29844[(8)] = inst_29810__$1);

return statearr_29844;
})();
var statearr_29845_29867 = state_29833__$1;
(statearr_29845_29867[(2)] = null);

(statearr_29845_29867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (9))){
var state_29833__$1 = state_29833;
var statearr_29846_29868 = state_29833__$1;
(statearr_29846_29868[(2)] = null);

(statearr_29846_29868[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (5))){
var state_29833__$1 = state_29833;
var statearr_29847_29869 = state_29833__$1;
(statearr_29847_29869[(2)] = null);

(statearr_29847_29869[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (10))){
var inst_29825 = (state_29833[(2)]);
var state_29833__$1 = state_29833;
var statearr_29848_29870 = state_29833__$1;
(statearr_29848_29870[(2)] = inst_29825);

(statearr_29848_29870[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29834 === (8))){
var inst_29815 = (state_29833[(7)]);
var state_29833__$1 = state_29833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29833__$1,(11),out,inst_29815);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___29860,out))
;
return ((function (switch__21216__auto__,c__21281__auto___29860,out){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_29852 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29852[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_29852[(1)] = (1));

return statearr_29852;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_29833){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_29833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e29853){if((e29853 instanceof Object)){
var ex__21220__auto__ = e29853;
var statearr_29854_29871 = state_29833;
(statearr_29854_29871[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29833);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29853;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29872 = state_29833;
state_29833 = G__29872;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_29833){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_29833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___29860,out))
})();
var state__21283__auto__ = (function (){var statearr_29855 = f__21282__auto__.call(null);
(statearr_29855[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___29860);

return statearr_29855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___29860,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t29880 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29880 = (function (map_LT_,f,ch,meta29881){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta29881 = meta29881;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29880.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29882,meta29881__$1){
var self__ = this;
var _29882__$1 = this;
return (new cljs.core.async.t29880(self__.map_LT_,self__.f,self__.ch,meta29881__$1));
});

cljs.core.async.t29880.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29882){
var self__ = this;
var _29882__$1 = this;
return self__.meta29881;
});

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t29883 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29883 = (function (map_LT_,f,ch,meta29881,_,fn1,meta29884){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta29881 = meta29881;
this._ = _;
this.fn1 = fn1;
this.meta29884 = meta29884;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29883.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_29885,meta29884__$1){
var self__ = this;
var _29885__$1 = this;
return (new cljs.core.async.t29883(self__.map_LT_,self__.f,self__.ch,self__.meta29881,self__._,self__.fn1,meta29884__$1));
});})(___$1))
;

cljs.core.async.t29883.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_29885){
var self__ = this;
var _29885__$1 = this;
return self__.meta29884;
});})(___$1))
;

cljs.core.async.t29883.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29883.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t29883.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__29873_SHARP_){
return f1.call(null,(((p1__29873_SHARP_ == null))?null:self__.f.call(null,p1__29873_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t29883.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29881","meta29881",2060615431,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t29880","cljs.core.async/t29880",1101315827,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta29884","meta29884",-1142316730,null)], null);
});})(___$1))
;

cljs.core.async.t29883.cljs$lang$type = true;

cljs.core.async.t29883.cljs$lang$ctorStr = "cljs.core.async/t29883";

cljs.core.async.t29883.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t29883");
});})(___$1))
;

cljs.core.async.__GT_t29883 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t29883(map_LT___$1,f__$1,ch__$1,meta29881__$1,___$2,fn1__$1,meta29884){
return (new cljs.core.async.t29883(map_LT___$1,f__$1,ch__$1,meta29881__$1,___$2,fn1__$1,meta29884));
});})(___$1))
;

}

return (new cljs.core.async.t29883(self__.map_LT_,self__.f,self__.ch,self__.meta29881,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__17347__auto__ = ret;
if(cljs.core.truth_(and__17347__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__17347__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t29880.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t29880.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29881","meta29881",2060615431,null)], null);
});

cljs.core.async.t29880.cljs$lang$type = true;

cljs.core.async.t29880.cljs$lang$ctorStr = "cljs.core.async/t29880";

cljs.core.async.t29880.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t29880");
});

cljs.core.async.__GT_t29880 = (function cljs$core$async$map_LT__$___GT_t29880(map_LT___$1,f__$1,ch__$1,meta29881){
return (new cljs.core.async.t29880(map_LT___$1,f__$1,ch__$1,meta29881));
});

}

return (new cljs.core.async.t29880(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t29889 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29889 = (function (map_GT_,f,ch,meta29890){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta29890 = meta29890;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29889.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29891,meta29890__$1){
var self__ = this;
var _29891__$1 = this;
return (new cljs.core.async.t29889(self__.map_GT_,self__.f,self__.ch,meta29890__$1));
});

cljs.core.async.t29889.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29891){
var self__ = this;
var _29891__$1 = this;
return self__.meta29890;
});

cljs.core.async.t29889.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t29889.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t29889.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t29889.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t29889.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t29889.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t29889.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29890","meta29890",24009448,null)], null);
});

cljs.core.async.t29889.cljs$lang$type = true;

cljs.core.async.t29889.cljs$lang$ctorStr = "cljs.core.async/t29889";

cljs.core.async.t29889.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t29889");
});

cljs.core.async.__GT_t29889 = (function cljs$core$async$map_GT__$___GT_t29889(map_GT___$1,f__$1,ch__$1,meta29890){
return (new cljs.core.async.t29889(map_GT___$1,f__$1,ch__$1,meta29890));
});

}

return (new cljs.core.async.t29889(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t29895 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29895 = (function (filter_GT_,p,ch,meta29896){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta29896 = meta29896;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29895.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29897,meta29896__$1){
var self__ = this;
var _29897__$1 = this;
return (new cljs.core.async.t29895(self__.filter_GT_,self__.p,self__.ch,meta29896__$1));
});

cljs.core.async.t29895.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29897){
var self__ = this;
var _29897__$1 = this;
return self__.meta29896;
});

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t29895.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t29895.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29896","meta29896",-1262846510,null)], null);
});

cljs.core.async.t29895.cljs$lang$type = true;

cljs.core.async.t29895.cljs$lang$ctorStr = "cljs.core.async/t29895";

cljs.core.async.t29895.cljs$lang$ctorPrWriter = (function (this__17938__auto__,writer__17939__auto__,opt__17940__auto__){
return cljs.core._write.call(null,writer__17939__auto__,"cljs.core.async/t29895");
});

cljs.core.async.__GT_t29895 = (function cljs$core$async$filter_GT__$___GT_t29895(filter_GT___$1,p__$1,ch__$1,meta29896){
return (new cljs.core.async.t29895(filter_GT___$1,p__$1,ch__$1,meta29896));
});

}

return (new cljs.core.async.t29895(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args29898 = [];
var len__18398__auto___29942 = arguments.length;
var i__18399__auto___29943 = (0);
while(true){
if((i__18399__auto___29943 < len__18398__auto___29942)){
args29898.push((arguments[i__18399__auto___29943]));

var G__29944 = (i__18399__auto___29943 + (1));
i__18399__auto___29943 = G__29944;
continue;
} else {
}
break;
}

var G__29900 = args29898.length;
switch (G__29900) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29898.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21281__auto___29946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___29946,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___29946,out){
return (function (state_29921){
var state_val_29922 = (state_29921[(1)]);
if((state_val_29922 === (7))){
var inst_29917 = (state_29921[(2)]);
var state_29921__$1 = state_29921;
var statearr_29923_29947 = state_29921__$1;
(statearr_29923_29947[(2)] = inst_29917);

(statearr_29923_29947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (1))){
var state_29921__$1 = state_29921;
var statearr_29924_29948 = state_29921__$1;
(statearr_29924_29948[(2)] = null);

(statearr_29924_29948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (4))){
var inst_29903 = (state_29921[(7)]);
var inst_29903__$1 = (state_29921[(2)]);
var inst_29904 = (inst_29903__$1 == null);
var state_29921__$1 = (function (){var statearr_29925 = state_29921;
(statearr_29925[(7)] = inst_29903__$1);

return statearr_29925;
})();
if(cljs.core.truth_(inst_29904)){
var statearr_29926_29949 = state_29921__$1;
(statearr_29926_29949[(1)] = (5));

} else {
var statearr_29927_29950 = state_29921__$1;
(statearr_29927_29950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (6))){
var inst_29903 = (state_29921[(7)]);
var inst_29908 = p.call(null,inst_29903);
var state_29921__$1 = state_29921;
if(cljs.core.truth_(inst_29908)){
var statearr_29928_29951 = state_29921__$1;
(statearr_29928_29951[(1)] = (8));

} else {
var statearr_29929_29952 = state_29921__$1;
(statearr_29929_29952[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (3))){
var inst_29919 = (state_29921[(2)]);
var state_29921__$1 = state_29921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29921__$1,inst_29919);
} else {
if((state_val_29922 === (2))){
var state_29921__$1 = state_29921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29921__$1,(4),ch);
} else {
if((state_val_29922 === (11))){
var inst_29911 = (state_29921[(2)]);
var state_29921__$1 = state_29921;
var statearr_29930_29953 = state_29921__$1;
(statearr_29930_29953[(2)] = inst_29911);

(statearr_29930_29953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (9))){
var state_29921__$1 = state_29921;
var statearr_29931_29954 = state_29921__$1;
(statearr_29931_29954[(2)] = null);

(statearr_29931_29954[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (5))){
var inst_29906 = cljs.core.async.close_BANG_.call(null,out);
var state_29921__$1 = state_29921;
var statearr_29932_29955 = state_29921__$1;
(statearr_29932_29955[(2)] = inst_29906);

(statearr_29932_29955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (10))){
var inst_29914 = (state_29921[(2)]);
var state_29921__$1 = (function (){var statearr_29933 = state_29921;
(statearr_29933[(8)] = inst_29914);

return statearr_29933;
})();
var statearr_29934_29956 = state_29921__$1;
(statearr_29934_29956[(2)] = null);

(statearr_29934_29956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29922 === (8))){
var inst_29903 = (state_29921[(7)]);
var state_29921__$1 = state_29921;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29921__$1,(11),out,inst_29903);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___29946,out))
;
return ((function (switch__21216__auto__,c__21281__auto___29946,out){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_29938 = [null,null,null,null,null,null,null,null,null];
(statearr_29938[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_29938[(1)] = (1));

return statearr_29938;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_29921){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_29921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e29939){if((e29939 instanceof Object)){
var ex__21220__auto__ = e29939;
var statearr_29940_29957 = state_29921;
(statearr_29940_29957[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29921);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29958 = state_29921;
state_29921 = G__29958;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_29921){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_29921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___29946,out))
})();
var state__21283__auto__ = (function (){var statearr_29941 = f__21282__auto__.call(null);
(statearr_29941[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___29946);

return statearr_29941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___29946,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args29959 = [];
var len__18398__auto___29962 = arguments.length;
var i__18399__auto___29963 = (0);
while(true){
if((i__18399__auto___29963 < len__18398__auto___29962)){
args29959.push((arguments[i__18399__auto___29963]));

var G__29964 = (i__18399__auto___29963 + (1));
i__18399__auto___29963 = G__29964;
continue;
} else {
}
break;
}

var G__29961 = args29959.length;
switch (G__29961) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29959.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__21281__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto__){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto__){
return (function (state_30131){
var state_val_30132 = (state_30131[(1)]);
if((state_val_30132 === (7))){
var inst_30127 = (state_30131[(2)]);
var state_30131__$1 = state_30131;
var statearr_30133_30174 = state_30131__$1;
(statearr_30133_30174[(2)] = inst_30127);

(statearr_30133_30174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (20))){
var inst_30097 = (state_30131[(7)]);
var inst_30108 = (state_30131[(2)]);
var inst_30109 = cljs.core.next.call(null,inst_30097);
var inst_30083 = inst_30109;
var inst_30084 = null;
var inst_30085 = (0);
var inst_30086 = (0);
var state_30131__$1 = (function (){var statearr_30134 = state_30131;
(statearr_30134[(8)] = inst_30086);

(statearr_30134[(9)] = inst_30085);

(statearr_30134[(10)] = inst_30083);

(statearr_30134[(11)] = inst_30108);

(statearr_30134[(12)] = inst_30084);

return statearr_30134;
})();
var statearr_30135_30175 = state_30131__$1;
(statearr_30135_30175[(2)] = null);

(statearr_30135_30175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (1))){
var state_30131__$1 = state_30131;
var statearr_30136_30176 = state_30131__$1;
(statearr_30136_30176[(2)] = null);

(statearr_30136_30176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (4))){
var inst_30072 = (state_30131[(13)]);
var inst_30072__$1 = (state_30131[(2)]);
var inst_30073 = (inst_30072__$1 == null);
var state_30131__$1 = (function (){var statearr_30137 = state_30131;
(statearr_30137[(13)] = inst_30072__$1);

return statearr_30137;
})();
if(cljs.core.truth_(inst_30073)){
var statearr_30138_30177 = state_30131__$1;
(statearr_30138_30177[(1)] = (5));

} else {
var statearr_30139_30178 = state_30131__$1;
(statearr_30139_30178[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (15))){
var state_30131__$1 = state_30131;
var statearr_30143_30179 = state_30131__$1;
(statearr_30143_30179[(2)] = null);

(statearr_30143_30179[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (21))){
var state_30131__$1 = state_30131;
var statearr_30144_30180 = state_30131__$1;
(statearr_30144_30180[(2)] = null);

(statearr_30144_30180[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (13))){
var inst_30086 = (state_30131[(8)]);
var inst_30085 = (state_30131[(9)]);
var inst_30083 = (state_30131[(10)]);
var inst_30084 = (state_30131[(12)]);
var inst_30093 = (state_30131[(2)]);
var inst_30094 = (inst_30086 + (1));
var tmp30140 = inst_30085;
var tmp30141 = inst_30083;
var tmp30142 = inst_30084;
var inst_30083__$1 = tmp30141;
var inst_30084__$1 = tmp30142;
var inst_30085__$1 = tmp30140;
var inst_30086__$1 = inst_30094;
var state_30131__$1 = (function (){var statearr_30145 = state_30131;
(statearr_30145[(8)] = inst_30086__$1);

(statearr_30145[(9)] = inst_30085__$1);

(statearr_30145[(10)] = inst_30083__$1);

(statearr_30145[(14)] = inst_30093);

(statearr_30145[(12)] = inst_30084__$1);

return statearr_30145;
})();
var statearr_30146_30181 = state_30131__$1;
(statearr_30146_30181[(2)] = null);

(statearr_30146_30181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (22))){
var state_30131__$1 = state_30131;
var statearr_30147_30182 = state_30131__$1;
(statearr_30147_30182[(2)] = null);

(statearr_30147_30182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (6))){
var inst_30072 = (state_30131[(13)]);
var inst_30081 = f.call(null,inst_30072);
var inst_30082 = cljs.core.seq.call(null,inst_30081);
var inst_30083 = inst_30082;
var inst_30084 = null;
var inst_30085 = (0);
var inst_30086 = (0);
var state_30131__$1 = (function (){var statearr_30148 = state_30131;
(statearr_30148[(8)] = inst_30086);

(statearr_30148[(9)] = inst_30085);

(statearr_30148[(10)] = inst_30083);

(statearr_30148[(12)] = inst_30084);

return statearr_30148;
})();
var statearr_30149_30183 = state_30131__$1;
(statearr_30149_30183[(2)] = null);

(statearr_30149_30183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (17))){
var inst_30097 = (state_30131[(7)]);
var inst_30101 = cljs.core.chunk_first.call(null,inst_30097);
var inst_30102 = cljs.core.chunk_rest.call(null,inst_30097);
var inst_30103 = cljs.core.count.call(null,inst_30101);
var inst_30083 = inst_30102;
var inst_30084 = inst_30101;
var inst_30085 = inst_30103;
var inst_30086 = (0);
var state_30131__$1 = (function (){var statearr_30150 = state_30131;
(statearr_30150[(8)] = inst_30086);

(statearr_30150[(9)] = inst_30085);

(statearr_30150[(10)] = inst_30083);

(statearr_30150[(12)] = inst_30084);

return statearr_30150;
})();
var statearr_30151_30184 = state_30131__$1;
(statearr_30151_30184[(2)] = null);

(statearr_30151_30184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (3))){
var inst_30129 = (state_30131[(2)]);
var state_30131__$1 = state_30131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30131__$1,inst_30129);
} else {
if((state_val_30132 === (12))){
var inst_30117 = (state_30131[(2)]);
var state_30131__$1 = state_30131;
var statearr_30152_30185 = state_30131__$1;
(statearr_30152_30185[(2)] = inst_30117);

(statearr_30152_30185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (2))){
var state_30131__$1 = state_30131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30131__$1,(4),in$);
} else {
if((state_val_30132 === (23))){
var inst_30125 = (state_30131[(2)]);
var state_30131__$1 = state_30131;
var statearr_30153_30186 = state_30131__$1;
(statearr_30153_30186[(2)] = inst_30125);

(statearr_30153_30186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (19))){
var inst_30112 = (state_30131[(2)]);
var state_30131__$1 = state_30131;
var statearr_30154_30187 = state_30131__$1;
(statearr_30154_30187[(2)] = inst_30112);

(statearr_30154_30187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (11))){
var inst_30083 = (state_30131[(10)]);
var inst_30097 = (state_30131[(7)]);
var inst_30097__$1 = cljs.core.seq.call(null,inst_30083);
var state_30131__$1 = (function (){var statearr_30155 = state_30131;
(statearr_30155[(7)] = inst_30097__$1);

return statearr_30155;
})();
if(inst_30097__$1){
var statearr_30156_30188 = state_30131__$1;
(statearr_30156_30188[(1)] = (14));

} else {
var statearr_30157_30189 = state_30131__$1;
(statearr_30157_30189[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (9))){
var inst_30119 = (state_30131[(2)]);
var inst_30120 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_30131__$1 = (function (){var statearr_30158 = state_30131;
(statearr_30158[(15)] = inst_30119);

return statearr_30158;
})();
if(cljs.core.truth_(inst_30120)){
var statearr_30159_30190 = state_30131__$1;
(statearr_30159_30190[(1)] = (21));

} else {
var statearr_30160_30191 = state_30131__$1;
(statearr_30160_30191[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (5))){
var inst_30075 = cljs.core.async.close_BANG_.call(null,out);
var state_30131__$1 = state_30131;
var statearr_30161_30192 = state_30131__$1;
(statearr_30161_30192[(2)] = inst_30075);

(statearr_30161_30192[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (14))){
var inst_30097 = (state_30131[(7)]);
var inst_30099 = cljs.core.chunked_seq_QMARK_.call(null,inst_30097);
var state_30131__$1 = state_30131;
if(inst_30099){
var statearr_30162_30193 = state_30131__$1;
(statearr_30162_30193[(1)] = (17));

} else {
var statearr_30163_30194 = state_30131__$1;
(statearr_30163_30194[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (16))){
var inst_30115 = (state_30131[(2)]);
var state_30131__$1 = state_30131;
var statearr_30164_30195 = state_30131__$1;
(statearr_30164_30195[(2)] = inst_30115);

(statearr_30164_30195[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30132 === (10))){
var inst_30086 = (state_30131[(8)]);
var inst_30084 = (state_30131[(12)]);
var inst_30091 = cljs.core._nth.call(null,inst_30084,inst_30086);
var state_30131__$1 = state_30131;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30131__$1,(13),out,inst_30091);
} else {
if((state_val_30132 === (18))){
var inst_30097 = (state_30131[(7)]);
var inst_30106 = cljs.core.first.call(null,inst_30097);
var state_30131__$1 = state_30131;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30131__$1,(20),out,inst_30106);
} else {
if((state_val_30132 === (8))){
var inst_30086 = (state_30131[(8)]);
var inst_30085 = (state_30131[(9)]);
var inst_30088 = (inst_30086 < inst_30085);
var inst_30089 = inst_30088;
var state_30131__$1 = state_30131;
if(cljs.core.truth_(inst_30089)){
var statearr_30165_30196 = state_30131__$1;
(statearr_30165_30196[(1)] = (10));

} else {
var statearr_30166_30197 = state_30131__$1;
(statearr_30166_30197[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto__))
;
return ((function (switch__21216__auto__,c__21281__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__21217__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__21217__auto____0 = (function (){
var statearr_30170 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30170[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__21217__auto__);

(statearr_30170[(1)] = (1));

return statearr_30170;
});
var cljs$core$async$mapcat_STAR__$_state_machine__21217__auto____1 = (function (state_30131){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_30131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e30171){if((e30171 instanceof Object)){
var ex__21220__auto__ = e30171;
var statearr_30172_30198 = state_30131;
(statearr_30172_30198[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30131);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30199 = state_30131;
state_30131 = G__30199;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__21217__auto__ = function(state_30131){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__21217__auto____1.call(this,state_30131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__21217__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__21217__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto__))
})();
var state__21283__auto__ = (function (){var statearr_30173 = f__21282__auto__.call(null);
(statearr_30173[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto__);

return statearr_30173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto__))
);

return c__21281__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args30200 = [];
var len__18398__auto___30203 = arguments.length;
var i__18399__auto___30204 = (0);
while(true){
if((i__18399__auto___30204 < len__18398__auto___30203)){
args30200.push((arguments[i__18399__auto___30204]));

var G__30205 = (i__18399__auto___30204 + (1));
i__18399__auto___30204 = G__30205;
continue;
} else {
}
break;
}

var G__30202 = args30200.length;
switch (G__30202) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30200.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args30207 = [];
var len__18398__auto___30210 = arguments.length;
var i__18399__auto___30211 = (0);
while(true){
if((i__18399__auto___30211 < len__18398__auto___30210)){
args30207.push((arguments[i__18399__auto___30211]));

var G__30212 = (i__18399__auto___30211 + (1));
i__18399__auto___30211 = G__30212;
continue;
} else {
}
break;
}

var G__30209 = args30207.length;
switch (G__30209) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30207.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args30214 = [];
var len__18398__auto___30265 = arguments.length;
var i__18399__auto___30266 = (0);
while(true){
if((i__18399__auto___30266 < len__18398__auto___30265)){
args30214.push((arguments[i__18399__auto___30266]));

var G__30267 = (i__18399__auto___30266 + (1));
i__18399__auto___30266 = G__30267;
continue;
} else {
}
break;
}

var G__30216 = args30214.length;
switch (G__30216) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30214.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21281__auto___30269 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___30269,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___30269,out){
return (function (state_30240){
var state_val_30241 = (state_30240[(1)]);
if((state_val_30241 === (7))){
var inst_30235 = (state_30240[(2)]);
var state_30240__$1 = state_30240;
var statearr_30242_30270 = state_30240__$1;
(statearr_30242_30270[(2)] = inst_30235);

(statearr_30242_30270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (1))){
var inst_30217 = null;
var state_30240__$1 = (function (){var statearr_30243 = state_30240;
(statearr_30243[(7)] = inst_30217);

return statearr_30243;
})();
var statearr_30244_30271 = state_30240__$1;
(statearr_30244_30271[(2)] = null);

(statearr_30244_30271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (4))){
var inst_30220 = (state_30240[(8)]);
var inst_30220__$1 = (state_30240[(2)]);
var inst_30221 = (inst_30220__$1 == null);
var inst_30222 = cljs.core.not.call(null,inst_30221);
var state_30240__$1 = (function (){var statearr_30245 = state_30240;
(statearr_30245[(8)] = inst_30220__$1);

return statearr_30245;
})();
if(inst_30222){
var statearr_30246_30272 = state_30240__$1;
(statearr_30246_30272[(1)] = (5));

} else {
var statearr_30247_30273 = state_30240__$1;
(statearr_30247_30273[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (6))){
var state_30240__$1 = state_30240;
var statearr_30248_30274 = state_30240__$1;
(statearr_30248_30274[(2)] = null);

(statearr_30248_30274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (3))){
var inst_30237 = (state_30240[(2)]);
var inst_30238 = cljs.core.async.close_BANG_.call(null,out);
var state_30240__$1 = (function (){var statearr_30249 = state_30240;
(statearr_30249[(9)] = inst_30237);

return statearr_30249;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30240__$1,inst_30238);
} else {
if((state_val_30241 === (2))){
var state_30240__$1 = state_30240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30240__$1,(4),ch);
} else {
if((state_val_30241 === (11))){
var inst_30220 = (state_30240[(8)]);
var inst_30229 = (state_30240[(2)]);
var inst_30217 = inst_30220;
var state_30240__$1 = (function (){var statearr_30250 = state_30240;
(statearr_30250[(7)] = inst_30217);

(statearr_30250[(10)] = inst_30229);

return statearr_30250;
})();
var statearr_30251_30275 = state_30240__$1;
(statearr_30251_30275[(2)] = null);

(statearr_30251_30275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (9))){
var inst_30220 = (state_30240[(8)]);
var state_30240__$1 = state_30240;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30240__$1,(11),out,inst_30220);
} else {
if((state_val_30241 === (5))){
var inst_30217 = (state_30240[(7)]);
var inst_30220 = (state_30240[(8)]);
var inst_30224 = cljs.core._EQ_.call(null,inst_30220,inst_30217);
var state_30240__$1 = state_30240;
if(inst_30224){
var statearr_30253_30276 = state_30240__$1;
(statearr_30253_30276[(1)] = (8));

} else {
var statearr_30254_30277 = state_30240__$1;
(statearr_30254_30277[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (10))){
var inst_30232 = (state_30240[(2)]);
var state_30240__$1 = state_30240;
var statearr_30255_30278 = state_30240__$1;
(statearr_30255_30278[(2)] = inst_30232);

(statearr_30255_30278[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30241 === (8))){
var inst_30217 = (state_30240[(7)]);
var tmp30252 = inst_30217;
var inst_30217__$1 = tmp30252;
var state_30240__$1 = (function (){var statearr_30256 = state_30240;
(statearr_30256[(7)] = inst_30217__$1);

return statearr_30256;
})();
var statearr_30257_30279 = state_30240__$1;
(statearr_30257_30279[(2)] = null);

(statearr_30257_30279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___30269,out))
;
return ((function (switch__21216__auto__,c__21281__auto___30269,out){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_30261 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30261[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_30261[(1)] = (1));

return statearr_30261;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_30240){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_30240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e30262){if((e30262 instanceof Object)){
var ex__21220__auto__ = e30262;
var statearr_30263_30280 = state_30240;
(statearr_30263_30280[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30240);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30262;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30281 = state_30240;
state_30240 = G__30281;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_30240){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_30240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___30269,out))
})();
var state__21283__auto__ = (function (){var statearr_30264 = f__21282__auto__.call(null);
(statearr_30264[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___30269);

return statearr_30264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___30269,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args30282 = [];
var len__18398__auto___30352 = arguments.length;
var i__18399__auto___30353 = (0);
while(true){
if((i__18399__auto___30353 < len__18398__auto___30352)){
args30282.push((arguments[i__18399__auto___30353]));

var G__30354 = (i__18399__auto___30353 + (1));
i__18399__auto___30353 = G__30354;
continue;
} else {
}
break;
}

var G__30284 = args30282.length;
switch (G__30284) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30282.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21281__auto___30356 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___30356,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___30356,out){
return (function (state_30322){
var state_val_30323 = (state_30322[(1)]);
if((state_val_30323 === (7))){
var inst_30318 = (state_30322[(2)]);
var state_30322__$1 = state_30322;
var statearr_30324_30357 = state_30322__$1;
(statearr_30324_30357[(2)] = inst_30318);

(statearr_30324_30357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (1))){
var inst_30285 = (new Array(n));
var inst_30286 = inst_30285;
var inst_30287 = (0);
var state_30322__$1 = (function (){var statearr_30325 = state_30322;
(statearr_30325[(7)] = inst_30287);

(statearr_30325[(8)] = inst_30286);

return statearr_30325;
})();
var statearr_30326_30358 = state_30322__$1;
(statearr_30326_30358[(2)] = null);

(statearr_30326_30358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (4))){
var inst_30290 = (state_30322[(9)]);
var inst_30290__$1 = (state_30322[(2)]);
var inst_30291 = (inst_30290__$1 == null);
var inst_30292 = cljs.core.not.call(null,inst_30291);
var state_30322__$1 = (function (){var statearr_30327 = state_30322;
(statearr_30327[(9)] = inst_30290__$1);

return statearr_30327;
})();
if(inst_30292){
var statearr_30328_30359 = state_30322__$1;
(statearr_30328_30359[(1)] = (5));

} else {
var statearr_30329_30360 = state_30322__$1;
(statearr_30329_30360[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (15))){
var inst_30312 = (state_30322[(2)]);
var state_30322__$1 = state_30322;
var statearr_30330_30361 = state_30322__$1;
(statearr_30330_30361[(2)] = inst_30312);

(statearr_30330_30361[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (13))){
var state_30322__$1 = state_30322;
var statearr_30331_30362 = state_30322__$1;
(statearr_30331_30362[(2)] = null);

(statearr_30331_30362[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (6))){
var inst_30287 = (state_30322[(7)]);
var inst_30308 = (inst_30287 > (0));
var state_30322__$1 = state_30322;
if(cljs.core.truth_(inst_30308)){
var statearr_30332_30363 = state_30322__$1;
(statearr_30332_30363[(1)] = (12));

} else {
var statearr_30333_30364 = state_30322__$1;
(statearr_30333_30364[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (3))){
var inst_30320 = (state_30322[(2)]);
var state_30322__$1 = state_30322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30322__$1,inst_30320);
} else {
if((state_val_30323 === (12))){
var inst_30286 = (state_30322[(8)]);
var inst_30310 = cljs.core.vec.call(null,inst_30286);
var state_30322__$1 = state_30322;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30322__$1,(15),out,inst_30310);
} else {
if((state_val_30323 === (2))){
var state_30322__$1 = state_30322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30322__$1,(4),ch);
} else {
if((state_val_30323 === (11))){
var inst_30302 = (state_30322[(2)]);
var inst_30303 = (new Array(n));
var inst_30286 = inst_30303;
var inst_30287 = (0);
var state_30322__$1 = (function (){var statearr_30334 = state_30322;
(statearr_30334[(7)] = inst_30287);

(statearr_30334[(8)] = inst_30286);

(statearr_30334[(10)] = inst_30302);

return statearr_30334;
})();
var statearr_30335_30365 = state_30322__$1;
(statearr_30335_30365[(2)] = null);

(statearr_30335_30365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (9))){
var inst_30286 = (state_30322[(8)]);
var inst_30300 = cljs.core.vec.call(null,inst_30286);
var state_30322__$1 = state_30322;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30322__$1,(11),out,inst_30300);
} else {
if((state_val_30323 === (5))){
var inst_30287 = (state_30322[(7)]);
var inst_30290 = (state_30322[(9)]);
var inst_30286 = (state_30322[(8)]);
var inst_30295 = (state_30322[(11)]);
var inst_30294 = (inst_30286[inst_30287] = inst_30290);
var inst_30295__$1 = (inst_30287 + (1));
var inst_30296 = (inst_30295__$1 < n);
var state_30322__$1 = (function (){var statearr_30336 = state_30322;
(statearr_30336[(12)] = inst_30294);

(statearr_30336[(11)] = inst_30295__$1);

return statearr_30336;
})();
if(cljs.core.truth_(inst_30296)){
var statearr_30337_30366 = state_30322__$1;
(statearr_30337_30366[(1)] = (8));

} else {
var statearr_30338_30367 = state_30322__$1;
(statearr_30338_30367[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (14))){
var inst_30315 = (state_30322[(2)]);
var inst_30316 = cljs.core.async.close_BANG_.call(null,out);
var state_30322__$1 = (function (){var statearr_30340 = state_30322;
(statearr_30340[(13)] = inst_30315);

return statearr_30340;
})();
var statearr_30341_30368 = state_30322__$1;
(statearr_30341_30368[(2)] = inst_30316);

(statearr_30341_30368[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (10))){
var inst_30306 = (state_30322[(2)]);
var state_30322__$1 = state_30322;
var statearr_30342_30369 = state_30322__$1;
(statearr_30342_30369[(2)] = inst_30306);

(statearr_30342_30369[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30323 === (8))){
var inst_30286 = (state_30322[(8)]);
var inst_30295 = (state_30322[(11)]);
var tmp30339 = inst_30286;
var inst_30286__$1 = tmp30339;
var inst_30287 = inst_30295;
var state_30322__$1 = (function (){var statearr_30343 = state_30322;
(statearr_30343[(7)] = inst_30287);

(statearr_30343[(8)] = inst_30286__$1);

return statearr_30343;
})();
var statearr_30344_30370 = state_30322__$1;
(statearr_30344_30370[(2)] = null);

(statearr_30344_30370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___30356,out))
;
return ((function (switch__21216__auto__,c__21281__auto___30356,out){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_30348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30348[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_30348[(1)] = (1));

return statearr_30348;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_30322){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_30322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e30349){if((e30349 instanceof Object)){
var ex__21220__auto__ = e30349;
var statearr_30350_30371 = state_30322;
(statearr_30350_30371[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30372 = state_30322;
state_30322 = G__30372;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_30322){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_30322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___30356,out))
})();
var state__21283__auto__ = (function (){var statearr_30351 = f__21282__auto__.call(null);
(statearr_30351[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___30356);

return statearr_30351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___30356,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args30373 = [];
var len__18398__auto___30447 = arguments.length;
var i__18399__auto___30448 = (0);
while(true){
if((i__18399__auto___30448 < len__18398__auto___30447)){
args30373.push((arguments[i__18399__auto___30448]));

var G__30449 = (i__18399__auto___30448 + (1));
i__18399__auto___30448 = G__30449;
continue;
} else {
}
break;
}

var G__30375 = args30373.length;
switch (G__30375) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30373.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21281__auto___30451 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21281__auto___30451,out){
return (function (){
var f__21282__auto__ = (function (){var switch__21216__auto__ = ((function (c__21281__auto___30451,out){
return (function (state_30417){
var state_val_30418 = (state_30417[(1)]);
if((state_val_30418 === (7))){
var inst_30413 = (state_30417[(2)]);
var state_30417__$1 = state_30417;
var statearr_30419_30452 = state_30417__$1;
(statearr_30419_30452[(2)] = inst_30413);

(statearr_30419_30452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (1))){
var inst_30376 = [];
var inst_30377 = inst_30376;
var inst_30378 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30417__$1 = (function (){var statearr_30420 = state_30417;
(statearr_30420[(7)] = inst_30377);

(statearr_30420[(8)] = inst_30378);

return statearr_30420;
})();
var statearr_30421_30453 = state_30417__$1;
(statearr_30421_30453[(2)] = null);

(statearr_30421_30453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (4))){
var inst_30381 = (state_30417[(9)]);
var inst_30381__$1 = (state_30417[(2)]);
var inst_30382 = (inst_30381__$1 == null);
var inst_30383 = cljs.core.not.call(null,inst_30382);
var state_30417__$1 = (function (){var statearr_30422 = state_30417;
(statearr_30422[(9)] = inst_30381__$1);

return statearr_30422;
})();
if(inst_30383){
var statearr_30423_30454 = state_30417__$1;
(statearr_30423_30454[(1)] = (5));

} else {
var statearr_30424_30455 = state_30417__$1;
(statearr_30424_30455[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (15))){
var inst_30407 = (state_30417[(2)]);
var state_30417__$1 = state_30417;
var statearr_30425_30456 = state_30417__$1;
(statearr_30425_30456[(2)] = inst_30407);

(statearr_30425_30456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (13))){
var state_30417__$1 = state_30417;
var statearr_30426_30457 = state_30417__$1;
(statearr_30426_30457[(2)] = null);

(statearr_30426_30457[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (6))){
var inst_30377 = (state_30417[(7)]);
var inst_30402 = inst_30377.length;
var inst_30403 = (inst_30402 > (0));
var state_30417__$1 = state_30417;
if(cljs.core.truth_(inst_30403)){
var statearr_30427_30458 = state_30417__$1;
(statearr_30427_30458[(1)] = (12));

} else {
var statearr_30428_30459 = state_30417__$1;
(statearr_30428_30459[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (3))){
var inst_30415 = (state_30417[(2)]);
var state_30417__$1 = state_30417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30417__$1,inst_30415);
} else {
if((state_val_30418 === (12))){
var inst_30377 = (state_30417[(7)]);
var inst_30405 = cljs.core.vec.call(null,inst_30377);
var state_30417__$1 = state_30417;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30417__$1,(15),out,inst_30405);
} else {
if((state_val_30418 === (2))){
var state_30417__$1 = state_30417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30417__$1,(4),ch);
} else {
if((state_val_30418 === (11))){
var inst_30381 = (state_30417[(9)]);
var inst_30385 = (state_30417[(10)]);
var inst_30395 = (state_30417[(2)]);
var inst_30396 = [];
var inst_30397 = inst_30396.push(inst_30381);
var inst_30377 = inst_30396;
var inst_30378 = inst_30385;
var state_30417__$1 = (function (){var statearr_30429 = state_30417;
(statearr_30429[(11)] = inst_30397);

(statearr_30429[(7)] = inst_30377);

(statearr_30429[(8)] = inst_30378);

(statearr_30429[(12)] = inst_30395);

return statearr_30429;
})();
var statearr_30430_30460 = state_30417__$1;
(statearr_30430_30460[(2)] = null);

(statearr_30430_30460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (9))){
var inst_30377 = (state_30417[(7)]);
var inst_30393 = cljs.core.vec.call(null,inst_30377);
var state_30417__$1 = state_30417;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30417__$1,(11),out,inst_30393);
} else {
if((state_val_30418 === (5))){
var inst_30378 = (state_30417[(8)]);
var inst_30381 = (state_30417[(9)]);
var inst_30385 = (state_30417[(10)]);
var inst_30385__$1 = f.call(null,inst_30381);
var inst_30386 = cljs.core._EQ_.call(null,inst_30385__$1,inst_30378);
var inst_30387 = cljs.core.keyword_identical_QMARK_.call(null,inst_30378,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30388 = (inst_30386) || (inst_30387);
var state_30417__$1 = (function (){var statearr_30431 = state_30417;
(statearr_30431[(10)] = inst_30385__$1);

return statearr_30431;
})();
if(cljs.core.truth_(inst_30388)){
var statearr_30432_30461 = state_30417__$1;
(statearr_30432_30461[(1)] = (8));

} else {
var statearr_30433_30462 = state_30417__$1;
(statearr_30433_30462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (14))){
var inst_30410 = (state_30417[(2)]);
var inst_30411 = cljs.core.async.close_BANG_.call(null,out);
var state_30417__$1 = (function (){var statearr_30435 = state_30417;
(statearr_30435[(13)] = inst_30410);

return statearr_30435;
})();
var statearr_30436_30463 = state_30417__$1;
(statearr_30436_30463[(2)] = inst_30411);

(statearr_30436_30463[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (10))){
var inst_30400 = (state_30417[(2)]);
var state_30417__$1 = state_30417;
var statearr_30437_30464 = state_30417__$1;
(statearr_30437_30464[(2)] = inst_30400);

(statearr_30437_30464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30418 === (8))){
var inst_30377 = (state_30417[(7)]);
var inst_30381 = (state_30417[(9)]);
var inst_30385 = (state_30417[(10)]);
var inst_30390 = inst_30377.push(inst_30381);
var tmp30434 = inst_30377;
var inst_30377__$1 = tmp30434;
var inst_30378 = inst_30385;
var state_30417__$1 = (function (){var statearr_30438 = state_30417;
(statearr_30438[(7)] = inst_30377__$1);

(statearr_30438[(8)] = inst_30378);

(statearr_30438[(14)] = inst_30390);

return statearr_30438;
})();
var statearr_30439_30465 = state_30417__$1;
(statearr_30439_30465[(2)] = null);

(statearr_30439_30465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21281__auto___30451,out))
;
return ((function (switch__21216__auto__,c__21281__auto___30451,out){
return (function() {
var cljs$core$async$state_machine__21217__auto__ = null;
var cljs$core$async$state_machine__21217__auto____0 = (function (){
var statearr_30443 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30443[(0)] = cljs$core$async$state_machine__21217__auto__);

(statearr_30443[(1)] = (1));

return statearr_30443;
});
var cljs$core$async$state_machine__21217__auto____1 = (function (state_30417){
while(true){
var ret_value__21218__auto__ = (function (){try{while(true){
var result__21219__auto__ = switch__21216__auto__.call(null,state_30417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21219__auto__;
}
break;
}
}catch (e30444){if((e30444 instanceof Object)){
var ex__21220__auto__ = e30444;
var statearr_30445_30466 = state_30417;
(statearr_30445_30466[(5)] = ex__21220__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30444;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21218__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30467 = state_30417;
state_30417 = G__30467;
continue;
} else {
return ret_value__21218__auto__;
}
break;
}
});
cljs$core$async$state_machine__21217__auto__ = function(state_30417){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21217__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21217__auto____1.call(this,state_30417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21217__auto____0;
cljs$core$async$state_machine__21217__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21217__auto____1;
return cljs$core$async$state_machine__21217__auto__;
})()
;})(switch__21216__auto__,c__21281__auto___30451,out))
})();
var state__21283__auto__ = (function (){var statearr_30446 = f__21282__auto__.call(null);
(statearr_30446[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21281__auto___30451);

return statearr_30446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21283__auto__);
});})(c__21281__auto___30451,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1439917876955