// Compiled by ClojureScript 1.7.48 {}
goog.provide('ajax.core');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cognitect.transit');
goog.require('goog.net.XhrIo');
goog.require('goog.net.XhrManager');
goog.require('goog.json');
goog.require('goog.Uri.QueryData');
goog.require('goog.net.EventType');
goog.require('goog.events');
goog.require('goog.structs');
goog.require('goog.json.Serializer');
goog.require('clojure.string');
goog.require('cljs.reader');
goog.require('goog.net.ErrorCode');

/**
 * An abstraction for a javascript class that implements
 * Ajax calls.
 */
ajax.core.AjaxImpl = {};

/**
 * Makes an actual ajax request.  All parameters except opts
 * are in JS format.  Should return an AjaxRequest.
 */
ajax.core._js_ajax_request = (function ajax$core$_js_ajax_request(this$,uri,method,body,headers,handler,opts){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxImpl$_js_ajax_request$arity$7 == null)))){
return this$.ajax$core$AjaxImpl$_js_ajax_request$arity$7(this$,uri,method,body,headers,handler,opts);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._js_ajax_request[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$,uri,method,body,headers,handler,opts);
} else {
var m__17996__auto____$1 = (ajax.core._js_ajax_request["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$,uri,method,body,headers,handler,opts);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxImpl.-js-ajax-request",this$);
}
}
}
});


/**
 * An abstraction for a running ajax request.
 */
ajax.core.AjaxRequest = {};

/**
 * Aborts a running ajax request, if possible.
 */
ajax.core._abort = (function ajax$core$_abort(this$){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxRequest$_abort$arity$1 == null)))){
return this$.ajax$core$AjaxRequest$_abort$arity$1(this$);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._abort[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$);
} else {
var m__17996__auto____$1 = (ajax.core._abort["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxRequest.-abort",this$);
}
}
}
});


/**
 * A marker interface for types that can be directly sent to XhrIo.
 */
ajax.core.DirectlySubmittable = {};


/**
 * An abstraction for an ajax response.
 */
ajax.core.AjaxResponse = {};

/**
 * Returns the HTTP Status of the response as an integer.
 */
ajax.core._status = (function ajax$core$_status(this$){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxResponse$_status$arity$1 == null)))){
return this$.ajax$core$AjaxResponse$_status$arity$1(this$);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._status[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$);
} else {
var m__17996__auto____$1 = (ajax.core._status["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxResponse.-status",this$);
}
}
}
});

/**
 * Returns the HTTP Status Text of the response as a string.
 */
ajax.core._status_text = (function ajax$core$_status_text(this$){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxResponse$_status_text$arity$1 == null)))){
return this$.ajax$core$AjaxResponse$_status_text$arity$1(this$);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._status_text[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$);
} else {
var m__17996__auto____$1 = (ajax.core._status_text["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxResponse.-status-text",this$);
}
}
}
});

/**
 * Returns the response body as a string.
 */
ajax.core._body = (function ajax$core$_body(this$){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxResponse$_body$arity$1 == null)))){
return this$.ajax$core$AjaxResponse$_body$arity$1(this$);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._body[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$);
} else {
var m__17996__auto____$1 = (ajax.core._body["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxResponse.-body",this$);
}
}
}
});

/**
 * Gets the specified response header (specified by a string) as a string.
 */
ajax.core._get_response_header = (function ajax$core$_get_response_header(this$,header){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxResponse$_get_response_header$arity$2 == null)))){
return this$.ajax$core$AjaxResponse$_get_response_header$arity$2(this$,header);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._get_response_header[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$,header);
} else {
var m__17996__auto____$1 = (ajax.core._get_response_header["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$,header);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxResponse.-get-response-header",this$);
}
}
}
});

/**
 * Was the response aborted.
 */
ajax.core._was_aborted = (function ajax$core$_was_aborted(this$){
if((!((this$ == null))) && (!((this$.ajax$core$AjaxResponse$_was_aborted$arity$1 == null)))){
return this$.ajax$core$AjaxResponse$_was_aborted$arity$1(this$);
} else {
var x__17995__auto__ = (((this$ == null))?null:this$);
var m__17996__auto__ = (ajax.core._was_aborted[goog.typeOf(x__17995__auto__)]);
if(!((m__17996__auto__ == null))){
return m__17996__auto__.call(null,this$);
} else {
var m__17996__auto____$1 = (ajax.core._was_aborted["_"]);
if(!((m__17996__auto____$1 == null))){
return m__17996__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"AjaxResponse.-was-aborted",this$);
}
}
}
});

if(typeof FormData !== 'undefined'){
FormData.prototype.ajax$core$DirectlySubmittable$ = true;
} else {
}

if(typeof ArrayBufferView !== 'undefined'){
ArrayBufferView.prototype.ajax$core$DirectlySubmittable$ = true;
} else {
}

if(typeof Blob !== 'undefined'){
Blob.prototype.ajax$core$DirectlySubmittable$ = true;
} else {
}

if(typeof Document !== 'undefined'){
Document.prototype.ajax$core$DirectlySubmittable$ = true;
} else {
}
ajax.core.submittable_QMARK_ = (function ajax$core$submittable_QMARK_(params){
var or__17359__auto__ = ((!((params == null)))?(((false) || (params.ajax$core$DirectlySubmittable$))?true:(((!params.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,ajax.core.DirectlySubmittable,params):false)):cljs.core.native_satisfies_QMARK_.call(null,ajax.core.DirectlySubmittable,params));
if(or__17359__auto__){
return or__17359__auto__;
} else {
return typeof params === 'string';
}
});
goog.net.XhrIo.prototype.ajax$core$AjaxImpl$ = true;

goog.net.XhrIo.prototype.ajax$core$AjaxImpl$_js_ajax_request$arity$7 = (function (this$,uri,method,body,headers,handler,p__25741){
var map__25742 = p__25741;
var map__25742__$1 = ((((!((map__25742 == null)))?((((map__25742.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25742.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25742):map__25742);
var timeout = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var this$__$1 = this;
var G__25744 = this$__$1;
goog.events.listen(G__25744,goog.net.EventType.COMPLETE,((function (G__25744,this$__$1,map__25742,map__25742__$1,timeout,with_credentials){
return (function (p1__25740_SHARP_){
return handler.call(null,p1__25740_SHARP_.target);
});})(G__25744,this$__$1,map__25742,map__25742__$1,timeout,with_credentials))
);

G__25744.setTimeoutInterval(timeout);

G__25744.setWithCredentials(with_credentials);

G__25744.send(uri,method,body,cljs.core.clj__GT_js.call(null,headers));

return G__25744;
});

goog.net.XhrIo.prototype.ajax$core$AjaxRequest$ = true;

goog.net.XhrIo.prototype.ajax$core$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort(goog.net.ErrorCode.ABORT);
});

goog.net.XhrIo.prototype.ajax$core$AjaxResponse$ = true;

goog.net.XhrIo.prototype.ajax$core$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getResponseText();
});

goog.net.XhrIo.prototype.ajax$core$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getStatus();
});

goog.net.XhrIo.prototype.ajax$core$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getStatusText();
});

goog.net.XhrIo.prototype.ajax$core$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
});

goog.net.XhrIo.prototype.ajax$core$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.call(null,this$__$1.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
XMLHttpRequest.prototype.ajax$core$AjaxImpl$ = true;

XMLHttpRequest.prototype.ajax$core$AjaxImpl$_js_ajax_request$arity$7 = (function (this$,uri,method,body,headers,handler,p__25745){
var map__25746 = p__25745;
var map__25746__$1 = ((((!((map__25746 == null)))?((((map__25746.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25746.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25746):map__25746);
var timeout = cljs.core.get.call(null,map__25746__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.call(null,map__25746__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var this$__$1 = this;
this$__$1.timeout = timeout;

this$__$1.withCredentials = with_credentials;

this$__$1.onreadystatechange = ((function (this$__$1,map__25746,map__25746__$1,timeout,with_credentials){
return (function (){
return handler.call(null,this$__$1);
});})(this$__$1,map__25746,map__25746__$1,timeout,with_credentials))
;

var G__25748 = this$__$1;
G__25748.open(method,uri,true);

var t_25755 = G__25748;
var t_25756__$1 = (function (){var seq__25749 = cljs.core.seq.call(null,headers);
var chunk__25750 = null;
var count__25751 = (0);
var i__25752 = (0);
while(true){
if((i__25752 < count__25751)){
var vec__25753 = cljs.core._nth.call(null,chunk__25750,i__25752);
var k = cljs.core.nth.call(null,vec__25753,(0),null);
var v = cljs.core.nth.call(null,vec__25753,(1),null);
t_25755.setRequestHeader(k,v);

var G__25757 = seq__25749;
var G__25758 = chunk__25750;
var G__25759 = count__25751;
var G__25760 = (i__25752 + (1));
seq__25749 = G__25757;
chunk__25750 = G__25758;
count__25751 = G__25759;
i__25752 = G__25760;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25749);
if(temp__4425__auto__){
var seq__25749__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25749__$1)){
var c__18143__auto__ = cljs.core.chunk_first.call(null,seq__25749__$1);
var G__25761 = cljs.core.chunk_rest.call(null,seq__25749__$1);
var G__25762 = c__18143__auto__;
var G__25763 = cljs.core.count.call(null,c__18143__auto__);
var G__25764 = (0);
seq__25749 = G__25761;
chunk__25750 = G__25762;
count__25751 = G__25763;
i__25752 = G__25764;
continue;
} else {
var vec__25754 = cljs.core.first.call(null,seq__25749__$1);
var k = cljs.core.nth.call(null,vec__25754,(0),null);
var v = cljs.core.nth.call(null,vec__25754,(1),null);
t_25755.setRequestHeader(k,v);

var G__25765 = cljs.core.next.call(null,seq__25749__$1);
var G__25766 = null;
var G__25767 = (0);
var G__25768 = (0);
seq__25749 = G__25765;
chunk__25750 = G__25766;
count__25751 = G__25767;
i__25752 = G__25768;
continue;
}
} else {
return null;
}
}
break;
}
})();

G__25748.send((function (){var or__17359__auto__ = body;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return "";
}
})());

return G__25748;
});

XMLHttpRequest.prototype.ajax$core$AjaxRequest$ = true;

XMLHttpRequest.prototype.ajax$core$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
});

XMLHttpRequest.prototype.ajax$core$AjaxResponse$ = true;

XMLHttpRequest.prototype.ajax$core$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
});

XMLHttpRequest.prototype.ajax$core$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
});

XMLHttpRequest.prototype.ajax$core$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
});

XMLHttpRequest.prototype.ajax$core$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
});

XMLHttpRequest.prototype.ajax$core$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.call(null,(0),this$__$1.readyState);
});
goog.net.XhrManager.prototype.ajax$core$AjaxImpl$ = true;

goog.net.XhrManager.prototype.ajax$core$AjaxImpl$_js_ajax_request$arity$7 = (function (this$,uri,method,body,headers,handler,p__25769){
var map__25770 = p__25769;
var map__25770__$1 = ((((!((map__25770 == null)))?((((map__25770.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25770.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25770):map__25770);
var id = cljs.core.get.call(null,map__25770__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var timeout = cljs.core.get.call(null,map__25770__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var priority = cljs.core.get.call(null,map__25770__$1,new cljs.core.Keyword(null,"priority","priority",1431093715));
var max_retries = cljs.core.get.call(null,map__25770__$1,new cljs.core.Keyword(null,"max-retries","max-retries",-1933762121));
var this$__$1 = this;
return this$__$1.send(id,uri,method,body,cljs.core.clj__GT_js.call(null,headers),priority,handler,max_retries);
});
ajax.core.abort = (function ajax$core$abort(this$){
return ajax.core._abort.call(null,this$);
});
ajax.core.success_QMARK_ = (function ajax$core$success_QMARK_(status){
return cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([status], true),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),(201),(202),(204),(205),(206)], null));
});
ajax.core.read_edn = (function ajax$core$read_edn(xhrio){
return cljs.reader.read_string.call(null,ajax.core._body.call(null,xhrio));
});
ajax.core.edn_response_format = (function ajax$core$edn_response_format(){
var args25772 = [];
var len__18398__auto___25775 = arguments.length;
var i__18399__auto___25776 = (0);
while(true){
if((i__18399__auto___25776 < len__18398__auto___25775)){
args25772.push((arguments[i__18399__auto___25776]));

var G__25777 = (i__18399__auto___25776 + (1));
i__18399__auto___25776 = G__25777;
continue;
} else {
}
break;
}

var G__25774 = args25772.length;
switch (G__25774) {
case 0:
return ajax.core.edn_response_format.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return ajax.core.edn_response_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25772.length)].join('')));

}
});

ajax.core.edn_response_format.cljs$core$IFn$_invoke$arity$0 = (function (){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"read","read",1140058661),ajax.core.read_edn,new cljs.core.Keyword(null,"description","description",-1428560544),"EDN",new cljs.core.Keyword(null,"content-type","content-type",-508222634),"application/edn"], null);
});

ajax.core.edn_response_format.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return ajax.core.edn_response_format.call(null);
});

ajax.core.edn_response_format.cljs$lang$maxFixedArity = 1;
ajax.core.edn_request_format = (function ajax$core$edn_request_format(){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write","write",-1857649168),cljs.core.pr_str,new cljs.core.Keyword(null,"content-type","content-type",-508222634),"application/edn"], null);
});
ajax.core.transit_content_type = "application/transit+json; charset=utf-8";
ajax.core.transit_write = (function ajax$core$transit_write(){
var args25779 = [];
var len__18398__auto___25782 = arguments.length;
var i__18399__auto___25783 = (0);
while(true){
if((i__18399__auto___25783 < len__18398__auto___25782)){
args25779.push((arguments[i__18399__auto___25783]));

var G__25784 = (i__18399__auto___25783 + (1));
i__18399__auto___25783 = G__25784;
continue;
} else {
}
break;
}

var G__25781 = args25779.length;
switch (G__25781) {
case 2:
return ajax.core.transit_write.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.transit_write.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25779.length)].join('')));

}
});

ajax.core.transit_write.cljs$core$IFn$_invoke$arity$2 = (function (writer,params){
return cognitect.transit.write.call(null,writer,params);
});

ajax.core.transit_write.cljs$core$IFn$_invoke$arity$1 = (function (writer){
return (function (params){
return cognitect.transit.write.call(null,writer,params);
});
});

ajax.core.transit_write.cljs$lang$maxFixedArity = 2;
ajax.core.transit_request_format = (function ajax$core$transit_request_format(){
var args25786 = [];
var len__18398__auto___25792 = arguments.length;
var i__18399__auto___25793 = (0);
while(true){
if((i__18399__auto___25793 < len__18398__auto___25792)){
args25786.push((arguments[i__18399__auto___25793]));

var G__25794 = (i__18399__auto___25793 + (1));
i__18399__auto___25793 = G__25794;
continue;
} else {
}
break;
}

var G__25788 = args25786.length;
switch (G__25788) {
case 0:
return ajax.core.transit_request_format.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return ajax.core.transit_request_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25786.length)].join('')));

}
});

ajax.core.transit_request_format.cljs$core$IFn$_invoke$arity$0 = (function (){
return ajax.core.transit_request_format.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

ajax.core.transit_request_format.cljs$core$IFn$_invoke$arity$1 = (function (p__25789){
var map__25790 = p__25789;
var map__25790__$1 = ((((!((map__25790 == null)))?((((map__25790.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25790.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25790):map__25790);
var opts = map__25790__$1;
var type = cljs.core.get.call(null,map__25790__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var writer = cljs.core.get.call(null,map__25790__$1,new cljs.core.Keyword(null,"writer","writer",-277568236));
var writer__$1 = (function (){var or__17359__auto__ = writer;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cognitect.transit.writer.call(null,(function (){var or__17359__auto____$1 = type;
if(cljs.core.truth_(or__17359__auto____$1)){
return or__17359__auto____$1;
} else {
return new cljs.core.Keyword(null,"json","json",1279968570);
}
})(),opts);
}
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write","write",-1857649168),ajax.core.transit_write.call(null,writer__$1),new cljs.core.Keyword(null,"content-type","content-type",-508222634),ajax.core.transit_content_type], null);
});

ajax.core.transit_request_format.cljs$lang$maxFixedArity = 1;
ajax.core.transit_read = (function ajax$core$transit_read(){
var args25796 = [];
var len__18398__auto___25799 = arguments.length;
var i__18399__auto___25800 = (0);
while(true){
if((i__18399__auto___25800 < len__18398__auto___25799)){
args25796.push((arguments[i__18399__auto___25800]));

var G__25801 = (i__18399__auto___25800 + (1));
i__18399__auto___25800 = G__25801;
continue;
} else {
}
break;
}

var G__25798 = args25796.length;
switch (G__25798) {
case 3:
return ajax.core.transit_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return ajax.core.transit_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.transit_read.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25796.length)].join('')));

}
});

ajax.core.transit_read.cljs$core$IFn$_invoke$arity$3 = (function (reader,raw,xhrio){
var text = ajax.core._body.call(null,xhrio);
var data = cognitect.transit.read.call(null,reader,text);
if(cljs.core.truth_(raw)){
return data;
} else {
return cljs.core.js__GT_clj.call(null,data);
}
});

ajax.core.transit_read.cljs$core$IFn$_invoke$arity$2 = (function (reader,raw){
return (function (xhrio){
var text = ajax.core._body.call(null,xhrio);
var data = cognitect.transit.read.call(null,reader,text);
if(cljs.core.truth_(raw)){
return data;
} else {
return cljs.core.js__GT_clj.call(null,data);
}
});
});

ajax.core.transit_read.cljs$core$IFn$_invoke$arity$1 = (function (reader){
return (function (raw,xhrio){
var text = ajax.core._body.call(null,xhrio);
var data = cognitect.transit.read.call(null,reader,text);
if(cljs.core.truth_(raw)){
return data;
} else {
return cljs.core.js__GT_clj.call(null,data);
}
});
});

ajax.core.transit_read.cljs$lang$maxFixedArity = 3;
ajax.core.transit_response_format = (function ajax$core$transit_response_format(){
var args25803 = [];
var len__18398__auto___25809 = arguments.length;
var i__18399__auto___25810 = (0);
while(true){
if((i__18399__auto___25810 < len__18398__auto___25809)){
args25803.push((arguments[i__18399__auto___25810]));

var G__25811 = (i__18399__auto___25810 + (1));
i__18399__auto___25810 = G__25811;
continue;
} else {
}
break;
}

var G__25805 = args25803.length;
switch (G__25805) {
case 0:
return ajax.core.transit_response_format.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return ajax.core.transit_response_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25803.length)].join('')));

}
});

ajax.core.transit_response_format.cljs$core$IFn$_invoke$arity$0 = (function (){
return ajax.core.transit_response_format.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

ajax.core.transit_response_format.cljs$core$IFn$_invoke$arity$1 = (function (p__25806){
var map__25807 = p__25806;
var map__25807__$1 = ((((!((map__25807 == null)))?((((map__25807.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25807.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25807):map__25807);
var opts = map__25807__$1;
var type = cljs.core.get.call(null,map__25807__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var reader = cljs.core.get.call(null,map__25807__$1,new cljs.core.Keyword(null,"reader","reader",169660853));
var raw = cljs.core.get.call(null,map__25807__$1,new cljs.core.Keyword(null,"raw","raw",1604651272));
var reader__$1 = (function (){var or__17359__auto__ = reader;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cognitect.transit.reader.call(null,(function (){var or__17359__auto____$1 = type;
if(cljs.core.truth_(or__17359__auto____$1)){
return or__17359__auto____$1;
} else {
return new cljs.core.Keyword(null,"json","json",1279968570);
}
})(),opts);
}
})();
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"read","read",1140058661),ajax.core.transit_read.call(null,reader__$1,raw),new cljs.core.Keyword(null,"description","description",-1428560544),"Transit",new cljs.core.Keyword(null,"content-type","content-type",-508222634),"application/transit+json"], null);
});

ajax.core.transit_response_format.cljs$lang$maxFixedArity = 1;
ajax.core.params_to_str = (function ajax$core$params_to_str(params){
if(cljs.core.truth_(params)){
return goog.Uri.QueryData.createFromMap((new goog.structs.Map(cljs.core.clj__GT_js.call(null,params)))).toString();
} else {
return null;
}
});
ajax.core.url_request_format = (function ajax$core$url_request_format(){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write","write",-1857649168),ajax.core.params_to_str,new cljs.core.Keyword(null,"content-type","content-type",-508222634),"application/x-www-form-urlencoded"], null);
});
ajax.core.raw_response_format = (function ajax$core$raw_response_format(){
var args25813 = [];
var len__18398__auto___25816 = arguments.length;
var i__18399__auto___25817 = (0);
while(true){
if((i__18399__auto___25817 < len__18398__auto___25816)){
args25813.push((arguments[i__18399__auto___25817]));

var G__25818 = (i__18399__auto___25817 + (1));
i__18399__auto___25817 = G__25818;
continue;
} else {
}
break;
}

var G__25815 = args25813.length;
switch (G__25815) {
case 0:
return ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25813.length)].join('')));

}
});

ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0 = (function (){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"read","read",1140058661),ajax.core._body,new cljs.core.Keyword(null,"description","description",-1428560544),"raw text",new cljs.core.Keyword(null,"content-type","content-type",-508222634),"*/*"], null);
});

ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return ajax.core.raw_response_format.call(null);
});

ajax.core.raw_response_format.cljs$lang$maxFixedArity = 1;
ajax.core.write_json = (function ajax$core$write_json(data){
return (new goog.json.Serializer()).serialize(cljs.core.clj__GT_js.call(null,data));
});
ajax.core.json_request_format = (function ajax$core$json_request_format(){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write","write",-1857649168),ajax.core.write_json,new cljs.core.Keyword(null,"content-type","content-type",-508222634),"application/json"], null);
});
ajax.core.json_read = (function ajax$core$json_read(){
var args25820 = [];
var len__18398__auto___25823 = arguments.length;
var i__18399__auto___25824 = (0);
while(true){
if((i__18399__auto___25824 < len__18398__auto___25823)){
args25820.push((arguments[i__18399__auto___25824]));

var G__25825 = (i__18399__auto___25824 + (1));
i__18399__auto___25824 = G__25825;
continue;
} else {
}
break;
}

var G__25822 = args25820.length;
switch (G__25822) {
case 4:
return ajax.core.json_read.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return ajax.core.json_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return ajax.core.json_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.json_read.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25820.length)].join('')));

}
});

ajax.core.json_read.cljs$core$IFn$_invoke$arity$4 = (function (prefix,raw,keywords_QMARK_,xhrio){
var text = ajax.core._body.call(null,xhrio);
var text__$1 = (cljs.core.truth_((function (){var and__17347__auto__ = prefix;
if(cljs.core.truth_(and__17347__auto__)){
return cljs.core._EQ_.call(null,(0),text.indexOf(prefix));
} else {
return and__17347__auto__;
}
})())?text.substring(prefix.length()):text);
var json = goog.json.parse(text__$1);
if(cljs.core.truth_(raw)){
return json;
} else {
return cljs.core.js__GT_clj.call(null,json,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywords_QMARK_);
}
});

ajax.core.json_read.cljs$core$IFn$_invoke$arity$3 = (function (prefix,raw,keywords_QMARK_){
return (function (xhrio){
var text = ajax.core._body.call(null,xhrio);
var text__$1 = (cljs.core.truth_((function (){var and__17347__auto__ = prefix;
if(cljs.core.truth_(and__17347__auto__)){
return cljs.core._EQ_.call(null,(0),text.indexOf(prefix));
} else {
return and__17347__auto__;
}
})())?text.substring(prefix.length()):text);
var json = goog.json.parse(text__$1);
if(cljs.core.truth_(raw)){
return json;
} else {
return cljs.core.js__GT_clj.call(null,json,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywords_QMARK_);
}
});
});

ajax.core.json_read.cljs$core$IFn$_invoke$arity$2 = (function (prefix,raw){
return (function (keywords_QMARK_,xhrio){
var text = ajax.core._body.call(null,xhrio);
var text__$1 = (cljs.core.truth_((function (){var and__17347__auto__ = prefix;
if(cljs.core.truth_(and__17347__auto__)){
return cljs.core._EQ_.call(null,(0),text.indexOf(prefix));
} else {
return and__17347__auto__;
}
})())?text.substring(prefix.length()):text);
var json = goog.json.parse(text__$1);
if(cljs.core.truth_(raw)){
return json;
} else {
return cljs.core.js__GT_clj.call(null,json,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywords_QMARK_);
}
});
});

ajax.core.json_read.cljs$core$IFn$_invoke$arity$1 = (function (prefix){
return (function (raw,keywords_QMARK_,xhrio){
var text = ajax.core._body.call(null,xhrio);
var text__$1 = (cljs.core.truth_((function (){var and__17347__auto__ = prefix;
if(cljs.core.truth_(and__17347__auto__)){
return cljs.core._EQ_.call(null,(0),text.indexOf(prefix));
} else {
return and__17347__auto__;
}
})())?text.substring(prefix.length()):text);
var json = goog.json.parse(text__$1);
if(cljs.core.truth_(raw)){
return json;
} else {
return cljs.core.js__GT_clj.call(null,json,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywords_QMARK_);
}
});
});

ajax.core.json_read.cljs$lang$maxFixedArity = 4;
/**
 * Returns a JSON response format.  Options include
 * :keywords? Returns the keys as keywords
 * :prefix A prefix that needs to be stripped off.  This is to
 * combat JSON hijacking.  If you're using JSON with GET request,
 * you should think about using this.
 * http://stackoverflow.com/questions/2669690/why-does-google-prepend-while1-to-their-json-responses
 * http://haacked.com/archive/2009/06/24/json-hijacking.aspx
 */
ajax.core.json_response_format = (function ajax$core$json_response_format(){
var args25827 = [];
var len__18398__auto___25833 = arguments.length;
var i__18399__auto___25834 = (0);
while(true){
if((i__18399__auto___25834 < len__18398__auto___25833)){
args25827.push((arguments[i__18399__auto___25834]));

var G__25835 = (i__18399__auto___25834 + (1));
i__18399__auto___25834 = G__25835;
continue;
} else {
}
break;
}

var G__25829 = args25827.length;
switch (G__25829) {
case 0:
return ajax.core.json_response_format.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return ajax.core.json_response_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25827.length)].join('')));

}
});

ajax.core.json_response_format.cljs$core$IFn$_invoke$arity$0 = (function (){
return ajax.core.json_response_format.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

ajax.core.json_response_format.cljs$core$IFn$_invoke$arity$1 = (function (p__25830){
var map__25831 = p__25830;
var map__25831__$1 = ((((!((map__25831 == null)))?((((map__25831.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25831.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25831):map__25831);
var prefix = cljs.core.get.call(null,map__25831__$1,new cljs.core.Keyword(null,"prefix","prefix",-265908465));
var keywords_QMARK_ = cljs.core.get.call(null,map__25831__$1,new cljs.core.Keyword(null,"keywords?","keywords?",764949733));
var raw = cljs.core.get.call(null,map__25831__$1,new cljs.core.Keyword(null,"raw","raw",1604651272));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"read","read",1140058661),ajax.core.json_read.call(null,prefix,raw,keywords_QMARK_),new cljs.core.Keyword(null,"description","description",-1428560544),[cljs.core.str("JSON"),cljs.core.str((cljs.core.truth_(prefix)?[cljs.core.str(" prefix '"),cljs.core.str(prefix),cljs.core.str("'")].join(''):null)),cljs.core.str((cljs.core.truth_(keywords_QMARK_)?" keywordize":null))].join(''),new cljs.core.Keyword(null,"content-type","content-type",-508222634),"application/json"], null);
});

ajax.core.json_response_format.cljs$lang$maxFixedArity = 1;
ajax.core.default_formats = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [ajax.core.json_response_format,ajax.core.edn_response_format,ajax.core.transit_response_format,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/plain",ajax.core.raw_response_format], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/html",ajax.core.raw_response_format], null),ajax.core.raw_response_format], null);
ajax.core.get_format = (function ajax$core$get_format(){
var args25837 = [];
var len__18398__auto___25840 = arguments.length;
var i__18399__auto___25841 = (0);
while(true){
if((i__18399__auto___25841 < len__18398__auto___25840)){
args25837.push((arguments[i__18399__auto___25841]));

var G__25842 = (i__18399__auto___25841 + (1));
i__18399__auto___25841 = G__25842;
continue;
} else {
}
break;
}

var G__25839 = args25837.length;
switch (G__25839) {
case 2:
return ajax.core.get_format.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.get_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25837.length)].join('')));

}
});

ajax.core.get_format.cljs$core$IFn$_invoke$arity$2 = (function (opts,format_entry){
if(cljs.core.vector_QMARK_.call(null,format_entry)){
return ajax.core.get_format.call(null,opts,cljs.core.second.call(null,format_entry));
} else {
if(cljs.core.map_QMARK_.call(null,format_entry)){
return format_entry;
} else {
return format_entry.call(null,opts);

}
}
});

ajax.core.get_format.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return (function (format_entry){
if(cljs.core.vector_QMARK_.call(null,format_entry)){
return ajax.core.get_format.call(null,opts,cljs.core.second.call(null,format_entry));
} else {
if(cljs.core.map_QMARK_.call(null,format_entry)){
return format_entry;
} else {
return format_entry.call(null,opts);

}
}
});
});

ajax.core.get_format.cljs$lang$maxFixedArity = 2;
ajax.core.accept_entry = (function ajax$core$accept_entry(){
var args25844 = [];
var len__18398__auto___25847 = arguments.length;
var i__18399__auto___25848 = (0);
while(true){
if((i__18399__auto___25848 < len__18398__auto___25847)){
args25844.push((arguments[i__18399__auto___25848]));

var G__25849 = (i__18399__auto___25848 + (1));
i__18399__auto___25848 = G__25849;
continue;
} else {
}
break;
}

var G__25846 = args25844.length;
switch (G__25846) {
case 2:
return ajax.core.accept_entry.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.accept_entry.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25844.length)].join('')));

}
});

ajax.core.accept_entry.cljs$core$IFn$_invoke$arity$2 = (function (opts,format_entry){
var or__17359__auto__ = ((cljs.core.vector_QMARK_.call(null,format_entry))?cljs.core.first.call(null,format_entry):new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(ajax.core.get_format.call(null,opts,format_entry)));
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return "*/*";
}
});

ajax.core.accept_entry.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return (function (format_entry){
var or__17359__auto__ = ((cljs.core.vector_QMARK_.call(null,format_entry))?cljs.core.first.call(null,format_entry):new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(ajax.core.get_format.call(null,opts,format_entry)));
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return "*/*";
}
});
});

ajax.core.accept_entry.cljs$lang$maxFixedArity = 2;
ajax.core.detect_content_type = (function ajax$core$detect_content_type(){
var args25851 = [];
var len__18398__auto___25854 = arguments.length;
var i__18399__auto___25855 = (0);
while(true){
if((i__18399__auto___25855 < len__18398__auto___25854)){
args25851.push((arguments[i__18399__auto___25855]));

var G__25856 = (i__18399__auto___25855 + (1));
i__18399__auto___25855 = G__25856;
continue;
} else {
}
break;
}

var G__25853 = args25851.length;
switch (G__25853) {
case 3:
return ajax.core.detect_content_type.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return ajax.core.detect_content_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.detect_content_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25851.length)].join('')));

}
});

ajax.core.detect_content_type.cljs$core$IFn$_invoke$arity$3 = (function (content_type,opts,format_entry){
var accept = ajax.core.accept_entry.call(null,opts,format_entry);
return (cljs.core._EQ_.call(null,accept,"*/*")) || ((content_type.indexOf(accept) >= (0)));
});

ajax.core.detect_content_type.cljs$core$IFn$_invoke$arity$2 = (function (content_type,opts){
return (function (format_entry){
var accept = ajax.core.accept_entry.call(null,opts,format_entry);
return (cljs.core._EQ_.call(null,accept,"*/*")) || ((content_type.indexOf(accept) >= (0)));
});
});

ajax.core.detect_content_type.cljs$core$IFn$_invoke$arity$1 = (function (content_type){
return (function (opts,format_entry){
var accept = ajax.core.accept_entry.call(null,opts,format_entry);
return (cljs.core._EQ_.call(null,accept,"*/*")) || ((content_type.indexOf(accept) >= (0)));
});
});

ajax.core.detect_content_type.cljs$lang$maxFixedArity = 3;
ajax.core.get_default_format = (function ajax$core$get_default_format(xhrio,p__25858){
var map__25861 = p__25858;
var map__25861__$1 = ((((!((map__25861 == null)))?((((map__25861.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25861.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25861):map__25861);
var opts = map__25861__$1;
var response_format = cljs.core.get.call(null,map__25861__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var f = ajax.core.detect_content_type.call(null,(function (){var or__17359__auto__ = ajax.core._get_response_header.call(null,xhrio,"Content-Type");
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return "";
}
})(),opts);
return ajax.core.get_format.call(null,opts,cljs.core.first.call(null,cljs.core.filter.call(null,f,response_format)));
});
ajax.core.detect_response_format_read = (function ajax$core$detect_response_format_read(){
var args25863 = [];
var len__18398__auto___25866 = arguments.length;
var i__18399__auto___25867 = (0);
while(true){
if((i__18399__auto___25867 < len__18398__auto___25866)){
args25863.push((arguments[i__18399__auto___25867]));

var G__25868 = (i__18399__auto___25867 + (1));
i__18399__auto___25867 = G__25868;
continue;
} else {
}
break;
}

var G__25865 = args25863.length;
switch (G__25865) {
case 2:
return ajax.core.detect_response_format_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.detect_response_format_read.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25863.length)].join('')));

}
});

ajax.core.detect_response_format_read.cljs$core$IFn$_invoke$arity$2 = (function (opts,xhrio){
return new cljs.core.Keyword(null,"read","read",1140058661).cljs$core$IFn$_invoke$arity$1(ajax.core.get_default_format.call(null,xhrio,opts)).call(null,xhrio);
});

ajax.core.detect_response_format_read.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return (function (xhrio){
return new cljs.core.Keyword(null,"read","read",1140058661).cljs$core$IFn$_invoke$arity$1(ajax.core.get_default_format.call(null,xhrio,opts)).call(null,xhrio);
});
});

ajax.core.detect_response_format_read.cljs$lang$maxFixedArity = 2;
ajax.core.accept_header = (function ajax$core$accept_header(p__25870){
var map__25873 = p__25870;
var map__25873__$1 = ((((!((map__25873 == null)))?((((map__25873.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25873.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25873):map__25873);
var opts = map__25873__$1;
var response_format = cljs.core.get.call(null,map__25873__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
if(cljs.core.vector_QMARK_.call(null,response_format)){
return clojure.string.join.call(null,", ",cljs.core.map.call(null,ajax.core.accept_entry.call(null,opts),response_format));
} else {
return ajax.core.accept_entry.call(null,opts,response_format);
}
});
ajax.core.detect_response_format = (function ajax$core$detect_response_format(){
var args25875 = [];
var len__18398__auto___25878 = arguments.length;
var i__18399__auto___25879 = (0);
while(true){
if((i__18399__auto___25879 < len__18398__auto___25878)){
args25875.push((arguments[i__18399__auto___25879]));

var G__25880 = (i__18399__auto___25879 + (1));
i__18399__auto___25879 = G__25880;
continue;
} else {
}
break;
}

var G__25877 = args25875.length;
switch (G__25877) {
case 0:
return ajax.core.detect_response_format.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return ajax.core.detect_response_format.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25875.length)].join('')));

}
});

ajax.core.detect_response_format.cljs$core$IFn$_invoke$arity$0 = (function (){
return ajax.core.detect_response_format.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"response-format","response-format",1664465322),ajax.core.default_formats], null));
});

ajax.core.detect_response_format.cljs$core$IFn$_invoke$arity$1 = (function (opts){
var accept = ajax.core.accept_header.call(null,opts);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"read","read",1140058661),ajax.core.detect_response_format_read.call(null,opts),new cljs.core.Keyword(null,"format","format",-1306924766),[cljs.core.str("(from "),cljs.core.str(accept),cljs.core.str(")")].join(''),new cljs.core.Keyword(null,"content-type","content-type",-508222634),accept], null);
});

ajax.core.detect_response_format.cljs$lang$maxFixedArity = 1;
ajax.core.get_response_format = (function ajax$core$get_response_format(p__25882){
var map__25885 = p__25882;
var map__25885__$1 = ((((!((map__25885 == null)))?((((map__25885.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25885.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25885):map__25885);
var opts = map__25885__$1;
var response_format = cljs.core.get.call(null,map__25885__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
if(cljs.core.vector_QMARK_.call(null,response_format)){
return ajax.core.detect_response_format.call(null,opts);
} else {
if(cljs.core.map_QMARK_.call(null,response_format)){
return response_format;
} else {
if(cljs.core.ifn_QMARK_.call(null,response_format)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"read","read",1140058661),response_format,new cljs.core.Keyword(null,"description","description",-1428560544),"custom",new cljs.core.Keyword(null,"content-type","content-type",-508222634),"*/*"], null);
} else {
throw (new Error([cljs.core.str("unrecognized response format: "),cljs.core.str(response_format)].join('')));

}
}
}
});
ajax.core.exception_response = (function ajax$core$exception_response(e,status,p__25887,xhrio){
var map__25890 = p__25887;
var map__25890__$1 = ((((!((map__25890 == null)))?((((map__25890.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25890.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25890):map__25890);
var description = cljs.core.get.call(null,map__25890__$1,new cljs.core.Keyword(null,"description","description",-1428560544));
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"failure","failure",720415879),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"response","response",-1068424192),null], null);
var status_text = [cljs.core.str(e.message),cljs.core.str("  Format should have been "),cljs.core.str(description)].join('');
var parse_error = cljs.core.assoc.call(null,response,new cljs.core.Keyword(null,"status-text","status-text",-1834235478),status_text,new cljs.core.Keyword(null,"failure","failure",720415879),new cljs.core.Keyword(null,"parse","parse",-1162164619),new cljs.core.Keyword(null,"original-text","original-text",744448452),ajax.core._body.call(null,xhrio));
if(cljs.core.truth_(ajax.core.success_QMARK_.call(null,status))){
return parse_error;
} else {
return cljs.core.assoc.call(null,response,new cljs.core.Keyword(null,"status-text","status-text",-1834235478),ajax.core._status_text.call(null,xhrio),new cljs.core.Keyword(null,"parse-error","parse-error",255902478),parse_error);
}
});
ajax.core.fail = (function ajax$core$fail(){
var args__18405__auto__ = [];
var len__18398__auto___25896 = arguments.length;
var i__18399__auto___25897 = (0);
while(true){
if((i__18399__auto___25897 < len__18398__auto___25896)){
args__18405__auto__.push((arguments[i__18399__auto___25897]));

var G__25898 = (i__18399__auto___25897 + (1));
i__18399__auto___25897 = G__25898;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((3) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((3)),(0))):null);
return ajax.core.fail.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__18406__auto__);
});

ajax.core.fail.cljs$core$IFn$_invoke$arity$variadic = (function (status,status_text,failure,params){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-text","status-text",-1834235478),status_text,new cljs.core.Keyword(null,"failure","failure",720415879),failure], null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,cljs.core.reduce.call(null,cljs.core.conj,response,cljs.core.map.call(null,cljs.core.vec,cljs.core.partition.call(null,(2),params)))], null);
});

ajax.core.fail.cljs$lang$maxFixedArity = (3);

ajax.core.fail.cljs$lang$applyTo = (function (seq25892){
var G__25893 = cljs.core.first.call(null,seq25892);
var seq25892__$1 = cljs.core.next.call(null,seq25892);
var G__25894 = cljs.core.first.call(null,seq25892__$1);
var seq25892__$2 = cljs.core.next.call(null,seq25892__$1);
var G__25895 = cljs.core.first.call(null,seq25892__$2);
var seq25892__$3 = cljs.core.next.call(null,seq25892__$2);
return ajax.core.fail.cljs$core$IFn$_invoke$arity$variadic(G__25893,G__25894,G__25895,seq25892__$3);
});
ajax.core.interpret_response = (function ajax$core$interpret_response(p__25899,xhrio){
var map__25904 = p__25899;
var map__25904__$1 = ((((!((map__25904 == null)))?((((map__25904.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25904.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25904):map__25904);
var format = map__25904__$1;
var read = cljs.core.get.call(null,map__25904__$1,new cljs.core.Keyword(null,"read","read",1140058661));
try{var status = ajax.core._status.call(null,xhrio);
var fail = cljs.core.partial.call(null,ajax.core.fail,status);
if(cljs.core._EQ_.call(null,(-1),status)){
if(cljs.core.truth_(ajax.core._was_aborted.call(null,xhrio))){
return fail.call(null,"Request aborted by client.",new cljs.core.Keyword(null,"aborted","aborted",1775972619));
} else {
return fail.call(null,"Request timed out.",new cljs.core.Keyword(null,"timeout","timeout",-318625318));
}
} else {
try{var response = read.call(null,xhrio);
if(cljs.core.truth_(ajax.core.success_QMARK_.call(null,status))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,response], null);
} else {
return fail.call(null,ajax.core._status_text.call(null,xhrio),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"response","response",-1068424192),response);
}
}catch (e25907){if((e25907 instanceof Object)){
var e = e25907;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,ajax.core.exception_response.call(null,e,status,format,xhrio)], null);
} else {
throw e25907;

}
}}
}catch (e25906){if((e25906 instanceof Object)){
var e = e25906;
return ajax.core.fail.call(null,(0),e.message,new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"exception","exception",-335277064),e);
} else {
throw e25906;

}
}});
ajax.core.no_format = (function ajax$core$no_format(xhrio){
throw (new Error("No response format was supplied."));
});
ajax.core.uri_with_params = (function ajax$core$uri_with_params(uri,params){
if(cljs.core.truth_(params)){
return [cljs.core.str(uri),cljs.core.str("?"),cljs.core.str(ajax.core.params_to_str.call(null,params))].join('');
} else {
return uri;
}
});
ajax.core.get_request_format = (function ajax$core$get_request_format(format){
if(cljs.core.map_QMARK_.call(null,format)){
return format;
} else {
if(cljs.core.ifn_QMARK_.call(null,format)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write","write",-1857649168),format,new cljs.core.Keyword(null,"content-type","content-type",-508222634),"text/plain"], null);
} else {
return null;

}
}
});
ajax.core.normalize_method = (function ajax$core$normalize_method(method){
if((method instanceof cljs.core.Keyword)){
return clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
} else {
return method;
}
});
ajax.core.process_inputs = (function ajax$core$process_inputs(p__25908,p__25909){
var map__25916 = p__25908;
var map__25916__$1 = ((((!((map__25916 == null)))?((((map__25916.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25916.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25916):map__25916);
var uri = cljs.core.get.call(null,map__25916__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.call(null,map__25916__$1,new cljs.core.Keyword(null,"method","method",55703592));
var format = cljs.core.get.call(null,map__25916__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var params = cljs.core.get.call(null,map__25916__$1,new cljs.core.Keyword(null,"params","params",710516235));
var headers = cljs.core.get.call(null,map__25916__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var map__25917 = p__25909;
var map__25917__$1 = ((((!((map__25917 == null)))?((((map__25917.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25917.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25917):map__25917);
var content_type = cljs.core.get.call(null,map__25917__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634));
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["Accept",content_type], null),(function (){var or__17359__auto__ = headers;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})());
if(cljs.core._EQ_.call(null,ajax.core.normalize_method.call(null,method),"GET")){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ajax.core.uri_with_params.call(null,uri,params),null,headers__$1], null);
} else {
var map__25920 = ajax.core.get_request_format.call(null,format);
var map__25920__$1 = ((((!((map__25920 == null)))?((((map__25920.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25920.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25920):map__25920);
var write = cljs.core.get.call(null,map__25920__$1,new cljs.core.Keyword(null,"write","write",-1857649168));
var content_type__$1 = cljs.core.get.call(null,map__25920__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634));
var body = ((!((write == null)))?write.call(null,params):(cljs.core.truth_(ajax.core.submittable_QMARK_.call(null,params))?params:(function(){throw (new Error([cljs.core.str("unrecognized request format: "),cljs.core.str(format)].join('')))})()
));
var content_type__$2 = (cljs.core.truth_(content_type__$1)?new cljs.core.PersistentArrayMap(null, 1, ["Content-Type",content_type__$1], null):null);
var headers__$2 = cljs.core.merge.call(null,headers__$1,content_type__$2);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,body,headers__$2], null);
}
});
ajax.core.js_handler = (function ajax$core$js_handler(){
var args25922 = [];
var len__18398__auto___25925 = arguments.length;
var i__18399__auto___25926 = (0);
while(true){
if((i__18399__auto___25926 < len__18398__auto___25925)){
args25922.push((arguments[i__18399__auto___25926]));

var G__25927 = (i__18399__auto___25926 + (1));
i__18399__auto___25926 = G__25927;
continue;
} else {
}
break;
}

var G__25924 = args25922.length;
switch (G__25924) {
case 3:
return ajax.core.js_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return ajax.core.js_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.js_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25922.length)].join('')));

}
});

ajax.core.js_handler.cljs$core$IFn$_invoke$arity$3 = (function (response_format,handler,xhrio){
var response = ajax.core.interpret_response.call(null,response_format,xhrio);
return handler.call(null,response);
});

ajax.core.js_handler.cljs$core$IFn$_invoke$arity$2 = (function (response_format,handler){
return (function (xhrio){
var response = ajax.core.interpret_response.call(null,response_format,xhrio);
return handler.call(null,response);
});
});

ajax.core.js_handler.cljs$core$IFn$_invoke$arity$1 = (function (response_format){
return (function (handler,xhrio){
var response = ajax.core.interpret_response.call(null,response_format,xhrio);
return handler.call(null,response);
});
});

ajax.core.js_handler.cljs$lang$maxFixedArity = 3;
ajax.core.base_handler = (function ajax$core$base_handler(response_format,p__25929){
var map__25932 = p__25929;
var map__25932__$1 = ((((!((map__25932 == null)))?((((map__25932.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25932.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25932):map__25932);
var handler = cljs.core.get.call(null,map__25932__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.truth_(handler)){
return ajax.core.js_handler.call(null,response_format,handler);
} else {
throw (new Error("No ajax handler provided."));
}
});
ajax.core.ajax_request = (function ajax$core$ajax_request(p__25934){
var map__25938 = p__25934;
var map__25938__$1 = ((((!((map__25938 == null)))?((((map__25938.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25938.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25938):map__25938);
var opts = map__25938__$1;
var method = cljs.core.get.call(null,map__25938__$1,new cljs.core.Keyword(null,"method","method",55703592));
var api = cljs.core.get.call(null,map__25938__$1,new cljs.core.Keyword(null,"api","api",-899839580));
var response_format = ajax.core.get_response_format.call(null,opts);
var method__$1 = ajax.core.normalize_method.call(null,method);
var vec__25940 = ajax.core.process_inputs.call(null,opts,response_format);
var uri = cljs.core.nth.call(null,vec__25940,(0),null);
var body = cljs.core.nth.call(null,vec__25940,(1),null);
var headers = cljs.core.nth.call(null,vec__25940,(2),null);
var handler = ajax.core.base_handler.call(null,response_format,opts);
var api__$1 = (function (){var or__17359__auto__ = api;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return (new goog.net.XhrIo());
}
})();
return ajax.core._js_ajax_request.call(null,api__$1,uri,method__$1,body,headers,handler,opts);
});
ajax.core.keyword_request_format = (function ajax$core$keyword_request_format(format,format_params){
if(cljs.core.map_QMARK_.call(null,format)){
return format;
} else {
if(cljs.core.fn_QMARK_.call(null,format)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"write","write",-1857649168),format], null);
} else {
if((format == null)){
return ajax.core.transit_request_format.call(null,format_params);
} else {
var G__25942 = (((format instanceof cljs.core.Keyword))?format.fqn:null);
switch (G__25942) {
case "transit":
return ajax.core.transit_request_format.call(null,format_params);

break;
case "json":
return ajax.core.json_request_format.call(null);

break;
case "edn":
return ajax.core.edn_request_format.call(null);

break;
case "raw":
return ajax.core.url_request_format.call(null);

break;
case "url":
return ajax.core.url_request_format.call(null);

break;
default:
return null;

}

}
}
}
});
ajax.core.keyword_response_format_2 = (function ajax$core$keyword_response_format_2(format,format_params){
if(cljs.core.vector_QMARK_.call(null,format)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,format),ajax$core$keyword_response_format_2.call(null,cljs.core.second.call(null,format),format_params)], null);
} else {
if(cljs.core.map_QMARK_.call(null,format)){
return format;
} else {
if(cljs.core.fn_QMARK_.call(null,format)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read","read",1140058661),format,new cljs.core.Keyword(null,"description","description",-1428560544),"custom"], null);
} else {
if((format == null)){
return ajax.core.detect_response_format.call(null);
} else {
var G__25945 = (((format instanceof cljs.core.Keyword))?format.fqn:null);
switch (G__25945) {
case "transit":
return ajax.core.transit_response_format.call(null,format_params);

break;
case "json":
return ajax.core.json_response_format.call(null,format_params);

break;
case "edn":
return ajax.core.edn_response_format.call(null);

break;
case "raw":
return ajax.core.raw_response_format.call(null);

break;
case "detect":
return ajax.core.detect_response_format.call(null);

break;
default:
return null;

}

}
}
}
}
});
ajax.core.keyword_response_format = (function ajax$core$keyword_response_format(format,format_params){
if(cljs.core.vector_QMARK_.call(null,format)){
return cljs.core.apply.call(null,cljs.core.vector,cljs.core.map.call(null,(function (p1__25947_SHARP_){
return ajax.core.keyword_response_format_2.call(null,p1__25947_SHARP_,format_params);
}),format));
} else {
return ajax.core.keyword_response_format_2.call(null,format,format_params);
}
});
ajax.core.transform_handler = (function ajax$core$transform_handler(){
var args25948 = [];
var len__18398__auto___25961 = arguments.length;
var i__18399__auto___25962 = (0);
while(true){
if((i__18399__auto___25962 < len__18398__auto___25961)){
args25948.push((arguments[i__18399__auto___25962]));

var G__25963 = (i__18399__auto___25962 + (1));
i__18399__auto___25962 = G__25963;
continue;
} else {
}
break;
}

var G__25950 = args25948.length;
switch (G__25950) {
case 2:
return ajax.core.transform_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return ajax.core.transform_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25948.length)].join('')));

}
});

ajax.core.transform_handler.cljs$core$IFn$_invoke$arity$2 = (function (p__25951,p__25952){
var map__25953 = p__25951;
var map__25953__$1 = ((((!((map__25953 == null)))?((((map__25953.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25953.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25953):map__25953);
var handler = cljs.core.get.call(null,map__25953__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
var error_handler = cljs.core.get.call(null,map__25953__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var finally$ = cljs.core.get.call(null,map__25953__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var vec__25954 = p__25952;
var ok = cljs.core.nth.call(null,vec__25954,(0),null);
var result = cljs.core.nth.call(null,vec__25954,(1),null);
var temp__4423__auto___25965 = (cljs.core.truth_(ok)?handler:error_handler);
if(cljs.core.truth_(temp__4423__auto___25965)){
var h_25966 = temp__4423__auto___25965;
h_25966.call(null,result);
} else {
}

if(cljs.core.fn_QMARK_.call(null,finally$)){
return finally$.call(null);
} else {
return null;
}
});

ajax.core.transform_handler.cljs$core$IFn$_invoke$arity$1 = (function (p__25956){
var map__25957 = p__25956;
var map__25957__$1 = ((((!((map__25957 == null)))?((((map__25957.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25957.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25957):map__25957);
var handler = cljs.core.get.call(null,map__25957__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
var error_handler = cljs.core.get.call(null,map__25957__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var finally$ = cljs.core.get.call(null,map__25957__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
return ((function (map__25957,map__25957__$1,handler,error_handler,finally$){
return (function (p__25959){
var vec__25960 = p__25959;
var ok = cljs.core.nth.call(null,vec__25960,(0),null);
var result = cljs.core.nth.call(null,vec__25960,(1),null);
var temp__4423__auto___25967 = (cljs.core.truth_(ok)?handler:error_handler);
if(cljs.core.truth_(temp__4423__auto___25967)){
var h_25968 = temp__4423__auto___25967;
h_25968.call(null,result);
} else {
}

if(cljs.core.fn_QMARK_.call(null,finally$)){
return finally$.call(null);
} else {
return null;
}
});
;})(map__25957,map__25957__$1,handler,error_handler,finally$))
});

ajax.core.transform_handler.cljs$lang$maxFixedArity = 2;
ajax.core.transform_opts = (function ajax$core$transform_opts(p__25969){
var map__25972 = p__25969;
var map__25972__$1 = ((((!((map__25972 == null)))?((((map__25972.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25972.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25972):map__25972);
var opts = map__25972__$1;
var method = cljs.core.get.call(null,map__25972__$1,new cljs.core.Keyword(null,"method","method",55703592));
var format = cljs.core.get.call(null,map__25972__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var response_format = cljs.core.get.call(null,map__25972__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var params = cljs.core.get.call(null,map__25972__$1,new cljs.core.Keyword(null,"params","params",710516235));

var needs_format = cljs.core.not.call(null,(function (){var or__17359__auto__ = ajax.core.submittable_QMARK_.call(null,params);
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return cljs.core._EQ_.call(null,method,"GET");
}
})());
var rf = (cljs.core.truth_((function (){var or__17359__auto__ = format;
if(cljs.core.truth_(or__17359__auto__)){
return or__17359__auto__;
} else {
return needs_format;
}
})())?ajax.core.keyword_request_format.call(null,format,opts):null);
return cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"handler","handler",-195596612),ajax.core.transform_handler.call(null,opts),new cljs.core.Keyword(null,"format","format",-1306924766),rf,new cljs.core.Keyword(null,"response-format","response-format",1664465322),ajax.core.keyword_response_format.call(null,response_format,opts));
});
ajax.core.easy_ajax_request = (function ajax$core$easy_ajax_request(uri,method,opts){
return ajax.core.ajax_request.call(null,ajax.core.transform_opts.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"uri","uri",-774711847),uri,new cljs.core.Keyword(null,"method","method",55703592),method)));
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.GET = (function ajax$core$GET(){
var args__18405__auto__ = [];
var len__18398__auto___25976 = arguments.length;
var i__18399__auto___25977 = (0);
while(true){
if((i__18399__auto___25977 < len__18398__auto___25976)){
args__18405__auto__.push((arguments[i__18399__auto___25977]));

var G__25978 = (i__18399__auto___25977 + (1));
i__18399__auto___25977 = G__25978;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"GET",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.GET.cljs$lang$maxFixedArity = (1);

ajax.core.GET.cljs$lang$applyTo = (function (seq25974){
var G__25975 = cljs.core.first.call(null,seq25974);
var seq25974__$1 = cljs.core.next.call(null,seq25974);
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic(G__25975,seq25974__$1);
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.HEAD = (function ajax$core$HEAD(){
var args__18405__auto__ = [];
var len__18398__auto___25981 = arguments.length;
var i__18399__auto___25982 = (0);
while(true){
if((i__18399__auto___25982 < len__18398__auto___25981)){
args__18405__auto__.push((arguments[i__18399__auto___25982]));

var G__25983 = (i__18399__auto___25982 + (1));
i__18399__auto___25982 = G__25983;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.HEAD.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.HEAD.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"HEAD",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.HEAD.cljs$lang$maxFixedArity = (1);

ajax.core.HEAD.cljs$lang$applyTo = (function (seq25979){
var G__25980 = cljs.core.first.call(null,seq25979);
var seq25979__$1 = cljs.core.next.call(null,seq25979);
return ajax.core.HEAD.cljs$core$IFn$_invoke$arity$variadic(G__25980,seq25979__$1);
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.POST = (function ajax$core$POST(){
var args__18405__auto__ = [];
var len__18398__auto___25986 = arguments.length;
var i__18399__auto___25987 = (0);
while(true){
if((i__18399__auto___25987 < len__18398__auto___25986)){
args__18405__auto__.push((arguments[i__18399__auto___25987]));

var G__25988 = (i__18399__auto___25987 + (1));
i__18399__auto___25987 = G__25988;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.POST.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.POST.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"POST",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.POST.cljs$lang$maxFixedArity = (1);

ajax.core.POST.cljs$lang$applyTo = (function (seq25984){
var G__25985 = cljs.core.first.call(null,seq25984);
var seq25984__$1 = cljs.core.next.call(null,seq25984);
return ajax.core.POST.cljs$core$IFn$_invoke$arity$variadic(G__25985,seq25984__$1);
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.PUT = (function ajax$core$PUT(){
var args__18405__auto__ = [];
var len__18398__auto___25991 = arguments.length;
var i__18399__auto___25992 = (0);
while(true){
if((i__18399__auto___25992 < len__18398__auto___25991)){
args__18405__auto__.push((arguments[i__18399__auto___25992]));

var G__25993 = (i__18399__auto___25992 + (1));
i__18399__auto___25992 = G__25993;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"PUT",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.PUT.cljs$lang$maxFixedArity = (1);

ajax.core.PUT.cljs$lang$applyTo = (function (seq25989){
var G__25990 = cljs.core.first.call(null,seq25989);
var seq25989__$1 = cljs.core.next.call(null,seq25989);
return ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic(G__25990,seq25989__$1);
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.DELETE = (function ajax$core$DELETE(){
var args__18405__auto__ = [];
var len__18398__auto___25996 = arguments.length;
var i__18399__auto___25997 = (0);
while(true){
if((i__18399__auto___25997 < len__18398__auto___25996)){
args__18405__auto__.push((arguments[i__18399__auto___25997]));

var G__25998 = (i__18399__auto___25997 + (1));
i__18399__auto___25997 = G__25998;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.DELETE.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.DELETE.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"DELETE",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.DELETE.cljs$lang$maxFixedArity = (1);

ajax.core.DELETE.cljs$lang$applyTo = (function (seq25994){
var G__25995 = cljs.core.first.call(null,seq25994);
var seq25994__$1 = cljs.core.next.call(null,seq25994);
return ajax.core.DELETE.cljs$core$IFn$_invoke$arity$variadic(G__25995,seq25994__$1);
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.OPTIONS = (function ajax$core$OPTIONS(){
var args__18405__auto__ = [];
var len__18398__auto___26001 = arguments.length;
var i__18399__auto___26002 = (0);
while(true){
if((i__18399__auto___26002 < len__18398__auto___26001)){
args__18405__auto__.push((arguments[i__18399__auto___26002]));

var G__26003 = (i__18399__auto___26002 + (1));
i__18399__auto___26002 = G__26003;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.OPTIONS.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.OPTIONS.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"OPTIONS",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.OPTIONS.cljs$lang$maxFixedArity = (1);

ajax.core.OPTIONS.cljs$lang$applyTo = (function (seq25999){
var G__26000 = cljs.core.first.call(null,seq25999);
var seq25999__$1 = cljs.core.next.call(null,seq25999);
return ajax.core.OPTIONS.cljs$core$IFn$_invoke$arity$variadic(G__26000,seq25999__$1);
});
/**
 * accepts the URI and an optional map of options, options include:
 * :handler - the handler function for successful operation
 * should accept a single parameter which is the
 * deserialized response
 * :error-handler - the handler function for errors, should accept a
 * map with keys :status and :status-text
 * :format - the format for the request
 * :response-format - the format for the response
 * :params - a map of parameters that will be sent with the request
 */
ajax.core.TRACE = (function ajax$core$TRACE(){
var args__18405__auto__ = [];
var len__18398__auto___26006 = arguments.length;
var i__18399__auto___26007 = (0);
while(true){
if((i__18399__auto___26007 < len__18398__auto___26006)){
args__18405__auto__.push((arguments[i__18399__auto___26007]));

var G__26008 = (i__18399__auto___26007 + (1));
i__18399__auto___26007 = G__26008;
continue;
} else {
}
break;
}

var argseq__18406__auto__ = ((((1) < args__18405__auto__.length))?(new cljs.core.IndexedSeq(args__18405__auto__.slice((1)),(0))):null);
return ajax.core.TRACE.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__18406__auto__);
});

ajax.core.TRACE.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__23623__auto__ = cljs.core.first.call(null,opts);
return ajax.core.easy_ajax_request.call(null,uri,"TRACE",(((f__23623__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__23623__auto__));
});

ajax.core.TRACE.cljs$lang$maxFixedArity = (1);

ajax.core.TRACE.cljs$lang$applyTo = (function (seq26004){
var G__26005 = cljs.core.first.call(null,seq26004);
var seq26004__$1 = cljs.core.next.call(null,seq26004);
return ajax.core.TRACE.cljs$core$IFn$_invoke$arity$variadic(G__26005,seq26004__$1);
});

//# sourceMappingURL=core.js.map?rel=1439917869583