(ns toshtogo.scratch
  (:import (org.joda.time DateTime)
           (java.util UUID))
  (:require [clj-time.core :refer [now minus seconds minutes plus after?]]
            [midje.sweet :refer :all]
            [ring.adapter.jetty :refer [run-jetty]]
            [clojure.java.jdbc :as sql]
            [clojure.pprint :refer [pprint]]
            [toshtogo.server.core :refer [dev-db]]
            [toshtogo.server.handler :refer [app]]
            [toshtogo.client.protocol :refer :all]
            [toshtogo.client.core :as ttc]
            [toshtogo.util.core :refer [uuid uuid-str debug cause-trace]]))

#_(
  (def in-process {:type :app :app (app dev-db)})
  (def localhost {:type :http :base-path "http://localhost:3000"})

  (def client-config in-process)
  (def client (ttc/client client-config
                          :error-fn (fn [e] (println (cause-trace e)))
                          :debug true
                          :system "client-test"
                          :version "0.0"))

  (defn return-success [job] (success {:result 1}))

  (defn ids-and-created-dates [client query]
    (->> (get-jobs client query)
         (:data)
         (map #(select-keys % [:job_created :job_id :job_type]))))

  (let [job-id-1 (uuid)
        job-id-2 (uuid)
        job-type (uuid-str)]

    (put-job! client job-id-1 (job-req {} job-type))
    (Thread/sleep 1)
    (put-job! client job-id-2 (job-req {} job-type))

    @(do-work! client job-type return-success)

    (println "A")
    (pprint (ids-and-created-dates client {:order-by [:job_created] :job_type job-type}))

    (println "B")
    (pprint (ids-and-created-dates client {:order-by [[:job_created :desc]] :job_type job-type}))
    ))

