(ns toshtogo.scratch
  (:import (org.joda.time DateTime)
           (java.util UUID))
  (:require [clj-time.core :refer [now minus seconds minutes plus after?]]
            [midje.sweet :refer :all]
            [ring.adapter.jetty :refer [run-jetty]]
            [clojure.java.jdbc :as sql]
            [toshtogo.server.core :refer [dev-db]]
            [toshtogo.server.handler :refer [app]]
            [toshtogo.client.protocol :refer :all]
            [toshtogo.client.core :as ttc]
            [toshtogo.util.core :refer [uuid uuid-str debug cause-trace]]))

(def in-process {:type :app :app (app dev-db)})
(def localhost {:type :http :base-path "http://localhost:3000"})

(def client-config in-process)
(def client (ttc/client client-config
                        :error-fn (fn [e] (println (cause-trace e)))
                        :debug true
                        :timeout 1000
                        :system "client-test"
                        :version "0.0"))



