(ns leiningen.new.sane-app
  (:require [leiningen.new.templates :refer [renderer name-to-path project-name sanitize-ns ->files]]
            [leiningen.core.main :as main]
            [clojure.string :as str]))

(def render (renderer "sane-app"))

(defn mirror [data path]
  (let [base-path (str/replace path #"\{\{.*\}\}/" "")]
    [path (render base-path data)]))

(defn sane-app
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :project-name (project-name name)
              :project-ns (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' sane-app project.")
    (->files data
             ;;["src/clj/{{sanitized}}/core.clj" (render "src/clj/core.clj" data)]
             (mirror data ".gitignore")
             (mirror data "README.md")
             (mirror data "LICENSE")
             (mirror data "project.clj")
             (mirror data "src/clj/{{sanitized}}/core.clj")
             (mirror data "src/cljc/{{sanitized}}/util.cljc")
             (mirror data "env/dev/clj/{{sanitized}}/repl.clj")
             (mirror data "test/clj/{{sanitized}}/test.clj")
             )))
