// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__21394){
var map__21395 = p__21394;
var map__21395__$1 = cljs.core.__destructure_map.call(null,map__21395);
var m = map__21395__$1;
var n = cljs.core.get.call(null,map__21395__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__21395__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return [(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__21396_21424 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__21397_21425 = null;
var count__21398_21426 = (0);
var i__21399_21427 = (0);
while(true){
if((i__21399_21427 < count__21398_21426)){
var f_21428 = cljs.core._nth.call(null,chunk__21397_21425,i__21399_21427);
cljs.core.println.call(null,"  ",f_21428);


var G__21429 = seq__21396_21424;
var G__21430 = chunk__21397_21425;
var G__21431 = count__21398_21426;
var G__21432 = (i__21399_21427 + (1));
seq__21396_21424 = G__21429;
chunk__21397_21425 = G__21430;
count__21398_21426 = G__21431;
i__21399_21427 = G__21432;
continue;
} else {
var temp__5804__auto___21433 = cljs.core.seq.call(null,seq__21396_21424);
if(temp__5804__auto___21433){
var seq__21396_21434__$1 = temp__5804__auto___21433;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21396_21434__$1)){
var c__5568__auto___21435 = cljs.core.chunk_first.call(null,seq__21396_21434__$1);
var G__21436 = cljs.core.chunk_rest.call(null,seq__21396_21434__$1);
var G__21437 = c__5568__auto___21435;
var G__21438 = cljs.core.count.call(null,c__5568__auto___21435);
var G__21439 = (0);
seq__21396_21424 = G__21436;
chunk__21397_21425 = G__21437;
count__21398_21426 = G__21438;
i__21399_21427 = G__21439;
continue;
} else {
var f_21440 = cljs.core.first.call(null,seq__21396_21434__$1);
cljs.core.println.call(null,"  ",f_21440);


var G__21441 = cljs.core.next.call(null,seq__21396_21434__$1);
var G__21442 = null;
var G__21443 = (0);
var G__21444 = (0);
seq__21396_21424 = G__21441;
chunk__21397_21425 = G__21442;
count__21398_21426 = G__21443;
i__21399_21427 = G__21444;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_21445 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_21445);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_21445)))?cljs.core.second.call(null,arglists_21445):arglists_21445));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__21400_21446 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__21401_21447 = null;
var count__21402_21448 = (0);
var i__21403_21449 = (0);
while(true){
if((i__21403_21449 < count__21402_21448)){
var vec__21412_21450 = cljs.core._nth.call(null,chunk__21401_21447,i__21403_21449);
var name_21451 = cljs.core.nth.call(null,vec__21412_21450,(0),null);
var map__21415_21452 = cljs.core.nth.call(null,vec__21412_21450,(1),null);
var map__21415_21453__$1 = cljs.core.__destructure_map.call(null,map__21415_21452);
var doc_21454 = cljs.core.get.call(null,map__21415_21453__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_21455 = cljs.core.get.call(null,map__21415_21453__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_21451);

cljs.core.println.call(null," ",arglists_21455);

if(cljs.core.truth_(doc_21454)){
cljs.core.println.call(null," ",doc_21454);
} else {
}


var G__21456 = seq__21400_21446;
var G__21457 = chunk__21401_21447;
var G__21458 = count__21402_21448;
var G__21459 = (i__21403_21449 + (1));
seq__21400_21446 = G__21456;
chunk__21401_21447 = G__21457;
count__21402_21448 = G__21458;
i__21403_21449 = G__21459;
continue;
} else {
var temp__5804__auto___21460 = cljs.core.seq.call(null,seq__21400_21446);
if(temp__5804__auto___21460){
var seq__21400_21461__$1 = temp__5804__auto___21460;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21400_21461__$1)){
var c__5568__auto___21462 = cljs.core.chunk_first.call(null,seq__21400_21461__$1);
var G__21463 = cljs.core.chunk_rest.call(null,seq__21400_21461__$1);
var G__21464 = c__5568__auto___21462;
var G__21465 = cljs.core.count.call(null,c__5568__auto___21462);
var G__21466 = (0);
seq__21400_21446 = G__21463;
chunk__21401_21447 = G__21464;
count__21402_21448 = G__21465;
i__21403_21449 = G__21466;
continue;
} else {
var vec__21416_21467 = cljs.core.first.call(null,seq__21400_21461__$1);
var name_21468 = cljs.core.nth.call(null,vec__21416_21467,(0),null);
var map__21419_21469 = cljs.core.nth.call(null,vec__21416_21467,(1),null);
var map__21419_21470__$1 = cljs.core.__destructure_map.call(null,map__21419_21469);
var doc_21471 = cljs.core.get.call(null,map__21419_21470__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_21472 = cljs.core.get.call(null,map__21419_21470__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_21468);

cljs.core.println.call(null," ",arglists_21472);

if(cljs.core.truth_(doc_21471)){
cljs.core.println.call(null," ",doc_21471);
} else {
}


var G__21473 = cljs.core.next.call(null,seq__21400_21461__$1);
var G__21474 = null;
var G__21475 = (0);
var G__21476 = (0);
seq__21400_21446 = G__21473;
chunk__21401_21447 = G__21474;
count__21402_21448 = G__21475;
i__21403_21449 = G__21476;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5804__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5804__auto__)){
var fnspec = temp__5804__auto__;
cljs.core.print.call(null,"Spec");

var seq__21420 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__21421 = null;
var count__21422 = (0);
var i__21423 = (0);
while(true){
if((i__21423 < count__21422)){
var role = cljs.core._nth.call(null,chunk__21421,i__21423);
var temp__5804__auto___21477__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5804__auto___21477__$1)){
var spec_21478 = temp__5804__auto___21477__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_21478));
} else {
}


var G__21479 = seq__21420;
var G__21480 = chunk__21421;
var G__21481 = count__21422;
var G__21482 = (i__21423 + (1));
seq__21420 = G__21479;
chunk__21421 = G__21480;
count__21422 = G__21481;
i__21423 = G__21482;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__21420);
if(temp__5804__auto____$1){
var seq__21420__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21420__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__21420__$1);
var G__21483 = cljs.core.chunk_rest.call(null,seq__21420__$1);
var G__21484 = c__5568__auto__;
var G__21485 = cljs.core.count.call(null,c__5568__auto__);
var G__21486 = (0);
seq__21420 = G__21483;
chunk__21421 = G__21484;
count__21422 = G__21485;
i__21423 = G__21486;
continue;
} else {
var role = cljs.core.first.call(null,seq__21420__$1);
var temp__5804__auto___21487__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5804__auto___21487__$2)){
var spec_21488 = temp__5804__auto___21487__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_21488));
} else {
}


var G__21489 = cljs.core.next.call(null,seq__21420__$1);
var G__21490 = null;
var G__21491 = (0);
var G__21492 = (0);
seq__21420 = G__21489;
chunk__21421 = G__21490;
count__21422 = G__21491;
i__21423 = G__21492;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol("cljs.core","ExceptionInfo","cljs.core/ExceptionInfo",701839050,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5804__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5804__auto__)){
var msg = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5804__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5804__auto__)){
var ed = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__21493 = cljs.core.conj.call(null,via,t);
var G__21494 = cljs.core.ex_cause.call(null,t);
via = G__21493;
t = G__21494;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5804__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5804__auto__)){
var root_msg = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5804__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5804__auto__)){
var data = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5804__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5804__auto__)){
var phase = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__21497 = datafied_throwable;
var map__21497__$1 = cljs.core.__destructure_map.call(null,map__21497);
var via = cljs.core.get.call(null,map__21497__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__21497__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__21497__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__21498 = cljs.core.last.call(null,via);
var map__21498__$1 = cljs.core.__destructure_map.call(null,map__21498);
var type = cljs.core.get.call(null,map__21498__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__21498__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__21498__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__21499 = data;
var map__21499__$1 = cljs.core.__destructure_map.call(null,map__21499);
var problems = cljs.core.get.call(null,map__21499__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__21499__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__21499__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__21500 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__21500__$1 = cljs.core.__destructure_map.call(null,map__21500);
var top_data = map__21500__$1;
var source = cljs.core.get.call(null,map__21500__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__21501 = phase;
var G__21501__$1 = (((G__21501 instanceof cljs.core.Keyword))?G__21501.fqn:null);
switch (G__21501__$1) {
case "read-source":
var map__21502 = data;
var map__21502__$1 = cljs.core.__destructure_map.call(null,map__21502);
var line = cljs.core.get.call(null,map__21502__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__21502__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__21503 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__21503__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__21503,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__21503);
var G__21503__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__21503__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__21503__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__21503__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__21503__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__21504 = top_data;
var G__21504__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__21504,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__21504);
var G__21504__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__21504__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__21504__$1);
var G__21504__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__21504__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__21504__$2);
var G__21504__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__21504__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__21504__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__21504__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__21504__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__21505 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__21505,(0),null);
var method = cljs.core.nth.call(null,vec__21505,(1),null);
var file = cljs.core.nth.call(null,vec__21505,(2),null);
var line = cljs.core.nth.call(null,vec__21505,(3),null);
var G__21508 = top_data;
var G__21508__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__21508,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__21508);
var G__21508__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__21508__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__21508__$1);
var G__21508__$3 = (cljs.core.truth_((function (){var and__5043__auto__ = source__$1;
if(cljs.core.truth_(and__5043__auto__)){
return method;
} else {
return and__5043__auto__;
}
})())?cljs.core.assoc.call(null,G__21508__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__21508__$2);
var G__21508__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__21508__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__21508__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__21508__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__21508__$4;
}

break;
case "execution":
var vec__21509 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__21509,(0),null);
var method = cljs.core.nth.call(null,vec__21509,(1),null);
var file = cljs.core.nth.call(null,vec__21509,(2),null);
var line = cljs.core.nth.call(null,vec__21509,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__21496_SHARP_){
var or__5045__auto__ = (p1__21496_SHARP_ == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__21496_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return line;
}
})();
var G__21512 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__21512__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__21512,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__21512);
var G__21512__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__21512__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__21512__$1);
var G__21512__$3 = (cljs.core.truth_((function (){var or__5045__auto__ = fn;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = source__$1;
if(cljs.core.truth_(and__5043__auto__)){
return method;
} else {
return and__5043__auto__;
}
}
})())?cljs.core.assoc.call(null,G__21512__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__5045__auto__ = fn;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__21512__$2);
var G__21512__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__21512__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__21512__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__21512__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__21512__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21501__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__21516){
var map__21517 = p__21516;
var map__21517__$1 = cljs.core.__destructure_map.call(null,map__21517);
var triage_data = map__21517__$1;
var phase = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__21517__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__5045__auto__ = class$;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__21518 = phase;
var G__21518__$1 = (((G__21518 instanceof cljs.core.Keyword))?G__21518.fqn:null);
switch (G__21518__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__21519_21528 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__21520_21529 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__21521_21530 = true;
var _STAR_print_fn_STAR__temp_val__21522_21531 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__21521_21530);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__21522_21531);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__21514_SHARP_){
return cljs.core.dissoc.call(null,p1__21514_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__21520_21529);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__21519_21528);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__21523_21532 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__21524_21533 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__21525_21534 = true;
var _STAR_print_fn_STAR__temp_val__21526_21535 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__21525_21534);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__21526_21535);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__21515_SHARP_){
return cljs.core.dissoc.call(null,p1__21515_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__21524_21533);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__21523_21532);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21518__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map
