// Compiled by ClojureScript 1.11.4 {:optimizations :none}
goog.provide('same.core');
goog.require('cljs.core');
goog.require('same.compare');
goog.require('same.ish');
/**
 * Compare one or more values to an expected value, returning true if they are the same-ish.
 *   The values can be numbers:
 *   ```klipse
 *   (let [two (Math/pow (Math/sqrt 2) 2)]
 *  [(== 2 two) (ish? 2 two)])
 *   ```
 *   or data structures:
 *   ```klipse
 *   (ish? {:a 1 :b [1.99999999999999 3]}
 *      {:a 1.00000000000001 :b [2 3.0]})
 *   ```
 *   you can also compare more than one value to the expected value:
 *   ```klipse
 *   (ish? 1 1.0 0.99999999999999 1.00000000000001 1)
 *   ```
 */
same.core.ish_QMARK_ = (function same$core$ish_QMARK_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___8855 = arguments.length;
var i__4865__auto___8856 = (0);
while(true){
if((i__4865__auto___8856 < len__4864__auto___8855)){
args__4870__auto__.push((arguments[i__4865__auto___8856]));

var G__8857 = (i__4865__auto___8856 + (1));
i__4865__auto___8856 = G__8857;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return same.core.ish_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(same.core.ish_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (expected,actuals){
if(cljs.core.truth_(cljs.core.not_empty.call(null,actuals))){
} else {
throw (new Error("Assert failed: (not-empty actuals)"));
}

return cljs.core.every_QMARK_.call(null,cljs.core.partial.call(null,same.ish.ish,expected),actuals);
}));

(same.core.ish_QMARK_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(same.core.ish_QMARK_.cljs$lang$applyTo = (function (seq8853){
var G__8854 = cljs.core.first.call(null,seq8853);
var seq8853__$1 = cljs.core.next.call(null,seq8853);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8854,seq8853__$1);
}));

/**
 * Compare a numeric value to zero, returning true if close.
 *   ```klipse
 *   (zeroish? 0.0000000001
 *          :scale 1e6)
 *   ```
 */
same.core.zeroish_QMARK_ = (function same$core$zeroish_QMARK_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___8862 = arguments.length;
var i__4865__auto___8863 = (0);
while(true){
if((i__4865__auto___8863 < len__4864__auto___8862)){
args__4870__auto__.push((arguments[i__4865__auto___8863]));

var G__8864 = (i__4865__auto___8863 + (1));
i__4865__auto___8863 = G__8864;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return same.core.zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(same.core.zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__8860){
var map__8861 = p__8860;
var map__8861__$1 = cljs.core.__destructure_map.call(null,map__8861);
var scale = cljs.core.get.call(null,map__8861__$1,new cljs.core.Keyword(null,"scale","scale",-230427353),1000.0);
return same.compare.near_zero.call(null,val,scale);
}));

(same.core.zeroish_QMARK_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(same.core.zeroish_QMARK_.cljs$lang$applyTo = (function (seq8858){
var G__8859 = cljs.core.first.call(null,seq8858);
var seq8858__$1 = cljs.core.next.call(null,seq8858);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8859,seq8858__$1);
}));

/**
 * Compare a numeric value to zero, returning true if not close. Equivalent to `(not (zeroish? ...))`.
 *   ```klipse
 *   (not-zeroish? 3 :scale 1e6)
 *   ```
 */
same.core.not_zeroish_QMARK_ = (function same$core$not_zeroish_QMARK_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___8869 = arguments.length;
var i__4865__auto___8870 = (0);
while(true){
if((i__4865__auto___8870 < len__4864__auto___8869)){
args__4870__auto__.push((arguments[i__4865__auto___8870]));

var G__8871 = (i__4865__auto___8870 + (1));
i__4865__auto___8870 = G__8871;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return same.core.not_zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(same.core.not_zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__8867){
var map__8868 = p__8867;
var map__8868__$1 = cljs.core.__destructure_map.call(null,map__8868);
var scale = cljs.core.get.call(null,map__8868__$1,new cljs.core.Keyword(null,"scale","scale",-230427353),1000.0);
return (!(same.compare.near_zero.call(null,val,scale)));
}));

(same.core.not_zeroish_QMARK_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(same.core.not_zeroish_QMARK_.cljs$lang$applyTo = (function (seq8865){
var G__8866 = cljs.core.first.call(null,seq8865);
var seq8865__$1 = cljs.core.next.call(null,seq8865);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8866,seq8865__$1);
}));

/**
 * Set the default comparator.
 *   ```klipse
 *   (set-comparator! (compare-ulp 2.0 100))
 *   (ish? 0.1 (-> 2 Math/sqrt (Math/pow 2) (- 1.9)))
 *   ```
 */
same.core.set_comparator_BANG_ = (function same$core$set_comparator_BANG_(comparator){
(same.ish._STAR_comparator_STAR_ = comparator);

return null;
});
var ret__4913__auto___8876 = (function (){
/**
 * Temporarily replace the default comparator.
 *   ```klipse
 *   (with-comparator (compare-ulp 100.0 1e9)
 *  (ish? 1.0 0.9999999))
 *   ```
 *   ```klipse
 *   (with-comparator ==
 *  (ish? 1.0 0.9999999999999))
 *   ```
 */
same.core.with_comparator = (function same$core$with_comparator(var_args){
var args__4870__auto__ = [];
var len__4864__auto___8877 = arguments.length;
var i__4865__auto___8878 = (0);
while(true){
if((i__4865__auto___8878 < len__4864__auto___8877)){
args__4870__auto__.push((arguments[i__4865__auto___8878]));

var G__8879 = (i__4865__auto___8878 + (1));
i__4865__auto___8878 = G__8879;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return same.core.with_comparator.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(same.core.with_comparator.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,comparator,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("same.ish","*comparator*","same.ish/*comparator*",-1083476129,null),null,(1),null)),(new cljs.core.List(null,comparator,null,(1),null)))))),null,(1),null)),body)));
}));

(same.core.with_comparator.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(same.core.with_comparator.cljs$lang$applyTo = (function (seq8872){
var G__8873 = cljs.core.first.call(null,seq8872);
var seq8872__$1 = cljs.core.next.call(null,seq8872);
var G__8874 = cljs.core.first.call(null,seq8872__$1);
var seq8872__$2 = cljs.core.next.call(null,seq8872__$1);
var G__8875 = cljs.core.first.call(null,seq8872__$2);
var seq8872__$3 = cljs.core.next.call(null,seq8872__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8873,G__8874,G__8875,seq8872__$3);
}));

return null;
})()
;
(same.core.with_comparator.cljs$lang$macro = true);


//# sourceMappingURL=core.js.map
