/*
 * Decompiled with CFR 0.152.
 */
package com.saarthak.client;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.saarthak.config.CouchbaseConfig;

public class CouchbaseClient {
    private CouchbaseConfig config;
    private Cluster cluster;

    public CouchbaseClient(CouchbaseConfig couchbaseConfig) {
        this.config = couchbaseConfig;
        DefaultCouchbaseEnvironment couchbaseEnvironment = DefaultCouchbaseEnvironment.builder().build();
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)couchbaseEnvironment, couchbaseConfig.getNodes());
    }

    public void shutdown() {
        this.cluster.disconnect();
    }

    public JsonArray getNodes() {
        return (JsonArray)this.cluster.clusterManager(this.config.getUser(), this.config.getPassword()).info().raw().get("nodes");
    }

    public CouchbaseConfig getConfig() {
        return this.config;
    }

    public Cluster getCluster() {
        return this.cluster;
    }
}

