/*
 * Decompiled with CFR 0.152.
 */
package liqp.tags;

import java.util.HashMap;
import java.util.Map;
import liqp.LValue;
import liqp.nodes.LNode;
import liqp.tags.Assign;
import liqp.tags.Capture;
import liqp.tags.Case;
import liqp.tags.Comment;
import liqp.tags.Cycle;
import liqp.tags.For;
import liqp.tags.If;
import liqp.tags.Include;
import liqp.tags.Raw;
import liqp.tags.Tablerow;
import liqp.tags.Unless;

public abstract class Tag
extends LValue {
    private static final Map<String, Tag> TAGS = new HashMap<String, Tag>();
    public final String name;

    protected Tag() {
        this.name = this.getClass().getSimpleName().toLowerCase();
    }

    public Tag(String name) {
        this.name = name;
    }

    public static Tag getTag(String name) {
        Tag tag = TAGS.get(name);
        if (tag == null) {
            throw new RuntimeException("unknown tag: " + name);
        }
        return tag;
    }

    public static void registerTag(Tag tag) {
        TAGS.put(tag.name, tag);
    }

    public abstract Object render(Map<String, Object> var1, LNode ... var2);

    static {
        Tag.registerTag(new Assign());
        Tag.registerTag(new Case());
        Tag.registerTag(new Capture());
        Tag.registerTag(new Comment());
        Tag.registerTag(new Cycle());
        Tag.registerTag(new For());
        Tag.registerTag(new If());
        Tag.registerTag(new Include());
        Tag.registerTag(new Raw());
        Tag.registerTag(new Tablerow());
        Tag.registerTag(new Unless());
    }

    public static enum Statement {
        BREAK,
        CONTINUE;


        public String toString() {
            return "";
        }
    }
}

