/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.util.Collection;
import java.util.List;
import liqp.nodes.AtomNode;

public abstract class LValue {
    public static boolean areEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            double delta = ((Number)a).doubleValue() - ((Number)b).doubleValue();
            return Math.abs(delta) < 1.0E-11;
        }
        if (AtomNode.isEmpty(a) && b instanceof CharSequence) {
            return ((CharSequence)b).length() == 0;
        }
        if (AtomNode.isEmpty(b) && a instanceof CharSequence) {
            return ((CharSequence)a).length() == 0;
        }
        if (AtomNode.isEmpty(a) && b instanceof Collection) {
            return ((Collection)b).size() == 0;
        }
        if (AtomNode.isEmpty(b) && a instanceof Collection) {
            return ((Collection)a).size() == 0;
        }
        if (AtomNode.isEmpty(a) && b.getClass().isArray()) {
            return ((Object[])b).length == 0;
        }
        if (AtomNode.isEmpty(b) && a.getClass().isArray()) {
            return ((Object[])a).length == 0;
        }
        return a.equals(b);
    }

    public Object[] asArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Object[])value;
        }
        if (value instanceof List) {
            return ((List)value).toArray();
        }
        return new Object[]{value};
    }

    public boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public Number asNumber(Object value) throws NumberFormatException {
        if (value instanceof Number) {
            return (Number)value;
        }
        String str = String.valueOf(value);
        return str.matches("\\d+") ? (double)Long.valueOf(str).longValue() : Double.valueOf(str);
    }

    public String asString(Object value) {
        if (value == null) {
            return "";
        }
        if (!this.isArray(value)) {
            return String.valueOf(value);
        }
        Object[] array = this.asArray(value);
        StringBuilder builder = new StringBuilder();
        for (Object obj : array) {
            builder.append(this.asString(obj));
        }
        return builder.toString();
    }

    public boolean isArray(Object value) {
        return value != null && (value.getClass().isArray() || value instanceof List);
    }

    public boolean isInteger(Object value) {
        return value != null && (value instanceof Long || value instanceof Integer);
    }

    public boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return true;
        }
        if (String.valueOf(value).matches("\\d+")) {
            return true;
        }
        try {
            Double.parseDouble(String.valueOf(value));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isString(Object value) {
        return value != null && value instanceof CharSequence;
    }
}

