/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.httpkit.DynamicBytes;
import org.httpkit.HTTPException;
import org.httpkit.HttpMethod;
import org.httpkit.HttpUtils;
import org.httpkit.PriorityQueue;
import org.httpkit.ProtocolException;
import org.httpkit.client.HttpClientConfig;
import org.httpkit.client.IRespListener;
import org.httpkit.client.PersistentConn;
import org.httpkit.client.Request;
import org.httpkit.client.State;
import org.httpkit.client.TimeoutException;

public final class HttpClient
implements Runnable {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private final Queue<Request> pending = new ConcurrentLinkedQueue<Request>();
    private final PriorityQueue<Request> requests = new PriorityQueue();
    private final PriorityQueue<PersistentConn> keepalives = new PriorityQueue();
    private volatile boolean running = true;
    private final HttpClientConfig config;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
    private final Selector selector;

    public HttpClient(HttpClientConfig config) throws IOException {
        this.config = config;
        int id = ID.incrementAndGet();
        String name = "client-loop";
        if (id > 1) {
            name = name + "#" + id;
        }
        this.selector = Selector.open();
        Thread t = new Thread((Runnable)this, name);
        t.setDaemon(true);
        t.start();
    }

    private void clearTimeout(long now) {
        PersistentConn pc;
        Request r;
        while ((r = this.requests.peek()) != null && r.isTimeout(now)) {
            String msg = "connect timeout: ";
            if (r.isConnected) {
                msg = "read timeout: ";
            }
            r.finish(new TimeoutException(msg + r.timeOutMs + "ms"));
            if (r.key == null) continue;
            this.closeQuietly(r.key);
        }
        while ((pc = this.keepalives.peek()) != null && pc.isTimeout(now)) {
            this.closeQuietly(pc.key);
            this.keepalives.poll();
        }
    }

    private boolean cleanAndRetryIfBroken(SelectionKey key, Request req) {
        this.closeQuietly(key);
        this.keepalives.remove(key);
        if (req.isReuseConn && req.decoder.state == State.READ_INITIAL) {
            for (ByteBuffer b : req.request) {
                b.position(0);
            }
            req.isReuseConn = false;
            this.requests.remove(req);
            this.pending.offer(req);
            this.selector.wakeup();
            return true;
        }
        return false;
    }

    private void doRead(SelectionKey key, long now) {
        int read;
        Request req;
        block10: {
            req = (Request)key.attachment();
            SocketChannel ch = (SocketChannel)key.channel();
            this.buffer.clear();
            read = 0;
            try {
                read = ch.read(this.buffer);
            }
            catch (IOException e) {
                if (this.cleanAndRetryIfBroken(key, req)) break block10;
                req.finish(e);
            }
        }
        if (read == -1) {
            if (!this.cleanAndRetryIfBroken(key, req)) {
                req.finish();
            }
        } else if (read > 0) {
            req.onProgress(now);
            this.buffer.flip();
            try {
                if (req.decoder.decode(this.buffer) == State.ALL_READ) {
                    req.finish();
                    this.keepalives.offer(new PersistentConn(now + (long)this.config.keepalive, req.addr, key));
                }
            }
            catch (HTTPException e) {
                this.closeQuietly(key);
                req.finish(e);
            }
            catch (Exception e) {
                this.closeQuietly(key);
                req.finish(e);
                HttpUtils.printError("Should not happen!!", e);
            }
        }
    }

    private void closeQuietly(SelectionKey key) {
        try {
            key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doWrite(SelectionKey key) {
        block3: {
            Request req = (Request)key.attachment();
            SocketChannel ch = (SocketChannel)key.channel();
            try {
                ByteBuffer[] request = req.request;
                ch.write(request);
                if (!request[request.length - 1].hasRemaining()) {
                    key.interestOps(1);
                }
            }
            catch (IOException e) {
                if (this.cleanAndRetryIfBroken(key, req)) break block3;
                req.finish(e);
            }
        }
    }

    public void exec(String url, HttpMethod method, Map<String, Object> headers, Object body, int timeoutMs, IRespListener cb) {
        ByteBuffer[] request;
        InetSocketAddress addr;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            cb.onThrowable(e);
            return;
        }
        if (!"http".equals(uri.getScheme())) {
            cb.onThrowable(new ProtocolException(uri.getScheme() + " is not supported"));
            return;
        }
        try {
            addr = HttpUtils.getServerAddr(uri);
        }
        catch (UnknownHostException e) {
            cb.onThrowable(e);
            return;
        }
        headers = HttpUtils.camelCase(headers);
        headers.put("Host", HttpUtils.getHost(uri));
        headers.put("Accept", "*/*");
        if (!headers.containsKey("User-Agent")) {
            headers.put("User-Agent", this.config.userAgent);
        }
        if (!headers.containsKey("Accept-Encoding")) {
            headers.put("Accept-Encoding", "gzip, deflate");
        }
        try {
            request = this.encode(method, headers, body, uri);
        }
        catch (IOException e) {
            cb.onThrowable(e);
            return;
        }
        if (timeoutMs == -1) {
            timeoutMs = this.config.timeOutMs;
        }
        this.pending.offer(new Request(addr, request, cb, this.requests, timeoutMs, method));
        this.selector.wakeup();
    }

    private ByteBuffer[] encode(HttpMethod method, Map<String, Object> headers, Object body, URI uri) throws IOException {
        ByteBuffer bodyBuffer = HttpUtils.bodyBuffer(body);
        if (body != null) {
            headers.put("Content-Length", Integer.toString(bodyBuffer.remaining()));
        } else {
            headers.put("Content-Length", "0");
        }
        DynamicBytes bytes = new DynamicBytes(196);
        bytes.append(method.toString()).append((byte)32).append(HttpUtils.getPath(uri));
        bytes.append(" HTTP/1.1\r\n");
        HttpUtils.encodeHeaders(bytes, headers);
        ByteBuffer headBuffer = ByteBuffer.wrap(bytes.get(), 0, bytes.length());
        if (bodyBuffer == null) {
            return new ByteBuffer[]{headBuffer};
        }
        return new ByteBuffer[]{headBuffer, bodyBuffer};
    }

    private void finishConnect(SelectionKey key, long now) {
        SocketChannel ch = (SocketChannel)key.channel();
        Request req = (Request)key.attachment();
        try {
            if (ch.finishConnect()) {
                req.isConnected = true;
                req.onProgress(now);
                key.interestOps(4);
            }
        }
        catch (IOException e) {
            this.closeQuietly(key);
            req.finish(e);
        }
    }

    private void processPending() {
        Request job = null;
        while ((job = this.pending.poll()) != null) {
            PersistentConn con = this.keepalives.remove(job.addr);
            if (con != null) {
                SelectionKey key = con.key;
                if (key.isValid()) {
                    job.isReuseConn = true;
                    key.attach(job);
                    key.interestOps(4);
                    this.requests.offer(job);
                    continue;
                }
                this.closeQuietly(key);
            }
            try {
                SocketChannel ch = SocketChannel.open();
                ch.configureBlocking(false);
                job.key = ch.register(this.selector, 8, job);
                ch.connect(job.addr);
                this.requests.offer(job);
            }
            catch (IOException e) {
                job.finish(e);
                HttpUtils.printError("Try to connect " + job.addr, e);
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                long now = System.currentTimeMillis();
                int select = this.selector.select(2000L);
                if (select > 0) {
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> ite = selectedKeys.iterator();
                    while (ite.hasNext()) {
                        SelectionKey key = ite.next();
                        if (!key.isValid()) continue;
                        if (key.isConnectable()) {
                            this.finishConnect(key, now);
                        } else if (key.isReadable()) {
                            this.doRead(key, now);
                        } else if (key.isWritable()) {
                            this.doWrite(key);
                        }
                        ite.remove();
                    }
                }
                this.clearTimeout(now);
                this.processPending();
            }
            catch (IOException e) {
                HttpUtils.printError("select exception", e);
            }
        }
    }

    public void stop() throws IOException {
        this.running = false;
        if (this.selector != null) {
            this.selector.close();
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + this.config.toString();
    }
}

