// Compiled by ClojureScript 1.9.854 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27953__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27953__auto__){
return or__27953__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27953__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
var or__27953__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__27953__auto____$1)){
return or__27953__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__44877_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__44877_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__44878 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__44879 = null;
var count__44880 = (0);
var i__44881 = (0);
while(true){
if((i__44881 < count__44880)){
var n = cljs.core._nth.call(null,chunk__44879,i__44881);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__44882 = seq__44878;
var G__44883 = chunk__44879;
var G__44884 = count__44880;
var G__44885 = (i__44881 + (1));
seq__44878 = G__44882;
chunk__44879 = G__44883;
count__44880 = G__44884;
i__44881 = G__44885;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__44878);
if(temp__4657__auto__){
var seq__44878__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44878__$1)){
var c__28787__auto__ = cljs.core.chunk_first.call(null,seq__44878__$1);
var G__44886 = cljs.core.chunk_rest.call(null,seq__44878__$1);
var G__44887 = c__28787__auto__;
var G__44888 = cljs.core.count.call(null,c__28787__auto__);
var G__44889 = (0);
seq__44878 = G__44886;
chunk__44879 = G__44887;
count__44880 = G__44888;
i__44881 = G__44889;
continue;
} else {
var n = cljs.core.first.call(null,seq__44878__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__44890 = cljs.core.next.call(null,seq__44878__$1);
var G__44891 = null;
var G__44892 = (0);
var G__44893 = (0);
seq__44878 = G__44890;
chunk__44879 = G__44891;
count__44880 = G__44892;
i__44881 = G__44893;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__44903_44911 = cljs.core.seq.call(null,deps);
var chunk__44904_44912 = null;
var count__44905_44913 = (0);
var i__44906_44914 = (0);
while(true){
if((i__44906_44914 < count__44905_44913)){
var dep_44915 = cljs.core._nth.call(null,chunk__44904_44912,i__44906_44914);
topo_sort_helper_STAR_.call(null,dep_44915,(depth + (1)),state);

var G__44916 = seq__44903_44911;
var G__44917 = chunk__44904_44912;
var G__44918 = count__44905_44913;
var G__44919 = (i__44906_44914 + (1));
seq__44903_44911 = G__44916;
chunk__44904_44912 = G__44917;
count__44905_44913 = G__44918;
i__44906_44914 = G__44919;
continue;
} else {
var temp__4657__auto___44920 = cljs.core.seq.call(null,seq__44903_44911);
if(temp__4657__auto___44920){
var seq__44903_44921__$1 = temp__4657__auto___44920;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44903_44921__$1)){
var c__28787__auto___44922 = cljs.core.chunk_first.call(null,seq__44903_44921__$1);
var G__44923 = cljs.core.chunk_rest.call(null,seq__44903_44921__$1);
var G__44924 = c__28787__auto___44922;
var G__44925 = cljs.core.count.call(null,c__28787__auto___44922);
var G__44926 = (0);
seq__44903_44911 = G__44923;
chunk__44904_44912 = G__44924;
count__44905_44913 = G__44925;
i__44906_44914 = G__44926;
continue;
} else {
var dep_44927 = cljs.core.first.call(null,seq__44903_44921__$1);
topo_sort_helper_STAR_.call(null,dep_44927,(depth + (1)),state);

var G__44928 = cljs.core.next.call(null,seq__44903_44921__$1);
var G__44929 = null;
var G__44930 = (0);
var G__44931 = (0);
seq__44903_44911 = G__44928;
chunk__44904_44912 = G__44929;
count__44905_44913 = G__44930;
i__44906_44914 = G__44931;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__44907){
var vec__44908 = p__44907;
var seq__44909 = cljs.core.seq.call(null,vec__44908);
var first__44910 = cljs.core.first.call(null,seq__44909);
var seq__44909__$1 = cljs.core.next.call(null,seq__44909);
var x = first__44910;
var xs = seq__44909__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__44908,seq__44909,first__44910,seq__44909__$1,x,xs,get_deps__$1){
return (function (p1__44894_SHARP_){
return clojure.set.difference.call(null,p1__44894_SHARP_,x);
});})(vec__44908,seq__44909,first__44910,seq__44909__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__44932 = cljs.core.seq.call(null,provides);
var chunk__44933 = null;
var count__44934 = (0);
var i__44935 = (0);
while(true){
if((i__44935 < count__44934)){
var prov = cljs.core._nth.call(null,chunk__44933,i__44935);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__44936_44944 = cljs.core.seq.call(null,requires);
var chunk__44937_44945 = null;
var count__44938_44946 = (0);
var i__44939_44947 = (0);
while(true){
if((i__44939_44947 < count__44938_44946)){
var req_44948 = cljs.core._nth.call(null,chunk__44937_44945,i__44939_44947);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_44948,prov);

var G__44949 = seq__44936_44944;
var G__44950 = chunk__44937_44945;
var G__44951 = count__44938_44946;
var G__44952 = (i__44939_44947 + (1));
seq__44936_44944 = G__44949;
chunk__44937_44945 = G__44950;
count__44938_44946 = G__44951;
i__44939_44947 = G__44952;
continue;
} else {
var temp__4657__auto___44953 = cljs.core.seq.call(null,seq__44936_44944);
if(temp__4657__auto___44953){
var seq__44936_44954__$1 = temp__4657__auto___44953;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44936_44954__$1)){
var c__28787__auto___44955 = cljs.core.chunk_first.call(null,seq__44936_44954__$1);
var G__44956 = cljs.core.chunk_rest.call(null,seq__44936_44954__$1);
var G__44957 = c__28787__auto___44955;
var G__44958 = cljs.core.count.call(null,c__28787__auto___44955);
var G__44959 = (0);
seq__44936_44944 = G__44956;
chunk__44937_44945 = G__44957;
count__44938_44946 = G__44958;
i__44939_44947 = G__44959;
continue;
} else {
var req_44960 = cljs.core.first.call(null,seq__44936_44954__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_44960,prov);

var G__44961 = cljs.core.next.call(null,seq__44936_44954__$1);
var G__44962 = null;
var G__44963 = (0);
var G__44964 = (0);
seq__44936_44944 = G__44961;
chunk__44937_44945 = G__44962;
count__44938_44946 = G__44963;
i__44939_44947 = G__44964;
continue;
}
} else {
}
}
break;
}

var G__44965 = seq__44932;
var G__44966 = chunk__44933;
var G__44967 = count__44934;
var G__44968 = (i__44935 + (1));
seq__44932 = G__44965;
chunk__44933 = G__44966;
count__44934 = G__44967;
i__44935 = G__44968;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__44932);
if(temp__4657__auto__){
var seq__44932__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44932__$1)){
var c__28787__auto__ = cljs.core.chunk_first.call(null,seq__44932__$1);
var G__44969 = cljs.core.chunk_rest.call(null,seq__44932__$1);
var G__44970 = c__28787__auto__;
var G__44971 = cljs.core.count.call(null,c__28787__auto__);
var G__44972 = (0);
seq__44932 = G__44969;
chunk__44933 = G__44970;
count__44934 = G__44971;
i__44935 = G__44972;
continue;
} else {
var prov = cljs.core.first.call(null,seq__44932__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__44940_44973 = cljs.core.seq.call(null,requires);
var chunk__44941_44974 = null;
var count__44942_44975 = (0);
var i__44943_44976 = (0);
while(true){
if((i__44943_44976 < count__44942_44975)){
var req_44977 = cljs.core._nth.call(null,chunk__44941_44974,i__44943_44976);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_44977,prov);

var G__44978 = seq__44940_44973;
var G__44979 = chunk__44941_44974;
var G__44980 = count__44942_44975;
var G__44981 = (i__44943_44976 + (1));
seq__44940_44973 = G__44978;
chunk__44941_44974 = G__44979;
count__44942_44975 = G__44980;
i__44943_44976 = G__44981;
continue;
} else {
var temp__4657__auto___44982__$1 = cljs.core.seq.call(null,seq__44940_44973);
if(temp__4657__auto___44982__$1){
var seq__44940_44983__$1 = temp__4657__auto___44982__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44940_44983__$1)){
var c__28787__auto___44984 = cljs.core.chunk_first.call(null,seq__44940_44983__$1);
var G__44985 = cljs.core.chunk_rest.call(null,seq__44940_44983__$1);
var G__44986 = c__28787__auto___44984;
var G__44987 = cljs.core.count.call(null,c__28787__auto___44984);
var G__44988 = (0);
seq__44940_44973 = G__44985;
chunk__44941_44974 = G__44986;
count__44942_44975 = G__44987;
i__44943_44976 = G__44988;
continue;
} else {
var req_44989 = cljs.core.first.call(null,seq__44940_44983__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_44989,prov);

var G__44990 = cljs.core.next.call(null,seq__44940_44983__$1);
var G__44991 = null;
var G__44992 = (0);
var G__44993 = (0);
seq__44940_44973 = G__44990;
chunk__44941_44974 = G__44991;
count__44942_44975 = G__44992;
i__44943_44976 = G__44993;
continue;
}
} else {
}
}
break;
}

var G__44994 = cljs.core.next.call(null,seq__44932__$1);
var G__44995 = null;
var G__44996 = (0);
var G__44997 = (0);
seq__44932 = G__44994;
chunk__44933 = G__44995;
count__44934 = G__44996;
i__44935 = G__44997;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__44998_45002 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__44999_45003 = null;
var count__45000_45004 = (0);
var i__45001_45005 = (0);
while(true){
if((i__45001_45005 < count__45000_45004)){
var ns_45006 = cljs.core._nth.call(null,chunk__44999_45003,i__45001_45005);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_45006);

var G__45007 = seq__44998_45002;
var G__45008 = chunk__44999_45003;
var G__45009 = count__45000_45004;
var G__45010 = (i__45001_45005 + (1));
seq__44998_45002 = G__45007;
chunk__44999_45003 = G__45008;
count__45000_45004 = G__45009;
i__45001_45005 = G__45010;
continue;
} else {
var temp__4657__auto___45011 = cljs.core.seq.call(null,seq__44998_45002);
if(temp__4657__auto___45011){
var seq__44998_45012__$1 = temp__4657__auto___45011;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44998_45012__$1)){
var c__28787__auto___45013 = cljs.core.chunk_first.call(null,seq__44998_45012__$1);
var G__45014 = cljs.core.chunk_rest.call(null,seq__44998_45012__$1);
var G__45015 = c__28787__auto___45013;
var G__45016 = cljs.core.count.call(null,c__28787__auto___45013);
var G__45017 = (0);
seq__44998_45002 = G__45014;
chunk__44999_45003 = G__45015;
count__45000_45004 = G__45016;
i__45001_45005 = G__45017;
continue;
} else {
var ns_45018 = cljs.core.first.call(null,seq__44998_45012__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_45018);

var G__45019 = cljs.core.next.call(null,seq__44998_45012__$1);
var G__45020 = null;
var G__45021 = (0);
var G__45022 = (0);
seq__44998_45002 = G__45019;
chunk__44999_45003 = G__45020;
count__45000_45004 = G__45021;
i__45001_45005 = G__45022;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27953__auto__ = goog.require__;
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__45023__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__45023 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__45024__i = 0, G__45024__a = new Array(arguments.length -  0);
while (G__45024__i < G__45024__a.length) {G__45024__a[G__45024__i] = arguments[G__45024__i + 0]; ++G__45024__i;}
  args = new cljs.core.IndexedSeq(G__45024__a,0,null);
} 
return G__45023__delegate.call(this,args);};
G__45023.cljs$lang$maxFixedArity = 0;
G__45023.cljs$lang$applyTo = (function (arglist__45025){
var args = cljs.core.seq(arglist__45025);
return G__45023__delegate(args);
});
G__45023.cljs$core$IFn$_invoke$arity$variadic = G__45023__delegate;
return G__45023;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__45026 = cljs.core._EQ_;
var expr__45027 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__45026.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__45027))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__45026,expr__45027){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__45026,expr__45027))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__45026,expr__45027){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e45029){if((e45029 instanceof Error)){
var e = e45029;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e45029;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__45026,expr__45027))
} else {
if(cljs.core.truth_(pred__45026.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__45027))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__45026.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__45027))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__45026.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__45027))){
return ((function (pred__45026,expr__45027){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e45030){if((e45030 instanceof Error)){
var e = e45030;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e45030;

}
}})());
});
;})(pred__45026,expr__45027))
} else {
return ((function (pred__45026,expr__45027){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__45026,expr__45027))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__45031,callback){
var map__45032 = p__45031;
var map__45032__$1 = ((((!((map__45032 == null)))?((((map__45032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45032.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45032):map__45032);
var file_msg = map__45032__$1;
var request_url = cljs.core.get.call(null,map__45032__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__45032,map__45032__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__45032,map__45032__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__){
return (function (state_45056){
var state_val_45057 = (state_45056[(1)]);
if((state_val_45057 === (7))){
var inst_45052 = (state_45056[(2)]);
var state_45056__$1 = state_45056;
var statearr_45058_45075 = state_45056__$1;
(statearr_45058_45075[(2)] = inst_45052);

(statearr_45058_45075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (1))){
var state_45056__$1 = state_45056;
var statearr_45059_45076 = state_45056__$1;
(statearr_45059_45076[(2)] = null);

(statearr_45059_45076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (4))){
var inst_45036 = (state_45056[(7)]);
var inst_45036__$1 = (state_45056[(2)]);
var state_45056__$1 = (function (){var statearr_45060 = state_45056;
(statearr_45060[(7)] = inst_45036__$1);

return statearr_45060;
})();
if(cljs.core.truth_(inst_45036__$1)){
var statearr_45061_45077 = state_45056__$1;
(statearr_45061_45077[(1)] = (5));

} else {
var statearr_45062_45078 = state_45056__$1;
(statearr_45062_45078[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (6))){
var state_45056__$1 = state_45056;
var statearr_45063_45079 = state_45056__$1;
(statearr_45063_45079[(2)] = null);

(statearr_45063_45079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (3))){
var inst_45054 = (state_45056[(2)]);
var state_45056__$1 = state_45056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45056__$1,inst_45054);
} else {
if((state_val_45057 === (2))){
var state_45056__$1 = state_45056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45056__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_45057 === (11))){
var inst_45048 = (state_45056[(2)]);
var state_45056__$1 = (function (){var statearr_45064 = state_45056;
(statearr_45064[(8)] = inst_45048);

return statearr_45064;
})();
var statearr_45065_45080 = state_45056__$1;
(statearr_45065_45080[(2)] = null);

(statearr_45065_45080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (9))){
var inst_45040 = (state_45056[(9)]);
var inst_45042 = (state_45056[(10)]);
var inst_45044 = inst_45042.call(null,inst_45040);
var state_45056__$1 = state_45056;
var statearr_45066_45081 = state_45056__$1;
(statearr_45066_45081[(2)] = inst_45044);

(statearr_45066_45081[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (5))){
var inst_45036 = (state_45056[(7)]);
var inst_45038 = figwheel.client.file_reloading.blocking_load.call(null,inst_45036);
var state_45056__$1 = state_45056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45056__$1,(8),inst_45038);
} else {
if((state_val_45057 === (10))){
var inst_45040 = (state_45056[(9)]);
var inst_45046 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_45040);
var state_45056__$1 = state_45056;
var statearr_45067_45082 = state_45056__$1;
(statearr_45067_45082[(2)] = inst_45046);

(statearr_45067_45082[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45057 === (8))){
var inst_45036 = (state_45056[(7)]);
var inst_45042 = (state_45056[(10)]);
var inst_45040 = (state_45056[(2)]);
var inst_45041 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_45042__$1 = cljs.core.get.call(null,inst_45041,inst_45036);
var state_45056__$1 = (function (){var statearr_45068 = state_45056;
(statearr_45068[(9)] = inst_45040);

(statearr_45068[(10)] = inst_45042__$1);

return statearr_45068;
})();
if(cljs.core.truth_(inst_45042__$1)){
var statearr_45069_45083 = state_45056__$1;
(statearr_45069_45083[(1)] = (9));

} else {
var statearr_45070_45084 = state_45056__$1;
(statearr_45070_45084[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__))
;
return ((function (switch__42662__auto__,c__42750__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__42663__auto__ = null;
var figwheel$client$file_reloading$state_machine__42663__auto____0 = (function (){
var statearr_45071 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45071[(0)] = figwheel$client$file_reloading$state_machine__42663__auto__);

(statearr_45071[(1)] = (1));

return statearr_45071;
});
var figwheel$client$file_reloading$state_machine__42663__auto____1 = (function (state_45056){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_45056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e45072){if((e45072 instanceof Object)){
var ex__42666__auto__ = e45072;
var statearr_45073_45085 = state_45056;
(statearr_45073_45085[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45072;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45086 = state_45056;
state_45056 = G__45086;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__42663__auto__ = function(state_45056){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__42663__auto____1.call(this,state_45056);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__42663__auto____0;
figwheel$client$file_reloading$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__42663__auto____1;
return figwheel$client$file_reloading$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__))
})();
var state__42752__auto__ = (function (){var statearr_45074 = f__42751__auto__.call(null);
(statearr_45074[(6)] = c__42750__auto__);

return statearr_45074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__))
);

return c__42750__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__45087,callback){
var map__45088 = p__45087;
var map__45088__$1 = ((((!((map__45088 == null)))?((((map__45088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45088):map__45088);
var file_msg = map__45088__$1;
var namespace = cljs.core.get.call(null,map__45088__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__45088,map__45088__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__45088,map__45088__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__45090){
var map__45091 = p__45090;
var map__45091__$1 = ((((!((map__45091 == null)))?((((map__45091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45091):map__45091);
var file_msg = map__45091__$1;
var namespace = cljs.core.get.call(null,map__45091__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__45093){
var map__45094 = p__45093;
var map__45094__$1 = ((((!((map__45094 == null)))?((((map__45094.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45094.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45094):map__45094);
var file_msg = map__45094__$1;
var namespace = cljs.core.get.call(null,map__45094__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27941__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__27941__auto__){
var or__27953__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
var or__27953__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27953__auto____$1)){
return or__27953__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27941__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__45096,callback){
var map__45097 = p__45096;
var map__45097__$1 = ((((!((map__45097 == null)))?((((map__45097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45097.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45097):map__45097);
var file_msg = map__45097__$1;
var request_url = cljs.core.get.call(null,map__45097__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__45097__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__42750__auto___45147 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___45147,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___45147,out){
return (function (state_45132){
var state_val_45133 = (state_45132[(1)]);
if((state_val_45133 === (1))){
var inst_45106 = cljs.core.seq.call(null,files);
var inst_45107 = cljs.core.first.call(null,inst_45106);
var inst_45108 = cljs.core.next.call(null,inst_45106);
var inst_45109 = files;
var state_45132__$1 = (function (){var statearr_45134 = state_45132;
(statearr_45134[(7)] = inst_45107);

(statearr_45134[(8)] = inst_45108);

(statearr_45134[(9)] = inst_45109);

return statearr_45134;
})();
var statearr_45135_45148 = state_45132__$1;
(statearr_45135_45148[(2)] = null);

(statearr_45135_45148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45133 === (2))){
var inst_45115 = (state_45132[(10)]);
var inst_45109 = (state_45132[(9)]);
var inst_45114 = cljs.core.seq.call(null,inst_45109);
var inst_45115__$1 = cljs.core.first.call(null,inst_45114);
var inst_45116 = cljs.core.next.call(null,inst_45114);
var inst_45117 = (inst_45115__$1 == null);
var inst_45118 = cljs.core.not.call(null,inst_45117);
var state_45132__$1 = (function (){var statearr_45136 = state_45132;
(statearr_45136[(10)] = inst_45115__$1);

(statearr_45136[(11)] = inst_45116);

return statearr_45136;
})();
if(inst_45118){
var statearr_45137_45149 = state_45132__$1;
(statearr_45137_45149[(1)] = (4));

} else {
var statearr_45138_45150 = state_45132__$1;
(statearr_45138_45150[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45133 === (3))){
var inst_45130 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45132__$1,inst_45130);
} else {
if((state_val_45133 === (4))){
var inst_45115 = (state_45132[(10)]);
var inst_45120 = figwheel.client.file_reloading.reload_js_file.call(null,inst_45115);
var state_45132__$1 = state_45132;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45132__$1,(7),inst_45120);
} else {
if((state_val_45133 === (5))){
var inst_45126 = cljs.core.async.close_BANG_.call(null,out);
var state_45132__$1 = state_45132;
var statearr_45139_45151 = state_45132__$1;
(statearr_45139_45151[(2)] = inst_45126);

(statearr_45139_45151[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45133 === (6))){
var inst_45128 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
var statearr_45140_45152 = state_45132__$1;
(statearr_45140_45152[(2)] = inst_45128);

(statearr_45140_45152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45133 === (7))){
var inst_45116 = (state_45132[(11)]);
var inst_45122 = (state_45132[(2)]);
var inst_45123 = cljs.core.async.put_BANG_.call(null,out,inst_45122);
var inst_45109 = inst_45116;
var state_45132__$1 = (function (){var statearr_45141 = state_45132;
(statearr_45141[(12)] = inst_45123);

(statearr_45141[(9)] = inst_45109);

return statearr_45141;
})();
var statearr_45142_45153 = state_45132__$1;
(statearr_45142_45153[(2)] = null);

(statearr_45142_45153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__42750__auto___45147,out))
;
return ((function (switch__42662__auto__,c__42750__auto___45147,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto____0 = (function (){
var statearr_45143 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45143[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto__);

(statearr_45143[(1)] = (1));

return statearr_45143;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto____1 = (function (state_45132){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_45132);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e45144){if((e45144 instanceof Object)){
var ex__42666__auto__ = e45144;
var statearr_45145_45154 = state_45132;
(statearr_45145_45154[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45132);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45144;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45155 = state_45132;
state_45132 = G__45155;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto__ = function(state_45132){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto____1.call(this,state_45132);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___45147,out))
})();
var state__42752__auto__ = (function (){var statearr_45146 = f__42751__auto__.call(null);
(statearr_45146[(6)] = c__42750__auto___45147);

return statearr_45146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___45147,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__45156,opts){
var map__45157 = p__45156;
var map__45157__$1 = ((((!((map__45157 == null)))?((((map__45157.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45157.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45157):map__45157);
var eval_body = cljs.core.get.call(null,map__45157__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__45157__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27941__auto__ = eval_body;
if(cljs.core.truth_(and__27941__auto__)){
return typeof eval_body === 'string';
} else {
return and__27941__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e45159){var e = e45159;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__45160_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__45160_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__45161){
var vec__45162 = p__45161;
var k = cljs.core.nth.call(null,vec__45162,(0),null);
var v = cljs.core.nth.call(null,vec__45162,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__45165){
var vec__45166 = p__45165;
var k = cljs.core.nth.call(null,vec__45166,(0),null);
var v = cljs.core.nth.call(null,vec__45166,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__45172,p__45173){
var map__45174 = p__45172;
var map__45174__$1 = ((((!((map__45174 == null)))?((((map__45174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45174.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45174):map__45174);
var opts = map__45174__$1;
var before_jsload = cljs.core.get.call(null,map__45174__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__45174__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__45174__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__45175 = p__45173;
var map__45175__$1 = ((((!((map__45175 == null)))?((((map__45175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45175):map__45175);
var msg = map__45175__$1;
var files = cljs.core.get.call(null,map__45175__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__45175__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__45175__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_45329){
var state_val_45330 = (state_45329[(1)]);
if((state_val_45330 === (7))){
var inst_45189 = (state_45329[(7)]);
var inst_45191 = (state_45329[(8)]);
var inst_45190 = (state_45329[(9)]);
var inst_45192 = (state_45329[(10)]);
var inst_45197 = cljs.core._nth.call(null,inst_45190,inst_45192);
var inst_45198 = figwheel.client.file_reloading.eval_body.call(null,inst_45197,opts);
var inst_45199 = (inst_45192 + (1));
var tmp45331 = inst_45189;
var tmp45332 = inst_45191;
var tmp45333 = inst_45190;
var inst_45189__$1 = tmp45331;
var inst_45190__$1 = tmp45333;
var inst_45191__$1 = tmp45332;
var inst_45192__$1 = inst_45199;
var state_45329__$1 = (function (){var statearr_45334 = state_45329;
(statearr_45334[(7)] = inst_45189__$1);

(statearr_45334[(11)] = inst_45198);

(statearr_45334[(8)] = inst_45191__$1);

(statearr_45334[(9)] = inst_45190__$1);

(statearr_45334[(10)] = inst_45192__$1);

return statearr_45334;
})();
var statearr_45335_45418 = state_45329__$1;
(statearr_45335_45418[(2)] = null);

(statearr_45335_45418[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (20))){
var inst_45232 = (state_45329[(12)]);
var inst_45240 = figwheel.client.file_reloading.sort_files.call(null,inst_45232);
var state_45329__$1 = state_45329;
var statearr_45336_45419 = state_45329__$1;
(statearr_45336_45419[(2)] = inst_45240);

(statearr_45336_45419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (27))){
var state_45329__$1 = state_45329;
var statearr_45337_45420 = state_45329__$1;
(statearr_45337_45420[(2)] = null);

(statearr_45337_45420[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (1))){
var inst_45181 = (state_45329[(13)]);
var inst_45178 = before_jsload.call(null,files);
var inst_45179 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_45180 = (function (){return ((function (inst_45181,inst_45178,inst_45179,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__45169_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__45169_SHARP_);
});
;})(inst_45181,inst_45178,inst_45179,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45181__$1 = cljs.core.filter.call(null,inst_45180,files);
var inst_45182 = cljs.core.not_empty.call(null,inst_45181__$1);
var state_45329__$1 = (function (){var statearr_45338 = state_45329;
(statearr_45338[(13)] = inst_45181__$1);

(statearr_45338[(14)] = inst_45178);

(statearr_45338[(15)] = inst_45179);

return statearr_45338;
})();
if(cljs.core.truth_(inst_45182)){
var statearr_45339_45421 = state_45329__$1;
(statearr_45339_45421[(1)] = (2));

} else {
var statearr_45340_45422 = state_45329__$1;
(statearr_45340_45422[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (24))){
var state_45329__$1 = state_45329;
var statearr_45341_45423 = state_45329__$1;
(statearr_45341_45423[(2)] = null);

(statearr_45341_45423[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (39))){
var inst_45282 = (state_45329[(16)]);
var state_45329__$1 = state_45329;
var statearr_45342_45424 = state_45329__$1;
(statearr_45342_45424[(2)] = inst_45282);

(statearr_45342_45424[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (46))){
var inst_45324 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45343_45425 = state_45329__$1;
(statearr_45343_45425[(2)] = inst_45324);

(statearr_45343_45425[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (4))){
var inst_45226 = (state_45329[(2)]);
var inst_45227 = cljs.core.List.EMPTY;
var inst_45228 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_45227);
var inst_45229 = (function (){return ((function (inst_45226,inst_45227,inst_45228,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__45170_SHARP_){
var and__27941__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__45170_SHARP_);
if(cljs.core.truth_(and__27941__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__45170_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__45170_SHARP_)));
} else {
return and__27941__auto__;
}
});
;})(inst_45226,inst_45227,inst_45228,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45230 = cljs.core.filter.call(null,inst_45229,files);
var inst_45231 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_45232 = cljs.core.concat.call(null,inst_45230,inst_45231);
var state_45329__$1 = (function (){var statearr_45344 = state_45329;
(statearr_45344[(17)] = inst_45228);

(statearr_45344[(18)] = inst_45226);

(statearr_45344[(12)] = inst_45232);

return statearr_45344;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_45345_45426 = state_45329__$1;
(statearr_45345_45426[(1)] = (16));

} else {
var statearr_45346_45427 = state_45329__$1;
(statearr_45346_45427[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (15))){
var inst_45216 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45347_45428 = state_45329__$1;
(statearr_45347_45428[(2)] = inst_45216);

(statearr_45347_45428[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (21))){
var inst_45242 = (state_45329[(19)]);
var inst_45242__$1 = (state_45329[(2)]);
var inst_45243 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_45242__$1);
var state_45329__$1 = (function (){var statearr_45348 = state_45329;
(statearr_45348[(19)] = inst_45242__$1);

return statearr_45348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45329__$1,(22),inst_45243);
} else {
if((state_val_45330 === (31))){
var inst_45327 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45329__$1,inst_45327);
} else {
if((state_val_45330 === (32))){
var inst_45282 = (state_45329[(16)]);
var inst_45287 = inst_45282.cljs$lang$protocol_mask$partition0$;
var inst_45288 = (inst_45287 & (64));
var inst_45289 = inst_45282.cljs$core$ISeq$;
var inst_45290 = (cljs.core.PROTOCOL_SENTINEL === inst_45289);
var inst_45291 = (inst_45288) || (inst_45290);
var state_45329__$1 = state_45329;
if(cljs.core.truth_(inst_45291)){
var statearr_45349_45429 = state_45329__$1;
(statearr_45349_45429[(1)] = (35));

} else {
var statearr_45350_45430 = state_45329__$1;
(statearr_45350_45430[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (40))){
var inst_45304 = (state_45329[(20)]);
var inst_45303 = (state_45329[(2)]);
var inst_45304__$1 = cljs.core.get.call(null,inst_45303,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_45305 = cljs.core.get.call(null,inst_45303,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_45306 = cljs.core.not_empty.call(null,inst_45304__$1);
var state_45329__$1 = (function (){var statearr_45351 = state_45329;
(statearr_45351[(21)] = inst_45305);

(statearr_45351[(20)] = inst_45304__$1);

return statearr_45351;
})();
if(cljs.core.truth_(inst_45306)){
var statearr_45352_45431 = state_45329__$1;
(statearr_45352_45431[(1)] = (41));

} else {
var statearr_45353_45432 = state_45329__$1;
(statearr_45353_45432[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (33))){
var state_45329__$1 = state_45329;
var statearr_45354_45433 = state_45329__$1;
(statearr_45354_45433[(2)] = false);

(statearr_45354_45433[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (13))){
var inst_45202 = (state_45329[(22)]);
var inst_45206 = cljs.core.chunk_first.call(null,inst_45202);
var inst_45207 = cljs.core.chunk_rest.call(null,inst_45202);
var inst_45208 = cljs.core.count.call(null,inst_45206);
var inst_45189 = inst_45207;
var inst_45190 = inst_45206;
var inst_45191 = inst_45208;
var inst_45192 = (0);
var state_45329__$1 = (function (){var statearr_45355 = state_45329;
(statearr_45355[(7)] = inst_45189);

(statearr_45355[(8)] = inst_45191);

(statearr_45355[(9)] = inst_45190);

(statearr_45355[(10)] = inst_45192);

return statearr_45355;
})();
var statearr_45356_45434 = state_45329__$1;
(statearr_45356_45434[(2)] = null);

(statearr_45356_45434[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (22))){
var inst_45246 = (state_45329[(23)]);
var inst_45242 = (state_45329[(19)]);
var inst_45245 = (state_45329[(24)]);
var inst_45250 = (state_45329[(25)]);
var inst_45245__$1 = (state_45329[(2)]);
var inst_45246__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_45245__$1);
var inst_45247 = (function (){var all_files = inst_45242;
var res_SINGLEQUOTE_ = inst_45245__$1;
var res = inst_45246__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_45246,inst_45242,inst_45245,inst_45250,inst_45245__$1,inst_45246__$1,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__45171_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__45171_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_45246,inst_45242,inst_45245,inst_45250,inst_45245__$1,inst_45246__$1,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45248 = cljs.core.filter.call(null,inst_45247,inst_45245__$1);
var inst_45249 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_45250__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_45249);
var inst_45251 = cljs.core.not_empty.call(null,inst_45250__$1);
var state_45329__$1 = (function (){var statearr_45357 = state_45329;
(statearr_45357[(23)] = inst_45246__$1);

(statearr_45357[(24)] = inst_45245__$1);

(statearr_45357[(25)] = inst_45250__$1);

(statearr_45357[(26)] = inst_45248);

return statearr_45357;
})();
if(cljs.core.truth_(inst_45251)){
var statearr_45358_45435 = state_45329__$1;
(statearr_45358_45435[(1)] = (23));

} else {
var statearr_45359_45436 = state_45329__$1;
(statearr_45359_45436[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (36))){
var state_45329__$1 = state_45329;
var statearr_45360_45437 = state_45329__$1;
(statearr_45360_45437[(2)] = false);

(statearr_45360_45437[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (41))){
var inst_45304 = (state_45329[(20)]);
var inst_45308 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_45309 = cljs.core.map.call(null,inst_45308,inst_45304);
var inst_45310 = cljs.core.pr_str.call(null,inst_45309);
var inst_45311 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45310)].join('');
var inst_45312 = figwheel.client.utils.log.call(null,inst_45311);
var state_45329__$1 = state_45329;
var statearr_45361_45438 = state_45329__$1;
(statearr_45361_45438[(2)] = inst_45312);

(statearr_45361_45438[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (43))){
var inst_45305 = (state_45329[(21)]);
var inst_45315 = (state_45329[(2)]);
var inst_45316 = cljs.core.not_empty.call(null,inst_45305);
var state_45329__$1 = (function (){var statearr_45362 = state_45329;
(statearr_45362[(27)] = inst_45315);

return statearr_45362;
})();
if(cljs.core.truth_(inst_45316)){
var statearr_45363_45439 = state_45329__$1;
(statearr_45363_45439[(1)] = (44));

} else {
var statearr_45364_45440 = state_45329__$1;
(statearr_45364_45440[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (29))){
var inst_45246 = (state_45329[(23)]);
var inst_45282 = (state_45329[(16)]);
var inst_45242 = (state_45329[(19)]);
var inst_45245 = (state_45329[(24)]);
var inst_45250 = (state_45329[(25)]);
var inst_45248 = (state_45329[(26)]);
var inst_45278 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_45281 = (function (){var all_files = inst_45242;
var res_SINGLEQUOTE_ = inst_45245;
var res = inst_45246;
var files_not_loaded = inst_45248;
var dependencies_that_loaded = inst_45250;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45282,inst_45242,inst_45245,inst_45250,inst_45248,inst_45278,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__45280){
var map__45365 = p__45280;
var map__45365__$1 = ((((!((map__45365 == null)))?((((map__45365.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45365.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45365):map__45365);
var namespace = cljs.core.get.call(null,map__45365__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45282,inst_45242,inst_45245,inst_45250,inst_45248,inst_45278,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45282__$1 = cljs.core.group_by.call(null,inst_45281,inst_45248);
var inst_45284 = (inst_45282__$1 == null);
var inst_45285 = cljs.core.not.call(null,inst_45284);
var state_45329__$1 = (function (){var statearr_45367 = state_45329;
(statearr_45367[(28)] = inst_45278);

(statearr_45367[(16)] = inst_45282__$1);

return statearr_45367;
})();
if(inst_45285){
var statearr_45368_45441 = state_45329__$1;
(statearr_45368_45441[(1)] = (32));

} else {
var statearr_45369_45442 = state_45329__$1;
(statearr_45369_45442[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (44))){
var inst_45305 = (state_45329[(21)]);
var inst_45318 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_45305);
var inst_45319 = cljs.core.pr_str.call(null,inst_45318);
var inst_45320 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45319)].join('');
var inst_45321 = figwheel.client.utils.log.call(null,inst_45320);
var state_45329__$1 = state_45329;
var statearr_45370_45443 = state_45329__$1;
(statearr_45370_45443[(2)] = inst_45321);

(statearr_45370_45443[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (6))){
var inst_45223 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45371_45444 = state_45329__$1;
(statearr_45371_45444[(2)] = inst_45223);

(statearr_45371_45444[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (28))){
var inst_45248 = (state_45329[(26)]);
var inst_45275 = (state_45329[(2)]);
var inst_45276 = cljs.core.not_empty.call(null,inst_45248);
var state_45329__$1 = (function (){var statearr_45372 = state_45329;
(statearr_45372[(29)] = inst_45275);

return statearr_45372;
})();
if(cljs.core.truth_(inst_45276)){
var statearr_45373_45445 = state_45329__$1;
(statearr_45373_45445[(1)] = (29));

} else {
var statearr_45374_45446 = state_45329__$1;
(statearr_45374_45446[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (25))){
var inst_45246 = (state_45329[(23)]);
var inst_45262 = (state_45329[(2)]);
var inst_45263 = cljs.core.not_empty.call(null,inst_45246);
var state_45329__$1 = (function (){var statearr_45375 = state_45329;
(statearr_45375[(30)] = inst_45262);

return statearr_45375;
})();
if(cljs.core.truth_(inst_45263)){
var statearr_45376_45447 = state_45329__$1;
(statearr_45376_45447[(1)] = (26));

} else {
var statearr_45377_45448 = state_45329__$1;
(statearr_45377_45448[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (34))){
var inst_45298 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
if(cljs.core.truth_(inst_45298)){
var statearr_45378_45449 = state_45329__$1;
(statearr_45378_45449[(1)] = (38));

} else {
var statearr_45379_45450 = state_45329__$1;
(statearr_45379_45450[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (17))){
var state_45329__$1 = state_45329;
var statearr_45380_45451 = state_45329__$1;
(statearr_45380_45451[(2)] = recompile_dependents);

(statearr_45380_45451[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (3))){
var state_45329__$1 = state_45329;
var statearr_45381_45452 = state_45329__$1;
(statearr_45381_45452[(2)] = null);

(statearr_45381_45452[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (12))){
var inst_45219 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45382_45453 = state_45329__$1;
(statearr_45382_45453[(2)] = inst_45219);

(statearr_45382_45453[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (2))){
var inst_45181 = (state_45329[(13)]);
var inst_45188 = cljs.core.seq.call(null,inst_45181);
var inst_45189 = inst_45188;
var inst_45190 = null;
var inst_45191 = (0);
var inst_45192 = (0);
var state_45329__$1 = (function (){var statearr_45383 = state_45329;
(statearr_45383[(7)] = inst_45189);

(statearr_45383[(8)] = inst_45191);

(statearr_45383[(9)] = inst_45190);

(statearr_45383[(10)] = inst_45192);

return statearr_45383;
})();
var statearr_45384_45454 = state_45329__$1;
(statearr_45384_45454[(2)] = null);

(statearr_45384_45454[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (23))){
var inst_45246 = (state_45329[(23)]);
var inst_45242 = (state_45329[(19)]);
var inst_45245 = (state_45329[(24)]);
var inst_45250 = (state_45329[(25)]);
var inst_45248 = (state_45329[(26)]);
var inst_45253 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_45255 = (function (){var all_files = inst_45242;
var res_SINGLEQUOTE_ = inst_45245;
var res = inst_45246;
var files_not_loaded = inst_45248;
var dependencies_that_loaded = inst_45250;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45242,inst_45245,inst_45250,inst_45248,inst_45253,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__45254){
var map__45385 = p__45254;
var map__45385__$1 = ((((!((map__45385 == null)))?((((map__45385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45385.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45385):map__45385);
var request_url = cljs.core.get.call(null,map__45385__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45242,inst_45245,inst_45250,inst_45248,inst_45253,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45256 = cljs.core.reverse.call(null,inst_45250);
var inst_45257 = cljs.core.map.call(null,inst_45255,inst_45256);
var inst_45258 = cljs.core.pr_str.call(null,inst_45257);
var inst_45259 = figwheel.client.utils.log.call(null,inst_45258);
var state_45329__$1 = (function (){var statearr_45387 = state_45329;
(statearr_45387[(31)] = inst_45253);

return statearr_45387;
})();
var statearr_45388_45455 = state_45329__$1;
(statearr_45388_45455[(2)] = inst_45259);

(statearr_45388_45455[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (35))){
var state_45329__$1 = state_45329;
var statearr_45389_45456 = state_45329__$1;
(statearr_45389_45456[(2)] = true);

(statearr_45389_45456[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (19))){
var inst_45232 = (state_45329[(12)]);
var inst_45238 = figwheel.client.file_reloading.expand_files.call(null,inst_45232);
var state_45329__$1 = state_45329;
var statearr_45390_45457 = state_45329__$1;
(statearr_45390_45457[(2)] = inst_45238);

(statearr_45390_45457[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (11))){
var state_45329__$1 = state_45329;
var statearr_45391_45458 = state_45329__$1;
(statearr_45391_45458[(2)] = null);

(statearr_45391_45458[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (9))){
var inst_45221 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45392_45459 = state_45329__$1;
(statearr_45392_45459[(2)] = inst_45221);

(statearr_45392_45459[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (5))){
var inst_45191 = (state_45329[(8)]);
var inst_45192 = (state_45329[(10)]);
var inst_45194 = (inst_45192 < inst_45191);
var inst_45195 = inst_45194;
var state_45329__$1 = state_45329;
if(cljs.core.truth_(inst_45195)){
var statearr_45393_45460 = state_45329__$1;
(statearr_45393_45460[(1)] = (7));

} else {
var statearr_45394_45461 = state_45329__$1;
(statearr_45394_45461[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (14))){
var inst_45202 = (state_45329[(22)]);
var inst_45211 = cljs.core.first.call(null,inst_45202);
var inst_45212 = figwheel.client.file_reloading.eval_body.call(null,inst_45211,opts);
var inst_45213 = cljs.core.next.call(null,inst_45202);
var inst_45189 = inst_45213;
var inst_45190 = null;
var inst_45191 = (0);
var inst_45192 = (0);
var state_45329__$1 = (function (){var statearr_45395 = state_45329;
(statearr_45395[(7)] = inst_45189);

(statearr_45395[(8)] = inst_45191);

(statearr_45395[(9)] = inst_45190);

(statearr_45395[(32)] = inst_45212);

(statearr_45395[(10)] = inst_45192);

return statearr_45395;
})();
var statearr_45396_45462 = state_45329__$1;
(statearr_45396_45462[(2)] = null);

(statearr_45396_45462[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (45))){
var state_45329__$1 = state_45329;
var statearr_45397_45463 = state_45329__$1;
(statearr_45397_45463[(2)] = null);

(statearr_45397_45463[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (26))){
var inst_45246 = (state_45329[(23)]);
var inst_45242 = (state_45329[(19)]);
var inst_45245 = (state_45329[(24)]);
var inst_45250 = (state_45329[(25)]);
var inst_45248 = (state_45329[(26)]);
var inst_45265 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_45267 = (function (){var all_files = inst_45242;
var res_SINGLEQUOTE_ = inst_45245;
var res = inst_45246;
var files_not_loaded = inst_45248;
var dependencies_that_loaded = inst_45250;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45242,inst_45245,inst_45250,inst_45248,inst_45265,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__45266){
var map__45398 = p__45266;
var map__45398__$1 = ((((!((map__45398 == null)))?((((map__45398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45398.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45398):map__45398);
var namespace = cljs.core.get.call(null,map__45398__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__45398__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45242,inst_45245,inst_45250,inst_45248,inst_45265,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45268 = cljs.core.map.call(null,inst_45267,inst_45246);
var inst_45269 = cljs.core.pr_str.call(null,inst_45268);
var inst_45270 = figwheel.client.utils.log.call(null,inst_45269);
var inst_45271 = (function (){var all_files = inst_45242;
var res_SINGLEQUOTE_ = inst_45245;
var res = inst_45246;
var files_not_loaded = inst_45248;
var dependencies_that_loaded = inst_45250;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45242,inst_45245,inst_45250,inst_45248,inst_45265,inst_45267,inst_45268,inst_45269,inst_45270,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_45246,inst_45242,inst_45245,inst_45250,inst_45248,inst_45265,inst_45267,inst_45268,inst_45269,inst_45270,state_val_45330,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_45272 = setTimeout(inst_45271,(10));
var state_45329__$1 = (function (){var statearr_45400 = state_45329;
(statearr_45400[(33)] = inst_45270);

(statearr_45400[(34)] = inst_45265);

return statearr_45400;
})();
var statearr_45401_45464 = state_45329__$1;
(statearr_45401_45464[(2)] = inst_45272);

(statearr_45401_45464[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (16))){
var state_45329__$1 = state_45329;
var statearr_45402_45465 = state_45329__$1;
(statearr_45402_45465[(2)] = reload_dependents);

(statearr_45402_45465[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (38))){
var inst_45282 = (state_45329[(16)]);
var inst_45300 = cljs.core.apply.call(null,cljs.core.hash_map,inst_45282);
var state_45329__$1 = state_45329;
var statearr_45403_45466 = state_45329__$1;
(statearr_45403_45466[(2)] = inst_45300);

(statearr_45403_45466[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (30))){
var state_45329__$1 = state_45329;
var statearr_45404_45467 = state_45329__$1;
(statearr_45404_45467[(2)] = null);

(statearr_45404_45467[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (10))){
var inst_45202 = (state_45329[(22)]);
var inst_45204 = cljs.core.chunked_seq_QMARK_.call(null,inst_45202);
var state_45329__$1 = state_45329;
if(inst_45204){
var statearr_45405_45468 = state_45329__$1;
(statearr_45405_45468[(1)] = (13));

} else {
var statearr_45406_45469 = state_45329__$1;
(statearr_45406_45469[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (18))){
var inst_45236 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
if(cljs.core.truth_(inst_45236)){
var statearr_45407_45470 = state_45329__$1;
(statearr_45407_45470[(1)] = (19));

} else {
var statearr_45408_45471 = state_45329__$1;
(statearr_45408_45471[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (42))){
var state_45329__$1 = state_45329;
var statearr_45409_45472 = state_45329__$1;
(statearr_45409_45472[(2)] = null);

(statearr_45409_45472[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (37))){
var inst_45295 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45410_45473 = state_45329__$1;
(statearr_45410_45473[(2)] = inst_45295);

(statearr_45410_45473[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (8))){
var inst_45189 = (state_45329[(7)]);
var inst_45202 = (state_45329[(22)]);
var inst_45202__$1 = cljs.core.seq.call(null,inst_45189);
var state_45329__$1 = (function (){var statearr_45411 = state_45329;
(statearr_45411[(22)] = inst_45202__$1);

return statearr_45411;
})();
if(inst_45202__$1){
var statearr_45412_45474 = state_45329__$1;
(statearr_45412_45474[(1)] = (10));

} else {
var statearr_45413_45475 = state_45329__$1;
(statearr_45413_45475[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__42662__auto__,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto____0 = (function (){
var statearr_45414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45414[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto__);

(statearr_45414[(1)] = (1));

return statearr_45414;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto____1 = (function (state_45329){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_45329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e45415){if((e45415 instanceof Object)){
var ex__42666__auto__ = e45415;
var statearr_45416_45476 = state_45329;
(statearr_45416_45476[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45415;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45477 = state_45329;
state_45329 = G__45477;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto__ = function(state_45329){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto____1.call(this,state_45329);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__42752__auto__ = (function (){var statearr_45417 = f__42751__auto__.call(null);
(statearr_45417[(6)] = c__42750__auto__);

return statearr_45417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__,map__45174,map__45174__$1,opts,before_jsload,on_jsload,reload_dependents,map__45175,map__45175__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__42750__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__45480,link){
var map__45481 = p__45480;
var map__45481__$1 = ((((!((map__45481 == null)))?((((map__45481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45481.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45481):map__45481);
var file = cljs.core.get.call(null,map__45481__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__45481,map__45481__$1,file){
return (function (p1__45478_SHARP_,p2__45479_SHARP_){
if(cljs.core._EQ_.call(null,p1__45478_SHARP_,p2__45479_SHARP_)){
return p1__45478_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__45481,map__45481__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__45484){
var map__45485 = p__45484;
var map__45485__$1 = ((((!((map__45485 == null)))?((((map__45485.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45485.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45485):map__45485);
var match_length = cljs.core.get.call(null,map__45485__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__45485__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__45483_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__45483_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__45487_SHARP_,p2__45488_SHARP_){
return cljs.core.assoc.call(null,p1__45487_SHARP_,cljs.core.get.call(null,p2__45488_SHARP_,key),p2__45488_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_45489 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_45489);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_45489);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__45490,p__45491){
var map__45492 = p__45490;
var map__45492__$1 = ((((!((map__45492 == null)))?((((map__45492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45492.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45492):map__45492);
var on_cssload = cljs.core.get.call(null,map__45492__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__45493 = p__45491;
var map__45493__$1 = ((((!((map__45493 == null)))?((((map__45493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45493.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45493):map__45493);
var files_msg = map__45493__$1;
var files = cljs.core.get.call(null,map__45493__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1503392487418
