// Compiled by ClojureScript 1.9.854 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42796 = arguments.length;
switch (G__42796) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async42797 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42797 = (function (f,blockable,meta42798){
this.f = f;
this.blockable = blockable;
this.meta42798 = meta42798;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42797.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42799,meta42798__$1){
var self__ = this;
var _42799__$1 = this;
return (new cljs.core.async.t_cljs$core$async42797(self__.f,self__.blockable,meta42798__$1));
});

cljs.core.async.t_cljs$core$async42797.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42799){
var self__ = this;
var _42799__$1 = this;
return self__.meta42798;
});

cljs.core.async.t_cljs$core$async42797.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42797.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async42797.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async42797.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async42797.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42798","meta42798",-455404325,null)], null);
});

cljs.core.async.t_cljs$core$async42797.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42797.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42797";

cljs.core.async.t_cljs$core$async42797.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async42797");
});

cljs.core.async.__GT_t_cljs$core$async42797 = (function cljs$core$async$__GT_t_cljs$core$async42797(f__$1,blockable__$1,meta42798){
return (new cljs.core.async.t_cljs$core$async42797(f__$1,blockable__$1,meta42798));
});

}

return (new cljs.core.async.t_cljs$core$async42797(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42803 = arguments.length;
switch (G__42803) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__42806 = arguments.length;
switch (G__42806) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__42809 = arguments.length;
switch (G__42809) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_42811 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_42811);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_42811,ret){
return (function (){
return fn1.call(null,val_42811);
});})(val_42811,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__42813 = arguments.length;
switch (G__42813) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28893__auto___42815 = n;
var x_42816 = (0);
while(true){
if((x_42816 < n__28893__auto___42815)){
(a[x_42816] = (0));

var G__42817 = (x_42816 + (1));
x_42816 = G__42817;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__42818 = (i + (1));
i = G__42818;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async42819 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42819 = (function (flag,meta42820){
this.flag = flag;
this.meta42820 = meta42820;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42819.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_42821,meta42820__$1){
var self__ = this;
var _42821__$1 = this;
return (new cljs.core.async.t_cljs$core$async42819(self__.flag,meta42820__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async42819.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_42821){
var self__ = this;
var _42821__$1 = this;
return self__.meta42820;
});})(flag))
;

cljs.core.async.t_cljs$core$async42819.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42819.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async42819.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async42819.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async42819.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42820","meta42820",-1787677015,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async42819.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42819.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42819";

cljs.core.async.t_cljs$core$async42819.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async42819");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async42819 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42819(flag__$1,meta42820){
return (new cljs.core.async.t_cljs$core$async42819(flag__$1,meta42820));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async42819(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async42822 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42822 = (function (flag,cb,meta42823){
this.flag = flag;
this.cb = cb;
this.meta42823 = meta42823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42824,meta42823__$1){
var self__ = this;
var _42824__$1 = this;
return (new cljs.core.async.t_cljs$core$async42822(self__.flag,self__.cb,meta42823__$1));
});

cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42824){
var self__ = this;
var _42824__$1 = this;
return self__.meta42823;
});

cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async42822.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async42822.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42823","meta42823",-1204862880,null)], null);
});

cljs.core.async.t_cljs$core$async42822.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42822.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42822";

cljs.core.async.t_cljs$core$async42822.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async42822");
});

cljs.core.async.__GT_t_cljs$core$async42822 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42822(flag__$1,cb__$1,meta42823){
return (new cljs.core.async.t_cljs$core$async42822(flag__$1,cb__$1,meta42823));
});

}

return (new cljs.core.async.t_cljs$core$async42822(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42825_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42825_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42826_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42826_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27953__auto__ = wport;
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return port;
}
})()], null));
} else {
var G__42827 = (i + (1));
i = G__42827;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27953__auto__ = ret;
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__27941__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27941__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27941__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29124__auto__ = [];
var len__29117__auto___42833 = arguments.length;
var i__29118__auto___42834 = (0);
while(true){
if((i__29118__auto___42834 < len__29117__auto___42833)){
args__29124__auto__.push((arguments[i__29118__auto___42834]));

var G__42835 = (i__29118__auto___42834 + (1));
i__29118__auto___42834 = G__42835;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((1) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29125__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__42830){
var map__42831 = p__42830;
var map__42831__$1 = ((((!((map__42831 == null)))?((((map__42831.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42831.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42831):map__42831);
var opts = map__42831__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq42828){
var G__42829 = cljs.core.first.call(null,seq42828);
var seq42828__$1 = cljs.core.next.call(null,seq42828);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42829,seq42828__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__42837 = arguments.length;
switch (G__42837) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42750__auto___42883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___42883){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___42883){
return (function (state_42861){
var state_val_42862 = (state_42861[(1)]);
if((state_val_42862 === (7))){
var inst_42857 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42863_42884 = state_42861__$1;
(statearr_42863_42884[(2)] = inst_42857);

(statearr_42863_42884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (1))){
var state_42861__$1 = state_42861;
var statearr_42864_42885 = state_42861__$1;
(statearr_42864_42885[(2)] = null);

(statearr_42864_42885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (4))){
var inst_42840 = (state_42861[(7)]);
var inst_42840__$1 = (state_42861[(2)]);
var inst_42841 = (inst_42840__$1 == null);
var state_42861__$1 = (function (){var statearr_42865 = state_42861;
(statearr_42865[(7)] = inst_42840__$1);

return statearr_42865;
})();
if(cljs.core.truth_(inst_42841)){
var statearr_42866_42886 = state_42861__$1;
(statearr_42866_42886[(1)] = (5));

} else {
var statearr_42867_42887 = state_42861__$1;
(statearr_42867_42887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (13))){
var state_42861__$1 = state_42861;
var statearr_42868_42888 = state_42861__$1;
(statearr_42868_42888[(2)] = null);

(statearr_42868_42888[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (6))){
var inst_42840 = (state_42861[(7)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42861__$1,(11),to,inst_42840);
} else {
if((state_val_42862 === (3))){
var inst_42859 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42861__$1,inst_42859);
} else {
if((state_val_42862 === (12))){
var state_42861__$1 = state_42861;
var statearr_42869_42889 = state_42861__$1;
(statearr_42869_42889[(2)] = null);

(statearr_42869_42889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (2))){
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42861__$1,(4),from);
} else {
if((state_val_42862 === (11))){
var inst_42850 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
if(cljs.core.truth_(inst_42850)){
var statearr_42870_42890 = state_42861__$1;
(statearr_42870_42890[(1)] = (12));

} else {
var statearr_42871_42891 = state_42861__$1;
(statearr_42871_42891[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (9))){
var state_42861__$1 = state_42861;
var statearr_42872_42892 = state_42861__$1;
(statearr_42872_42892[(2)] = null);

(statearr_42872_42892[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (5))){
var state_42861__$1 = state_42861;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42873_42893 = state_42861__$1;
(statearr_42873_42893[(1)] = (8));

} else {
var statearr_42874_42894 = state_42861__$1;
(statearr_42874_42894[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (14))){
var inst_42855 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42875_42895 = state_42861__$1;
(statearr_42875_42895[(2)] = inst_42855);

(statearr_42875_42895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (10))){
var inst_42847 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42876_42896 = state_42861__$1;
(statearr_42876_42896[(2)] = inst_42847);

(statearr_42876_42896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (8))){
var inst_42844 = cljs.core.async.close_BANG_.call(null,to);
var state_42861__$1 = state_42861;
var statearr_42877_42897 = state_42861__$1;
(statearr_42877_42897[(2)] = inst_42844);

(statearr_42877_42897[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___42883))
;
return ((function (switch__42662__auto__,c__42750__auto___42883){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_42878 = [null,null,null,null,null,null,null,null];
(statearr_42878[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_42878[(1)] = (1));

return statearr_42878;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_42861){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_42861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e42879){if((e42879 instanceof Object)){
var ex__42666__auto__ = e42879;
var statearr_42880_42898 = state_42861;
(statearr_42880_42898[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42899 = state_42861;
state_42861 = G__42899;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_42861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_42861);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___42883))
})();
var state__42752__auto__ = (function (){var statearr_42881 = f__42751__auto__.call(null);
(statearr_42881[(6)] = c__42750__auto___42883);

return statearr_42881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___42883))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__42900){
var vec__42901 = p__42900;
var v = cljs.core.nth.call(null,vec__42901,(0),null);
var p = cljs.core.nth.call(null,vec__42901,(1),null);
var job = vec__42901;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__42750__auto___43072 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___43072,res,vec__42901,v,p,job,jobs,results){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___43072,res,vec__42901,v,p,job,jobs,results){
return (function (state_42908){
var state_val_42909 = (state_42908[(1)]);
if((state_val_42909 === (1))){
var state_42908__$1 = state_42908;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42908__$1,(2),res,v);
} else {
if((state_val_42909 === (2))){
var inst_42905 = (state_42908[(2)]);
var inst_42906 = cljs.core.async.close_BANG_.call(null,res);
var state_42908__$1 = (function (){var statearr_42910 = state_42908;
(statearr_42910[(7)] = inst_42905);

return statearr_42910;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42908__$1,inst_42906);
} else {
return null;
}
}
});})(c__42750__auto___43072,res,vec__42901,v,p,job,jobs,results))
;
return ((function (switch__42662__auto__,c__42750__auto___43072,res,vec__42901,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0 = (function (){
var statearr_42911 = [null,null,null,null,null,null,null,null];
(statearr_42911[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__);

(statearr_42911[(1)] = (1));

return statearr_42911;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1 = (function (state_42908){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_42908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e42912){if((e42912 instanceof Object)){
var ex__42666__auto__ = e42912;
var statearr_42913_43073 = state_42908;
(statearr_42913_43073[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42908);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43074 = state_42908;
state_42908 = G__43074;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = function(state_42908){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1.call(this,state_42908);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___43072,res,vec__42901,v,p,job,jobs,results))
})();
var state__42752__auto__ = (function (){var statearr_42914 = f__42751__auto__.call(null);
(statearr_42914[(6)] = c__42750__auto___43072);

return statearr_42914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___43072,res,vec__42901,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__42915){
var vec__42916 = p__42915;
var v = cljs.core.nth.call(null,vec__42916,(0),null);
var p = cljs.core.nth.call(null,vec__42916,(1),null);
var job = vec__42916;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28893__auto___43075 = n;
var __43076 = (0);
while(true){
if((__43076 < n__28893__auto___43075)){
var G__42919_43077 = type;
var G__42919_43078__$1 = (((G__42919_43077 instanceof cljs.core.Keyword))?G__42919_43077.fqn:null);
switch (G__42919_43078__$1) {
case "compute":
var c__42750__auto___43080 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__43076,c__42750__auto___43080,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (__43076,c__42750__auto___43080,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async){
return (function (state_42932){
var state_val_42933 = (state_42932[(1)]);
if((state_val_42933 === (1))){
var state_42932__$1 = state_42932;
var statearr_42934_43081 = state_42932__$1;
(statearr_42934_43081[(2)] = null);

(statearr_42934_43081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42933 === (2))){
var state_42932__$1 = state_42932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42932__$1,(4),jobs);
} else {
if((state_val_42933 === (3))){
var inst_42930 = (state_42932[(2)]);
var state_42932__$1 = state_42932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42932__$1,inst_42930);
} else {
if((state_val_42933 === (4))){
var inst_42922 = (state_42932[(2)]);
var inst_42923 = process.call(null,inst_42922);
var state_42932__$1 = state_42932;
if(cljs.core.truth_(inst_42923)){
var statearr_42935_43082 = state_42932__$1;
(statearr_42935_43082[(1)] = (5));

} else {
var statearr_42936_43083 = state_42932__$1;
(statearr_42936_43083[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42933 === (5))){
var state_42932__$1 = state_42932;
var statearr_42937_43084 = state_42932__$1;
(statearr_42937_43084[(2)] = null);

(statearr_42937_43084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42933 === (6))){
var state_42932__$1 = state_42932;
var statearr_42938_43085 = state_42932__$1;
(statearr_42938_43085[(2)] = null);

(statearr_42938_43085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42933 === (7))){
var inst_42928 = (state_42932[(2)]);
var state_42932__$1 = state_42932;
var statearr_42939_43086 = state_42932__$1;
(statearr_42939_43086[(2)] = inst_42928);

(statearr_42939_43086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43076,c__42750__auto___43080,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async))
;
return ((function (__43076,switch__42662__auto__,c__42750__auto___43080,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0 = (function (){
var statearr_42940 = [null,null,null,null,null,null,null];
(statearr_42940[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__);

(statearr_42940[(1)] = (1));

return statearr_42940;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1 = (function (state_42932){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_42932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e42941){if((e42941 instanceof Object)){
var ex__42666__auto__ = e42941;
var statearr_42942_43087 = state_42932;
(statearr_42942_43087[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42941;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43088 = state_42932;
state_42932 = G__43088;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = function(state_42932){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1.call(this,state_42932);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__;
})()
;})(__43076,switch__42662__auto__,c__42750__auto___43080,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async))
})();
var state__42752__auto__ = (function (){var statearr_42943 = f__42751__auto__.call(null);
(statearr_42943[(6)] = c__42750__auto___43080);

return statearr_42943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(__43076,c__42750__auto___43080,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async))
);


break;
case "async":
var c__42750__auto___43089 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__43076,c__42750__auto___43089,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (__43076,c__42750__auto___43089,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async){
return (function (state_42956){
var state_val_42957 = (state_42956[(1)]);
if((state_val_42957 === (1))){
var state_42956__$1 = state_42956;
var statearr_42958_43090 = state_42956__$1;
(statearr_42958_43090[(2)] = null);

(statearr_42958_43090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42957 === (2))){
var state_42956__$1 = state_42956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42956__$1,(4),jobs);
} else {
if((state_val_42957 === (3))){
var inst_42954 = (state_42956[(2)]);
var state_42956__$1 = state_42956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42956__$1,inst_42954);
} else {
if((state_val_42957 === (4))){
var inst_42946 = (state_42956[(2)]);
var inst_42947 = async.call(null,inst_42946);
var state_42956__$1 = state_42956;
if(cljs.core.truth_(inst_42947)){
var statearr_42959_43091 = state_42956__$1;
(statearr_42959_43091[(1)] = (5));

} else {
var statearr_42960_43092 = state_42956__$1;
(statearr_42960_43092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42957 === (5))){
var state_42956__$1 = state_42956;
var statearr_42961_43093 = state_42956__$1;
(statearr_42961_43093[(2)] = null);

(statearr_42961_43093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42957 === (6))){
var state_42956__$1 = state_42956;
var statearr_42962_43094 = state_42956__$1;
(statearr_42962_43094[(2)] = null);

(statearr_42962_43094[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42957 === (7))){
var inst_42952 = (state_42956[(2)]);
var state_42956__$1 = state_42956;
var statearr_42963_43095 = state_42956__$1;
(statearr_42963_43095[(2)] = inst_42952);

(statearr_42963_43095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43076,c__42750__auto___43089,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async))
;
return ((function (__43076,switch__42662__auto__,c__42750__auto___43089,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0 = (function (){
var statearr_42964 = [null,null,null,null,null,null,null];
(statearr_42964[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__);

(statearr_42964[(1)] = (1));

return statearr_42964;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1 = (function (state_42956){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_42956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e42965){if((e42965 instanceof Object)){
var ex__42666__auto__ = e42965;
var statearr_42966_43096 = state_42956;
(statearr_42966_43096[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43097 = state_42956;
state_42956 = G__43097;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = function(state_42956){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1.call(this,state_42956);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__;
})()
;})(__43076,switch__42662__auto__,c__42750__auto___43089,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async))
})();
var state__42752__auto__ = (function (){var statearr_42967 = f__42751__auto__.call(null);
(statearr_42967[(6)] = c__42750__auto___43089);

return statearr_42967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(__43076,c__42750__auto___43089,G__42919_43077,G__42919_43078__$1,n__28893__auto___43075,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42919_43078__$1)].join('')));

}

var G__43098 = (__43076 + (1));
__43076 = G__43098;
continue;
} else {
}
break;
}

var c__42750__auto___43099 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___43099,jobs,results,process,async){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___43099,jobs,results,process,async){
return (function (state_42989){
var state_val_42990 = (state_42989[(1)]);
if((state_val_42990 === (1))){
var state_42989__$1 = state_42989;
var statearr_42991_43100 = state_42989__$1;
(statearr_42991_43100[(2)] = null);

(statearr_42991_43100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42990 === (2))){
var state_42989__$1 = state_42989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42989__$1,(4),from);
} else {
if((state_val_42990 === (3))){
var inst_42987 = (state_42989[(2)]);
var state_42989__$1 = state_42989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42989__$1,inst_42987);
} else {
if((state_val_42990 === (4))){
var inst_42970 = (state_42989[(7)]);
var inst_42970__$1 = (state_42989[(2)]);
var inst_42971 = (inst_42970__$1 == null);
var state_42989__$1 = (function (){var statearr_42992 = state_42989;
(statearr_42992[(7)] = inst_42970__$1);

return statearr_42992;
})();
if(cljs.core.truth_(inst_42971)){
var statearr_42993_43101 = state_42989__$1;
(statearr_42993_43101[(1)] = (5));

} else {
var statearr_42994_43102 = state_42989__$1;
(statearr_42994_43102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42990 === (5))){
var inst_42973 = cljs.core.async.close_BANG_.call(null,jobs);
var state_42989__$1 = state_42989;
var statearr_42995_43103 = state_42989__$1;
(statearr_42995_43103[(2)] = inst_42973);

(statearr_42995_43103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42990 === (6))){
var inst_42975 = (state_42989[(8)]);
var inst_42970 = (state_42989[(7)]);
var inst_42975__$1 = cljs.core.async.chan.call(null,(1));
var inst_42976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42977 = [inst_42970,inst_42975__$1];
var inst_42978 = (new cljs.core.PersistentVector(null,2,(5),inst_42976,inst_42977,null));
var state_42989__$1 = (function (){var statearr_42996 = state_42989;
(statearr_42996[(8)] = inst_42975__$1);

return statearr_42996;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42989__$1,(8),jobs,inst_42978);
} else {
if((state_val_42990 === (7))){
var inst_42985 = (state_42989[(2)]);
var state_42989__$1 = state_42989;
var statearr_42997_43104 = state_42989__$1;
(statearr_42997_43104[(2)] = inst_42985);

(statearr_42997_43104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42990 === (8))){
var inst_42975 = (state_42989[(8)]);
var inst_42980 = (state_42989[(2)]);
var state_42989__$1 = (function (){var statearr_42998 = state_42989;
(statearr_42998[(9)] = inst_42980);

return statearr_42998;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42989__$1,(9),results,inst_42975);
} else {
if((state_val_42990 === (9))){
var inst_42982 = (state_42989[(2)]);
var state_42989__$1 = (function (){var statearr_42999 = state_42989;
(statearr_42999[(10)] = inst_42982);

return statearr_42999;
})();
var statearr_43000_43105 = state_42989__$1;
(statearr_43000_43105[(2)] = null);

(statearr_43000_43105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___43099,jobs,results,process,async))
;
return ((function (switch__42662__auto__,c__42750__auto___43099,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0 = (function (){
var statearr_43001 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43001[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__);

(statearr_43001[(1)] = (1));

return statearr_43001;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1 = (function (state_42989){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_42989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43002){if((e43002 instanceof Object)){
var ex__42666__auto__ = e43002;
var statearr_43003_43106 = state_42989;
(statearr_43003_43106[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43002;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43107 = state_42989;
state_42989 = G__43107;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = function(state_42989){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1.call(this,state_42989);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___43099,jobs,results,process,async))
})();
var state__42752__auto__ = (function (){var statearr_43004 = f__42751__auto__.call(null);
(statearr_43004[(6)] = c__42750__auto___43099);

return statearr_43004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___43099,jobs,results,process,async))
);


var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__,jobs,results,process,async){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__,jobs,results,process,async){
return (function (state_43042){
var state_val_43043 = (state_43042[(1)]);
if((state_val_43043 === (7))){
var inst_43038 = (state_43042[(2)]);
var state_43042__$1 = state_43042;
var statearr_43044_43108 = state_43042__$1;
(statearr_43044_43108[(2)] = inst_43038);

(statearr_43044_43108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (20))){
var state_43042__$1 = state_43042;
var statearr_43045_43109 = state_43042__$1;
(statearr_43045_43109[(2)] = null);

(statearr_43045_43109[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (1))){
var state_43042__$1 = state_43042;
var statearr_43046_43110 = state_43042__$1;
(statearr_43046_43110[(2)] = null);

(statearr_43046_43110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (4))){
var inst_43007 = (state_43042[(7)]);
var inst_43007__$1 = (state_43042[(2)]);
var inst_43008 = (inst_43007__$1 == null);
var state_43042__$1 = (function (){var statearr_43047 = state_43042;
(statearr_43047[(7)] = inst_43007__$1);

return statearr_43047;
})();
if(cljs.core.truth_(inst_43008)){
var statearr_43048_43111 = state_43042__$1;
(statearr_43048_43111[(1)] = (5));

} else {
var statearr_43049_43112 = state_43042__$1;
(statearr_43049_43112[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (15))){
var inst_43020 = (state_43042[(8)]);
var state_43042__$1 = state_43042;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43042__$1,(18),to,inst_43020);
} else {
if((state_val_43043 === (21))){
var inst_43033 = (state_43042[(2)]);
var state_43042__$1 = state_43042;
var statearr_43050_43113 = state_43042__$1;
(statearr_43050_43113[(2)] = inst_43033);

(statearr_43050_43113[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (13))){
var inst_43035 = (state_43042[(2)]);
var state_43042__$1 = (function (){var statearr_43051 = state_43042;
(statearr_43051[(9)] = inst_43035);

return statearr_43051;
})();
var statearr_43052_43114 = state_43042__$1;
(statearr_43052_43114[(2)] = null);

(statearr_43052_43114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (6))){
var inst_43007 = (state_43042[(7)]);
var state_43042__$1 = state_43042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43042__$1,(11),inst_43007);
} else {
if((state_val_43043 === (17))){
var inst_43028 = (state_43042[(2)]);
var state_43042__$1 = state_43042;
if(cljs.core.truth_(inst_43028)){
var statearr_43053_43115 = state_43042__$1;
(statearr_43053_43115[(1)] = (19));

} else {
var statearr_43054_43116 = state_43042__$1;
(statearr_43054_43116[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (3))){
var inst_43040 = (state_43042[(2)]);
var state_43042__$1 = state_43042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43042__$1,inst_43040);
} else {
if((state_val_43043 === (12))){
var inst_43017 = (state_43042[(10)]);
var state_43042__$1 = state_43042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43042__$1,(14),inst_43017);
} else {
if((state_val_43043 === (2))){
var state_43042__$1 = state_43042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43042__$1,(4),results);
} else {
if((state_val_43043 === (19))){
var state_43042__$1 = state_43042;
var statearr_43055_43117 = state_43042__$1;
(statearr_43055_43117[(2)] = null);

(statearr_43055_43117[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (11))){
var inst_43017 = (state_43042[(2)]);
var state_43042__$1 = (function (){var statearr_43056 = state_43042;
(statearr_43056[(10)] = inst_43017);

return statearr_43056;
})();
var statearr_43057_43118 = state_43042__$1;
(statearr_43057_43118[(2)] = null);

(statearr_43057_43118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (9))){
var state_43042__$1 = state_43042;
var statearr_43058_43119 = state_43042__$1;
(statearr_43058_43119[(2)] = null);

(statearr_43058_43119[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (5))){
var state_43042__$1 = state_43042;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43059_43120 = state_43042__$1;
(statearr_43059_43120[(1)] = (8));

} else {
var statearr_43060_43121 = state_43042__$1;
(statearr_43060_43121[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (14))){
var inst_43020 = (state_43042[(8)]);
var inst_43022 = (state_43042[(11)]);
var inst_43020__$1 = (state_43042[(2)]);
var inst_43021 = (inst_43020__$1 == null);
var inst_43022__$1 = cljs.core.not.call(null,inst_43021);
var state_43042__$1 = (function (){var statearr_43061 = state_43042;
(statearr_43061[(8)] = inst_43020__$1);

(statearr_43061[(11)] = inst_43022__$1);

return statearr_43061;
})();
if(inst_43022__$1){
var statearr_43062_43122 = state_43042__$1;
(statearr_43062_43122[(1)] = (15));

} else {
var statearr_43063_43123 = state_43042__$1;
(statearr_43063_43123[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (16))){
var inst_43022 = (state_43042[(11)]);
var state_43042__$1 = state_43042;
var statearr_43064_43124 = state_43042__$1;
(statearr_43064_43124[(2)] = inst_43022);

(statearr_43064_43124[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (10))){
var inst_43014 = (state_43042[(2)]);
var state_43042__$1 = state_43042;
var statearr_43065_43125 = state_43042__$1;
(statearr_43065_43125[(2)] = inst_43014);

(statearr_43065_43125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (18))){
var inst_43025 = (state_43042[(2)]);
var state_43042__$1 = state_43042;
var statearr_43066_43126 = state_43042__$1;
(statearr_43066_43126[(2)] = inst_43025);

(statearr_43066_43126[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43043 === (8))){
var inst_43011 = cljs.core.async.close_BANG_.call(null,to);
var state_43042__$1 = state_43042;
var statearr_43067_43127 = state_43042__$1;
(statearr_43067_43127[(2)] = inst_43011);

(statearr_43067_43127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__,jobs,results,process,async))
;
return ((function (switch__42662__auto__,c__42750__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0 = (function (){
var statearr_43068 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43068[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__);

(statearr_43068[(1)] = (1));

return statearr_43068;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1 = (function (state_43042){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43069){if((e43069 instanceof Object)){
var ex__42666__auto__ = e43069;
var statearr_43070_43128 = state_43042;
(statearr_43070_43128[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43042);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43129 = state_43042;
state_43042 = G__43129;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__ = function(state_43042){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1.call(this,state_43042);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42663__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__,jobs,results,process,async))
})();
var state__42752__auto__ = (function (){var statearr_43071 = f__42751__auto__.call(null);
(statearr_43071[(6)] = c__42750__auto__);

return statearr_43071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__,jobs,results,process,async))
);

return c__42750__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__43131 = arguments.length;
switch (G__43131) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__43134 = arguments.length;
switch (G__43134) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__43137 = arguments.length;
switch (G__43137) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__42750__auto___43186 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___43186,tc,fc){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___43186,tc,fc){
return (function (state_43163){
var state_val_43164 = (state_43163[(1)]);
if((state_val_43164 === (7))){
var inst_43159 = (state_43163[(2)]);
var state_43163__$1 = state_43163;
var statearr_43165_43187 = state_43163__$1;
(statearr_43165_43187[(2)] = inst_43159);

(statearr_43165_43187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (1))){
var state_43163__$1 = state_43163;
var statearr_43166_43188 = state_43163__$1;
(statearr_43166_43188[(2)] = null);

(statearr_43166_43188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (4))){
var inst_43140 = (state_43163[(7)]);
var inst_43140__$1 = (state_43163[(2)]);
var inst_43141 = (inst_43140__$1 == null);
var state_43163__$1 = (function (){var statearr_43167 = state_43163;
(statearr_43167[(7)] = inst_43140__$1);

return statearr_43167;
})();
if(cljs.core.truth_(inst_43141)){
var statearr_43168_43189 = state_43163__$1;
(statearr_43168_43189[(1)] = (5));

} else {
var statearr_43169_43190 = state_43163__$1;
(statearr_43169_43190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (13))){
var state_43163__$1 = state_43163;
var statearr_43170_43191 = state_43163__$1;
(statearr_43170_43191[(2)] = null);

(statearr_43170_43191[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (6))){
var inst_43140 = (state_43163[(7)]);
var inst_43146 = p.call(null,inst_43140);
var state_43163__$1 = state_43163;
if(cljs.core.truth_(inst_43146)){
var statearr_43171_43192 = state_43163__$1;
(statearr_43171_43192[(1)] = (9));

} else {
var statearr_43172_43193 = state_43163__$1;
(statearr_43172_43193[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (3))){
var inst_43161 = (state_43163[(2)]);
var state_43163__$1 = state_43163;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43163__$1,inst_43161);
} else {
if((state_val_43164 === (12))){
var state_43163__$1 = state_43163;
var statearr_43173_43194 = state_43163__$1;
(statearr_43173_43194[(2)] = null);

(statearr_43173_43194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (2))){
var state_43163__$1 = state_43163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43163__$1,(4),ch);
} else {
if((state_val_43164 === (11))){
var inst_43140 = (state_43163[(7)]);
var inst_43150 = (state_43163[(2)]);
var state_43163__$1 = state_43163;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43163__$1,(8),inst_43150,inst_43140);
} else {
if((state_val_43164 === (9))){
var state_43163__$1 = state_43163;
var statearr_43174_43195 = state_43163__$1;
(statearr_43174_43195[(2)] = tc);

(statearr_43174_43195[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (5))){
var inst_43143 = cljs.core.async.close_BANG_.call(null,tc);
var inst_43144 = cljs.core.async.close_BANG_.call(null,fc);
var state_43163__$1 = (function (){var statearr_43175 = state_43163;
(statearr_43175[(8)] = inst_43143);

return statearr_43175;
})();
var statearr_43176_43196 = state_43163__$1;
(statearr_43176_43196[(2)] = inst_43144);

(statearr_43176_43196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (14))){
var inst_43157 = (state_43163[(2)]);
var state_43163__$1 = state_43163;
var statearr_43177_43197 = state_43163__$1;
(statearr_43177_43197[(2)] = inst_43157);

(statearr_43177_43197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (10))){
var state_43163__$1 = state_43163;
var statearr_43178_43198 = state_43163__$1;
(statearr_43178_43198[(2)] = fc);

(statearr_43178_43198[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43164 === (8))){
var inst_43152 = (state_43163[(2)]);
var state_43163__$1 = state_43163;
if(cljs.core.truth_(inst_43152)){
var statearr_43179_43199 = state_43163__$1;
(statearr_43179_43199[(1)] = (12));

} else {
var statearr_43180_43200 = state_43163__$1;
(statearr_43180_43200[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___43186,tc,fc))
;
return ((function (switch__42662__auto__,c__42750__auto___43186,tc,fc){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_43181 = [null,null,null,null,null,null,null,null,null];
(statearr_43181[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_43181[(1)] = (1));

return statearr_43181;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_43163){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43182){if((e43182 instanceof Object)){
var ex__42666__auto__ = e43182;
var statearr_43183_43201 = state_43163;
(statearr_43183_43201[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43182;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43202 = state_43163;
state_43163 = G__43202;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_43163){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_43163);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___43186,tc,fc))
})();
var state__42752__auto__ = (function (){var statearr_43184 = f__42751__auto__.call(null);
(statearr_43184[(6)] = c__42750__auto___43186);

return statearr_43184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___43186,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__){
return (function (state_43223){
var state_val_43224 = (state_43223[(1)]);
if((state_val_43224 === (7))){
var inst_43219 = (state_43223[(2)]);
var state_43223__$1 = state_43223;
var statearr_43225_43243 = state_43223__$1;
(statearr_43225_43243[(2)] = inst_43219);

(statearr_43225_43243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (1))){
var inst_43203 = init;
var state_43223__$1 = (function (){var statearr_43226 = state_43223;
(statearr_43226[(7)] = inst_43203);

return statearr_43226;
})();
var statearr_43227_43244 = state_43223__$1;
(statearr_43227_43244[(2)] = null);

(statearr_43227_43244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (4))){
var inst_43206 = (state_43223[(8)]);
var inst_43206__$1 = (state_43223[(2)]);
var inst_43207 = (inst_43206__$1 == null);
var state_43223__$1 = (function (){var statearr_43228 = state_43223;
(statearr_43228[(8)] = inst_43206__$1);

return statearr_43228;
})();
if(cljs.core.truth_(inst_43207)){
var statearr_43229_43245 = state_43223__$1;
(statearr_43229_43245[(1)] = (5));

} else {
var statearr_43230_43246 = state_43223__$1;
(statearr_43230_43246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (6))){
var inst_43203 = (state_43223[(7)]);
var inst_43210 = (state_43223[(9)]);
var inst_43206 = (state_43223[(8)]);
var inst_43210__$1 = f.call(null,inst_43203,inst_43206);
var inst_43211 = cljs.core.reduced_QMARK_.call(null,inst_43210__$1);
var state_43223__$1 = (function (){var statearr_43231 = state_43223;
(statearr_43231[(9)] = inst_43210__$1);

return statearr_43231;
})();
if(inst_43211){
var statearr_43232_43247 = state_43223__$1;
(statearr_43232_43247[(1)] = (8));

} else {
var statearr_43233_43248 = state_43223__$1;
(statearr_43233_43248[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (3))){
var inst_43221 = (state_43223[(2)]);
var state_43223__$1 = state_43223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43223__$1,inst_43221);
} else {
if((state_val_43224 === (2))){
var state_43223__$1 = state_43223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43223__$1,(4),ch);
} else {
if((state_val_43224 === (9))){
var inst_43210 = (state_43223[(9)]);
var inst_43203 = inst_43210;
var state_43223__$1 = (function (){var statearr_43234 = state_43223;
(statearr_43234[(7)] = inst_43203);

return statearr_43234;
})();
var statearr_43235_43249 = state_43223__$1;
(statearr_43235_43249[(2)] = null);

(statearr_43235_43249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (5))){
var inst_43203 = (state_43223[(7)]);
var state_43223__$1 = state_43223;
var statearr_43236_43250 = state_43223__$1;
(statearr_43236_43250[(2)] = inst_43203);

(statearr_43236_43250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (10))){
var inst_43217 = (state_43223[(2)]);
var state_43223__$1 = state_43223;
var statearr_43237_43251 = state_43223__$1;
(statearr_43237_43251[(2)] = inst_43217);

(statearr_43237_43251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43224 === (8))){
var inst_43210 = (state_43223[(9)]);
var inst_43213 = cljs.core.deref.call(null,inst_43210);
var state_43223__$1 = state_43223;
var statearr_43238_43252 = state_43223__$1;
(statearr_43238_43252[(2)] = inst_43213);

(statearr_43238_43252[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__))
;
return ((function (switch__42662__auto__,c__42750__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__42663__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42663__auto____0 = (function (){
var statearr_43239 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43239[(0)] = cljs$core$async$reduce_$_state_machine__42663__auto__);

(statearr_43239[(1)] = (1));

return statearr_43239;
});
var cljs$core$async$reduce_$_state_machine__42663__auto____1 = (function (state_43223){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43240){if((e43240 instanceof Object)){
var ex__42666__auto__ = e43240;
var statearr_43241_43253 = state_43223;
(statearr_43241_43253[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43240;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43254 = state_43223;
state_43223 = G__43254;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42663__auto__ = function(state_43223){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42663__auto____1.call(this,state_43223);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42663__auto____0;
cljs$core$async$reduce_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42663__auto____1;
return cljs$core$async$reduce_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__))
})();
var state__42752__auto__ = (function (){var statearr_43242 = f__42751__auto__.call(null);
(statearr_43242[(6)] = c__42750__auto__);

return statearr_43242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__))
);

return c__42750__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__,f__$1){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__,f__$1){
return (function (state_43260){
var state_val_43261 = (state_43260[(1)]);
if((state_val_43261 === (1))){
var inst_43255 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_43260__$1 = state_43260;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43260__$1,(2),inst_43255);
} else {
if((state_val_43261 === (2))){
var inst_43257 = (state_43260[(2)]);
var inst_43258 = f__$1.call(null,inst_43257);
var state_43260__$1 = state_43260;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43260__$1,inst_43258);
} else {
return null;
}
}
});})(c__42750__auto__,f__$1))
;
return ((function (switch__42662__auto__,c__42750__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__42663__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42663__auto____0 = (function (){
var statearr_43262 = [null,null,null,null,null,null,null];
(statearr_43262[(0)] = cljs$core$async$transduce_$_state_machine__42663__auto__);

(statearr_43262[(1)] = (1));

return statearr_43262;
});
var cljs$core$async$transduce_$_state_machine__42663__auto____1 = (function (state_43260){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43260);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43263){if((e43263 instanceof Object)){
var ex__42666__auto__ = e43263;
var statearr_43264_43266 = state_43260;
(statearr_43264_43266[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43260);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43267 = state_43260;
state_43260 = G__43267;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42663__auto__ = function(state_43260){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42663__auto____1.call(this,state_43260);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42663__auto____0;
cljs$core$async$transduce_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42663__auto____1;
return cljs$core$async$transduce_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__,f__$1))
})();
var state__42752__auto__ = (function (){var statearr_43265 = f__42751__auto__.call(null);
(statearr_43265[(6)] = c__42750__auto__);

return statearr_43265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__,f__$1))
);

return c__42750__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__43269 = arguments.length;
switch (G__43269) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__){
return (function (state_43294){
var state_val_43295 = (state_43294[(1)]);
if((state_val_43295 === (7))){
var inst_43276 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
var statearr_43296_43317 = state_43294__$1;
(statearr_43296_43317[(2)] = inst_43276);

(statearr_43296_43317[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (1))){
var inst_43270 = cljs.core.seq.call(null,coll);
var inst_43271 = inst_43270;
var state_43294__$1 = (function (){var statearr_43297 = state_43294;
(statearr_43297[(7)] = inst_43271);

return statearr_43297;
})();
var statearr_43298_43318 = state_43294__$1;
(statearr_43298_43318[(2)] = null);

(statearr_43298_43318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (4))){
var inst_43271 = (state_43294[(7)]);
var inst_43274 = cljs.core.first.call(null,inst_43271);
var state_43294__$1 = state_43294;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43294__$1,(7),ch,inst_43274);
} else {
if((state_val_43295 === (13))){
var inst_43288 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
var statearr_43299_43319 = state_43294__$1;
(statearr_43299_43319[(2)] = inst_43288);

(statearr_43299_43319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (6))){
var inst_43279 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
if(cljs.core.truth_(inst_43279)){
var statearr_43300_43320 = state_43294__$1;
(statearr_43300_43320[(1)] = (8));

} else {
var statearr_43301_43321 = state_43294__$1;
(statearr_43301_43321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (3))){
var inst_43292 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43294__$1,inst_43292);
} else {
if((state_val_43295 === (12))){
var state_43294__$1 = state_43294;
var statearr_43302_43322 = state_43294__$1;
(statearr_43302_43322[(2)] = null);

(statearr_43302_43322[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (2))){
var inst_43271 = (state_43294[(7)]);
var state_43294__$1 = state_43294;
if(cljs.core.truth_(inst_43271)){
var statearr_43303_43323 = state_43294__$1;
(statearr_43303_43323[(1)] = (4));

} else {
var statearr_43304_43324 = state_43294__$1;
(statearr_43304_43324[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (11))){
var inst_43285 = cljs.core.async.close_BANG_.call(null,ch);
var state_43294__$1 = state_43294;
var statearr_43305_43325 = state_43294__$1;
(statearr_43305_43325[(2)] = inst_43285);

(statearr_43305_43325[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (9))){
var state_43294__$1 = state_43294;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43306_43326 = state_43294__$1;
(statearr_43306_43326[(1)] = (11));

} else {
var statearr_43307_43327 = state_43294__$1;
(statearr_43307_43327[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (5))){
var inst_43271 = (state_43294[(7)]);
var state_43294__$1 = state_43294;
var statearr_43308_43328 = state_43294__$1;
(statearr_43308_43328[(2)] = inst_43271);

(statearr_43308_43328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (10))){
var inst_43290 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
var statearr_43309_43329 = state_43294__$1;
(statearr_43309_43329[(2)] = inst_43290);

(statearr_43309_43329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43295 === (8))){
var inst_43271 = (state_43294[(7)]);
var inst_43281 = cljs.core.next.call(null,inst_43271);
var inst_43271__$1 = inst_43281;
var state_43294__$1 = (function (){var statearr_43310 = state_43294;
(statearr_43310[(7)] = inst_43271__$1);

return statearr_43310;
})();
var statearr_43311_43330 = state_43294__$1;
(statearr_43311_43330[(2)] = null);

(statearr_43311_43330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__))
;
return ((function (switch__42662__auto__,c__42750__auto__){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_43312 = [null,null,null,null,null,null,null,null];
(statearr_43312[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_43312[(1)] = (1));

return statearr_43312;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_43294){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43313){if((e43313 instanceof Object)){
var ex__42666__auto__ = e43313;
var statearr_43314_43331 = state_43294;
(statearr_43314_43331[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43313;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43332 = state_43294;
state_43294 = G__43332;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_43294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_43294);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__))
})();
var state__42752__auto__ = (function (){var statearr_43315 = f__42751__auto__.call(null);
(statearr_43315[(6)] = c__42750__auto__);

return statearr_43315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__))
);

return c__42750__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28636__auto__ = (((_ == null))?null:_);
var m__28637__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,_);
} else {
var m__28637__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28637__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m);
} else {
var m__28637__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async43333 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43333 = (function (ch,cs,meta43334){
this.ch = ch;
this.cs = cs;
this.meta43334 = meta43334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_43335,meta43334__$1){
var self__ = this;
var _43335__$1 = this;
return (new cljs.core.async.t_cljs$core$async43333(self__.ch,self__.cs,meta43334__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_43335){
var self__ = this;
var _43335__$1 = this;
return self__.meta43334;
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43334","meta43334",-1341038499,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async43333.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async43333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43333";

cljs.core.async.t_cljs$core$async43333.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async43333");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async43333 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async43333(ch__$1,cs__$1,meta43334){
return (new cljs.core.async.t_cljs$core$async43333(ch__$1,cs__$1,meta43334));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async43333(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__42750__auto___43555 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___43555,cs,m,dchan,dctr,done){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___43555,cs,m,dchan,dctr,done){
return (function (state_43470){
var state_val_43471 = (state_43470[(1)]);
if((state_val_43471 === (7))){
var inst_43466 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43472_43556 = state_43470__$1;
(statearr_43472_43556[(2)] = inst_43466);

(statearr_43472_43556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (20))){
var inst_43369 = (state_43470[(7)]);
var inst_43381 = cljs.core.first.call(null,inst_43369);
var inst_43382 = cljs.core.nth.call(null,inst_43381,(0),null);
var inst_43383 = cljs.core.nth.call(null,inst_43381,(1),null);
var state_43470__$1 = (function (){var statearr_43473 = state_43470;
(statearr_43473[(8)] = inst_43382);

return statearr_43473;
})();
if(cljs.core.truth_(inst_43383)){
var statearr_43474_43557 = state_43470__$1;
(statearr_43474_43557[(1)] = (22));

} else {
var statearr_43475_43558 = state_43470__$1;
(statearr_43475_43558[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (27))){
var inst_43413 = (state_43470[(9)]);
var inst_43338 = (state_43470[(10)]);
var inst_43418 = (state_43470[(11)]);
var inst_43411 = (state_43470[(12)]);
var inst_43418__$1 = cljs.core._nth.call(null,inst_43411,inst_43413);
var inst_43419 = cljs.core.async.put_BANG_.call(null,inst_43418__$1,inst_43338,done);
var state_43470__$1 = (function (){var statearr_43476 = state_43470;
(statearr_43476[(11)] = inst_43418__$1);

return statearr_43476;
})();
if(cljs.core.truth_(inst_43419)){
var statearr_43477_43559 = state_43470__$1;
(statearr_43477_43559[(1)] = (30));

} else {
var statearr_43478_43560 = state_43470__$1;
(statearr_43478_43560[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (1))){
var state_43470__$1 = state_43470;
var statearr_43479_43561 = state_43470__$1;
(statearr_43479_43561[(2)] = null);

(statearr_43479_43561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (24))){
var inst_43369 = (state_43470[(7)]);
var inst_43388 = (state_43470[(2)]);
var inst_43389 = cljs.core.next.call(null,inst_43369);
var inst_43347 = inst_43389;
var inst_43348 = null;
var inst_43349 = (0);
var inst_43350 = (0);
var state_43470__$1 = (function (){var statearr_43480 = state_43470;
(statearr_43480[(13)] = inst_43388);

(statearr_43480[(14)] = inst_43347);

(statearr_43480[(15)] = inst_43350);

(statearr_43480[(16)] = inst_43349);

(statearr_43480[(17)] = inst_43348);

return statearr_43480;
})();
var statearr_43481_43562 = state_43470__$1;
(statearr_43481_43562[(2)] = null);

(statearr_43481_43562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (39))){
var state_43470__$1 = state_43470;
var statearr_43485_43563 = state_43470__$1;
(statearr_43485_43563[(2)] = null);

(statearr_43485_43563[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (4))){
var inst_43338 = (state_43470[(10)]);
var inst_43338__$1 = (state_43470[(2)]);
var inst_43339 = (inst_43338__$1 == null);
var state_43470__$1 = (function (){var statearr_43486 = state_43470;
(statearr_43486[(10)] = inst_43338__$1);

return statearr_43486;
})();
if(cljs.core.truth_(inst_43339)){
var statearr_43487_43564 = state_43470__$1;
(statearr_43487_43564[(1)] = (5));

} else {
var statearr_43488_43565 = state_43470__$1;
(statearr_43488_43565[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (15))){
var inst_43347 = (state_43470[(14)]);
var inst_43350 = (state_43470[(15)]);
var inst_43349 = (state_43470[(16)]);
var inst_43348 = (state_43470[(17)]);
var inst_43365 = (state_43470[(2)]);
var inst_43366 = (inst_43350 + (1));
var tmp43482 = inst_43347;
var tmp43483 = inst_43349;
var tmp43484 = inst_43348;
var inst_43347__$1 = tmp43482;
var inst_43348__$1 = tmp43484;
var inst_43349__$1 = tmp43483;
var inst_43350__$1 = inst_43366;
var state_43470__$1 = (function (){var statearr_43489 = state_43470;
(statearr_43489[(18)] = inst_43365);

(statearr_43489[(14)] = inst_43347__$1);

(statearr_43489[(15)] = inst_43350__$1);

(statearr_43489[(16)] = inst_43349__$1);

(statearr_43489[(17)] = inst_43348__$1);

return statearr_43489;
})();
var statearr_43490_43566 = state_43470__$1;
(statearr_43490_43566[(2)] = null);

(statearr_43490_43566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (21))){
var inst_43392 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43494_43567 = state_43470__$1;
(statearr_43494_43567[(2)] = inst_43392);

(statearr_43494_43567[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (31))){
var inst_43418 = (state_43470[(11)]);
var inst_43422 = done.call(null,null);
var inst_43423 = cljs.core.async.untap_STAR_.call(null,m,inst_43418);
var state_43470__$1 = (function (){var statearr_43495 = state_43470;
(statearr_43495[(19)] = inst_43422);

return statearr_43495;
})();
var statearr_43496_43568 = state_43470__$1;
(statearr_43496_43568[(2)] = inst_43423);

(statearr_43496_43568[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (32))){
var inst_43413 = (state_43470[(9)]);
var inst_43410 = (state_43470[(20)]);
var inst_43412 = (state_43470[(21)]);
var inst_43411 = (state_43470[(12)]);
var inst_43425 = (state_43470[(2)]);
var inst_43426 = (inst_43413 + (1));
var tmp43491 = inst_43410;
var tmp43492 = inst_43412;
var tmp43493 = inst_43411;
var inst_43410__$1 = tmp43491;
var inst_43411__$1 = tmp43493;
var inst_43412__$1 = tmp43492;
var inst_43413__$1 = inst_43426;
var state_43470__$1 = (function (){var statearr_43497 = state_43470;
(statearr_43497[(9)] = inst_43413__$1);

(statearr_43497[(20)] = inst_43410__$1);

(statearr_43497[(22)] = inst_43425);

(statearr_43497[(21)] = inst_43412__$1);

(statearr_43497[(12)] = inst_43411__$1);

return statearr_43497;
})();
var statearr_43498_43569 = state_43470__$1;
(statearr_43498_43569[(2)] = null);

(statearr_43498_43569[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (40))){
var inst_43438 = (state_43470[(23)]);
var inst_43442 = done.call(null,null);
var inst_43443 = cljs.core.async.untap_STAR_.call(null,m,inst_43438);
var state_43470__$1 = (function (){var statearr_43499 = state_43470;
(statearr_43499[(24)] = inst_43442);

return statearr_43499;
})();
var statearr_43500_43570 = state_43470__$1;
(statearr_43500_43570[(2)] = inst_43443);

(statearr_43500_43570[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (33))){
var inst_43429 = (state_43470[(25)]);
var inst_43431 = cljs.core.chunked_seq_QMARK_.call(null,inst_43429);
var state_43470__$1 = state_43470;
if(inst_43431){
var statearr_43501_43571 = state_43470__$1;
(statearr_43501_43571[(1)] = (36));

} else {
var statearr_43502_43572 = state_43470__$1;
(statearr_43502_43572[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (13))){
var inst_43359 = (state_43470[(26)]);
var inst_43362 = cljs.core.async.close_BANG_.call(null,inst_43359);
var state_43470__$1 = state_43470;
var statearr_43503_43573 = state_43470__$1;
(statearr_43503_43573[(2)] = inst_43362);

(statearr_43503_43573[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (22))){
var inst_43382 = (state_43470[(8)]);
var inst_43385 = cljs.core.async.close_BANG_.call(null,inst_43382);
var state_43470__$1 = state_43470;
var statearr_43504_43574 = state_43470__$1;
(statearr_43504_43574[(2)] = inst_43385);

(statearr_43504_43574[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (36))){
var inst_43429 = (state_43470[(25)]);
var inst_43433 = cljs.core.chunk_first.call(null,inst_43429);
var inst_43434 = cljs.core.chunk_rest.call(null,inst_43429);
var inst_43435 = cljs.core.count.call(null,inst_43433);
var inst_43410 = inst_43434;
var inst_43411 = inst_43433;
var inst_43412 = inst_43435;
var inst_43413 = (0);
var state_43470__$1 = (function (){var statearr_43505 = state_43470;
(statearr_43505[(9)] = inst_43413);

(statearr_43505[(20)] = inst_43410);

(statearr_43505[(21)] = inst_43412);

(statearr_43505[(12)] = inst_43411);

return statearr_43505;
})();
var statearr_43506_43575 = state_43470__$1;
(statearr_43506_43575[(2)] = null);

(statearr_43506_43575[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (41))){
var inst_43429 = (state_43470[(25)]);
var inst_43445 = (state_43470[(2)]);
var inst_43446 = cljs.core.next.call(null,inst_43429);
var inst_43410 = inst_43446;
var inst_43411 = null;
var inst_43412 = (0);
var inst_43413 = (0);
var state_43470__$1 = (function (){var statearr_43507 = state_43470;
(statearr_43507[(9)] = inst_43413);

(statearr_43507[(20)] = inst_43410);

(statearr_43507[(27)] = inst_43445);

(statearr_43507[(21)] = inst_43412);

(statearr_43507[(12)] = inst_43411);

return statearr_43507;
})();
var statearr_43508_43576 = state_43470__$1;
(statearr_43508_43576[(2)] = null);

(statearr_43508_43576[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (43))){
var state_43470__$1 = state_43470;
var statearr_43509_43577 = state_43470__$1;
(statearr_43509_43577[(2)] = null);

(statearr_43509_43577[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (29))){
var inst_43454 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43510_43578 = state_43470__$1;
(statearr_43510_43578[(2)] = inst_43454);

(statearr_43510_43578[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (44))){
var inst_43463 = (state_43470[(2)]);
var state_43470__$1 = (function (){var statearr_43511 = state_43470;
(statearr_43511[(28)] = inst_43463);

return statearr_43511;
})();
var statearr_43512_43579 = state_43470__$1;
(statearr_43512_43579[(2)] = null);

(statearr_43512_43579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (6))){
var inst_43402 = (state_43470[(29)]);
var inst_43401 = cljs.core.deref.call(null,cs);
var inst_43402__$1 = cljs.core.keys.call(null,inst_43401);
var inst_43403 = cljs.core.count.call(null,inst_43402__$1);
var inst_43404 = cljs.core.reset_BANG_.call(null,dctr,inst_43403);
var inst_43409 = cljs.core.seq.call(null,inst_43402__$1);
var inst_43410 = inst_43409;
var inst_43411 = null;
var inst_43412 = (0);
var inst_43413 = (0);
var state_43470__$1 = (function (){var statearr_43513 = state_43470;
(statearr_43513[(9)] = inst_43413);

(statearr_43513[(20)] = inst_43410);

(statearr_43513[(29)] = inst_43402__$1);

(statearr_43513[(21)] = inst_43412);

(statearr_43513[(30)] = inst_43404);

(statearr_43513[(12)] = inst_43411);

return statearr_43513;
})();
var statearr_43514_43580 = state_43470__$1;
(statearr_43514_43580[(2)] = null);

(statearr_43514_43580[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (28))){
var inst_43410 = (state_43470[(20)]);
var inst_43429 = (state_43470[(25)]);
var inst_43429__$1 = cljs.core.seq.call(null,inst_43410);
var state_43470__$1 = (function (){var statearr_43515 = state_43470;
(statearr_43515[(25)] = inst_43429__$1);

return statearr_43515;
})();
if(inst_43429__$1){
var statearr_43516_43581 = state_43470__$1;
(statearr_43516_43581[(1)] = (33));

} else {
var statearr_43517_43582 = state_43470__$1;
(statearr_43517_43582[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (25))){
var inst_43413 = (state_43470[(9)]);
var inst_43412 = (state_43470[(21)]);
var inst_43415 = (inst_43413 < inst_43412);
var inst_43416 = inst_43415;
var state_43470__$1 = state_43470;
if(cljs.core.truth_(inst_43416)){
var statearr_43518_43583 = state_43470__$1;
(statearr_43518_43583[(1)] = (27));

} else {
var statearr_43519_43584 = state_43470__$1;
(statearr_43519_43584[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (34))){
var state_43470__$1 = state_43470;
var statearr_43520_43585 = state_43470__$1;
(statearr_43520_43585[(2)] = null);

(statearr_43520_43585[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (17))){
var state_43470__$1 = state_43470;
var statearr_43521_43586 = state_43470__$1;
(statearr_43521_43586[(2)] = null);

(statearr_43521_43586[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (3))){
var inst_43468 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43470__$1,inst_43468);
} else {
if((state_val_43471 === (12))){
var inst_43397 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43522_43587 = state_43470__$1;
(statearr_43522_43587[(2)] = inst_43397);

(statearr_43522_43587[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (2))){
var state_43470__$1 = state_43470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43470__$1,(4),ch);
} else {
if((state_val_43471 === (23))){
var state_43470__$1 = state_43470;
var statearr_43523_43588 = state_43470__$1;
(statearr_43523_43588[(2)] = null);

(statearr_43523_43588[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (35))){
var inst_43452 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43524_43589 = state_43470__$1;
(statearr_43524_43589[(2)] = inst_43452);

(statearr_43524_43589[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (19))){
var inst_43369 = (state_43470[(7)]);
var inst_43373 = cljs.core.chunk_first.call(null,inst_43369);
var inst_43374 = cljs.core.chunk_rest.call(null,inst_43369);
var inst_43375 = cljs.core.count.call(null,inst_43373);
var inst_43347 = inst_43374;
var inst_43348 = inst_43373;
var inst_43349 = inst_43375;
var inst_43350 = (0);
var state_43470__$1 = (function (){var statearr_43525 = state_43470;
(statearr_43525[(14)] = inst_43347);

(statearr_43525[(15)] = inst_43350);

(statearr_43525[(16)] = inst_43349);

(statearr_43525[(17)] = inst_43348);

return statearr_43525;
})();
var statearr_43526_43590 = state_43470__$1;
(statearr_43526_43590[(2)] = null);

(statearr_43526_43590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (11))){
var inst_43347 = (state_43470[(14)]);
var inst_43369 = (state_43470[(7)]);
var inst_43369__$1 = cljs.core.seq.call(null,inst_43347);
var state_43470__$1 = (function (){var statearr_43527 = state_43470;
(statearr_43527[(7)] = inst_43369__$1);

return statearr_43527;
})();
if(inst_43369__$1){
var statearr_43528_43591 = state_43470__$1;
(statearr_43528_43591[(1)] = (16));

} else {
var statearr_43529_43592 = state_43470__$1;
(statearr_43529_43592[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (9))){
var inst_43399 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43530_43593 = state_43470__$1;
(statearr_43530_43593[(2)] = inst_43399);

(statearr_43530_43593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (5))){
var inst_43345 = cljs.core.deref.call(null,cs);
var inst_43346 = cljs.core.seq.call(null,inst_43345);
var inst_43347 = inst_43346;
var inst_43348 = null;
var inst_43349 = (0);
var inst_43350 = (0);
var state_43470__$1 = (function (){var statearr_43531 = state_43470;
(statearr_43531[(14)] = inst_43347);

(statearr_43531[(15)] = inst_43350);

(statearr_43531[(16)] = inst_43349);

(statearr_43531[(17)] = inst_43348);

return statearr_43531;
})();
var statearr_43532_43594 = state_43470__$1;
(statearr_43532_43594[(2)] = null);

(statearr_43532_43594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (14))){
var state_43470__$1 = state_43470;
var statearr_43533_43595 = state_43470__$1;
(statearr_43533_43595[(2)] = null);

(statearr_43533_43595[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (45))){
var inst_43460 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43534_43596 = state_43470__$1;
(statearr_43534_43596[(2)] = inst_43460);

(statearr_43534_43596[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (26))){
var inst_43402 = (state_43470[(29)]);
var inst_43456 = (state_43470[(2)]);
var inst_43457 = cljs.core.seq.call(null,inst_43402);
var state_43470__$1 = (function (){var statearr_43535 = state_43470;
(statearr_43535[(31)] = inst_43456);

return statearr_43535;
})();
if(inst_43457){
var statearr_43536_43597 = state_43470__$1;
(statearr_43536_43597[(1)] = (42));

} else {
var statearr_43537_43598 = state_43470__$1;
(statearr_43537_43598[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (16))){
var inst_43369 = (state_43470[(7)]);
var inst_43371 = cljs.core.chunked_seq_QMARK_.call(null,inst_43369);
var state_43470__$1 = state_43470;
if(inst_43371){
var statearr_43538_43599 = state_43470__$1;
(statearr_43538_43599[(1)] = (19));

} else {
var statearr_43539_43600 = state_43470__$1;
(statearr_43539_43600[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (38))){
var inst_43449 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43540_43601 = state_43470__$1;
(statearr_43540_43601[(2)] = inst_43449);

(statearr_43540_43601[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (30))){
var state_43470__$1 = state_43470;
var statearr_43541_43602 = state_43470__$1;
(statearr_43541_43602[(2)] = null);

(statearr_43541_43602[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (10))){
var inst_43350 = (state_43470[(15)]);
var inst_43348 = (state_43470[(17)]);
var inst_43358 = cljs.core._nth.call(null,inst_43348,inst_43350);
var inst_43359 = cljs.core.nth.call(null,inst_43358,(0),null);
var inst_43360 = cljs.core.nth.call(null,inst_43358,(1),null);
var state_43470__$1 = (function (){var statearr_43542 = state_43470;
(statearr_43542[(26)] = inst_43359);

return statearr_43542;
})();
if(cljs.core.truth_(inst_43360)){
var statearr_43543_43603 = state_43470__$1;
(statearr_43543_43603[(1)] = (13));

} else {
var statearr_43544_43604 = state_43470__$1;
(statearr_43544_43604[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (18))){
var inst_43395 = (state_43470[(2)]);
var state_43470__$1 = state_43470;
var statearr_43545_43605 = state_43470__$1;
(statearr_43545_43605[(2)] = inst_43395);

(statearr_43545_43605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (42))){
var state_43470__$1 = state_43470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43470__$1,(45),dchan);
} else {
if((state_val_43471 === (37))){
var inst_43338 = (state_43470[(10)]);
var inst_43438 = (state_43470[(23)]);
var inst_43429 = (state_43470[(25)]);
var inst_43438__$1 = cljs.core.first.call(null,inst_43429);
var inst_43439 = cljs.core.async.put_BANG_.call(null,inst_43438__$1,inst_43338,done);
var state_43470__$1 = (function (){var statearr_43546 = state_43470;
(statearr_43546[(23)] = inst_43438__$1);

return statearr_43546;
})();
if(cljs.core.truth_(inst_43439)){
var statearr_43547_43606 = state_43470__$1;
(statearr_43547_43606[(1)] = (39));

} else {
var statearr_43548_43607 = state_43470__$1;
(statearr_43548_43607[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43471 === (8))){
var inst_43350 = (state_43470[(15)]);
var inst_43349 = (state_43470[(16)]);
var inst_43352 = (inst_43350 < inst_43349);
var inst_43353 = inst_43352;
var state_43470__$1 = state_43470;
if(cljs.core.truth_(inst_43353)){
var statearr_43549_43608 = state_43470__$1;
(statearr_43549_43608[(1)] = (10));

} else {
var statearr_43550_43609 = state_43470__$1;
(statearr_43550_43609[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___43555,cs,m,dchan,dctr,done))
;
return ((function (switch__42662__auto__,c__42750__auto___43555,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__42663__auto__ = null;
var cljs$core$async$mult_$_state_machine__42663__auto____0 = (function (){
var statearr_43551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43551[(0)] = cljs$core$async$mult_$_state_machine__42663__auto__);

(statearr_43551[(1)] = (1));

return statearr_43551;
});
var cljs$core$async$mult_$_state_machine__42663__auto____1 = (function (state_43470){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43552){if((e43552 instanceof Object)){
var ex__42666__auto__ = e43552;
var statearr_43553_43610 = state_43470;
(statearr_43553_43610[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43552;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43611 = state_43470;
state_43470 = G__43611;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42663__auto__ = function(state_43470){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42663__auto____1.call(this,state_43470);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42663__auto____0;
cljs$core$async$mult_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42663__auto____1;
return cljs$core$async$mult_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___43555,cs,m,dchan,dctr,done))
})();
var state__42752__auto__ = (function (){var statearr_43554 = f__42751__auto__.call(null);
(statearr_43554[(6)] = c__42750__auto___43555);

return statearr_43554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___43555,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__43613 = arguments.length;
switch (G__43613) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m);
} else {
var m__28637__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,state_map);
} else {
var m__28637__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,mode);
} else {
var m__28637__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29124__auto__ = [];
var len__29117__auto___43625 = arguments.length;
var i__29118__auto___43626 = (0);
while(true){
if((i__29118__auto___43626 < len__29117__auto___43625)){
args__29124__auto__.push((arguments[i__29118__auto___43626]));

var G__43627 = (i__29118__auto___43626 + (1));
i__29118__auto___43626 = G__43627;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((3) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29125__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__43619){
var map__43620 = p__43619;
var map__43620__$1 = ((((!((map__43620 == null)))?((((map__43620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43620.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43620):map__43620);
var opts = map__43620__$1;
var statearr_43622_43628 = state;
(statearr_43622_43628[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__43620,map__43620__$1,opts){
return (function (val){
var statearr_43623_43629 = state;
(statearr_43623_43629[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__43620,map__43620__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_43624_43630 = state;
(statearr_43624_43630[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq43615){
var G__43616 = cljs.core.first.call(null,seq43615);
var seq43615__$1 = cljs.core.next.call(null,seq43615);
var G__43617 = cljs.core.first.call(null,seq43615__$1);
var seq43615__$2 = cljs.core.next.call(null,seq43615__$1);
var G__43618 = cljs.core.first.call(null,seq43615__$2);
var seq43615__$3 = cljs.core.next.call(null,seq43615__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43616,G__43617,G__43618,seq43615__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async43631 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43631 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta43632){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta43632 = meta43632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_43633,meta43632__$1){
var self__ = this;
var _43633__$1 = this;
return (new cljs.core.async.t_cljs$core$async43631(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta43632__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_43633){
var self__ = this;
var _43633__$1 = this;
return self__.meta43632;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta43632","meta43632",-1097954856,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async43631.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async43631.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43631";

cljs.core.async.t_cljs$core$async43631.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async43631");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async43631 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async43631(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta43632){
return (new cljs.core.async.t_cljs$core$async43631(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta43632));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async43631(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42750__auto___43795 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___43795,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___43795,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_43735){
var state_val_43736 = (state_43735[(1)]);
if((state_val_43736 === (7))){
var inst_43650 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
var statearr_43737_43796 = state_43735__$1;
(statearr_43737_43796[(2)] = inst_43650);

(statearr_43737_43796[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (20))){
var inst_43662 = (state_43735[(7)]);
var state_43735__$1 = state_43735;
var statearr_43738_43797 = state_43735__$1;
(statearr_43738_43797[(2)] = inst_43662);

(statearr_43738_43797[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (27))){
var state_43735__$1 = state_43735;
var statearr_43739_43798 = state_43735__$1;
(statearr_43739_43798[(2)] = null);

(statearr_43739_43798[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (1))){
var inst_43637 = (state_43735[(8)]);
var inst_43637__$1 = calc_state.call(null);
var inst_43639 = (inst_43637__$1 == null);
var inst_43640 = cljs.core.not.call(null,inst_43639);
var state_43735__$1 = (function (){var statearr_43740 = state_43735;
(statearr_43740[(8)] = inst_43637__$1);

return statearr_43740;
})();
if(inst_43640){
var statearr_43741_43799 = state_43735__$1;
(statearr_43741_43799[(1)] = (2));

} else {
var statearr_43742_43800 = state_43735__$1;
(statearr_43742_43800[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (24))){
var inst_43695 = (state_43735[(9)]);
var inst_43709 = (state_43735[(10)]);
var inst_43686 = (state_43735[(11)]);
var inst_43709__$1 = inst_43686.call(null,inst_43695);
var state_43735__$1 = (function (){var statearr_43743 = state_43735;
(statearr_43743[(10)] = inst_43709__$1);

return statearr_43743;
})();
if(cljs.core.truth_(inst_43709__$1)){
var statearr_43744_43801 = state_43735__$1;
(statearr_43744_43801[(1)] = (29));

} else {
var statearr_43745_43802 = state_43735__$1;
(statearr_43745_43802[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (4))){
var inst_43653 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43653)){
var statearr_43746_43803 = state_43735__$1;
(statearr_43746_43803[(1)] = (8));

} else {
var statearr_43747_43804 = state_43735__$1;
(statearr_43747_43804[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (15))){
var inst_43680 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43680)){
var statearr_43748_43805 = state_43735__$1;
(statearr_43748_43805[(1)] = (19));

} else {
var statearr_43749_43806 = state_43735__$1;
(statearr_43749_43806[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (21))){
var inst_43685 = (state_43735[(12)]);
var inst_43685__$1 = (state_43735[(2)]);
var inst_43686 = cljs.core.get.call(null,inst_43685__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43687 = cljs.core.get.call(null,inst_43685__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43688 = cljs.core.get.call(null,inst_43685__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_43735__$1 = (function (){var statearr_43750 = state_43735;
(statearr_43750[(12)] = inst_43685__$1);

(statearr_43750[(11)] = inst_43686);

(statearr_43750[(13)] = inst_43687);

return statearr_43750;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_43735__$1,(22),inst_43688);
} else {
if((state_val_43736 === (31))){
var inst_43717 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43717)){
var statearr_43751_43807 = state_43735__$1;
(statearr_43751_43807[(1)] = (32));

} else {
var statearr_43752_43808 = state_43735__$1;
(statearr_43752_43808[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (32))){
var inst_43694 = (state_43735[(14)]);
var state_43735__$1 = state_43735;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43735__$1,(35),out,inst_43694);
} else {
if((state_val_43736 === (33))){
var inst_43685 = (state_43735[(12)]);
var inst_43662 = inst_43685;
var state_43735__$1 = (function (){var statearr_43753 = state_43735;
(statearr_43753[(7)] = inst_43662);

return statearr_43753;
})();
var statearr_43754_43809 = state_43735__$1;
(statearr_43754_43809[(2)] = null);

(statearr_43754_43809[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (13))){
var inst_43662 = (state_43735[(7)]);
var inst_43669 = inst_43662.cljs$lang$protocol_mask$partition0$;
var inst_43670 = (inst_43669 & (64));
var inst_43671 = inst_43662.cljs$core$ISeq$;
var inst_43672 = (cljs.core.PROTOCOL_SENTINEL === inst_43671);
var inst_43673 = (inst_43670) || (inst_43672);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43673)){
var statearr_43755_43810 = state_43735__$1;
(statearr_43755_43810[(1)] = (16));

} else {
var statearr_43756_43811 = state_43735__$1;
(statearr_43756_43811[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (22))){
var inst_43695 = (state_43735[(9)]);
var inst_43694 = (state_43735[(14)]);
var inst_43693 = (state_43735[(2)]);
var inst_43694__$1 = cljs.core.nth.call(null,inst_43693,(0),null);
var inst_43695__$1 = cljs.core.nth.call(null,inst_43693,(1),null);
var inst_43696 = (inst_43694__$1 == null);
var inst_43697 = cljs.core._EQ_.call(null,inst_43695__$1,change);
var inst_43698 = (inst_43696) || (inst_43697);
var state_43735__$1 = (function (){var statearr_43757 = state_43735;
(statearr_43757[(9)] = inst_43695__$1);

(statearr_43757[(14)] = inst_43694__$1);

return statearr_43757;
})();
if(cljs.core.truth_(inst_43698)){
var statearr_43758_43812 = state_43735__$1;
(statearr_43758_43812[(1)] = (23));

} else {
var statearr_43759_43813 = state_43735__$1;
(statearr_43759_43813[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (36))){
var inst_43685 = (state_43735[(12)]);
var inst_43662 = inst_43685;
var state_43735__$1 = (function (){var statearr_43760 = state_43735;
(statearr_43760[(7)] = inst_43662);

return statearr_43760;
})();
var statearr_43761_43814 = state_43735__$1;
(statearr_43761_43814[(2)] = null);

(statearr_43761_43814[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (29))){
var inst_43709 = (state_43735[(10)]);
var state_43735__$1 = state_43735;
var statearr_43762_43815 = state_43735__$1;
(statearr_43762_43815[(2)] = inst_43709);

(statearr_43762_43815[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (6))){
var state_43735__$1 = state_43735;
var statearr_43763_43816 = state_43735__$1;
(statearr_43763_43816[(2)] = false);

(statearr_43763_43816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (28))){
var inst_43705 = (state_43735[(2)]);
var inst_43706 = calc_state.call(null);
var inst_43662 = inst_43706;
var state_43735__$1 = (function (){var statearr_43764 = state_43735;
(statearr_43764[(15)] = inst_43705);

(statearr_43764[(7)] = inst_43662);

return statearr_43764;
})();
var statearr_43765_43817 = state_43735__$1;
(statearr_43765_43817[(2)] = null);

(statearr_43765_43817[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (25))){
var inst_43731 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
var statearr_43766_43818 = state_43735__$1;
(statearr_43766_43818[(2)] = inst_43731);

(statearr_43766_43818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (34))){
var inst_43729 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
var statearr_43767_43819 = state_43735__$1;
(statearr_43767_43819[(2)] = inst_43729);

(statearr_43767_43819[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (17))){
var state_43735__$1 = state_43735;
var statearr_43768_43820 = state_43735__$1;
(statearr_43768_43820[(2)] = false);

(statearr_43768_43820[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (3))){
var state_43735__$1 = state_43735;
var statearr_43769_43821 = state_43735__$1;
(statearr_43769_43821[(2)] = false);

(statearr_43769_43821[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (12))){
var inst_43733 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43735__$1,inst_43733);
} else {
if((state_val_43736 === (2))){
var inst_43637 = (state_43735[(8)]);
var inst_43642 = inst_43637.cljs$lang$protocol_mask$partition0$;
var inst_43643 = (inst_43642 & (64));
var inst_43644 = inst_43637.cljs$core$ISeq$;
var inst_43645 = (cljs.core.PROTOCOL_SENTINEL === inst_43644);
var inst_43646 = (inst_43643) || (inst_43645);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43646)){
var statearr_43770_43822 = state_43735__$1;
(statearr_43770_43822[(1)] = (5));

} else {
var statearr_43771_43823 = state_43735__$1;
(statearr_43771_43823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (23))){
var inst_43694 = (state_43735[(14)]);
var inst_43700 = (inst_43694 == null);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43700)){
var statearr_43772_43824 = state_43735__$1;
(statearr_43772_43824[(1)] = (26));

} else {
var statearr_43773_43825 = state_43735__$1;
(statearr_43773_43825[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (35))){
var inst_43720 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
if(cljs.core.truth_(inst_43720)){
var statearr_43774_43826 = state_43735__$1;
(statearr_43774_43826[(1)] = (36));

} else {
var statearr_43775_43827 = state_43735__$1;
(statearr_43775_43827[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (19))){
var inst_43662 = (state_43735[(7)]);
var inst_43682 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43662);
var state_43735__$1 = state_43735;
var statearr_43776_43828 = state_43735__$1;
(statearr_43776_43828[(2)] = inst_43682);

(statearr_43776_43828[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (11))){
var inst_43662 = (state_43735[(7)]);
var inst_43666 = (inst_43662 == null);
var inst_43667 = cljs.core.not.call(null,inst_43666);
var state_43735__$1 = state_43735;
if(inst_43667){
var statearr_43777_43829 = state_43735__$1;
(statearr_43777_43829[(1)] = (13));

} else {
var statearr_43778_43830 = state_43735__$1;
(statearr_43778_43830[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (9))){
var inst_43637 = (state_43735[(8)]);
var state_43735__$1 = state_43735;
var statearr_43779_43831 = state_43735__$1;
(statearr_43779_43831[(2)] = inst_43637);

(statearr_43779_43831[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (5))){
var state_43735__$1 = state_43735;
var statearr_43780_43832 = state_43735__$1;
(statearr_43780_43832[(2)] = true);

(statearr_43780_43832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (14))){
var state_43735__$1 = state_43735;
var statearr_43781_43833 = state_43735__$1;
(statearr_43781_43833[(2)] = false);

(statearr_43781_43833[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (26))){
var inst_43695 = (state_43735[(9)]);
var inst_43702 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_43695);
var state_43735__$1 = state_43735;
var statearr_43782_43834 = state_43735__$1;
(statearr_43782_43834[(2)] = inst_43702);

(statearr_43782_43834[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (16))){
var state_43735__$1 = state_43735;
var statearr_43783_43835 = state_43735__$1;
(statearr_43783_43835[(2)] = true);

(statearr_43783_43835[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (38))){
var inst_43725 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
var statearr_43784_43836 = state_43735__$1;
(statearr_43784_43836[(2)] = inst_43725);

(statearr_43784_43836[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (30))){
var inst_43695 = (state_43735[(9)]);
var inst_43686 = (state_43735[(11)]);
var inst_43687 = (state_43735[(13)]);
var inst_43712 = cljs.core.empty_QMARK_.call(null,inst_43686);
var inst_43713 = inst_43687.call(null,inst_43695);
var inst_43714 = cljs.core.not.call(null,inst_43713);
var inst_43715 = (inst_43712) && (inst_43714);
var state_43735__$1 = state_43735;
var statearr_43785_43837 = state_43735__$1;
(statearr_43785_43837[(2)] = inst_43715);

(statearr_43785_43837[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (10))){
var inst_43637 = (state_43735[(8)]);
var inst_43658 = (state_43735[(2)]);
var inst_43659 = cljs.core.get.call(null,inst_43658,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43660 = cljs.core.get.call(null,inst_43658,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43661 = cljs.core.get.call(null,inst_43658,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_43662 = inst_43637;
var state_43735__$1 = (function (){var statearr_43786 = state_43735;
(statearr_43786[(16)] = inst_43660);

(statearr_43786[(17)] = inst_43659);

(statearr_43786[(18)] = inst_43661);

(statearr_43786[(7)] = inst_43662);

return statearr_43786;
})();
var statearr_43787_43838 = state_43735__$1;
(statearr_43787_43838[(2)] = null);

(statearr_43787_43838[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (18))){
var inst_43677 = (state_43735[(2)]);
var state_43735__$1 = state_43735;
var statearr_43788_43839 = state_43735__$1;
(statearr_43788_43839[(2)] = inst_43677);

(statearr_43788_43839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (37))){
var state_43735__$1 = state_43735;
var statearr_43789_43840 = state_43735__$1;
(statearr_43789_43840[(2)] = null);

(statearr_43789_43840[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43736 === (8))){
var inst_43637 = (state_43735[(8)]);
var inst_43655 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43637);
var state_43735__$1 = state_43735;
var statearr_43790_43841 = state_43735__$1;
(statearr_43790_43841[(2)] = inst_43655);

(statearr_43790_43841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___43795,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__42662__auto__,c__42750__auto___43795,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__42663__auto__ = null;
var cljs$core$async$mix_$_state_machine__42663__auto____0 = (function (){
var statearr_43791 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43791[(0)] = cljs$core$async$mix_$_state_machine__42663__auto__);

(statearr_43791[(1)] = (1));

return statearr_43791;
});
var cljs$core$async$mix_$_state_machine__42663__auto____1 = (function (state_43735){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43792){if((e43792 instanceof Object)){
var ex__42666__auto__ = e43792;
var statearr_43793_43842 = state_43735;
(statearr_43793_43842[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43843 = state_43735;
state_43735 = G__43843;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42663__auto__ = function(state_43735){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42663__auto____1.call(this,state_43735);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42663__auto____0;
cljs$core$async$mix_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42663__auto____1;
return cljs$core$async$mix_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___43795,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__42752__auto__ = (function (){var statearr_43794 = f__42751__auto__.call(null);
(statearr_43794[(6)] = c__42750__auto___43795);

return statearr_43794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___43795,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28637__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p,v,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__43845 = arguments.length;
switch (G__43845) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p);
} else {
var m__28637__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p,v);
} else {
var m__28637__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__43849 = arguments.length;
switch (G__43849) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27953__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27953__auto__,mults){
return (function (p1__43847_SHARP_){
if(cljs.core.truth_(p1__43847_SHARP_.call(null,topic))){
return p1__43847_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__43847_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27953__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async43850 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43850 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta43851){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta43851 = meta43851;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_43852,meta43851__$1){
var self__ = this;
var _43852__$1 = this;
return (new cljs.core.async.t_cljs$core$async43850(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta43851__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_43852){
var self__ = this;
var _43852__$1 = this;
return self__.meta43851;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta43851","meta43851",1245668610,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async43850.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async43850.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43850";

cljs.core.async.t_cljs$core$async43850.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async43850");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async43850 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async43850(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta43851){
return (new cljs.core.async.t_cljs$core$async43850(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta43851));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async43850(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42750__auto___43970 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___43970,mults,ensure_mult,p){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___43970,mults,ensure_mult,p){
return (function (state_43924){
var state_val_43925 = (state_43924[(1)]);
if((state_val_43925 === (7))){
var inst_43920 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
var statearr_43926_43971 = state_43924__$1;
(statearr_43926_43971[(2)] = inst_43920);

(statearr_43926_43971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (20))){
var state_43924__$1 = state_43924;
var statearr_43927_43972 = state_43924__$1;
(statearr_43927_43972[(2)] = null);

(statearr_43927_43972[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (1))){
var state_43924__$1 = state_43924;
var statearr_43928_43973 = state_43924__$1;
(statearr_43928_43973[(2)] = null);

(statearr_43928_43973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (24))){
var inst_43903 = (state_43924[(7)]);
var inst_43912 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_43903);
var state_43924__$1 = state_43924;
var statearr_43929_43974 = state_43924__$1;
(statearr_43929_43974[(2)] = inst_43912);

(statearr_43929_43974[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (4))){
var inst_43855 = (state_43924[(8)]);
var inst_43855__$1 = (state_43924[(2)]);
var inst_43856 = (inst_43855__$1 == null);
var state_43924__$1 = (function (){var statearr_43930 = state_43924;
(statearr_43930[(8)] = inst_43855__$1);

return statearr_43930;
})();
if(cljs.core.truth_(inst_43856)){
var statearr_43931_43975 = state_43924__$1;
(statearr_43931_43975[(1)] = (5));

} else {
var statearr_43932_43976 = state_43924__$1;
(statearr_43932_43976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (15))){
var inst_43897 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
var statearr_43933_43977 = state_43924__$1;
(statearr_43933_43977[(2)] = inst_43897);

(statearr_43933_43977[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (21))){
var inst_43917 = (state_43924[(2)]);
var state_43924__$1 = (function (){var statearr_43934 = state_43924;
(statearr_43934[(9)] = inst_43917);

return statearr_43934;
})();
var statearr_43935_43978 = state_43924__$1;
(statearr_43935_43978[(2)] = null);

(statearr_43935_43978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (13))){
var inst_43879 = (state_43924[(10)]);
var inst_43881 = cljs.core.chunked_seq_QMARK_.call(null,inst_43879);
var state_43924__$1 = state_43924;
if(inst_43881){
var statearr_43936_43979 = state_43924__$1;
(statearr_43936_43979[(1)] = (16));

} else {
var statearr_43937_43980 = state_43924__$1;
(statearr_43937_43980[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (22))){
var inst_43909 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
if(cljs.core.truth_(inst_43909)){
var statearr_43938_43981 = state_43924__$1;
(statearr_43938_43981[(1)] = (23));

} else {
var statearr_43939_43982 = state_43924__$1;
(statearr_43939_43982[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (6))){
var inst_43903 = (state_43924[(7)]);
var inst_43855 = (state_43924[(8)]);
var inst_43905 = (state_43924[(11)]);
var inst_43903__$1 = topic_fn.call(null,inst_43855);
var inst_43904 = cljs.core.deref.call(null,mults);
var inst_43905__$1 = cljs.core.get.call(null,inst_43904,inst_43903__$1);
var state_43924__$1 = (function (){var statearr_43940 = state_43924;
(statearr_43940[(7)] = inst_43903__$1);

(statearr_43940[(11)] = inst_43905__$1);

return statearr_43940;
})();
if(cljs.core.truth_(inst_43905__$1)){
var statearr_43941_43983 = state_43924__$1;
(statearr_43941_43983[(1)] = (19));

} else {
var statearr_43942_43984 = state_43924__$1;
(statearr_43942_43984[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (25))){
var inst_43914 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
var statearr_43943_43985 = state_43924__$1;
(statearr_43943_43985[(2)] = inst_43914);

(statearr_43943_43985[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (17))){
var inst_43879 = (state_43924[(10)]);
var inst_43888 = cljs.core.first.call(null,inst_43879);
var inst_43889 = cljs.core.async.muxch_STAR_.call(null,inst_43888);
var inst_43890 = cljs.core.async.close_BANG_.call(null,inst_43889);
var inst_43891 = cljs.core.next.call(null,inst_43879);
var inst_43865 = inst_43891;
var inst_43866 = null;
var inst_43867 = (0);
var inst_43868 = (0);
var state_43924__$1 = (function (){var statearr_43944 = state_43924;
(statearr_43944[(12)] = inst_43867);

(statearr_43944[(13)] = inst_43890);

(statearr_43944[(14)] = inst_43868);

(statearr_43944[(15)] = inst_43866);

(statearr_43944[(16)] = inst_43865);

return statearr_43944;
})();
var statearr_43945_43986 = state_43924__$1;
(statearr_43945_43986[(2)] = null);

(statearr_43945_43986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (3))){
var inst_43922 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43924__$1,inst_43922);
} else {
if((state_val_43925 === (12))){
var inst_43899 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
var statearr_43946_43987 = state_43924__$1;
(statearr_43946_43987[(2)] = inst_43899);

(statearr_43946_43987[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (2))){
var state_43924__$1 = state_43924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43924__$1,(4),ch);
} else {
if((state_val_43925 === (23))){
var state_43924__$1 = state_43924;
var statearr_43947_43988 = state_43924__$1;
(statearr_43947_43988[(2)] = null);

(statearr_43947_43988[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (19))){
var inst_43855 = (state_43924[(8)]);
var inst_43905 = (state_43924[(11)]);
var inst_43907 = cljs.core.async.muxch_STAR_.call(null,inst_43905);
var state_43924__$1 = state_43924;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43924__$1,(22),inst_43907,inst_43855);
} else {
if((state_val_43925 === (11))){
var inst_43865 = (state_43924[(16)]);
var inst_43879 = (state_43924[(10)]);
var inst_43879__$1 = cljs.core.seq.call(null,inst_43865);
var state_43924__$1 = (function (){var statearr_43948 = state_43924;
(statearr_43948[(10)] = inst_43879__$1);

return statearr_43948;
})();
if(inst_43879__$1){
var statearr_43949_43989 = state_43924__$1;
(statearr_43949_43989[(1)] = (13));

} else {
var statearr_43950_43990 = state_43924__$1;
(statearr_43950_43990[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (9))){
var inst_43901 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
var statearr_43951_43991 = state_43924__$1;
(statearr_43951_43991[(2)] = inst_43901);

(statearr_43951_43991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (5))){
var inst_43862 = cljs.core.deref.call(null,mults);
var inst_43863 = cljs.core.vals.call(null,inst_43862);
var inst_43864 = cljs.core.seq.call(null,inst_43863);
var inst_43865 = inst_43864;
var inst_43866 = null;
var inst_43867 = (0);
var inst_43868 = (0);
var state_43924__$1 = (function (){var statearr_43952 = state_43924;
(statearr_43952[(12)] = inst_43867);

(statearr_43952[(14)] = inst_43868);

(statearr_43952[(15)] = inst_43866);

(statearr_43952[(16)] = inst_43865);

return statearr_43952;
})();
var statearr_43953_43992 = state_43924__$1;
(statearr_43953_43992[(2)] = null);

(statearr_43953_43992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (14))){
var state_43924__$1 = state_43924;
var statearr_43957_43993 = state_43924__$1;
(statearr_43957_43993[(2)] = null);

(statearr_43957_43993[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (16))){
var inst_43879 = (state_43924[(10)]);
var inst_43883 = cljs.core.chunk_first.call(null,inst_43879);
var inst_43884 = cljs.core.chunk_rest.call(null,inst_43879);
var inst_43885 = cljs.core.count.call(null,inst_43883);
var inst_43865 = inst_43884;
var inst_43866 = inst_43883;
var inst_43867 = inst_43885;
var inst_43868 = (0);
var state_43924__$1 = (function (){var statearr_43958 = state_43924;
(statearr_43958[(12)] = inst_43867);

(statearr_43958[(14)] = inst_43868);

(statearr_43958[(15)] = inst_43866);

(statearr_43958[(16)] = inst_43865);

return statearr_43958;
})();
var statearr_43959_43994 = state_43924__$1;
(statearr_43959_43994[(2)] = null);

(statearr_43959_43994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (10))){
var inst_43867 = (state_43924[(12)]);
var inst_43868 = (state_43924[(14)]);
var inst_43866 = (state_43924[(15)]);
var inst_43865 = (state_43924[(16)]);
var inst_43873 = cljs.core._nth.call(null,inst_43866,inst_43868);
var inst_43874 = cljs.core.async.muxch_STAR_.call(null,inst_43873);
var inst_43875 = cljs.core.async.close_BANG_.call(null,inst_43874);
var inst_43876 = (inst_43868 + (1));
var tmp43954 = inst_43867;
var tmp43955 = inst_43866;
var tmp43956 = inst_43865;
var inst_43865__$1 = tmp43956;
var inst_43866__$1 = tmp43955;
var inst_43867__$1 = tmp43954;
var inst_43868__$1 = inst_43876;
var state_43924__$1 = (function (){var statearr_43960 = state_43924;
(statearr_43960[(12)] = inst_43867__$1);

(statearr_43960[(14)] = inst_43868__$1);

(statearr_43960[(17)] = inst_43875);

(statearr_43960[(15)] = inst_43866__$1);

(statearr_43960[(16)] = inst_43865__$1);

return statearr_43960;
})();
var statearr_43961_43995 = state_43924__$1;
(statearr_43961_43995[(2)] = null);

(statearr_43961_43995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (18))){
var inst_43894 = (state_43924[(2)]);
var state_43924__$1 = state_43924;
var statearr_43962_43996 = state_43924__$1;
(statearr_43962_43996[(2)] = inst_43894);

(statearr_43962_43996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43925 === (8))){
var inst_43867 = (state_43924[(12)]);
var inst_43868 = (state_43924[(14)]);
var inst_43870 = (inst_43868 < inst_43867);
var inst_43871 = inst_43870;
var state_43924__$1 = state_43924;
if(cljs.core.truth_(inst_43871)){
var statearr_43963_43997 = state_43924__$1;
(statearr_43963_43997[(1)] = (10));

} else {
var statearr_43964_43998 = state_43924__$1;
(statearr_43964_43998[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___43970,mults,ensure_mult,p))
;
return ((function (switch__42662__auto__,c__42750__auto___43970,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_43965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43965[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_43965[(1)] = (1));

return statearr_43965;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_43924){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_43924);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e43966){if((e43966 instanceof Object)){
var ex__42666__auto__ = e43966;
var statearr_43967_43999 = state_43924;
(statearr_43967_43999[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43924);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44000 = state_43924;
state_43924 = G__44000;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_43924){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_43924);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___43970,mults,ensure_mult,p))
})();
var state__42752__auto__ = (function (){var statearr_43968 = f__42751__auto__.call(null);
(statearr_43968[(6)] = c__42750__auto___43970);

return statearr_43968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___43970,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__44002 = arguments.length;
switch (G__44002) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__44005 = arguments.length;
switch (G__44005) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__44008 = arguments.length;
switch (G__44008) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__42750__auto___44075 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44075,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44075,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_44047){
var state_val_44048 = (state_44047[(1)]);
if((state_val_44048 === (7))){
var state_44047__$1 = state_44047;
var statearr_44049_44076 = state_44047__$1;
(statearr_44049_44076[(2)] = null);

(statearr_44049_44076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (1))){
var state_44047__$1 = state_44047;
var statearr_44050_44077 = state_44047__$1;
(statearr_44050_44077[(2)] = null);

(statearr_44050_44077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (4))){
var inst_44011 = (state_44047[(7)]);
var inst_44013 = (inst_44011 < cnt);
var state_44047__$1 = state_44047;
if(cljs.core.truth_(inst_44013)){
var statearr_44051_44078 = state_44047__$1;
(statearr_44051_44078[(1)] = (6));

} else {
var statearr_44052_44079 = state_44047__$1;
(statearr_44052_44079[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (15))){
var inst_44043 = (state_44047[(2)]);
var state_44047__$1 = state_44047;
var statearr_44053_44080 = state_44047__$1;
(statearr_44053_44080[(2)] = inst_44043);

(statearr_44053_44080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (13))){
var inst_44036 = cljs.core.async.close_BANG_.call(null,out);
var state_44047__$1 = state_44047;
var statearr_44054_44081 = state_44047__$1;
(statearr_44054_44081[(2)] = inst_44036);

(statearr_44054_44081[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (6))){
var state_44047__$1 = state_44047;
var statearr_44055_44082 = state_44047__$1;
(statearr_44055_44082[(2)] = null);

(statearr_44055_44082[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (3))){
var inst_44045 = (state_44047[(2)]);
var state_44047__$1 = state_44047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44047__$1,inst_44045);
} else {
if((state_val_44048 === (12))){
var inst_44033 = (state_44047[(8)]);
var inst_44033__$1 = (state_44047[(2)]);
var inst_44034 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_44033__$1);
var state_44047__$1 = (function (){var statearr_44056 = state_44047;
(statearr_44056[(8)] = inst_44033__$1);

return statearr_44056;
})();
if(cljs.core.truth_(inst_44034)){
var statearr_44057_44083 = state_44047__$1;
(statearr_44057_44083[(1)] = (13));

} else {
var statearr_44058_44084 = state_44047__$1;
(statearr_44058_44084[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (2))){
var inst_44010 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_44011 = (0);
var state_44047__$1 = (function (){var statearr_44059 = state_44047;
(statearr_44059[(9)] = inst_44010);

(statearr_44059[(7)] = inst_44011);

return statearr_44059;
})();
var statearr_44060_44085 = state_44047__$1;
(statearr_44060_44085[(2)] = null);

(statearr_44060_44085[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (11))){
var inst_44011 = (state_44047[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_44047,(10),Object,null,(9));
var inst_44020 = chs__$1.call(null,inst_44011);
var inst_44021 = done.call(null,inst_44011);
var inst_44022 = cljs.core.async.take_BANG_.call(null,inst_44020,inst_44021);
var state_44047__$1 = state_44047;
var statearr_44061_44086 = state_44047__$1;
(statearr_44061_44086[(2)] = inst_44022);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44047__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (9))){
var inst_44011 = (state_44047[(7)]);
var inst_44024 = (state_44047[(2)]);
var inst_44025 = (inst_44011 + (1));
var inst_44011__$1 = inst_44025;
var state_44047__$1 = (function (){var statearr_44062 = state_44047;
(statearr_44062[(10)] = inst_44024);

(statearr_44062[(7)] = inst_44011__$1);

return statearr_44062;
})();
var statearr_44063_44087 = state_44047__$1;
(statearr_44063_44087[(2)] = null);

(statearr_44063_44087[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (5))){
var inst_44031 = (state_44047[(2)]);
var state_44047__$1 = (function (){var statearr_44064 = state_44047;
(statearr_44064[(11)] = inst_44031);

return statearr_44064;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44047__$1,(12),dchan);
} else {
if((state_val_44048 === (14))){
var inst_44033 = (state_44047[(8)]);
var inst_44038 = cljs.core.apply.call(null,f,inst_44033);
var state_44047__$1 = state_44047;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44047__$1,(16),out,inst_44038);
} else {
if((state_val_44048 === (16))){
var inst_44040 = (state_44047[(2)]);
var state_44047__$1 = (function (){var statearr_44065 = state_44047;
(statearr_44065[(12)] = inst_44040);

return statearr_44065;
})();
var statearr_44066_44088 = state_44047__$1;
(statearr_44066_44088[(2)] = null);

(statearr_44066_44088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (10))){
var inst_44015 = (state_44047[(2)]);
var inst_44016 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_44047__$1 = (function (){var statearr_44067 = state_44047;
(statearr_44067[(13)] = inst_44015);

return statearr_44067;
})();
var statearr_44068_44089 = state_44047__$1;
(statearr_44068_44089[(2)] = inst_44016);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44047__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44048 === (8))){
var inst_44029 = (state_44047[(2)]);
var state_44047__$1 = state_44047;
var statearr_44069_44090 = state_44047__$1;
(statearr_44069_44090[(2)] = inst_44029);

(statearr_44069_44090[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44075,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__42662__auto__,c__42750__auto___44075,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44070[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44070[(1)] = (1));

return statearr_44070;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44047){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44071){if((e44071 instanceof Object)){
var ex__42666__auto__ = e44071;
var statearr_44072_44091 = state_44047;
(statearr_44072_44091[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44047);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44071;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44092 = state_44047;
state_44047 = G__44092;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44047){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44047);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44075,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__42752__auto__ = (function (){var statearr_44073 = f__42751__auto__.call(null);
(statearr_44073[(6)] = c__42750__auto___44075);

return statearr_44073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44075,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__44095 = arguments.length;
switch (G__44095) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42750__auto___44149 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44149,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44149,out){
return (function (state_44127){
var state_val_44128 = (state_44127[(1)]);
if((state_val_44128 === (7))){
var inst_44107 = (state_44127[(7)]);
var inst_44106 = (state_44127[(8)]);
var inst_44106__$1 = (state_44127[(2)]);
var inst_44107__$1 = cljs.core.nth.call(null,inst_44106__$1,(0),null);
var inst_44108 = cljs.core.nth.call(null,inst_44106__$1,(1),null);
var inst_44109 = (inst_44107__$1 == null);
var state_44127__$1 = (function (){var statearr_44129 = state_44127;
(statearr_44129[(7)] = inst_44107__$1);

(statearr_44129[(9)] = inst_44108);

(statearr_44129[(8)] = inst_44106__$1);

return statearr_44129;
})();
if(cljs.core.truth_(inst_44109)){
var statearr_44130_44150 = state_44127__$1;
(statearr_44130_44150[(1)] = (8));

} else {
var statearr_44131_44151 = state_44127__$1;
(statearr_44131_44151[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (1))){
var inst_44096 = cljs.core.vec.call(null,chs);
var inst_44097 = inst_44096;
var state_44127__$1 = (function (){var statearr_44132 = state_44127;
(statearr_44132[(10)] = inst_44097);

return statearr_44132;
})();
var statearr_44133_44152 = state_44127__$1;
(statearr_44133_44152[(2)] = null);

(statearr_44133_44152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (4))){
var inst_44097 = (state_44127[(10)]);
var state_44127__$1 = state_44127;
return cljs.core.async.ioc_alts_BANG_.call(null,state_44127__$1,(7),inst_44097);
} else {
if((state_val_44128 === (6))){
var inst_44123 = (state_44127[(2)]);
var state_44127__$1 = state_44127;
var statearr_44134_44153 = state_44127__$1;
(statearr_44134_44153[(2)] = inst_44123);

(statearr_44134_44153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (3))){
var inst_44125 = (state_44127[(2)]);
var state_44127__$1 = state_44127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44127__$1,inst_44125);
} else {
if((state_val_44128 === (2))){
var inst_44097 = (state_44127[(10)]);
var inst_44099 = cljs.core.count.call(null,inst_44097);
var inst_44100 = (inst_44099 > (0));
var state_44127__$1 = state_44127;
if(cljs.core.truth_(inst_44100)){
var statearr_44136_44154 = state_44127__$1;
(statearr_44136_44154[(1)] = (4));

} else {
var statearr_44137_44155 = state_44127__$1;
(statearr_44137_44155[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (11))){
var inst_44097 = (state_44127[(10)]);
var inst_44116 = (state_44127[(2)]);
var tmp44135 = inst_44097;
var inst_44097__$1 = tmp44135;
var state_44127__$1 = (function (){var statearr_44138 = state_44127;
(statearr_44138[(10)] = inst_44097__$1);

(statearr_44138[(11)] = inst_44116);

return statearr_44138;
})();
var statearr_44139_44156 = state_44127__$1;
(statearr_44139_44156[(2)] = null);

(statearr_44139_44156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (9))){
var inst_44107 = (state_44127[(7)]);
var state_44127__$1 = state_44127;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44127__$1,(11),out,inst_44107);
} else {
if((state_val_44128 === (5))){
var inst_44121 = cljs.core.async.close_BANG_.call(null,out);
var state_44127__$1 = state_44127;
var statearr_44140_44157 = state_44127__$1;
(statearr_44140_44157[(2)] = inst_44121);

(statearr_44140_44157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (10))){
var inst_44119 = (state_44127[(2)]);
var state_44127__$1 = state_44127;
var statearr_44141_44158 = state_44127__$1;
(statearr_44141_44158[(2)] = inst_44119);

(statearr_44141_44158[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44128 === (8))){
var inst_44107 = (state_44127[(7)]);
var inst_44108 = (state_44127[(9)]);
var inst_44097 = (state_44127[(10)]);
var inst_44106 = (state_44127[(8)]);
var inst_44111 = (function (){var cs = inst_44097;
var vec__44102 = inst_44106;
var v = inst_44107;
var c = inst_44108;
return ((function (cs,vec__44102,v,c,inst_44107,inst_44108,inst_44097,inst_44106,state_val_44128,c__42750__auto___44149,out){
return (function (p1__44093_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__44093_SHARP_);
});
;})(cs,vec__44102,v,c,inst_44107,inst_44108,inst_44097,inst_44106,state_val_44128,c__42750__auto___44149,out))
})();
var inst_44112 = cljs.core.filterv.call(null,inst_44111,inst_44097);
var inst_44097__$1 = inst_44112;
var state_44127__$1 = (function (){var statearr_44142 = state_44127;
(statearr_44142[(10)] = inst_44097__$1);

return statearr_44142;
})();
var statearr_44143_44159 = state_44127__$1;
(statearr_44143_44159[(2)] = null);

(statearr_44143_44159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44149,out))
;
return ((function (switch__42662__auto__,c__42750__auto___44149,out){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44144 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44144[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44144[(1)] = (1));

return statearr_44144;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44127){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44145){if((e44145 instanceof Object)){
var ex__42666__auto__ = e44145;
var statearr_44146_44160 = state_44127;
(statearr_44146_44160[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44127);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44161 = state_44127;
state_44127 = G__44161;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44127){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44127);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44149,out))
})();
var state__42752__auto__ = (function (){var statearr_44147 = f__42751__auto__.call(null);
(statearr_44147[(6)] = c__42750__auto___44149);

return statearr_44147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44149,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__44163 = arguments.length;
switch (G__44163) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42750__auto___44208 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44208,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44208,out){
return (function (state_44187){
var state_val_44188 = (state_44187[(1)]);
if((state_val_44188 === (7))){
var inst_44169 = (state_44187[(7)]);
var inst_44169__$1 = (state_44187[(2)]);
var inst_44170 = (inst_44169__$1 == null);
var inst_44171 = cljs.core.not.call(null,inst_44170);
var state_44187__$1 = (function (){var statearr_44189 = state_44187;
(statearr_44189[(7)] = inst_44169__$1);

return statearr_44189;
})();
if(inst_44171){
var statearr_44190_44209 = state_44187__$1;
(statearr_44190_44209[(1)] = (8));

} else {
var statearr_44191_44210 = state_44187__$1;
(statearr_44191_44210[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (1))){
var inst_44164 = (0);
var state_44187__$1 = (function (){var statearr_44192 = state_44187;
(statearr_44192[(8)] = inst_44164);

return statearr_44192;
})();
var statearr_44193_44211 = state_44187__$1;
(statearr_44193_44211[(2)] = null);

(statearr_44193_44211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (4))){
var state_44187__$1 = state_44187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44187__$1,(7),ch);
} else {
if((state_val_44188 === (6))){
var inst_44182 = (state_44187[(2)]);
var state_44187__$1 = state_44187;
var statearr_44194_44212 = state_44187__$1;
(statearr_44194_44212[(2)] = inst_44182);

(statearr_44194_44212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (3))){
var inst_44184 = (state_44187[(2)]);
var inst_44185 = cljs.core.async.close_BANG_.call(null,out);
var state_44187__$1 = (function (){var statearr_44195 = state_44187;
(statearr_44195[(9)] = inst_44184);

return statearr_44195;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44187__$1,inst_44185);
} else {
if((state_val_44188 === (2))){
var inst_44164 = (state_44187[(8)]);
var inst_44166 = (inst_44164 < n);
var state_44187__$1 = state_44187;
if(cljs.core.truth_(inst_44166)){
var statearr_44196_44213 = state_44187__$1;
(statearr_44196_44213[(1)] = (4));

} else {
var statearr_44197_44214 = state_44187__$1;
(statearr_44197_44214[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (11))){
var inst_44164 = (state_44187[(8)]);
var inst_44174 = (state_44187[(2)]);
var inst_44175 = (inst_44164 + (1));
var inst_44164__$1 = inst_44175;
var state_44187__$1 = (function (){var statearr_44198 = state_44187;
(statearr_44198[(10)] = inst_44174);

(statearr_44198[(8)] = inst_44164__$1);

return statearr_44198;
})();
var statearr_44199_44215 = state_44187__$1;
(statearr_44199_44215[(2)] = null);

(statearr_44199_44215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (9))){
var state_44187__$1 = state_44187;
var statearr_44200_44216 = state_44187__$1;
(statearr_44200_44216[(2)] = null);

(statearr_44200_44216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (5))){
var state_44187__$1 = state_44187;
var statearr_44201_44217 = state_44187__$1;
(statearr_44201_44217[(2)] = null);

(statearr_44201_44217[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (10))){
var inst_44179 = (state_44187[(2)]);
var state_44187__$1 = state_44187;
var statearr_44202_44218 = state_44187__$1;
(statearr_44202_44218[(2)] = inst_44179);

(statearr_44202_44218[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44188 === (8))){
var inst_44169 = (state_44187[(7)]);
var state_44187__$1 = state_44187;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44187__$1,(11),out,inst_44169);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44208,out))
;
return ((function (switch__42662__auto__,c__42750__auto___44208,out){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44203 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44203[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44203[(1)] = (1));

return statearr_44203;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44187){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44204){if((e44204 instanceof Object)){
var ex__42666__auto__ = e44204;
var statearr_44205_44219 = state_44187;
(statearr_44205_44219[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44204;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44220 = state_44187;
state_44187 = G__44220;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44187){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44187);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44208,out))
})();
var state__42752__auto__ = (function (){var statearr_44206 = f__42751__auto__.call(null);
(statearr_44206[(6)] = c__42750__auto___44208);

return statearr_44206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44208,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async44222 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44222 = (function (f,ch,meta44223){
this.f = f;
this.ch = ch;
this.meta44223 = meta44223;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44224,meta44223__$1){
var self__ = this;
var _44224__$1 = this;
return (new cljs.core.async.t_cljs$core$async44222(self__.f,self__.ch,meta44223__$1));
});

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44224){
var self__ = this;
var _44224__$1 = this;
return self__.meta44223;
});

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async44225 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44225 = (function (f,ch,meta44223,_,fn1,meta44226){
this.f = f;
this.ch = ch;
this.meta44223 = meta44223;
this._ = _;
this.fn1 = fn1;
this.meta44226 = meta44226;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async44225.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_44227,meta44226__$1){
var self__ = this;
var _44227__$1 = this;
return (new cljs.core.async.t_cljs$core$async44225(self__.f,self__.ch,self__.meta44223,self__._,self__.fn1,meta44226__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async44225.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_44227){
var self__ = this;
var _44227__$1 = this;
return self__.meta44226;
});})(___$1))
;

cljs.core.async.t_cljs$core$async44225.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44225.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async44225.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async44225.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__44221_SHARP_){
return f1.call(null,(((p1__44221_SHARP_ == null))?null:self__.f.call(null,p1__44221_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async44225.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44223","meta44223",-1218783309,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async44222","cljs.core.async/t_cljs$core$async44222",1961614093,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta44226","meta44226",338243642,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async44225.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44225.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44225";

cljs.core.async.t_cljs$core$async44225.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async44225");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async44225 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44225(f__$1,ch__$1,meta44223__$1,___$2,fn1__$1,meta44226){
return (new cljs.core.async.t_cljs$core$async44225(f__$1,ch__$1,meta44223__$1,___$2,fn1__$1,meta44226));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async44225(self__.f,self__.ch,self__.meta44223,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27941__auto__ = ret;
if(cljs.core.truth_(and__27941__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27941__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44222.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async44222.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44223","meta44223",-1218783309,null)], null);
});

cljs.core.async.t_cljs$core$async44222.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44222.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44222";

cljs.core.async.t_cljs$core$async44222.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async44222");
});

cljs.core.async.__GT_t_cljs$core$async44222 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44222(f__$1,ch__$1,meta44223){
return (new cljs.core.async.t_cljs$core$async44222(f__$1,ch__$1,meta44223));
});

}

return (new cljs.core.async.t_cljs$core$async44222(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async44228 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44228 = (function (f,ch,meta44229){
this.f = f;
this.ch = ch;
this.meta44229 = meta44229;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44230,meta44229__$1){
var self__ = this;
var _44230__$1 = this;
return (new cljs.core.async.t_cljs$core$async44228(self__.f,self__.ch,meta44229__$1));
});

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44230){
var self__ = this;
var _44230__$1 = this;
return self__.meta44229;
});

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44228.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async44228.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44229","meta44229",-1071039704,null)], null);
});

cljs.core.async.t_cljs$core$async44228.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44228.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44228";

cljs.core.async.t_cljs$core$async44228.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async44228");
});

cljs.core.async.__GT_t_cljs$core$async44228 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async44228(f__$1,ch__$1,meta44229){
return (new cljs.core.async.t_cljs$core$async44228(f__$1,ch__$1,meta44229));
});

}

return (new cljs.core.async.t_cljs$core$async44228(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async44231 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44231 = (function (p,ch,meta44232){
this.p = p;
this.ch = ch;
this.meta44232 = meta44232;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44233,meta44232__$1){
var self__ = this;
var _44233__$1 = this;
return (new cljs.core.async.t_cljs$core$async44231(self__.p,self__.ch,meta44232__$1));
});

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44233){
var self__ = this;
var _44233__$1 = this;
return self__.meta44232;
});

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async44231.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async44231.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44232","meta44232",2124208272,null)], null);
});

cljs.core.async.t_cljs$core$async44231.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44231.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44231";

cljs.core.async.t_cljs$core$async44231.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async44231");
});

cljs.core.async.__GT_t_cljs$core$async44231 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async44231(p__$1,ch__$1,meta44232){
return (new cljs.core.async.t_cljs$core$async44231(p__$1,ch__$1,meta44232));
});

}

return (new cljs.core.async.t_cljs$core$async44231(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__44235 = arguments.length;
switch (G__44235) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42750__auto___44275 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44275,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44275,out){
return (function (state_44256){
var state_val_44257 = (state_44256[(1)]);
if((state_val_44257 === (7))){
var inst_44252 = (state_44256[(2)]);
var state_44256__$1 = state_44256;
var statearr_44258_44276 = state_44256__$1;
(statearr_44258_44276[(2)] = inst_44252);

(statearr_44258_44276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (1))){
var state_44256__$1 = state_44256;
var statearr_44259_44277 = state_44256__$1;
(statearr_44259_44277[(2)] = null);

(statearr_44259_44277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (4))){
var inst_44238 = (state_44256[(7)]);
var inst_44238__$1 = (state_44256[(2)]);
var inst_44239 = (inst_44238__$1 == null);
var state_44256__$1 = (function (){var statearr_44260 = state_44256;
(statearr_44260[(7)] = inst_44238__$1);

return statearr_44260;
})();
if(cljs.core.truth_(inst_44239)){
var statearr_44261_44278 = state_44256__$1;
(statearr_44261_44278[(1)] = (5));

} else {
var statearr_44262_44279 = state_44256__$1;
(statearr_44262_44279[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (6))){
var inst_44238 = (state_44256[(7)]);
var inst_44243 = p.call(null,inst_44238);
var state_44256__$1 = state_44256;
if(cljs.core.truth_(inst_44243)){
var statearr_44263_44280 = state_44256__$1;
(statearr_44263_44280[(1)] = (8));

} else {
var statearr_44264_44281 = state_44256__$1;
(statearr_44264_44281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (3))){
var inst_44254 = (state_44256[(2)]);
var state_44256__$1 = state_44256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44256__$1,inst_44254);
} else {
if((state_val_44257 === (2))){
var state_44256__$1 = state_44256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44256__$1,(4),ch);
} else {
if((state_val_44257 === (11))){
var inst_44246 = (state_44256[(2)]);
var state_44256__$1 = state_44256;
var statearr_44265_44282 = state_44256__$1;
(statearr_44265_44282[(2)] = inst_44246);

(statearr_44265_44282[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (9))){
var state_44256__$1 = state_44256;
var statearr_44266_44283 = state_44256__$1;
(statearr_44266_44283[(2)] = null);

(statearr_44266_44283[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (5))){
var inst_44241 = cljs.core.async.close_BANG_.call(null,out);
var state_44256__$1 = state_44256;
var statearr_44267_44284 = state_44256__$1;
(statearr_44267_44284[(2)] = inst_44241);

(statearr_44267_44284[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (10))){
var inst_44249 = (state_44256[(2)]);
var state_44256__$1 = (function (){var statearr_44268 = state_44256;
(statearr_44268[(8)] = inst_44249);

return statearr_44268;
})();
var statearr_44269_44285 = state_44256__$1;
(statearr_44269_44285[(2)] = null);

(statearr_44269_44285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44257 === (8))){
var inst_44238 = (state_44256[(7)]);
var state_44256__$1 = state_44256;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44256__$1,(11),out,inst_44238);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44275,out))
;
return ((function (switch__42662__auto__,c__42750__auto___44275,out){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44270 = [null,null,null,null,null,null,null,null,null];
(statearr_44270[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44270[(1)] = (1));

return statearr_44270;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44256){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44271){if((e44271 instanceof Object)){
var ex__42666__auto__ = e44271;
var statearr_44272_44286 = state_44256;
(statearr_44272_44286[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44256);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44287 = state_44256;
state_44256 = G__44287;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44256){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44256);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44275,out))
})();
var state__42752__auto__ = (function (){var statearr_44273 = f__42751__auto__.call(null);
(statearr_44273[(6)] = c__42750__auto___44275);

return statearr_44273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44275,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__44289 = arguments.length;
switch (G__44289) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__){
return (function (state_44352){
var state_val_44353 = (state_44352[(1)]);
if((state_val_44353 === (7))){
var inst_44348 = (state_44352[(2)]);
var state_44352__$1 = state_44352;
var statearr_44354_44392 = state_44352__$1;
(statearr_44354_44392[(2)] = inst_44348);

(statearr_44354_44392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (20))){
var inst_44318 = (state_44352[(7)]);
var inst_44329 = (state_44352[(2)]);
var inst_44330 = cljs.core.next.call(null,inst_44318);
var inst_44304 = inst_44330;
var inst_44305 = null;
var inst_44306 = (0);
var inst_44307 = (0);
var state_44352__$1 = (function (){var statearr_44355 = state_44352;
(statearr_44355[(8)] = inst_44304);

(statearr_44355[(9)] = inst_44307);

(statearr_44355[(10)] = inst_44305);

(statearr_44355[(11)] = inst_44329);

(statearr_44355[(12)] = inst_44306);

return statearr_44355;
})();
var statearr_44356_44393 = state_44352__$1;
(statearr_44356_44393[(2)] = null);

(statearr_44356_44393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (1))){
var state_44352__$1 = state_44352;
var statearr_44357_44394 = state_44352__$1;
(statearr_44357_44394[(2)] = null);

(statearr_44357_44394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (4))){
var inst_44293 = (state_44352[(13)]);
var inst_44293__$1 = (state_44352[(2)]);
var inst_44294 = (inst_44293__$1 == null);
var state_44352__$1 = (function (){var statearr_44358 = state_44352;
(statearr_44358[(13)] = inst_44293__$1);

return statearr_44358;
})();
if(cljs.core.truth_(inst_44294)){
var statearr_44359_44395 = state_44352__$1;
(statearr_44359_44395[(1)] = (5));

} else {
var statearr_44360_44396 = state_44352__$1;
(statearr_44360_44396[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (15))){
var state_44352__$1 = state_44352;
var statearr_44364_44397 = state_44352__$1;
(statearr_44364_44397[(2)] = null);

(statearr_44364_44397[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (21))){
var state_44352__$1 = state_44352;
var statearr_44365_44398 = state_44352__$1;
(statearr_44365_44398[(2)] = null);

(statearr_44365_44398[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (13))){
var inst_44304 = (state_44352[(8)]);
var inst_44307 = (state_44352[(9)]);
var inst_44305 = (state_44352[(10)]);
var inst_44306 = (state_44352[(12)]);
var inst_44314 = (state_44352[(2)]);
var inst_44315 = (inst_44307 + (1));
var tmp44361 = inst_44304;
var tmp44362 = inst_44305;
var tmp44363 = inst_44306;
var inst_44304__$1 = tmp44361;
var inst_44305__$1 = tmp44362;
var inst_44306__$1 = tmp44363;
var inst_44307__$1 = inst_44315;
var state_44352__$1 = (function (){var statearr_44366 = state_44352;
(statearr_44366[(8)] = inst_44304__$1);

(statearr_44366[(9)] = inst_44307__$1);

(statearr_44366[(10)] = inst_44305__$1);

(statearr_44366[(14)] = inst_44314);

(statearr_44366[(12)] = inst_44306__$1);

return statearr_44366;
})();
var statearr_44367_44399 = state_44352__$1;
(statearr_44367_44399[(2)] = null);

(statearr_44367_44399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (22))){
var state_44352__$1 = state_44352;
var statearr_44368_44400 = state_44352__$1;
(statearr_44368_44400[(2)] = null);

(statearr_44368_44400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (6))){
var inst_44293 = (state_44352[(13)]);
var inst_44302 = f.call(null,inst_44293);
var inst_44303 = cljs.core.seq.call(null,inst_44302);
var inst_44304 = inst_44303;
var inst_44305 = null;
var inst_44306 = (0);
var inst_44307 = (0);
var state_44352__$1 = (function (){var statearr_44369 = state_44352;
(statearr_44369[(8)] = inst_44304);

(statearr_44369[(9)] = inst_44307);

(statearr_44369[(10)] = inst_44305);

(statearr_44369[(12)] = inst_44306);

return statearr_44369;
})();
var statearr_44370_44401 = state_44352__$1;
(statearr_44370_44401[(2)] = null);

(statearr_44370_44401[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (17))){
var inst_44318 = (state_44352[(7)]);
var inst_44322 = cljs.core.chunk_first.call(null,inst_44318);
var inst_44323 = cljs.core.chunk_rest.call(null,inst_44318);
var inst_44324 = cljs.core.count.call(null,inst_44322);
var inst_44304 = inst_44323;
var inst_44305 = inst_44322;
var inst_44306 = inst_44324;
var inst_44307 = (0);
var state_44352__$1 = (function (){var statearr_44371 = state_44352;
(statearr_44371[(8)] = inst_44304);

(statearr_44371[(9)] = inst_44307);

(statearr_44371[(10)] = inst_44305);

(statearr_44371[(12)] = inst_44306);

return statearr_44371;
})();
var statearr_44372_44402 = state_44352__$1;
(statearr_44372_44402[(2)] = null);

(statearr_44372_44402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (3))){
var inst_44350 = (state_44352[(2)]);
var state_44352__$1 = state_44352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44352__$1,inst_44350);
} else {
if((state_val_44353 === (12))){
var inst_44338 = (state_44352[(2)]);
var state_44352__$1 = state_44352;
var statearr_44373_44403 = state_44352__$1;
(statearr_44373_44403[(2)] = inst_44338);

(statearr_44373_44403[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (2))){
var state_44352__$1 = state_44352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44352__$1,(4),in$);
} else {
if((state_val_44353 === (23))){
var inst_44346 = (state_44352[(2)]);
var state_44352__$1 = state_44352;
var statearr_44374_44404 = state_44352__$1;
(statearr_44374_44404[(2)] = inst_44346);

(statearr_44374_44404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (19))){
var inst_44333 = (state_44352[(2)]);
var state_44352__$1 = state_44352;
var statearr_44375_44405 = state_44352__$1;
(statearr_44375_44405[(2)] = inst_44333);

(statearr_44375_44405[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (11))){
var inst_44304 = (state_44352[(8)]);
var inst_44318 = (state_44352[(7)]);
var inst_44318__$1 = cljs.core.seq.call(null,inst_44304);
var state_44352__$1 = (function (){var statearr_44376 = state_44352;
(statearr_44376[(7)] = inst_44318__$1);

return statearr_44376;
})();
if(inst_44318__$1){
var statearr_44377_44406 = state_44352__$1;
(statearr_44377_44406[(1)] = (14));

} else {
var statearr_44378_44407 = state_44352__$1;
(statearr_44378_44407[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (9))){
var inst_44340 = (state_44352[(2)]);
var inst_44341 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_44352__$1 = (function (){var statearr_44379 = state_44352;
(statearr_44379[(15)] = inst_44340);

return statearr_44379;
})();
if(cljs.core.truth_(inst_44341)){
var statearr_44380_44408 = state_44352__$1;
(statearr_44380_44408[(1)] = (21));

} else {
var statearr_44381_44409 = state_44352__$1;
(statearr_44381_44409[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (5))){
var inst_44296 = cljs.core.async.close_BANG_.call(null,out);
var state_44352__$1 = state_44352;
var statearr_44382_44410 = state_44352__$1;
(statearr_44382_44410[(2)] = inst_44296);

(statearr_44382_44410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (14))){
var inst_44318 = (state_44352[(7)]);
var inst_44320 = cljs.core.chunked_seq_QMARK_.call(null,inst_44318);
var state_44352__$1 = state_44352;
if(inst_44320){
var statearr_44383_44411 = state_44352__$1;
(statearr_44383_44411[(1)] = (17));

} else {
var statearr_44384_44412 = state_44352__$1;
(statearr_44384_44412[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (16))){
var inst_44336 = (state_44352[(2)]);
var state_44352__$1 = state_44352;
var statearr_44385_44413 = state_44352__$1;
(statearr_44385_44413[(2)] = inst_44336);

(statearr_44385_44413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44353 === (10))){
var inst_44307 = (state_44352[(9)]);
var inst_44305 = (state_44352[(10)]);
var inst_44312 = cljs.core._nth.call(null,inst_44305,inst_44307);
var state_44352__$1 = state_44352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44352__$1,(13),out,inst_44312);
} else {
if((state_val_44353 === (18))){
var inst_44318 = (state_44352[(7)]);
var inst_44327 = cljs.core.first.call(null,inst_44318);
var state_44352__$1 = state_44352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44352__$1,(20),out,inst_44327);
} else {
if((state_val_44353 === (8))){
var inst_44307 = (state_44352[(9)]);
var inst_44306 = (state_44352[(12)]);
var inst_44309 = (inst_44307 < inst_44306);
var inst_44310 = inst_44309;
var state_44352__$1 = state_44352;
if(cljs.core.truth_(inst_44310)){
var statearr_44386_44414 = state_44352__$1;
(statearr_44386_44414[(1)] = (10));

} else {
var statearr_44387_44415 = state_44352__$1;
(statearr_44387_44415[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__))
;
return ((function (switch__42662__auto__,c__42750__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42663__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42663__auto____0 = (function (){
var statearr_44388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44388[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42663__auto__);

(statearr_44388[(1)] = (1));

return statearr_44388;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42663__auto____1 = (function (state_44352){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44389){if((e44389 instanceof Object)){
var ex__42666__auto__ = e44389;
var statearr_44390_44416 = state_44352;
(statearr_44390_44416[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44417 = state_44352;
state_44352 = G__44417;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42663__auto__ = function(state_44352){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42663__auto____1.call(this,state_44352);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42663__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42663__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__))
})();
var state__42752__auto__ = (function (){var statearr_44391 = f__42751__auto__.call(null);
(statearr_44391[(6)] = c__42750__auto__);

return statearr_44391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__))
);

return c__42750__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__44419 = arguments.length;
switch (G__44419) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__44422 = arguments.length;
switch (G__44422) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__44425 = arguments.length;
switch (G__44425) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42750__auto___44472 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44472,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44472,out){
return (function (state_44449){
var state_val_44450 = (state_44449[(1)]);
if((state_val_44450 === (7))){
var inst_44444 = (state_44449[(2)]);
var state_44449__$1 = state_44449;
var statearr_44451_44473 = state_44449__$1;
(statearr_44451_44473[(2)] = inst_44444);

(statearr_44451_44473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (1))){
var inst_44426 = null;
var state_44449__$1 = (function (){var statearr_44452 = state_44449;
(statearr_44452[(7)] = inst_44426);

return statearr_44452;
})();
var statearr_44453_44474 = state_44449__$1;
(statearr_44453_44474[(2)] = null);

(statearr_44453_44474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (4))){
var inst_44429 = (state_44449[(8)]);
var inst_44429__$1 = (state_44449[(2)]);
var inst_44430 = (inst_44429__$1 == null);
var inst_44431 = cljs.core.not.call(null,inst_44430);
var state_44449__$1 = (function (){var statearr_44454 = state_44449;
(statearr_44454[(8)] = inst_44429__$1);

return statearr_44454;
})();
if(inst_44431){
var statearr_44455_44475 = state_44449__$1;
(statearr_44455_44475[(1)] = (5));

} else {
var statearr_44456_44476 = state_44449__$1;
(statearr_44456_44476[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (6))){
var state_44449__$1 = state_44449;
var statearr_44457_44477 = state_44449__$1;
(statearr_44457_44477[(2)] = null);

(statearr_44457_44477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (3))){
var inst_44446 = (state_44449[(2)]);
var inst_44447 = cljs.core.async.close_BANG_.call(null,out);
var state_44449__$1 = (function (){var statearr_44458 = state_44449;
(statearr_44458[(9)] = inst_44446);

return statearr_44458;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44449__$1,inst_44447);
} else {
if((state_val_44450 === (2))){
var state_44449__$1 = state_44449;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44449__$1,(4),ch);
} else {
if((state_val_44450 === (11))){
var inst_44429 = (state_44449[(8)]);
var inst_44438 = (state_44449[(2)]);
var inst_44426 = inst_44429;
var state_44449__$1 = (function (){var statearr_44459 = state_44449;
(statearr_44459[(10)] = inst_44438);

(statearr_44459[(7)] = inst_44426);

return statearr_44459;
})();
var statearr_44460_44478 = state_44449__$1;
(statearr_44460_44478[(2)] = null);

(statearr_44460_44478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (9))){
var inst_44429 = (state_44449[(8)]);
var state_44449__$1 = state_44449;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44449__$1,(11),out,inst_44429);
} else {
if((state_val_44450 === (5))){
var inst_44426 = (state_44449[(7)]);
var inst_44429 = (state_44449[(8)]);
var inst_44433 = cljs.core._EQ_.call(null,inst_44429,inst_44426);
var state_44449__$1 = state_44449;
if(inst_44433){
var statearr_44462_44479 = state_44449__$1;
(statearr_44462_44479[(1)] = (8));

} else {
var statearr_44463_44480 = state_44449__$1;
(statearr_44463_44480[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (10))){
var inst_44441 = (state_44449[(2)]);
var state_44449__$1 = state_44449;
var statearr_44464_44481 = state_44449__$1;
(statearr_44464_44481[(2)] = inst_44441);

(statearr_44464_44481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44450 === (8))){
var inst_44426 = (state_44449[(7)]);
var tmp44461 = inst_44426;
var inst_44426__$1 = tmp44461;
var state_44449__$1 = (function (){var statearr_44465 = state_44449;
(statearr_44465[(7)] = inst_44426__$1);

return statearr_44465;
})();
var statearr_44466_44482 = state_44449__$1;
(statearr_44466_44482[(2)] = null);

(statearr_44466_44482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44472,out))
;
return ((function (switch__42662__auto__,c__42750__auto___44472,out){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44467 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44467[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44467[(1)] = (1));

return statearr_44467;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44449){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44449);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44468){if((e44468 instanceof Object)){
var ex__42666__auto__ = e44468;
var statearr_44469_44483 = state_44449;
(statearr_44469_44483[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44449);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44468;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44484 = state_44449;
state_44449 = G__44484;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44449){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44449);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44472,out))
})();
var state__42752__auto__ = (function (){var statearr_44470 = f__42751__auto__.call(null);
(statearr_44470[(6)] = c__42750__auto___44472);

return statearr_44470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44472,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__44486 = arguments.length;
switch (G__44486) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42750__auto___44552 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44552,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44552,out){
return (function (state_44524){
var state_val_44525 = (state_44524[(1)]);
if((state_val_44525 === (7))){
var inst_44520 = (state_44524[(2)]);
var state_44524__$1 = state_44524;
var statearr_44526_44553 = state_44524__$1;
(statearr_44526_44553[(2)] = inst_44520);

(statearr_44526_44553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (1))){
var inst_44487 = (new Array(n));
var inst_44488 = inst_44487;
var inst_44489 = (0);
var state_44524__$1 = (function (){var statearr_44527 = state_44524;
(statearr_44527[(7)] = inst_44489);

(statearr_44527[(8)] = inst_44488);

return statearr_44527;
})();
var statearr_44528_44554 = state_44524__$1;
(statearr_44528_44554[(2)] = null);

(statearr_44528_44554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (4))){
var inst_44492 = (state_44524[(9)]);
var inst_44492__$1 = (state_44524[(2)]);
var inst_44493 = (inst_44492__$1 == null);
var inst_44494 = cljs.core.not.call(null,inst_44493);
var state_44524__$1 = (function (){var statearr_44529 = state_44524;
(statearr_44529[(9)] = inst_44492__$1);

return statearr_44529;
})();
if(inst_44494){
var statearr_44530_44555 = state_44524__$1;
(statearr_44530_44555[(1)] = (5));

} else {
var statearr_44531_44556 = state_44524__$1;
(statearr_44531_44556[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (15))){
var inst_44514 = (state_44524[(2)]);
var state_44524__$1 = state_44524;
var statearr_44532_44557 = state_44524__$1;
(statearr_44532_44557[(2)] = inst_44514);

(statearr_44532_44557[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (13))){
var state_44524__$1 = state_44524;
var statearr_44533_44558 = state_44524__$1;
(statearr_44533_44558[(2)] = null);

(statearr_44533_44558[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (6))){
var inst_44489 = (state_44524[(7)]);
var inst_44510 = (inst_44489 > (0));
var state_44524__$1 = state_44524;
if(cljs.core.truth_(inst_44510)){
var statearr_44534_44559 = state_44524__$1;
(statearr_44534_44559[(1)] = (12));

} else {
var statearr_44535_44560 = state_44524__$1;
(statearr_44535_44560[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (3))){
var inst_44522 = (state_44524[(2)]);
var state_44524__$1 = state_44524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44524__$1,inst_44522);
} else {
if((state_val_44525 === (12))){
var inst_44488 = (state_44524[(8)]);
var inst_44512 = cljs.core.vec.call(null,inst_44488);
var state_44524__$1 = state_44524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44524__$1,(15),out,inst_44512);
} else {
if((state_val_44525 === (2))){
var state_44524__$1 = state_44524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44524__$1,(4),ch);
} else {
if((state_val_44525 === (11))){
var inst_44504 = (state_44524[(2)]);
var inst_44505 = (new Array(n));
var inst_44488 = inst_44505;
var inst_44489 = (0);
var state_44524__$1 = (function (){var statearr_44536 = state_44524;
(statearr_44536[(7)] = inst_44489);

(statearr_44536[(8)] = inst_44488);

(statearr_44536[(10)] = inst_44504);

return statearr_44536;
})();
var statearr_44537_44561 = state_44524__$1;
(statearr_44537_44561[(2)] = null);

(statearr_44537_44561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (9))){
var inst_44488 = (state_44524[(8)]);
var inst_44502 = cljs.core.vec.call(null,inst_44488);
var state_44524__$1 = state_44524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44524__$1,(11),out,inst_44502);
} else {
if((state_val_44525 === (5))){
var inst_44489 = (state_44524[(7)]);
var inst_44488 = (state_44524[(8)]);
var inst_44492 = (state_44524[(9)]);
var inst_44497 = (state_44524[(11)]);
var inst_44496 = (inst_44488[inst_44489] = inst_44492);
var inst_44497__$1 = (inst_44489 + (1));
var inst_44498 = (inst_44497__$1 < n);
var state_44524__$1 = (function (){var statearr_44538 = state_44524;
(statearr_44538[(11)] = inst_44497__$1);

(statearr_44538[(12)] = inst_44496);

return statearr_44538;
})();
if(cljs.core.truth_(inst_44498)){
var statearr_44539_44562 = state_44524__$1;
(statearr_44539_44562[(1)] = (8));

} else {
var statearr_44540_44563 = state_44524__$1;
(statearr_44540_44563[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (14))){
var inst_44517 = (state_44524[(2)]);
var inst_44518 = cljs.core.async.close_BANG_.call(null,out);
var state_44524__$1 = (function (){var statearr_44542 = state_44524;
(statearr_44542[(13)] = inst_44517);

return statearr_44542;
})();
var statearr_44543_44564 = state_44524__$1;
(statearr_44543_44564[(2)] = inst_44518);

(statearr_44543_44564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (10))){
var inst_44508 = (state_44524[(2)]);
var state_44524__$1 = state_44524;
var statearr_44544_44565 = state_44524__$1;
(statearr_44544_44565[(2)] = inst_44508);

(statearr_44544_44565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44525 === (8))){
var inst_44488 = (state_44524[(8)]);
var inst_44497 = (state_44524[(11)]);
var tmp44541 = inst_44488;
var inst_44488__$1 = tmp44541;
var inst_44489 = inst_44497;
var state_44524__$1 = (function (){var statearr_44545 = state_44524;
(statearr_44545[(7)] = inst_44489);

(statearr_44545[(8)] = inst_44488__$1);

return statearr_44545;
})();
var statearr_44546_44566 = state_44524__$1;
(statearr_44546_44566[(2)] = null);

(statearr_44546_44566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44552,out))
;
return ((function (switch__42662__auto__,c__42750__auto___44552,out){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44547[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44547[(1)] = (1));

return statearr_44547;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44524){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44548){if((e44548 instanceof Object)){
var ex__42666__auto__ = e44548;
var statearr_44549_44567 = state_44524;
(statearr_44549_44567[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44548;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44568 = state_44524;
state_44524 = G__44568;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44524);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44552,out))
})();
var state__42752__auto__ = (function (){var statearr_44550 = f__42751__auto__.call(null);
(statearr_44550[(6)] = c__42750__auto___44552);

return statearr_44550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44552,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__44570 = arguments.length;
switch (G__44570) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42750__auto___44640 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___44640,out){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___44640,out){
return (function (state_44612){
var state_val_44613 = (state_44612[(1)]);
if((state_val_44613 === (7))){
var inst_44608 = (state_44612[(2)]);
var state_44612__$1 = state_44612;
var statearr_44614_44641 = state_44612__$1;
(statearr_44614_44641[(2)] = inst_44608);

(statearr_44614_44641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (1))){
var inst_44571 = [];
var inst_44572 = inst_44571;
var inst_44573 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_44612__$1 = (function (){var statearr_44615 = state_44612;
(statearr_44615[(7)] = inst_44573);

(statearr_44615[(8)] = inst_44572);

return statearr_44615;
})();
var statearr_44616_44642 = state_44612__$1;
(statearr_44616_44642[(2)] = null);

(statearr_44616_44642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (4))){
var inst_44576 = (state_44612[(9)]);
var inst_44576__$1 = (state_44612[(2)]);
var inst_44577 = (inst_44576__$1 == null);
var inst_44578 = cljs.core.not.call(null,inst_44577);
var state_44612__$1 = (function (){var statearr_44617 = state_44612;
(statearr_44617[(9)] = inst_44576__$1);

return statearr_44617;
})();
if(inst_44578){
var statearr_44618_44643 = state_44612__$1;
(statearr_44618_44643[(1)] = (5));

} else {
var statearr_44619_44644 = state_44612__$1;
(statearr_44619_44644[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (15))){
var inst_44602 = (state_44612[(2)]);
var state_44612__$1 = state_44612;
var statearr_44620_44645 = state_44612__$1;
(statearr_44620_44645[(2)] = inst_44602);

(statearr_44620_44645[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (13))){
var state_44612__$1 = state_44612;
var statearr_44621_44646 = state_44612__$1;
(statearr_44621_44646[(2)] = null);

(statearr_44621_44646[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (6))){
var inst_44572 = (state_44612[(8)]);
var inst_44597 = inst_44572.length;
var inst_44598 = (inst_44597 > (0));
var state_44612__$1 = state_44612;
if(cljs.core.truth_(inst_44598)){
var statearr_44622_44647 = state_44612__$1;
(statearr_44622_44647[(1)] = (12));

} else {
var statearr_44623_44648 = state_44612__$1;
(statearr_44623_44648[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (3))){
var inst_44610 = (state_44612[(2)]);
var state_44612__$1 = state_44612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44612__$1,inst_44610);
} else {
if((state_val_44613 === (12))){
var inst_44572 = (state_44612[(8)]);
var inst_44600 = cljs.core.vec.call(null,inst_44572);
var state_44612__$1 = state_44612;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44612__$1,(15),out,inst_44600);
} else {
if((state_val_44613 === (2))){
var state_44612__$1 = state_44612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44612__$1,(4),ch);
} else {
if((state_val_44613 === (11))){
var inst_44576 = (state_44612[(9)]);
var inst_44580 = (state_44612[(10)]);
var inst_44590 = (state_44612[(2)]);
var inst_44591 = [];
var inst_44592 = inst_44591.push(inst_44576);
var inst_44572 = inst_44591;
var inst_44573 = inst_44580;
var state_44612__$1 = (function (){var statearr_44624 = state_44612;
(statearr_44624[(11)] = inst_44592);

(statearr_44624[(12)] = inst_44590);

(statearr_44624[(7)] = inst_44573);

(statearr_44624[(8)] = inst_44572);

return statearr_44624;
})();
var statearr_44625_44649 = state_44612__$1;
(statearr_44625_44649[(2)] = null);

(statearr_44625_44649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (9))){
var inst_44572 = (state_44612[(8)]);
var inst_44588 = cljs.core.vec.call(null,inst_44572);
var state_44612__$1 = state_44612;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44612__$1,(11),out,inst_44588);
} else {
if((state_val_44613 === (5))){
var inst_44576 = (state_44612[(9)]);
var inst_44580 = (state_44612[(10)]);
var inst_44573 = (state_44612[(7)]);
var inst_44580__$1 = f.call(null,inst_44576);
var inst_44581 = cljs.core._EQ_.call(null,inst_44580__$1,inst_44573);
var inst_44582 = cljs.core.keyword_identical_QMARK_.call(null,inst_44573,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_44583 = (inst_44581) || (inst_44582);
var state_44612__$1 = (function (){var statearr_44626 = state_44612;
(statearr_44626[(10)] = inst_44580__$1);

return statearr_44626;
})();
if(cljs.core.truth_(inst_44583)){
var statearr_44627_44650 = state_44612__$1;
(statearr_44627_44650[(1)] = (8));

} else {
var statearr_44628_44651 = state_44612__$1;
(statearr_44628_44651[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (14))){
var inst_44605 = (state_44612[(2)]);
var inst_44606 = cljs.core.async.close_BANG_.call(null,out);
var state_44612__$1 = (function (){var statearr_44630 = state_44612;
(statearr_44630[(13)] = inst_44605);

return statearr_44630;
})();
var statearr_44631_44652 = state_44612__$1;
(statearr_44631_44652[(2)] = inst_44606);

(statearr_44631_44652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (10))){
var inst_44595 = (state_44612[(2)]);
var state_44612__$1 = state_44612;
var statearr_44632_44653 = state_44612__$1;
(statearr_44632_44653[(2)] = inst_44595);

(statearr_44632_44653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44613 === (8))){
var inst_44576 = (state_44612[(9)]);
var inst_44580 = (state_44612[(10)]);
var inst_44572 = (state_44612[(8)]);
var inst_44585 = inst_44572.push(inst_44576);
var tmp44629 = inst_44572;
var inst_44572__$1 = tmp44629;
var inst_44573 = inst_44580;
var state_44612__$1 = (function (){var statearr_44633 = state_44612;
(statearr_44633[(14)] = inst_44585);

(statearr_44633[(7)] = inst_44573);

(statearr_44633[(8)] = inst_44572__$1);

return statearr_44633;
})();
var statearr_44634_44654 = state_44612__$1;
(statearr_44634_44654[(2)] = null);

(statearr_44634_44654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___44640,out))
;
return ((function (switch__42662__auto__,c__42750__auto___44640,out){
return (function() {
var cljs$core$async$state_machine__42663__auto__ = null;
var cljs$core$async$state_machine__42663__auto____0 = (function (){
var statearr_44635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44635[(0)] = cljs$core$async$state_machine__42663__auto__);

(statearr_44635[(1)] = (1));

return statearr_44635;
});
var cljs$core$async$state_machine__42663__auto____1 = (function (state_44612){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_44612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e44636){if((e44636 instanceof Object)){
var ex__42666__auto__ = e44636;
var statearr_44637_44655 = state_44612;
(statearr_44637_44655[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44612);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44636;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44656 = state_44612;
state_44612 = G__44656;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
cljs$core$async$state_machine__42663__auto__ = function(state_44612){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42663__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42663__auto____1.call(this,state_44612);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42663__auto____0;
cljs$core$async$state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42663__auto____1;
return cljs$core$async$state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___44640,out))
})();
var state__42752__auto__ = (function (){var statearr_44638 = f__42751__auto__.call(null);
(statearr_44638[(6)] = c__42750__auto___44640);

return statearr_44638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___44640,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1503392486751
