// Compiled by ClojureScript 1.9.854 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.12";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("#js "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e46600){if((e46600 instanceof Error)){
var e = e46600;
return "Error: Unable to stringify";
} else {
throw e46600;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__46603 = arguments.length;
switch (G__46603) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__46601_SHARP_){
if(typeof p1__46601_SHARP_ === 'string'){
return p1__46601_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__46601_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29124__auto__ = [];
var len__29117__auto___46606 = arguments.length;
var i__29118__auto___46607 = (0);
while(true){
if((i__29118__auto___46607 < len__29117__auto___46606)){
args__29124__auto__.push((arguments[i__29118__auto___46607]));

var G__46608 = (i__29118__auto___46607 + (1));
i__29118__auto___46607 = G__46608;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((0) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29125__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq46605){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46605));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29124__auto__ = [];
var len__29117__auto___46610 = arguments.length;
var i__29118__auto___46611 = (0);
while(true){
if((i__29118__auto___46611 < len__29117__auto___46610)){
args__29124__auto__.push((arguments[i__29118__auto___46611]));

var G__46612 = (i__29118__auto___46611 + (1));
i__29118__auto___46611 = G__46612;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((0) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29125__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq46609){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46609));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__46613){
var map__46614 = p__46613;
var map__46614__$1 = ((((!((map__46614 == null)))?((((map__46614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46614.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46614):map__46614);
var message = cljs.core.get.call(null,map__46614__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__46614__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__27953__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__27941__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__27941__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__27941__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__42750__auto___46693 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___46693,ch){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___46693,ch){
return (function (state_46665){
var state_val_46666 = (state_46665[(1)]);
if((state_val_46666 === (7))){
var inst_46661 = (state_46665[(2)]);
var state_46665__$1 = state_46665;
var statearr_46667_46694 = state_46665__$1;
(statearr_46667_46694[(2)] = inst_46661);

(statearr_46667_46694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (1))){
var state_46665__$1 = state_46665;
var statearr_46668_46695 = state_46665__$1;
(statearr_46668_46695[(2)] = null);

(statearr_46668_46695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (4))){
var inst_46618 = (state_46665[(7)]);
var inst_46618__$1 = (state_46665[(2)]);
var state_46665__$1 = (function (){var statearr_46669 = state_46665;
(statearr_46669[(7)] = inst_46618__$1);

return statearr_46669;
})();
if(cljs.core.truth_(inst_46618__$1)){
var statearr_46670_46696 = state_46665__$1;
(statearr_46670_46696[(1)] = (5));

} else {
var statearr_46671_46697 = state_46665__$1;
(statearr_46671_46697[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (15))){
var inst_46625 = (state_46665[(8)]);
var inst_46640 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_46625);
var inst_46641 = cljs.core.first.call(null,inst_46640);
var inst_46642 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_46641);
var inst_46643 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46642)].join('');
var inst_46644 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_46643);
var state_46665__$1 = state_46665;
var statearr_46672_46698 = state_46665__$1;
(statearr_46672_46698[(2)] = inst_46644);

(statearr_46672_46698[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (13))){
var inst_46649 = (state_46665[(2)]);
var state_46665__$1 = state_46665;
var statearr_46673_46699 = state_46665__$1;
(statearr_46673_46699[(2)] = inst_46649);

(statearr_46673_46699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (6))){
var state_46665__$1 = state_46665;
var statearr_46674_46700 = state_46665__$1;
(statearr_46674_46700[(2)] = null);

(statearr_46674_46700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (17))){
var inst_46647 = (state_46665[(2)]);
var state_46665__$1 = state_46665;
var statearr_46675_46701 = state_46665__$1;
(statearr_46675_46701[(2)] = inst_46647);

(statearr_46675_46701[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (3))){
var inst_46663 = (state_46665[(2)]);
var state_46665__$1 = state_46665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46665__$1,inst_46663);
} else {
if((state_val_46666 === (12))){
var inst_46624 = (state_46665[(9)]);
var inst_46638 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_46624,opts);
var state_46665__$1 = state_46665;
if(cljs.core.truth_(inst_46638)){
var statearr_46676_46702 = state_46665__$1;
(statearr_46676_46702[(1)] = (15));

} else {
var statearr_46677_46703 = state_46665__$1;
(statearr_46677_46703[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (2))){
var state_46665__$1 = state_46665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46665__$1,(4),ch);
} else {
if((state_val_46666 === (11))){
var inst_46625 = (state_46665[(8)]);
var inst_46630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46631 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_46625);
var inst_46632 = cljs.core.async.timeout.call(null,(1000));
var inst_46633 = [inst_46631,inst_46632];
var inst_46634 = (new cljs.core.PersistentVector(null,2,(5),inst_46630,inst_46633,null));
var state_46665__$1 = state_46665;
return cljs.core.async.ioc_alts_BANG_.call(null,state_46665__$1,(14),inst_46634);
} else {
if((state_val_46666 === (9))){
var inst_46625 = (state_46665[(8)]);
var inst_46651 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_46652 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_46625);
var inst_46653 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_46652);
var inst_46654 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46653)].join('');
var inst_46655 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_46654);
var state_46665__$1 = (function (){var statearr_46678 = state_46665;
(statearr_46678[(10)] = inst_46651);

return statearr_46678;
})();
var statearr_46679_46704 = state_46665__$1;
(statearr_46679_46704[(2)] = inst_46655);

(statearr_46679_46704[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (5))){
var inst_46618 = (state_46665[(7)]);
var inst_46620 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_46621 = (new cljs.core.PersistentArrayMap(null,2,inst_46620,null));
var inst_46622 = (new cljs.core.PersistentHashSet(null,inst_46621,null));
var inst_46623 = figwheel.client.focus_msgs.call(null,inst_46622,inst_46618);
var inst_46624 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_46623);
var inst_46625 = cljs.core.first.call(null,inst_46623);
var inst_46626 = figwheel.client.autoload_QMARK_.call(null);
var state_46665__$1 = (function (){var statearr_46680 = state_46665;
(statearr_46680[(9)] = inst_46624);

(statearr_46680[(8)] = inst_46625);

return statearr_46680;
})();
if(cljs.core.truth_(inst_46626)){
var statearr_46681_46705 = state_46665__$1;
(statearr_46681_46705[(1)] = (8));

} else {
var statearr_46682_46706 = state_46665__$1;
(statearr_46682_46706[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (14))){
var inst_46636 = (state_46665[(2)]);
var state_46665__$1 = state_46665;
var statearr_46683_46707 = state_46665__$1;
(statearr_46683_46707[(2)] = inst_46636);

(statearr_46683_46707[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (16))){
var state_46665__$1 = state_46665;
var statearr_46684_46708 = state_46665__$1;
(statearr_46684_46708[(2)] = null);

(statearr_46684_46708[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (10))){
var inst_46657 = (state_46665[(2)]);
var state_46665__$1 = (function (){var statearr_46685 = state_46665;
(statearr_46685[(11)] = inst_46657);

return statearr_46685;
})();
var statearr_46686_46709 = state_46665__$1;
(statearr_46686_46709[(2)] = null);

(statearr_46686_46709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46666 === (8))){
var inst_46624 = (state_46665[(9)]);
var inst_46628 = figwheel.client.reload_file_state_QMARK_.call(null,inst_46624,opts);
var state_46665__$1 = state_46665;
if(cljs.core.truth_(inst_46628)){
var statearr_46687_46710 = state_46665__$1;
(statearr_46687_46710[(1)] = (11));

} else {
var statearr_46688_46711 = state_46665__$1;
(statearr_46688_46711[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto___46693,ch))
;
return ((function (switch__42662__auto__,c__42750__auto___46693,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__42663__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__42663__auto____0 = (function (){
var statearr_46689 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46689[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__42663__auto__);

(statearr_46689[(1)] = (1));

return statearr_46689;
});
var figwheel$client$file_reloader_plugin_$_state_machine__42663__auto____1 = (function (state_46665){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_46665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e46690){if((e46690 instanceof Object)){
var ex__42666__auto__ = e46690;
var statearr_46691_46712 = state_46665;
(statearr_46691_46712[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46665);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46690;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46713 = state_46665;
state_46665 = G__46713;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__42663__auto__ = function(state_46665){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__42663__auto____1.call(this,state_46665);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__42663__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__42663__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___46693,ch))
})();
var state__42752__auto__ = (function (){var statearr_46692 = f__42751__auto__.call(null);
(statearr_46692[(6)] = c__42750__auto___46693);

return statearr_46692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___46693,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__46714_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__46714_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_46716 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_46716){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e46715){if((e46715 instanceof Error)){
var e = e46715;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_46716], null));
} else {
var e = e46715;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_46716))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__46717){
var map__46718 = p__46717;
var map__46718__$1 = ((((!((map__46718 == null)))?((((map__46718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46718.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46718):map__46718);
var opts = map__46718__$1;
var build_id = cljs.core.get.call(null,map__46718__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__46718,map__46718__$1,opts,build_id){
return (function (p__46720){
var vec__46721 = p__46720;
var seq__46722 = cljs.core.seq.call(null,vec__46721);
var first__46723 = cljs.core.first.call(null,seq__46722);
var seq__46722__$1 = cljs.core.next.call(null,seq__46722);
var map__46724 = first__46723;
var map__46724__$1 = ((((!((map__46724 == null)))?((((map__46724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46724.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46724):map__46724);
var msg = map__46724__$1;
var msg_name = cljs.core.get.call(null,map__46724__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__46722__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__46721,seq__46722,first__46723,seq__46722__$1,map__46724,map__46724__$1,msg,msg_name,_,map__46718,map__46718__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__46721,seq__46722,first__46723,seq__46722__$1,map__46724,map__46724__$1,msg,msg_name,_,map__46718,map__46718__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__46718,map__46718__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__46726){
var vec__46727 = p__46726;
var seq__46728 = cljs.core.seq.call(null,vec__46727);
var first__46729 = cljs.core.first.call(null,seq__46728);
var seq__46728__$1 = cljs.core.next.call(null,seq__46728);
var map__46730 = first__46729;
var map__46730__$1 = ((((!((map__46730 == null)))?((((map__46730.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46730.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46730):map__46730);
var msg = map__46730__$1;
var msg_name = cljs.core.get.call(null,map__46730__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__46728__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__46732){
var map__46733 = p__46732;
var map__46733__$1 = ((((!((map__46733 == null)))?((((map__46733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46733.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46733):map__46733);
var on_compile_warning = cljs.core.get.call(null,map__46733__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__46733__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__46733,map__46733__$1,on_compile_warning,on_compile_fail){
return (function (p__46735){
var vec__46736 = p__46735;
var seq__46737 = cljs.core.seq.call(null,vec__46736);
var first__46738 = cljs.core.first.call(null,seq__46737);
var seq__46737__$1 = cljs.core.next.call(null,seq__46737);
var map__46739 = first__46738;
var map__46739__$1 = ((((!((map__46739 == null)))?((((map__46739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46739.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46739):map__46739);
var msg = map__46739__$1;
var msg_name = cljs.core.get.call(null,map__46739__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__46737__$1;
var pred__46741 = cljs.core._EQ_;
var expr__46742 = msg_name;
if(cljs.core.truth_(pred__46741.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__46742))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__46741.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__46742))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__46733,map__46733__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__,msg_hist,msg_names,msg){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__,msg_hist,msg_names,msg){
return (function (state_46831){
var state_val_46832 = (state_46831[(1)]);
if((state_val_46832 === (7))){
var inst_46751 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46751)){
var statearr_46833_46880 = state_46831__$1;
(statearr_46833_46880[(1)] = (8));

} else {
var statearr_46834_46881 = state_46831__$1;
(statearr_46834_46881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (20))){
var inst_46825 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46835_46882 = state_46831__$1;
(statearr_46835_46882[(2)] = inst_46825);

(statearr_46835_46882[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (27))){
var inst_46821 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46836_46883 = state_46831__$1;
(statearr_46836_46883[(2)] = inst_46821);

(statearr_46836_46883[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (1))){
var inst_46744 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46744)){
var statearr_46837_46884 = state_46831__$1;
(statearr_46837_46884[(1)] = (2));

} else {
var statearr_46838_46885 = state_46831__$1;
(statearr_46838_46885[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (24))){
var inst_46823 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46839_46886 = state_46831__$1;
(statearr_46839_46886[(2)] = inst_46823);

(statearr_46839_46886[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (4))){
var inst_46829 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46831__$1,inst_46829);
} else {
if((state_val_46832 === (15))){
var inst_46827 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46840_46887 = state_46831__$1;
(statearr_46840_46887[(2)] = inst_46827);

(statearr_46840_46887[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (21))){
var inst_46780 = (state_46831[(2)]);
var inst_46781 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46782 = figwheel.client.auto_jump_to_error.call(null,opts,inst_46781);
var state_46831__$1 = (function (){var statearr_46841 = state_46831;
(statearr_46841[(7)] = inst_46780);

return statearr_46841;
})();
var statearr_46842_46888 = state_46831__$1;
(statearr_46842_46888[(2)] = inst_46782);

(statearr_46842_46888[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (31))){
var inst_46810 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46810)){
var statearr_46843_46889 = state_46831__$1;
(statearr_46843_46889[(1)] = (34));

} else {
var statearr_46844_46890 = state_46831__$1;
(statearr_46844_46890[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (32))){
var inst_46819 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46845_46891 = state_46831__$1;
(statearr_46845_46891[(2)] = inst_46819);

(statearr_46845_46891[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (33))){
var inst_46806 = (state_46831[(2)]);
var inst_46807 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46808 = figwheel.client.auto_jump_to_error.call(null,opts,inst_46807);
var state_46831__$1 = (function (){var statearr_46846 = state_46831;
(statearr_46846[(8)] = inst_46806);

return statearr_46846;
})();
var statearr_46847_46892 = state_46831__$1;
(statearr_46847_46892[(2)] = inst_46808);

(statearr_46847_46892[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (13))){
var inst_46765 = figwheel.client.heads_up.clear.call(null);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(16),inst_46765);
} else {
if((state_val_46832 === (22))){
var inst_46786 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46787 = figwheel.client.heads_up.append_warning_message.call(null,inst_46786);
var state_46831__$1 = state_46831;
var statearr_46848_46893 = state_46831__$1;
(statearr_46848_46893[(2)] = inst_46787);

(statearr_46848_46893[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (36))){
var inst_46817 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46849_46894 = state_46831__$1;
(statearr_46849_46894[(2)] = inst_46817);

(statearr_46849_46894[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (29))){
var inst_46797 = (state_46831[(2)]);
var inst_46798 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46799 = figwheel.client.auto_jump_to_error.call(null,opts,inst_46798);
var state_46831__$1 = (function (){var statearr_46850 = state_46831;
(statearr_46850[(9)] = inst_46797);

return statearr_46850;
})();
var statearr_46851_46895 = state_46831__$1;
(statearr_46851_46895[(2)] = inst_46799);

(statearr_46851_46895[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (6))){
var inst_46746 = (state_46831[(10)]);
var state_46831__$1 = state_46831;
var statearr_46852_46896 = state_46831__$1;
(statearr_46852_46896[(2)] = inst_46746);

(statearr_46852_46896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (28))){
var inst_46793 = (state_46831[(2)]);
var inst_46794 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46795 = figwheel.client.heads_up.display_warning.call(null,inst_46794);
var state_46831__$1 = (function (){var statearr_46853 = state_46831;
(statearr_46853[(11)] = inst_46793);

return statearr_46853;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(29),inst_46795);
} else {
if((state_val_46832 === (25))){
var inst_46791 = figwheel.client.heads_up.clear.call(null);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(28),inst_46791);
} else {
if((state_val_46832 === (34))){
var inst_46812 = figwheel.client.heads_up.flash_loaded.call(null);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(37),inst_46812);
} else {
if((state_val_46832 === (17))){
var inst_46771 = (state_46831[(2)]);
var inst_46772 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46773 = figwheel.client.auto_jump_to_error.call(null,opts,inst_46772);
var state_46831__$1 = (function (){var statearr_46854 = state_46831;
(statearr_46854[(12)] = inst_46771);

return statearr_46854;
})();
var statearr_46855_46897 = state_46831__$1;
(statearr_46855_46897[(2)] = inst_46773);

(statearr_46855_46897[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (3))){
var inst_46763 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46763)){
var statearr_46856_46898 = state_46831__$1;
(statearr_46856_46898[(1)] = (13));

} else {
var statearr_46857_46899 = state_46831__$1;
(statearr_46857_46899[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (12))){
var inst_46759 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46858_46900 = state_46831__$1;
(statearr_46858_46900[(2)] = inst_46759);

(statearr_46858_46900[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (2))){
var inst_46746 = (state_46831[(10)]);
var inst_46746__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_46831__$1 = (function (){var statearr_46859 = state_46831;
(statearr_46859[(10)] = inst_46746__$1);

return statearr_46859;
})();
if(cljs.core.truth_(inst_46746__$1)){
var statearr_46860_46901 = state_46831__$1;
(statearr_46860_46901[(1)] = (5));

} else {
var statearr_46861_46902 = state_46831__$1;
(statearr_46861_46902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (23))){
var inst_46789 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46789)){
var statearr_46862_46903 = state_46831__$1;
(statearr_46862_46903[(1)] = (25));

} else {
var statearr_46863_46904 = state_46831__$1;
(statearr_46863_46904[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (35))){
var state_46831__$1 = state_46831;
var statearr_46864_46905 = state_46831__$1;
(statearr_46864_46905[(2)] = null);

(statearr_46864_46905[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (19))){
var inst_46784 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46784)){
var statearr_46865_46906 = state_46831__$1;
(statearr_46865_46906[(1)] = (22));

} else {
var statearr_46866_46907 = state_46831__$1;
(statearr_46866_46907[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (11))){
var inst_46755 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46867_46908 = state_46831__$1;
(statearr_46867_46908[(2)] = inst_46755);

(statearr_46867_46908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (9))){
var inst_46757 = figwheel.client.heads_up.clear.call(null);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(12),inst_46757);
} else {
if((state_val_46832 === (5))){
var inst_46748 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_46831__$1 = state_46831;
var statearr_46868_46909 = state_46831__$1;
(statearr_46868_46909[(2)] = inst_46748);

(statearr_46868_46909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (14))){
var inst_46775 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46775)){
var statearr_46869_46910 = state_46831__$1;
(statearr_46869_46910[(1)] = (18));

} else {
var statearr_46870_46911 = state_46831__$1;
(statearr_46870_46911[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (26))){
var inst_46801 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_46831__$1 = state_46831;
if(cljs.core.truth_(inst_46801)){
var statearr_46871_46912 = state_46831__$1;
(statearr_46871_46912[(1)] = (30));

} else {
var statearr_46872_46913 = state_46831__$1;
(statearr_46872_46913[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (16))){
var inst_46767 = (state_46831[(2)]);
var inst_46768 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46769 = figwheel.client.heads_up.display_exception.call(null,inst_46768);
var state_46831__$1 = (function (){var statearr_46873 = state_46831;
(statearr_46873[(13)] = inst_46767);

return statearr_46873;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(17),inst_46769);
} else {
if((state_val_46832 === (30))){
var inst_46803 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46804 = figwheel.client.heads_up.display_warning.call(null,inst_46803);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(33),inst_46804);
} else {
if((state_val_46832 === (10))){
var inst_46761 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46874_46914 = state_46831__$1;
(statearr_46874_46914[(2)] = inst_46761);

(statearr_46874_46914[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (18))){
var inst_46777 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_46778 = figwheel.client.heads_up.display_exception.call(null,inst_46777);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(21),inst_46778);
} else {
if((state_val_46832 === (37))){
var inst_46814 = (state_46831[(2)]);
var state_46831__$1 = state_46831;
var statearr_46875_46915 = state_46831__$1;
(statearr_46875_46915[(2)] = inst_46814);

(statearr_46875_46915[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46832 === (8))){
var inst_46753 = figwheel.client.heads_up.flash_loaded.call(null);
var state_46831__$1 = state_46831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46831__$1,(11),inst_46753);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42750__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__42662__auto__,c__42750__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto____0 = (function (){
var statearr_46876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46876[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto__);

(statearr_46876[(1)] = (1));

return statearr_46876;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto____1 = (function (state_46831){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_46831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e46877){if((e46877 instanceof Object)){
var ex__42666__auto__ = e46877;
var statearr_46878_46916 = state_46831;
(statearr_46878_46916[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46917 = state_46831;
state_46831 = G__46917;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto__ = function(state_46831){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto____1.call(this,state_46831);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__,msg_hist,msg_names,msg))
})();
var state__42752__auto__ = (function (){var statearr_46879 = f__42751__auto__.call(null);
(statearr_46879[(6)] = c__42750__auto__);

return statearr_46879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__,msg_hist,msg_names,msg))
);

return c__42750__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__42750__auto___46946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto___46946,ch){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto___46946,ch){
return (function (state_46932){
var state_val_46933 = (state_46932[(1)]);
if((state_val_46933 === (1))){
var state_46932__$1 = state_46932;
var statearr_46934_46947 = state_46932__$1;
(statearr_46934_46947[(2)] = null);

(statearr_46934_46947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46933 === (2))){
var state_46932__$1 = state_46932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46932__$1,(4),ch);
} else {
if((state_val_46933 === (3))){
var inst_46930 = (state_46932[(2)]);
var state_46932__$1 = state_46932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46932__$1,inst_46930);
} else {
if((state_val_46933 === (4))){
var inst_46920 = (state_46932[(7)]);
var inst_46920__$1 = (state_46932[(2)]);
var state_46932__$1 = (function (){var statearr_46935 = state_46932;
(statearr_46935[(7)] = inst_46920__$1);

return statearr_46935;
})();
if(cljs.core.truth_(inst_46920__$1)){
var statearr_46936_46948 = state_46932__$1;
(statearr_46936_46948[(1)] = (5));

} else {
var statearr_46937_46949 = state_46932__$1;
(statearr_46937_46949[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46933 === (5))){
var inst_46920 = (state_46932[(7)]);
var inst_46922 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_46920);
var state_46932__$1 = state_46932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46932__$1,(8),inst_46922);
} else {
if((state_val_46933 === (6))){
var state_46932__$1 = state_46932;
var statearr_46938_46950 = state_46932__$1;
(statearr_46938_46950[(2)] = null);

(statearr_46938_46950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46933 === (7))){
var inst_46928 = (state_46932[(2)]);
var state_46932__$1 = state_46932;
var statearr_46939_46951 = state_46932__$1;
(statearr_46939_46951[(2)] = inst_46928);

(statearr_46939_46951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46933 === (8))){
var inst_46924 = (state_46932[(2)]);
var state_46932__$1 = (function (){var statearr_46940 = state_46932;
(statearr_46940[(8)] = inst_46924);

return statearr_46940;
})();
var statearr_46941_46952 = state_46932__$1;
(statearr_46941_46952[(2)] = null);

(statearr_46941_46952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__42750__auto___46946,ch))
;
return ((function (switch__42662__auto__,c__42750__auto___46946,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__42663__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__42663__auto____0 = (function (){
var statearr_46942 = [null,null,null,null,null,null,null,null,null];
(statearr_46942[(0)] = figwheel$client$heads_up_plugin_$_state_machine__42663__auto__);

(statearr_46942[(1)] = (1));

return statearr_46942;
});
var figwheel$client$heads_up_plugin_$_state_machine__42663__auto____1 = (function (state_46932){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_46932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e46943){if((e46943 instanceof Object)){
var ex__42666__auto__ = e46943;
var statearr_46944_46953 = state_46932;
(statearr_46944_46953[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46943;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46954 = state_46932;
state_46932 = G__46954;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__42663__auto__ = function(state_46932){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__42663__auto____1.call(this,state_46932);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__42663__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__42663__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto___46946,ch))
})();
var state__42752__auto__ = (function (){var statearr_46945 = f__42751__auto__.call(null);
(statearr_46945[(6)] = c__42750__auto___46946);

return statearr_46945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto___46946,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__){
return (function (state_46960){
var state_val_46961 = (state_46960[(1)]);
if((state_val_46961 === (1))){
var inst_46955 = cljs.core.async.timeout.call(null,(3000));
var state_46960__$1 = state_46960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46960__$1,(2),inst_46955);
} else {
if((state_val_46961 === (2))){
var inst_46957 = (state_46960[(2)]);
var inst_46958 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_46960__$1 = (function (){var statearr_46962 = state_46960;
(statearr_46962[(7)] = inst_46957);

return statearr_46962;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46960__$1,inst_46958);
} else {
return null;
}
}
});})(c__42750__auto__))
;
return ((function (switch__42662__auto__,c__42750__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__42663__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__42663__auto____0 = (function (){
var statearr_46963 = [null,null,null,null,null,null,null,null];
(statearr_46963[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__42663__auto__);

(statearr_46963[(1)] = (1));

return statearr_46963;
});
var figwheel$client$enforce_project_plugin_$_state_machine__42663__auto____1 = (function (state_46960){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_46960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e46964){if((e46964 instanceof Object)){
var ex__42666__auto__ = e46964;
var statearr_46965_46967 = state_46960;
(statearr_46965_46967[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46968 = state_46960;
state_46960 = G__46968;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__42663__auto__ = function(state_46960){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__42663__auto____1.call(this,state_46960);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__42663__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__42663__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__))
})();
var state__42752__auto__ = (function (){var statearr_46966 = f__42751__auto__.call(null);
(statearr_46966[(6)] = c__42750__auto__);

return statearr_46966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__))
);

return c__42750__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__42750__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42750__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__42751__auto__ = (function (){var switch__42662__auto__ = ((function (c__42750__auto__,figwheel_version,temp__4657__auto__){
return (function (state_46975){
var state_val_46976 = (state_46975[(1)]);
if((state_val_46976 === (1))){
var inst_46969 = cljs.core.async.timeout.call(null,(2000));
var state_46975__$1 = state_46975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46975__$1,(2),inst_46969);
} else {
if((state_val_46976 === (2))){
var inst_46971 = (state_46975[(2)]);
var inst_46972 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_46973 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_46972);
var state_46975__$1 = (function (){var statearr_46977 = state_46975;
(statearr_46977[(7)] = inst_46971);

return statearr_46977;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46975__$1,inst_46973);
} else {
return null;
}
}
});})(c__42750__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__42662__auto__,c__42750__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto____0 = (function (){
var statearr_46978 = [null,null,null,null,null,null,null,null];
(statearr_46978[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto__);

(statearr_46978[(1)] = (1));

return statearr_46978;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto____1 = (function (state_46975){
while(true){
var ret_value__42664__auto__ = (function (){try{while(true){
var result__42665__auto__ = switch__42662__auto__.call(null,state_46975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42665__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42665__auto__;
}
break;
}
}catch (e46979){if((e46979 instanceof Object)){
var ex__42666__auto__ = e46979;
var statearr_46980_46982 = state_46975;
(statearr_46980_46982[(5)] = ex__42666__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46979;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46983 = state_46975;
state_46975 = G__46983;
continue;
} else {
return ret_value__42664__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto__ = function(state_46975){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto____1.call(this,state_46975);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42663__auto__;
})()
;})(switch__42662__auto__,c__42750__auto__,figwheel_version,temp__4657__auto__))
})();
var state__42752__auto__ = (function (){var statearr_46981 = f__42751__auto__.call(null);
(statearr_46981[(6)] = c__42750__auto__);

return statearr_46981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42752__auto__);
});})(c__42750__auto__,figwheel_version,temp__4657__auto__))
);

return c__42750__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__46984){
var map__46985 = p__46984;
var map__46985__$1 = ((((!((map__46985 == null)))?((((map__46985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46985.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46985):map__46985);
var file = cljs.core.get.call(null,map__46985__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__46985__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__46985__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__46987 = "";
var G__46987__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46987),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__46987);
var G__46987__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46987__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__46987__$1);
if(cljs.core.truth_((function (){var and__27941__auto__ = line;
if(cljs.core.truth_(and__27941__auto__)){
return column;
} else {
return and__27941__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46987__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__46987__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__46988){
var map__46989 = p__46988;
var map__46989__$1 = ((((!((map__46989 == null)))?((((map__46989.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46989.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46989):map__46989);
var ed = map__46989__$1;
var formatted_exception = cljs.core.get.call(null,map__46989__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__46989__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__46989__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__46991_46995 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__46992_46996 = null;
var count__46993_46997 = (0);
var i__46994_46998 = (0);
while(true){
if((i__46994_46998 < count__46993_46997)){
var msg_46999 = cljs.core._nth.call(null,chunk__46992_46996,i__46994_46998);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_46999);

var G__47000 = seq__46991_46995;
var G__47001 = chunk__46992_46996;
var G__47002 = count__46993_46997;
var G__47003 = (i__46994_46998 + (1));
seq__46991_46995 = G__47000;
chunk__46992_46996 = G__47001;
count__46993_46997 = G__47002;
i__46994_46998 = G__47003;
continue;
} else {
var temp__4657__auto___47004 = cljs.core.seq.call(null,seq__46991_46995);
if(temp__4657__auto___47004){
var seq__46991_47005__$1 = temp__4657__auto___47004;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46991_47005__$1)){
var c__28787__auto___47006 = cljs.core.chunk_first.call(null,seq__46991_47005__$1);
var G__47007 = cljs.core.chunk_rest.call(null,seq__46991_47005__$1);
var G__47008 = c__28787__auto___47006;
var G__47009 = cljs.core.count.call(null,c__28787__auto___47006);
var G__47010 = (0);
seq__46991_46995 = G__47007;
chunk__46992_46996 = G__47008;
count__46993_46997 = G__47009;
i__46994_46998 = G__47010;
continue;
} else {
var msg_47011 = cljs.core.first.call(null,seq__46991_47005__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_47011);

var G__47012 = cljs.core.next.call(null,seq__46991_47005__$1);
var G__47013 = null;
var G__47014 = (0);
var G__47015 = (0);
seq__46991_46995 = G__47012;
chunk__46992_46996 = G__47013;
count__46993_46997 = G__47014;
i__46994_46998 = G__47015;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__47016){
var map__47017 = p__47016;
var map__47017__$1 = ((((!((map__47017 == null)))?((((map__47017.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47017.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47017):map__47017);
var w = map__47017__$1;
var message = cljs.core.get.call(null,map__47017__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__27941__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__27941__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__27941__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__47019 = cljs.core.seq.call(null,plugins);
var chunk__47020 = null;
var count__47021 = (0);
var i__47022 = (0);
while(true){
if((i__47022 < count__47021)){
var vec__47023 = cljs.core._nth.call(null,chunk__47020,i__47022);
var k = cljs.core.nth.call(null,vec__47023,(0),null);
var plugin = cljs.core.nth.call(null,vec__47023,(1),null);
if(cljs.core.truth_(plugin)){
var pl_47029 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__47019,chunk__47020,count__47021,i__47022,pl_47029,vec__47023,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_47029.call(null,msg_hist);
});})(seq__47019,chunk__47020,count__47021,i__47022,pl_47029,vec__47023,k,plugin))
);
} else {
}

var G__47030 = seq__47019;
var G__47031 = chunk__47020;
var G__47032 = count__47021;
var G__47033 = (i__47022 + (1));
seq__47019 = G__47030;
chunk__47020 = G__47031;
count__47021 = G__47032;
i__47022 = G__47033;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__47019);
if(temp__4657__auto__){
var seq__47019__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47019__$1)){
var c__28787__auto__ = cljs.core.chunk_first.call(null,seq__47019__$1);
var G__47034 = cljs.core.chunk_rest.call(null,seq__47019__$1);
var G__47035 = c__28787__auto__;
var G__47036 = cljs.core.count.call(null,c__28787__auto__);
var G__47037 = (0);
seq__47019 = G__47034;
chunk__47020 = G__47035;
count__47021 = G__47036;
i__47022 = G__47037;
continue;
} else {
var vec__47026 = cljs.core.first.call(null,seq__47019__$1);
var k = cljs.core.nth.call(null,vec__47026,(0),null);
var plugin = cljs.core.nth.call(null,vec__47026,(1),null);
if(cljs.core.truth_(plugin)){
var pl_47038 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__47019,chunk__47020,count__47021,i__47022,pl_47038,vec__47026,k,plugin,seq__47019__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_47038.call(null,msg_hist);
});})(seq__47019,chunk__47020,count__47021,i__47022,pl_47038,vec__47026,k,plugin,seq__47019__$1,temp__4657__auto__))
);
} else {
}

var G__47039 = cljs.core.next.call(null,seq__47019__$1);
var G__47040 = null;
var G__47041 = (0);
var G__47042 = (0);
seq__47019 = G__47039;
chunk__47020 = G__47040;
count__47021 = G__47041;
i__47022 = G__47042;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__47044 = arguments.length;
switch (G__47044) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__47045_47050 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__47046_47051 = null;
var count__47047_47052 = (0);
var i__47048_47053 = (0);
while(true){
if((i__47048_47053 < count__47047_47052)){
var msg_47054 = cljs.core._nth.call(null,chunk__47046_47051,i__47048_47053);
figwheel.client.socket.handle_incoming_message.call(null,msg_47054);

var G__47055 = seq__47045_47050;
var G__47056 = chunk__47046_47051;
var G__47057 = count__47047_47052;
var G__47058 = (i__47048_47053 + (1));
seq__47045_47050 = G__47055;
chunk__47046_47051 = G__47056;
count__47047_47052 = G__47057;
i__47048_47053 = G__47058;
continue;
} else {
var temp__4657__auto___47059 = cljs.core.seq.call(null,seq__47045_47050);
if(temp__4657__auto___47059){
var seq__47045_47060__$1 = temp__4657__auto___47059;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47045_47060__$1)){
var c__28787__auto___47061 = cljs.core.chunk_first.call(null,seq__47045_47060__$1);
var G__47062 = cljs.core.chunk_rest.call(null,seq__47045_47060__$1);
var G__47063 = c__28787__auto___47061;
var G__47064 = cljs.core.count.call(null,c__28787__auto___47061);
var G__47065 = (0);
seq__47045_47050 = G__47062;
chunk__47046_47051 = G__47063;
count__47047_47052 = G__47064;
i__47048_47053 = G__47065;
continue;
} else {
var msg_47066 = cljs.core.first.call(null,seq__47045_47060__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_47066);

var G__47067 = cljs.core.next.call(null,seq__47045_47060__$1);
var G__47068 = null;
var G__47069 = (0);
var G__47070 = (0);
seq__47045_47050 = G__47067;
chunk__47046_47051 = G__47068;
count__47047_47052 = G__47069;
i__47048_47053 = G__47070;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29124__auto__ = [];
var len__29117__auto___47075 = arguments.length;
var i__29118__auto___47076 = (0);
while(true){
if((i__29118__auto___47076 < len__29117__auto___47075)){
args__29124__auto__.push((arguments[i__29118__auto___47076]));

var G__47077 = (i__29118__auto___47076 + (1));
i__29118__auto___47076 = G__47077;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((0) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29125__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__47072){
var map__47073 = p__47072;
var map__47073__$1 = ((((!((map__47073 == null)))?((((map__47073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47073.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47073):map__47073);
var opts = map__47073__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq47071){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq47071));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e47078){if((e47078 instanceof Error)){
var e = e47078;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e47078;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__47079){
var map__47080 = p__47079;
var map__47080__$1 = ((((!((map__47080 == null)))?((((map__47080.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47080.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47080):map__47080);
var msg_name = cljs.core.get.call(null,map__47080__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1503392489098
