// Compiled by ClojureScript 1.9.854 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30900 = arguments.length;
switch (G__30900) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30901 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30901 = (function (f,blockable,meta30902){
this.f = f;
this.blockable = blockable;
this.meta30902 = meta30902;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async30901.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30903,meta30902__$1){
var self__ = this;
var _30903__$1 = this;
return (new cljs.core.async.t_cljs$core$async30901(self__.f,self__.blockable,meta30902__$1));
});

cljs.core.async.t_cljs$core$async30901.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30903){
var self__ = this;
var _30903__$1 = this;
return self__.meta30902;
});

cljs.core.async.t_cljs$core$async30901.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30901.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30901.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30901.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30901.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30902","meta30902",1289423275,null)], null);
});

cljs.core.async.t_cljs$core$async30901.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30901.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30901";

cljs.core.async.t_cljs$core$async30901.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async30901");
});

cljs.core.async.__GT_t_cljs$core$async30901 = (function cljs$core$async$__GT_t_cljs$core$async30901(f__$1,blockable__$1,meta30902){
return (new cljs.core.async.t_cljs$core$async30901(f__$1,blockable__$1,meta30902));
});

}

return (new cljs.core.async.t_cljs$core$async30901(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30907 = arguments.length;
switch (G__30907) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30910 = arguments.length;
switch (G__30910) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30913 = arguments.length;
switch (G__30913) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_30915 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_30915);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_30915,ret){
return (function (){
return fn1.call(null,val_30915);
});})(val_30915,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30917 = arguments.length;
switch (G__30917) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28893__auto___30919 = n;
var x_30920 = (0);
while(true){
if((x_30920 < n__28893__auto___30919)){
(a[x_30920] = (0));

var G__30921 = (x_30920 + (1));
x_30920 = G__30921;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__30922 = (i + (1));
i = G__30922;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async30923 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30923 = (function (flag,meta30924){
this.flag = flag;
this.meta30924 = meta30924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async30923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30925,meta30924__$1){
var self__ = this;
var _30925__$1 = this;
return (new cljs.core.async.t_cljs$core$async30923(self__.flag,meta30924__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async30923.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30925){
var self__ = this;
var _30925__$1 = this;
return self__.meta30924;
});})(flag))
;

cljs.core.async.t_cljs$core$async30923.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30923.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async30923.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30923.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30923.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30924","meta30924",-469346207,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async30923.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30923";

cljs.core.async.t_cljs$core$async30923.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async30923");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async30923 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30923(flag__$1,meta30924){
return (new cljs.core.async.t_cljs$core$async30923(flag__$1,meta30924));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async30923(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async30926 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30926 = (function (flag,cb,meta30927){
this.flag = flag;
this.cb = cb;
this.meta30927 = meta30927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async30926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30928,meta30927__$1){
var self__ = this;
var _30928__$1 = this;
return (new cljs.core.async.t_cljs$core$async30926(self__.flag,self__.cb,meta30927__$1));
});

cljs.core.async.t_cljs$core$async30926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30928){
var self__ = this;
var _30928__$1 = this;
return self__.meta30927;
});

cljs.core.async.t_cljs$core$async30926.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30926.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async30926.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30926.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async30926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30927","meta30927",-141877251,null)], null);
});

cljs.core.async.t_cljs$core$async30926.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30926.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30926";

cljs.core.async.t_cljs$core$async30926.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async30926");
});

cljs.core.async.__GT_t_cljs$core$async30926 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30926(flag__$1,cb__$1,meta30927){
return (new cljs.core.async.t_cljs$core$async30926(flag__$1,cb__$1,meta30927));
});

}

return (new cljs.core.async.t_cljs$core$async30926(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30929_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30929_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30930_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30930_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27953__auto__ = wport;
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30931 = (i + (1));
i = G__30931;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27953__auto__ = ret;
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__27941__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27941__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27941__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29124__auto__ = [];
var len__29117__auto___30937 = arguments.length;
var i__29118__auto___30938 = (0);
while(true){
if((i__29118__auto___30938 < len__29117__auto___30937)){
args__29124__auto__.push((arguments[i__29118__auto___30938]));

var G__30939 = (i__29118__auto___30938 + (1));
i__29118__auto___30938 = G__30939;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((1) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29125__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30934){
var map__30935 = p__30934;
var map__30935__$1 = ((((!((map__30935 == null)))?((((map__30935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30935.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30935):map__30935);
var opts = map__30935__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30932){
var G__30933 = cljs.core.first.call(null,seq30932);
var seq30932__$1 = cljs.core.next.call(null,seq30932);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30933,seq30932__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30941 = arguments.length;
switch (G__30941) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30854__auto___30987 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___30987){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___30987){
return (function (state_30965){
var state_val_30966 = (state_30965[(1)]);
if((state_val_30966 === (7))){
var inst_30961 = (state_30965[(2)]);
var state_30965__$1 = state_30965;
var statearr_30967_30988 = state_30965__$1;
(statearr_30967_30988[(2)] = inst_30961);

(statearr_30967_30988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (1))){
var state_30965__$1 = state_30965;
var statearr_30968_30989 = state_30965__$1;
(statearr_30968_30989[(2)] = null);

(statearr_30968_30989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (4))){
var inst_30944 = (state_30965[(7)]);
var inst_30944__$1 = (state_30965[(2)]);
var inst_30945 = (inst_30944__$1 == null);
var state_30965__$1 = (function (){var statearr_30969 = state_30965;
(statearr_30969[(7)] = inst_30944__$1);

return statearr_30969;
})();
if(cljs.core.truth_(inst_30945)){
var statearr_30970_30990 = state_30965__$1;
(statearr_30970_30990[(1)] = (5));

} else {
var statearr_30971_30991 = state_30965__$1;
(statearr_30971_30991[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (13))){
var state_30965__$1 = state_30965;
var statearr_30972_30992 = state_30965__$1;
(statearr_30972_30992[(2)] = null);

(statearr_30972_30992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (6))){
var inst_30944 = (state_30965[(7)]);
var state_30965__$1 = state_30965;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30965__$1,(11),to,inst_30944);
} else {
if((state_val_30966 === (3))){
var inst_30963 = (state_30965[(2)]);
var state_30965__$1 = state_30965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30965__$1,inst_30963);
} else {
if((state_val_30966 === (12))){
var state_30965__$1 = state_30965;
var statearr_30973_30993 = state_30965__$1;
(statearr_30973_30993[(2)] = null);

(statearr_30973_30993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (2))){
var state_30965__$1 = state_30965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30965__$1,(4),from);
} else {
if((state_val_30966 === (11))){
var inst_30954 = (state_30965[(2)]);
var state_30965__$1 = state_30965;
if(cljs.core.truth_(inst_30954)){
var statearr_30974_30994 = state_30965__$1;
(statearr_30974_30994[(1)] = (12));

} else {
var statearr_30975_30995 = state_30965__$1;
(statearr_30975_30995[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (9))){
var state_30965__$1 = state_30965;
var statearr_30976_30996 = state_30965__$1;
(statearr_30976_30996[(2)] = null);

(statearr_30976_30996[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (5))){
var state_30965__$1 = state_30965;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30977_30997 = state_30965__$1;
(statearr_30977_30997[(1)] = (8));

} else {
var statearr_30978_30998 = state_30965__$1;
(statearr_30978_30998[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (14))){
var inst_30959 = (state_30965[(2)]);
var state_30965__$1 = state_30965;
var statearr_30979_30999 = state_30965__$1;
(statearr_30979_30999[(2)] = inst_30959);

(statearr_30979_30999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (10))){
var inst_30951 = (state_30965[(2)]);
var state_30965__$1 = state_30965;
var statearr_30980_31000 = state_30965__$1;
(statearr_30980_31000[(2)] = inst_30951);

(statearr_30980_31000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30966 === (8))){
var inst_30948 = cljs.core.async.close_BANG_.call(null,to);
var state_30965__$1 = state_30965;
var statearr_30981_31001 = state_30965__$1;
(statearr_30981_31001[(2)] = inst_30948);

(statearr_30981_31001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___30987))
;
return ((function (switch__30766__auto__,c__30854__auto___30987){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_30982 = [null,null,null,null,null,null,null,null];
(statearr_30982[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_30982[(1)] = (1));

return statearr_30982;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_30965){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_30965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e30983){if((e30983 instanceof Object)){
var ex__30770__auto__ = e30983;
var statearr_30984_31002 = state_30965;
(statearr_30984_31002[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30965);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31003 = state_30965;
state_30965 = G__31003;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_30965){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_30965);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___30987))
})();
var state__30856__auto__ = (function (){var statearr_30985 = f__30855__auto__.call(null);
(statearr_30985[(6)] = c__30854__auto___30987);

return statearr_30985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___30987))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31004){
var vec__31005 = p__31004;
var v = cljs.core.nth.call(null,vec__31005,(0),null);
var p = cljs.core.nth.call(null,vec__31005,(1),null);
var job = vec__31005;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30854__auto___31176 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___31176,res,vec__31005,v,p,job,jobs,results){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___31176,res,vec__31005,v,p,job,jobs,results){
return (function (state_31012){
var state_val_31013 = (state_31012[(1)]);
if((state_val_31013 === (1))){
var state_31012__$1 = state_31012;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31012__$1,(2),res,v);
} else {
if((state_val_31013 === (2))){
var inst_31009 = (state_31012[(2)]);
var inst_31010 = cljs.core.async.close_BANG_.call(null,res);
var state_31012__$1 = (function (){var statearr_31014 = state_31012;
(statearr_31014[(7)] = inst_31009);

return statearr_31014;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31012__$1,inst_31010);
} else {
return null;
}
}
});})(c__30854__auto___31176,res,vec__31005,v,p,job,jobs,results))
;
return ((function (switch__30766__auto__,c__30854__auto___31176,res,vec__31005,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0 = (function (){
var statearr_31015 = [null,null,null,null,null,null,null,null];
(statearr_31015[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__);

(statearr_31015[(1)] = (1));

return statearr_31015;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1 = (function (state_31012){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31016){if((e31016 instanceof Object)){
var ex__30770__auto__ = e31016;
var statearr_31017_31177 = state_31012;
(statearr_31017_31177[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31012);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31178 = state_31012;
state_31012 = G__31178;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = function(state_31012){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1.call(this,state_31012);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___31176,res,vec__31005,v,p,job,jobs,results))
})();
var state__30856__auto__ = (function (){var statearr_31018 = f__30855__auto__.call(null);
(statearr_31018[(6)] = c__30854__auto___31176);

return statearr_31018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___31176,res,vec__31005,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31019){
var vec__31020 = p__31019;
var v = cljs.core.nth.call(null,vec__31020,(0),null);
var p = cljs.core.nth.call(null,vec__31020,(1),null);
var job = vec__31020;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28893__auto___31179 = n;
var __31180 = (0);
while(true){
if((__31180 < n__28893__auto___31179)){
var G__31023_31181 = type;
var G__31023_31182__$1 = (((G__31023_31181 instanceof cljs.core.Keyword))?G__31023_31181.fqn:null);
switch (G__31023_31182__$1) {
case "compute":
var c__30854__auto___31184 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31180,c__30854__auto___31184,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (__31180,c__30854__auto___31184,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async){
return (function (state_31036){
var state_val_31037 = (state_31036[(1)]);
if((state_val_31037 === (1))){
var state_31036__$1 = state_31036;
var statearr_31038_31185 = state_31036__$1;
(statearr_31038_31185[(2)] = null);

(statearr_31038_31185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (2))){
var state_31036__$1 = state_31036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31036__$1,(4),jobs);
} else {
if((state_val_31037 === (3))){
var inst_31034 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31036__$1,inst_31034);
} else {
if((state_val_31037 === (4))){
var inst_31026 = (state_31036[(2)]);
var inst_31027 = process.call(null,inst_31026);
var state_31036__$1 = state_31036;
if(cljs.core.truth_(inst_31027)){
var statearr_31039_31186 = state_31036__$1;
(statearr_31039_31186[(1)] = (5));

} else {
var statearr_31040_31187 = state_31036__$1;
(statearr_31040_31187[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (5))){
var state_31036__$1 = state_31036;
var statearr_31041_31188 = state_31036__$1;
(statearr_31041_31188[(2)] = null);

(statearr_31041_31188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (6))){
var state_31036__$1 = state_31036;
var statearr_31042_31189 = state_31036__$1;
(statearr_31042_31189[(2)] = null);

(statearr_31042_31189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (7))){
var inst_31032 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
var statearr_31043_31190 = state_31036__$1;
(statearr_31043_31190[(2)] = inst_31032);

(statearr_31043_31190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31180,c__30854__auto___31184,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async))
;
return ((function (__31180,switch__30766__auto__,c__30854__auto___31184,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0 = (function (){
var statearr_31044 = [null,null,null,null,null,null,null];
(statearr_31044[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__);

(statearr_31044[(1)] = (1));

return statearr_31044;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1 = (function (state_31036){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31045){if((e31045 instanceof Object)){
var ex__30770__auto__ = e31045;
var statearr_31046_31191 = state_31036;
(statearr_31046_31191[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31036);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31045;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31192 = state_31036;
state_31036 = G__31192;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = function(state_31036){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1.call(this,state_31036);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__;
})()
;})(__31180,switch__30766__auto__,c__30854__auto___31184,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async))
})();
var state__30856__auto__ = (function (){var statearr_31047 = f__30855__auto__.call(null);
(statearr_31047[(6)] = c__30854__auto___31184);

return statearr_31047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(__31180,c__30854__auto___31184,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async))
);


break;
case "async":
var c__30854__auto___31193 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31180,c__30854__auto___31193,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (__31180,c__30854__auto___31193,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async){
return (function (state_31060){
var state_val_31061 = (state_31060[(1)]);
if((state_val_31061 === (1))){
var state_31060__$1 = state_31060;
var statearr_31062_31194 = state_31060__$1;
(statearr_31062_31194[(2)] = null);

(statearr_31062_31194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (2))){
var state_31060__$1 = state_31060;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31060__$1,(4),jobs);
} else {
if((state_val_31061 === (3))){
var inst_31058 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31060__$1,inst_31058);
} else {
if((state_val_31061 === (4))){
var inst_31050 = (state_31060[(2)]);
var inst_31051 = async.call(null,inst_31050);
var state_31060__$1 = state_31060;
if(cljs.core.truth_(inst_31051)){
var statearr_31063_31195 = state_31060__$1;
(statearr_31063_31195[(1)] = (5));

} else {
var statearr_31064_31196 = state_31060__$1;
(statearr_31064_31196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (5))){
var state_31060__$1 = state_31060;
var statearr_31065_31197 = state_31060__$1;
(statearr_31065_31197[(2)] = null);

(statearr_31065_31197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (6))){
var state_31060__$1 = state_31060;
var statearr_31066_31198 = state_31060__$1;
(statearr_31066_31198[(2)] = null);

(statearr_31066_31198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (7))){
var inst_31056 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
var statearr_31067_31199 = state_31060__$1;
(statearr_31067_31199[(2)] = inst_31056);

(statearr_31067_31199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31180,c__30854__auto___31193,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async))
;
return ((function (__31180,switch__30766__auto__,c__30854__auto___31193,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0 = (function (){
var statearr_31068 = [null,null,null,null,null,null,null];
(statearr_31068[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__);

(statearr_31068[(1)] = (1));

return statearr_31068;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1 = (function (state_31060){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31069){if((e31069 instanceof Object)){
var ex__30770__auto__ = e31069;
var statearr_31070_31200 = state_31060;
(statearr_31070_31200[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31060);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31201 = state_31060;
state_31060 = G__31201;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = function(state_31060){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1.call(this,state_31060);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__;
})()
;})(__31180,switch__30766__auto__,c__30854__auto___31193,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async))
})();
var state__30856__auto__ = (function (){var statearr_31071 = f__30855__auto__.call(null);
(statearr_31071[(6)] = c__30854__auto___31193);

return statearr_31071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(__31180,c__30854__auto___31193,G__31023_31181,G__31023_31182__$1,n__28893__auto___31179,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31023_31182__$1)].join('')));

}

var G__31202 = (__31180 + (1));
__31180 = G__31202;
continue;
} else {
}
break;
}

var c__30854__auto___31203 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___31203,jobs,results,process,async){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___31203,jobs,results,process,async){
return (function (state_31093){
var state_val_31094 = (state_31093[(1)]);
if((state_val_31094 === (1))){
var state_31093__$1 = state_31093;
var statearr_31095_31204 = state_31093__$1;
(statearr_31095_31204[(2)] = null);

(statearr_31095_31204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (2))){
var state_31093__$1 = state_31093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31093__$1,(4),from);
} else {
if((state_val_31094 === (3))){
var inst_31091 = (state_31093[(2)]);
var state_31093__$1 = state_31093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31093__$1,inst_31091);
} else {
if((state_val_31094 === (4))){
var inst_31074 = (state_31093[(7)]);
var inst_31074__$1 = (state_31093[(2)]);
var inst_31075 = (inst_31074__$1 == null);
var state_31093__$1 = (function (){var statearr_31096 = state_31093;
(statearr_31096[(7)] = inst_31074__$1);

return statearr_31096;
})();
if(cljs.core.truth_(inst_31075)){
var statearr_31097_31205 = state_31093__$1;
(statearr_31097_31205[(1)] = (5));

} else {
var statearr_31098_31206 = state_31093__$1;
(statearr_31098_31206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (5))){
var inst_31077 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31093__$1 = state_31093;
var statearr_31099_31207 = state_31093__$1;
(statearr_31099_31207[(2)] = inst_31077);

(statearr_31099_31207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (6))){
var inst_31079 = (state_31093[(8)]);
var inst_31074 = (state_31093[(7)]);
var inst_31079__$1 = cljs.core.async.chan.call(null,(1));
var inst_31080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31081 = [inst_31074,inst_31079__$1];
var inst_31082 = (new cljs.core.PersistentVector(null,2,(5),inst_31080,inst_31081,null));
var state_31093__$1 = (function (){var statearr_31100 = state_31093;
(statearr_31100[(8)] = inst_31079__$1);

return statearr_31100;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31093__$1,(8),jobs,inst_31082);
} else {
if((state_val_31094 === (7))){
var inst_31089 = (state_31093[(2)]);
var state_31093__$1 = state_31093;
var statearr_31101_31208 = state_31093__$1;
(statearr_31101_31208[(2)] = inst_31089);

(statearr_31101_31208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (8))){
var inst_31079 = (state_31093[(8)]);
var inst_31084 = (state_31093[(2)]);
var state_31093__$1 = (function (){var statearr_31102 = state_31093;
(statearr_31102[(9)] = inst_31084);

return statearr_31102;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31093__$1,(9),results,inst_31079);
} else {
if((state_val_31094 === (9))){
var inst_31086 = (state_31093[(2)]);
var state_31093__$1 = (function (){var statearr_31103 = state_31093;
(statearr_31103[(10)] = inst_31086);

return statearr_31103;
})();
var statearr_31104_31209 = state_31093__$1;
(statearr_31104_31209[(2)] = null);

(statearr_31104_31209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___31203,jobs,results,process,async))
;
return ((function (switch__30766__auto__,c__30854__auto___31203,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0 = (function (){
var statearr_31105 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31105[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__);

(statearr_31105[(1)] = (1));

return statearr_31105;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1 = (function (state_31093){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31106){if((e31106 instanceof Object)){
var ex__30770__auto__ = e31106;
var statearr_31107_31210 = state_31093;
(statearr_31107_31210[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31093);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31106;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31211 = state_31093;
state_31093 = G__31211;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = function(state_31093){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1.call(this,state_31093);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___31203,jobs,results,process,async))
})();
var state__30856__auto__ = (function (){var statearr_31108 = f__30855__auto__.call(null);
(statearr_31108[(6)] = c__30854__auto___31203);

return statearr_31108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___31203,jobs,results,process,async))
);


var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__,jobs,results,process,async){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__,jobs,results,process,async){
return (function (state_31146){
var state_val_31147 = (state_31146[(1)]);
if((state_val_31147 === (7))){
var inst_31142 = (state_31146[(2)]);
var state_31146__$1 = state_31146;
var statearr_31148_31212 = state_31146__$1;
(statearr_31148_31212[(2)] = inst_31142);

(statearr_31148_31212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (20))){
var state_31146__$1 = state_31146;
var statearr_31149_31213 = state_31146__$1;
(statearr_31149_31213[(2)] = null);

(statearr_31149_31213[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (1))){
var state_31146__$1 = state_31146;
var statearr_31150_31214 = state_31146__$1;
(statearr_31150_31214[(2)] = null);

(statearr_31150_31214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (4))){
var inst_31111 = (state_31146[(7)]);
var inst_31111__$1 = (state_31146[(2)]);
var inst_31112 = (inst_31111__$1 == null);
var state_31146__$1 = (function (){var statearr_31151 = state_31146;
(statearr_31151[(7)] = inst_31111__$1);

return statearr_31151;
})();
if(cljs.core.truth_(inst_31112)){
var statearr_31152_31215 = state_31146__$1;
(statearr_31152_31215[(1)] = (5));

} else {
var statearr_31153_31216 = state_31146__$1;
(statearr_31153_31216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (15))){
var inst_31124 = (state_31146[(8)]);
var state_31146__$1 = state_31146;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31146__$1,(18),to,inst_31124);
} else {
if((state_val_31147 === (21))){
var inst_31137 = (state_31146[(2)]);
var state_31146__$1 = state_31146;
var statearr_31154_31217 = state_31146__$1;
(statearr_31154_31217[(2)] = inst_31137);

(statearr_31154_31217[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (13))){
var inst_31139 = (state_31146[(2)]);
var state_31146__$1 = (function (){var statearr_31155 = state_31146;
(statearr_31155[(9)] = inst_31139);

return statearr_31155;
})();
var statearr_31156_31218 = state_31146__$1;
(statearr_31156_31218[(2)] = null);

(statearr_31156_31218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (6))){
var inst_31111 = (state_31146[(7)]);
var state_31146__$1 = state_31146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31146__$1,(11),inst_31111);
} else {
if((state_val_31147 === (17))){
var inst_31132 = (state_31146[(2)]);
var state_31146__$1 = state_31146;
if(cljs.core.truth_(inst_31132)){
var statearr_31157_31219 = state_31146__$1;
(statearr_31157_31219[(1)] = (19));

} else {
var statearr_31158_31220 = state_31146__$1;
(statearr_31158_31220[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (3))){
var inst_31144 = (state_31146[(2)]);
var state_31146__$1 = state_31146;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31146__$1,inst_31144);
} else {
if((state_val_31147 === (12))){
var inst_31121 = (state_31146[(10)]);
var state_31146__$1 = state_31146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31146__$1,(14),inst_31121);
} else {
if((state_val_31147 === (2))){
var state_31146__$1 = state_31146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31146__$1,(4),results);
} else {
if((state_val_31147 === (19))){
var state_31146__$1 = state_31146;
var statearr_31159_31221 = state_31146__$1;
(statearr_31159_31221[(2)] = null);

(statearr_31159_31221[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (11))){
var inst_31121 = (state_31146[(2)]);
var state_31146__$1 = (function (){var statearr_31160 = state_31146;
(statearr_31160[(10)] = inst_31121);

return statearr_31160;
})();
var statearr_31161_31222 = state_31146__$1;
(statearr_31161_31222[(2)] = null);

(statearr_31161_31222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (9))){
var state_31146__$1 = state_31146;
var statearr_31162_31223 = state_31146__$1;
(statearr_31162_31223[(2)] = null);

(statearr_31162_31223[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (5))){
var state_31146__$1 = state_31146;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31163_31224 = state_31146__$1;
(statearr_31163_31224[(1)] = (8));

} else {
var statearr_31164_31225 = state_31146__$1;
(statearr_31164_31225[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (14))){
var inst_31124 = (state_31146[(8)]);
var inst_31126 = (state_31146[(11)]);
var inst_31124__$1 = (state_31146[(2)]);
var inst_31125 = (inst_31124__$1 == null);
var inst_31126__$1 = cljs.core.not.call(null,inst_31125);
var state_31146__$1 = (function (){var statearr_31165 = state_31146;
(statearr_31165[(8)] = inst_31124__$1);

(statearr_31165[(11)] = inst_31126__$1);

return statearr_31165;
})();
if(inst_31126__$1){
var statearr_31166_31226 = state_31146__$1;
(statearr_31166_31226[(1)] = (15));

} else {
var statearr_31167_31227 = state_31146__$1;
(statearr_31167_31227[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (16))){
var inst_31126 = (state_31146[(11)]);
var state_31146__$1 = state_31146;
var statearr_31168_31228 = state_31146__$1;
(statearr_31168_31228[(2)] = inst_31126);

(statearr_31168_31228[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (10))){
var inst_31118 = (state_31146[(2)]);
var state_31146__$1 = state_31146;
var statearr_31169_31229 = state_31146__$1;
(statearr_31169_31229[(2)] = inst_31118);

(statearr_31169_31229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (18))){
var inst_31129 = (state_31146[(2)]);
var state_31146__$1 = state_31146;
var statearr_31170_31230 = state_31146__$1;
(statearr_31170_31230[(2)] = inst_31129);

(statearr_31170_31230[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31147 === (8))){
var inst_31115 = cljs.core.async.close_BANG_.call(null,to);
var state_31146__$1 = state_31146;
var statearr_31171_31231 = state_31146__$1;
(statearr_31171_31231[(2)] = inst_31115);

(statearr_31171_31231[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__,jobs,results,process,async))
;
return ((function (switch__30766__auto__,c__30854__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0 = (function (){
var statearr_31172 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31172[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__);

(statearr_31172[(1)] = (1));

return statearr_31172;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1 = (function (state_31146){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31146);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31173){if((e31173 instanceof Object)){
var ex__30770__auto__ = e31173;
var statearr_31174_31232 = state_31146;
(statearr_31174_31232[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31146);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31173;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31233 = state_31146;
state_31146 = G__31233;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__ = function(state_31146){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1.call(this,state_31146);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30767__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__,jobs,results,process,async))
})();
var state__30856__auto__ = (function (){var statearr_31175 = f__30855__auto__.call(null);
(statearr_31175[(6)] = c__30854__auto__);

return statearr_31175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__,jobs,results,process,async))
);

return c__30854__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31235 = arguments.length;
switch (G__31235) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31238 = arguments.length;
switch (G__31238) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31241 = arguments.length;
switch (G__31241) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30854__auto___31290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___31290,tc,fc){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___31290,tc,fc){
return (function (state_31267){
var state_val_31268 = (state_31267[(1)]);
if((state_val_31268 === (7))){
var inst_31263 = (state_31267[(2)]);
var state_31267__$1 = state_31267;
var statearr_31269_31291 = state_31267__$1;
(statearr_31269_31291[(2)] = inst_31263);

(statearr_31269_31291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (1))){
var state_31267__$1 = state_31267;
var statearr_31270_31292 = state_31267__$1;
(statearr_31270_31292[(2)] = null);

(statearr_31270_31292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (4))){
var inst_31244 = (state_31267[(7)]);
var inst_31244__$1 = (state_31267[(2)]);
var inst_31245 = (inst_31244__$1 == null);
var state_31267__$1 = (function (){var statearr_31271 = state_31267;
(statearr_31271[(7)] = inst_31244__$1);

return statearr_31271;
})();
if(cljs.core.truth_(inst_31245)){
var statearr_31272_31293 = state_31267__$1;
(statearr_31272_31293[(1)] = (5));

} else {
var statearr_31273_31294 = state_31267__$1;
(statearr_31273_31294[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (13))){
var state_31267__$1 = state_31267;
var statearr_31274_31295 = state_31267__$1;
(statearr_31274_31295[(2)] = null);

(statearr_31274_31295[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (6))){
var inst_31244 = (state_31267[(7)]);
var inst_31250 = p.call(null,inst_31244);
var state_31267__$1 = state_31267;
if(cljs.core.truth_(inst_31250)){
var statearr_31275_31296 = state_31267__$1;
(statearr_31275_31296[(1)] = (9));

} else {
var statearr_31276_31297 = state_31267__$1;
(statearr_31276_31297[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (3))){
var inst_31265 = (state_31267[(2)]);
var state_31267__$1 = state_31267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31267__$1,inst_31265);
} else {
if((state_val_31268 === (12))){
var state_31267__$1 = state_31267;
var statearr_31277_31298 = state_31267__$1;
(statearr_31277_31298[(2)] = null);

(statearr_31277_31298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (2))){
var state_31267__$1 = state_31267;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31267__$1,(4),ch);
} else {
if((state_val_31268 === (11))){
var inst_31244 = (state_31267[(7)]);
var inst_31254 = (state_31267[(2)]);
var state_31267__$1 = state_31267;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31267__$1,(8),inst_31254,inst_31244);
} else {
if((state_val_31268 === (9))){
var state_31267__$1 = state_31267;
var statearr_31278_31299 = state_31267__$1;
(statearr_31278_31299[(2)] = tc);

(statearr_31278_31299[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (5))){
var inst_31247 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31248 = cljs.core.async.close_BANG_.call(null,fc);
var state_31267__$1 = (function (){var statearr_31279 = state_31267;
(statearr_31279[(8)] = inst_31247);

return statearr_31279;
})();
var statearr_31280_31300 = state_31267__$1;
(statearr_31280_31300[(2)] = inst_31248);

(statearr_31280_31300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (14))){
var inst_31261 = (state_31267[(2)]);
var state_31267__$1 = state_31267;
var statearr_31281_31301 = state_31267__$1;
(statearr_31281_31301[(2)] = inst_31261);

(statearr_31281_31301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (10))){
var state_31267__$1 = state_31267;
var statearr_31282_31302 = state_31267__$1;
(statearr_31282_31302[(2)] = fc);

(statearr_31282_31302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31268 === (8))){
var inst_31256 = (state_31267[(2)]);
var state_31267__$1 = state_31267;
if(cljs.core.truth_(inst_31256)){
var statearr_31283_31303 = state_31267__$1;
(statearr_31283_31303[(1)] = (12));

} else {
var statearr_31284_31304 = state_31267__$1;
(statearr_31284_31304[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___31290,tc,fc))
;
return ((function (switch__30766__auto__,c__30854__auto___31290,tc,fc){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_31285 = [null,null,null,null,null,null,null,null,null];
(statearr_31285[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_31285[(1)] = (1));

return statearr_31285;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_31267){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31286){if((e31286 instanceof Object)){
var ex__30770__auto__ = e31286;
var statearr_31287_31305 = state_31267;
(statearr_31287_31305[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31286;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31306 = state_31267;
state_31267 = G__31306;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_31267){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_31267);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___31290,tc,fc))
})();
var state__30856__auto__ = (function (){var statearr_31288 = f__30855__auto__.call(null);
(statearr_31288[(6)] = c__30854__auto___31290);

return statearr_31288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___31290,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__){
return (function (state_31327){
var state_val_31328 = (state_31327[(1)]);
if((state_val_31328 === (7))){
var inst_31323 = (state_31327[(2)]);
var state_31327__$1 = state_31327;
var statearr_31329_31347 = state_31327__$1;
(statearr_31329_31347[(2)] = inst_31323);

(statearr_31329_31347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (1))){
var inst_31307 = init;
var state_31327__$1 = (function (){var statearr_31330 = state_31327;
(statearr_31330[(7)] = inst_31307);

return statearr_31330;
})();
var statearr_31331_31348 = state_31327__$1;
(statearr_31331_31348[(2)] = null);

(statearr_31331_31348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (4))){
var inst_31310 = (state_31327[(8)]);
var inst_31310__$1 = (state_31327[(2)]);
var inst_31311 = (inst_31310__$1 == null);
var state_31327__$1 = (function (){var statearr_31332 = state_31327;
(statearr_31332[(8)] = inst_31310__$1);

return statearr_31332;
})();
if(cljs.core.truth_(inst_31311)){
var statearr_31333_31349 = state_31327__$1;
(statearr_31333_31349[(1)] = (5));

} else {
var statearr_31334_31350 = state_31327__$1;
(statearr_31334_31350[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (6))){
var inst_31310 = (state_31327[(8)]);
var inst_31307 = (state_31327[(7)]);
var inst_31314 = (state_31327[(9)]);
var inst_31314__$1 = f.call(null,inst_31307,inst_31310);
var inst_31315 = cljs.core.reduced_QMARK_.call(null,inst_31314__$1);
var state_31327__$1 = (function (){var statearr_31335 = state_31327;
(statearr_31335[(9)] = inst_31314__$1);

return statearr_31335;
})();
if(inst_31315){
var statearr_31336_31351 = state_31327__$1;
(statearr_31336_31351[(1)] = (8));

} else {
var statearr_31337_31352 = state_31327__$1;
(statearr_31337_31352[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (3))){
var inst_31325 = (state_31327[(2)]);
var state_31327__$1 = state_31327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31327__$1,inst_31325);
} else {
if((state_val_31328 === (2))){
var state_31327__$1 = state_31327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31327__$1,(4),ch);
} else {
if((state_val_31328 === (9))){
var inst_31314 = (state_31327[(9)]);
var inst_31307 = inst_31314;
var state_31327__$1 = (function (){var statearr_31338 = state_31327;
(statearr_31338[(7)] = inst_31307);

return statearr_31338;
})();
var statearr_31339_31353 = state_31327__$1;
(statearr_31339_31353[(2)] = null);

(statearr_31339_31353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (5))){
var inst_31307 = (state_31327[(7)]);
var state_31327__$1 = state_31327;
var statearr_31340_31354 = state_31327__$1;
(statearr_31340_31354[(2)] = inst_31307);

(statearr_31340_31354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (10))){
var inst_31321 = (state_31327[(2)]);
var state_31327__$1 = state_31327;
var statearr_31341_31355 = state_31327__$1;
(statearr_31341_31355[(2)] = inst_31321);

(statearr_31341_31355[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31328 === (8))){
var inst_31314 = (state_31327[(9)]);
var inst_31317 = cljs.core.deref.call(null,inst_31314);
var state_31327__$1 = state_31327;
var statearr_31342_31356 = state_31327__$1;
(statearr_31342_31356[(2)] = inst_31317);

(statearr_31342_31356[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__))
;
return ((function (switch__30766__auto__,c__30854__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30767__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30767__auto____0 = (function (){
var statearr_31343 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31343[(0)] = cljs$core$async$reduce_$_state_machine__30767__auto__);

(statearr_31343[(1)] = (1));

return statearr_31343;
});
var cljs$core$async$reduce_$_state_machine__30767__auto____1 = (function (state_31327){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31344){if((e31344 instanceof Object)){
var ex__30770__auto__ = e31344;
var statearr_31345_31357 = state_31327;
(statearr_31345_31357[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31358 = state_31327;
state_31327 = G__31358;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30767__auto__ = function(state_31327){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30767__auto____1.call(this,state_31327);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30767__auto____0;
cljs$core$async$reduce_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30767__auto____1;
return cljs$core$async$reduce_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__))
})();
var state__30856__auto__ = (function (){var statearr_31346 = f__30855__auto__.call(null);
(statearr_31346[(6)] = c__30854__auto__);

return statearr_31346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__))
);

return c__30854__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__,f__$1){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__,f__$1){
return (function (state_31364){
var state_val_31365 = (state_31364[(1)]);
if((state_val_31365 === (1))){
var inst_31359 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_31364__$1 = state_31364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31364__$1,(2),inst_31359);
} else {
if((state_val_31365 === (2))){
var inst_31361 = (state_31364[(2)]);
var inst_31362 = f__$1.call(null,inst_31361);
var state_31364__$1 = state_31364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31364__$1,inst_31362);
} else {
return null;
}
}
});})(c__30854__auto__,f__$1))
;
return ((function (switch__30766__auto__,c__30854__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__30767__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30767__auto____0 = (function (){
var statearr_31366 = [null,null,null,null,null,null,null];
(statearr_31366[(0)] = cljs$core$async$transduce_$_state_machine__30767__auto__);

(statearr_31366[(1)] = (1));

return statearr_31366;
});
var cljs$core$async$transduce_$_state_machine__30767__auto____1 = (function (state_31364){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31367){if((e31367 instanceof Object)){
var ex__30770__auto__ = e31367;
var statearr_31368_31370 = state_31364;
(statearr_31368_31370[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31364);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31367;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31371 = state_31364;
state_31364 = G__31371;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30767__auto__ = function(state_31364){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30767__auto____1.call(this,state_31364);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30767__auto____0;
cljs$core$async$transduce_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30767__auto____1;
return cljs$core$async$transduce_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__,f__$1))
})();
var state__30856__auto__ = (function (){var statearr_31369 = f__30855__auto__.call(null);
(statearr_31369[(6)] = c__30854__auto__);

return statearr_31369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__,f__$1))
);

return c__30854__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31373 = arguments.length;
switch (G__31373) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__){
return (function (state_31398){
var state_val_31399 = (state_31398[(1)]);
if((state_val_31399 === (7))){
var inst_31380 = (state_31398[(2)]);
var state_31398__$1 = state_31398;
var statearr_31400_31421 = state_31398__$1;
(statearr_31400_31421[(2)] = inst_31380);

(statearr_31400_31421[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (1))){
var inst_31374 = cljs.core.seq.call(null,coll);
var inst_31375 = inst_31374;
var state_31398__$1 = (function (){var statearr_31401 = state_31398;
(statearr_31401[(7)] = inst_31375);

return statearr_31401;
})();
var statearr_31402_31422 = state_31398__$1;
(statearr_31402_31422[(2)] = null);

(statearr_31402_31422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (4))){
var inst_31375 = (state_31398[(7)]);
var inst_31378 = cljs.core.first.call(null,inst_31375);
var state_31398__$1 = state_31398;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31398__$1,(7),ch,inst_31378);
} else {
if((state_val_31399 === (13))){
var inst_31392 = (state_31398[(2)]);
var state_31398__$1 = state_31398;
var statearr_31403_31423 = state_31398__$1;
(statearr_31403_31423[(2)] = inst_31392);

(statearr_31403_31423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (6))){
var inst_31383 = (state_31398[(2)]);
var state_31398__$1 = state_31398;
if(cljs.core.truth_(inst_31383)){
var statearr_31404_31424 = state_31398__$1;
(statearr_31404_31424[(1)] = (8));

} else {
var statearr_31405_31425 = state_31398__$1;
(statearr_31405_31425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (3))){
var inst_31396 = (state_31398[(2)]);
var state_31398__$1 = state_31398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31398__$1,inst_31396);
} else {
if((state_val_31399 === (12))){
var state_31398__$1 = state_31398;
var statearr_31406_31426 = state_31398__$1;
(statearr_31406_31426[(2)] = null);

(statearr_31406_31426[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (2))){
var inst_31375 = (state_31398[(7)]);
var state_31398__$1 = state_31398;
if(cljs.core.truth_(inst_31375)){
var statearr_31407_31427 = state_31398__$1;
(statearr_31407_31427[(1)] = (4));

} else {
var statearr_31408_31428 = state_31398__$1;
(statearr_31408_31428[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (11))){
var inst_31389 = cljs.core.async.close_BANG_.call(null,ch);
var state_31398__$1 = state_31398;
var statearr_31409_31429 = state_31398__$1;
(statearr_31409_31429[(2)] = inst_31389);

(statearr_31409_31429[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (9))){
var state_31398__$1 = state_31398;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31410_31430 = state_31398__$1;
(statearr_31410_31430[(1)] = (11));

} else {
var statearr_31411_31431 = state_31398__$1;
(statearr_31411_31431[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (5))){
var inst_31375 = (state_31398[(7)]);
var state_31398__$1 = state_31398;
var statearr_31412_31432 = state_31398__$1;
(statearr_31412_31432[(2)] = inst_31375);

(statearr_31412_31432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (10))){
var inst_31394 = (state_31398[(2)]);
var state_31398__$1 = state_31398;
var statearr_31413_31433 = state_31398__$1;
(statearr_31413_31433[(2)] = inst_31394);

(statearr_31413_31433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31399 === (8))){
var inst_31375 = (state_31398[(7)]);
var inst_31385 = cljs.core.next.call(null,inst_31375);
var inst_31375__$1 = inst_31385;
var state_31398__$1 = (function (){var statearr_31414 = state_31398;
(statearr_31414[(7)] = inst_31375__$1);

return statearr_31414;
})();
var statearr_31415_31434 = state_31398__$1;
(statearr_31415_31434[(2)] = null);

(statearr_31415_31434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__))
;
return ((function (switch__30766__auto__,c__30854__auto__){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_31416 = [null,null,null,null,null,null,null,null];
(statearr_31416[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_31416[(1)] = (1));

return statearr_31416;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_31398){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31417){if((e31417 instanceof Object)){
var ex__30770__auto__ = e31417;
var statearr_31418_31435 = state_31398;
(statearr_31418_31435[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31417;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31436 = state_31398;
state_31398 = G__31436;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_31398){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_31398);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__))
})();
var state__30856__auto__ = (function (){var statearr_31419 = f__30855__auto__.call(null);
(statearr_31419[(6)] = c__30854__auto__);

return statearr_31419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__))
);

return c__30854__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28636__auto__ = (((_ == null))?null:_);
var m__28637__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,_);
} else {
var m__28637__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28637__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m);
} else {
var m__28637__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31437 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31437 = (function (ch,cs,meta31438){
this.ch = ch;
this.cs = cs;
this.meta31438 = meta31438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31439,meta31438__$1){
var self__ = this;
var _31439__$1 = this;
return (new cljs.core.async.t_cljs$core$async31437(self__.ch,self__.cs,meta31438__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31439){
var self__ = this;
var _31439__$1 = this;
return self__.meta31438;
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31438","meta31438",-1129576172,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31437.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31437.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31437";

cljs.core.async.t_cljs$core$async31437.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async31437");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31437 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31437(ch__$1,cs__$1,meta31438){
return (new cljs.core.async.t_cljs$core$async31437(ch__$1,cs__$1,meta31438));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31437(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30854__auto___31659 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___31659,cs,m,dchan,dctr,done){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___31659,cs,m,dchan,dctr,done){
return (function (state_31574){
var state_val_31575 = (state_31574[(1)]);
if((state_val_31575 === (7))){
var inst_31570 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31576_31660 = state_31574__$1;
(statearr_31576_31660[(2)] = inst_31570);

(statearr_31576_31660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (20))){
var inst_31473 = (state_31574[(7)]);
var inst_31485 = cljs.core.first.call(null,inst_31473);
var inst_31486 = cljs.core.nth.call(null,inst_31485,(0),null);
var inst_31487 = cljs.core.nth.call(null,inst_31485,(1),null);
var state_31574__$1 = (function (){var statearr_31577 = state_31574;
(statearr_31577[(8)] = inst_31486);

return statearr_31577;
})();
if(cljs.core.truth_(inst_31487)){
var statearr_31578_31661 = state_31574__$1;
(statearr_31578_31661[(1)] = (22));

} else {
var statearr_31579_31662 = state_31574__$1;
(statearr_31579_31662[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (27))){
var inst_31515 = (state_31574[(9)]);
var inst_31522 = (state_31574[(10)]);
var inst_31517 = (state_31574[(11)]);
var inst_31442 = (state_31574[(12)]);
var inst_31522__$1 = cljs.core._nth.call(null,inst_31515,inst_31517);
var inst_31523 = cljs.core.async.put_BANG_.call(null,inst_31522__$1,inst_31442,done);
var state_31574__$1 = (function (){var statearr_31580 = state_31574;
(statearr_31580[(10)] = inst_31522__$1);

return statearr_31580;
})();
if(cljs.core.truth_(inst_31523)){
var statearr_31581_31663 = state_31574__$1;
(statearr_31581_31663[(1)] = (30));

} else {
var statearr_31582_31664 = state_31574__$1;
(statearr_31582_31664[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (1))){
var state_31574__$1 = state_31574;
var statearr_31583_31665 = state_31574__$1;
(statearr_31583_31665[(2)] = null);

(statearr_31583_31665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (24))){
var inst_31473 = (state_31574[(7)]);
var inst_31492 = (state_31574[(2)]);
var inst_31493 = cljs.core.next.call(null,inst_31473);
var inst_31451 = inst_31493;
var inst_31452 = null;
var inst_31453 = (0);
var inst_31454 = (0);
var state_31574__$1 = (function (){var statearr_31584 = state_31574;
(statearr_31584[(13)] = inst_31453);

(statearr_31584[(14)] = inst_31492);

(statearr_31584[(15)] = inst_31454);

(statearr_31584[(16)] = inst_31451);

(statearr_31584[(17)] = inst_31452);

return statearr_31584;
})();
var statearr_31585_31666 = state_31574__$1;
(statearr_31585_31666[(2)] = null);

(statearr_31585_31666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (39))){
var state_31574__$1 = state_31574;
var statearr_31589_31667 = state_31574__$1;
(statearr_31589_31667[(2)] = null);

(statearr_31589_31667[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (4))){
var inst_31442 = (state_31574[(12)]);
var inst_31442__$1 = (state_31574[(2)]);
var inst_31443 = (inst_31442__$1 == null);
var state_31574__$1 = (function (){var statearr_31590 = state_31574;
(statearr_31590[(12)] = inst_31442__$1);

return statearr_31590;
})();
if(cljs.core.truth_(inst_31443)){
var statearr_31591_31668 = state_31574__$1;
(statearr_31591_31668[(1)] = (5));

} else {
var statearr_31592_31669 = state_31574__$1;
(statearr_31592_31669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (15))){
var inst_31453 = (state_31574[(13)]);
var inst_31454 = (state_31574[(15)]);
var inst_31451 = (state_31574[(16)]);
var inst_31452 = (state_31574[(17)]);
var inst_31469 = (state_31574[(2)]);
var inst_31470 = (inst_31454 + (1));
var tmp31586 = inst_31453;
var tmp31587 = inst_31451;
var tmp31588 = inst_31452;
var inst_31451__$1 = tmp31587;
var inst_31452__$1 = tmp31588;
var inst_31453__$1 = tmp31586;
var inst_31454__$1 = inst_31470;
var state_31574__$1 = (function (){var statearr_31593 = state_31574;
(statearr_31593[(13)] = inst_31453__$1);

(statearr_31593[(18)] = inst_31469);

(statearr_31593[(15)] = inst_31454__$1);

(statearr_31593[(16)] = inst_31451__$1);

(statearr_31593[(17)] = inst_31452__$1);

return statearr_31593;
})();
var statearr_31594_31670 = state_31574__$1;
(statearr_31594_31670[(2)] = null);

(statearr_31594_31670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (21))){
var inst_31496 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31598_31671 = state_31574__$1;
(statearr_31598_31671[(2)] = inst_31496);

(statearr_31598_31671[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (31))){
var inst_31522 = (state_31574[(10)]);
var inst_31526 = done.call(null,null);
var inst_31527 = cljs.core.async.untap_STAR_.call(null,m,inst_31522);
var state_31574__$1 = (function (){var statearr_31599 = state_31574;
(statearr_31599[(19)] = inst_31526);

return statearr_31599;
})();
var statearr_31600_31672 = state_31574__$1;
(statearr_31600_31672[(2)] = inst_31527);

(statearr_31600_31672[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (32))){
var inst_31516 = (state_31574[(20)]);
var inst_31515 = (state_31574[(9)]);
var inst_31517 = (state_31574[(11)]);
var inst_31514 = (state_31574[(21)]);
var inst_31529 = (state_31574[(2)]);
var inst_31530 = (inst_31517 + (1));
var tmp31595 = inst_31516;
var tmp31596 = inst_31515;
var tmp31597 = inst_31514;
var inst_31514__$1 = tmp31597;
var inst_31515__$1 = tmp31596;
var inst_31516__$1 = tmp31595;
var inst_31517__$1 = inst_31530;
var state_31574__$1 = (function (){var statearr_31601 = state_31574;
(statearr_31601[(20)] = inst_31516__$1);

(statearr_31601[(9)] = inst_31515__$1);

(statearr_31601[(22)] = inst_31529);

(statearr_31601[(11)] = inst_31517__$1);

(statearr_31601[(21)] = inst_31514__$1);

return statearr_31601;
})();
var statearr_31602_31673 = state_31574__$1;
(statearr_31602_31673[(2)] = null);

(statearr_31602_31673[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (40))){
var inst_31542 = (state_31574[(23)]);
var inst_31546 = done.call(null,null);
var inst_31547 = cljs.core.async.untap_STAR_.call(null,m,inst_31542);
var state_31574__$1 = (function (){var statearr_31603 = state_31574;
(statearr_31603[(24)] = inst_31546);

return statearr_31603;
})();
var statearr_31604_31674 = state_31574__$1;
(statearr_31604_31674[(2)] = inst_31547);

(statearr_31604_31674[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (33))){
var inst_31533 = (state_31574[(25)]);
var inst_31535 = cljs.core.chunked_seq_QMARK_.call(null,inst_31533);
var state_31574__$1 = state_31574;
if(inst_31535){
var statearr_31605_31675 = state_31574__$1;
(statearr_31605_31675[(1)] = (36));

} else {
var statearr_31606_31676 = state_31574__$1;
(statearr_31606_31676[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (13))){
var inst_31463 = (state_31574[(26)]);
var inst_31466 = cljs.core.async.close_BANG_.call(null,inst_31463);
var state_31574__$1 = state_31574;
var statearr_31607_31677 = state_31574__$1;
(statearr_31607_31677[(2)] = inst_31466);

(statearr_31607_31677[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (22))){
var inst_31486 = (state_31574[(8)]);
var inst_31489 = cljs.core.async.close_BANG_.call(null,inst_31486);
var state_31574__$1 = state_31574;
var statearr_31608_31678 = state_31574__$1;
(statearr_31608_31678[(2)] = inst_31489);

(statearr_31608_31678[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (36))){
var inst_31533 = (state_31574[(25)]);
var inst_31537 = cljs.core.chunk_first.call(null,inst_31533);
var inst_31538 = cljs.core.chunk_rest.call(null,inst_31533);
var inst_31539 = cljs.core.count.call(null,inst_31537);
var inst_31514 = inst_31538;
var inst_31515 = inst_31537;
var inst_31516 = inst_31539;
var inst_31517 = (0);
var state_31574__$1 = (function (){var statearr_31609 = state_31574;
(statearr_31609[(20)] = inst_31516);

(statearr_31609[(9)] = inst_31515);

(statearr_31609[(11)] = inst_31517);

(statearr_31609[(21)] = inst_31514);

return statearr_31609;
})();
var statearr_31610_31679 = state_31574__$1;
(statearr_31610_31679[(2)] = null);

(statearr_31610_31679[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (41))){
var inst_31533 = (state_31574[(25)]);
var inst_31549 = (state_31574[(2)]);
var inst_31550 = cljs.core.next.call(null,inst_31533);
var inst_31514 = inst_31550;
var inst_31515 = null;
var inst_31516 = (0);
var inst_31517 = (0);
var state_31574__$1 = (function (){var statearr_31611 = state_31574;
(statearr_31611[(20)] = inst_31516);

(statearr_31611[(27)] = inst_31549);

(statearr_31611[(9)] = inst_31515);

(statearr_31611[(11)] = inst_31517);

(statearr_31611[(21)] = inst_31514);

return statearr_31611;
})();
var statearr_31612_31680 = state_31574__$1;
(statearr_31612_31680[(2)] = null);

(statearr_31612_31680[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (43))){
var state_31574__$1 = state_31574;
var statearr_31613_31681 = state_31574__$1;
(statearr_31613_31681[(2)] = null);

(statearr_31613_31681[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (29))){
var inst_31558 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31614_31682 = state_31574__$1;
(statearr_31614_31682[(2)] = inst_31558);

(statearr_31614_31682[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (44))){
var inst_31567 = (state_31574[(2)]);
var state_31574__$1 = (function (){var statearr_31615 = state_31574;
(statearr_31615[(28)] = inst_31567);

return statearr_31615;
})();
var statearr_31616_31683 = state_31574__$1;
(statearr_31616_31683[(2)] = null);

(statearr_31616_31683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (6))){
var inst_31506 = (state_31574[(29)]);
var inst_31505 = cljs.core.deref.call(null,cs);
var inst_31506__$1 = cljs.core.keys.call(null,inst_31505);
var inst_31507 = cljs.core.count.call(null,inst_31506__$1);
var inst_31508 = cljs.core.reset_BANG_.call(null,dctr,inst_31507);
var inst_31513 = cljs.core.seq.call(null,inst_31506__$1);
var inst_31514 = inst_31513;
var inst_31515 = null;
var inst_31516 = (0);
var inst_31517 = (0);
var state_31574__$1 = (function (){var statearr_31617 = state_31574;
(statearr_31617[(20)] = inst_31516);

(statearr_31617[(30)] = inst_31508);

(statearr_31617[(9)] = inst_31515);

(statearr_31617[(11)] = inst_31517);

(statearr_31617[(29)] = inst_31506__$1);

(statearr_31617[(21)] = inst_31514);

return statearr_31617;
})();
var statearr_31618_31684 = state_31574__$1;
(statearr_31618_31684[(2)] = null);

(statearr_31618_31684[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (28))){
var inst_31533 = (state_31574[(25)]);
var inst_31514 = (state_31574[(21)]);
var inst_31533__$1 = cljs.core.seq.call(null,inst_31514);
var state_31574__$1 = (function (){var statearr_31619 = state_31574;
(statearr_31619[(25)] = inst_31533__$1);

return statearr_31619;
})();
if(inst_31533__$1){
var statearr_31620_31685 = state_31574__$1;
(statearr_31620_31685[(1)] = (33));

} else {
var statearr_31621_31686 = state_31574__$1;
(statearr_31621_31686[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (25))){
var inst_31516 = (state_31574[(20)]);
var inst_31517 = (state_31574[(11)]);
var inst_31519 = (inst_31517 < inst_31516);
var inst_31520 = inst_31519;
var state_31574__$1 = state_31574;
if(cljs.core.truth_(inst_31520)){
var statearr_31622_31687 = state_31574__$1;
(statearr_31622_31687[(1)] = (27));

} else {
var statearr_31623_31688 = state_31574__$1;
(statearr_31623_31688[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (34))){
var state_31574__$1 = state_31574;
var statearr_31624_31689 = state_31574__$1;
(statearr_31624_31689[(2)] = null);

(statearr_31624_31689[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (17))){
var state_31574__$1 = state_31574;
var statearr_31625_31690 = state_31574__$1;
(statearr_31625_31690[(2)] = null);

(statearr_31625_31690[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (3))){
var inst_31572 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31574__$1,inst_31572);
} else {
if((state_val_31575 === (12))){
var inst_31501 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31626_31691 = state_31574__$1;
(statearr_31626_31691[(2)] = inst_31501);

(statearr_31626_31691[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (2))){
var state_31574__$1 = state_31574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31574__$1,(4),ch);
} else {
if((state_val_31575 === (23))){
var state_31574__$1 = state_31574;
var statearr_31627_31692 = state_31574__$1;
(statearr_31627_31692[(2)] = null);

(statearr_31627_31692[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (35))){
var inst_31556 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31628_31693 = state_31574__$1;
(statearr_31628_31693[(2)] = inst_31556);

(statearr_31628_31693[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (19))){
var inst_31473 = (state_31574[(7)]);
var inst_31477 = cljs.core.chunk_first.call(null,inst_31473);
var inst_31478 = cljs.core.chunk_rest.call(null,inst_31473);
var inst_31479 = cljs.core.count.call(null,inst_31477);
var inst_31451 = inst_31478;
var inst_31452 = inst_31477;
var inst_31453 = inst_31479;
var inst_31454 = (0);
var state_31574__$1 = (function (){var statearr_31629 = state_31574;
(statearr_31629[(13)] = inst_31453);

(statearr_31629[(15)] = inst_31454);

(statearr_31629[(16)] = inst_31451);

(statearr_31629[(17)] = inst_31452);

return statearr_31629;
})();
var statearr_31630_31694 = state_31574__$1;
(statearr_31630_31694[(2)] = null);

(statearr_31630_31694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (11))){
var inst_31473 = (state_31574[(7)]);
var inst_31451 = (state_31574[(16)]);
var inst_31473__$1 = cljs.core.seq.call(null,inst_31451);
var state_31574__$1 = (function (){var statearr_31631 = state_31574;
(statearr_31631[(7)] = inst_31473__$1);

return statearr_31631;
})();
if(inst_31473__$1){
var statearr_31632_31695 = state_31574__$1;
(statearr_31632_31695[(1)] = (16));

} else {
var statearr_31633_31696 = state_31574__$1;
(statearr_31633_31696[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (9))){
var inst_31503 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31634_31697 = state_31574__$1;
(statearr_31634_31697[(2)] = inst_31503);

(statearr_31634_31697[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (5))){
var inst_31449 = cljs.core.deref.call(null,cs);
var inst_31450 = cljs.core.seq.call(null,inst_31449);
var inst_31451 = inst_31450;
var inst_31452 = null;
var inst_31453 = (0);
var inst_31454 = (0);
var state_31574__$1 = (function (){var statearr_31635 = state_31574;
(statearr_31635[(13)] = inst_31453);

(statearr_31635[(15)] = inst_31454);

(statearr_31635[(16)] = inst_31451);

(statearr_31635[(17)] = inst_31452);

return statearr_31635;
})();
var statearr_31636_31698 = state_31574__$1;
(statearr_31636_31698[(2)] = null);

(statearr_31636_31698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (14))){
var state_31574__$1 = state_31574;
var statearr_31637_31699 = state_31574__$1;
(statearr_31637_31699[(2)] = null);

(statearr_31637_31699[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (45))){
var inst_31564 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31638_31700 = state_31574__$1;
(statearr_31638_31700[(2)] = inst_31564);

(statearr_31638_31700[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (26))){
var inst_31506 = (state_31574[(29)]);
var inst_31560 = (state_31574[(2)]);
var inst_31561 = cljs.core.seq.call(null,inst_31506);
var state_31574__$1 = (function (){var statearr_31639 = state_31574;
(statearr_31639[(31)] = inst_31560);

return statearr_31639;
})();
if(inst_31561){
var statearr_31640_31701 = state_31574__$1;
(statearr_31640_31701[(1)] = (42));

} else {
var statearr_31641_31702 = state_31574__$1;
(statearr_31641_31702[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (16))){
var inst_31473 = (state_31574[(7)]);
var inst_31475 = cljs.core.chunked_seq_QMARK_.call(null,inst_31473);
var state_31574__$1 = state_31574;
if(inst_31475){
var statearr_31642_31703 = state_31574__$1;
(statearr_31642_31703[(1)] = (19));

} else {
var statearr_31643_31704 = state_31574__$1;
(statearr_31643_31704[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (38))){
var inst_31553 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31644_31705 = state_31574__$1;
(statearr_31644_31705[(2)] = inst_31553);

(statearr_31644_31705[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (30))){
var state_31574__$1 = state_31574;
var statearr_31645_31706 = state_31574__$1;
(statearr_31645_31706[(2)] = null);

(statearr_31645_31706[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (10))){
var inst_31454 = (state_31574[(15)]);
var inst_31452 = (state_31574[(17)]);
var inst_31462 = cljs.core._nth.call(null,inst_31452,inst_31454);
var inst_31463 = cljs.core.nth.call(null,inst_31462,(0),null);
var inst_31464 = cljs.core.nth.call(null,inst_31462,(1),null);
var state_31574__$1 = (function (){var statearr_31646 = state_31574;
(statearr_31646[(26)] = inst_31463);

return statearr_31646;
})();
if(cljs.core.truth_(inst_31464)){
var statearr_31647_31707 = state_31574__$1;
(statearr_31647_31707[(1)] = (13));

} else {
var statearr_31648_31708 = state_31574__$1;
(statearr_31648_31708[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (18))){
var inst_31499 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31649_31709 = state_31574__$1;
(statearr_31649_31709[(2)] = inst_31499);

(statearr_31649_31709[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (42))){
var state_31574__$1 = state_31574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31574__$1,(45),dchan);
} else {
if((state_val_31575 === (37))){
var inst_31533 = (state_31574[(25)]);
var inst_31442 = (state_31574[(12)]);
var inst_31542 = (state_31574[(23)]);
var inst_31542__$1 = cljs.core.first.call(null,inst_31533);
var inst_31543 = cljs.core.async.put_BANG_.call(null,inst_31542__$1,inst_31442,done);
var state_31574__$1 = (function (){var statearr_31650 = state_31574;
(statearr_31650[(23)] = inst_31542__$1);

return statearr_31650;
})();
if(cljs.core.truth_(inst_31543)){
var statearr_31651_31710 = state_31574__$1;
(statearr_31651_31710[(1)] = (39));

} else {
var statearr_31652_31711 = state_31574__$1;
(statearr_31652_31711[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31575 === (8))){
var inst_31453 = (state_31574[(13)]);
var inst_31454 = (state_31574[(15)]);
var inst_31456 = (inst_31454 < inst_31453);
var inst_31457 = inst_31456;
var state_31574__$1 = state_31574;
if(cljs.core.truth_(inst_31457)){
var statearr_31653_31712 = state_31574__$1;
(statearr_31653_31712[(1)] = (10));

} else {
var statearr_31654_31713 = state_31574__$1;
(statearr_31654_31713[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___31659,cs,m,dchan,dctr,done))
;
return ((function (switch__30766__auto__,c__30854__auto___31659,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30767__auto__ = null;
var cljs$core$async$mult_$_state_machine__30767__auto____0 = (function (){
var statearr_31655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31655[(0)] = cljs$core$async$mult_$_state_machine__30767__auto__);

(statearr_31655[(1)] = (1));

return statearr_31655;
});
var cljs$core$async$mult_$_state_machine__30767__auto____1 = (function (state_31574){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31656){if((e31656 instanceof Object)){
var ex__30770__auto__ = e31656;
var statearr_31657_31714 = state_31574;
(statearr_31657_31714[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31574);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31715 = state_31574;
state_31574 = G__31715;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30767__auto__ = function(state_31574){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30767__auto____1.call(this,state_31574);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30767__auto____0;
cljs$core$async$mult_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30767__auto____1;
return cljs$core$async$mult_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___31659,cs,m,dchan,dctr,done))
})();
var state__30856__auto__ = (function (){var statearr_31658 = f__30855__auto__.call(null);
(statearr_31658[(6)] = c__30854__auto___31659);

return statearr_31658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___31659,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31717 = arguments.length;
switch (G__31717) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m);
} else {
var m__28637__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,state_map);
} else {
var m__28637__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28636__auto__ = (((m == null))?null:m);
var m__28637__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,m,mode);
} else {
var m__28637__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29124__auto__ = [];
var len__29117__auto___31729 = arguments.length;
var i__29118__auto___31730 = (0);
while(true){
if((i__29118__auto___31730 < len__29117__auto___31729)){
args__29124__auto__.push((arguments[i__29118__auto___31730]));

var G__31731 = (i__29118__auto___31730 + (1));
i__29118__auto___31730 = G__31731;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((3) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29125__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31723){
var map__31724 = p__31723;
var map__31724__$1 = ((((!((map__31724 == null)))?((((map__31724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31724.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31724):map__31724);
var opts = map__31724__$1;
var statearr_31726_31732 = state;
(statearr_31726_31732[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__31724,map__31724__$1,opts){
return (function (val){
var statearr_31727_31733 = state;
(statearr_31727_31733[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31724,map__31724__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_31728_31734 = state;
(statearr_31728_31734[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31719){
var G__31720 = cljs.core.first.call(null,seq31719);
var seq31719__$1 = cljs.core.next.call(null,seq31719);
var G__31721 = cljs.core.first.call(null,seq31719__$1);
var seq31719__$2 = cljs.core.next.call(null,seq31719__$1);
var G__31722 = cljs.core.first.call(null,seq31719__$2);
var seq31719__$3 = cljs.core.next.call(null,seq31719__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31720,G__31721,G__31722,seq31719__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31735 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31735 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31736){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31736 = meta31736;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31737,meta31736__$1){
var self__ = this;
var _31737__$1 = this;
return (new cljs.core.async.t_cljs$core$async31735(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31736__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31737){
var self__ = this;
var _31737__$1 = this;
return self__.meta31736;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31736","meta31736",59397799,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31735.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31735.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31735";

cljs.core.async.t_cljs$core$async31735.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async31735");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31735 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31735(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31736){
return (new cljs.core.async.t_cljs$core$async31735(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31736));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31735(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30854__auto___31899 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___31899,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___31899,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31839){
var state_val_31840 = (state_31839[(1)]);
if((state_val_31840 === (7))){
var inst_31754 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31841_31900 = state_31839__$1;
(statearr_31841_31900[(2)] = inst_31754);

(statearr_31841_31900[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (20))){
var inst_31766 = (state_31839[(7)]);
var state_31839__$1 = state_31839;
var statearr_31842_31901 = state_31839__$1;
(statearr_31842_31901[(2)] = inst_31766);

(statearr_31842_31901[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (27))){
var state_31839__$1 = state_31839;
var statearr_31843_31902 = state_31839__$1;
(statearr_31843_31902[(2)] = null);

(statearr_31843_31902[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (1))){
var inst_31741 = (state_31839[(8)]);
var inst_31741__$1 = calc_state.call(null);
var inst_31743 = (inst_31741__$1 == null);
var inst_31744 = cljs.core.not.call(null,inst_31743);
var state_31839__$1 = (function (){var statearr_31844 = state_31839;
(statearr_31844[(8)] = inst_31741__$1);

return statearr_31844;
})();
if(inst_31744){
var statearr_31845_31903 = state_31839__$1;
(statearr_31845_31903[(1)] = (2));

} else {
var statearr_31846_31904 = state_31839__$1;
(statearr_31846_31904[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (24))){
var inst_31813 = (state_31839[(9)]);
var inst_31799 = (state_31839[(10)]);
var inst_31790 = (state_31839[(11)]);
var inst_31813__$1 = inst_31790.call(null,inst_31799);
var state_31839__$1 = (function (){var statearr_31847 = state_31839;
(statearr_31847[(9)] = inst_31813__$1);

return statearr_31847;
})();
if(cljs.core.truth_(inst_31813__$1)){
var statearr_31848_31905 = state_31839__$1;
(statearr_31848_31905[(1)] = (29));

} else {
var statearr_31849_31906 = state_31839__$1;
(statearr_31849_31906[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (4))){
var inst_31757 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31757)){
var statearr_31850_31907 = state_31839__$1;
(statearr_31850_31907[(1)] = (8));

} else {
var statearr_31851_31908 = state_31839__$1;
(statearr_31851_31908[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (15))){
var inst_31784 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31784)){
var statearr_31852_31909 = state_31839__$1;
(statearr_31852_31909[(1)] = (19));

} else {
var statearr_31853_31910 = state_31839__$1;
(statearr_31853_31910[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (21))){
var inst_31789 = (state_31839[(12)]);
var inst_31789__$1 = (state_31839[(2)]);
var inst_31790 = cljs.core.get.call(null,inst_31789__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31791 = cljs.core.get.call(null,inst_31789__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31792 = cljs.core.get.call(null,inst_31789__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31839__$1 = (function (){var statearr_31854 = state_31839;
(statearr_31854[(12)] = inst_31789__$1);

(statearr_31854[(13)] = inst_31791);

(statearr_31854[(11)] = inst_31790);

return statearr_31854;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31839__$1,(22),inst_31792);
} else {
if((state_val_31840 === (31))){
var inst_31821 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31821)){
var statearr_31855_31911 = state_31839__$1;
(statearr_31855_31911[(1)] = (32));

} else {
var statearr_31856_31912 = state_31839__$1;
(statearr_31856_31912[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (32))){
var inst_31798 = (state_31839[(14)]);
var state_31839__$1 = state_31839;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31839__$1,(35),out,inst_31798);
} else {
if((state_val_31840 === (33))){
var inst_31789 = (state_31839[(12)]);
var inst_31766 = inst_31789;
var state_31839__$1 = (function (){var statearr_31857 = state_31839;
(statearr_31857[(7)] = inst_31766);

return statearr_31857;
})();
var statearr_31858_31913 = state_31839__$1;
(statearr_31858_31913[(2)] = null);

(statearr_31858_31913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (13))){
var inst_31766 = (state_31839[(7)]);
var inst_31773 = inst_31766.cljs$lang$protocol_mask$partition0$;
var inst_31774 = (inst_31773 & (64));
var inst_31775 = inst_31766.cljs$core$ISeq$;
var inst_31776 = (cljs.core.PROTOCOL_SENTINEL === inst_31775);
var inst_31777 = (inst_31774) || (inst_31776);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31777)){
var statearr_31859_31914 = state_31839__$1;
(statearr_31859_31914[(1)] = (16));

} else {
var statearr_31860_31915 = state_31839__$1;
(statearr_31860_31915[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (22))){
var inst_31798 = (state_31839[(14)]);
var inst_31799 = (state_31839[(10)]);
var inst_31797 = (state_31839[(2)]);
var inst_31798__$1 = cljs.core.nth.call(null,inst_31797,(0),null);
var inst_31799__$1 = cljs.core.nth.call(null,inst_31797,(1),null);
var inst_31800 = (inst_31798__$1 == null);
var inst_31801 = cljs.core._EQ_.call(null,inst_31799__$1,change);
var inst_31802 = (inst_31800) || (inst_31801);
var state_31839__$1 = (function (){var statearr_31861 = state_31839;
(statearr_31861[(14)] = inst_31798__$1);

(statearr_31861[(10)] = inst_31799__$1);

return statearr_31861;
})();
if(cljs.core.truth_(inst_31802)){
var statearr_31862_31916 = state_31839__$1;
(statearr_31862_31916[(1)] = (23));

} else {
var statearr_31863_31917 = state_31839__$1;
(statearr_31863_31917[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (36))){
var inst_31789 = (state_31839[(12)]);
var inst_31766 = inst_31789;
var state_31839__$1 = (function (){var statearr_31864 = state_31839;
(statearr_31864[(7)] = inst_31766);

return statearr_31864;
})();
var statearr_31865_31918 = state_31839__$1;
(statearr_31865_31918[(2)] = null);

(statearr_31865_31918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (29))){
var inst_31813 = (state_31839[(9)]);
var state_31839__$1 = state_31839;
var statearr_31866_31919 = state_31839__$1;
(statearr_31866_31919[(2)] = inst_31813);

(statearr_31866_31919[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (6))){
var state_31839__$1 = state_31839;
var statearr_31867_31920 = state_31839__$1;
(statearr_31867_31920[(2)] = false);

(statearr_31867_31920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (28))){
var inst_31809 = (state_31839[(2)]);
var inst_31810 = calc_state.call(null);
var inst_31766 = inst_31810;
var state_31839__$1 = (function (){var statearr_31868 = state_31839;
(statearr_31868[(15)] = inst_31809);

(statearr_31868[(7)] = inst_31766);

return statearr_31868;
})();
var statearr_31869_31921 = state_31839__$1;
(statearr_31869_31921[(2)] = null);

(statearr_31869_31921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (25))){
var inst_31835 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31870_31922 = state_31839__$1;
(statearr_31870_31922[(2)] = inst_31835);

(statearr_31870_31922[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (34))){
var inst_31833 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31871_31923 = state_31839__$1;
(statearr_31871_31923[(2)] = inst_31833);

(statearr_31871_31923[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (17))){
var state_31839__$1 = state_31839;
var statearr_31872_31924 = state_31839__$1;
(statearr_31872_31924[(2)] = false);

(statearr_31872_31924[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (3))){
var state_31839__$1 = state_31839;
var statearr_31873_31925 = state_31839__$1;
(statearr_31873_31925[(2)] = false);

(statearr_31873_31925[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (12))){
var inst_31837 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31839__$1,inst_31837);
} else {
if((state_val_31840 === (2))){
var inst_31741 = (state_31839[(8)]);
var inst_31746 = inst_31741.cljs$lang$protocol_mask$partition0$;
var inst_31747 = (inst_31746 & (64));
var inst_31748 = inst_31741.cljs$core$ISeq$;
var inst_31749 = (cljs.core.PROTOCOL_SENTINEL === inst_31748);
var inst_31750 = (inst_31747) || (inst_31749);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31750)){
var statearr_31874_31926 = state_31839__$1;
(statearr_31874_31926[(1)] = (5));

} else {
var statearr_31875_31927 = state_31839__$1;
(statearr_31875_31927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (23))){
var inst_31798 = (state_31839[(14)]);
var inst_31804 = (inst_31798 == null);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31804)){
var statearr_31876_31928 = state_31839__$1;
(statearr_31876_31928[(1)] = (26));

} else {
var statearr_31877_31929 = state_31839__$1;
(statearr_31877_31929[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (35))){
var inst_31824 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31824)){
var statearr_31878_31930 = state_31839__$1;
(statearr_31878_31930[(1)] = (36));

} else {
var statearr_31879_31931 = state_31839__$1;
(statearr_31879_31931[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (19))){
var inst_31766 = (state_31839[(7)]);
var inst_31786 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31766);
var state_31839__$1 = state_31839;
var statearr_31880_31932 = state_31839__$1;
(statearr_31880_31932[(2)] = inst_31786);

(statearr_31880_31932[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (11))){
var inst_31766 = (state_31839[(7)]);
var inst_31770 = (inst_31766 == null);
var inst_31771 = cljs.core.not.call(null,inst_31770);
var state_31839__$1 = state_31839;
if(inst_31771){
var statearr_31881_31933 = state_31839__$1;
(statearr_31881_31933[(1)] = (13));

} else {
var statearr_31882_31934 = state_31839__$1;
(statearr_31882_31934[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (9))){
var inst_31741 = (state_31839[(8)]);
var state_31839__$1 = state_31839;
var statearr_31883_31935 = state_31839__$1;
(statearr_31883_31935[(2)] = inst_31741);

(statearr_31883_31935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (5))){
var state_31839__$1 = state_31839;
var statearr_31884_31936 = state_31839__$1;
(statearr_31884_31936[(2)] = true);

(statearr_31884_31936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (14))){
var state_31839__$1 = state_31839;
var statearr_31885_31937 = state_31839__$1;
(statearr_31885_31937[(2)] = false);

(statearr_31885_31937[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (26))){
var inst_31799 = (state_31839[(10)]);
var inst_31806 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31799);
var state_31839__$1 = state_31839;
var statearr_31886_31938 = state_31839__$1;
(statearr_31886_31938[(2)] = inst_31806);

(statearr_31886_31938[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (16))){
var state_31839__$1 = state_31839;
var statearr_31887_31939 = state_31839__$1;
(statearr_31887_31939[(2)] = true);

(statearr_31887_31939[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (38))){
var inst_31829 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31888_31940 = state_31839__$1;
(statearr_31888_31940[(2)] = inst_31829);

(statearr_31888_31940[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (30))){
var inst_31791 = (state_31839[(13)]);
var inst_31799 = (state_31839[(10)]);
var inst_31790 = (state_31839[(11)]);
var inst_31816 = cljs.core.empty_QMARK_.call(null,inst_31790);
var inst_31817 = inst_31791.call(null,inst_31799);
var inst_31818 = cljs.core.not.call(null,inst_31817);
var inst_31819 = (inst_31816) && (inst_31818);
var state_31839__$1 = state_31839;
var statearr_31889_31941 = state_31839__$1;
(statearr_31889_31941[(2)] = inst_31819);

(statearr_31889_31941[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (10))){
var inst_31741 = (state_31839[(8)]);
var inst_31762 = (state_31839[(2)]);
var inst_31763 = cljs.core.get.call(null,inst_31762,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31764 = cljs.core.get.call(null,inst_31762,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31765 = cljs.core.get.call(null,inst_31762,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31766 = inst_31741;
var state_31839__$1 = (function (){var statearr_31890 = state_31839;
(statearr_31890[(16)] = inst_31764);

(statearr_31890[(7)] = inst_31766);

(statearr_31890[(17)] = inst_31763);

(statearr_31890[(18)] = inst_31765);

return statearr_31890;
})();
var statearr_31891_31942 = state_31839__$1;
(statearr_31891_31942[(2)] = null);

(statearr_31891_31942[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (18))){
var inst_31781 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31892_31943 = state_31839__$1;
(statearr_31892_31943[(2)] = inst_31781);

(statearr_31892_31943[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (37))){
var state_31839__$1 = state_31839;
var statearr_31893_31944 = state_31839__$1;
(statearr_31893_31944[(2)] = null);

(statearr_31893_31944[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31840 === (8))){
var inst_31741 = (state_31839[(8)]);
var inst_31759 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31741);
var state_31839__$1 = state_31839;
var statearr_31894_31945 = state_31839__$1;
(statearr_31894_31945[(2)] = inst_31759);

(statearr_31894_31945[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___31899,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30766__auto__,c__30854__auto___31899,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30767__auto__ = null;
var cljs$core$async$mix_$_state_machine__30767__auto____0 = (function (){
var statearr_31895 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31895[(0)] = cljs$core$async$mix_$_state_machine__30767__auto__);

(statearr_31895[(1)] = (1));

return statearr_31895;
});
var cljs$core$async$mix_$_state_machine__30767__auto____1 = (function (state_31839){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_31839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e31896){if((e31896 instanceof Object)){
var ex__30770__auto__ = e31896;
var statearr_31897_31946 = state_31839;
(statearr_31897_31946[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31839);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31896;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31947 = state_31839;
state_31839 = G__31947;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30767__auto__ = function(state_31839){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30767__auto____1.call(this,state_31839);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30767__auto____0;
cljs$core$async$mix_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30767__auto____1;
return cljs$core$async$mix_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___31899,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30856__auto__ = (function (){var statearr_31898 = f__30855__auto__.call(null);
(statearr_31898[(6)] = c__30854__auto___31899);

return statearr_31898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___31899,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28637__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p,v,ch);
} else {
var m__28637__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31949 = arguments.length;
switch (G__31949) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p);
} else {
var m__28637__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28636__auto__ = (((p == null))?null:p);
var m__28637__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28636__auto__)]);
if(!((m__28637__auto__ == null))){
return m__28637__auto__.call(null,p,v);
} else {
var m__28637__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28637__auto____$1 == null))){
return m__28637__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31953 = arguments.length;
switch (G__31953) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27953__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27953__auto__,mults){
return (function (p1__31951_SHARP_){
if(cljs.core.truth_(p1__31951_SHARP_.call(null,topic))){
return p1__31951_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31951_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27953__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31954 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31954 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31955){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31955 = meta31955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31956,meta31955__$1){
var self__ = this;
var _31956__$1 = this;
return (new cljs.core.async.t_cljs$core$async31954(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31955__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31956){
var self__ = this;
var _31956__$1 = this;
return self__.meta31955;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31955","meta31955",-596749227,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31954.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31954.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31954";

cljs.core.async.t_cljs$core$async31954.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async31954");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31954 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31954(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31955){
return (new cljs.core.async.t_cljs$core$async31954(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31955));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31954(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30854__auto___32074 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32074,mults,ensure_mult,p){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32074,mults,ensure_mult,p){
return (function (state_32028){
var state_val_32029 = (state_32028[(1)]);
if((state_val_32029 === (7))){
var inst_32024 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
var statearr_32030_32075 = state_32028__$1;
(statearr_32030_32075[(2)] = inst_32024);

(statearr_32030_32075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (20))){
var state_32028__$1 = state_32028;
var statearr_32031_32076 = state_32028__$1;
(statearr_32031_32076[(2)] = null);

(statearr_32031_32076[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (1))){
var state_32028__$1 = state_32028;
var statearr_32032_32077 = state_32028__$1;
(statearr_32032_32077[(2)] = null);

(statearr_32032_32077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (24))){
var inst_32007 = (state_32028[(7)]);
var inst_32016 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32007);
var state_32028__$1 = state_32028;
var statearr_32033_32078 = state_32028__$1;
(statearr_32033_32078[(2)] = inst_32016);

(statearr_32033_32078[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (4))){
var inst_31959 = (state_32028[(8)]);
var inst_31959__$1 = (state_32028[(2)]);
var inst_31960 = (inst_31959__$1 == null);
var state_32028__$1 = (function (){var statearr_32034 = state_32028;
(statearr_32034[(8)] = inst_31959__$1);

return statearr_32034;
})();
if(cljs.core.truth_(inst_31960)){
var statearr_32035_32079 = state_32028__$1;
(statearr_32035_32079[(1)] = (5));

} else {
var statearr_32036_32080 = state_32028__$1;
(statearr_32036_32080[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (15))){
var inst_32001 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
var statearr_32037_32081 = state_32028__$1;
(statearr_32037_32081[(2)] = inst_32001);

(statearr_32037_32081[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (21))){
var inst_32021 = (state_32028[(2)]);
var state_32028__$1 = (function (){var statearr_32038 = state_32028;
(statearr_32038[(9)] = inst_32021);

return statearr_32038;
})();
var statearr_32039_32082 = state_32028__$1;
(statearr_32039_32082[(2)] = null);

(statearr_32039_32082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (13))){
var inst_31983 = (state_32028[(10)]);
var inst_31985 = cljs.core.chunked_seq_QMARK_.call(null,inst_31983);
var state_32028__$1 = state_32028;
if(inst_31985){
var statearr_32040_32083 = state_32028__$1;
(statearr_32040_32083[(1)] = (16));

} else {
var statearr_32041_32084 = state_32028__$1;
(statearr_32041_32084[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (22))){
var inst_32013 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
if(cljs.core.truth_(inst_32013)){
var statearr_32042_32085 = state_32028__$1;
(statearr_32042_32085[(1)] = (23));

} else {
var statearr_32043_32086 = state_32028__$1;
(statearr_32043_32086[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (6))){
var inst_32009 = (state_32028[(11)]);
var inst_32007 = (state_32028[(7)]);
var inst_31959 = (state_32028[(8)]);
var inst_32007__$1 = topic_fn.call(null,inst_31959);
var inst_32008 = cljs.core.deref.call(null,mults);
var inst_32009__$1 = cljs.core.get.call(null,inst_32008,inst_32007__$1);
var state_32028__$1 = (function (){var statearr_32044 = state_32028;
(statearr_32044[(11)] = inst_32009__$1);

(statearr_32044[(7)] = inst_32007__$1);

return statearr_32044;
})();
if(cljs.core.truth_(inst_32009__$1)){
var statearr_32045_32087 = state_32028__$1;
(statearr_32045_32087[(1)] = (19));

} else {
var statearr_32046_32088 = state_32028__$1;
(statearr_32046_32088[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (25))){
var inst_32018 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
var statearr_32047_32089 = state_32028__$1;
(statearr_32047_32089[(2)] = inst_32018);

(statearr_32047_32089[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (17))){
var inst_31983 = (state_32028[(10)]);
var inst_31992 = cljs.core.first.call(null,inst_31983);
var inst_31993 = cljs.core.async.muxch_STAR_.call(null,inst_31992);
var inst_31994 = cljs.core.async.close_BANG_.call(null,inst_31993);
var inst_31995 = cljs.core.next.call(null,inst_31983);
var inst_31969 = inst_31995;
var inst_31970 = null;
var inst_31971 = (0);
var inst_31972 = (0);
var state_32028__$1 = (function (){var statearr_32048 = state_32028;
(statearr_32048[(12)] = inst_31969);

(statearr_32048[(13)] = inst_31971);

(statearr_32048[(14)] = inst_31970);

(statearr_32048[(15)] = inst_31972);

(statearr_32048[(16)] = inst_31994);

return statearr_32048;
})();
var statearr_32049_32090 = state_32028__$1;
(statearr_32049_32090[(2)] = null);

(statearr_32049_32090[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (3))){
var inst_32026 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32028__$1,inst_32026);
} else {
if((state_val_32029 === (12))){
var inst_32003 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
var statearr_32050_32091 = state_32028__$1;
(statearr_32050_32091[(2)] = inst_32003);

(statearr_32050_32091[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (2))){
var state_32028__$1 = state_32028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32028__$1,(4),ch);
} else {
if((state_val_32029 === (23))){
var state_32028__$1 = state_32028;
var statearr_32051_32092 = state_32028__$1;
(statearr_32051_32092[(2)] = null);

(statearr_32051_32092[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (19))){
var inst_32009 = (state_32028[(11)]);
var inst_31959 = (state_32028[(8)]);
var inst_32011 = cljs.core.async.muxch_STAR_.call(null,inst_32009);
var state_32028__$1 = state_32028;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32028__$1,(22),inst_32011,inst_31959);
} else {
if((state_val_32029 === (11))){
var inst_31969 = (state_32028[(12)]);
var inst_31983 = (state_32028[(10)]);
var inst_31983__$1 = cljs.core.seq.call(null,inst_31969);
var state_32028__$1 = (function (){var statearr_32052 = state_32028;
(statearr_32052[(10)] = inst_31983__$1);

return statearr_32052;
})();
if(inst_31983__$1){
var statearr_32053_32093 = state_32028__$1;
(statearr_32053_32093[(1)] = (13));

} else {
var statearr_32054_32094 = state_32028__$1;
(statearr_32054_32094[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (9))){
var inst_32005 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
var statearr_32055_32095 = state_32028__$1;
(statearr_32055_32095[(2)] = inst_32005);

(statearr_32055_32095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (5))){
var inst_31966 = cljs.core.deref.call(null,mults);
var inst_31967 = cljs.core.vals.call(null,inst_31966);
var inst_31968 = cljs.core.seq.call(null,inst_31967);
var inst_31969 = inst_31968;
var inst_31970 = null;
var inst_31971 = (0);
var inst_31972 = (0);
var state_32028__$1 = (function (){var statearr_32056 = state_32028;
(statearr_32056[(12)] = inst_31969);

(statearr_32056[(13)] = inst_31971);

(statearr_32056[(14)] = inst_31970);

(statearr_32056[(15)] = inst_31972);

return statearr_32056;
})();
var statearr_32057_32096 = state_32028__$1;
(statearr_32057_32096[(2)] = null);

(statearr_32057_32096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (14))){
var state_32028__$1 = state_32028;
var statearr_32061_32097 = state_32028__$1;
(statearr_32061_32097[(2)] = null);

(statearr_32061_32097[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (16))){
var inst_31983 = (state_32028[(10)]);
var inst_31987 = cljs.core.chunk_first.call(null,inst_31983);
var inst_31988 = cljs.core.chunk_rest.call(null,inst_31983);
var inst_31989 = cljs.core.count.call(null,inst_31987);
var inst_31969 = inst_31988;
var inst_31970 = inst_31987;
var inst_31971 = inst_31989;
var inst_31972 = (0);
var state_32028__$1 = (function (){var statearr_32062 = state_32028;
(statearr_32062[(12)] = inst_31969);

(statearr_32062[(13)] = inst_31971);

(statearr_32062[(14)] = inst_31970);

(statearr_32062[(15)] = inst_31972);

return statearr_32062;
})();
var statearr_32063_32098 = state_32028__$1;
(statearr_32063_32098[(2)] = null);

(statearr_32063_32098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (10))){
var inst_31969 = (state_32028[(12)]);
var inst_31971 = (state_32028[(13)]);
var inst_31970 = (state_32028[(14)]);
var inst_31972 = (state_32028[(15)]);
var inst_31977 = cljs.core._nth.call(null,inst_31970,inst_31972);
var inst_31978 = cljs.core.async.muxch_STAR_.call(null,inst_31977);
var inst_31979 = cljs.core.async.close_BANG_.call(null,inst_31978);
var inst_31980 = (inst_31972 + (1));
var tmp32058 = inst_31969;
var tmp32059 = inst_31971;
var tmp32060 = inst_31970;
var inst_31969__$1 = tmp32058;
var inst_31970__$1 = tmp32060;
var inst_31971__$1 = tmp32059;
var inst_31972__$1 = inst_31980;
var state_32028__$1 = (function (){var statearr_32064 = state_32028;
(statearr_32064[(17)] = inst_31979);

(statearr_32064[(12)] = inst_31969__$1);

(statearr_32064[(13)] = inst_31971__$1);

(statearr_32064[(14)] = inst_31970__$1);

(statearr_32064[(15)] = inst_31972__$1);

return statearr_32064;
})();
var statearr_32065_32099 = state_32028__$1;
(statearr_32065_32099[(2)] = null);

(statearr_32065_32099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (18))){
var inst_31998 = (state_32028[(2)]);
var state_32028__$1 = state_32028;
var statearr_32066_32100 = state_32028__$1;
(statearr_32066_32100[(2)] = inst_31998);

(statearr_32066_32100[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32029 === (8))){
var inst_31971 = (state_32028[(13)]);
var inst_31972 = (state_32028[(15)]);
var inst_31974 = (inst_31972 < inst_31971);
var inst_31975 = inst_31974;
var state_32028__$1 = state_32028;
if(cljs.core.truth_(inst_31975)){
var statearr_32067_32101 = state_32028__$1;
(statearr_32067_32101[(1)] = (10));

} else {
var statearr_32068_32102 = state_32028__$1;
(statearr_32068_32102[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32074,mults,ensure_mult,p))
;
return ((function (switch__30766__auto__,c__30854__auto___32074,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32069 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32069[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32069[(1)] = (1));

return statearr_32069;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32028){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32070){if((e32070 instanceof Object)){
var ex__30770__auto__ = e32070;
var statearr_32071_32103 = state_32028;
(statearr_32071_32103[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32070;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32104 = state_32028;
state_32028 = G__32104;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32028){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32028);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32074,mults,ensure_mult,p))
})();
var state__30856__auto__ = (function (){var statearr_32072 = f__30855__auto__.call(null);
(statearr_32072[(6)] = c__30854__auto___32074);

return statearr_32072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32074,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32106 = arguments.length;
switch (G__32106) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32109 = arguments.length;
switch (G__32109) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32112 = arguments.length;
switch (G__32112) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30854__auto___32179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32179,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32179,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32151){
var state_val_32152 = (state_32151[(1)]);
if((state_val_32152 === (7))){
var state_32151__$1 = state_32151;
var statearr_32153_32180 = state_32151__$1;
(statearr_32153_32180[(2)] = null);

(statearr_32153_32180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (1))){
var state_32151__$1 = state_32151;
var statearr_32154_32181 = state_32151__$1;
(statearr_32154_32181[(2)] = null);

(statearr_32154_32181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (4))){
var inst_32115 = (state_32151[(7)]);
var inst_32117 = (inst_32115 < cnt);
var state_32151__$1 = state_32151;
if(cljs.core.truth_(inst_32117)){
var statearr_32155_32182 = state_32151__$1;
(statearr_32155_32182[(1)] = (6));

} else {
var statearr_32156_32183 = state_32151__$1;
(statearr_32156_32183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (15))){
var inst_32147 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32157_32184 = state_32151__$1;
(statearr_32157_32184[(2)] = inst_32147);

(statearr_32157_32184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (13))){
var inst_32140 = cljs.core.async.close_BANG_.call(null,out);
var state_32151__$1 = state_32151;
var statearr_32158_32185 = state_32151__$1;
(statearr_32158_32185[(2)] = inst_32140);

(statearr_32158_32185[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (6))){
var state_32151__$1 = state_32151;
var statearr_32159_32186 = state_32151__$1;
(statearr_32159_32186[(2)] = null);

(statearr_32159_32186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (3))){
var inst_32149 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32151__$1,inst_32149);
} else {
if((state_val_32152 === (12))){
var inst_32137 = (state_32151[(8)]);
var inst_32137__$1 = (state_32151[(2)]);
var inst_32138 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32137__$1);
var state_32151__$1 = (function (){var statearr_32160 = state_32151;
(statearr_32160[(8)] = inst_32137__$1);

return statearr_32160;
})();
if(cljs.core.truth_(inst_32138)){
var statearr_32161_32187 = state_32151__$1;
(statearr_32161_32187[(1)] = (13));

} else {
var statearr_32162_32188 = state_32151__$1;
(statearr_32162_32188[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (2))){
var inst_32114 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32115 = (0);
var state_32151__$1 = (function (){var statearr_32163 = state_32151;
(statearr_32163[(9)] = inst_32114);

(statearr_32163[(7)] = inst_32115);

return statearr_32163;
})();
var statearr_32164_32189 = state_32151__$1;
(statearr_32164_32189[(2)] = null);

(statearr_32164_32189[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (11))){
var inst_32115 = (state_32151[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32151,(10),Object,null,(9));
var inst_32124 = chs__$1.call(null,inst_32115);
var inst_32125 = done.call(null,inst_32115);
var inst_32126 = cljs.core.async.take_BANG_.call(null,inst_32124,inst_32125);
var state_32151__$1 = state_32151;
var statearr_32165_32190 = state_32151__$1;
(statearr_32165_32190[(2)] = inst_32126);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32151__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (9))){
var inst_32115 = (state_32151[(7)]);
var inst_32128 = (state_32151[(2)]);
var inst_32129 = (inst_32115 + (1));
var inst_32115__$1 = inst_32129;
var state_32151__$1 = (function (){var statearr_32166 = state_32151;
(statearr_32166[(10)] = inst_32128);

(statearr_32166[(7)] = inst_32115__$1);

return statearr_32166;
})();
var statearr_32167_32191 = state_32151__$1;
(statearr_32167_32191[(2)] = null);

(statearr_32167_32191[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (5))){
var inst_32135 = (state_32151[(2)]);
var state_32151__$1 = (function (){var statearr_32168 = state_32151;
(statearr_32168[(11)] = inst_32135);

return statearr_32168;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32151__$1,(12),dchan);
} else {
if((state_val_32152 === (14))){
var inst_32137 = (state_32151[(8)]);
var inst_32142 = cljs.core.apply.call(null,f,inst_32137);
var state_32151__$1 = state_32151;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32151__$1,(16),out,inst_32142);
} else {
if((state_val_32152 === (16))){
var inst_32144 = (state_32151[(2)]);
var state_32151__$1 = (function (){var statearr_32169 = state_32151;
(statearr_32169[(12)] = inst_32144);

return statearr_32169;
})();
var statearr_32170_32192 = state_32151__$1;
(statearr_32170_32192[(2)] = null);

(statearr_32170_32192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (10))){
var inst_32119 = (state_32151[(2)]);
var inst_32120 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32151__$1 = (function (){var statearr_32171 = state_32151;
(statearr_32171[(13)] = inst_32119);

return statearr_32171;
})();
var statearr_32172_32193 = state_32151__$1;
(statearr_32172_32193[(2)] = inst_32120);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32151__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (8))){
var inst_32133 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32173_32194 = state_32151__$1;
(statearr_32173_32194[(2)] = inst_32133);

(statearr_32173_32194[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32179,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30766__auto__,c__30854__auto___32179,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32174[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32174[(1)] = (1));

return statearr_32174;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32151){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32175){if((e32175 instanceof Object)){
var ex__30770__auto__ = e32175;
var statearr_32176_32195 = state_32151;
(statearr_32176_32195[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32151);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32175;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32196 = state_32151;
state_32151 = G__32196;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32151){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32151);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32179,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30856__auto__ = (function (){var statearr_32177 = f__30855__auto__.call(null);
(statearr_32177[(6)] = c__30854__auto___32179);

return statearr_32177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32179,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32199 = arguments.length;
switch (G__32199) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30854__auto___32253 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32253,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32253,out){
return (function (state_32231){
var state_val_32232 = (state_32231[(1)]);
if((state_val_32232 === (7))){
var inst_32210 = (state_32231[(7)]);
var inst_32211 = (state_32231[(8)]);
var inst_32210__$1 = (state_32231[(2)]);
var inst_32211__$1 = cljs.core.nth.call(null,inst_32210__$1,(0),null);
var inst_32212 = cljs.core.nth.call(null,inst_32210__$1,(1),null);
var inst_32213 = (inst_32211__$1 == null);
var state_32231__$1 = (function (){var statearr_32233 = state_32231;
(statearr_32233[(9)] = inst_32212);

(statearr_32233[(7)] = inst_32210__$1);

(statearr_32233[(8)] = inst_32211__$1);

return statearr_32233;
})();
if(cljs.core.truth_(inst_32213)){
var statearr_32234_32254 = state_32231__$1;
(statearr_32234_32254[(1)] = (8));

} else {
var statearr_32235_32255 = state_32231__$1;
(statearr_32235_32255[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (1))){
var inst_32200 = cljs.core.vec.call(null,chs);
var inst_32201 = inst_32200;
var state_32231__$1 = (function (){var statearr_32236 = state_32231;
(statearr_32236[(10)] = inst_32201);

return statearr_32236;
})();
var statearr_32237_32256 = state_32231__$1;
(statearr_32237_32256[(2)] = null);

(statearr_32237_32256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (4))){
var inst_32201 = (state_32231[(10)]);
var state_32231__$1 = state_32231;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32231__$1,(7),inst_32201);
} else {
if((state_val_32232 === (6))){
var inst_32227 = (state_32231[(2)]);
var state_32231__$1 = state_32231;
var statearr_32238_32257 = state_32231__$1;
(statearr_32238_32257[(2)] = inst_32227);

(statearr_32238_32257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (3))){
var inst_32229 = (state_32231[(2)]);
var state_32231__$1 = state_32231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32231__$1,inst_32229);
} else {
if((state_val_32232 === (2))){
var inst_32201 = (state_32231[(10)]);
var inst_32203 = cljs.core.count.call(null,inst_32201);
var inst_32204 = (inst_32203 > (0));
var state_32231__$1 = state_32231;
if(cljs.core.truth_(inst_32204)){
var statearr_32240_32258 = state_32231__$1;
(statearr_32240_32258[(1)] = (4));

} else {
var statearr_32241_32259 = state_32231__$1;
(statearr_32241_32259[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (11))){
var inst_32201 = (state_32231[(10)]);
var inst_32220 = (state_32231[(2)]);
var tmp32239 = inst_32201;
var inst_32201__$1 = tmp32239;
var state_32231__$1 = (function (){var statearr_32242 = state_32231;
(statearr_32242[(10)] = inst_32201__$1);

(statearr_32242[(11)] = inst_32220);

return statearr_32242;
})();
var statearr_32243_32260 = state_32231__$1;
(statearr_32243_32260[(2)] = null);

(statearr_32243_32260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (9))){
var inst_32211 = (state_32231[(8)]);
var state_32231__$1 = state_32231;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32231__$1,(11),out,inst_32211);
} else {
if((state_val_32232 === (5))){
var inst_32225 = cljs.core.async.close_BANG_.call(null,out);
var state_32231__$1 = state_32231;
var statearr_32244_32261 = state_32231__$1;
(statearr_32244_32261[(2)] = inst_32225);

(statearr_32244_32261[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (10))){
var inst_32223 = (state_32231[(2)]);
var state_32231__$1 = state_32231;
var statearr_32245_32262 = state_32231__$1;
(statearr_32245_32262[(2)] = inst_32223);

(statearr_32245_32262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32232 === (8))){
var inst_32212 = (state_32231[(9)]);
var inst_32210 = (state_32231[(7)]);
var inst_32201 = (state_32231[(10)]);
var inst_32211 = (state_32231[(8)]);
var inst_32215 = (function (){var cs = inst_32201;
var vec__32206 = inst_32210;
var v = inst_32211;
var c = inst_32212;
return ((function (cs,vec__32206,v,c,inst_32212,inst_32210,inst_32201,inst_32211,state_val_32232,c__30854__auto___32253,out){
return (function (p1__32197_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32197_SHARP_);
});
;})(cs,vec__32206,v,c,inst_32212,inst_32210,inst_32201,inst_32211,state_val_32232,c__30854__auto___32253,out))
})();
var inst_32216 = cljs.core.filterv.call(null,inst_32215,inst_32201);
var inst_32201__$1 = inst_32216;
var state_32231__$1 = (function (){var statearr_32246 = state_32231;
(statearr_32246[(10)] = inst_32201__$1);

return statearr_32246;
})();
var statearr_32247_32263 = state_32231__$1;
(statearr_32247_32263[(2)] = null);

(statearr_32247_32263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32253,out))
;
return ((function (switch__30766__auto__,c__30854__auto___32253,out){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32248 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32248[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32248[(1)] = (1));

return statearr_32248;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32231){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32249){if((e32249 instanceof Object)){
var ex__30770__auto__ = e32249;
var statearr_32250_32264 = state_32231;
(statearr_32250_32264[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32231);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32249;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32265 = state_32231;
state_32231 = G__32265;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32231){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32231);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32253,out))
})();
var state__30856__auto__ = (function (){var statearr_32251 = f__30855__auto__.call(null);
(statearr_32251[(6)] = c__30854__auto___32253);

return statearr_32251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32253,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32267 = arguments.length;
switch (G__32267) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30854__auto___32312 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32312,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32312,out){
return (function (state_32291){
var state_val_32292 = (state_32291[(1)]);
if((state_val_32292 === (7))){
var inst_32273 = (state_32291[(7)]);
var inst_32273__$1 = (state_32291[(2)]);
var inst_32274 = (inst_32273__$1 == null);
var inst_32275 = cljs.core.not.call(null,inst_32274);
var state_32291__$1 = (function (){var statearr_32293 = state_32291;
(statearr_32293[(7)] = inst_32273__$1);

return statearr_32293;
})();
if(inst_32275){
var statearr_32294_32313 = state_32291__$1;
(statearr_32294_32313[(1)] = (8));

} else {
var statearr_32295_32314 = state_32291__$1;
(statearr_32295_32314[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (1))){
var inst_32268 = (0);
var state_32291__$1 = (function (){var statearr_32296 = state_32291;
(statearr_32296[(8)] = inst_32268);

return statearr_32296;
})();
var statearr_32297_32315 = state_32291__$1;
(statearr_32297_32315[(2)] = null);

(statearr_32297_32315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (4))){
var state_32291__$1 = state_32291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32291__$1,(7),ch);
} else {
if((state_val_32292 === (6))){
var inst_32286 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32298_32316 = state_32291__$1;
(statearr_32298_32316[(2)] = inst_32286);

(statearr_32298_32316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (3))){
var inst_32288 = (state_32291[(2)]);
var inst_32289 = cljs.core.async.close_BANG_.call(null,out);
var state_32291__$1 = (function (){var statearr_32299 = state_32291;
(statearr_32299[(9)] = inst_32288);

return statearr_32299;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32291__$1,inst_32289);
} else {
if((state_val_32292 === (2))){
var inst_32268 = (state_32291[(8)]);
var inst_32270 = (inst_32268 < n);
var state_32291__$1 = state_32291;
if(cljs.core.truth_(inst_32270)){
var statearr_32300_32317 = state_32291__$1;
(statearr_32300_32317[(1)] = (4));

} else {
var statearr_32301_32318 = state_32291__$1;
(statearr_32301_32318[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (11))){
var inst_32268 = (state_32291[(8)]);
var inst_32278 = (state_32291[(2)]);
var inst_32279 = (inst_32268 + (1));
var inst_32268__$1 = inst_32279;
var state_32291__$1 = (function (){var statearr_32302 = state_32291;
(statearr_32302[(8)] = inst_32268__$1);

(statearr_32302[(10)] = inst_32278);

return statearr_32302;
})();
var statearr_32303_32319 = state_32291__$1;
(statearr_32303_32319[(2)] = null);

(statearr_32303_32319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (9))){
var state_32291__$1 = state_32291;
var statearr_32304_32320 = state_32291__$1;
(statearr_32304_32320[(2)] = null);

(statearr_32304_32320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (5))){
var state_32291__$1 = state_32291;
var statearr_32305_32321 = state_32291__$1;
(statearr_32305_32321[(2)] = null);

(statearr_32305_32321[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (10))){
var inst_32283 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32306_32322 = state_32291__$1;
(statearr_32306_32322[(2)] = inst_32283);

(statearr_32306_32322[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (8))){
var inst_32273 = (state_32291[(7)]);
var state_32291__$1 = state_32291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32291__$1,(11),out,inst_32273);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32312,out))
;
return ((function (switch__30766__auto__,c__30854__auto___32312,out){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32307 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32307[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32307[(1)] = (1));

return statearr_32307;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32291){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32308){if((e32308 instanceof Object)){
var ex__30770__auto__ = e32308;
var statearr_32309_32323 = state_32291;
(statearr_32309_32323[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32308;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32324 = state_32291;
state_32291 = G__32324;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32291){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32291);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32312,out))
})();
var state__30856__auto__ = (function (){var statearr_32310 = f__30855__auto__.call(null);
(statearr_32310[(6)] = c__30854__auto___32312);

return statearr_32310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32312,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32326 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32326 = (function (f,ch,meta32327){
this.f = f;
this.ch = ch;
this.meta32327 = meta32327;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32328,meta32327__$1){
var self__ = this;
var _32328__$1 = this;
return (new cljs.core.async.t_cljs$core$async32326(self__.f,self__.ch,meta32327__$1));
});

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32328){
var self__ = this;
var _32328__$1 = this;
return self__.meta32327;
});

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32329 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32329 = (function (f,ch,meta32327,_,fn1,meta32330){
this.f = f;
this.ch = ch;
this.meta32327 = meta32327;
this._ = _;
this.fn1 = fn1;
this.meta32330 = meta32330;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32329.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32331,meta32330__$1){
var self__ = this;
var _32331__$1 = this;
return (new cljs.core.async.t_cljs$core$async32329(self__.f,self__.ch,self__.meta32327,self__._,self__.fn1,meta32330__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32329.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32331){
var self__ = this;
var _32331__$1 = this;
return self__.meta32330;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32329.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32329.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32329.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32329.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32325_SHARP_){
return f1.call(null,(((p1__32325_SHARP_ == null))?null:self__.f.call(null,p1__32325_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32329.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32327","meta32327",1737122576,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32326","cljs.core.async/t_cljs$core$async32326",972698589,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32330","meta32330",-654266956,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32329.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32329.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32329";

cljs.core.async.t_cljs$core$async32329.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async32329");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32329 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32329(f__$1,ch__$1,meta32327__$1,___$2,fn1__$1,meta32330){
return (new cljs.core.async.t_cljs$core$async32329(f__$1,ch__$1,meta32327__$1,___$2,fn1__$1,meta32330));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32329(self__.f,self__.ch,self__.meta32327,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27941__auto__ = ret;
if(cljs.core.truth_(and__27941__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27941__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32326.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32326.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32327","meta32327",1737122576,null)], null);
});

cljs.core.async.t_cljs$core$async32326.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32326.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32326";

cljs.core.async.t_cljs$core$async32326.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async32326");
});

cljs.core.async.__GT_t_cljs$core$async32326 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32326(f__$1,ch__$1,meta32327){
return (new cljs.core.async.t_cljs$core$async32326(f__$1,ch__$1,meta32327));
});

}

return (new cljs.core.async.t_cljs$core$async32326(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32332 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32332 = (function (f,ch,meta32333){
this.f = f;
this.ch = ch;
this.meta32333 = meta32333;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32334,meta32333__$1){
var self__ = this;
var _32334__$1 = this;
return (new cljs.core.async.t_cljs$core$async32332(self__.f,self__.ch,meta32333__$1));
});

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32334){
var self__ = this;
var _32334__$1 = this;
return self__.meta32333;
});

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32332.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32332.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32333","meta32333",131171170,null)], null);
});

cljs.core.async.t_cljs$core$async32332.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32332.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32332";

cljs.core.async.t_cljs$core$async32332.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async32332");
});

cljs.core.async.__GT_t_cljs$core$async32332 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32332(f__$1,ch__$1,meta32333){
return (new cljs.core.async.t_cljs$core$async32332(f__$1,ch__$1,meta32333));
});

}

return (new cljs.core.async.t_cljs$core$async32332(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32335 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32335 = (function (p,ch,meta32336){
this.p = p;
this.ch = ch;
this.meta32336 = meta32336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32337,meta32336__$1){
var self__ = this;
var _32337__$1 = this;
return (new cljs.core.async.t_cljs$core$async32335(self__.p,self__.ch,meta32336__$1));
});

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32337){
var self__ = this;
var _32337__$1 = this;
return self__.meta32336;
});

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32335.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32336","meta32336",-1741368757,null)], null);
});

cljs.core.async.t_cljs$core$async32335.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32335.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32335";

cljs.core.async.t_cljs$core$async32335.cljs$lang$ctorPrWriter = (function (this__28578__auto__,writer__28579__auto__,opt__28580__auto__){
return cljs.core._write.call(null,writer__28579__auto__,"cljs.core.async/t_cljs$core$async32335");
});

cljs.core.async.__GT_t_cljs$core$async32335 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32335(p__$1,ch__$1,meta32336){
return (new cljs.core.async.t_cljs$core$async32335(p__$1,ch__$1,meta32336));
});

}

return (new cljs.core.async.t_cljs$core$async32335(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32339 = arguments.length;
switch (G__32339) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30854__auto___32379 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32379,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32379,out){
return (function (state_32360){
var state_val_32361 = (state_32360[(1)]);
if((state_val_32361 === (7))){
var inst_32356 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
var statearr_32362_32380 = state_32360__$1;
(statearr_32362_32380[(2)] = inst_32356);

(statearr_32362_32380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (1))){
var state_32360__$1 = state_32360;
var statearr_32363_32381 = state_32360__$1;
(statearr_32363_32381[(2)] = null);

(statearr_32363_32381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (4))){
var inst_32342 = (state_32360[(7)]);
var inst_32342__$1 = (state_32360[(2)]);
var inst_32343 = (inst_32342__$1 == null);
var state_32360__$1 = (function (){var statearr_32364 = state_32360;
(statearr_32364[(7)] = inst_32342__$1);

return statearr_32364;
})();
if(cljs.core.truth_(inst_32343)){
var statearr_32365_32382 = state_32360__$1;
(statearr_32365_32382[(1)] = (5));

} else {
var statearr_32366_32383 = state_32360__$1;
(statearr_32366_32383[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (6))){
var inst_32342 = (state_32360[(7)]);
var inst_32347 = p.call(null,inst_32342);
var state_32360__$1 = state_32360;
if(cljs.core.truth_(inst_32347)){
var statearr_32367_32384 = state_32360__$1;
(statearr_32367_32384[(1)] = (8));

} else {
var statearr_32368_32385 = state_32360__$1;
(statearr_32368_32385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (3))){
var inst_32358 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32360__$1,inst_32358);
} else {
if((state_val_32361 === (2))){
var state_32360__$1 = state_32360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32360__$1,(4),ch);
} else {
if((state_val_32361 === (11))){
var inst_32350 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
var statearr_32369_32386 = state_32360__$1;
(statearr_32369_32386[(2)] = inst_32350);

(statearr_32369_32386[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (9))){
var state_32360__$1 = state_32360;
var statearr_32370_32387 = state_32360__$1;
(statearr_32370_32387[(2)] = null);

(statearr_32370_32387[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (5))){
var inst_32345 = cljs.core.async.close_BANG_.call(null,out);
var state_32360__$1 = state_32360;
var statearr_32371_32388 = state_32360__$1;
(statearr_32371_32388[(2)] = inst_32345);

(statearr_32371_32388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (10))){
var inst_32353 = (state_32360[(2)]);
var state_32360__$1 = (function (){var statearr_32372 = state_32360;
(statearr_32372[(8)] = inst_32353);

return statearr_32372;
})();
var statearr_32373_32389 = state_32360__$1;
(statearr_32373_32389[(2)] = null);

(statearr_32373_32389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (8))){
var inst_32342 = (state_32360[(7)]);
var state_32360__$1 = state_32360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32360__$1,(11),out,inst_32342);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32379,out))
;
return ((function (switch__30766__auto__,c__30854__auto___32379,out){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32374 = [null,null,null,null,null,null,null,null,null];
(statearr_32374[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32374[(1)] = (1));

return statearr_32374;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32360){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32375){if((e32375 instanceof Object)){
var ex__30770__auto__ = e32375;
var statearr_32376_32390 = state_32360;
(statearr_32376_32390[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32375;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32391 = state_32360;
state_32360 = G__32391;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32360);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32379,out))
})();
var state__30856__auto__ = (function (){var statearr_32377 = f__30855__auto__.call(null);
(statearr_32377[(6)] = c__30854__auto___32379);

return statearr_32377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32379,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32393 = arguments.length;
switch (G__32393) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__){
return (function (state_32456){
var state_val_32457 = (state_32456[(1)]);
if((state_val_32457 === (7))){
var inst_32452 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32458_32496 = state_32456__$1;
(statearr_32458_32496[(2)] = inst_32452);

(statearr_32458_32496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (20))){
var inst_32422 = (state_32456[(7)]);
var inst_32433 = (state_32456[(2)]);
var inst_32434 = cljs.core.next.call(null,inst_32422);
var inst_32408 = inst_32434;
var inst_32409 = null;
var inst_32410 = (0);
var inst_32411 = (0);
var state_32456__$1 = (function (){var statearr_32459 = state_32456;
(statearr_32459[(8)] = inst_32411);

(statearr_32459[(9)] = inst_32433);

(statearr_32459[(10)] = inst_32410);

(statearr_32459[(11)] = inst_32409);

(statearr_32459[(12)] = inst_32408);

return statearr_32459;
})();
var statearr_32460_32497 = state_32456__$1;
(statearr_32460_32497[(2)] = null);

(statearr_32460_32497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (1))){
var state_32456__$1 = state_32456;
var statearr_32461_32498 = state_32456__$1;
(statearr_32461_32498[(2)] = null);

(statearr_32461_32498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (4))){
var inst_32397 = (state_32456[(13)]);
var inst_32397__$1 = (state_32456[(2)]);
var inst_32398 = (inst_32397__$1 == null);
var state_32456__$1 = (function (){var statearr_32462 = state_32456;
(statearr_32462[(13)] = inst_32397__$1);

return statearr_32462;
})();
if(cljs.core.truth_(inst_32398)){
var statearr_32463_32499 = state_32456__$1;
(statearr_32463_32499[(1)] = (5));

} else {
var statearr_32464_32500 = state_32456__$1;
(statearr_32464_32500[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (15))){
var state_32456__$1 = state_32456;
var statearr_32468_32501 = state_32456__$1;
(statearr_32468_32501[(2)] = null);

(statearr_32468_32501[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (21))){
var state_32456__$1 = state_32456;
var statearr_32469_32502 = state_32456__$1;
(statearr_32469_32502[(2)] = null);

(statearr_32469_32502[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (13))){
var inst_32411 = (state_32456[(8)]);
var inst_32410 = (state_32456[(10)]);
var inst_32409 = (state_32456[(11)]);
var inst_32408 = (state_32456[(12)]);
var inst_32418 = (state_32456[(2)]);
var inst_32419 = (inst_32411 + (1));
var tmp32465 = inst_32410;
var tmp32466 = inst_32409;
var tmp32467 = inst_32408;
var inst_32408__$1 = tmp32467;
var inst_32409__$1 = tmp32466;
var inst_32410__$1 = tmp32465;
var inst_32411__$1 = inst_32419;
var state_32456__$1 = (function (){var statearr_32470 = state_32456;
(statearr_32470[(8)] = inst_32411__$1);

(statearr_32470[(14)] = inst_32418);

(statearr_32470[(10)] = inst_32410__$1);

(statearr_32470[(11)] = inst_32409__$1);

(statearr_32470[(12)] = inst_32408__$1);

return statearr_32470;
})();
var statearr_32471_32503 = state_32456__$1;
(statearr_32471_32503[(2)] = null);

(statearr_32471_32503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (22))){
var state_32456__$1 = state_32456;
var statearr_32472_32504 = state_32456__$1;
(statearr_32472_32504[(2)] = null);

(statearr_32472_32504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (6))){
var inst_32397 = (state_32456[(13)]);
var inst_32406 = f.call(null,inst_32397);
var inst_32407 = cljs.core.seq.call(null,inst_32406);
var inst_32408 = inst_32407;
var inst_32409 = null;
var inst_32410 = (0);
var inst_32411 = (0);
var state_32456__$1 = (function (){var statearr_32473 = state_32456;
(statearr_32473[(8)] = inst_32411);

(statearr_32473[(10)] = inst_32410);

(statearr_32473[(11)] = inst_32409);

(statearr_32473[(12)] = inst_32408);

return statearr_32473;
})();
var statearr_32474_32505 = state_32456__$1;
(statearr_32474_32505[(2)] = null);

(statearr_32474_32505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (17))){
var inst_32422 = (state_32456[(7)]);
var inst_32426 = cljs.core.chunk_first.call(null,inst_32422);
var inst_32427 = cljs.core.chunk_rest.call(null,inst_32422);
var inst_32428 = cljs.core.count.call(null,inst_32426);
var inst_32408 = inst_32427;
var inst_32409 = inst_32426;
var inst_32410 = inst_32428;
var inst_32411 = (0);
var state_32456__$1 = (function (){var statearr_32475 = state_32456;
(statearr_32475[(8)] = inst_32411);

(statearr_32475[(10)] = inst_32410);

(statearr_32475[(11)] = inst_32409);

(statearr_32475[(12)] = inst_32408);

return statearr_32475;
})();
var statearr_32476_32506 = state_32456__$1;
(statearr_32476_32506[(2)] = null);

(statearr_32476_32506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (3))){
var inst_32454 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32456__$1,inst_32454);
} else {
if((state_val_32457 === (12))){
var inst_32442 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32477_32507 = state_32456__$1;
(statearr_32477_32507[(2)] = inst_32442);

(statearr_32477_32507[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (2))){
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32456__$1,(4),in$);
} else {
if((state_val_32457 === (23))){
var inst_32450 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32478_32508 = state_32456__$1;
(statearr_32478_32508[(2)] = inst_32450);

(statearr_32478_32508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (19))){
var inst_32437 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32479_32509 = state_32456__$1;
(statearr_32479_32509[(2)] = inst_32437);

(statearr_32479_32509[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (11))){
var inst_32422 = (state_32456[(7)]);
var inst_32408 = (state_32456[(12)]);
var inst_32422__$1 = cljs.core.seq.call(null,inst_32408);
var state_32456__$1 = (function (){var statearr_32480 = state_32456;
(statearr_32480[(7)] = inst_32422__$1);

return statearr_32480;
})();
if(inst_32422__$1){
var statearr_32481_32510 = state_32456__$1;
(statearr_32481_32510[(1)] = (14));

} else {
var statearr_32482_32511 = state_32456__$1;
(statearr_32482_32511[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (9))){
var inst_32444 = (state_32456[(2)]);
var inst_32445 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32456__$1 = (function (){var statearr_32483 = state_32456;
(statearr_32483[(15)] = inst_32444);

return statearr_32483;
})();
if(cljs.core.truth_(inst_32445)){
var statearr_32484_32512 = state_32456__$1;
(statearr_32484_32512[(1)] = (21));

} else {
var statearr_32485_32513 = state_32456__$1;
(statearr_32485_32513[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (5))){
var inst_32400 = cljs.core.async.close_BANG_.call(null,out);
var state_32456__$1 = state_32456;
var statearr_32486_32514 = state_32456__$1;
(statearr_32486_32514[(2)] = inst_32400);

(statearr_32486_32514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (14))){
var inst_32422 = (state_32456[(7)]);
var inst_32424 = cljs.core.chunked_seq_QMARK_.call(null,inst_32422);
var state_32456__$1 = state_32456;
if(inst_32424){
var statearr_32487_32515 = state_32456__$1;
(statearr_32487_32515[(1)] = (17));

} else {
var statearr_32488_32516 = state_32456__$1;
(statearr_32488_32516[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (16))){
var inst_32440 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32489_32517 = state_32456__$1;
(statearr_32489_32517[(2)] = inst_32440);

(statearr_32489_32517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (10))){
var inst_32411 = (state_32456[(8)]);
var inst_32409 = (state_32456[(11)]);
var inst_32416 = cljs.core._nth.call(null,inst_32409,inst_32411);
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32456__$1,(13),out,inst_32416);
} else {
if((state_val_32457 === (18))){
var inst_32422 = (state_32456[(7)]);
var inst_32431 = cljs.core.first.call(null,inst_32422);
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32456__$1,(20),out,inst_32431);
} else {
if((state_val_32457 === (8))){
var inst_32411 = (state_32456[(8)]);
var inst_32410 = (state_32456[(10)]);
var inst_32413 = (inst_32411 < inst_32410);
var inst_32414 = inst_32413;
var state_32456__$1 = state_32456;
if(cljs.core.truth_(inst_32414)){
var statearr_32490_32518 = state_32456__$1;
(statearr_32490_32518[(1)] = (10));

} else {
var statearr_32491_32519 = state_32456__$1;
(statearr_32491_32519[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__))
;
return ((function (switch__30766__auto__,c__30854__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30767__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30767__auto____0 = (function (){
var statearr_32492 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32492[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30767__auto__);

(statearr_32492[(1)] = (1));

return statearr_32492;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30767__auto____1 = (function (state_32456){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32493){if((e32493 instanceof Object)){
var ex__30770__auto__ = e32493;
var statearr_32494_32520 = state_32456;
(statearr_32494_32520[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32456);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32493;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32521 = state_32456;
state_32456 = G__32521;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30767__auto__ = function(state_32456){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30767__auto____1.call(this,state_32456);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30767__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30767__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__))
})();
var state__30856__auto__ = (function (){var statearr_32495 = f__30855__auto__.call(null);
(statearr_32495[(6)] = c__30854__auto__);

return statearr_32495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__))
);

return c__30854__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32523 = arguments.length;
switch (G__32523) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32526 = arguments.length;
switch (G__32526) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32529 = arguments.length;
switch (G__32529) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30854__auto___32576 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32576,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32576,out){
return (function (state_32553){
var state_val_32554 = (state_32553[(1)]);
if((state_val_32554 === (7))){
var inst_32548 = (state_32553[(2)]);
var state_32553__$1 = state_32553;
var statearr_32555_32577 = state_32553__$1;
(statearr_32555_32577[(2)] = inst_32548);

(statearr_32555_32577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (1))){
var inst_32530 = null;
var state_32553__$1 = (function (){var statearr_32556 = state_32553;
(statearr_32556[(7)] = inst_32530);

return statearr_32556;
})();
var statearr_32557_32578 = state_32553__$1;
(statearr_32557_32578[(2)] = null);

(statearr_32557_32578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (4))){
var inst_32533 = (state_32553[(8)]);
var inst_32533__$1 = (state_32553[(2)]);
var inst_32534 = (inst_32533__$1 == null);
var inst_32535 = cljs.core.not.call(null,inst_32534);
var state_32553__$1 = (function (){var statearr_32558 = state_32553;
(statearr_32558[(8)] = inst_32533__$1);

return statearr_32558;
})();
if(inst_32535){
var statearr_32559_32579 = state_32553__$1;
(statearr_32559_32579[(1)] = (5));

} else {
var statearr_32560_32580 = state_32553__$1;
(statearr_32560_32580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (6))){
var state_32553__$1 = state_32553;
var statearr_32561_32581 = state_32553__$1;
(statearr_32561_32581[(2)] = null);

(statearr_32561_32581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (3))){
var inst_32550 = (state_32553[(2)]);
var inst_32551 = cljs.core.async.close_BANG_.call(null,out);
var state_32553__$1 = (function (){var statearr_32562 = state_32553;
(statearr_32562[(9)] = inst_32550);

return statearr_32562;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32553__$1,inst_32551);
} else {
if((state_val_32554 === (2))){
var state_32553__$1 = state_32553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32553__$1,(4),ch);
} else {
if((state_val_32554 === (11))){
var inst_32533 = (state_32553[(8)]);
var inst_32542 = (state_32553[(2)]);
var inst_32530 = inst_32533;
var state_32553__$1 = (function (){var statearr_32563 = state_32553;
(statearr_32563[(10)] = inst_32542);

(statearr_32563[(7)] = inst_32530);

return statearr_32563;
})();
var statearr_32564_32582 = state_32553__$1;
(statearr_32564_32582[(2)] = null);

(statearr_32564_32582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (9))){
var inst_32533 = (state_32553[(8)]);
var state_32553__$1 = state_32553;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32553__$1,(11),out,inst_32533);
} else {
if((state_val_32554 === (5))){
var inst_32533 = (state_32553[(8)]);
var inst_32530 = (state_32553[(7)]);
var inst_32537 = cljs.core._EQ_.call(null,inst_32533,inst_32530);
var state_32553__$1 = state_32553;
if(inst_32537){
var statearr_32566_32583 = state_32553__$1;
(statearr_32566_32583[(1)] = (8));

} else {
var statearr_32567_32584 = state_32553__$1;
(statearr_32567_32584[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (10))){
var inst_32545 = (state_32553[(2)]);
var state_32553__$1 = state_32553;
var statearr_32568_32585 = state_32553__$1;
(statearr_32568_32585[(2)] = inst_32545);

(statearr_32568_32585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32554 === (8))){
var inst_32530 = (state_32553[(7)]);
var tmp32565 = inst_32530;
var inst_32530__$1 = tmp32565;
var state_32553__$1 = (function (){var statearr_32569 = state_32553;
(statearr_32569[(7)] = inst_32530__$1);

return statearr_32569;
})();
var statearr_32570_32586 = state_32553__$1;
(statearr_32570_32586[(2)] = null);

(statearr_32570_32586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32576,out))
;
return ((function (switch__30766__auto__,c__30854__auto___32576,out){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32571 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32571[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32571[(1)] = (1));

return statearr_32571;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32553){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32572){if((e32572 instanceof Object)){
var ex__30770__auto__ = e32572;
var statearr_32573_32587 = state_32553;
(statearr_32573_32587[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32553);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32588 = state_32553;
state_32553 = G__32588;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32553){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32553);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32576,out))
})();
var state__30856__auto__ = (function (){var statearr_32574 = f__30855__auto__.call(null);
(statearr_32574[(6)] = c__30854__auto___32576);

return statearr_32574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32576,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32590 = arguments.length;
switch (G__32590) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30854__auto___32656 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32656,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32656,out){
return (function (state_32628){
var state_val_32629 = (state_32628[(1)]);
if((state_val_32629 === (7))){
var inst_32624 = (state_32628[(2)]);
var state_32628__$1 = state_32628;
var statearr_32630_32657 = state_32628__$1;
(statearr_32630_32657[(2)] = inst_32624);

(statearr_32630_32657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (1))){
var inst_32591 = (new Array(n));
var inst_32592 = inst_32591;
var inst_32593 = (0);
var state_32628__$1 = (function (){var statearr_32631 = state_32628;
(statearr_32631[(7)] = inst_32593);

(statearr_32631[(8)] = inst_32592);

return statearr_32631;
})();
var statearr_32632_32658 = state_32628__$1;
(statearr_32632_32658[(2)] = null);

(statearr_32632_32658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (4))){
var inst_32596 = (state_32628[(9)]);
var inst_32596__$1 = (state_32628[(2)]);
var inst_32597 = (inst_32596__$1 == null);
var inst_32598 = cljs.core.not.call(null,inst_32597);
var state_32628__$1 = (function (){var statearr_32633 = state_32628;
(statearr_32633[(9)] = inst_32596__$1);

return statearr_32633;
})();
if(inst_32598){
var statearr_32634_32659 = state_32628__$1;
(statearr_32634_32659[(1)] = (5));

} else {
var statearr_32635_32660 = state_32628__$1;
(statearr_32635_32660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (15))){
var inst_32618 = (state_32628[(2)]);
var state_32628__$1 = state_32628;
var statearr_32636_32661 = state_32628__$1;
(statearr_32636_32661[(2)] = inst_32618);

(statearr_32636_32661[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (13))){
var state_32628__$1 = state_32628;
var statearr_32637_32662 = state_32628__$1;
(statearr_32637_32662[(2)] = null);

(statearr_32637_32662[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (6))){
var inst_32593 = (state_32628[(7)]);
var inst_32614 = (inst_32593 > (0));
var state_32628__$1 = state_32628;
if(cljs.core.truth_(inst_32614)){
var statearr_32638_32663 = state_32628__$1;
(statearr_32638_32663[(1)] = (12));

} else {
var statearr_32639_32664 = state_32628__$1;
(statearr_32639_32664[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (3))){
var inst_32626 = (state_32628[(2)]);
var state_32628__$1 = state_32628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32628__$1,inst_32626);
} else {
if((state_val_32629 === (12))){
var inst_32592 = (state_32628[(8)]);
var inst_32616 = cljs.core.vec.call(null,inst_32592);
var state_32628__$1 = state_32628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32628__$1,(15),out,inst_32616);
} else {
if((state_val_32629 === (2))){
var state_32628__$1 = state_32628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32628__$1,(4),ch);
} else {
if((state_val_32629 === (11))){
var inst_32608 = (state_32628[(2)]);
var inst_32609 = (new Array(n));
var inst_32592 = inst_32609;
var inst_32593 = (0);
var state_32628__$1 = (function (){var statearr_32640 = state_32628;
(statearr_32640[(10)] = inst_32608);

(statearr_32640[(7)] = inst_32593);

(statearr_32640[(8)] = inst_32592);

return statearr_32640;
})();
var statearr_32641_32665 = state_32628__$1;
(statearr_32641_32665[(2)] = null);

(statearr_32641_32665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (9))){
var inst_32592 = (state_32628[(8)]);
var inst_32606 = cljs.core.vec.call(null,inst_32592);
var state_32628__$1 = state_32628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32628__$1,(11),out,inst_32606);
} else {
if((state_val_32629 === (5))){
var inst_32596 = (state_32628[(9)]);
var inst_32593 = (state_32628[(7)]);
var inst_32601 = (state_32628[(11)]);
var inst_32592 = (state_32628[(8)]);
var inst_32600 = (inst_32592[inst_32593] = inst_32596);
var inst_32601__$1 = (inst_32593 + (1));
var inst_32602 = (inst_32601__$1 < n);
var state_32628__$1 = (function (){var statearr_32642 = state_32628;
(statearr_32642[(11)] = inst_32601__$1);

(statearr_32642[(12)] = inst_32600);

return statearr_32642;
})();
if(cljs.core.truth_(inst_32602)){
var statearr_32643_32666 = state_32628__$1;
(statearr_32643_32666[(1)] = (8));

} else {
var statearr_32644_32667 = state_32628__$1;
(statearr_32644_32667[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (14))){
var inst_32621 = (state_32628[(2)]);
var inst_32622 = cljs.core.async.close_BANG_.call(null,out);
var state_32628__$1 = (function (){var statearr_32646 = state_32628;
(statearr_32646[(13)] = inst_32621);

return statearr_32646;
})();
var statearr_32647_32668 = state_32628__$1;
(statearr_32647_32668[(2)] = inst_32622);

(statearr_32647_32668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (10))){
var inst_32612 = (state_32628[(2)]);
var state_32628__$1 = state_32628;
var statearr_32648_32669 = state_32628__$1;
(statearr_32648_32669[(2)] = inst_32612);

(statearr_32648_32669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32629 === (8))){
var inst_32601 = (state_32628[(11)]);
var inst_32592 = (state_32628[(8)]);
var tmp32645 = inst_32592;
var inst_32592__$1 = tmp32645;
var inst_32593 = inst_32601;
var state_32628__$1 = (function (){var statearr_32649 = state_32628;
(statearr_32649[(7)] = inst_32593);

(statearr_32649[(8)] = inst_32592__$1);

return statearr_32649;
})();
var statearr_32650_32670 = state_32628__$1;
(statearr_32650_32670[(2)] = null);

(statearr_32650_32670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32656,out))
;
return ((function (switch__30766__auto__,c__30854__auto___32656,out){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32651[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32651[(1)] = (1));

return statearr_32651;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32628){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32652){if((e32652 instanceof Object)){
var ex__30770__auto__ = e32652;
var statearr_32653_32671 = state_32628;
(statearr_32653_32671[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32652;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32672 = state_32628;
state_32628 = G__32672;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32628){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32628);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32656,out))
})();
var state__30856__auto__ = (function (){var statearr_32654 = f__30855__auto__.call(null);
(statearr_32654[(6)] = c__30854__auto___32656);

return statearr_32654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32656,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32674 = arguments.length;
switch (G__32674) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30854__auto___32744 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___32744,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___32744,out){
return (function (state_32716){
var state_val_32717 = (state_32716[(1)]);
if((state_val_32717 === (7))){
var inst_32712 = (state_32716[(2)]);
var state_32716__$1 = state_32716;
var statearr_32718_32745 = state_32716__$1;
(statearr_32718_32745[(2)] = inst_32712);

(statearr_32718_32745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (1))){
var inst_32675 = [];
var inst_32676 = inst_32675;
var inst_32677 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32716__$1 = (function (){var statearr_32719 = state_32716;
(statearr_32719[(7)] = inst_32676);

(statearr_32719[(8)] = inst_32677);

return statearr_32719;
})();
var statearr_32720_32746 = state_32716__$1;
(statearr_32720_32746[(2)] = null);

(statearr_32720_32746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (4))){
var inst_32680 = (state_32716[(9)]);
var inst_32680__$1 = (state_32716[(2)]);
var inst_32681 = (inst_32680__$1 == null);
var inst_32682 = cljs.core.not.call(null,inst_32681);
var state_32716__$1 = (function (){var statearr_32721 = state_32716;
(statearr_32721[(9)] = inst_32680__$1);

return statearr_32721;
})();
if(inst_32682){
var statearr_32722_32747 = state_32716__$1;
(statearr_32722_32747[(1)] = (5));

} else {
var statearr_32723_32748 = state_32716__$1;
(statearr_32723_32748[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (15))){
var inst_32706 = (state_32716[(2)]);
var state_32716__$1 = state_32716;
var statearr_32724_32749 = state_32716__$1;
(statearr_32724_32749[(2)] = inst_32706);

(statearr_32724_32749[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (13))){
var state_32716__$1 = state_32716;
var statearr_32725_32750 = state_32716__$1;
(statearr_32725_32750[(2)] = null);

(statearr_32725_32750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (6))){
var inst_32676 = (state_32716[(7)]);
var inst_32701 = inst_32676.length;
var inst_32702 = (inst_32701 > (0));
var state_32716__$1 = state_32716;
if(cljs.core.truth_(inst_32702)){
var statearr_32726_32751 = state_32716__$1;
(statearr_32726_32751[(1)] = (12));

} else {
var statearr_32727_32752 = state_32716__$1;
(statearr_32727_32752[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (3))){
var inst_32714 = (state_32716[(2)]);
var state_32716__$1 = state_32716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32716__$1,inst_32714);
} else {
if((state_val_32717 === (12))){
var inst_32676 = (state_32716[(7)]);
var inst_32704 = cljs.core.vec.call(null,inst_32676);
var state_32716__$1 = state_32716;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32716__$1,(15),out,inst_32704);
} else {
if((state_val_32717 === (2))){
var state_32716__$1 = state_32716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32716__$1,(4),ch);
} else {
if((state_val_32717 === (11))){
var inst_32684 = (state_32716[(10)]);
var inst_32680 = (state_32716[(9)]);
var inst_32694 = (state_32716[(2)]);
var inst_32695 = [];
var inst_32696 = inst_32695.push(inst_32680);
var inst_32676 = inst_32695;
var inst_32677 = inst_32684;
var state_32716__$1 = (function (){var statearr_32728 = state_32716;
(statearr_32728[(11)] = inst_32694);

(statearr_32728[(7)] = inst_32676);

(statearr_32728[(12)] = inst_32696);

(statearr_32728[(8)] = inst_32677);

return statearr_32728;
})();
var statearr_32729_32753 = state_32716__$1;
(statearr_32729_32753[(2)] = null);

(statearr_32729_32753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (9))){
var inst_32676 = (state_32716[(7)]);
var inst_32692 = cljs.core.vec.call(null,inst_32676);
var state_32716__$1 = state_32716;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32716__$1,(11),out,inst_32692);
} else {
if((state_val_32717 === (5))){
var inst_32684 = (state_32716[(10)]);
var inst_32680 = (state_32716[(9)]);
var inst_32677 = (state_32716[(8)]);
var inst_32684__$1 = f.call(null,inst_32680);
var inst_32685 = cljs.core._EQ_.call(null,inst_32684__$1,inst_32677);
var inst_32686 = cljs.core.keyword_identical_QMARK_.call(null,inst_32677,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32687 = (inst_32685) || (inst_32686);
var state_32716__$1 = (function (){var statearr_32730 = state_32716;
(statearr_32730[(10)] = inst_32684__$1);

return statearr_32730;
})();
if(cljs.core.truth_(inst_32687)){
var statearr_32731_32754 = state_32716__$1;
(statearr_32731_32754[(1)] = (8));

} else {
var statearr_32732_32755 = state_32716__$1;
(statearr_32732_32755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (14))){
var inst_32709 = (state_32716[(2)]);
var inst_32710 = cljs.core.async.close_BANG_.call(null,out);
var state_32716__$1 = (function (){var statearr_32734 = state_32716;
(statearr_32734[(13)] = inst_32709);

return statearr_32734;
})();
var statearr_32735_32756 = state_32716__$1;
(statearr_32735_32756[(2)] = inst_32710);

(statearr_32735_32756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (10))){
var inst_32699 = (state_32716[(2)]);
var state_32716__$1 = state_32716;
var statearr_32736_32757 = state_32716__$1;
(statearr_32736_32757[(2)] = inst_32699);

(statearr_32736_32757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32717 === (8))){
var inst_32684 = (state_32716[(10)]);
var inst_32680 = (state_32716[(9)]);
var inst_32676 = (state_32716[(7)]);
var inst_32689 = inst_32676.push(inst_32680);
var tmp32733 = inst_32676;
var inst_32676__$1 = tmp32733;
var inst_32677 = inst_32684;
var state_32716__$1 = (function (){var statearr_32737 = state_32716;
(statearr_32737[(7)] = inst_32676__$1);

(statearr_32737[(14)] = inst_32689);

(statearr_32737[(8)] = inst_32677);

return statearr_32737;
})();
var statearr_32738_32758 = state_32716__$1;
(statearr_32738_32758[(2)] = null);

(statearr_32738_32758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___32744,out))
;
return ((function (switch__30766__auto__,c__30854__auto___32744,out){
return (function() {
var cljs$core$async$state_machine__30767__auto__ = null;
var cljs$core$async$state_machine__30767__auto____0 = (function (){
var statearr_32739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32739[(0)] = cljs$core$async$state_machine__30767__auto__);

(statearr_32739[(1)] = (1));

return statearr_32739;
});
var cljs$core$async$state_machine__30767__auto____1 = (function (state_32716){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_32716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e32740){if((e32740 instanceof Object)){
var ex__30770__auto__ = e32740;
var statearr_32741_32759 = state_32716;
(statearr_32741_32759[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32716);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32760 = state_32716;
state_32716 = G__32760;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
cljs$core$async$state_machine__30767__auto__ = function(state_32716){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30767__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30767__auto____1.call(this,state_32716);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30767__auto____0;
cljs$core$async$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30767__auto____1;
return cljs$core$async$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___32744,out))
})();
var state__30856__auto__ = (function (){var statearr_32742 = f__30855__auto__.call(null);
(statearr_32742[(6)] = c__30854__auto___32744);

return statearr_32742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___32744,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1502375613723
