// Compiled by ClojureScript 1.9.854 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27953__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27953__auto__){
return or__27953__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27953__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
var or__27953__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__27953__auto____$1)){
return or__27953__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33071_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33071_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__33072 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__33073 = null;
var count__33074 = (0);
var i__33075 = (0);
while(true){
if((i__33075 < count__33074)){
var n = cljs.core._nth.call(null,chunk__33073,i__33075);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33076 = seq__33072;
var G__33077 = chunk__33073;
var G__33078 = count__33074;
var G__33079 = (i__33075 + (1));
seq__33072 = G__33076;
chunk__33073 = G__33077;
count__33074 = G__33078;
i__33075 = G__33079;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33072);
if(temp__4657__auto__){
var seq__33072__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33072__$1)){
var c__28787__auto__ = cljs.core.chunk_first.call(null,seq__33072__$1);
var G__33080 = cljs.core.chunk_rest.call(null,seq__33072__$1);
var G__33081 = c__28787__auto__;
var G__33082 = cljs.core.count.call(null,c__28787__auto__);
var G__33083 = (0);
seq__33072 = G__33080;
chunk__33073 = G__33081;
count__33074 = G__33082;
i__33075 = G__33083;
continue;
} else {
var n = cljs.core.first.call(null,seq__33072__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33084 = cljs.core.next.call(null,seq__33072__$1);
var G__33085 = null;
var G__33086 = (0);
var G__33087 = (0);
seq__33072 = G__33084;
chunk__33073 = G__33085;
count__33074 = G__33086;
i__33075 = G__33087;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33097_33105 = cljs.core.seq.call(null,deps);
var chunk__33098_33106 = null;
var count__33099_33107 = (0);
var i__33100_33108 = (0);
while(true){
if((i__33100_33108 < count__33099_33107)){
var dep_33109 = cljs.core._nth.call(null,chunk__33098_33106,i__33100_33108);
topo_sort_helper_STAR_.call(null,dep_33109,(depth + (1)),state);

var G__33110 = seq__33097_33105;
var G__33111 = chunk__33098_33106;
var G__33112 = count__33099_33107;
var G__33113 = (i__33100_33108 + (1));
seq__33097_33105 = G__33110;
chunk__33098_33106 = G__33111;
count__33099_33107 = G__33112;
i__33100_33108 = G__33113;
continue;
} else {
var temp__4657__auto___33114 = cljs.core.seq.call(null,seq__33097_33105);
if(temp__4657__auto___33114){
var seq__33097_33115__$1 = temp__4657__auto___33114;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33097_33115__$1)){
var c__28787__auto___33116 = cljs.core.chunk_first.call(null,seq__33097_33115__$1);
var G__33117 = cljs.core.chunk_rest.call(null,seq__33097_33115__$1);
var G__33118 = c__28787__auto___33116;
var G__33119 = cljs.core.count.call(null,c__28787__auto___33116);
var G__33120 = (0);
seq__33097_33105 = G__33117;
chunk__33098_33106 = G__33118;
count__33099_33107 = G__33119;
i__33100_33108 = G__33120;
continue;
} else {
var dep_33121 = cljs.core.first.call(null,seq__33097_33115__$1);
topo_sort_helper_STAR_.call(null,dep_33121,(depth + (1)),state);

var G__33122 = cljs.core.next.call(null,seq__33097_33115__$1);
var G__33123 = null;
var G__33124 = (0);
var G__33125 = (0);
seq__33097_33105 = G__33122;
chunk__33098_33106 = G__33123;
count__33099_33107 = G__33124;
i__33100_33108 = G__33125;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33101){
var vec__33102 = p__33101;
var seq__33103 = cljs.core.seq.call(null,vec__33102);
var first__33104 = cljs.core.first.call(null,seq__33103);
var seq__33103__$1 = cljs.core.next.call(null,seq__33103);
var x = first__33104;
var xs = seq__33103__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__33102,seq__33103,first__33104,seq__33103__$1,x,xs,get_deps__$1){
return (function (p1__33088_SHARP_){
return clojure.set.difference.call(null,p1__33088_SHARP_,x);
});})(vec__33102,seq__33103,first__33104,seq__33103__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__33126 = cljs.core.seq.call(null,provides);
var chunk__33127 = null;
var count__33128 = (0);
var i__33129 = (0);
while(true){
if((i__33129 < count__33128)){
var prov = cljs.core._nth.call(null,chunk__33127,i__33129);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33130_33138 = cljs.core.seq.call(null,requires);
var chunk__33131_33139 = null;
var count__33132_33140 = (0);
var i__33133_33141 = (0);
while(true){
if((i__33133_33141 < count__33132_33140)){
var req_33142 = cljs.core._nth.call(null,chunk__33131_33139,i__33133_33141);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33142,prov);

var G__33143 = seq__33130_33138;
var G__33144 = chunk__33131_33139;
var G__33145 = count__33132_33140;
var G__33146 = (i__33133_33141 + (1));
seq__33130_33138 = G__33143;
chunk__33131_33139 = G__33144;
count__33132_33140 = G__33145;
i__33133_33141 = G__33146;
continue;
} else {
var temp__4657__auto___33147 = cljs.core.seq.call(null,seq__33130_33138);
if(temp__4657__auto___33147){
var seq__33130_33148__$1 = temp__4657__auto___33147;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33130_33148__$1)){
var c__28787__auto___33149 = cljs.core.chunk_first.call(null,seq__33130_33148__$1);
var G__33150 = cljs.core.chunk_rest.call(null,seq__33130_33148__$1);
var G__33151 = c__28787__auto___33149;
var G__33152 = cljs.core.count.call(null,c__28787__auto___33149);
var G__33153 = (0);
seq__33130_33138 = G__33150;
chunk__33131_33139 = G__33151;
count__33132_33140 = G__33152;
i__33133_33141 = G__33153;
continue;
} else {
var req_33154 = cljs.core.first.call(null,seq__33130_33148__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33154,prov);

var G__33155 = cljs.core.next.call(null,seq__33130_33148__$1);
var G__33156 = null;
var G__33157 = (0);
var G__33158 = (0);
seq__33130_33138 = G__33155;
chunk__33131_33139 = G__33156;
count__33132_33140 = G__33157;
i__33133_33141 = G__33158;
continue;
}
} else {
}
}
break;
}

var G__33159 = seq__33126;
var G__33160 = chunk__33127;
var G__33161 = count__33128;
var G__33162 = (i__33129 + (1));
seq__33126 = G__33159;
chunk__33127 = G__33160;
count__33128 = G__33161;
i__33129 = G__33162;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33126);
if(temp__4657__auto__){
var seq__33126__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33126__$1)){
var c__28787__auto__ = cljs.core.chunk_first.call(null,seq__33126__$1);
var G__33163 = cljs.core.chunk_rest.call(null,seq__33126__$1);
var G__33164 = c__28787__auto__;
var G__33165 = cljs.core.count.call(null,c__28787__auto__);
var G__33166 = (0);
seq__33126 = G__33163;
chunk__33127 = G__33164;
count__33128 = G__33165;
i__33129 = G__33166;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33126__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33134_33167 = cljs.core.seq.call(null,requires);
var chunk__33135_33168 = null;
var count__33136_33169 = (0);
var i__33137_33170 = (0);
while(true){
if((i__33137_33170 < count__33136_33169)){
var req_33171 = cljs.core._nth.call(null,chunk__33135_33168,i__33137_33170);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33171,prov);

var G__33172 = seq__33134_33167;
var G__33173 = chunk__33135_33168;
var G__33174 = count__33136_33169;
var G__33175 = (i__33137_33170 + (1));
seq__33134_33167 = G__33172;
chunk__33135_33168 = G__33173;
count__33136_33169 = G__33174;
i__33137_33170 = G__33175;
continue;
} else {
var temp__4657__auto___33176__$1 = cljs.core.seq.call(null,seq__33134_33167);
if(temp__4657__auto___33176__$1){
var seq__33134_33177__$1 = temp__4657__auto___33176__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33134_33177__$1)){
var c__28787__auto___33178 = cljs.core.chunk_first.call(null,seq__33134_33177__$1);
var G__33179 = cljs.core.chunk_rest.call(null,seq__33134_33177__$1);
var G__33180 = c__28787__auto___33178;
var G__33181 = cljs.core.count.call(null,c__28787__auto___33178);
var G__33182 = (0);
seq__33134_33167 = G__33179;
chunk__33135_33168 = G__33180;
count__33136_33169 = G__33181;
i__33137_33170 = G__33182;
continue;
} else {
var req_33183 = cljs.core.first.call(null,seq__33134_33177__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33183,prov);

var G__33184 = cljs.core.next.call(null,seq__33134_33177__$1);
var G__33185 = null;
var G__33186 = (0);
var G__33187 = (0);
seq__33134_33167 = G__33184;
chunk__33135_33168 = G__33185;
count__33136_33169 = G__33186;
i__33137_33170 = G__33187;
continue;
}
} else {
}
}
break;
}

var G__33188 = cljs.core.next.call(null,seq__33126__$1);
var G__33189 = null;
var G__33190 = (0);
var G__33191 = (0);
seq__33126 = G__33188;
chunk__33127 = G__33189;
count__33128 = G__33190;
i__33129 = G__33191;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__33192_33196 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__33193_33197 = null;
var count__33194_33198 = (0);
var i__33195_33199 = (0);
while(true){
if((i__33195_33199 < count__33194_33198)){
var ns_33200 = cljs.core._nth.call(null,chunk__33193_33197,i__33195_33199);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33200);

var G__33201 = seq__33192_33196;
var G__33202 = chunk__33193_33197;
var G__33203 = count__33194_33198;
var G__33204 = (i__33195_33199 + (1));
seq__33192_33196 = G__33201;
chunk__33193_33197 = G__33202;
count__33194_33198 = G__33203;
i__33195_33199 = G__33204;
continue;
} else {
var temp__4657__auto___33205 = cljs.core.seq.call(null,seq__33192_33196);
if(temp__4657__auto___33205){
var seq__33192_33206__$1 = temp__4657__auto___33205;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33192_33206__$1)){
var c__28787__auto___33207 = cljs.core.chunk_first.call(null,seq__33192_33206__$1);
var G__33208 = cljs.core.chunk_rest.call(null,seq__33192_33206__$1);
var G__33209 = c__28787__auto___33207;
var G__33210 = cljs.core.count.call(null,c__28787__auto___33207);
var G__33211 = (0);
seq__33192_33196 = G__33208;
chunk__33193_33197 = G__33209;
count__33194_33198 = G__33210;
i__33195_33199 = G__33211;
continue;
} else {
var ns_33212 = cljs.core.first.call(null,seq__33192_33206__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33212);

var G__33213 = cljs.core.next.call(null,seq__33192_33206__$1);
var G__33214 = null;
var G__33215 = (0);
var G__33216 = (0);
seq__33192_33196 = G__33213;
chunk__33193_33197 = G__33214;
count__33194_33198 = G__33215;
i__33195_33199 = G__33216;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27953__auto__ = goog.require__;
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__33217__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__33217 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33218__i = 0, G__33218__a = new Array(arguments.length -  0);
while (G__33218__i < G__33218__a.length) {G__33218__a[G__33218__i] = arguments[G__33218__i + 0]; ++G__33218__i;}
  args = new cljs.core.IndexedSeq(G__33218__a,0,null);
} 
return G__33217__delegate.call(this,args);};
G__33217.cljs$lang$maxFixedArity = 0;
G__33217.cljs$lang$applyTo = (function (arglist__33219){
var args = cljs.core.seq(arglist__33219);
return G__33217__delegate(args);
});
G__33217.cljs$core$IFn$_invoke$arity$variadic = G__33217__delegate;
return G__33217;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__33220 = cljs.core._EQ_;
var expr__33221 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__33221))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__33220,expr__33221){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__33220,expr__33221))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__33220,expr__33221){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e33223){if((e33223 instanceof Error)){
var e = e33223;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33223;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__33220,expr__33221))
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__33221))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__33221))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__33221))){
return ((function (pred__33220,expr__33221){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e33224){if((e33224 instanceof Error)){
var e = e33224;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33224;

}
}})());
});
;})(pred__33220,expr__33221))
} else {
return ((function (pred__33220,expr__33221){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__33220,expr__33221))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__33225,callback){
var map__33226 = p__33225;
var map__33226__$1 = ((((!((map__33226 == null)))?((((map__33226.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33226.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33226):map__33226);
var file_msg = map__33226__$1;
var request_url = cljs.core.get.call(null,map__33226__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__33226,map__33226__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__33226,map__33226__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__){
return (function (state_33250){
var state_val_33251 = (state_33250[(1)]);
if((state_val_33251 === (7))){
var inst_33246 = (state_33250[(2)]);
var state_33250__$1 = state_33250;
var statearr_33252_33269 = state_33250__$1;
(statearr_33252_33269[(2)] = inst_33246);

(statearr_33252_33269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (1))){
var state_33250__$1 = state_33250;
var statearr_33253_33270 = state_33250__$1;
(statearr_33253_33270[(2)] = null);

(statearr_33253_33270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (4))){
var inst_33230 = (state_33250[(7)]);
var inst_33230__$1 = (state_33250[(2)]);
var state_33250__$1 = (function (){var statearr_33254 = state_33250;
(statearr_33254[(7)] = inst_33230__$1);

return statearr_33254;
})();
if(cljs.core.truth_(inst_33230__$1)){
var statearr_33255_33271 = state_33250__$1;
(statearr_33255_33271[(1)] = (5));

} else {
var statearr_33256_33272 = state_33250__$1;
(statearr_33256_33272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (6))){
var state_33250__$1 = state_33250;
var statearr_33257_33273 = state_33250__$1;
(statearr_33257_33273[(2)] = null);

(statearr_33257_33273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (3))){
var inst_33248 = (state_33250[(2)]);
var state_33250__$1 = state_33250;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33250__$1,inst_33248);
} else {
if((state_val_33251 === (2))){
var state_33250__$1 = state_33250;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33250__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_33251 === (11))){
var inst_33242 = (state_33250[(2)]);
var state_33250__$1 = (function (){var statearr_33258 = state_33250;
(statearr_33258[(8)] = inst_33242);

return statearr_33258;
})();
var statearr_33259_33274 = state_33250__$1;
(statearr_33259_33274[(2)] = null);

(statearr_33259_33274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (9))){
var inst_33236 = (state_33250[(9)]);
var inst_33234 = (state_33250[(10)]);
var inst_33238 = inst_33236.call(null,inst_33234);
var state_33250__$1 = state_33250;
var statearr_33260_33275 = state_33250__$1;
(statearr_33260_33275[(2)] = inst_33238);

(statearr_33260_33275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (5))){
var inst_33230 = (state_33250[(7)]);
var inst_33232 = figwheel.client.file_reloading.blocking_load.call(null,inst_33230);
var state_33250__$1 = state_33250;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33250__$1,(8),inst_33232);
} else {
if((state_val_33251 === (10))){
var inst_33234 = (state_33250[(10)]);
var inst_33240 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_33234);
var state_33250__$1 = state_33250;
var statearr_33261_33276 = state_33250__$1;
(statearr_33261_33276[(2)] = inst_33240);

(statearr_33261_33276[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33251 === (8))){
var inst_33236 = (state_33250[(9)]);
var inst_33230 = (state_33250[(7)]);
var inst_33234 = (state_33250[(2)]);
var inst_33235 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_33236__$1 = cljs.core.get.call(null,inst_33235,inst_33230);
var state_33250__$1 = (function (){var statearr_33262 = state_33250;
(statearr_33262[(9)] = inst_33236__$1);

(statearr_33262[(10)] = inst_33234);

return statearr_33262;
})();
if(cljs.core.truth_(inst_33236__$1)){
var statearr_33263_33277 = state_33250__$1;
(statearr_33263_33277[(1)] = (9));

} else {
var statearr_33264_33278 = state_33250__$1;
(statearr_33264_33278[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__))
;
return ((function (switch__30766__auto__,c__30854__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30767__auto__ = null;
var figwheel$client$file_reloading$state_machine__30767__auto____0 = (function (){
var statearr_33265 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33265[(0)] = figwheel$client$file_reloading$state_machine__30767__auto__);

(statearr_33265[(1)] = (1));

return statearr_33265;
});
var figwheel$client$file_reloading$state_machine__30767__auto____1 = (function (state_33250){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_33250);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e33266){if((e33266 instanceof Object)){
var ex__30770__auto__ = e33266;
var statearr_33267_33279 = state_33250;
(statearr_33267_33279[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33250);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33280 = state_33250;
state_33250 = G__33280;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30767__auto__ = function(state_33250){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30767__auto____1.call(this,state_33250);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30767__auto____0;
figwheel$client$file_reloading$state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30767__auto____1;
return figwheel$client$file_reloading$state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__))
})();
var state__30856__auto__ = (function (){var statearr_33268 = f__30855__auto__.call(null);
(statearr_33268[(6)] = c__30854__auto__);

return statearr_33268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__))
);

return c__30854__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__33281,callback){
var map__33282 = p__33281;
var map__33282__$1 = ((((!((map__33282 == null)))?((((map__33282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33282.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33282):map__33282);
var file_msg = map__33282__$1;
var namespace = cljs.core.get.call(null,map__33282__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__33282,map__33282__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__33282,map__33282__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__33284){
var map__33285 = p__33284;
var map__33285__$1 = ((((!((map__33285 == null)))?((((map__33285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33285.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33285):map__33285);
var file_msg = map__33285__$1;
var namespace = cljs.core.get.call(null,map__33285__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__33287){
var map__33288 = p__33287;
var map__33288__$1 = ((((!((map__33288 == null)))?((((map__33288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33288.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33288):map__33288);
var file_msg = map__33288__$1;
var namespace = cljs.core.get.call(null,map__33288__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27941__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__27941__auto__){
var or__27953__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
var or__27953__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27953__auto____$1)){
return or__27953__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27941__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__33290,callback){
var map__33291 = p__33290;
var map__33291__$1 = ((((!((map__33291 == null)))?((((map__33291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33291.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33291):map__33291);
var file_msg = map__33291__$1;
var request_url = cljs.core.get.call(null,map__33291__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__33291__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30854__auto___33341 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___33341,out){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___33341,out){
return (function (state_33326){
var state_val_33327 = (state_33326[(1)]);
if((state_val_33327 === (1))){
var inst_33300 = cljs.core.seq.call(null,files);
var inst_33301 = cljs.core.first.call(null,inst_33300);
var inst_33302 = cljs.core.next.call(null,inst_33300);
var inst_33303 = files;
var state_33326__$1 = (function (){var statearr_33328 = state_33326;
(statearr_33328[(7)] = inst_33302);

(statearr_33328[(8)] = inst_33303);

(statearr_33328[(9)] = inst_33301);

return statearr_33328;
})();
var statearr_33329_33342 = state_33326__$1;
(statearr_33329_33342[(2)] = null);

(statearr_33329_33342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33327 === (2))){
var inst_33309 = (state_33326[(10)]);
var inst_33303 = (state_33326[(8)]);
var inst_33308 = cljs.core.seq.call(null,inst_33303);
var inst_33309__$1 = cljs.core.first.call(null,inst_33308);
var inst_33310 = cljs.core.next.call(null,inst_33308);
var inst_33311 = (inst_33309__$1 == null);
var inst_33312 = cljs.core.not.call(null,inst_33311);
var state_33326__$1 = (function (){var statearr_33330 = state_33326;
(statearr_33330[(10)] = inst_33309__$1);

(statearr_33330[(11)] = inst_33310);

return statearr_33330;
})();
if(inst_33312){
var statearr_33331_33343 = state_33326__$1;
(statearr_33331_33343[(1)] = (4));

} else {
var statearr_33332_33344 = state_33326__$1;
(statearr_33332_33344[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33327 === (3))){
var inst_33324 = (state_33326[(2)]);
var state_33326__$1 = state_33326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33326__$1,inst_33324);
} else {
if((state_val_33327 === (4))){
var inst_33309 = (state_33326[(10)]);
var inst_33314 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33309);
var state_33326__$1 = state_33326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33326__$1,(7),inst_33314);
} else {
if((state_val_33327 === (5))){
var inst_33320 = cljs.core.async.close_BANG_.call(null,out);
var state_33326__$1 = state_33326;
var statearr_33333_33345 = state_33326__$1;
(statearr_33333_33345[(2)] = inst_33320);

(statearr_33333_33345[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33327 === (6))){
var inst_33322 = (state_33326[(2)]);
var state_33326__$1 = state_33326;
var statearr_33334_33346 = state_33326__$1;
(statearr_33334_33346[(2)] = inst_33322);

(statearr_33334_33346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33327 === (7))){
var inst_33310 = (state_33326[(11)]);
var inst_33316 = (state_33326[(2)]);
var inst_33317 = cljs.core.async.put_BANG_.call(null,out,inst_33316);
var inst_33303 = inst_33310;
var state_33326__$1 = (function (){var statearr_33335 = state_33326;
(statearr_33335[(12)] = inst_33317);

(statearr_33335[(8)] = inst_33303);

return statearr_33335;
})();
var statearr_33336_33347 = state_33326__$1;
(statearr_33336_33347[(2)] = null);

(statearr_33336_33347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30854__auto___33341,out))
;
return ((function (switch__30766__auto__,c__30854__auto___33341,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto____0 = (function (){
var statearr_33337 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33337[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto__);

(statearr_33337[(1)] = (1));

return statearr_33337;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto____1 = (function (state_33326){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_33326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e33338){if((e33338 instanceof Object)){
var ex__30770__auto__ = e33338;
var statearr_33339_33348 = state_33326;
(statearr_33339_33348[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33326);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33338;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33349 = state_33326;
state_33326 = G__33349;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto__ = function(state_33326){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto____1.call(this,state_33326);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___33341,out))
})();
var state__30856__auto__ = (function (){var statearr_33340 = f__30855__auto__.call(null);
(statearr_33340[(6)] = c__30854__auto___33341);

return statearr_33340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___33341,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__33350,opts){
var map__33351 = p__33350;
var map__33351__$1 = ((((!((map__33351 == null)))?((((map__33351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33351.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33351):map__33351);
var eval_body = cljs.core.get.call(null,map__33351__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__33351__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27941__auto__ = eval_body;
if(cljs.core.truth_(and__27941__auto__)){
return typeof eval_body === 'string';
} else {
return and__27941__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e33353){var e = e33353;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__33354_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33354_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__33355){
var vec__33356 = p__33355;
var k = cljs.core.nth.call(null,vec__33356,(0),null);
var v = cljs.core.nth.call(null,vec__33356,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__33359){
var vec__33360 = p__33359;
var k = cljs.core.nth.call(null,vec__33360,(0),null);
var v = cljs.core.nth.call(null,vec__33360,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__33366,p__33367){
var map__33368 = p__33366;
var map__33368__$1 = ((((!((map__33368 == null)))?((((map__33368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33368.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33368):map__33368);
var opts = map__33368__$1;
var before_jsload = cljs.core.get.call(null,map__33368__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__33368__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__33368__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__33369 = p__33367;
var map__33369__$1 = ((((!((map__33369 == null)))?((((map__33369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33369.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33369):map__33369);
var msg = map__33369__$1;
var files = cljs.core.get.call(null,map__33369__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__33369__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__33369__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_33523){
var state_val_33524 = (state_33523[(1)]);
if((state_val_33524 === (7))){
var inst_33386 = (state_33523[(7)]);
var inst_33383 = (state_33523[(8)]);
var inst_33384 = (state_33523[(9)]);
var inst_33385 = (state_33523[(10)]);
var inst_33391 = cljs.core._nth.call(null,inst_33384,inst_33386);
var inst_33392 = figwheel.client.file_reloading.eval_body.call(null,inst_33391,opts);
var inst_33393 = (inst_33386 + (1));
var tmp33525 = inst_33383;
var tmp33526 = inst_33384;
var tmp33527 = inst_33385;
var inst_33383__$1 = tmp33525;
var inst_33384__$1 = tmp33526;
var inst_33385__$1 = tmp33527;
var inst_33386__$1 = inst_33393;
var state_33523__$1 = (function (){var statearr_33528 = state_33523;
(statearr_33528[(7)] = inst_33386__$1);

(statearr_33528[(11)] = inst_33392);

(statearr_33528[(8)] = inst_33383__$1);

(statearr_33528[(9)] = inst_33384__$1);

(statearr_33528[(10)] = inst_33385__$1);

return statearr_33528;
})();
var statearr_33529_33612 = state_33523__$1;
(statearr_33529_33612[(2)] = null);

(statearr_33529_33612[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (20))){
var inst_33426 = (state_33523[(12)]);
var inst_33434 = figwheel.client.file_reloading.sort_files.call(null,inst_33426);
var state_33523__$1 = state_33523;
var statearr_33530_33613 = state_33523__$1;
(statearr_33530_33613[(2)] = inst_33434);

(statearr_33530_33613[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (27))){
var state_33523__$1 = state_33523;
var statearr_33531_33614 = state_33523__$1;
(statearr_33531_33614[(2)] = null);

(statearr_33531_33614[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (1))){
var inst_33375 = (state_33523[(13)]);
var inst_33372 = before_jsload.call(null,files);
var inst_33373 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_33374 = (function (){return ((function (inst_33375,inst_33372,inst_33373,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33363_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33363_SHARP_);
});
;})(inst_33375,inst_33372,inst_33373,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33375__$1 = cljs.core.filter.call(null,inst_33374,files);
var inst_33376 = cljs.core.not_empty.call(null,inst_33375__$1);
var state_33523__$1 = (function (){var statearr_33532 = state_33523;
(statearr_33532[(13)] = inst_33375__$1);

(statearr_33532[(14)] = inst_33372);

(statearr_33532[(15)] = inst_33373);

return statearr_33532;
})();
if(cljs.core.truth_(inst_33376)){
var statearr_33533_33615 = state_33523__$1;
(statearr_33533_33615[(1)] = (2));

} else {
var statearr_33534_33616 = state_33523__$1;
(statearr_33534_33616[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (24))){
var state_33523__$1 = state_33523;
var statearr_33535_33617 = state_33523__$1;
(statearr_33535_33617[(2)] = null);

(statearr_33535_33617[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (39))){
var inst_33476 = (state_33523[(16)]);
var state_33523__$1 = state_33523;
var statearr_33536_33618 = state_33523__$1;
(statearr_33536_33618[(2)] = inst_33476);

(statearr_33536_33618[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (46))){
var inst_33518 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33537_33619 = state_33523__$1;
(statearr_33537_33619[(2)] = inst_33518);

(statearr_33537_33619[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (4))){
var inst_33420 = (state_33523[(2)]);
var inst_33421 = cljs.core.List.EMPTY;
var inst_33422 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_33421);
var inst_33423 = (function (){return ((function (inst_33420,inst_33421,inst_33422,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33364_SHARP_){
var and__27941__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33364_SHARP_);
if(cljs.core.truth_(and__27941__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33364_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__33364_SHARP_)));
} else {
return and__27941__auto__;
}
});
;})(inst_33420,inst_33421,inst_33422,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33424 = cljs.core.filter.call(null,inst_33423,files);
var inst_33425 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_33426 = cljs.core.concat.call(null,inst_33424,inst_33425);
var state_33523__$1 = (function (){var statearr_33538 = state_33523;
(statearr_33538[(12)] = inst_33426);

(statearr_33538[(17)] = inst_33420);

(statearr_33538[(18)] = inst_33422);

return statearr_33538;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_33539_33620 = state_33523__$1;
(statearr_33539_33620[(1)] = (16));

} else {
var statearr_33540_33621 = state_33523__$1;
(statearr_33540_33621[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (15))){
var inst_33410 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33541_33622 = state_33523__$1;
(statearr_33541_33622[(2)] = inst_33410);

(statearr_33541_33622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (21))){
var inst_33436 = (state_33523[(19)]);
var inst_33436__$1 = (state_33523[(2)]);
var inst_33437 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_33436__$1);
var state_33523__$1 = (function (){var statearr_33542 = state_33523;
(statearr_33542[(19)] = inst_33436__$1);

return statearr_33542;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33523__$1,(22),inst_33437);
} else {
if((state_val_33524 === (31))){
var inst_33521 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33523__$1,inst_33521);
} else {
if((state_val_33524 === (32))){
var inst_33476 = (state_33523[(16)]);
var inst_33481 = inst_33476.cljs$lang$protocol_mask$partition0$;
var inst_33482 = (inst_33481 & (64));
var inst_33483 = inst_33476.cljs$core$ISeq$;
var inst_33484 = (cljs.core.PROTOCOL_SENTINEL === inst_33483);
var inst_33485 = (inst_33482) || (inst_33484);
var state_33523__$1 = state_33523;
if(cljs.core.truth_(inst_33485)){
var statearr_33543_33623 = state_33523__$1;
(statearr_33543_33623[(1)] = (35));

} else {
var statearr_33544_33624 = state_33523__$1;
(statearr_33544_33624[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (40))){
var inst_33498 = (state_33523[(20)]);
var inst_33497 = (state_33523[(2)]);
var inst_33498__$1 = cljs.core.get.call(null,inst_33497,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_33499 = cljs.core.get.call(null,inst_33497,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_33500 = cljs.core.not_empty.call(null,inst_33498__$1);
var state_33523__$1 = (function (){var statearr_33545 = state_33523;
(statearr_33545[(21)] = inst_33499);

(statearr_33545[(20)] = inst_33498__$1);

return statearr_33545;
})();
if(cljs.core.truth_(inst_33500)){
var statearr_33546_33625 = state_33523__$1;
(statearr_33546_33625[(1)] = (41));

} else {
var statearr_33547_33626 = state_33523__$1;
(statearr_33547_33626[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (33))){
var state_33523__$1 = state_33523;
var statearr_33548_33627 = state_33523__$1;
(statearr_33548_33627[(2)] = false);

(statearr_33548_33627[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (13))){
var inst_33396 = (state_33523[(22)]);
var inst_33400 = cljs.core.chunk_first.call(null,inst_33396);
var inst_33401 = cljs.core.chunk_rest.call(null,inst_33396);
var inst_33402 = cljs.core.count.call(null,inst_33400);
var inst_33383 = inst_33401;
var inst_33384 = inst_33400;
var inst_33385 = inst_33402;
var inst_33386 = (0);
var state_33523__$1 = (function (){var statearr_33549 = state_33523;
(statearr_33549[(7)] = inst_33386);

(statearr_33549[(8)] = inst_33383);

(statearr_33549[(9)] = inst_33384);

(statearr_33549[(10)] = inst_33385);

return statearr_33549;
})();
var statearr_33550_33628 = state_33523__$1;
(statearr_33550_33628[(2)] = null);

(statearr_33550_33628[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (22))){
var inst_33436 = (state_33523[(19)]);
var inst_33444 = (state_33523[(23)]);
var inst_33439 = (state_33523[(24)]);
var inst_33440 = (state_33523[(25)]);
var inst_33439__$1 = (state_33523[(2)]);
var inst_33440__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_33439__$1);
var inst_33441 = (function (){var all_files = inst_33436;
var res_SINGLEQUOTE_ = inst_33439__$1;
var res = inst_33440__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_33436,inst_33444,inst_33439,inst_33440,inst_33439__$1,inst_33440__$1,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33365_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__33365_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_33436,inst_33444,inst_33439,inst_33440,inst_33439__$1,inst_33440__$1,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33442 = cljs.core.filter.call(null,inst_33441,inst_33439__$1);
var inst_33443 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_33444__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_33443);
var inst_33445 = cljs.core.not_empty.call(null,inst_33444__$1);
var state_33523__$1 = (function (){var statearr_33551 = state_33523;
(statearr_33551[(26)] = inst_33442);

(statearr_33551[(23)] = inst_33444__$1);

(statearr_33551[(24)] = inst_33439__$1);

(statearr_33551[(25)] = inst_33440__$1);

return statearr_33551;
})();
if(cljs.core.truth_(inst_33445)){
var statearr_33552_33629 = state_33523__$1;
(statearr_33552_33629[(1)] = (23));

} else {
var statearr_33553_33630 = state_33523__$1;
(statearr_33553_33630[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (36))){
var state_33523__$1 = state_33523;
var statearr_33554_33631 = state_33523__$1;
(statearr_33554_33631[(2)] = false);

(statearr_33554_33631[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (41))){
var inst_33498 = (state_33523[(20)]);
var inst_33502 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_33503 = cljs.core.map.call(null,inst_33502,inst_33498);
var inst_33504 = cljs.core.pr_str.call(null,inst_33503);
var inst_33505 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33504)].join('');
var inst_33506 = figwheel.client.utils.log.call(null,inst_33505);
var state_33523__$1 = state_33523;
var statearr_33555_33632 = state_33523__$1;
(statearr_33555_33632[(2)] = inst_33506);

(statearr_33555_33632[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (43))){
var inst_33499 = (state_33523[(21)]);
var inst_33509 = (state_33523[(2)]);
var inst_33510 = cljs.core.not_empty.call(null,inst_33499);
var state_33523__$1 = (function (){var statearr_33556 = state_33523;
(statearr_33556[(27)] = inst_33509);

return statearr_33556;
})();
if(cljs.core.truth_(inst_33510)){
var statearr_33557_33633 = state_33523__$1;
(statearr_33557_33633[(1)] = (44));

} else {
var statearr_33558_33634 = state_33523__$1;
(statearr_33558_33634[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (29))){
var inst_33436 = (state_33523[(19)]);
var inst_33442 = (state_33523[(26)]);
var inst_33444 = (state_33523[(23)]);
var inst_33439 = (state_33523[(24)]);
var inst_33476 = (state_33523[(16)]);
var inst_33440 = (state_33523[(25)]);
var inst_33472 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_33475 = (function (){var all_files = inst_33436;
var res_SINGLEQUOTE_ = inst_33439;
var res = inst_33440;
var files_not_loaded = inst_33442;
var dependencies_that_loaded = inst_33444;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33476,inst_33440,inst_33472,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33474){
var map__33559 = p__33474;
var map__33559__$1 = ((((!((map__33559 == null)))?((((map__33559.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33559.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33559):map__33559);
var namespace = cljs.core.get.call(null,map__33559__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33476,inst_33440,inst_33472,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33476__$1 = cljs.core.group_by.call(null,inst_33475,inst_33442);
var inst_33478 = (inst_33476__$1 == null);
var inst_33479 = cljs.core.not.call(null,inst_33478);
var state_33523__$1 = (function (){var statearr_33561 = state_33523;
(statearr_33561[(28)] = inst_33472);

(statearr_33561[(16)] = inst_33476__$1);

return statearr_33561;
})();
if(inst_33479){
var statearr_33562_33635 = state_33523__$1;
(statearr_33562_33635[(1)] = (32));

} else {
var statearr_33563_33636 = state_33523__$1;
(statearr_33563_33636[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (44))){
var inst_33499 = (state_33523[(21)]);
var inst_33512 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_33499);
var inst_33513 = cljs.core.pr_str.call(null,inst_33512);
var inst_33514 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33513)].join('');
var inst_33515 = figwheel.client.utils.log.call(null,inst_33514);
var state_33523__$1 = state_33523;
var statearr_33564_33637 = state_33523__$1;
(statearr_33564_33637[(2)] = inst_33515);

(statearr_33564_33637[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (6))){
var inst_33417 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33565_33638 = state_33523__$1;
(statearr_33565_33638[(2)] = inst_33417);

(statearr_33565_33638[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (28))){
var inst_33442 = (state_33523[(26)]);
var inst_33469 = (state_33523[(2)]);
var inst_33470 = cljs.core.not_empty.call(null,inst_33442);
var state_33523__$1 = (function (){var statearr_33566 = state_33523;
(statearr_33566[(29)] = inst_33469);

return statearr_33566;
})();
if(cljs.core.truth_(inst_33470)){
var statearr_33567_33639 = state_33523__$1;
(statearr_33567_33639[(1)] = (29));

} else {
var statearr_33568_33640 = state_33523__$1;
(statearr_33568_33640[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (25))){
var inst_33440 = (state_33523[(25)]);
var inst_33456 = (state_33523[(2)]);
var inst_33457 = cljs.core.not_empty.call(null,inst_33440);
var state_33523__$1 = (function (){var statearr_33569 = state_33523;
(statearr_33569[(30)] = inst_33456);

return statearr_33569;
})();
if(cljs.core.truth_(inst_33457)){
var statearr_33570_33641 = state_33523__$1;
(statearr_33570_33641[(1)] = (26));

} else {
var statearr_33571_33642 = state_33523__$1;
(statearr_33571_33642[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (34))){
var inst_33492 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
if(cljs.core.truth_(inst_33492)){
var statearr_33572_33643 = state_33523__$1;
(statearr_33572_33643[(1)] = (38));

} else {
var statearr_33573_33644 = state_33523__$1;
(statearr_33573_33644[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (17))){
var state_33523__$1 = state_33523;
var statearr_33574_33645 = state_33523__$1;
(statearr_33574_33645[(2)] = recompile_dependents);

(statearr_33574_33645[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (3))){
var state_33523__$1 = state_33523;
var statearr_33575_33646 = state_33523__$1;
(statearr_33575_33646[(2)] = null);

(statearr_33575_33646[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (12))){
var inst_33413 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33576_33647 = state_33523__$1;
(statearr_33576_33647[(2)] = inst_33413);

(statearr_33576_33647[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (2))){
var inst_33375 = (state_33523[(13)]);
var inst_33382 = cljs.core.seq.call(null,inst_33375);
var inst_33383 = inst_33382;
var inst_33384 = null;
var inst_33385 = (0);
var inst_33386 = (0);
var state_33523__$1 = (function (){var statearr_33577 = state_33523;
(statearr_33577[(7)] = inst_33386);

(statearr_33577[(8)] = inst_33383);

(statearr_33577[(9)] = inst_33384);

(statearr_33577[(10)] = inst_33385);

return statearr_33577;
})();
var statearr_33578_33648 = state_33523__$1;
(statearr_33578_33648[(2)] = null);

(statearr_33578_33648[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (23))){
var inst_33436 = (state_33523[(19)]);
var inst_33442 = (state_33523[(26)]);
var inst_33444 = (state_33523[(23)]);
var inst_33439 = (state_33523[(24)]);
var inst_33440 = (state_33523[(25)]);
var inst_33447 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_33449 = (function (){var all_files = inst_33436;
var res_SINGLEQUOTE_ = inst_33439;
var res = inst_33440;
var files_not_loaded = inst_33442;
var dependencies_that_loaded = inst_33444;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33440,inst_33447,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33448){
var map__33579 = p__33448;
var map__33579__$1 = ((((!((map__33579 == null)))?((((map__33579.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33579.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33579):map__33579);
var request_url = cljs.core.get.call(null,map__33579__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33440,inst_33447,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33450 = cljs.core.reverse.call(null,inst_33444);
var inst_33451 = cljs.core.map.call(null,inst_33449,inst_33450);
var inst_33452 = cljs.core.pr_str.call(null,inst_33451);
var inst_33453 = figwheel.client.utils.log.call(null,inst_33452);
var state_33523__$1 = (function (){var statearr_33581 = state_33523;
(statearr_33581[(31)] = inst_33447);

return statearr_33581;
})();
var statearr_33582_33649 = state_33523__$1;
(statearr_33582_33649[(2)] = inst_33453);

(statearr_33582_33649[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (35))){
var state_33523__$1 = state_33523;
var statearr_33583_33650 = state_33523__$1;
(statearr_33583_33650[(2)] = true);

(statearr_33583_33650[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (19))){
var inst_33426 = (state_33523[(12)]);
var inst_33432 = figwheel.client.file_reloading.expand_files.call(null,inst_33426);
var state_33523__$1 = state_33523;
var statearr_33584_33651 = state_33523__$1;
(statearr_33584_33651[(2)] = inst_33432);

(statearr_33584_33651[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (11))){
var state_33523__$1 = state_33523;
var statearr_33585_33652 = state_33523__$1;
(statearr_33585_33652[(2)] = null);

(statearr_33585_33652[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (9))){
var inst_33415 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33586_33653 = state_33523__$1;
(statearr_33586_33653[(2)] = inst_33415);

(statearr_33586_33653[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (5))){
var inst_33386 = (state_33523[(7)]);
var inst_33385 = (state_33523[(10)]);
var inst_33388 = (inst_33386 < inst_33385);
var inst_33389 = inst_33388;
var state_33523__$1 = state_33523;
if(cljs.core.truth_(inst_33389)){
var statearr_33587_33654 = state_33523__$1;
(statearr_33587_33654[(1)] = (7));

} else {
var statearr_33588_33655 = state_33523__$1;
(statearr_33588_33655[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (14))){
var inst_33396 = (state_33523[(22)]);
var inst_33405 = cljs.core.first.call(null,inst_33396);
var inst_33406 = figwheel.client.file_reloading.eval_body.call(null,inst_33405,opts);
var inst_33407 = cljs.core.next.call(null,inst_33396);
var inst_33383 = inst_33407;
var inst_33384 = null;
var inst_33385 = (0);
var inst_33386 = (0);
var state_33523__$1 = (function (){var statearr_33589 = state_33523;
(statearr_33589[(7)] = inst_33386);

(statearr_33589[(8)] = inst_33383);

(statearr_33589[(32)] = inst_33406);

(statearr_33589[(9)] = inst_33384);

(statearr_33589[(10)] = inst_33385);

return statearr_33589;
})();
var statearr_33590_33656 = state_33523__$1;
(statearr_33590_33656[(2)] = null);

(statearr_33590_33656[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (45))){
var state_33523__$1 = state_33523;
var statearr_33591_33657 = state_33523__$1;
(statearr_33591_33657[(2)] = null);

(statearr_33591_33657[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (26))){
var inst_33436 = (state_33523[(19)]);
var inst_33442 = (state_33523[(26)]);
var inst_33444 = (state_33523[(23)]);
var inst_33439 = (state_33523[(24)]);
var inst_33440 = (state_33523[(25)]);
var inst_33459 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_33461 = (function (){var all_files = inst_33436;
var res_SINGLEQUOTE_ = inst_33439;
var res = inst_33440;
var files_not_loaded = inst_33442;
var dependencies_that_loaded = inst_33444;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33440,inst_33459,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33460){
var map__33592 = p__33460;
var map__33592__$1 = ((((!((map__33592 == null)))?((((map__33592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33592.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33592):map__33592);
var namespace = cljs.core.get.call(null,map__33592__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__33592__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33440,inst_33459,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33462 = cljs.core.map.call(null,inst_33461,inst_33440);
var inst_33463 = cljs.core.pr_str.call(null,inst_33462);
var inst_33464 = figwheel.client.utils.log.call(null,inst_33463);
var inst_33465 = (function (){var all_files = inst_33436;
var res_SINGLEQUOTE_ = inst_33439;
var res = inst_33440;
var files_not_loaded = inst_33442;
var dependencies_that_loaded = inst_33444;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33440,inst_33459,inst_33461,inst_33462,inst_33463,inst_33464,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33436,inst_33442,inst_33444,inst_33439,inst_33440,inst_33459,inst_33461,inst_33462,inst_33463,inst_33464,state_val_33524,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33466 = setTimeout(inst_33465,(10));
var state_33523__$1 = (function (){var statearr_33594 = state_33523;
(statearr_33594[(33)] = inst_33459);

(statearr_33594[(34)] = inst_33464);

return statearr_33594;
})();
var statearr_33595_33658 = state_33523__$1;
(statearr_33595_33658[(2)] = inst_33466);

(statearr_33595_33658[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (16))){
var state_33523__$1 = state_33523;
var statearr_33596_33659 = state_33523__$1;
(statearr_33596_33659[(2)] = reload_dependents);

(statearr_33596_33659[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (38))){
var inst_33476 = (state_33523[(16)]);
var inst_33494 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33476);
var state_33523__$1 = state_33523;
var statearr_33597_33660 = state_33523__$1;
(statearr_33597_33660[(2)] = inst_33494);

(statearr_33597_33660[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (30))){
var state_33523__$1 = state_33523;
var statearr_33598_33661 = state_33523__$1;
(statearr_33598_33661[(2)] = null);

(statearr_33598_33661[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (10))){
var inst_33396 = (state_33523[(22)]);
var inst_33398 = cljs.core.chunked_seq_QMARK_.call(null,inst_33396);
var state_33523__$1 = state_33523;
if(inst_33398){
var statearr_33599_33662 = state_33523__$1;
(statearr_33599_33662[(1)] = (13));

} else {
var statearr_33600_33663 = state_33523__$1;
(statearr_33600_33663[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (18))){
var inst_33430 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
if(cljs.core.truth_(inst_33430)){
var statearr_33601_33664 = state_33523__$1;
(statearr_33601_33664[(1)] = (19));

} else {
var statearr_33602_33665 = state_33523__$1;
(statearr_33602_33665[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (42))){
var state_33523__$1 = state_33523;
var statearr_33603_33666 = state_33523__$1;
(statearr_33603_33666[(2)] = null);

(statearr_33603_33666[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (37))){
var inst_33489 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33604_33667 = state_33523__$1;
(statearr_33604_33667[(2)] = inst_33489);

(statearr_33604_33667[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (8))){
var inst_33396 = (state_33523[(22)]);
var inst_33383 = (state_33523[(8)]);
var inst_33396__$1 = cljs.core.seq.call(null,inst_33383);
var state_33523__$1 = (function (){var statearr_33605 = state_33523;
(statearr_33605[(22)] = inst_33396__$1);

return statearr_33605;
})();
if(inst_33396__$1){
var statearr_33606_33668 = state_33523__$1;
(statearr_33606_33668[(1)] = (10));

} else {
var statearr_33607_33669 = state_33523__$1;
(statearr_33607_33669[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30766__auto__,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto____0 = (function (){
var statearr_33608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33608[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto__);

(statearr_33608[(1)] = (1));

return statearr_33608;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto____1 = (function (state_33523){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_33523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e33609){if((e33609 instanceof Object)){
var ex__30770__auto__ = e33609;
var statearr_33610_33670 = state_33523;
(statearr_33610_33670[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33609;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33671 = state_33523;
state_33523 = G__33671;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto__ = function(state_33523){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto____1.call(this,state_33523);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30856__auto__ = (function (){var statearr_33611 = f__30855__auto__.call(null);
(statearr_33611[(6)] = c__30854__auto__);

return statearr_33611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__,map__33368,map__33368__$1,opts,before_jsload,on_jsload,reload_dependents,map__33369,map__33369__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30854__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__33674,link){
var map__33675 = p__33674;
var map__33675__$1 = ((((!((map__33675 == null)))?((((map__33675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33675.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33675):map__33675);
var file = cljs.core.get.call(null,map__33675__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__33675,map__33675__$1,file){
return (function (p1__33672_SHARP_,p2__33673_SHARP_){
if(cljs.core._EQ_.call(null,p1__33672_SHARP_,p2__33673_SHARP_)){
return p1__33672_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__33675,map__33675__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__33678){
var map__33679 = p__33678;
var map__33679__$1 = ((((!((map__33679 == null)))?((((map__33679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33679.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33679):map__33679);
var match_length = cljs.core.get.call(null,map__33679__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__33679__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__33677_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__33677_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__33681_SHARP_,p2__33682_SHARP_){
return cljs.core.assoc.call(null,p1__33681_SHARP_,cljs.core.get.call(null,p2__33682_SHARP_,key),p2__33682_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_33683 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_33683);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_33683);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__33684,p__33685){
var map__33686 = p__33684;
var map__33686__$1 = ((((!((map__33686 == null)))?((((map__33686.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33686.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33686):map__33686);
var on_cssload = cljs.core.get.call(null,map__33686__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__33687 = p__33685;
var map__33687__$1 = ((((!((map__33687 == null)))?((((map__33687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33687.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33687):map__33687);
var files_msg = map__33687__$1;
var files = cljs.core.get.call(null,map__33687__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1502375614640
