// Compiled by ClojureScript 1.9.854 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.12";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("#js "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e34786){if((e34786 instanceof Error)){
var e = e34786;
return "Error: Unable to stringify";
} else {
throw e34786;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__34789 = arguments.length;
switch (G__34789) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__34787_SHARP_){
if(typeof p1__34787_SHARP_ === 'string'){
return p1__34787_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__34787_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29124__auto__ = [];
var len__29117__auto___34792 = arguments.length;
var i__29118__auto___34793 = (0);
while(true){
if((i__29118__auto___34793 < len__29117__auto___34792)){
args__29124__auto__.push((arguments[i__29118__auto___34793]));

var G__34794 = (i__29118__auto___34793 + (1));
i__29118__auto___34793 = G__34794;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((0) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29125__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq34791){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34791));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29124__auto__ = [];
var len__29117__auto___34796 = arguments.length;
var i__29118__auto___34797 = (0);
while(true){
if((i__29118__auto___34797 < len__29117__auto___34796)){
args__29124__auto__.push((arguments[i__29118__auto___34797]));

var G__34798 = (i__29118__auto___34797 + (1));
i__29118__auto___34797 = G__34798;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((0) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29125__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq34795){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34795));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__34799){
var map__34800 = p__34799;
var map__34800__$1 = ((((!((map__34800 == null)))?((((map__34800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34800.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34800):map__34800);
var message = cljs.core.get.call(null,map__34800__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__34800__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__27953__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27953__auto__)){
return or__27953__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__27941__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__27941__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__27941__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__30854__auto___34879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___34879,ch){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___34879,ch){
return (function (state_34851){
var state_val_34852 = (state_34851[(1)]);
if((state_val_34852 === (7))){
var inst_34847 = (state_34851[(2)]);
var state_34851__$1 = state_34851;
var statearr_34853_34880 = state_34851__$1;
(statearr_34853_34880[(2)] = inst_34847);

(statearr_34853_34880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (1))){
var state_34851__$1 = state_34851;
var statearr_34854_34881 = state_34851__$1;
(statearr_34854_34881[(2)] = null);

(statearr_34854_34881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (4))){
var inst_34804 = (state_34851[(7)]);
var inst_34804__$1 = (state_34851[(2)]);
var state_34851__$1 = (function (){var statearr_34855 = state_34851;
(statearr_34855[(7)] = inst_34804__$1);

return statearr_34855;
})();
if(cljs.core.truth_(inst_34804__$1)){
var statearr_34856_34882 = state_34851__$1;
(statearr_34856_34882[(1)] = (5));

} else {
var statearr_34857_34883 = state_34851__$1;
(statearr_34857_34883[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (15))){
var inst_34811 = (state_34851[(8)]);
var inst_34826 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34811);
var inst_34827 = cljs.core.first.call(null,inst_34826);
var inst_34828 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_34827);
var inst_34829 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34828)].join('');
var inst_34830 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_34829);
var state_34851__$1 = state_34851;
var statearr_34858_34884 = state_34851__$1;
(statearr_34858_34884[(2)] = inst_34830);

(statearr_34858_34884[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (13))){
var inst_34835 = (state_34851[(2)]);
var state_34851__$1 = state_34851;
var statearr_34859_34885 = state_34851__$1;
(statearr_34859_34885[(2)] = inst_34835);

(statearr_34859_34885[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (6))){
var state_34851__$1 = state_34851;
var statearr_34860_34886 = state_34851__$1;
(statearr_34860_34886[(2)] = null);

(statearr_34860_34886[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (17))){
var inst_34833 = (state_34851[(2)]);
var state_34851__$1 = state_34851;
var statearr_34861_34887 = state_34851__$1;
(statearr_34861_34887[(2)] = inst_34833);

(statearr_34861_34887[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (3))){
var inst_34849 = (state_34851[(2)]);
var state_34851__$1 = state_34851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34851__$1,inst_34849);
} else {
if((state_val_34852 === (12))){
var inst_34810 = (state_34851[(9)]);
var inst_34824 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_34810,opts);
var state_34851__$1 = state_34851;
if(cljs.core.truth_(inst_34824)){
var statearr_34862_34888 = state_34851__$1;
(statearr_34862_34888[(1)] = (15));

} else {
var statearr_34863_34889 = state_34851__$1;
(statearr_34863_34889[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (2))){
var state_34851__$1 = state_34851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34851__$1,(4),ch);
} else {
if((state_val_34852 === (11))){
var inst_34811 = (state_34851[(8)]);
var inst_34816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34817 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_34811);
var inst_34818 = cljs.core.async.timeout.call(null,(1000));
var inst_34819 = [inst_34817,inst_34818];
var inst_34820 = (new cljs.core.PersistentVector(null,2,(5),inst_34816,inst_34819,null));
var state_34851__$1 = state_34851;
return cljs.core.async.ioc_alts_BANG_.call(null,state_34851__$1,(14),inst_34820);
} else {
if((state_val_34852 === (9))){
var inst_34811 = (state_34851[(8)]);
var inst_34837 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_34838 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34811);
var inst_34839 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34838);
var inst_34840 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34839)].join('');
var inst_34841 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_34840);
var state_34851__$1 = (function (){var statearr_34864 = state_34851;
(statearr_34864[(10)] = inst_34837);

return statearr_34864;
})();
var statearr_34865_34890 = state_34851__$1;
(statearr_34865_34890[(2)] = inst_34841);

(statearr_34865_34890[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (5))){
var inst_34804 = (state_34851[(7)]);
var inst_34806 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_34807 = (new cljs.core.PersistentArrayMap(null,2,inst_34806,null));
var inst_34808 = (new cljs.core.PersistentHashSet(null,inst_34807,null));
var inst_34809 = figwheel.client.focus_msgs.call(null,inst_34808,inst_34804);
var inst_34810 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_34809);
var inst_34811 = cljs.core.first.call(null,inst_34809);
var inst_34812 = figwheel.client.autoload_QMARK_.call(null);
var state_34851__$1 = (function (){var statearr_34866 = state_34851;
(statearr_34866[(9)] = inst_34810);

(statearr_34866[(8)] = inst_34811);

return statearr_34866;
})();
if(cljs.core.truth_(inst_34812)){
var statearr_34867_34891 = state_34851__$1;
(statearr_34867_34891[(1)] = (8));

} else {
var statearr_34868_34892 = state_34851__$1;
(statearr_34868_34892[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (14))){
var inst_34822 = (state_34851[(2)]);
var state_34851__$1 = state_34851;
var statearr_34869_34893 = state_34851__$1;
(statearr_34869_34893[(2)] = inst_34822);

(statearr_34869_34893[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (16))){
var state_34851__$1 = state_34851;
var statearr_34870_34894 = state_34851__$1;
(statearr_34870_34894[(2)] = null);

(statearr_34870_34894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (10))){
var inst_34843 = (state_34851[(2)]);
var state_34851__$1 = (function (){var statearr_34871 = state_34851;
(statearr_34871[(11)] = inst_34843);

return statearr_34871;
})();
var statearr_34872_34895 = state_34851__$1;
(statearr_34872_34895[(2)] = null);

(statearr_34872_34895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34852 === (8))){
var inst_34810 = (state_34851[(9)]);
var inst_34814 = figwheel.client.reload_file_state_QMARK_.call(null,inst_34810,opts);
var state_34851__$1 = state_34851;
if(cljs.core.truth_(inst_34814)){
var statearr_34873_34896 = state_34851__$1;
(statearr_34873_34896[(1)] = (11));

} else {
var statearr_34874_34897 = state_34851__$1;
(statearr_34874_34897[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto___34879,ch))
;
return ((function (switch__30766__auto__,c__30854__auto___34879,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__30767__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__30767__auto____0 = (function (){
var statearr_34875 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34875[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__30767__auto__);

(statearr_34875[(1)] = (1));

return statearr_34875;
});
var figwheel$client$file_reloader_plugin_$_state_machine__30767__auto____1 = (function (state_34851){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_34851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e34876){if((e34876 instanceof Object)){
var ex__30770__auto__ = e34876;
var statearr_34877_34898 = state_34851;
(statearr_34877_34898[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34851);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34876;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34899 = state_34851;
state_34851 = G__34899;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__30767__auto__ = function(state_34851){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__30767__auto____1.call(this,state_34851);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__30767__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__30767__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___34879,ch))
})();
var state__30856__auto__ = (function (){var statearr_34878 = f__30855__auto__.call(null);
(statearr_34878[(6)] = c__30854__auto___34879);

return statearr_34878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___34879,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__34900_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__34900_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_34902 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_34902){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e34901){if((e34901 instanceof Error)){
var e = e34901;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_34902], null));
} else {
var e = e34901;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_34902))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__34903){
var map__34904 = p__34903;
var map__34904__$1 = ((((!((map__34904 == null)))?((((map__34904.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34904.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34904):map__34904);
var opts = map__34904__$1;
var build_id = cljs.core.get.call(null,map__34904__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__34904,map__34904__$1,opts,build_id){
return (function (p__34906){
var vec__34907 = p__34906;
var seq__34908 = cljs.core.seq.call(null,vec__34907);
var first__34909 = cljs.core.first.call(null,seq__34908);
var seq__34908__$1 = cljs.core.next.call(null,seq__34908);
var map__34910 = first__34909;
var map__34910__$1 = ((((!((map__34910 == null)))?((((map__34910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34910.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34910):map__34910);
var msg = map__34910__$1;
var msg_name = cljs.core.get.call(null,map__34910__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__34908__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__34907,seq__34908,first__34909,seq__34908__$1,map__34910,map__34910__$1,msg,msg_name,_,map__34904,map__34904__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__34907,seq__34908,first__34909,seq__34908__$1,map__34910,map__34910__$1,msg,msg_name,_,map__34904,map__34904__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__34904,map__34904__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__34912){
var vec__34913 = p__34912;
var seq__34914 = cljs.core.seq.call(null,vec__34913);
var first__34915 = cljs.core.first.call(null,seq__34914);
var seq__34914__$1 = cljs.core.next.call(null,seq__34914);
var map__34916 = first__34915;
var map__34916__$1 = ((((!((map__34916 == null)))?((((map__34916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34916.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34916):map__34916);
var msg = map__34916__$1;
var msg_name = cljs.core.get.call(null,map__34916__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__34914__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__34918){
var map__34919 = p__34918;
var map__34919__$1 = ((((!((map__34919 == null)))?((((map__34919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34919.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34919):map__34919);
var on_compile_warning = cljs.core.get.call(null,map__34919__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__34919__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__34919,map__34919__$1,on_compile_warning,on_compile_fail){
return (function (p__34921){
var vec__34922 = p__34921;
var seq__34923 = cljs.core.seq.call(null,vec__34922);
var first__34924 = cljs.core.first.call(null,seq__34923);
var seq__34923__$1 = cljs.core.next.call(null,seq__34923);
var map__34925 = first__34924;
var map__34925__$1 = ((((!((map__34925 == null)))?((((map__34925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34925.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34925):map__34925);
var msg = map__34925__$1;
var msg_name = cljs.core.get.call(null,map__34925__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__34923__$1;
var pred__34927 = cljs.core._EQ_;
var expr__34928 = msg_name;
if(cljs.core.truth_(pred__34927.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__34928))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__34927.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__34928))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__34919,map__34919__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__,msg_hist,msg_names,msg){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__,msg_hist,msg_names,msg){
return (function (state_35017){
var state_val_35018 = (state_35017[(1)]);
if((state_val_35018 === (7))){
var inst_34937 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34937)){
var statearr_35019_35066 = state_35017__$1;
(statearr_35019_35066[(1)] = (8));

} else {
var statearr_35020_35067 = state_35017__$1;
(statearr_35020_35067[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (20))){
var inst_35011 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35021_35068 = state_35017__$1;
(statearr_35021_35068[(2)] = inst_35011);

(statearr_35021_35068[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (27))){
var inst_35007 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35022_35069 = state_35017__$1;
(statearr_35022_35069[(2)] = inst_35007);

(statearr_35022_35069[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (1))){
var inst_34930 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34930)){
var statearr_35023_35070 = state_35017__$1;
(statearr_35023_35070[(1)] = (2));

} else {
var statearr_35024_35071 = state_35017__$1;
(statearr_35024_35071[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (24))){
var inst_35009 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35025_35072 = state_35017__$1;
(statearr_35025_35072[(2)] = inst_35009);

(statearr_35025_35072[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (4))){
var inst_35015 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35017__$1,inst_35015);
} else {
if((state_val_35018 === (15))){
var inst_35013 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35026_35073 = state_35017__$1;
(statearr_35026_35073[(2)] = inst_35013);

(statearr_35026_35073[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (21))){
var inst_34966 = (state_35017[(2)]);
var inst_34967 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34968 = figwheel.client.auto_jump_to_error.call(null,opts,inst_34967);
var state_35017__$1 = (function (){var statearr_35027 = state_35017;
(statearr_35027[(7)] = inst_34966);

return statearr_35027;
})();
var statearr_35028_35074 = state_35017__$1;
(statearr_35028_35074[(2)] = inst_34968);

(statearr_35028_35074[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (31))){
var inst_34996 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34996)){
var statearr_35029_35075 = state_35017__$1;
(statearr_35029_35075[(1)] = (34));

} else {
var statearr_35030_35076 = state_35017__$1;
(statearr_35030_35076[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (32))){
var inst_35005 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35031_35077 = state_35017__$1;
(statearr_35031_35077[(2)] = inst_35005);

(statearr_35031_35077[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (33))){
var inst_34992 = (state_35017[(2)]);
var inst_34993 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34994 = figwheel.client.auto_jump_to_error.call(null,opts,inst_34993);
var state_35017__$1 = (function (){var statearr_35032 = state_35017;
(statearr_35032[(8)] = inst_34992);

return statearr_35032;
})();
var statearr_35033_35078 = state_35017__$1;
(statearr_35033_35078[(2)] = inst_34994);

(statearr_35033_35078[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (13))){
var inst_34951 = figwheel.client.heads_up.clear.call(null);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(16),inst_34951);
} else {
if((state_val_35018 === (22))){
var inst_34972 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34973 = figwheel.client.heads_up.append_warning_message.call(null,inst_34972);
var state_35017__$1 = state_35017;
var statearr_35034_35079 = state_35017__$1;
(statearr_35034_35079[(2)] = inst_34973);

(statearr_35034_35079[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (36))){
var inst_35003 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35035_35080 = state_35017__$1;
(statearr_35035_35080[(2)] = inst_35003);

(statearr_35035_35080[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (29))){
var inst_34983 = (state_35017[(2)]);
var inst_34984 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34985 = figwheel.client.auto_jump_to_error.call(null,opts,inst_34984);
var state_35017__$1 = (function (){var statearr_35036 = state_35017;
(statearr_35036[(9)] = inst_34983);

return statearr_35036;
})();
var statearr_35037_35081 = state_35017__$1;
(statearr_35037_35081[(2)] = inst_34985);

(statearr_35037_35081[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (6))){
var inst_34932 = (state_35017[(10)]);
var state_35017__$1 = state_35017;
var statearr_35038_35082 = state_35017__$1;
(statearr_35038_35082[(2)] = inst_34932);

(statearr_35038_35082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (28))){
var inst_34979 = (state_35017[(2)]);
var inst_34980 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34981 = figwheel.client.heads_up.display_warning.call(null,inst_34980);
var state_35017__$1 = (function (){var statearr_35039 = state_35017;
(statearr_35039[(11)] = inst_34979);

return statearr_35039;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(29),inst_34981);
} else {
if((state_val_35018 === (25))){
var inst_34977 = figwheel.client.heads_up.clear.call(null);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(28),inst_34977);
} else {
if((state_val_35018 === (34))){
var inst_34998 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(37),inst_34998);
} else {
if((state_val_35018 === (17))){
var inst_34957 = (state_35017[(2)]);
var inst_34958 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34959 = figwheel.client.auto_jump_to_error.call(null,opts,inst_34958);
var state_35017__$1 = (function (){var statearr_35040 = state_35017;
(statearr_35040[(12)] = inst_34957);

return statearr_35040;
})();
var statearr_35041_35083 = state_35017__$1;
(statearr_35041_35083[(2)] = inst_34959);

(statearr_35041_35083[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (3))){
var inst_34949 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34949)){
var statearr_35042_35084 = state_35017__$1;
(statearr_35042_35084[(1)] = (13));

} else {
var statearr_35043_35085 = state_35017__$1;
(statearr_35043_35085[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (12))){
var inst_34945 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35044_35086 = state_35017__$1;
(statearr_35044_35086[(2)] = inst_34945);

(statearr_35044_35086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (2))){
var inst_34932 = (state_35017[(10)]);
var inst_34932__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_35017__$1 = (function (){var statearr_35045 = state_35017;
(statearr_35045[(10)] = inst_34932__$1);

return statearr_35045;
})();
if(cljs.core.truth_(inst_34932__$1)){
var statearr_35046_35087 = state_35017__$1;
(statearr_35046_35087[(1)] = (5));

} else {
var statearr_35047_35088 = state_35017__$1;
(statearr_35047_35088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (23))){
var inst_34975 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34975)){
var statearr_35048_35089 = state_35017__$1;
(statearr_35048_35089[(1)] = (25));

} else {
var statearr_35049_35090 = state_35017__$1;
(statearr_35049_35090[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (35))){
var state_35017__$1 = state_35017;
var statearr_35050_35091 = state_35017__$1;
(statearr_35050_35091[(2)] = null);

(statearr_35050_35091[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (19))){
var inst_34970 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34970)){
var statearr_35051_35092 = state_35017__$1;
(statearr_35051_35092[(1)] = (22));

} else {
var statearr_35052_35093 = state_35017__$1;
(statearr_35052_35093[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (11))){
var inst_34941 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35053_35094 = state_35017__$1;
(statearr_35053_35094[(2)] = inst_34941);

(statearr_35053_35094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (9))){
var inst_34943 = figwheel.client.heads_up.clear.call(null);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(12),inst_34943);
} else {
if((state_val_35018 === (5))){
var inst_34934 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_35017__$1 = state_35017;
var statearr_35054_35095 = state_35017__$1;
(statearr_35054_35095[(2)] = inst_34934);

(statearr_35054_35095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (14))){
var inst_34961 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34961)){
var statearr_35055_35096 = state_35017__$1;
(statearr_35055_35096[(1)] = (18));

} else {
var statearr_35056_35097 = state_35017__$1;
(statearr_35056_35097[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (26))){
var inst_34987 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_35017__$1 = state_35017;
if(cljs.core.truth_(inst_34987)){
var statearr_35057_35098 = state_35017__$1;
(statearr_35057_35098[(1)] = (30));

} else {
var statearr_35058_35099 = state_35017__$1;
(statearr_35058_35099[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (16))){
var inst_34953 = (state_35017[(2)]);
var inst_34954 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34955 = figwheel.client.heads_up.display_exception.call(null,inst_34954);
var state_35017__$1 = (function (){var statearr_35059 = state_35017;
(statearr_35059[(13)] = inst_34953);

return statearr_35059;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(17),inst_34955);
} else {
if((state_val_35018 === (30))){
var inst_34989 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34990 = figwheel.client.heads_up.display_warning.call(null,inst_34989);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(33),inst_34990);
} else {
if((state_val_35018 === (10))){
var inst_34947 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35060_35100 = state_35017__$1;
(statearr_35060_35100[(2)] = inst_34947);

(statearr_35060_35100[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (18))){
var inst_34963 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34964 = figwheel.client.heads_up.display_exception.call(null,inst_34963);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(21),inst_34964);
} else {
if((state_val_35018 === (37))){
var inst_35000 = (state_35017[(2)]);
var state_35017__$1 = state_35017;
var statearr_35061_35101 = state_35017__$1;
(statearr_35061_35101[(2)] = inst_35000);

(statearr_35061_35101[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35018 === (8))){
var inst_34939 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35017__$1 = state_35017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35017__$1,(11),inst_34939);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30854__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__30766__auto__,c__30854__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto____0 = (function (){
var statearr_35062 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35062[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto__);

(statearr_35062[(1)] = (1));

return statearr_35062;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto____1 = (function (state_35017){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_35017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e35063){if((e35063 instanceof Object)){
var ex__30770__auto__ = e35063;
var statearr_35064_35102 = state_35017;
(statearr_35064_35102[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35063;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35103 = state_35017;
state_35017 = G__35103;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto__ = function(state_35017){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto____1.call(this,state_35017);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__,msg_hist,msg_names,msg))
})();
var state__30856__auto__ = (function (){var statearr_35065 = f__30855__auto__.call(null);
(statearr_35065[(6)] = c__30854__auto__);

return statearr_35065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__,msg_hist,msg_names,msg))
);

return c__30854__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__30854__auto___35132 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto___35132,ch){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto___35132,ch){
return (function (state_35118){
var state_val_35119 = (state_35118[(1)]);
if((state_val_35119 === (1))){
var state_35118__$1 = state_35118;
var statearr_35120_35133 = state_35118__$1;
(statearr_35120_35133[(2)] = null);

(statearr_35120_35133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35119 === (2))){
var state_35118__$1 = state_35118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35118__$1,(4),ch);
} else {
if((state_val_35119 === (3))){
var inst_35116 = (state_35118[(2)]);
var state_35118__$1 = state_35118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35118__$1,inst_35116);
} else {
if((state_val_35119 === (4))){
var inst_35106 = (state_35118[(7)]);
var inst_35106__$1 = (state_35118[(2)]);
var state_35118__$1 = (function (){var statearr_35121 = state_35118;
(statearr_35121[(7)] = inst_35106__$1);

return statearr_35121;
})();
if(cljs.core.truth_(inst_35106__$1)){
var statearr_35122_35134 = state_35118__$1;
(statearr_35122_35134[(1)] = (5));

} else {
var statearr_35123_35135 = state_35118__$1;
(statearr_35123_35135[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35119 === (5))){
var inst_35106 = (state_35118[(7)]);
var inst_35108 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_35106);
var state_35118__$1 = state_35118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35118__$1,(8),inst_35108);
} else {
if((state_val_35119 === (6))){
var state_35118__$1 = state_35118;
var statearr_35124_35136 = state_35118__$1;
(statearr_35124_35136[(2)] = null);

(statearr_35124_35136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35119 === (7))){
var inst_35114 = (state_35118[(2)]);
var state_35118__$1 = state_35118;
var statearr_35125_35137 = state_35118__$1;
(statearr_35125_35137[(2)] = inst_35114);

(statearr_35125_35137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35119 === (8))){
var inst_35110 = (state_35118[(2)]);
var state_35118__$1 = (function (){var statearr_35126 = state_35118;
(statearr_35126[(8)] = inst_35110);

return statearr_35126;
})();
var statearr_35127_35138 = state_35118__$1;
(statearr_35127_35138[(2)] = null);

(statearr_35127_35138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__30854__auto___35132,ch))
;
return ((function (switch__30766__auto__,c__30854__auto___35132,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__30767__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__30767__auto____0 = (function (){
var statearr_35128 = [null,null,null,null,null,null,null,null,null];
(statearr_35128[(0)] = figwheel$client$heads_up_plugin_$_state_machine__30767__auto__);

(statearr_35128[(1)] = (1));

return statearr_35128;
});
var figwheel$client$heads_up_plugin_$_state_machine__30767__auto____1 = (function (state_35118){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_35118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e35129){if((e35129 instanceof Object)){
var ex__30770__auto__ = e35129;
var statearr_35130_35139 = state_35118;
(statearr_35130_35139[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35129;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35140 = state_35118;
state_35118 = G__35140;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__30767__auto__ = function(state_35118){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__30767__auto____1.call(this,state_35118);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__30767__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__30767__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto___35132,ch))
})();
var state__30856__auto__ = (function (){var statearr_35131 = f__30855__auto__.call(null);
(statearr_35131[(6)] = c__30854__auto___35132);

return statearr_35131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto___35132,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__){
return (function (state_35146){
var state_val_35147 = (state_35146[(1)]);
if((state_val_35147 === (1))){
var inst_35141 = cljs.core.async.timeout.call(null,(3000));
var state_35146__$1 = state_35146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35146__$1,(2),inst_35141);
} else {
if((state_val_35147 === (2))){
var inst_35143 = (state_35146[(2)]);
var inst_35144 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_35146__$1 = (function (){var statearr_35148 = state_35146;
(statearr_35148[(7)] = inst_35143);

return statearr_35148;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35146__$1,inst_35144);
} else {
return null;
}
}
});})(c__30854__auto__))
;
return ((function (switch__30766__auto__,c__30854__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__30767__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__30767__auto____0 = (function (){
var statearr_35149 = [null,null,null,null,null,null,null,null];
(statearr_35149[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__30767__auto__);

(statearr_35149[(1)] = (1));

return statearr_35149;
});
var figwheel$client$enforce_project_plugin_$_state_machine__30767__auto____1 = (function (state_35146){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_35146);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e35150){if((e35150 instanceof Object)){
var ex__30770__auto__ = e35150;
var statearr_35151_35153 = state_35146;
(statearr_35151_35153[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35146);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35154 = state_35146;
state_35146 = G__35154;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__30767__auto__ = function(state_35146){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__30767__auto____1.call(this,state_35146);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__30767__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__30767__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__))
})();
var state__30856__auto__ = (function (){var statearr_35152 = f__30855__auto__.call(null);
(statearr_35152[(6)] = c__30854__auto__);

return statearr_35152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__))
);

return c__30854__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30854__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__30855__auto__ = (function (){var switch__30766__auto__ = ((function (c__30854__auto__,figwheel_version,temp__4657__auto__){
return (function (state_35161){
var state_val_35162 = (state_35161[(1)]);
if((state_val_35162 === (1))){
var inst_35155 = cljs.core.async.timeout.call(null,(2000));
var state_35161__$1 = state_35161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35161__$1,(2),inst_35155);
} else {
if((state_val_35162 === (2))){
var inst_35157 = (state_35161[(2)]);
var inst_35158 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_35159 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_35158);
var state_35161__$1 = (function (){var statearr_35163 = state_35161;
(statearr_35163[(7)] = inst_35157);

return statearr_35163;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35161__$1,inst_35159);
} else {
return null;
}
}
});})(c__30854__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__30766__auto__,c__30854__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto____0 = (function (){
var statearr_35164 = [null,null,null,null,null,null,null,null];
(statearr_35164[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto__);

(statearr_35164[(1)] = (1));

return statearr_35164;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto____1 = (function (state_35161){
while(true){
var ret_value__30768__auto__ = (function (){try{while(true){
var result__30769__auto__ = switch__30766__auto__.call(null,state_35161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30769__auto__;
}
break;
}
}catch (e35165){if((e35165 instanceof Object)){
var ex__30770__auto__ = e35165;
var statearr_35166_35168 = state_35161;
(statearr_35166_35168[(5)] = ex__30770__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35161);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30768__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35169 = state_35161;
state_35161 = G__35169;
continue;
} else {
return ret_value__30768__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto__ = function(state_35161){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto____1.call(this,state_35161);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30767__auto__;
})()
;})(switch__30766__auto__,c__30854__auto__,figwheel_version,temp__4657__auto__))
})();
var state__30856__auto__ = (function (){var statearr_35167 = f__30855__auto__.call(null);
(statearr_35167[(6)] = c__30854__auto__);

return statearr_35167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30856__auto__);
});})(c__30854__auto__,figwheel_version,temp__4657__auto__))
);

return c__30854__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__35170){
var map__35171 = p__35170;
var map__35171__$1 = ((((!((map__35171 == null)))?((((map__35171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35171.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35171):map__35171);
var file = cljs.core.get.call(null,map__35171__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__35171__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__35171__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__35173 = "";
var G__35173__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35173),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__35173);
var G__35173__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35173__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__35173__$1);
if(cljs.core.truth_((function (){var and__27941__auto__ = line;
if(cljs.core.truth_(and__27941__auto__)){
return column;
} else {
return and__27941__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35173__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__35173__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__35174){
var map__35175 = p__35174;
var map__35175__$1 = ((((!((map__35175 == null)))?((((map__35175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35175):map__35175);
var ed = map__35175__$1;
var formatted_exception = cljs.core.get.call(null,map__35175__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__35175__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__35175__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__35177_35181 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__35178_35182 = null;
var count__35179_35183 = (0);
var i__35180_35184 = (0);
while(true){
if((i__35180_35184 < count__35179_35183)){
var msg_35185 = cljs.core._nth.call(null,chunk__35178_35182,i__35180_35184);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_35185);

var G__35186 = seq__35177_35181;
var G__35187 = chunk__35178_35182;
var G__35188 = count__35179_35183;
var G__35189 = (i__35180_35184 + (1));
seq__35177_35181 = G__35186;
chunk__35178_35182 = G__35187;
count__35179_35183 = G__35188;
i__35180_35184 = G__35189;
continue;
} else {
var temp__4657__auto___35190 = cljs.core.seq.call(null,seq__35177_35181);
if(temp__4657__auto___35190){
var seq__35177_35191__$1 = temp__4657__auto___35190;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35177_35191__$1)){
var c__28787__auto___35192 = cljs.core.chunk_first.call(null,seq__35177_35191__$1);
var G__35193 = cljs.core.chunk_rest.call(null,seq__35177_35191__$1);
var G__35194 = c__28787__auto___35192;
var G__35195 = cljs.core.count.call(null,c__28787__auto___35192);
var G__35196 = (0);
seq__35177_35181 = G__35193;
chunk__35178_35182 = G__35194;
count__35179_35183 = G__35195;
i__35180_35184 = G__35196;
continue;
} else {
var msg_35197 = cljs.core.first.call(null,seq__35177_35191__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_35197);

var G__35198 = cljs.core.next.call(null,seq__35177_35191__$1);
var G__35199 = null;
var G__35200 = (0);
var G__35201 = (0);
seq__35177_35181 = G__35198;
chunk__35178_35182 = G__35199;
count__35179_35183 = G__35200;
i__35180_35184 = G__35201;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__35202){
var map__35203 = p__35202;
var map__35203__$1 = ((((!((map__35203 == null)))?((((map__35203.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35203.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35203):map__35203);
var w = map__35203__$1;
var message = cljs.core.get.call(null,map__35203__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__27941__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__27941__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__27941__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__35205 = cljs.core.seq.call(null,plugins);
var chunk__35206 = null;
var count__35207 = (0);
var i__35208 = (0);
while(true){
if((i__35208 < count__35207)){
var vec__35209 = cljs.core._nth.call(null,chunk__35206,i__35208);
var k = cljs.core.nth.call(null,vec__35209,(0),null);
var plugin = cljs.core.nth.call(null,vec__35209,(1),null);
if(cljs.core.truth_(plugin)){
var pl_35215 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__35205,chunk__35206,count__35207,i__35208,pl_35215,vec__35209,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_35215.call(null,msg_hist);
});})(seq__35205,chunk__35206,count__35207,i__35208,pl_35215,vec__35209,k,plugin))
);
} else {
}

var G__35216 = seq__35205;
var G__35217 = chunk__35206;
var G__35218 = count__35207;
var G__35219 = (i__35208 + (1));
seq__35205 = G__35216;
chunk__35206 = G__35217;
count__35207 = G__35218;
i__35208 = G__35219;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35205);
if(temp__4657__auto__){
var seq__35205__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35205__$1)){
var c__28787__auto__ = cljs.core.chunk_first.call(null,seq__35205__$1);
var G__35220 = cljs.core.chunk_rest.call(null,seq__35205__$1);
var G__35221 = c__28787__auto__;
var G__35222 = cljs.core.count.call(null,c__28787__auto__);
var G__35223 = (0);
seq__35205 = G__35220;
chunk__35206 = G__35221;
count__35207 = G__35222;
i__35208 = G__35223;
continue;
} else {
var vec__35212 = cljs.core.first.call(null,seq__35205__$1);
var k = cljs.core.nth.call(null,vec__35212,(0),null);
var plugin = cljs.core.nth.call(null,vec__35212,(1),null);
if(cljs.core.truth_(plugin)){
var pl_35224 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__35205,chunk__35206,count__35207,i__35208,pl_35224,vec__35212,k,plugin,seq__35205__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_35224.call(null,msg_hist);
});})(seq__35205,chunk__35206,count__35207,i__35208,pl_35224,vec__35212,k,plugin,seq__35205__$1,temp__4657__auto__))
);
} else {
}

var G__35225 = cljs.core.next.call(null,seq__35205__$1);
var G__35226 = null;
var G__35227 = (0);
var G__35228 = (0);
seq__35205 = G__35225;
chunk__35206 = G__35226;
count__35207 = G__35227;
i__35208 = G__35228;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__35230 = arguments.length;
switch (G__35230) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__35231_35236 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__35232_35237 = null;
var count__35233_35238 = (0);
var i__35234_35239 = (0);
while(true){
if((i__35234_35239 < count__35233_35238)){
var msg_35240 = cljs.core._nth.call(null,chunk__35232_35237,i__35234_35239);
figwheel.client.socket.handle_incoming_message.call(null,msg_35240);

var G__35241 = seq__35231_35236;
var G__35242 = chunk__35232_35237;
var G__35243 = count__35233_35238;
var G__35244 = (i__35234_35239 + (1));
seq__35231_35236 = G__35241;
chunk__35232_35237 = G__35242;
count__35233_35238 = G__35243;
i__35234_35239 = G__35244;
continue;
} else {
var temp__4657__auto___35245 = cljs.core.seq.call(null,seq__35231_35236);
if(temp__4657__auto___35245){
var seq__35231_35246__$1 = temp__4657__auto___35245;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35231_35246__$1)){
var c__28787__auto___35247 = cljs.core.chunk_first.call(null,seq__35231_35246__$1);
var G__35248 = cljs.core.chunk_rest.call(null,seq__35231_35246__$1);
var G__35249 = c__28787__auto___35247;
var G__35250 = cljs.core.count.call(null,c__28787__auto___35247);
var G__35251 = (0);
seq__35231_35236 = G__35248;
chunk__35232_35237 = G__35249;
count__35233_35238 = G__35250;
i__35234_35239 = G__35251;
continue;
} else {
var msg_35252 = cljs.core.first.call(null,seq__35231_35246__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_35252);

var G__35253 = cljs.core.next.call(null,seq__35231_35246__$1);
var G__35254 = null;
var G__35255 = (0);
var G__35256 = (0);
seq__35231_35236 = G__35253;
chunk__35232_35237 = G__35254;
count__35233_35238 = G__35255;
i__35234_35239 = G__35256;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29124__auto__ = [];
var len__29117__auto___35261 = arguments.length;
var i__29118__auto___35262 = (0);
while(true){
if((i__29118__auto___35262 < len__29117__auto___35261)){
args__29124__auto__.push((arguments[i__29118__auto___35262]));

var G__35263 = (i__29118__auto___35262 + (1));
i__29118__auto___35262 = G__35263;
continue;
} else {
}
break;
}

var argseq__29125__auto__ = ((((0) < args__29124__auto__.length))?(new cljs.core.IndexedSeq(args__29124__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29125__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__35258){
var map__35259 = p__35258;
var map__35259__$1 = ((((!((map__35259 == null)))?((((map__35259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35259.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35259):map__35259);
var opts = map__35259__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq35257){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35257));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e35264){if((e35264 instanceof Error)){
var e = e35264;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e35264;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__35265){
var map__35266 = p__35265;
var map__35266__$1 = ((((!((map__35266 == null)))?((((map__35266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35266.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35266):map__35266);
var msg_name = cljs.core.get.call(null,map__35266__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1502375616593
