/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.Category;
import auction.model.Item;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Parent;

@Embeddable
public class CategorizedItemComponent
implements Serializable,
Comparable {
    @Column(name="ADDED_BY_USER", nullable=false, updatable=false, length=16)
    private String username;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ADDED_ON", nullable=false, updatable=false)
    private Date dateAdded = new Date();
    @ManyToOne
    @JoinColumn(name="ITEM_ID", nullable=false, updatable=false)
    @ForeignKey(name="FK_CATEGORIZED_ITEM_COMPONENT_ITEM_ID")
    private Item item;
    @Parent
    private Category category;

    CategorizedItemComponent() {
    }

    public CategorizedItemComponent(String string, Category category, Item item) {
        this.username = string;
        this.category = category;
        this.item = item;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public Item getItem() {
        return this.item;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CategorizedItemComponent categorizedItemComponent = (CategorizedItemComponent)object;
        if (!this.category.equals(categorizedItemComponent.category)) {
            return false;
        }
        if (!this.dateAdded.equals(categorizedItemComponent.dateAdded)) {
            return false;
        }
        if (!this.item.equals(categorizedItemComponent.item)) {
            return false;
        }
        return this.username.equals(categorizedItemComponent.username);
    }

    public int hashCode() {
        int n = this.username.hashCode();
        n = 29 * n + this.dateAdded.hashCode();
        n = 29 * n + this.item.hashCode();
        n = 29 * n + this.category.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        if (object instanceof CategorizedItemComponent) {
            return this.getDateAdded().compareTo(((CategorizedItemComponent)object).getDateAdded());
        }
        return 0;
    }

    public String toString() {
        return "Added by: '" + this.getUsername() + "', " + "On Date: '" + this.getDateAdded();
    }
}

