/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.CategorizedItem;
import auction.model.CategorizedItemComponent;
import auction.model.Item;
import auction.model.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.MapKeyManyToMany;
import org.hibernate.annotations.OrderBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="CATEGORY", uniqueConstraints={@UniqueConstraint(columnNames={"CATEGORY_NAME", "PARENT_CATEGORY_ID"})})
public class Category
implements Serializable,
Comparable {
    @Id
    @GeneratedValue
    @Column(name="CATEGORY_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @Column(name="CATEGORY_NAME", length=255, nullable=false)
    private String name;
    @OneToMany(mappedBy="parentCategory", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderBy(clause="CATEGORY_NAME asc")
    private List<Category> childCategories = new ArrayList<Category>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_CATEGORY_ID", nullable=true)
    @ForeignKey(name="FK_CATEGORY_PARENT_ID")
    private Category parentCategory;
    @ManyToMany
    @JoinTable(name="CATEGORY_ITEM", joinColumns={@JoinColumn(name="CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="ITEM_ID")})
    @IndexColumn(name="DISPLAY_POSITION")
    @ForeignKey(name="FK_CATEGORY_ITEM_CATEGORY_ID", inverseName="FK_CATEGORY_ITEM_ITEM_ID")
    @Filter(name="limitItemsByUserRank", condition=":currentUserRank >= (select u.RANK from USERS u where u.USER_ID = SELLER_ID)")
    private List<Item> items = new ArrayList<Item>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="category")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<CategorizedItem> categorizedItems = new HashSet<CategorizedItem>();
    @CollectionOfElements
    @JoinTable(name="CATEGORIZED_ITEM_COMPONENTS", joinColumns={@JoinColumn(name="CATEGORY_ID")})
    @ForeignKey(name="FK_CATEGORIZED_ITEM_COMPONENT_CATEGORY_ID")
    private Set<CategorizedItemComponent> categorizedItemComponents = new HashSet<CategorizedItemComponent>();
    @ManyToMany
    @MapKeyManyToMany(joinColumns={@JoinColumn(name="ITEM_ID")})
    @JoinTable(name="CATEGORY_ITEMS_BY_USER", joinColumns={@JoinColumn(name="CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID")})
    @ForeignKey(name="FK_CATEGORY_ITEMS_BY_USER_CATEGORY_ID", inverseName="FK_CATEGORY_ITEMS_BY_USER_USER_ID")
    private Map<Item, User> itemsAndUser = new HashMap<Item, User>();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();

    public Category() {
    }

    public Category(String string, List<Category> list, Category category, List<Item> list2, Set<CategorizedItem> set, Set<CategorizedItemComponent> set2, Map<Item, User> map) {
        this.name = string;
        this.childCategories = list;
        this.parentCategory = category;
        this.items = list2;
        this.categorizedItems = set;
        this.categorizedItemComponents = set2;
        this.itemsAndUser = map;
    }

    public Category(String string) {
        this.name = string;
    }

    public Category(String string, Category category) {
        this.name = string;
        this.parentCategory = category;
    }

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<Category> getChildCategories() {
        return this.childCategories;
    }

    public void addChildCategory(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Null child category!");
        }
        if (category.getParentCategory() != null) {
            category.getParentCategory().getChildCategories().remove(category);
        }
        category.setParentCategory(this.parentCategory);
        this.childCategories.add(category);
    }

    public void removeChildCategory(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Null child category!");
        }
        category.setParentCategory(null);
        this.childCategories.remove(category);
    }

    public Category getParentCategory() {
        return this.parentCategory;
    }

    private void setParentCategory(Category category) {
        this.parentCategory = category;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void addItem(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Null item!");
        }
        this.items.add(item);
        item.getCategories().add(this);
    }

    public void removeItem(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Null item!");
        }
        this.items.remove(item);
        item.getCategories().remove(this);
    }

    public Set<CategorizedItem> getCategorizedItems() {
        return this.categorizedItems;
    }

    public Set<CategorizedItemComponent> getCategorizedItemComponents() {
        return this.categorizedItemComponents;
    }

    public Map<Item, User> getItemsAndUser() {
        return this.itemsAndUser;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Category category = (Category)object;
        if (!this.created.equals(category.created)) {
            return false;
        }
        if (!this.name.equals(category.name)) {
            return false;
        }
        return !(this.parentCategory == null ? category.parentCategory != null : !this.parentCategory.equals(category.parentCategory));
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 29 * n + (this.parentCategory != null ? this.parentCategory.hashCode() : 0);
        n = 29 * n + this.created.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        if (object instanceof Category) {
            return this.getName().compareTo(((Category)object).getName());
        }
        return 0;
    }

    public String toString() {
        return "(" + this.getId() + ") Name: '" + this.getName();
    }
}

